/* RecordCollection.c generated by valac 0.40.8.18-c87af, the Vala compiler
 * generated from RecordCollection.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * libgdadata
 * Copyright (C) Daniel Espinosa Ortiz 2011 <esodan@gmail.com>
 * 
 * libgda is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * libgda is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include <glib.h>
#include <glib-object.h>
#include <gee.h>
#include <libgda/libgda.h>
#include <stdlib.h>
#include <string.h>


#define GDA_DATA_TYPE_DB_RECORD_COLLECTION (gda_data_db_record_collection_get_type ())
#define GDA_DATA_DB_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD_COLLECTION, GdaDataDbRecordCollection))
#define GDA_DATA_IS_DB_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD_COLLECTION))
#define GDA_DATA_DB_RECORD_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD_COLLECTION, GdaDataDbRecordCollectionIface))

typedef struct _GdaDataDbRecordCollection GdaDataDbRecordCollection;
typedef struct _GdaDataDbRecordCollectionIface GdaDataDbRecordCollectionIface;

#define GDA_DATA_TYPE_DB_OBJECT (gda_data_db_object_get_type ())
#define GDA_DATA_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObject))
#define GDA_DATA_IS_DB_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_OBJECT))
#define GDA_DATA_DB_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_OBJECT, GdaDataDbObjectIface))

typedef struct _GdaDataDbObject GdaDataDbObject;
typedef struct _GdaDataDbObjectIface GdaDataDbObjectIface;

#define GDA_DATA_TYPE_DB_NAMED_OBJECT (gda_data_db_named_object_get_type ())
#define GDA_DATA_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObject))
#define GDA_DATA_IS_DB_NAMED_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT))
#define GDA_DATA_DB_NAMED_OBJECT_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_NAMED_OBJECT, GdaDataDbNamedObjectIface))

typedef struct _GdaDataDbNamedObject GdaDataDbNamedObject;
typedef struct _GdaDataDbNamedObjectIface GdaDataDbNamedObjectIface;

#define GDA_DATA_TYPE_DB_TABLE (gda_data_db_table_get_type ())
#define GDA_DATA_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTable))
#define GDA_DATA_IS_DB_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_TABLE))
#define GDA_DATA_DB_TABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_TABLE, GdaDataDbTableIface))

typedef struct _GdaDataDbTable GdaDataDbTable;
typedef struct _GdaDataDbTableIface GdaDataDbTableIface;

#define GDA_DATA_TYPE_DB_FIELD_INFO (gda_data_db_field_info_get_type ())
#define GDA_DATA_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfo))
#define GDA_DATA_IS_DB_FIELD_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO))
#define GDA_DATA_DB_FIELD_INFO_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD_INFO, GdaDataDbFieldInfoIface))

typedef struct _GdaDataDbFieldInfo GdaDataDbFieldInfo;
typedef struct _GdaDataDbFieldInfoIface GdaDataDbFieldInfoIface;

#define GDA_DATA_DB_FIELD_INFO_TYPE_ATTRIBUTE (gda_data_db_field_info_attribute_get_type ())

#define GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY (gda_data_db_field_info_foreign_key_get_type ())
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKey))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_IS_FOREIGN_KEY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY))
#define GDA_DATA_DB_FIELD_INFO_FOREIGN_KEY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_DB_FIELD_INFO_TYPE_FOREIGN_KEY, GdaDataDbFieldInfoForeignKeyClass))

typedef struct _GdaDataDbFieldInfoForeignKey GdaDataDbFieldInfoForeignKey;
typedef struct _GdaDataDbFieldInfoForeignKeyClass GdaDataDbFieldInfoForeignKeyClass;

#define GDA_DATA_TYPE_DB_CATALOG (gda_data_db_catalog_get_type ())
#define GDA_DATA_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalog))
#define GDA_DATA_IS_DB_CATALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_CATALOG))
#define GDA_DATA_DB_CATALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_CATALOG, GdaDataDbCatalogIface))

typedef struct _GdaDataDbCatalog GdaDataDbCatalog;
typedef struct _GdaDataDbCatalogIface GdaDataDbCatalogIface;

#define GDA_DATA_TYPE_DB_SCHEMA (gda_data_db_schema_get_type ())
#define GDA_DATA_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchema))
#define GDA_DATA_IS_DB_SCHEMA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_SCHEMA))
#define GDA_DATA_DB_SCHEMA_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_SCHEMA, GdaDataDbSchemaIface))

typedef struct _GdaDataDbSchema GdaDataDbSchema;
typedef struct _GdaDataDbSchemaIface GdaDataDbSchemaIface;

#define GDA_DATA_DB_TABLE_TYPE_TABLE_TYPE (gda_data_db_table_table_type_get_type ())

#define GDA_DATA_TYPE_DB_RECORD (gda_data_db_record_get_type ())
#define GDA_DATA_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecord))
#define GDA_DATA_IS_DB_RECORD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_RECORD))
#define GDA_DATA_DB_RECORD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_RECORD, GdaDataDbRecordIface))

typedef struct _GdaDataDbRecord GdaDataDbRecord;
typedef struct _GdaDataDbRecordIface GdaDataDbRecordIface;

#define GDA_DATA_TYPE_DB_FIELD (gda_data_db_field_get_type ())
#define GDA_DATA_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbField))
#define GDA_DATA_IS_DB_FIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_DB_FIELD))
#define GDA_DATA_DB_FIELD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GDA_DATA_TYPE_DB_FIELD, GdaDataDbFieldIface))

typedef struct _GdaDataDbField GdaDataDbField;
typedef struct _GdaDataDbFieldIface GdaDataDbFieldIface;

#define GDA_DATA_DB_FIELD_TYPE_ATTRIBUTE (gda_data_db_field_attribute_get_type ())

#define GDA_DATA_TYPE_RECORD_COLLECTION (gda_data_record_collection_get_type ())
#define GDA_DATA_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollection))
#define GDA_DATA_RECORD_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollectionClass))
#define GDA_DATA_IS_RECORD_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_RECORD_COLLECTION))
#define GDA_DATA_IS_RECORD_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_RECORD_COLLECTION))
#define GDA_DATA_RECORD_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollectionClass))

typedef struct _GdaDataRecordCollection GdaDataRecordCollection;
typedef struct _GdaDataRecordCollectionClass GdaDataRecordCollectionClass;
typedef struct _GdaDataRecordCollectionPrivate GdaDataRecordCollectionPrivate;
enum  {
	GDA_DATA_RECORD_COLLECTION_0_PROPERTY,
	GDA_DATA_RECORD_COLLECTION_TABLE_PROPERTY,
	GDA_DATA_RECORD_COLLECTION_MODEL_PROPERTY,
	GDA_DATA_RECORD_COLLECTION_CONNECTION_PROPERTY,
	GDA_DATA_RECORD_COLLECTION_READ_ONLY_PROPERTY,
	GDA_DATA_RECORD_COLLECTION_SIZE_PROPERTY,
	GDA_DATA_RECORD_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define GDA_DATA_TYPE_RECORD_COLLECTION_ITERATOR (gda_data_record_collection_iterator_get_type ())
#define GDA_DATA_RECORD_COLLECTION_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GDA_DATA_TYPE_RECORD_COLLECTION_ITERATOR, GdaDataRecordCollectionIterator))
#define GDA_DATA_RECORD_COLLECTION_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GDA_DATA_TYPE_RECORD_COLLECTION_ITERATOR, GdaDataRecordCollectionIteratorClass))
#define GDA_DATA_IS_RECORD_COLLECTION_ITERATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GDA_DATA_TYPE_RECORD_COLLECTION_ITERATOR))
#define GDA_DATA_IS_RECORD_COLLECTION_ITERATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GDA_DATA_TYPE_RECORD_COLLECTION_ITERATOR))
#define GDA_DATA_RECORD_COLLECTION_ITERATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GDA_DATA_TYPE_RECORD_COLLECTION_ITERATOR, GdaDataRecordCollectionIteratorClass))

typedef struct _GdaDataRecordCollectionIterator GdaDataRecordCollectionIterator;
typedef struct _GdaDataRecordCollectionIteratorClass GdaDataRecordCollectionIteratorClass;

struct _GdaDataDbObjectIface {
	GTypeInterface parent_iface;
	void (*append) (GdaDataDbObject* self, GError** error);
	void (*update) (GdaDataDbObject* self, GError** error);
	void (*save) (GdaDataDbObject* self, GError** error);
	void (*drop) (GdaDataDbObject* self, gboolean cascade, GError** error);
	GdaConnection* (*get_connection) (GdaDataDbObject* self);
	void (*set_connection) (GdaDataDbObject* self, GdaConnection* value);
	gboolean (*get_update_meta) (GdaDataDbObject* self);
	void (*set_update_meta) (GdaDataDbObject* self, gboolean value);
};

struct _GdaDataDbNamedObjectIface {
	GTypeInterface parent_iface;
	const gchar* (*get_name) (GdaDataDbNamedObject* self);
	void (*set_name) (GdaDataDbNamedObject* self, const gchar* value);
};

typedef enum  {
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_PRIMARY_KEY = 1 << 1,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_UNIQUE = 1 << 2,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_FOREIGN_KEY = 1 << 3,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CHECK = 1 << 4,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_HAVE_DEFAULT = 1 << 5,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_CAN_BE_NULL = 1 << 6,
	GDA_DATA_DB_FIELD_INFO_ATTRIBUTE_AUTO_INCREMENT = 1 << 7
} GdaDataDbFieldInfoAttribute;

struct _GdaDataDbFieldInfoIface {
	GTypeInterface parent_iface;
	gboolean (*compatible) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gboolean (*equivalent) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfo* field);
	gchar* (*to_string) (GdaDataDbFieldInfo* self);
	gint (*get_ordinal) (GdaDataDbFieldInfo* self);
	void (*set_ordinal) (GdaDataDbFieldInfo* self, gint value);
	GType (*get_value_type) (GdaDataDbFieldInfo* self);
	void (*set_value_type) (GdaDataDbFieldInfo* self, GType value);
	GdaDataDbFieldInfoAttribute (*get_attributes) (GdaDataDbFieldInfo* self);
	void (*set_attributes) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoAttribute value);
	GValue* (*get_default_value) (GdaDataDbFieldInfo* self);
	void (*set_default_value) (GdaDataDbFieldInfo* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbFieldInfo* self);
	void (*set_name) (GdaDataDbFieldInfo* self, const gchar* value);
	const gchar* (*get_desc) (GdaDataDbFieldInfo* self);
	void (*set_desc) (GdaDataDbFieldInfo* self, const gchar* value);
	gint (*get_precision) (GdaDataDbFieldInfo* self);
	void (*set_precision) (GdaDataDbFieldInfo* self, gint value);
	gint (*get_scale) (GdaDataDbFieldInfo* self);
	void (*set_scale) (GdaDataDbFieldInfo* self, gint value);
	GdaDataDbFieldInfoForeignKey* (*get_fkey) (GdaDataDbFieldInfo* self);
	void (*set_fkey) (GdaDataDbFieldInfo* self, GdaDataDbFieldInfoForeignKey* value);
};

struct _GdaDataDbSchemaIface {
	GTypeInterface parent_iface;
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbSchema* self);
	void (*set_catalog) (GdaDataDbSchema* self, GdaDataDbCatalog* value);
	GeeCollection* (*get_tables) (GdaDataDbSchema* self);
};

struct _GdaDataDbCatalogIface {
	GTypeInterface parent_iface;
	GeeCollection* (*get_shemas) (GdaDataDbCatalog* self);
	void (*set_shemas) (GdaDataDbCatalog* self, GeeCollection* value);
};

typedef enum  {
	GDA_DATA_DB_TABLE_TABLE_TYPE_NONE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_BASE_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_VIEW,
	GDA_DATA_DB_TABLE_TABLE_TYPE_LOCAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYSTEM_TABLE,
	GDA_DATA_DB_TABLE_TABLE_TYPE_GLOBAL_TEMPORARY,
	GDA_DATA_DB_TABLE_TABLE_TYPE_ALIAS,
	GDA_DATA_DB_TABLE_TABLE_TYPE_SYNONYM
} GdaDataDbTableTableType;

typedef enum  {
	GDA_DATA_DB_FIELD_ATTRIBUTE_NONE = 1 << 0,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_NULL = 1 << 1,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_NULL = 1 << 2,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_DEFAULT = 1 << 3,
	GDA_DATA_DB_FIELD_ATTRIBUTE_CAN_BE_DEFAULT = 1 << 4,
	GDA_DATA_DB_FIELD_ATTRIBUTE_IS_UNCHANGED = 1 << 5,
	GDA_DATA_DB_FIELD_ATTRIBUTE_ACTIONS_SHOWN = 1 << 6,
	GDA_DATA_DB_FIELD_ATTRIBUTE_DATA_NON_VALID = 1 << 7,
	GDA_DATA_DB_FIELD_ATTRIBUTE_HAS_VALUE_ORIG = 1 << 8,
	GDA_DATA_DB_FIELD_ATTRIBUTE_NO_MODIF = 1 << 9,
	GDA_DATA_DB_FIELD_ATTRIBUTE_UNUSED = 1 << 10
} GdaDataDbFieldAttribute;

struct _GdaDataDbFieldIface {
	GTypeInterface parent_iface;
	gboolean (*equal) (GdaDataDbField* self, GdaDataDbField* field);
	gchar* (*to_string) (GdaDataDbField* self);
	GValue* (*get_value) (GdaDataDbField* self);
	void (*set_value) (GdaDataDbField* self, GValue* value);
	const gchar* (*get_name) (GdaDataDbField* self);
	void (*set_name) (GdaDataDbField* self, const gchar* value);
	const gchar* (*get_column_name) (GdaDataDbField* self);
	GdaDataDbFieldAttribute (*get_attributes) (GdaDataDbField* self);
};

struct _GdaDataDbRecordIface {
	GTypeInterface parent_iface;
	GValue* (*get_value) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_field) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_field_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_field) (GdaDataDbRecord* self, const gchar* name, GError** error);
	void (*set_key) (GdaDataDbRecord* self, GdaDataDbField* field, GError** error);
	void (*set_key_value) (GdaDataDbRecord* self, const gchar* field, GValue* val, GError** error);
	GdaDataDbField* (*get_key) (GdaDataDbRecord* self, const gchar* name, GError** error);
	gchar* (*to_string) (GdaDataDbRecord* self);
	void (*copy) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	gboolean (*equal) (GdaDataDbRecord* self, GdaDataDbRecord* record, GError** error);
	GdaDataDbTable* (*get_table) (GdaDataDbRecord* self);
	void (*set_table) (GdaDataDbRecord* self, GdaDataDbTable* value);
	GeeCollection* (*get_fields) (GdaDataDbRecord* self);
	GeeCollection* (*get_keys) (GdaDataDbRecord* self);
};

struct _GdaDataDbTableIface {
	GTypeInterface parent_iface;
	void (*set_field) (GdaDataDbTable* self, GdaDataDbFieldInfo* field, GError** error);
	GdaDataDbFieldInfo* (*get_field) (GdaDataDbTable* self, const gchar* name, GError** error);
	gboolean (*compatible) (GdaDataDbTable* self, GdaDataDbTable* table);
	gboolean (*equivalent) (GdaDataDbTable* self, GdaDataDbTable* table);
	GdaDataDbCatalog* (*get_catalog) (GdaDataDbTable* self);
	void (*set_catalog) (GdaDataDbTable* self, GdaDataDbCatalog* value);
	GdaDataDbSchema* (*get_schema) (GdaDataDbTable* self);
	void (*set_schema) (GdaDataDbTable* self, GdaDataDbSchema* value);
	GdaDataDbTableTableType (*get_table_type) (GdaDataDbTable* self);
	void (*set_table_type) (GdaDataDbTable* self, GdaDataDbTableTableType value);
	GeeCollection* (*get_records) (GdaDataDbTable* self);
	GeeCollection* (*get_depends) (GdaDataDbTable* self);
	GeeCollection* (*get_referenced) (GdaDataDbTable* self);
	GeeCollection* (*get_fields) (GdaDataDbTable* self);
	GeeCollection* (*get_primary_keys) (GdaDataDbTable* self);
};

struct _GdaDataDbRecordCollectionIface {
	GTypeInterface parent_iface;
	GdaConnection* (*get_connection) (GdaDataDbRecordCollection* self);
	void (*set_connection) (GdaDataDbRecordCollection* self, GdaConnection* value);
	GdaDataModel* (*get_model) (GdaDataDbRecordCollection* self);
	GdaDataDbTable* (*get_table) (GdaDataDbRecordCollection* self);
};

struct _GdaDataRecordCollection {
	GeeAbstractCollection parent_instance;
	GdaDataRecordCollectionPrivate * priv;
};

struct _GdaDataRecordCollectionClass {
	GeeAbstractCollectionClass parent_class;
};

struct _GdaDataRecordCollectionPrivate {
	GdaDataModel* _model;
	GdaDataDbTable* _table;
	GdaConnection* _connection;
};


static gpointer gda_data_record_collection_parent_class = NULL;
static GdaDataDbRecordCollectionIface * gda_data_record_collection_gda_data_db_record_collection_parent_iface = NULL;

GType gda_data_db_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_named_object_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_attribute_get_type (void) G_GNUC_CONST;
gpointer gda_data_db_field_info_foreign_key_ref (gpointer instance);
void gda_data_db_field_info_foreign_key_unref (gpointer instance);
GParamSpec* gda_data_db_field_info_param_spec_foreign_key (const gchar* name,
                                                           const gchar* nick,
                                                           const gchar* blurb,
                                                           GType object_type,
                                                           GParamFlags flags);
void gda_data_db_field_info_value_set_foreign_key (GValue* value,
                                                   gpointer v_object);
void gda_data_db_field_info_value_take_foreign_key (GValue* value,
                                                    gpointer v_object);
gpointer gda_data_db_field_info_value_get_foreign_key (const GValue* value);
GType gda_data_db_field_info_foreign_key_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_info_get_type (void) G_GNUC_CONST;
GType gda_data_db_schema_get_type (void) G_GNUC_CONST;
GType gda_data_db_catalog_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_table_type_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_attribute_get_type (void) G_GNUC_CONST;
GType gda_data_db_field_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_get_type (void) G_GNUC_CONST;
GType gda_data_db_table_get_type (void) G_GNUC_CONST;
GType gda_data_db_record_collection_get_type (void) G_GNUC_CONST;
GType gda_data_record_collection_get_type (void) G_GNUC_CONST;
#define GDA_DATA_RECORD_COLLECTION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollectionPrivate))
GdaDataRecordCollection* gda_data_record_collection_new (GdaDataModel* m,
                                                         GdaDataDbTable* table);
GdaDataRecordCollection* gda_data_record_collection_construct (GType object_type,
                                                               GdaDataModel* m,
                                                               GdaDataDbTable* table);
static gboolean gda_data_record_collection_real_add (GeeAbstractCollection* base,
                                              GdaDataDbRecord* item);
GeeCollection* gda_data_db_record_get_fields (GdaDataDbRecord* self);
const gchar* gda_data_db_field_get_name (GdaDataDbField* self);
GValue* gda_data_db_field_get_value (GdaDataDbField* self);
static void gda_data_record_collection_real_clear (GeeAbstractCollection* base);
static gboolean gda_data_record_collection_real_contains (GeeAbstractCollection* base,
                                                   GdaDataDbRecord* item);
GeeCollection* gda_data_db_record_get_keys (GdaDataDbRecord* self);
static GeeIterator* gda_data_record_collection_real_iterator (GeeAbstractCollection* base);
GdaDataRecordCollectionIterator* gda_data_record_collection_iterator_new (GdaDataModelIter* iter,
                                                                          GdaDataDbTable* table);
GdaDataRecordCollectionIterator* gda_data_record_collection_iterator_construct (GType object_type,
                                                                                GdaDataModelIter* iter,
                                                                                GdaDataDbTable* table);
GType gda_data_record_collection_iterator_get_type (void) G_GNUC_CONST;
static gboolean gda_data_record_collection_real_remove (GeeAbstractCollection* base,
                                                 GdaDataDbRecord* item);
gchar* gda_data_record_collection_to_string (GdaDataRecordCollection* self);
GdaDataDbTable* gda_data_db_record_collection_get_table (GdaDataDbRecordCollection* self);
static void gda_data_record_collection_finalize (GObject * obj);
GdaDataModel* gda_data_db_record_collection_get_model (GdaDataDbRecordCollection* self);
GdaConnection* gda_data_db_record_collection_get_connection (GdaDataDbRecordCollection* self);
static void _vala_gda_data_record_collection_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
void gda_data_db_record_collection_set_connection (GdaDataDbRecordCollection* self,
                                                   GdaConnection* value);
static void _vala_gda_data_record_collection_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);


static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}


GdaDataRecordCollection*
gda_data_record_collection_construct (GType object_type,
                                      GdaDataModel* m,
                                      GdaDataDbTable* table)
{
	GdaDataRecordCollection * self = NULL;
	GdaDataModel* _tmp0_;
	GdaDataDbTable* _tmp1_;
	g_return_val_if_fail (m != NULL, NULL);
	g_return_val_if_fail (table != NULL, NULL);
	self = (GdaDataRecordCollection*) gee_abstract_collection_construct (object_type, GDA_DATA_TYPE_DB_RECORD, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref);
	_tmp0_ = _g_object_ref0 (m);
	_g_object_unref0 (self->priv->_model);
	self->priv->_model = _tmp0_;
	_tmp1_ = _g_object_ref0 (table);
	_g_object_unref0 (self->priv->_table);
	self->priv->_table = _tmp1_;
	return self;
}


GdaDataRecordCollection*
gda_data_record_collection_new (GdaDataModel* m,
                                GdaDataDbTable* table)
{
	return gda_data_record_collection_construct (GDA_DATA_TYPE_RECORD_COLLECTION, m, table);
}


static gboolean
gda_data_record_collection_real_add (GeeAbstractCollection* base,
                                     GdaDataDbRecord* item)
{
	GdaDataRecordCollection * self;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecordCollection*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	{
		gint r = 0;
		GdaDataModel* _tmp0_;
		_tmp0_ = self->priv->_model;
		r = gda_data_model_append_row (_tmp0_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch11_g_error;
		}
		{
			GeeIterator* _f_it = NULL;
			GeeCollection* _tmp1_;
			GeeCollection* _tmp2_;
			GeeCollection* _tmp3_;
			GeeIterator* _tmp4_;
			GeeIterator* _tmp5_;
			_tmp1_ = gda_data_db_record_get_fields (item);
			_tmp2_ = _tmp1_;
			_tmp3_ = _tmp2_;
			_tmp4_ = gee_iterable_iterator ((GeeIterable*) _tmp3_);
			_tmp5_ = _tmp4_;
			_g_object_unref0 (_tmp3_);
			_f_it = _tmp5_;
			while (TRUE) {
				GeeIterator* _tmp6_;
				GdaDataDbField* f = NULL;
				GeeIterator* _tmp7_;
				gpointer _tmp8_;
				GdaDataModel* _tmp9_;
				GdaDataModel* _tmp10_;
				GdaDataDbField* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gint _tmp14_;
				GdaDataDbField* _tmp15_;
				GValue* _tmp16_;
				GValue* _tmp17_;
				GValue _tmp18_;
				_tmp6_ = _f_it;
				if (!gee_iterator_next (_tmp6_)) {
					break;
				}
				_tmp7_ = _f_it;
				_tmp8_ = gee_iterator_get (_tmp7_);
				f = (GdaDataDbField*) _tmp8_;
				_tmp9_ = self->priv->_model;
				_tmp10_ = self->priv->_model;
				_tmp11_ = f;
				_tmp12_ = gda_data_db_field_get_name (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = r;
				_tmp15_ = f;
				_tmp16_ = gda_data_db_field_get_value (_tmp15_);
				_tmp17_ = _tmp16_;
				_tmp18_ = *_tmp17_;
				gda_data_model_set_value_at (_tmp9_, gda_data_model_get_column_index (_tmp10_, _tmp13_), _tmp14_, &_tmp18_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (f);
					_g_object_unref0 (_f_it);
					goto __catch11_g_error;
				}
				_g_object_unref0 (f);
			}
			_g_object_unref0 (_f_it);
		}
		result = TRUE;
		return result;
	}
	goto __finally11;
	__catch11_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("RecordCollection.vala:50: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally11:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp21_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp21_;
	}
	result = FALSE;
	return result;
}


static void
gda_data_record_collection_real_clear (GeeAbstractCollection* base)
{
	GdaDataRecordCollection * self;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecordCollection*) base;
	{
		GdaDataModelIter* iter = NULL;
		GdaDataModel* _tmp0_;
		GdaDataModelIter* _tmp1_;
		GdaDataModel* _tmp5_;
		_tmp0_ = self->priv->_model;
		_tmp1_ = gda_data_model_create_iter (_tmp0_);
		iter = _tmp1_;
		while (TRUE) {
			GdaDataModelIter* _tmp2_;
			GdaDataModel* _tmp3_;
			GdaDataModelIter* _tmp4_;
			_tmp2_ = iter;
			if (!gda_data_model_iter_move_next (_tmp2_)) {
				break;
			}
			_tmp3_ = self->priv->_model;
			_tmp4_ = iter;
			gda_data_model_remove_row (_tmp3_, gda_data_model_iter_get_row (_tmp4_), &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				_g_object_unref0 (iter);
				goto __catch12_g_error;
			}
		}
		_tmp5_ = self->priv->_model;
		gda_data_proxy_apply_all_changes (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gda_data_proxy_get_type (), GdaDataProxy), &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (iter);
			goto __catch12_g_error;
		}
		_g_object_unref0 (iter);
	}
	goto __finally12;
	__catch12_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_warning ("RecordCollection.vala:62: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally12:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static gboolean
gda_data_record_collection_real_contains (GeeAbstractCollection* base,
                                          GdaDataDbRecord* item)
{
	GdaDataRecordCollection * self;
	gboolean result = FALSE;
	gboolean found = FALSE;
	GdaDataModelIter* iter = NULL;
	GdaDataModel* _tmp0_;
	GdaDataModelIter* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecordCollection*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	found = TRUE;
	_tmp0_ = self->priv->_model;
	_tmp1_ = gda_data_model_create_iter (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GdaDataModelIter* _tmp2_;
		gboolean _tmp30_;
		_tmp2_ = iter;
		if (!gda_data_model_iter_move_next (_tmp2_)) {
			break;
		}
		{
			GeeIterator* _k_it = NULL;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp3_ = gda_data_db_record_get_keys (item);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_k_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				GdaDataDbField* k = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				_tmp8_ = _k_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _k_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				k = (GdaDataDbField*) _tmp10_;
				{
					GValue id = {0};
					GdaDataModelIter* _tmp11_;
					GdaDataModelIter* _tmp12_;
					GdaDataModel* _tmp13_;
					GdaDataModel* _tmp14_;
					GdaDataModel* _tmp15_;
					GdaDataDbField* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					GValue _tmp19_ = {0};
					GValue _tmp20_;
					GValue v = {0};
					GdaDataDbField* _tmp21_;
					GValue* _tmp22_;
					GValue* _tmp23_;
					GValue _tmp24_ = {0};
					GValue _tmp25_;
					GValue _tmp26_;
					_tmp11_ = iter;
					_tmp12_ = iter;
					g_object_get (_tmp12_, "data-model", &_tmp13_, NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = _tmp14_;
					_tmp16_ = k;
					_tmp17_ = gda_data_db_field_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					if (G_IS_VALUE (gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_)))) {
						g_value_init (&_tmp19_, G_VALUE_TYPE (gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_))));
						g_value_copy (gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_)), &_tmp19_);
					} else {
						_tmp19_ = *gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_));
					}
					_tmp20_ = _tmp19_;
					_g_object_unref0 (_tmp15_);
					id = _tmp20_;
					_tmp21_ = k;
					_tmp22_ = gda_data_db_field_get_value (_tmp21_);
					_tmp23_ = _tmp22_;
					if (G_IS_VALUE (_tmp23_)) {
						g_value_init (&_tmp24_, G_VALUE_TYPE (_tmp23_));
						g_value_copy (_tmp23_, &_tmp24_);
					} else {
						_tmp24_ = *_tmp23_;
					}
					v = _tmp24_;
					_tmp25_ = id;
					_tmp26_ = v;
					if (gda_value_compare (&_tmp25_, &_tmp26_) != 0) {
						found = FALSE;
					}
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					G_IS_VALUE (&id) ? (g_value_unset (&id), NULL) : NULL;
				}
				goto __finally13;
				__catch13_g_error:
				{
					GError* e = NULL;
					GError* _tmp27_;
					const gchar* _tmp28_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp27_ = e;
					_tmp28_ = _tmp27_->message;
					g_warning ("RecordCollection.vala:77: %s", _tmp28_);
					found = FALSE;
					_g_error_free0 (e);
				}
				__finally13:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp29_ = FALSE;
					_g_object_unref0 (k);
					_g_object_unref0 (_k_it);
					_g_object_unref0 (iter);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp29_;
				}
				_g_object_unref0 (k);
			}
			_g_object_unref0 (_k_it);
		}
		_tmp30_ = found;
		if (_tmp30_) {
			break;
		}
	}
	result = found;
	_g_object_unref0 (iter);
	return result;
}


static GeeIterator*
gda_data_record_collection_real_iterator (GeeAbstractCollection* base)
{
	GdaDataRecordCollection * self;
	GeeIterator* result = NULL;
	GdaDataModelIter* iter = NULL;
	GdaDataModel* _tmp0_;
	GdaDataModelIter* _tmp1_;
	GdaDataDbTable* _tmp2_;
	GdaDataRecordCollectionIterator* _tmp3_;
	self = (GdaDataRecordCollection*) base;
	_tmp0_ = self->priv->_model;
	_tmp1_ = gda_data_model_create_iter (_tmp0_);
	_g_object_unref0 (iter);
	iter = _tmp1_;
	_tmp2_ = self->priv->_table;
	_tmp3_ = gda_data_record_collection_iterator_new (iter, _tmp2_);
	result = (GeeIterator*) _tmp3_;
	_g_object_unref0 (iter);
	return result;
}


static gboolean
gda_data_record_collection_real_remove (GeeAbstractCollection* base,
                                        GdaDataDbRecord* item)
{
	GdaDataRecordCollection * self;
	gboolean result = FALSE;
	GdaDataModelIter* iter = NULL;
	GdaDataModel* _tmp0_;
	GdaDataModelIter* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (GdaDataRecordCollection*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp0_ = self->priv->_model;
	_tmp1_ = gda_data_model_create_iter (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GdaDataModelIter* _tmp2_;
		gboolean found = FALSE;
		gboolean _tmp30_;
		_tmp2_ = iter;
		if (!gda_data_model_iter_move_next (_tmp2_)) {
			break;
		}
		found = TRUE;
		{
			GeeIterator* _k_it = NULL;
			GeeCollection* _tmp3_;
			GeeCollection* _tmp4_;
			GeeCollection* _tmp5_;
			GeeIterator* _tmp6_;
			GeeIterator* _tmp7_;
			_tmp3_ = gda_data_db_record_get_keys (item);
			_tmp4_ = _tmp3_;
			_tmp5_ = _tmp4_;
			_tmp6_ = gee_iterable_iterator ((GeeIterable*) _tmp5_);
			_tmp7_ = _tmp6_;
			_g_object_unref0 (_tmp5_);
			_k_it = _tmp7_;
			while (TRUE) {
				GeeIterator* _tmp8_;
				GdaDataDbField* k = NULL;
				GeeIterator* _tmp9_;
				gpointer _tmp10_;
				_tmp8_ = _k_it;
				if (!gee_iterator_next (_tmp8_)) {
					break;
				}
				_tmp9_ = _k_it;
				_tmp10_ = gee_iterator_get (_tmp9_);
				k = (GdaDataDbField*) _tmp10_;
				{
					GValue id = {0};
					GdaDataModelIter* _tmp11_;
					GdaDataModelIter* _tmp12_;
					GdaDataModel* _tmp13_;
					GdaDataModel* _tmp14_;
					GdaDataModel* _tmp15_;
					GdaDataDbField* _tmp16_;
					const gchar* _tmp17_;
					const gchar* _tmp18_;
					GValue _tmp19_ = {0};
					GValue _tmp20_;
					GValue v = {0};
					GdaDataDbField* _tmp21_;
					GValue* _tmp22_;
					GValue* _tmp23_;
					GValue _tmp24_ = {0};
					GValue _tmp25_;
					GValue _tmp26_;
					_tmp11_ = iter;
					_tmp12_ = iter;
					g_object_get (_tmp12_, "data-model", &_tmp13_, NULL);
					_tmp14_ = _tmp13_;
					_tmp15_ = _tmp14_;
					_tmp16_ = k;
					_tmp17_ = gda_data_db_field_get_name (_tmp16_);
					_tmp18_ = _tmp17_;
					if (G_IS_VALUE (gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_)))) {
						g_value_init (&_tmp19_, G_VALUE_TYPE (gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_))));
						g_value_copy (gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_)), &_tmp19_);
					} else {
						_tmp19_ = *gda_data_model_iter_get_value_at (_tmp11_, gda_data_model_get_column_index (_tmp15_, _tmp18_));
					}
					_tmp20_ = _tmp19_;
					_g_object_unref0 (_tmp15_);
					id = _tmp20_;
					_tmp21_ = k;
					_tmp22_ = gda_data_db_field_get_value (_tmp21_);
					_tmp23_ = _tmp22_;
					if (G_IS_VALUE (_tmp23_)) {
						g_value_init (&_tmp24_, G_VALUE_TYPE (_tmp23_));
						g_value_copy (_tmp23_, &_tmp24_);
					} else {
						_tmp24_ = *_tmp23_;
					}
					v = _tmp24_;
					_tmp25_ = id;
					_tmp26_ = v;
					if (gda_value_compare (&_tmp25_, &_tmp26_) != 0) {
						found = FALSE;
					}
					G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
					G_IS_VALUE (&id) ? (g_value_unset (&id), NULL) : NULL;
				}
				goto __finally14;
				__catch14_g_error:
				{
					GError* e = NULL;
					GError* _tmp27_;
					const gchar* _tmp28_;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp27_ = e;
					_tmp28_ = _tmp27_->message;
					g_warning ("RecordCollection.vala:104: %s", _tmp28_);
					found = FALSE;
					_g_error_free0 (e);
				}
				__finally14:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp29_ = FALSE;
					_g_object_unref0 (k);
					_g_object_unref0 (_k_it);
					_g_object_unref0 (iter);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp29_;
				}
				_g_object_unref0 (k);
			}
			_g_object_unref0 (_k_it);
		}
		_tmp30_ = found;
		if (_tmp30_) {
			{
				GdaDataModel* _tmp31_;
				GdaDataModelIter* _tmp32_;
				GdaDataModel* _tmp33_;
				_tmp31_ = self->priv->_model;
				_tmp32_ = iter;
				gda_data_model_remove_row (_tmp31_, gda_data_model_iter_get_row (_tmp32_), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch15_g_error;
				}
				_tmp33_ = self->priv->_model;
				gda_data_proxy_apply_all_changes (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, gda_data_proxy_get_type (), GdaDataProxy), &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					goto __catch15_g_error;
				}
				result = TRUE;
				_g_object_unref0 (iter);
				return result;
			}
			goto __finally15;
			__catch15_g_error:
			{
				g_clear_error (&_inner_error_);
				_inner_error_ = NULL;
			}
			__finally15:
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp34_ = FALSE;
				_g_object_unref0 (iter);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp34_;
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (iter);
	return result;
}


gchar*
gda_data_record_collection_to_string (GdaDataRecordCollection* self)
{
	gchar* result = NULL;
	GdaDataModel* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	_tmp1_ = gda_data_model_dump_as_string (_tmp0_);
	result = _tmp1_;
	return result;
}


static GdaDataDbTable*
gda_data_record_collection_real_get_table (GdaDataDbRecordCollection* base)
{
	GdaDataDbTable* result;
	GdaDataRecordCollection* self;
	GdaDataDbTable* _tmp0_;
	GdaDataDbTable* _tmp1_;
	self = (GdaDataRecordCollection*) base;
	_tmp0_ = gda_data_db_record_collection_get_table ((GdaDataDbRecordCollection*) self);
	_tmp1_ = _tmp0_;
	result = _tmp1_;
	return result;
}


static GdaDataModel*
gda_data_record_collection_real_get_model (GdaDataDbRecordCollection* base)
{
	GdaDataModel* result;
	GdaDataRecordCollection* self;
	GdaDataModel* _tmp0_;
	self = (GdaDataRecordCollection*) base;
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}


static GdaConnection*
gda_data_record_collection_real_get_connection (GdaDataDbRecordCollection* base)
{
	GdaConnection* result;
	GdaDataRecordCollection* self;
	GdaConnection* _tmp0_;
	self = (GdaDataRecordCollection*) base;
	_tmp0_ = self->priv->_connection;
	result = _tmp0_;
	return result;
}


static void
gda_data_record_collection_real_set_connection (GdaDataDbRecordCollection* base,
                                                GdaConnection* value)
{
	GdaDataRecordCollection* self;
	self = (GdaDataRecordCollection*) base;
	if (gda_data_record_collection_real_get_connection (base) != value) {
		GdaConnection* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_connection);
		self->priv->_connection = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_CONNECTION_PROPERTY]);
	}
}


static gboolean
gda_data_record_collection_real_get_read_only (GeeAbstractCollection* base)
{
	gboolean result;
	GdaDataRecordCollection* self;
	GdaDataModelAccessFlags f = 0;
	GdaDataModel* _tmp0_;
	GdaDataModelAccessFlags _tmp1_;
	self = (GdaDataRecordCollection*) base;
	_tmp0_ = self->priv->_model;
	f = gda_data_model_get_access_flags (_tmp0_);
	_tmp1_ = f;
	if ((((_tmp1_ & GDA_DATA_MODEL_ACCESS_INSERT) & GDA_DATA_MODEL_ACCESS_UPDATE) & GDA_DATA_MODEL_ACCESS_DELETE) != 0) {
		result = TRUE;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}


static gint
gda_data_record_collection_real_get_size (GeeAbstractCollection* base)
{
	gint result;
	GdaDataRecordCollection* self;
	GdaDataModel* _tmp0_;
	self = (GdaDataRecordCollection*) base;
	_tmp0_ = self->priv->_model;
	result = gda_data_model_get_n_rows (_tmp0_);
	return result;
}


static void
gda_data_record_collection_class_init (GdaDataRecordCollectionClass * klass)
{
	gda_data_record_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GdaDataRecordCollectionPrivate));
	((GeeAbstractCollectionClass *) klass)->add = (gboolean (*) (GeeAbstractCollection *, gconstpointer)) gda_data_record_collection_real_add;
	((GeeAbstractCollectionClass *) klass)->clear = (void (*) (GeeAbstractCollection *)) gda_data_record_collection_real_clear;
	((GeeAbstractCollectionClass *) klass)->contains = (gboolean (*) (GeeAbstractCollection *, gconstpointer)) gda_data_record_collection_real_contains;
	((GeeAbstractCollectionClass *) klass)->iterator = (GeeIterator* (*) (GeeAbstractCollection *)) gda_data_record_collection_real_iterator;
	((GeeAbstractCollectionClass *) klass)->remove = (gboolean (*) (GeeAbstractCollection *, gconstpointer)) gda_data_record_collection_real_remove;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_read_only = gda_data_record_collection_real_get_read_only;
	GEE_ABSTRACT_COLLECTION_CLASS (klass)->get_size = gda_data_record_collection_real_get_size;
	G_OBJECT_CLASS (klass)->get_property = _vala_gda_data_record_collection_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gda_data_record_collection_set_property;
	G_OBJECT_CLASS (klass)->finalize = gda_data_record_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_COLLECTION_TABLE_PROPERTY, gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_TABLE_PROPERTY] = g_param_spec_object ("table", "table", "table", GDA_DATA_TYPE_DB_TABLE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_COLLECTION_MODEL_PROPERTY, gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", gda_data_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_COLLECTION_CONNECTION_PROPERTY, gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_CONNECTION_PROPERTY] = g_param_spec_object ("connection", "connection", "connection", gda_connection_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_COLLECTION_READ_ONLY_PROPERTY, gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_READ_ONLY_PROPERTY] = g_param_spec_boolean ("read-only", "read-only", "read-only", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GDA_DATA_RECORD_COLLECTION_SIZE_PROPERTY, gda_data_record_collection_properties[GDA_DATA_RECORD_COLLECTION_SIZE_PROPERTY] = g_param_spec_int ("size", "size", "size", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}


static void
gda_data_record_collection_gda_data_db_record_collection_interface_init (GdaDataDbRecordCollectionIface * iface)
{
	gda_data_record_collection_gda_data_db_record_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_table = gda_data_record_collection_real_get_table;
	iface->get_model = gda_data_record_collection_real_get_model;
	iface->get_connection = gda_data_record_collection_real_get_connection;
	iface->set_connection = gda_data_record_collection_real_set_connection;
}


static void
gda_data_record_collection_instance_init (GdaDataRecordCollection * self)
{
	self->priv = GDA_DATA_RECORD_COLLECTION_GET_PRIVATE (self);
}


static void
gda_data_record_collection_finalize (GObject * obj)
{
	GdaDataRecordCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollection);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->_table);
	_g_object_unref0 (self->priv->_connection);
	G_OBJECT_CLASS (gda_data_record_collection_parent_class)->finalize (obj);
}


GType
gda_data_record_collection_get_type (void)
{
	static volatile gsize gda_data_record_collection_type_id__volatile = 0;
	if (g_once_init_enter (&gda_data_record_collection_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GdaDataRecordCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gda_data_record_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GdaDataRecordCollection), 0, (GInstanceInitFunc) gda_data_record_collection_instance_init, NULL };
		static const GInterfaceInfo gda_data_db_record_collection_info = { (GInterfaceInitFunc) gda_data_record_collection_gda_data_db_record_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType gda_data_record_collection_type_id;
		gda_data_record_collection_type_id = g_type_register_static (GEE_TYPE_ABSTRACT_COLLECTION, "GdaDataRecordCollection", &g_define_type_info, 0);
		g_type_add_interface_static (gda_data_record_collection_type_id, GDA_DATA_TYPE_DB_RECORD_COLLECTION, &gda_data_db_record_collection_info);
		g_once_init_leave (&gda_data_record_collection_type_id__volatile, gda_data_record_collection_type_id);
	}
	return gda_data_record_collection_type_id__volatile;
}


static void
_vala_gda_data_record_collection_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	GdaDataRecordCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollection);
	switch (property_id) {
		case GDA_DATA_RECORD_COLLECTION_TABLE_PROPERTY:
		g_value_set_object (value, gda_data_db_record_collection_get_table ((GdaDataDbRecordCollection*) self));
		break;
		case GDA_DATA_RECORD_COLLECTION_MODEL_PROPERTY:
		g_value_set_object (value, gda_data_db_record_collection_get_model ((GdaDataDbRecordCollection*) self));
		break;
		case GDA_DATA_RECORD_COLLECTION_CONNECTION_PROPERTY:
		g_value_set_object (value, gda_data_db_record_collection_get_connection ((GdaDataDbRecordCollection*) self));
		break;
		case GDA_DATA_RECORD_COLLECTION_READ_ONLY_PROPERTY:
		g_value_set_boolean (value, gee_abstract_collection_get_read_only ((GeeAbstractCollection*) self));
		break;
		case GDA_DATA_RECORD_COLLECTION_SIZE_PROPERTY:
		g_value_set_int (value, gee_abstract_collection_get_size ((GeeAbstractCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void
_vala_gda_data_record_collection_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	GdaDataRecordCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GDA_DATA_TYPE_RECORD_COLLECTION, GdaDataRecordCollection);
	switch (property_id) {
		case GDA_DATA_RECORD_COLLECTION_CONNECTION_PROPERTY:
		gda_data_db_record_collection_set_connection ((GdaDataDbRecordCollection*) self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



