/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Kurland     vadim@vk.crocodile.org

  $Id: Firewall.cc,v 1.22 2002/09/08 19:28:16 vkurland Exp $


  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

*/

#include <assert.h>

#include <fwbuilder/libfwbuilder-config.h>

#include <fwbuilder/Firewall.hh>

#include <fwbuilder/FWObjectReference.hh>
#include <fwbuilder/FWOptions.hh>
#include <fwbuilder/Interface.hh>
#include <fwbuilder/Management.hh>

#include <fwbuilder/Policy.hh>
#include <fwbuilder/InterfacePolicy.hh>
#include <fwbuilder/NAT.hh>

#include <fwbuilder/RuleElement.hh>

#include <fwbuilder/XMLTools.hh>

using namespace std;
using namespace libfwbuilder;

const char *Firewall::TYPENAME={"Firewall"};

Firewall::Firewall()
{
    setStr("platform","unknown");
    setStr("host_OS" ,"unknown");
}

Firewall::Firewall(const FWObject *root) : Host(root)
{
    setStr("platform","unknown");
    setStr("host_OS" ,"unknown");

    add( new FirewallOptions() );
    add( new Policy() );
    add( new NAT() );
}


Firewall::~Firewall()  {}

void Firewall::fromXML(xmlNodePtr root) throw(FWException)
{
    const char *n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("platform")));
    assert(n!=NULL);
    setStr("platform", n);
    FREEXMLBUFF(n);

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("version")));
    if (n!=NULL)
    {
        setStr("version", n);
        FREEXMLBUFF(n);
    }

    n=FROMXMLCAST(xmlGetProp(root,TOXMLCAST("host_OS")));
    if (n!=NULL)
    {
        setStr("host_OS", n);
        FREEXMLBUFF(n);
    }

    Host::fromXML(root);
}

xmlNodePtr Firewall::toXML(xmlNodePtr parent) throw(FWException)
{
    xmlNodePtr me = FWObject::toXML(parent, false);
    FWObject *o;
    
    o=getFirstByType( NAT::TYPENAME );
    if (o) o->toXML(me);

    o=getFirstByType( Policy::TYPENAME );
    if (o) o->toXML(me);

    for(FWObjectTypedChildIterator j=findByType(Interface::TYPENAME); j!=j.end(); ++j)
 	if((o=(*j))!=NULL )
 	    o->toXML(me);

    o=getFirstByType( Management::TYPENAME );
    if(o) o->toXML(me);

    o=getFirstByType( FirewallOptions::TYPENAME );
    if (o) o->toXML(me);

    return me;
}

FWOptions* Firewall::getOptionsObject()
{
    return FWOptions::cast( getFirstByType(FirewallOptions::TYPENAME) );
}


Policy* Firewall::getPolicy() 
{ 
    return(Policy::cast(getFirstByType(Policy::TYPENAME)));
}

NAT* Firewall::getNAT()    
{ 
    return(NAT::cast(getFirstByType(NAT::TYPENAME)));
}


bool  Firewall::validateChild(FWObject *o)
{ 
    string otype=o->getTypeName();
    return (FWObject::validateChild(o) && 
	    (otype==Interface::TYPENAME  ||
	     otype==RuleSet::TYPENAME    ||
	     otype==Policy::TYPENAME     ||
	     otype==NAT::TYPENAME        ||
	     otype==Management::TYPENAME ||
	     otype==FirewallOptions::TYPENAME ));
}

void Firewall::replaceRefToFirewall(RuleSet *rs,const string &oldfw_id)
{
    for (FWObject::iterator j1=rs->begin(); j1!=rs->end(); ++j1)
    {
        for (FWObject::iterator j2=(*j1)->begin(); j2!=(*j1)->end(); ++j2)
        {
            for (FWObject::iterator i=(*j2)->begin(); i!=(*j2)->end(); ++i)
            {
                FWReference *ref=FWObjectReference::cast(*i);
                if (ref!=NULL)
                { 
                    if (ref->getPointerId()==oldfw_id)
                        ref->setPointerId(getId());
                }
            }
        }
    }
}

FWObject& Firewall::duplicate(const FWObject *obj, bool preserve_id) throw(FWException)
{
    FWObject::duplicate(obj,preserve_id);

    FWObjectTypedChildIterator j=findByType(Interface::TYPENAME);
    for ( ; j!=j.end(); ++j ) 
    {
        Interface *iface=Interface::cast(*j);
	RuleSet  *ipolicy=RuleSet::cast(iface->getFirstByType(InterfacePolicy::TYPENAME));
        if (ipolicy)
            replaceRefToFirewall(ipolicy,obj->getId());
    }

    Policy *p=getPolicy();
    replaceRefToFirewall(p,obj->getId());

    NAT    *n=getNAT();
    replaceRefToFirewall(n,obj->getId());

    return *this;
}

