/* 

                          Firewall Builder

                 Copyright (C) 2000 NetCitadel, LLC

  Author:  Vadim Zaliva <lord@crocodile.org>

  $Id: fwbd.h,v 1.12 2002/08/29 00:34:09 vkurland Exp $

  This program is free software which we release under the GNU General Public
  License. You may redistribute and/or modify this program under the terms
  of that license as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
 
  To get a copy of the GNU General Public License, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


/*
 * This header file contains prototypes of all public functions
 * included in 'libfwbd' library. These functions are used to access
 * 'fwbd' daemon. This is simple "C" language interface. It can be 
 * used by 3rd party products to access our daemon.
 */

#ifndef __FWBD_H_FLAG__
#define __FWBD_H_FLAG__

#ifdef __cplusplus
extern "C" {
#endif

#ifdef HAVE_LIBSSL
# include <openssl/ssl.h>
# include <openssl/err.h>
#else
/* dummy definitions to compile when libssl not present */
  typedef void EVP_PKEY;
  typedef void X509_NAME;
  typedef void X509;
#endif
    
#define FWBD_MAX_PROTOCOL_LINE_LEN 256
    
    struct fwbd_connection
    {
        int      server;
#ifdef HAVE_LIBSSL
        SSL_CTX *ctx;
        SSL     *ssl;
#endif        
        /* Host info */
        int   connected;
        char *host;
        int   port;
        
        /* Last error message */
        char *lasterr;
    };

    void fwbd_init();

    struct fwbd_connection * fwdb_new_connection();
    
    void fwdb_free_connection(struct fwbd_connection *);

    /**
     * Connects to the daemon.
     *
     * @return 0 on success or error code otherwise.
     */
    int fwbd_connect(const char *host, int port, struct fwbd_connection *con, EVP_PKEY *pkey, X509 *cert);

    int fwbd_disconnect(struct fwbd_connection *con);

    int fwbd_send_protocol_line(struct fwbd_connection *con, const char *s);

    /**
     * Reads line from SSL connection.
     * Returned line is zero terminated.
     *
     * @return following code:
     *  0+  line length if read was OK.
     * -1 if reading error occured,
     * -2 if buffer is full.
     */
    int fwbd_read_protocol_line(struct fwbd_connection *con, char *buf, int len);

    /**
     * Sends command over SSL connection and reads response.
     * @returns response line or NULL in case of error.
     */
    char *fwbd_send_command(struct fwbd_connection *con, const char *cmd);

    /**
     * Converts public key to string.
     *
     * @returns malloc-ed null terminated string or NULL in case of error.
     */
    char *fwbd_key2str(EVP_PKEY *skey);

#ifdef __cplusplus
}
#endif

#endif /* __FWBD_H_FLAG__ */

