#!/bin/sh

if [ -x /bin/bash ];           then BASH="/bin/bash";           fi
if [ -x /usr/bin/bash ];       then BASH="/usr/bin/bash";       fi
if [ -x /usr/local/bin/bash ]; then BASH="/usr/local/bin/bash"; fi
if [ -z "$BASH" ]; then
  echo "Could not find bash."
  exit 1
fi


PACKAGE_NAME="$1"
VERSION="$2"
RPMROOT=/var/tmp/${PACKAGE_NAME}
EXPORTDIR=`pwd`/export
TAR_FILE=${PACKAGE_NAME}-${VERSION}.tar.gz
SNAPSHOT_DIR=${PACKAGE_NAME}-${VERSION}

TMP_FILE=${EXPORTDIR}/.maketar.tmp.sh


RPMFILES=""

#
# files regenerated by autogen.sh
GENFILES="aclocal.m4"

for f in ${GENFILES}; do
    test -f $f && RPMFILES="${RPMFILES} $f"
done


cat > ${TMP_FILE} << EOF

function die {
   echo $1
   exit 1
}

if test -z ${PACKAGE_NAME} -o -z ${VERSION}; then
  echo Usage: maketar.sh package_name version
  exit 1
fi


mkdir -p ${EXPORTDIR}

# make distclean

RPMFILES="${RPMFILES}              \
          VERSION                  \
          printversion.sh          \
          autogen.sh               \
          maketar.sh               \
          acconfig.h               \
	  mkinstalldirs            \
	  libfwbuilder-config.in   \
	  acinclude.m4             \
          aclocal.m4               \
          config.guess             \
          config.sub               \
          configure                \
          ltmain.sh                \
	  Makefile                 \
	  Main.make.in             \
	  install.sh               \
	  configure.in             \
	  build_librpm.sh          \
          missing                  \
	  doc                      \
	  etc                      \
	  migration/Makefile.in    \
          migration/[.0-9]*/*.xslt \
          src/Makefile.in          \
          src/*/*.in               \
          src/*/*.c                \
          src/*/*.h                \
          src/*/*.cc               \
          src/*/*.hh"


cd ${EXPORTDIR}
rm -rf ${SNAPSHOT_DIR}
ln -s .. ${SNAPSHOT_DIR}

FILELIST=\`for f in \${RPMFILES}; do echo ${SNAPSHOT_DIR}/\$f; done\`

tar -ch --exclude CVS --exclude *.bak -f - \${FILELIST}  | gzip > ${TAR_FILE} 
cd ..

EOF

$BASH $TMP_FILE

rm -f $TMP_FILE


