/**
 * @file
 * @brief Contains additional external requirements defs for external includes.
 * @note   DO NOT EDIT THIS FILE, your changes will be lost.
 *         Edit ir/be/sparc/sparc_spec.pl instead.
 *         created by: ir/be/scripts/generate_regalloc_if.pl ir/be/sparc/sparc_spec.pl ir/be/sparc
 * @date   Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_SPARC_GEN_SPARC_REGALLOC_IF_H
#define FIRM_BE_SPARC_GEN_SPARC_REGALLOC_IF_H

#include "bearch.h"
#include "sparc_nodes_attr.h"

/** global register indices for sparc registers */
enum reg_indices {
	REG_FPFLAGS,
	REG_L0,
	REG_L1,
	REG_L2,
	REG_L3,
	REG_L4,
	REG_L5,
	REG_L6,
	REG_L7,
	REG_G0,
	REG_G1,
	REG_G2,
	REG_G3,
	REG_G4,
	REG_G5,
	REG_G6,
	REG_G7,
	REG_O0,
	REG_O1,
	REG_O2,
	REG_O3,
	REG_O4,
	REG_O5,
	REG_SP,
	REG_O7,
	REG_I0,
	REG_I1,
	REG_I2,
	REG_I3,
	REG_I4,
	REG_I5,
	REG_FRAME_POINTER,
	REG_I7,
	REG_F0,
	REG_F1,
	REG_F2,
	REG_F3,
	REG_F4,
	REG_F5,
	REG_F6,
	REG_F7,
	REG_F8,
	REG_F9,
	REG_F10,
	REG_F11,
	REG_F12,
	REG_F13,
	REG_F14,
	REG_F15,
	REG_F16,
	REG_F17,
	REG_F18,
	REG_F19,
	REG_F20,
	REG_F21,
	REG_F22,
	REG_F23,
	REG_F24,
	REG_F25,
	REG_F26,
	REG_F27,
	REG_F28,
	REG_F29,
	REG_F30,
	REG_F31,
	REG_Y,
	REG_FLAGS,

	N_SPARC_REGISTERS
};
/** local register indices for sparc registers */
enum {
	REG_FPFLAGS_CLASS_FPFLAGS = 0,
	REG_GP_L0 = 0,
	REG_GP_L1 = 1,
	REG_GP_L2 = 2,
	REG_GP_L3 = 3,
	REG_GP_L4 = 4,
	REG_GP_L5 = 5,
	REG_GP_L6 = 6,
	REG_GP_L7 = 7,
	REG_GP_G0 = 8,
	REG_GP_G1 = 9,
	REG_GP_G2 = 10,
	REG_GP_G3 = 11,
	REG_GP_G4 = 12,
	REG_GP_G5 = 13,
	REG_GP_G6 = 14,
	REG_GP_G7 = 15,
	REG_GP_O0 = 16,
	REG_GP_O1 = 17,
	REG_GP_O2 = 18,
	REG_GP_O3 = 19,
	REG_GP_O4 = 20,
	REG_GP_O5 = 21,
	REG_GP_SP = 22,
	REG_GP_O7 = 23,
	REG_GP_I0 = 24,
	REG_GP_I1 = 25,
	REG_GP_I2 = 26,
	REG_GP_I3 = 27,
	REG_GP_I4 = 28,
	REG_GP_I5 = 29,
	REG_GP_FRAME_POINTER = 30,
	REG_GP_I7 = 31,
	REG_FP_F0 = 0,
	REG_FP_F1 = 1,
	REG_FP_F2 = 2,
	REG_FP_F3 = 3,
	REG_FP_F4 = 4,
	REG_FP_F5 = 5,
	REG_FP_F6 = 6,
	REG_FP_F7 = 7,
	REG_FP_F8 = 8,
	REG_FP_F9 = 9,
	REG_FP_F10 = 10,
	REG_FP_F11 = 11,
	REG_FP_F12 = 12,
	REG_FP_F13 = 13,
	REG_FP_F14 = 14,
	REG_FP_F15 = 15,
	REG_FP_F16 = 16,
	REG_FP_F17 = 17,
	REG_FP_F18 = 18,
	REG_FP_F19 = 19,
	REG_FP_F20 = 20,
	REG_FP_F21 = 21,
	REG_FP_F22 = 22,
	REG_FP_F23 = 23,
	REG_FP_F24 = 24,
	REG_FP_F25 = 25,
	REG_FP_F26 = 26,
	REG_FP_F27 = 27,
	REG_FP_F28 = 28,
	REG_FP_F29 = 29,
	REG_FP_F30 = 30,
	REG_FP_F31 = 31,
	REG_MUL_DIV_HIGH_RES_Y = 0,
	REG_FLAGS_CLASS_FLAGS = 0,

};

/** number of registers in sparc register classes. */
enum {
	N_sparc_fpflags_class_REGS = 1,
	N_sparc_gp_REGS = 32,
	N_sparc_fp_REGS = 32,
	N_sparc_mul_div_high_res_REGS = 1,
	N_sparc_flags_class_REGS = 1,

};
enum reg_classes {
	CLASS_sparc_fpflags_class = 0,
	CLASS_sparc_gp = 1,
	CLASS_sparc_fp = 2,
	CLASS_sparc_mul_div_high_res = 3,
	CLASS_sparc_flags_class = 4,
	N_SPARC_CLASSES = 5
};



extern const arch_register_t sparc_registers[N_SPARC_REGISTERS];

extern arch_register_class_t sparc_reg_classes[N_SPARC_CLASSES];

void sparc_register_init(void);

#endif
