/**
 * @file
 * @brief Function prototypes for the new opcode functions.
 * @note  DO NOT EDIT THIS FILE, your changes will be lost.
 *        Edit ir/be/sparc/sparc_spec.pl instead.
 *        created by: ir/be/scripts/generate_new_opcodes.pl ir/be/sparc/sparc_spec.pl ir/be/sparc
 * @date  Mon Nov 19 18:12:23 2012
 */
#ifndef FIRM_BE_SPARC_GEN_SPARC_NEW_NODES_H
#define FIRM_BE_SPARC_GEN_SPARC_NEW_NODES_H

typedef enum sparc_opcodes {
	iro_sparc_SubCCZero,
	iro_sparc_Sra,
	iro_sparc_Ld,
	iro_sparc_fitof,
	iro_sparc_fadd,
	iro_sparc_Start,
	iro_sparc_RestoreZero,
	iro_sparc_SetHi,
	iro_sparc_Xor,
	iro_sparc_Or,
	iro_sparc_Restore,
	iro_sparc_SubX_t,
	iro_sparc_UMulh,
	iro_sparc_Ba,
	iro_sparc_Cmp,
	iro_sparc_fftof,
	iro_sparc_XNorCCZero,
	iro_sparc_Call,
	iro_sparc_AddX,
	iro_sparc_SubSP,
	iro_sparc_Add,
	iro_sparc_SubCC,
	iro_sparc_Ldf,
	iro_sparc_fdiv,
	iro_sparc_AndN,
	iro_sparc_fftoi,
	iro_sparc_XorCCZero,
	iro_sparc_St,
	iro_sparc_MulCCZero,
	iro_sparc_Save,
	iro_sparc_fbfcc,
	iro_sparc_Sub,
	iro_sparc_Mul,
	iro_sparc_SubCC_t,
	iro_sparc_Stf,
	iro_sparc_SDiv,
	iro_sparc_AddX_t,
	iro_sparc_fabs,
	iro_sparc_AddCC,
	iro_sparc_Bicc,
	iro_sparc_OrN,
	iro_sparc_SubX,
	iro_sparc_fcmp,
	iro_sparc_OrCCZero,
	iro_sparc_AddSP,
	iro_sparc_SMulh,
	iro_sparc_AddCC_t,
	iro_sparc_Return,
	iro_sparc_XNor,
	iro_sparc_AndNCCZero,
	iro_sparc_AndCCZero,
	iro_sparc_FrameAddr,
	iro_sparc_OrNCCZero,
	iro_sparc_And,
	iro_sparc_fmul,
	iro_sparc_AddCCZero,
	iro_sparc_UDiv,
	iro_sparc_Sll,
	iro_sparc_SwitchJmp,
	iro_sparc_Srl,
	iro_sparc_fneg,
	iro_sparc_fsub,
	iro_sparc_last_generated,
	iro_sparc_last = iro_sparc_last_generated
} sparc_opcodes;

int is_sparc_irn(const ir_node *node);
int is_sparc_op(const ir_op *op);

int get_sparc_opcode_first(void);
int get_sparc_opcode_last(void);
int get_sparc_irn_opcode(const ir_node *node);
void sparc_create_opcodes(const arch_irn_ops_t *be_ops);
void sparc_free_opcodes(void);
extern ir_op *op_sparc_SubCCZero;
ir_op *get_op_sparc_SubCCZero(void);
int is_sparc_SubCCZero(const ir_node *n);
/**
 * construct SubCCZero node
 */
ir_node *new_bd_sparc_SubCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct SubCCZero node
 */
ir_node *new_bd_sparc_SubCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Sra;
ir_op *get_op_sparc_Sra(void);
int is_sparc_Sra(const ir_node *n);
/**
 * construct Sra node
 */
ir_node *new_bd_sparc_Sra_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Sra node
 */
ir_node *new_bd_sparc_Sra_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Ld;
ir_op *get_op_sparc_Ld(void);
int is_sparc_Ld(const ir_node *n);
/**
 * construct Ld node
 */
ir_node *new_bd_sparc_Ld_imm(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);
/**
 * construct Ld node
 */
ir_node *new_bd_sparc_Ld_reg(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *ptr2, ir_node *mem, ir_mode *ls_mode);

extern ir_op *op_sparc_fitof;
ir_op *get_op_sparc_fitof(void);
int is_sparc_fitof(const ir_node *n);
/**
 * construct fitof node
 */
ir_node *new_bd_sparc_fitof_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode);
/**
 * construct fitof node
 */
ir_node *new_bd_sparc_fitof_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode);
/**
 * construct fitof node
 */
ir_node *new_bd_sparc_fitof_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode);

extern ir_op *op_sparc_fadd;
ir_op *get_op_sparc_fadd(void);
int is_sparc_fadd(const ir_node *n);
/**
 * construct fadd node
 */
ir_node *new_bd_sparc_fadd_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fadd node
 */
ir_node *new_bd_sparc_fadd_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fadd node
 */
ir_node *new_bd_sparc_fadd_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);

extern ir_op *op_sparc_Start;
ir_op *get_op_sparc_Start(void);
int is_sparc_Start(const ir_node *n);
/**
 * construct Start node
 */
ir_node *new_bd_sparc_Start(dbg_info *dbgi, ir_node *block, int n_res);

extern ir_op *op_sparc_RestoreZero;
ir_op *get_op_sparc_RestoreZero(void);
int is_sparc_RestoreZero(const ir_node *n);
/**
 * construct RestoreZero node
 */
ir_node *new_bd_sparc_RestoreZero(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *frame_pointer);

extern ir_op *op_sparc_SetHi;
ir_op *get_op_sparc_SetHi(void);
int is_sparc_SetHi(const ir_node *n);
/**
 * construct SetHi node
 */
ir_node *new_bd_sparc_SetHi(dbg_info *dbgi, ir_node *block, ir_entity *entity, int32_t immediate_value);

extern ir_op *op_sparc_Xor;
ir_op *get_op_sparc_Xor(void);
int is_sparc_Xor(const ir_node *n);
/**
 * construct Xor node
 */
ir_node *new_bd_sparc_Xor_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Xor node
 */
ir_node *new_bd_sparc_Xor_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Or;
ir_op *get_op_sparc_Or(void);
int is_sparc_Or(const ir_node *n);
/**
 * construct Or node
 */
ir_node *new_bd_sparc_Or_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Or node
 */
ir_node *new_bd_sparc_Or_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Restore;
ir_op *get_op_sparc_Restore(void);
int is_sparc_Restore(const ir_node *n);
/**
 * construct Restore node
 */
ir_node *new_bd_sparc_Restore_imm(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *frame_pointer, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Restore node
 */
ir_node *new_bd_sparc_Restore_reg(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *frame_pointer, ir_node *left, ir_node *right);

extern ir_op *op_sparc_SubX_t;
ir_op *get_op_sparc_SubX_t(void);
int is_sparc_SubX_t(const ir_node *n);
/**
 * construct SubX_t node
 */
ir_node *new_bd_sparc_SubX_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *flags_input, ir_mode *mode);

extern ir_op *op_sparc_UMulh;
ir_op *get_op_sparc_UMulh(void);
int is_sparc_UMulh(const ir_node *n);
/**
 * construct UMulh node
 */
ir_node *new_bd_sparc_UMulh_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct UMulh node
 */
ir_node *new_bd_sparc_UMulh_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Ba;
ir_op *get_op_sparc_Ba(void);
int is_sparc_Ba(const ir_node *n);
/**
 * construct Ba node
 */
ir_node *new_bd_sparc_Ba(dbg_info *dbgi, ir_node *block);

extern ir_op *op_sparc_Cmp;
ir_op *get_op_sparc_Cmp(void);
int is_sparc_Cmp(const ir_node *n);
/**
 * construct Cmp node
 */
ir_node *new_bd_sparc_Cmp_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Cmp node
 */
ir_node *new_bd_sparc_Cmp_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_fftof;
ir_op *get_op_sparc_fftof(void);
int is_sparc_fftof(const ir_node *n);
/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_d_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode);
/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_q_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode);
/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_q_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode);
/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_s_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode);
/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_s_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode);
/**
 * construct fftof node
 */
ir_node *new_bd_sparc_fftof_d_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *src_mode, ir_mode *dest_mode);

extern ir_op *op_sparc_XNorCCZero;
ir_op *get_op_sparc_XNorCCZero(void);
int is_sparc_XNorCCZero(const ir_node *n);
/**
 * construct XNorCCZero node
 */
ir_node *new_bd_sparc_XNorCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct XNorCCZero node
 */
ir_node *new_bd_sparc_XNorCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Call;
ir_op *get_op_sparc_Call(void);
int is_sparc_Call(const ir_node *n);
/**
 * construct Call node
 */
ir_node *new_bd_sparc_Call_imm(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, ir_entity *entity, int32_t offset, bool aggregate_return);
/**
 * construct Call node
 */
ir_node *new_bd_sparc_Call_reg(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], int n_res, bool aggregate_return);

extern ir_op *op_sparc_AddX;
ir_op *get_op_sparc_AddX(void);
int is_sparc_AddX(const ir_node *n);
/**
 * construct AddX node
 */
ir_node *new_bd_sparc_AddX_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *carry, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct AddX node
 */
ir_node *new_bd_sparc_AddX_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *carry);

extern ir_op *op_sparc_SubSP;
ir_op *get_op_sparc_SubSP(void);
int is_sparc_SubSP(const ir_node *n);
/**
 * construct SubSP node
 */
ir_node *new_bd_sparc_SubSP_imm(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *mem, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct SubSP node
 */
ir_node *new_bd_sparc_SubSP_reg(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *size, ir_node *mem);

extern ir_op *op_sparc_Add;
ir_op *get_op_sparc_Add(void);
int is_sparc_Add(const ir_node *n);
/**
 * construct Add node
 */
ir_node *new_bd_sparc_Add_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Add node
 */
ir_node *new_bd_sparc_Add_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_SubCC;
ir_op *get_op_sparc_SubCC(void);
int is_sparc_SubCC(const ir_node *n);
/**
 * construct SubCC node
 */
ir_node *new_bd_sparc_SubCC_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct SubCC node
 */
ir_node *new_bd_sparc_SubCC_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Ldf;
ir_op *get_op_sparc_Ldf(void);
int is_sparc_Ldf(const ir_node *n);
/**
 * construct Ldf node
 */
ir_node *new_bd_sparc_Ldf_q(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);
/**
 * construct Ldf node
 */
ir_node *new_bd_sparc_Ldf_d(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);
/**
 * construct Ldf node
 */
ir_node *new_bd_sparc_Ldf_s(dbg_info *dbgi, ir_node *block, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);

extern ir_op *op_sparc_fdiv;
ir_op *get_op_sparc_fdiv(void);
int is_sparc_fdiv(const ir_node *n);
/**
 * construct fdiv node
 */
ir_node *new_bd_sparc_fdiv_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fdiv node
 */
ir_node *new_bd_sparc_fdiv_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fdiv node
 */
ir_node *new_bd_sparc_fdiv_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);

extern ir_op *op_sparc_AndN;
ir_op *get_op_sparc_AndN(void);
int is_sparc_AndN(const ir_node *n);
/**
 * construct AndN node
 */
ir_node *new_bd_sparc_AndN_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct AndN node
 */
ir_node *new_bd_sparc_AndN_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_fftoi;
ir_op *get_op_sparc_fftoi(void);
int is_sparc_fftoi(const ir_node *n);
/**
 * construct fftoi node
 */
ir_node *new_bd_sparc_fftoi_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode);
/**
 * construct fftoi node
 */
ir_node *new_bd_sparc_fftoi_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode);
/**
 * construct fftoi node
 */
ir_node *new_bd_sparc_fftoi_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_mode *fp_mode);

extern ir_op *op_sparc_XorCCZero;
ir_op *get_op_sparc_XorCCZero(void);
int is_sparc_XorCCZero(const ir_node *n);
/**
 * construct XorCCZero node
 */
ir_node *new_bd_sparc_XorCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct XorCCZero node
 */
ir_node *new_bd_sparc_XorCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_St;
ir_op *get_op_sparc_St(void);
int is_sparc_St(const ir_node *n);
/**
 * construct St node
 */
ir_node *new_bd_sparc_St_imm(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);
/**
 * construct St node
 */
ir_node *new_bd_sparc_St_reg(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *ptr2, ir_node *mem, ir_mode *ls_mode);

extern ir_op *op_sparc_MulCCZero;
ir_op *get_op_sparc_MulCCZero(void);
int is_sparc_MulCCZero(const ir_node *n);
/**
 * construct MulCCZero node
 */
ir_node *new_bd_sparc_MulCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct MulCCZero node
 */
ir_node *new_bd_sparc_MulCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Save;
ir_op *get_op_sparc_Save(void);
int is_sparc_Save(const ir_node *n);
/**
 * construct Save node
 */
ir_node *new_bd_sparc_Save_imm(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Save node
 */
ir_node *new_bd_sparc_Save_reg(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *increment);

extern ir_op *op_sparc_fbfcc;
ir_op *get_op_sparc_fbfcc(void);
int is_sparc_fbfcc(const ir_node *n);
/**
 * construct fbfcc node
 */
ir_node *new_bd_sparc_fbfcc(dbg_info *dbgi, ir_node *block, ir_node *flags, ir_relation relation);

extern ir_op *op_sparc_Sub;
ir_op *get_op_sparc_Sub(void);
int is_sparc_Sub(const ir_node *n);
/**
 * construct Sub node
 */
ir_node *new_bd_sparc_Sub_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Sub node
 */
ir_node *new_bd_sparc_Sub_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Mul;
ir_op *get_op_sparc_Mul(void);
int is_sparc_Mul(const ir_node *n);
/**
 * construct Mul node
 */
ir_node *new_bd_sparc_Mul_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Mul node
 */
ir_node *new_bd_sparc_Mul_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_SubCC_t;
ir_op *get_op_sparc_SubCC_t(void);
int is_sparc_SubCC_t(const ir_node *n);
/**
 * construct SubCC_t node
 */
ir_node *new_bd_sparc_SubCC_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Stf;
ir_op *get_op_sparc_Stf(void);
int is_sparc_Stf(const ir_node *n);
/**
 * construct Stf node
 */
ir_node *new_bd_sparc_Stf_q(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);
/**
 * construct Stf node
 */
ir_node *new_bd_sparc_Stf_d(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);
/**
 * construct Stf node
 */
ir_node *new_bd_sparc_Stf_s(dbg_info *dbgi, ir_node *block, ir_node *val, ir_node *ptr, ir_node *mem, ir_mode *ls_mode, ir_entity *entity, int32_t offset, bool is_frame_entity);

extern ir_op *op_sparc_SDiv;
ir_op *get_op_sparc_SDiv(void);
int is_sparc_SDiv(const ir_node *n);
/**
 * construct SDiv node
 */
ir_node *new_bd_sparc_SDiv_imm(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct SDiv node
 */
ir_node *new_bd_sparc_SDiv_reg(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_node *divisor);

extern ir_op *op_sparc_AddX_t;
ir_op *get_op_sparc_AddX_t(void);
int is_sparc_AddX_t(const ir_node *n);
/**
 * construct AddX_t node
 */
ir_node *new_bd_sparc_AddX_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *flags_input, ir_mode *mode);

extern ir_op *op_sparc_fabs;
ir_op *get_op_sparc_fabs(void);
int is_sparc_fabs(const ir_node *n);
/**
 * construct fabs node
 */
ir_node *new_bd_sparc_fabs_q(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode);
/**
 * construct fabs node
 */
ir_node *new_bd_sparc_fabs_d(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode);
/**
 * construct fabs node
 */
ir_node *new_bd_sparc_fabs_s(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode);

extern ir_op *op_sparc_AddCC;
ir_op *get_op_sparc_AddCC(void);
int is_sparc_AddCC(const ir_node *n);
/**
 * construct AddCC node
 */
ir_node *new_bd_sparc_AddCC_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct AddCC node
 */
ir_node *new_bd_sparc_AddCC_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Bicc;
ir_op *get_op_sparc_Bicc(void);
int is_sparc_Bicc(const ir_node *n);
/**
 * construct Bicc node
 */
ir_node *new_bd_sparc_Bicc(dbg_info *dbgi, ir_node *block, ir_node *flags, ir_relation relation, bool is_unsigned);

extern ir_op *op_sparc_OrN;
ir_op *get_op_sparc_OrN(void);
int is_sparc_OrN(const ir_node *n);
/**
 * construct OrN node
 */
ir_node *new_bd_sparc_OrN_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct OrN node
 */
ir_node *new_bd_sparc_OrN_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_SubX;
ir_op *get_op_sparc_SubX(void);
int is_sparc_SubX(const ir_node *n);
/**
 * construct SubX node
 */
ir_node *new_bd_sparc_SubX_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *carry, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct SubX node
 */
ir_node *new_bd_sparc_SubX_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_node *carry);

extern ir_op *op_sparc_fcmp;
ir_op *get_op_sparc_fcmp(void);
int is_sparc_fcmp(const ir_node *n);
/**
 * construct fcmp node
 */
ir_node *new_bd_sparc_fcmp_q(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *fp_mode);
/**
 * construct fcmp node
 */
ir_node *new_bd_sparc_fcmp_d(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *fp_mode);
/**
 * construct fcmp node
 */
ir_node *new_bd_sparc_fcmp_s(dbg_info *dbgi, ir_node *block, ir_node *op0, ir_node *op1, ir_mode *fp_mode);

extern ir_op *op_sparc_OrCCZero;
ir_op *get_op_sparc_OrCCZero(void);
int is_sparc_OrCCZero(const ir_node *n);
/**
 * construct OrCCZero node
 */
ir_node *new_bd_sparc_OrCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct OrCCZero node
 */
ir_node *new_bd_sparc_OrCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_AddSP;
ir_op *get_op_sparc_AddSP(void);
int is_sparc_AddSP(const ir_node *n);
/**
 * construct AddSP node
 */
ir_node *new_bd_sparc_AddSP(dbg_info *dbgi, ir_node *block, ir_node *stack, ir_node *size);

extern ir_op *op_sparc_SMulh;
ir_op *get_op_sparc_SMulh(void);
int is_sparc_SMulh(const ir_node *n);
/**
 * construct SMulh node
 */
ir_node *new_bd_sparc_SMulh_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct SMulh node
 */
ir_node *new_bd_sparc_SMulh_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_AddCC_t;
ir_op *get_op_sparc_AddCC_t(void);
int is_sparc_AddCC_t(const ir_node *n);
/**
 * construct AddCC_t node
 */
ir_node *new_bd_sparc_AddCC_t(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_Return;
ir_op *get_op_sparc_Return(void);
int is_sparc_Return(const ir_node *n);
/**
 * construct Return node
 */
ir_node *new_bd_sparc_Return_imm(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[], ir_entity *entity, int32_t offset);
/**
 * construct Return node
 */
ir_node *new_bd_sparc_Return_reg(dbg_info *dbgi, ir_node *block, int arity, ir_node *in[]);

extern ir_op *op_sparc_XNor;
ir_op *get_op_sparc_XNor(void);
int is_sparc_XNor(const ir_node *n);
/**
 * construct XNor node
 */
ir_node *new_bd_sparc_XNor_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct XNor node
 */
ir_node *new_bd_sparc_XNor_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_AndNCCZero;
ir_op *get_op_sparc_AndNCCZero(void);
int is_sparc_AndNCCZero(const ir_node *n);
/**
 * construct AndNCCZero node
 */
ir_node *new_bd_sparc_AndNCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct AndNCCZero node
 */
ir_node *new_bd_sparc_AndNCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_AndCCZero;
ir_op *get_op_sparc_AndCCZero(void);
int is_sparc_AndCCZero(const ir_node *n);
/**
 * construct AndCCZero node
 */
ir_node *new_bd_sparc_AndCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct AndCCZero node
 */
ir_node *new_bd_sparc_AndCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_FrameAddr;
ir_op *get_op_sparc_FrameAddr(void);
int is_sparc_FrameAddr(const ir_node *n);
/**
 * construct FrameAddr node
 */
ir_node *new_bd_sparc_FrameAddr(dbg_info *dbgi, ir_node *block, ir_node *base, ir_entity *entity, int32_t offset);

extern ir_op *op_sparc_OrNCCZero;
ir_op *get_op_sparc_OrNCCZero(void);
int is_sparc_OrNCCZero(const ir_node *n);
/**
 * construct OrNCCZero node
 */
ir_node *new_bd_sparc_OrNCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct OrNCCZero node
 */
ir_node *new_bd_sparc_OrNCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_And;
ir_op *get_op_sparc_And(void);
int is_sparc_And(const ir_node *n);
/**
 * construct And node
 */
ir_node *new_bd_sparc_And_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct And node
 */
ir_node *new_bd_sparc_And_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_fmul;
ir_op *get_op_sparc_fmul(void);
int is_sparc_fmul(const ir_node *n);
/**
 * construct fmul node
 */
ir_node *new_bd_sparc_fmul_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fmul node
 */
ir_node *new_bd_sparc_fmul_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fmul node
 */
ir_node *new_bd_sparc_fmul_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);

extern ir_op *op_sparc_AddCCZero;
ir_op *get_op_sparc_AddCCZero(void);
int is_sparc_AddCCZero(const ir_node *n);
/**
 * construct AddCCZero node
 */
ir_node *new_bd_sparc_AddCCZero_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct AddCCZero node
 */
ir_node *new_bd_sparc_AddCCZero_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_UDiv;
ir_op *get_op_sparc_UDiv(void);
int is_sparc_UDiv(const ir_node *n);
/**
 * construct UDiv node
 */
ir_node *new_bd_sparc_UDiv_imm(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct UDiv node
 */
ir_node *new_bd_sparc_UDiv_reg(dbg_info *dbgi, ir_node *block, ir_node *dividend_high, ir_node *dividend_low, ir_node *divisor);

extern ir_op *op_sparc_Sll;
ir_op *get_op_sparc_Sll(void);
int is_sparc_Sll(const ir_node *n);
/**
 * construct Sll node
 */
ir_node *new_bd_sparc_Sll_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Sll node
 */
ir_node *new_bd_sparc_Sll_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_SwitchJmp;
ir_op *get_op_sparc_SwitchJmp(void);
int is_sparc_SwitchJmp(const ir_node *n);
/**
 * construct SwitchJmp node
 */
ir_node *new_bd_sparc_SwitchJmp(dbg_info *dbgi, ir_node *block, ir_node *op0, int n_res, const ir_switch_table *table, ir_entity *jump_table);

extern ir_op *op_sparc_Srl;
ir_op *get_op_sparc_Srl(void);
int is_sparc_Srl(const ir_node *n);
/**
 * construct Srl node
 */
ir_node *new_bd_sparc_Srl_imm(dbg_info *dbgi, ir_node *block, ir_node *left, ir_entity *immediate_entity, int32_t immediate_value);
/**
 * construct Srl node
 */
ir_node *new_bd_sparc_Srl_reg(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right);

extern ir_op *op_sparc_fneg;
ir_op *get_op_sparc_fneg(void);
int is_sparc_fneg(const ir_node *n);
/**
 * construct fneg node
 */
ir_node *new_bd_sparc_fneg_q(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode);
/**
 * construct fneg node
 */
ir_node *new_bd_sparc_fneg_d(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode);
/**
 * construct fneg node
 */
ir_node *new_bd_sparc_fneg_s(dbg_info *dbgi, ir_node *block, ir_node *val, ir_mode *fp_mode);

extern ir_op *op_sparc_fsub;
ir_op *get_op_sparc_fsub(void);
int is_sparc_fsub(const ir_node *n);
/**
 * construct fsub node
 */
ir_node *new_bd_sparc_fsub_q(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fsub node
 */
ir_node *new_bd_sparc_fsub_d(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);
/**
 * construct fsub node
 */
ir_node *new_bd_sparc_fsub_s(dbg_info *dbgi, ir_node *block, ir_node *left, ir_node *right, ir_mode *fp_mode);



enum pn_sparc_Ld {
	pn_sparc_Ld_res = 0,
	pn_sparc_Ld_M = 1,
};

enum n_sparc_Ld {
	n_sparc_Ld_ptr = 0,
	n_sparc_Ld_mem = 1,
};

enum n_sparc_fadd {
	n_sparc_fadd_left = 0,
	n_sparc_fadd_right = 1,
};

enum pn_sparc_RestoreZero {
	pn_sparc_RestoreZero_stack = 0,
};

enum n_sparc_RestoreZero {
	n_sparc_RestoreZero_stack = 0,
	n_sparc_RestoreZero_frame_pointer = 1,
};

enum pn_sparc_SetHi {
	pn_sparc_SetHi_res = 0,
};

enum pn_sparc_Restore {
	pn_sparc_Restore_stack = 0,
	pn_sparc_Restore_res = 1,
};

enum n_sparc_SubX_t {
	n_sparc_SubX_t_left = 0,
	n_sparc_SubX_t_right = 1,
	n_sparc_SubX_t_flags_input = 2,
};

enum pn_sparc_UMulh {
	pn_sparc_UMulh_low = 0,
	pn_sparc_UMulh_high = 1,
};

enum pn_sparc_SubSP {
	pn_sparc_SubSP_stack = 0,
	pn_sparc_SubSP_addr = 1,
	pn_sparc_SubSP_M = 2,
};

enum pn_sparc_SubCC {
	pn_sparc_SubCC_res = 0,
	pn_sparc_SubCC_flags = 1,
};

enum pn_sparc_Ldf {
	pn_sparc_Ldf_res = 0,
	pn_sparc_Ldf_M = 1,
};

enum n_sparc_Ldf {
	n_sparc_Ldf_ptr = 0,
	n_sparc_Ldf_mem = 1,
};

enum pn_sparc_fdiv {
	pn_sparc_fdiv_res = 0,
	pn_sparc_fdiv_M = 1,
};

enum n_sparc_fdiv {
	n_sparc_fdiv_left = 0,
	n_sparc_fdiv_right = 1,
};

enum pn_sparc_St {
	pn_sparc_St_M = 0,
};

enum n_sparc_St {
	n_sparc_St_val = 0,
	n_sparc_St_ptr = 1,
	n_sparc_St_mem = 2,
};

enum pn_sparc_Save {
	pn_sparc_Save_stack = 0,
};

enum n_sparc_Save {
	n_sparc_Save_stack = 0,
};

enum pn_sparc_fbfcc {
	pn_sparc_fbfcc_false = 0,
	pn_sparc_fbfcc_true = 1,
};

enum n_sparc_fbfcc {
	n_sparc_fbfcc_flags = 0,
};

enum pn_sparc_SubCC_t {
	pn_sparc_SubCC_t_res = 0,
	pn_sparc_SubCC_t_flags = 1,
};

enum n_sparc_SubCC_t {
	n_sparc_SubCC_t_left = 0,
	n_sparc_SubCC_t_right = 1,
};

enum pn_sparc_Stf {
	pn_sparc_Stf_M = 0,
};

enum n_sparc_Stf {
	n_sparc_Stf_val = 0,
	n_sparc_Stf_ptr = 1,
	n_sparc_Stf_mem = 2,
};

enum pn_sparc_SDiv {
	pn_sparc_SDiv_res = 0,
	pn_sparc_SDiv_M = 1,
};

enum n_sparc_SDiv {
	n_sparc_SDiv_dividend_high = 0,
	n_sparc_SDiv_dividend_low = 1,
	n_sparc_SDiv_divisor = 2,
};

enum n_sparc_AddX_t {
	n_sparc_AddX_t_left = 0,
	n_sparc_AddX_t_right = 1,
	n_sparc_AddX_t_flags_input = 2,
};

enum n_sparc_fabs {
	n_sparc_fabs_val = 0,
};

enum pn_sparc_AddCC {
	pn_sparc_AddCC_res = 0,
	pn_sparc_AddCC_flags = 1,
};

enum pn_sparc_Bicc {
	pn_sparc_Bicc_false = 0,
	pn_sparc_Bicc_true = 1,
};

enum n_sparc_Bicc {
	n_sparc_Bicc_flags = 0,
};

enum pn_sparc_AddSP {
	pn_sparc_AddSP_stack = 0,
};

enum n_sparc_AddSP {
	n_sparc_AddSP_stack = 0,
	n_sparc_AddSP_size = 1,
};

enum pn_sparc_SMulh {
	pn_sparc_SMulh_low = 0,
	pn_sparc_SMulh_high = 1,
};

enum pn_sparc_AddCC_t {
	pn_sparc_AddCC_t_res = 0,
	pn_sparc_AddCC_t_flags = 1,
};

enum n_sparc_AddCC_t {
	n_sparc_AddCC_t_left = 0,
	n_sparc_AddCC_t_right = 1,
};

enum n_sparc_FrameAddr {
	n_sparc_FrameAddr_base = 0,
};

enum n_sparc_fmul {
	n_sparc_fmul_left = 0,
	n_sparc_fmul_right = 1,
};

enum pn_sparc_UDiv {
	pn_sparc_UDiv_res = 0,
	pn_sparc_UDiv_M = 1,
};

enum n_sparc_UDiv {
	n_sparc_UDiv_dividend_high = 0,
	n_sparc_UDiv_dividend_low = 1,
	n_sparc_UDiv_divisor = 2,
};

enum n_sparc_fneg {
	n_sparc_fneg_val = 0,
};

enum n_sparc_fsub {
	n_sparc_fsub_left = 0,
	n_sparc_fsub_right = 1,
};


#endif
