/*
 * Copyright (C) 1995-2008 University of Karlsruhe.  All right reserved.
 *
 * This file is part of libFirm.
 *
 * This file may be distributed and/or modified under the terms of the
 * GNU General Public License version 2 as published by the Free Software
 * Foundation and appearing in the file LICENSE.GPL included in the
 * packaging of this file.
 *
 * Licensees holding valid libFirm Professional Edition licenses may use
 * this file in accordance with the libFirm Commercial License.
 * Agreement provided with the Software.
 *
 * This file is provided AS IS with NO WARRANTY OF ANY KIND, INCLUDING THE
 * WARRANTY OF DESIGN, MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE.
 */

/**
 * @file
 * @brief       Chordal register allocation.
 * @author      Sebastian Hack
 * @date        14.12.2004
 */
#ifndef FIRM_BE_BECHORDAL_H
#define FIRM_BE_BECHORDAL_H

typedef struct be_chordal_env_t     be_chordal_env_t;
typedef struct be_ra_chordal_opts_t be_ra_chordal_opts_t;
typedef struct border_t             border_t;

typedef struct be_ra_chordal_coloring_t {
	void (*allocate)(be_chordal_env_t *env);
} be_ra_chordal_coloring_t;

void be_register_chordal_coloring(const char *name, be_ra_chordal_coloring_t *coloring);

#endif /* FIRM_BE_BECHORDAL_H */
