/**
 * @file
 * @brief  The generated interface for the register allocator.
 *          Contains register classes and types and register constraints
 *          for all nodes where constraints were given in spec.
 * @note    DO NOT EDIT THIS FILE, your changes will be lost.
 *          Edit ir/be/amd64/amd64_spec.pl instead.
 *          created by: ir/be/scripts/generate_regalloc_if.pl ir/be/amd64/amd64_spec.pl ir/be/amd64
 * $date    Mon Nov 19 18:12:23 2012
 */
#include "config.h"

#include "gen_amd64_regalloc_if.h"
#include "bearch_amd64_t.h"
#include "irmode.h"

static const arch_register_req_t amd64_class_reg_req_flags = {
	arch_register_req_type_normal,
	&amd64_reg_classes[CLASS_amd64_flags],
	NULL,
	0,
	0,
	1
};
static const unsigned amd64_limited_flags_eflags [] = { (1 << REG_FLAGS_EFLAGS) };
static const arch_register_req_t amd64_single_reg_req_flags_eflags = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_flags],
	amd64_limited_flags_eflags,
	0,
	0,
	1
};
static const arch_register_req_t amd64_class_reg_req_gp = {
	arch_register_req_type_normal,
	&amd64_reg_classes[CLASS_amd64_gp],
	NULL,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rax [] = { (1 << REG_GP_RAX) };
static const arch_register_req_t amd64_single_reg_req_gp_rax = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rax,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rcx [] = { (1 << REG_GP_RCX) };
static const arch_register_req_t amd64_single_reg_req_gp_rcx = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rcx,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rdx [] = { (1 << REG_GP_RDX) };
static const arch_register_req_t amd64_single_reg_req_gp_rdx = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rdx,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rsi [] = { (1 << REG_GP_RSI) };
static const arch_register_req_t amd64_single_reg_req_gp_rsi = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rsi,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rdi [] = { (1 << REG_GP_RDI) };
static const arch_register_req_t amd64_single_reg_req_gp_rdi = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rdi,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rbx [] = { (1 << REG_GP_RBX) };
static const arch_register_req_t amd64_single_reg_req_gp_rbx = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rbx,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rbp [] = { (1 << REG_GP_RBP) };
static const arch_register_req_t amd64_single_reg_req_gp_rbp = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rbp,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_rsp [] = { (1 << REG_GP_RSP) };
static const arch_register_req_t amd64_single_reg_req_gp_rsp = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_rsp,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r8 [] = { (1 << REG_GP_R8) };
static const arch_register_req_t amd64_single_reg_req_gp_r8 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r8,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r9 [] = { (1 << REG_GP_R9) };
static const arch_register_req_t amd64_single_reg_req_gp_r9 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r9,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r10 [] = { (1 << REG_GP_R10) };
static const arch_register_req_t amd64_single_reg_req_gp_r10 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r10,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r11 [] = { (1 << REG_GP_R11) };
static const arch_register_req_t amd64_single_reg_req_gp_r11 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r11,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r12 [] = { (1 << REG_GP_R12) };
static const arch_register_req_t amd64_single_reg_req_gp_r12 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r12,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r13 [] = { (1 << REG_GP_R13) };
static const arch_register_req_t amd64_single_reg_req_gp_r13 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r13,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r14 [] = { (1 << REG_GP_R14) };
static const arch_register_req_t amd64_single_reg_req_gp_r14 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r14,
	0,
	0,
	1
};
static const unsigned amd64_limited_gp_r15 [] = { (1 << REG_GP_R15) };
static const arch_register_req_t amd64_single_reg_req_gp_r15 = {
	arch_register_req_type_limited,
	&amd64_reg_classes[CLASS_amd64_gp],
	amd64_limited_gp_r15,
	0,
	0,
	1
};

arch_register_class_t amd64_reg_classes[] = {
	{ 0, "amd64_flags", 1, NULL, &amd64_registers[REG_EFLAGS], arch_register_class_flag_manual_ra, &amd64_class_reg_req_flags },
	{ 1, "amd64_gp", 16, NULL, &amd64_registers[REG_RAX], arch_register_class_flag_none, &amd64_class_reg_req_gp }
};


/** The array of all registers in the amd64 architecture, sorted by its global index.*/
const arch_register_t amd64_registers[] = {
	{
		"eflags",
		&amd64_reg_classes[CLASS_amd64_flags],
		REG_FLAGS_EFLAGS,
		REG_EFLAGS,
		arch_register_type_none,
		&amd64_single_reg_req_flags_eflags,
		49
	},
	{
		"rax",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RAX,
		REG_RAX,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rax,
		0
	},
	{
		"rcx",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RCX,
		REG_RCX,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rcx,
		2
	},
	{
		"rdx",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RDX,
		REG_RDX,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rdx,
		1
	},
	{
		"rsi",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RSI,
		REG_RSI,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rsi,
		4
	},
	{
		"rdi",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RDI,
		REG_RDI,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rdi,
		5
	},
	{
		"rbx",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RBX,
		REG_RBX,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rbx,
		3
	},
	{
		"rbp",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RBP,
		REG_RBP,
		arch_register_type_none,
		&amd64_single_reg_req_gp_rbp,
		6
	},
	{
		"rsp",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_RSP,
		REG_RSP,
		arch_register_type_ignore,
		&amd64_single_reg_req_gp_rsp,
		7
	},
	{
		"r8",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R8,
		REG_R8,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r8,
		8
	},
	{
		"r9",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R9,
		REG_R9,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r9,
		9
	},
	{
		"r10",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R10,
		REG_R10,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r10,
		10
	},
	{
		"r11",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R11,
		REG_R11,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r11,
		11
	},
	{
		"r12",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R12,
		REG_R12,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r12,
		12
	},
	{
		"r13",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R13,
		REG_R13,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r13,
		13
	},
	{
		"r14",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R14,
		REG_R14,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r14,
		14
	},
	{
		"r15",
		&amd64_reg_classes[CLASS_amd64_gp],
		REG_GP_R15,
		REG_R15,
		arch_register_type_none,
		&amd64_single_reg_req_gp_r15,
		15
	},

};

/**
 * Initializes amd64 register classes.
 */
void amd64_register_init(void)
{
	amd64_reg_classes[CLASS_amd64_flags].mode = mode_Iu;
	amd64_reg_classes[CLASS_amd64_gp].mode = mode_Lu;

}
