/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */

#ifndef DS_PARAMS_H
#define DS_PARAMS_H
 
#include <DSCore.h>
#include <DSHashTable.h>
/*!
 * @header DSParams
 * @discussion The Params class is designed to make it simple to parse command-line arguments into meaningful information.
 */

/*!
 * @class DSParams : public DSHashTable
 * @discussion The Params class is designed to make it simple to parse command-line arguments into meaningful information.
 */
class EXPSYM DSParams:public DSHashTable {
	private:
		unsigned int lsmask;
		unsigned int lfmask;
	public:
		/*!
		 * @function DSParams
		 * @discussion Create a new Params class.
		 */
		DSParams();

		/*!
		 * @function setFlagSwitch
		 * @discussion A flag argument is one which is either present or it isn't: a true/false combination.  This function registers that the application knows how to handle the specified character as a flag parameter.
		 * @param c A character which is recognised as a flag argument.
		 * @result Returns TRUE for success and FALSE for failure.
		 */
		BOOL setFlagSwitch(char c);
		DEPRECATED int setFlagArg(char c);
		/*!
		 * @function setStringSwitch
		 * @discussion A string argument is one which contains its own data: A filename or pathname, something where data is passed on the command line.  This function registers that an application knows how to handle the specified character as a string parameter.
		 * @param c A character which is recognised as a string argument.
		 * @result Returns TRUE for success and FALSE for failure.
		 */
		BOOL setStringSwitch(char c);
		DEPRECATED int setStringArg(char c);

		/*!
		 * @function process
		 * @discussion This function parses the parameters that have been previously registered using setFlagSwitch or setStringSwitch.  These are entered into the HashTable which this class extends.  To obtain the value of a parameter after parsing, use getNumericValue for flag arguments and getPtrValue for string arguments.  Data passed without a flag is entered with a key of 0.
		 * @param argc argc from main()
		 * @param argv argv from main()
		 * @result Returns TRUE for success and FALSE for failure.
		 */
		BOOL process(int argc, char * argv[]);
		DEPRECATED int Process(int argc, char * argv[]);
		/*!
		 * @function process
		 * @discussion This function parses the parameters that have been previously registered using setFlagSwitch or setStringSwitch.  These are entered into the HashTable which this class extends.  To obtain the value of a parameter after parsing, use getNumericValue for flag arguments and getPtrValue for string arguments.  Data passed without a flag is entered with a key of 0.
		 * @param arg The complete command line, which is all some OSes give you.
		 * @result Returns TRUE for success and FALSE for failure.
		 */
		BOOL process(char * arg);
		DEPRECATED int Process(char * arg);
};

#endif
