/* LIBDS
 * =====
 * This software is Copyright (c) 2002-03 Malcolm Smith.
 * No warranty is provided, including but not limited to
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * This code is licenced subject to the GNU General
 * Public Licence (GPL).  See the COPYING file for more.
 */
#ifndef WIN32_NO_CONFIG_H
#include "../config.h"
#else
#include "../winconf.h"
#endif
#include "DSListElement.h"
#ifdef HAVE_STDIO_H
#include <stdio.h>
#endif

DSListElement::DSListElement(int newCleanup)
{
	flags=0;
	setDataPtr(NULL);
	setKeyInt(0U);
	setNext(NULL);
	setCleanup(newCleanup);
}

DSListElement::DSListElement(DSListElement * le)
{
	flags=le->flags;
	pData=le->pData;
	nData=le->nData;
	strKey=le->strKey;
	nKey=le->nKey;
	next=le->next;
}

DSListElement::DSListElement(char* newKey, void* newData,
		DSListElement* newNext,int newCleanup)
{
	flags=0;
	setKeyString(newKey);
	setDataPtr(newData);
	setNext(newNext);
	setCleanup(newCleanup);
}

DSListElement::DSListElement(unsigned int newKey, void* newData,
		DSListElement* newNext,int newCleanup)
{
	flags=0;
	setKeyInt(newKey);
	setDataPtr(newData);
	setNext(newNext);
	setCleanup(newCleanup);
}

DSListElement::DSListElement(char* newKey, unsigned int newData,
		DSListElement* newNext,int newCleanup)
{
	flags=0;
	setKeyString(newKey);
	setDataInt(newData);
	setNext(newNext);
	setCleanup(newCleanup);
}

DSListElement::DSListElement(unsigned int newKey, unsigned int newData,
		DSListElement* newNext,int newCleanup)
{
	flags=0;
	setKeyInt(newKey);
	setDataInt(newData);
	setNext(newNext);
	setCleanup(newCleanup);
}

DSListElement::~DSListElement()
{
	cleanupKey();
	cleanupData();
}

void DSListElement::cleanupData()
{
	if (flags&VALUETYPE_STRING) {
		if ((flags&CLEANUP_VALUE_FREE)&&pData) {
			free(pData);
		}
	}
}

void DSListElement::cleanupKey()
{
	if (flags&KEYTYPE_STRING) {
		if ((flags&CLEANUP_KEY_FREE)&&strKey) {
			free(strKey);
		}
		if ((flags&CLEANUP_KEY_DELETE)&&strKey) {
			delete strKey;
		}
	}
}

void* DSListElement::getDataPtr()
{
	if (flags&VALUETYPE_STRING) {
		return(pData);
	} else {
		return NULL;
	}
}

unsigned int DSListElement::getDataInt()
{
	if ((~flags)&VALUETYPE_STRING) {
		return(nData);
	} else {
		return 0;
	}
}

char * DSListElement::getKeyString()
{
	if (flags&KEYTYPE_STRING) {
		return strKey;
	} else {
		return NULL;
	}
}

unsigned int DSListElement::getKeyInt()
{
	if ((~flags)&KEYTYPE_STRING) {
		return nKey;
	} else {
		return 0;
	}
}

DSListElement* DSListElement::getNext()
{
	return(next);
}

void DSListElement::setCleanup(int newCleanup)
{
	newCleanup=newCleanup&CLEANUP_ALL;
	flags=flags&(~CLEANUP_ALL);
	flags=flags|newCleanup;
}

void DSListElement::setDataInt(unsigned int newData)
{
	cleanupData();
	nData=newData;
	flags=flags&(~VALUETYPE_STRING);
}

void DSListElement::setDataPtr(void* newData)
{
	cleanupData();
	pData=newData;
	flags=flags|VALUETYPE_STRING;
}

void DSListElement::setKeyString(char* newKey)
{
	cleanupKey();
	strKey=newKey;
	flags=flags|KEYTYPE_STRING;
}

void DSListElement::setKeyInt(unsigned int newKey)
{
	cleanupKey();
	nKey=newKey;
	flags=flags&(~KEYTYPE_STRING);
}

void DSListElement::setNext(DSListElement* newNext)
{
	next=newNext;
}
