/* libdmapsharing-3.0-daap.vapi generated by vapigen, do not modify. */

namespace DAAP {
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class ChunkData {
		public weak Soup.Server server;
		public weak GLib.InputStream stream;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Connection : DAAP.DMAPConnection {
		[CCode (has_construct_function = false)]
		public Connection (string name, string host, uint port, DMAP.Db db, DMAP.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPConnection : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DMAPConnection ();
		[CCode (cname = "dmap_connection_authenticate_message")]
		public static void authenticate_message (DAAP.DMAPConnection connection, Soup.Session session, Soup.Message message, Soup.Auth auth, string password);
		[CCode (cname = "dmap_connection_build_message")]
		public virtual unowned Soup.Message build_message (DAAP.DMAPConnection connection, string path, bool need_hash, double version, int req_id, bool send_close);
		[CCode (cname = "dmap_connection_connect")]
		public static void connect (DAAP.DMAPConnection connection, DAAP.DMAPConnectionCallback callback);
		[CCode (cname = "dmap_connection_disconnect")]
		public static void disconnect (DAAP.DMAPConnection connection, DAAP.DMAPConnectionCallback callback);
		[CCode (cname = "dmap_connection_get")]
		public bool @get (string path, bool need_hash, DAAP.DMAPResponseHandler handler);
		[CCode (cname = "dmap_connection_get_headers")]
		public static unowned Soup.MessageHeaders get_headers (DAAP.DMAPConnection connection, string uri);
		[CCode (cname = "dmap_connection_get_playlists")]
		public static unowned GLib.SList get_playlists (DAAP.DMAPConnection connection);
		[NoWrapper]
		public virtual DAAP.DMAPContentCode get_protocol_version_cc (DAAP.DMAPConnection connection);
		[NoWrapper]
		public virtual unowned string get_query_metadata (DAAP.DMAPConnection connection);
		[NoWrapper]
		public virtual unowned DAAP.DMAPRecord handle_mlcl (DAAP.DMAPConnection connection, DMAP.RecordFactory factory, GLib.Node mlcl, int item_id);
		[CCode (cname = "dmap_connection_is_connected")]
		public static bool is_connected (DAAP.DMAPConnection connection);
		[CCode (cname = "dmap_connection_setup")]
		public static void setup (DAAP.DMAPConnection connection);
		[NoAccessorMethod]
		public void* base_uri { get; set; }
		[NoAccessorMethod]
		public int database_id { get; set; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public double dmap_version { get; set; }
		[NoAccessorMethod]
		public void* factory { get; construct; }
		[NoAccessorMethod]
		public string host { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public string password { set; }
		[NoAccessorMethod]
		public uint port { get; construct; }
		[NoAccessorMethod]
		public int revision_number { get; set; }
		[NoAccessorMethod]
		public int session_id { get; set; }
		[NoAccessorMethod]
		public string username { owned get; construct; }
		public virtual signal void authenticate (string name, Soup.Session p1, Soup.Message p2, Soup.Auth p3, bool p4);
		public virtual signal void connected ();
		public virtual signal void connecting (ulong state, float progress);
		public virtual signal void disconnected ();
		public virtual signal void operation_done ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPContentCodeDefinition {
		public DAAP.DMAPContentCode code;
		public int32 int_code;
		public weak string name;
		[CCode (cname = "string")]
		public weak string str;
		public DAAP.DMAPType type;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPDbFilterDefinition {
		public weak string key;
		public bool negate;
		public weak string value;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstInputStream : GLib.InputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstInputStream (string transcode_mimetype, GLib.InputStream src_stream);
		[NoWrapper]
		public virtual void kill_pipeline (DAAP.DMAPGstInputStream p1);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstMP3InputStream : DAAP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_mp3_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstMP3InputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstQtInputStream : DAAP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_qt_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstQtInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstWAVInputStream : DAAP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_wav_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstWAVInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPHashContext {
		[CCode (array_length = false)]
		public weak uint32[] bits;
		[CCode (array_length = false)]
		public weak uint32[] buf;
		[CCode (array_length = false)]
		public weak uint[] @in;
		public int version;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPMdnsBrowser : GLib.Object {
		[CCode (cname = "dmap_mdns_browser_new", has_construct_function = false, type = "DMAPMdnsBrowser*")]
		public DMAPMdnsBrowser (DAAP.DMAPMdnsBrowserServiceType type);
		[CCode (cname = "dmap_mdns_browser_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "dmap_mdns_browser_get_service_type")]
		public static DAAP.DMAPMdnsBrowserServiceType get_service_type (DAAP.DMAPMdnsBrowser browser);
		[CCode (cname = "dmap_mdns_browser_get_services")]
		public static unowned GLib.SList get_services (DAAP.DMAPMdnsBrowser browser);
		[CCode (cname = "dmap_mdns_browser_start")]
		public static bool start (DAAP.DMAPMdnsBrowser browser) throws GLib.Error;
		[CCode (cname = "dmap_mdns_browser_stop")]
		public static bool stop (DAAP.DMAPMdnsBrowser browser) throws GLib.Error;
		public virtual signal void service_added (void* service);
		public virtual signal void service_removed (string service);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPMdnsBrowserService {
		public weak string host;
		public weak string name;
		public weak string pair;
		public bool password_protected;
		public uint port;
		public weak string service_name;
		public DAAP.DMAPMdnsBrowserTransportProtocol transport_protocol;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPMdnsPublisher : GLib.Object {
		[CCode (cname = "dmap_mdns_publisher_new", has_construct_function = false, type = "DMAPMdnsPublisher*")]
		public DMAPMdnsPublisher ();
		[CCode (cname = "dmap_mdns_publisher_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "dmap_mdns_publisher_publish")]
		public static bool publish (DAAP.DMAPMdnsPublisher publisher, string name, uint port, string type_of_service, bool password_required, string txt_records) throws GLib.Error;
		[CCode (cname = "dmap_mdns_publisher_rename_at_port")]
		public static bool rename_at_port (DAAP.DMAPMdnsPublisher publisher, uint port, string name) throws GLib.Error;
		[CCode (cname = "dmap_mdns_publisher_withdraw")]
		public static bool withdraw (DAAP.DMAPMdnsPublisher publisher, uint port) throws GLib.Error;
		public virtual signal void name_collision (string name);
		public virtual signal void published (string name);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPMetaDataMap {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPPlaylist {
		public int id;
		public weak string name;
		public weak GLib.List uris;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPShare : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DMAPShare ();
		[NoWrapper]
		public virtual void add_entry_to_mlcl (void* id, DAAP.DMAPRecord record, void* mb);
		[NoWrapper]
		public virtual void content_codes (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void ctrl_int (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void databases (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_browse_xxx (DAAP.DMAPShare share, Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_items_xxx (DAAP.DMAPShare share, Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[CCode (cname = "dmap_share_free_filter")]
		public static void free_filter (GLib.SList filter);
		[NoWrapper]
		public virtual uint get_desired_port (DAAP.DMAPShare share);
		[NoWrapper]
		public virtual void* get_meta_data_map (DAAP.DMAPShare share);
		[NoWrapper]
		public virtual unowned string get_type_of_service (DAAP.DMAPShare share);
		[NoWrapper]
		public virtual void login (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void logout (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void message_add_standard_headers (DAAP.DMAPShare share, Soup.Message msg);
		[NoWrapper]
		public virtual void name_collision (DAAP.DMAPShare share, DAAP.DMAPMdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void published (DAAP.DMAPShare share, DAAP.DMAPMdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void server_info (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void update (DAAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoAccessorMethod]
		public uint auth_method { get; set; }
		[NoAccessorMethod]
		public void* container_db { get; construct; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint revision_number { get; set; }
		[NoAccessorMethod]
		public Soup.Server server_ipv4 { owned get; }
		[NoAccessorMethod]
		public Soup.Server server_ipv6 { owned get; }
		[NoAccessorMethod]
		public string transcode_mimetype { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] txt_records { owned get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPStructureItem {
		public GLib.Value content;
		public DAAP.DMAPContentCode content_code;
		public uint32 size;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Share : DAAP.DMAPShare {
		[CCode (has_construct_function = false)]
		public Share (string name, string password, DMAP.Db db, DMAP.ContainerDb container_db, string transcode_mimetype);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class bitwise {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPContainerDb : GLib.Object {
		[CCode (cname = "dmap_container_db_add")]
		public abstract void add (DMAP.ContainerDb db, DAAP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_db_count")]
		public abstract int64 count (DMAP.ContainerDb db);
		[CCode (cname = "dmap_container_db_foreach")]
		public abstract void @foreach (DMAP.ContainerDb db, GLib.HFunc func, void* data);
		[CCode (cname = "dmap_container_db_lookup_by_id")]
		public abstract unowned DAAP.DMAPContainerRecord lookup_by_id (DMAP.ContainerDb db, uint id);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPContainerRecord {
		[CCode (cname = "dmap_container_record_add_entry")]
		public abstract void add_entry (DAAP.DMAPContainerRecord container_record, DAAP.DMAPRecord record, int id);
		[CCode (cname = "dmap_container_record_get_entries")]
		public abstract unowned DMAP.Db get_entries (DAAP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_record_get_entry_count")]
		public abstract uint64 get_entry_count (DAAP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_record_get_id")]
		public abstract uint get_id (DAAP.DMAPContainerRecord record);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPDb : GLib.Object {
		[CCode (cname = "dmap_db_add")]
		public abstract uint add (DMAP.Db db, DAAP.DMAPRecord record);
		[CCode (cname = "dmap_db_add_path")]
		public abstract uint add_path (DMAP.Db db, string path);
		[CCode (cname = "dmap_db_add_with_id")]
		public abstract uint add_with_id (DMAP.Db db, DAAP.DMAPRecord record, uint id);
		[CCode (cname = "dmap_db_apply_filter")]
		public static unowned GLib.HashTable apply_filter (DMAP.Db db, GLib.SList filter_def);
		[CCode (cname = "dmap_db_count")]
		public abstract int64 count (DMAP.Db db);
		[CCode (cname = "dmap_db_foreach")]
		public abstract void @foreach (DMAP.Db db, GLib.HFunc func, void* data);
		[CCode (cname = "dmap_db_lookup_by_id")]
		public abstract unowned DAAP.DMAPRecord lookup_by_id (DMAP.Db db, uint id);
		[CCode (cname = "dmap_db_lookup_id_by_location")]
		public abstract uint lookup_id_by_location (DMAP.Db db, string location);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPRecord : GLib.Object {
		[CCode (cname = "dmap_record_set_from_blob")]
		public abstract bool set_from_blob (DAAP.DMAPRecord record, GLib.ByteArray blob);
		[CCode (cname = "dmap_record_to_blob")]
		public abstract unowned GLib.ByteArray to_blob (DAAP.DMAPRecord record);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPRecordFactory {
		[CCode (cname = "dmap_record_factory_create")]
		public abstract unowned DAAP.DMAPRecord create (DMAP.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface Record {
		public static int cmp_by_album (void* a, void* b, DMAP.Db db);
		public abstract bool itunes_compat ();
		public abstract unowned GLib.InputStream read () throws GLib.Error;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_PLAY_")]
	public enum DACPPlayState {
		STOPPED,
		PAUSED,
		PLAYING
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_REPEAT_")]
	public enum DACPRepeatState {
		NONE,
		SINGLE,
		ALL
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_")]
	public enum DMAPConnectionState {
		GET_INFO,
		LOGIN,
		GET_REVISION_NUMBER,
		GET_DB_INFO,
		GET_SONGS,
		GET_PLAYLISTS,
		GET_PLAYLIST_ENTRIES,
		LOGOUT,
		DONE
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_", has_type_id = false)]
	public enum DMAPContentCode {
		CC_INVALID,
		RAW,
		CC_MDCL,
		CC_MSTT,
		CC_MIID,
		CC_MINM,
		CC_MIKD,
		CC_MPER,
		CC_MCON,
		CC_MCTI,
		CC_MPCO,
		CC_MSTS,
		CC_MIMC,
		CC_MCTC,
		CC_MRCO,
		CC_MTCO,
		CC_MLCL,
		CC_MLIT,
		CC_MBCL,
		CC_MSRV,
		CC_MSAU,
		CC_MSLR,
		CC_MPRO,
		CC_MSAL,
		CC_MSUP,
		CC_MSPI,
		CC_MSEX,
		CC_MSBR,
		CC_MSQY,
		CC_MSIX,
		CC_MSRS,
		CC_MSTM,
		CC_MSDC,
		CC_MCCR,
		CC_MCNM,
		CC_MCNA,
		CC_MCTY,
		CC_MLOG,
		CC_MLID,
		CC_MUPD,
		CC_MUSR,
		CC_MUTY,
		CC_MUDL,
		CC_MSMA,
		CC_FQUESCH,
		CC_APRO,
		CC_AVDB,
		CC_ABRO,
		CC_ABAL,
		CC_ABAR,
		CC_ABCP,
		CC_ABGN,
		CC_ADBS,
		CC_ASAL,
		CC_ASAI,
		CC_ASAA,
		CC_ASAR,
		CC_ASBT,
		CC_ASBR,
		CC_ASCM,
		CC_ASCO,
		CC_ASDA,
		CC_ASDM,
		CC_ASDC,
		CC_ASDN,
		CC_ASDB,
		CC_ASEQ,
		CC_ASFM,
		CC_ASGN,
		CC_ASDT,
		CC_ASRV,
		CC_ASSR,
		CC_ASSZ,
		CC_ASST,
		CC_ASSP,
		CC_ASTM,
		CC_ASTC,
		CC_ASTN,
		CC_ASUR,
		CC_ASYR,
		CC_ASDK,
		CC_ASUL,
		CC_ASSU,
		CC_ASSA,
		CC_APLY,
		CC_ABPL,
		CC_APSO,
		CC_PRSV,
		CC_ARIF,
		CC_MSAS,
		CC_AGRP,
		CC_AGAL,
		CC_ASCP,
		CC_PPRO,
		CC_PASP,
		CC_PFDT,
		CC_PICD,
		CC_PIMF,
		CC_PFMT,
		CC_PIFS,
		CC_PLSZ,
		CC_PHGT,
		CC_PWTH,
		CC_PRAT,
		CC_PCMT,
		CC_PRET,
		CC_AESV,
		CC_AEHV,
		CC_AESP,
		CC_AEPP,
		CC_AEPS,
		CC_AESG,
		CC_AEMK,
		CC_AEFP,
		CC_CMPA,
		CC_CMNM,
		CC_CMTY,
		CC_CMPG,
		CC_CACI,
		CC_CAPS,
		CC_CASH,
		CC_CARP,
		CC_CAAS,
		CC_CAAR,
		CC_CAIA,
		CC_CANP,
		CC_CANN,
		CC_CANA,
		CC_CANL,
		CC_CANG,
		CC_CANT,
		CC_CASP,
		CC_CASS,
		CC_CAST,
		CC_CASU,
		CC_CASG,
		CC_CACR,
		CC_CMCP,
		CC_CMGT,
		CC_CMIK,
		CC_CMSP,
		CC_CMST,
		CC_CMSV,
		CC_CMSR,
		CC_CMMK,
		CC_CMVO,
		CC_CMPR,
		CC_CAPR,
		CC_AEFR,
		CC_CAOV,
		CC_CMRL,
		CC_CAHP,
		CC_CAIV,
		CC_CAVC
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_ERROR_")]
	public enum DMAPMdnsBrowserError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_SERVICE_TYPE_")]
	public enum DMAPMdnsBrowserServiceType {
		INVALID,
		DAAP,
		DPAP,
		DACP,
		RAOP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_TRANSPORT_PROTOCOL_")]
	public enum DMAPMdnsBrowserTransportProtocol {
		TCP,
		UDP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_PUBLISHER_ERROR_")]
	public enum DMAPMdnsPublisherError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MEDIA_KIND_")]
	public enum DMAPMediaKind {
		MUSIC,
		MOVIE,
		PODCAST,
		TV_SHOW
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_TYPE_")]
	public enum DMAPType {
		BYTE,
		SIGNED_INT,
		SHORT,
		INT,
		INT64,
		STRING,
		DATE,
		VERSION,
		CONTAINER,
		POINTER
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate bool DMAPConnectionCallback (DAAP.DMAPConnection connection, bool result, string reason);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate void DMAPResponseHandler (DAAP.DMAPConnection connection, uint status, GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_target = false)]
	public delegate unowned string RecordGetValueFunc (DAAP.DMAPRecord record);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_HASH_SIZE;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_HAVE_UNALIGNED_ACCESS;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_STATUS_OK;
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_chunked_message_finished")]
	public static void dmap_chunked_message_finished (Soup.Message message, DAAP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_dmap_type")]
	public static DAAP.DMAPType dmap_content_code_dmap_type (DAAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_name")]
	public static unowned string dmap_content_code_name (DAAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_read_from_buffer")]
	public static DAAP.DMAPContentCode dmap_content_code_read_from_buffer (string buf);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_string")]
	public static unowned string dmap_content_code_string (DAAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_string_as_int32")]
	public static int32 dmap_content_code_string_as_int32 (string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_codes")]
	public static unowned DAAP.DMAPContentCodeDefinition dmap_content_codes (uint number);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_generate")]
	public static void dmap_hash_generate (short version_major, uchar[] url, uchar hash_select, uchar[] @out, int request_id);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_final")]
	public static void dmap_hash_progressive_final (DAAP.DMAPHashContext context, uint[] digest);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_init")]
	public static void dmap_hash_progressive_init (DAAP.DMAPHashContext context);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_to_string")]
	public static void dmap_hash_progressive_to_string (uint digest, string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_update")]
	public static void dmap_hash_progressive_update (DAAP.DMAPHashContext context, uint buffer, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_BOOLEAN__STRING")]
	public static void dmap_marshal_BOOLEAN__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_STRING__STRING")]
	public static void dmap_marshal_STRING__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_STRING__ULONG_ULONG")]
	public static void dmap_marshal_STRING__ULONG_ULONG (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_ULONG__VOID")]
	public static void dmap_marshal_ULONG__VOID (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_BOOLEAN")]
	public static void dmap_marshal_VOID__STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN")]
	public static void dmap_marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_STRING")]
	public static void dmap_marshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__ULONG_FLOAT")]
	public static void dmap_marshal_VOID__ULONG_FLOAT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mdns_avahi_get_client")]
	public static unowned Avahi.Client dmap_mdns_avahi_get_client ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mdns_avahi_set_entry_group")]
	public static void dmap_mdns_avahi_set_entry_group (Avahi.EntryGroup group);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mime_to_format")]
	public static unowned string dmap_mime_to_format (string transcode_mimetype);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_add")]
	public static unowned GLib.Node dmap_structure_add (GLib.Node parent, DAAP.DMAPContentCode cc);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_destroy")]
	public static void dmap_structure_destroy (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_find_item")]
	public static unowned DAAP.DMAPStructureItem dmap_structure_find_item (GLib.Node structure, DAAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_find_node")]
	public static unowned GLib.Node dmap_structure_find_node (GLib.Node structure, DAAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_get_size")]
	public static uint dmap_structure_get_size (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_increase_by_predicted_size")]
	public static void dmap_structure_increase_by_predicted_size (GLib.Node structure, uint size);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_parse")]
	public static unowned GLib.Node dmap_structure_parse (string buf, int buf_length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_print")]
	public static void dmap_structure_print (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_serialize")]
	public static unowned string dmap_structure_serialize (GLib.Node structure, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_write_next_chunk")]
	public static void dmap_write_next_chunk (Soup.Message message, DAAP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmapd_input_stream_strdup_format_extension")]
	public static unowned string dmapd_input_stream_strdup_format_extension (int format_code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "pads_compatible")]
	public static bool pads_compatible (Gst.Pad pad1, Gst.Pad pad2);
}
/* libdmapsharing-3.0-dacp.vapi generated by vapigen, do not modify. */

namespace DACP {
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class ChunkData {
		public weak Soup.Server server;
		public weak GLib.InputStream stream;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Connection : DACP.DMAPConnection {
		[CCode (has_construct_function = false)]
		public Connection (string name, string host, uint port, DMAP.Db db, DACP.DMAPRecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DAAPConnection : DACP.DMAPConnection {
		[CCode (cname = "daap_connection_new", has_construct_function = false, type = "DAAPConnection*")]
		public DAAPConnection (string name, string host, uint port, DMAP.Db db, DACP.DMAPRecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DAAPShare : DACP.DMAPShare {
		[CCode (cname = "daap_share_new", has_construct_function = false, type = "DAAPShare*")]
		public DAAPShare (string name, string password, DMAP.Db db, DMAP.ContainerDb container_db, string transcode_mimetype);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPConnection : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DMAPConnection ();
		[CCode (cname = "dmap_connection_authenticate_message")]
		public static void authenticate_message (DACP.DMAPConnection connection, Soup.Session session, Soup.Message message, Soup.Auth auth, string password);
		[CCode (cname = "dmap_connection_build_message")]
		public virtual unowned Soup.Message build_message (DACP.DMAPConnection connection, string path, bool need_hash, double version, int req_id, bool send_close);
		[CCode (cname = "dmap_connection_connect")]
		public static void connect (DACP.DMAPConnection connection, DACP.DMAPConnectionCallback callback);
		[CCode (cname = "dmap_connection_disconnect")]
		public static void disconnect (DACP.DMAPConnection connection, DACP.DMAPConnectionCallback callback);
		[CCode (cname = "dmap_connection_get")]
		public bool @get (string path, bool need_hash, DACP.DMAPResponseHandler handler);
		[CCode (cname = "dmap_connection_get_headers")]
		public static unowned Soup.MessageHeaders get_headers (DACP.DMAPConnection connection, string uri);
		[CCode (cname = "dmap_connection_get_playlists")]
		public static unowned GLib.SList get_playlists (DACP.DMAPConnection connection);
		[NoWrapper]
		public virtual DACP.DMAPContentCode get_protocol_version_cc (DACP.DMAPConnection connection);
		[NoWrapper]
		public virtual unowned string get_query_metadata (DACP.DMAPConnection connection);
		[NoWrapper]
		public virtual unowned DACP.DMAPRecord handle_mlcl (DACP.DMAPConnection connection, DACP.DMAPRecordFactory factory, GLib.Node mlcl, int item_id);
		[CCode (cname = "dmap_connection_is_connected")]
		public static bool is_connected (DACP.DMAPConnection connection);
		[CCode (cname = "dmap_connection_setup")]
		public static void setup (DACP.DMAPConnection connection);
		[NoAccessorMethod]
		public void* base_uri { get; set; }
		[NoAccessorMethod]
		public int database_id { get; set; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public double dmap_version { get; set; }
		[NoAccessorMethod]
		public void* factory { get; construct; }
		[NoAccessorMethod]
		public string host { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public string password { set; }
		[NoAccessorMethod]
		public uint port { get; construct; }
		[NoAccessorMethod]
		public int revision_number { get; set; }
		[NoAccessorMethod]
		public int session_id { get; set; }
		[NoAccessorMethod]
		public string username { owned get; construct; }
		public virtual signal void authenticate (string name, Soup.Session p1, Soup.Message p2, Soup.Auth p3, bool p4);
		public virtual signal void connected ();
		public virtual signal void connecting (ulong state, float progress);
		public virtual signal void disconnected ();
		public virtual signal void operation_done ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPContentCodeDefinition {
		public DACP.DMAPContentCode code;
		public int32 int_code;
		public weak string name;
		[CCode (cname = "string")]
		public weak string str;
		public DACP.DMAPType type;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPDbFilterDefinition {
		public weak string key;
		public bool negate;
		public weak string value;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstInputStream : GLib.InputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstInputStream (string transcode_mimetype, GLib.InputStream src_stream);
		[NoWrapper]
		public virtual void kill_pipeline (DACP.DMAPGstInputStream p1);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstMP3InputStream : DACP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_mp3_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstMP3InputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstQtInputStream : DACP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_qt_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstQtInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstWAVInputStream : DACP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_wav_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstWAVInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPHashContext {
		[CCode (array_length = false)]
		public weak uint32[] bits;
		[CCode (array_length = false)]
		public weak uint32[] buf;
		[CCode (array_length = false)]
		public weak uint[] @in;
		public int version;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPMdnsBrowser : GLib.Object {
		[CCode (cname = "dmap_mdns_browser_new", has_construct_function = false, type = "DMAPMdnsBrowser*")]
		public DMAPMdnsBrowser (DACP.DMAPMdnsBrowserServiceType type);
		[CCode (cname = "dmap_mdns_browser_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "dmap_mdns_browser_get_service_type")]
		public static DACP.DMAPMdnsBrowserServiceType get_service_type (DACP.DMAPMdnsBrowser browser);
		[CCode (cname = "dmap_mdns_browser_get_services")]
		public static unowned GLib.SList get_services (DACP.DMAPMdnsBrowser browser);
		[CCode (cname = "dmap_mdns_browser_start")]
		public static bool start (DACP.DMAPMdnsBrowser browser) throws GLib.Error;
		[CCode (cname = "dmap_mdns_browser_stop")]
		public static bool stop (DACP.DMAPMdnsBrowser browser) throws GLib.Error;
		public virtual signal void service_added (void* service);
		public virtual signal void service_removed (string service);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPMdnsBrowserService {
		public weak string host;
		public weak string name;
		public weak string pair;
		public bool password_protected;
		public uint port;
		public weak string service_name;
		public DACP.DMAPMdnsBrowserTransportProtocol transport_protocol;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPMdnsPublisher : GLib.Object {
		[CCode (cname = "dmap_mdns_publisher_new", has_construct_function = false, type = "DMAPMdnsPublisher*")]
		public DMAPMdnsPublisher ();
		[CCode (cname = "dmap_mdns_publisher_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "dmap_mdns_publisher_publish")]
		public static bool publish (DACP.DMAPMdnsPublisher publisher, string name, uint port, string type_of_service, bool password_required, string txt_records) throws GLib.Error;
		[CCode (cname = "dmap_mdns_publisher_rename_at_port")]
		public static bool rename_at_port (DACP.DMAPMdnsPublisher publisher, uint port, string name) throws GLib.Error;
		[CCode (cname = "dmap_mdns_publisher_withdraw")]
		public static bool withdraw (DACP.DMAPMdnsPublisher publisher, uint port) throws GLib.Error;
		public virtual signal void name_collision (string name);
		public virtual signal void published (string name);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPMetaDataMap {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPPlaylist {
		public int id;
		public weak string name;
		public weak GLib.List uris;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPShare : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DMAPShare ();
		[NoWrapper]
		public virtual void add_entry_to_mlcl (void* id, DACP.DMAPRecord record, void* mb);
		[NoWrapper]
		public virtual void content_codes (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void ctrl_int (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void databases (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_browse_xxx (DACP.DMAPShare share, Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_items_xxx (DACP.DMAPShare share, Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[CCode (cname = "dmap_share_free_filter")]
		public static void free_filter (GLib.SList filter);
		[NoWrapper]
		public virtual uint get_desired_port (DACP.DMAPShare share);
		[NoWrapper]
		public virtual void* get_meta_data_map (DACP.DMAPShare share);
		[NoWrapper]
		public virtual unowned string get_type_of_service (DACP.DMAPShare share);
		[NoWrapper]
		public virtual void login (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void logout (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void message_add_standard_headers (DACP.DMAPShare share, Soup.Message msg);
		[NoWrapper]
		public virtual void name_collision (DACP.DMAPShare share, DACP.DMAPMdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void published (DACP.DMAPShare share, DACP.DMAPMdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void server_info (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void update (DACP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoAccessorMethod]
		public uint auth_method { get; set; }
		[NoAccessorMethod]
		public void* container_db { get; construct; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint revision_number { get; set; }
		[NoAccessorMethod]
		public Soup.Server server_ipv4 { owned get; }
		[NoAccessorMethod]
		public Soup.Server server_ipv6 { owned get; }
		[NoAccessorMethod]
		public string transcode_mimetype { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] txt_records { owned get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPStructureItem {
		public GLib.Value content;
		public DACP.DMAPContentCode content_code;
		public uint32 size;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Share : DACP.DAAPShare {
		[CCode (has_construct_function = false)]
		public Share (string library_name, DACP.Player player, DMAP.Db db, DMAP.ContainerDb container_db);
		public void pair (string service_name, char[] passcode);
		public void player_updated ();
		public void start_lookup ();
		public void stop_lookup ();
		[NoAccessorMethod]
		public string library_name { owned get; set; }
		[NoAccessorMethod]
		public GLib.Object player { owned get; construct; }
		public virtual signal void add_guid (string guid);
		public virtual signal bool lookup_guid (string guid);
		public virtual signal void remote_found (string service_name, string remote_name);
		public virtual signal void remote_lost (string service_name);
		public virtual signal void remote_paired (string service_name, bool connected);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class bitwise {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DAAPRecord {
		[CCode (cname = "daap_record_cmp_by_album")]
		public static int cmp_by_album (void* a, void* b, DMAP.Db db);
		[CCode (cname = "daap_record_itunes_compat")]
		public abstract bool itunes_compat (DAAP.Record record);
		[CCode (cname = "daap_record_read")]
		public abstract unowned GLib.InputStream read (DAAP.Record record) throws GLib.Error;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPContainerDb : GLib.Object {
		[CCode (cname = "dmap_container_db_add")]
		public abstract void add (DMAP.ContainerDb db, DACP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_db_count")]
		public abstract int64 count (DMAP.ContainerDb db);
		[CCode (cname = "dmap_container_db_foreach")]
		public abstract void @foreach (DMAP.ContainerDb db, GLib.HFunc func, void* data);
		[CCode (cname = "dmap_container_db_lookup_by_id")]
		public abstract unowned DACP.DMAPContainerRecord lookup_by_id (DMAP.ContainerDb db, uint id);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPContainerRecord {
		[CCode (cname = "dmap_container_record_add_entry")]
		public abstract void add_entry (DACP.DMAPContainerRecord container_record, DACP.DMAPRecord record, int id);
		[CCode (cname = "dmap_container_record_get_entries")]
		public abstract unowned DMAP.Db get_entries (DACP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_record_get_entry_count")]
		public abstract uint64 get_entry_count (DACP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_record_get_id")]
		public abstract uint get_id (DACP.DMAPContainerRecord record);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPDb : GLib.Object {
		[CCode (cname = "dmap_db_add")]
		public abstract uint add (DMAP.Db db, DACP.DMAPRecord record);
		[CCode (cname = "dmap_db_add_path")]
		public abstract uint add_path (DMAP.Db db, string path);
		[CCode (cname = "dmap_db_add_with_id")]
		public abstract uint add_with_id (DMAP.Db db, DACP.DMAPRecord record, uint id);
		[CCode (cname = "dmap_db_apply_filter")]
		public static unowned GLib.HashTable apply_filter (DMAP.Db db, GLib.SList filter_def);
		[CCode (cname = "dmap_db_count")]
		public abstract int64 count (DMAP.Db db);
		[CCode (cname = "dmap_db_foreach")]
		public abstract void @foreach (DMAP.Db db, GLib.HFunc func, void* data);
		[CCode (cname = "dmap_db_lookup_by_id")]
		public abstract unowned DACP.DMAPRecord lookup_by_id (DMAP.Db db, uint id);
		[CCode (cname = "dmap_db_lookup_id_by_location")]
		public abstract uint lookup_id_by_location (DMAP.Db db, string location);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPRecord : GLib.Object {
		[CCode (cname = "dmap_record_set_from_blob")]
		public abstract bool set_from_blob (DACP.DMAPRecord record, GLib.ByteArray blob);
		[CCode (cname = "dmap_record_to_blob")]
		public abstract unowned GLib.ByteArray to_blob (DACP.DMAPRecord record);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPRecordFactory {
		[CCode (cname = "dmap_record_factory_create")]
		public abstract unowned DACP.DMAPRecord create (DACP.DMAPRecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface Player : GLib.Object {
		public abstract void cue_clear ();
		public abstract void cue_play (GLib.List records, uint index);
		public abstract void next_item ();
		public abstract unowned uchar[] now_playing_artwork (uint width, uint height);
		public abstract unowned DAAP.Record now_playing_record ();
		public abstract void pause ();
		public abstract void play_pause ();
		public abstract void prev_item ();
		[NoAccessorMethod]
		public DACP.PlayState play_state { get; set; }
		[NoAccessorMethod]
		public ulong playing_time { get; set; }
		[NoAccessorMethod]
		public DACP.RepeatState repeat_state { get; set; }
		[NoAccessorMethod]
		public bool shuffle_state { get; set; }
		[NoAccessorMethod]
		public ulong volume { get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_")]
	public enum DMAPConnectionState {
		GET_INFO,
		LOGIN,
		GET_REVISION_NUMBER,
		GET_DB_INFO,
		GET_SONGS,
		GET_PLAYLISTS,
		GET_PLAYLIST_ENTRIES,
		LOGOUT,
		DONE
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_", has_type_id = false)]
	public enum DMAPContentCode {
		CC_INVALID,
		RAW,
		CC_MDCL,
		CC_MSTT,
		CC_MIID,
		CC_MINM,
		CC_MIKD,
		CC_MPER,
		CC_MCON,
		CC_MCTI,
		CC_MPCO,
		CC_MSTS,
		CC_MIMC,
		CC_MCTC,
		CC_MRCO,
		CC_MTCO,
		CC_MLCL,
		CC_MLIT,
		CC_MBCL,
		CC_MSRV,
		CC_MSAU,
		CC_MSLR,
		CC_MPRO,
		CC_MSAL,
		CC_MSUP,
		CC_MSPI,
		CC_MSEX,
		CC_MSBR,
		CC_MSQY,
		CC_MSIX,
		CC_MSRS,
		CC_MSTM,
		CC_MSDC,
		CC_MCCR,
		CC_MCNM,
		CC_MCNA,
		CC_MCTY,
		CC_MLOG,
		CC_MLID,
		CC_MUPD,
		CC_MUSR,
		CC_MUTY,
		CC_MUDL,
		CC_MSMA,
		CC_FQUESCH,
		CC_APRO,
		CC_AVDB,
		CC_ABRO,
		CC_ABAL,
		CC_ABAR,
		CC_ABCP,
		CC_ABGN,
		CC_ADBS,
		CC_ASAL,
		CC_ASAI,
		CC_ASAA,
		CC_ASAR,
		CC_ASBT,
		CC_ASBR,
		CC_ASCM,
		CC_ASCO,
		CC_ASDA,
		CC_ASDM,
		CC_ASDC,
		CC_ASDN,
		CC_ASDB,
		CC_ASEQ,
		CC_ASFM,
		CC_ASGN,
		CC_ASDT,
		CC_ASRV,
		CC_ASSR,
		CC_ASSZ,
		CC_ASST,
		CC_ASSP,
		CC_ASTM,
		CC_ASTC,
		CC_ASTN,
		CC_ASUR,
		CC_ASYR,
		CC_ASDK,
		CC_ASUL,
		CC_ASSU,
		CC_ASSA,
		CC_APLY,
		CC_ABPL,
		CC_APSO,
		CC_PRSV,
		CC_ARIF,
		CC_MSAS,
		CC_AGRP,
		CC_AGAL,
		CC_ASCP,
		CC_PPRO,
		CC_PASP,
		CC_PFDT,
		CC_PICD,
		CC_PIMF,
		CC_PFMT,
		CC_PIFS,
		CC_PLSZ,
		CC_PHGT,
		CC_PWTH,
		CC_PRAT,
		CC_PCMT,
		CC_PRET,
		CC_AESV,
		CC_AEHV,
		CC_AESP,
		CC_AEPP,
		CC_AEPS,
		CC_AESG,
		CC_AEMK,
		CC_AEFP,
		CC_CMPA,
		CC_CMNM,
		CC_CMTY,
		CC_CMPG,
		CC_CACI,
		CC_CAPS,
		CC_CASH,
		CC_CARP,
		CC_CAAS,
		CC_CAAR,
		CC_CAIA,
		CC_CANP,
		CC_CANN,
		CC_CANA,
		CC_CANL,
		CC_CANG,
		CC_CANT,
		CC_CASP,
		CC_CASS,
		CC_CAST,
		CC_CASU,
		CC_CASG,
		CC_CACR,
		CC_CMCP,
		CC_CMGT,
		CC_CMIK,
		CC_CMSP,
		CC_CMST,
		CC_CMSV,
		CC_CMSR,
		CC_CMMK,
		CC_CMVO,
		CC_CMPR,
		CC_CAPR,
		CC_AEFR,
		CC_CAOV,
		CC_CMRL,
		CC_CAHP,
		CC_CAIV,
		CC_CAVC
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_ERROR_")]
	public enum DMAPMdnsBrowserError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_SERVICE_TYPE_")]
	public enum DMAPMdnsBrowserServiceType {
		INVALID,
		DAAP,
		DPAP,
		DACP,
		RAOP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_TRANSPORT_PROTOCOL_")]
	public enum DMAPMdnsBrowserTransportProtocol {
		TCP,
		UDP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_PUBLISHER_ERROR_")]
	public enum DMAPMdnsPublisherError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MEDIA_KIND_")]
	public enum DMAPMediaKind {
		MUSIC,
		MOVIE,
		PODCAST,
		TV_SHOW
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_TYPE_")]
	public enum DMAPType {
		BYTE,
		SIGNED_INT,
		SHORT,
		INT,
		INT64,
		STRING,
		DATE,
		VERSION,
		CONTAINER,
		POINTER
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_PLAY_")]
	public enum PlayState {
		STOPPED,
		PAUSED,
		PLAYING
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_REPEAT_")]
	public enum RepeatState {
		NONE,
		SINGLE,
		ALL
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate bool DMAPConnectionCallback (DACP.DMAPConnection connection, bool result, string reason);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate void DMAPResponseHandler (DACP.DMAPConnection connection, uint status, GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_target = false)]
	public delegate unowned string RecordGetValueFunc (DACP.DMAPRecord record);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_HASH_SIZE;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_HAVE_UNALIGNED_ACCESS;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_STATUS_OK;
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_chunked_message_finished")]
	public static void dmap_chunked_message_finished (Soup.Message message, DACP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_dmap_type")]
	public static DACP.DMAPType dmap_content_code_dmap_type (DACP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_name")]
	public static unowned string dmap_content_code_name (DACP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_read_from_buffer")]
	public static DACP.DMAPContentCode dmap_content_code_read_from_buffer (string buf);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_string")]
	public static unowned string dmap_content_code_string (DACP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_string_as_int32")]
	public static int32 dmap_content_code_string_as_int32 (string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_codes")]
	public static unowned DACP.DMAPContentCodeDefinition dmap_content_codes (uint number);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_generate")]
	public static void dmap_hash_generate (short version_major, uchar[] url, uchar hash_select, uchar[] @out, int request_id);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_final")]
	public static void dmap_hash_progressive_final (DACP.DMAPHashContext context, uint[] digest);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_init")]
	public static void dmap_hash_progressive_init (DACP.DMAPHashContext context);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_to_string")]
	public static void dmap_hash_progressive_to_string (uint digest, string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_update")]
	public static void dmap_hash_progressive_update (DACP.DMAPHashContext context, uint buffer, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_BOOLEAN__STRING")]
	public static void dmap_marshal_BOOLEAN__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_STRING__STRING")]
	public static void dmap_marshal_STRING__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_STRING__ULONG_ULONG")]
	public static void dmap_marshal_STRING__ULONG_ULONG (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_ULONG__VOID")]
	public static void dmap_marshal_ULONG__VOID (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_BOOLEAN")]
	public static void dmap_marshal_VOID__STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN")]
	public static void dmap_marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_STRING")]
	public static void dmap_marshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__ULONG_FLOAT")]
	public static void dmap_marshal_VOID__ULONG_FLOAT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mdns_avahi_get_client")]
	public static unowned Avahi.Client dmap_mdns_avahi_get_client ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mdns_avahi_set_entry_group")]
	public static void dmap_mdns_avahi_set_entry_group (Avahi.EntryGroup group);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mime_to_format")]
	public static unowned string dmap_mime_to_format (string transcode_mimetype);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_add")]
	public static unowned GLib.Node dmap_structure_add (GLib.Node parent, DACP.DMAPContentCode cc);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_destroy")]
	public static void dmap_structure_destroy (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_find_item")]
	public static unowned DACP.DMAPStructureItem dmap_structure_find_item (GLib.Node structure, DACP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_find_node")]
	public static unowned GLib.Node dmap_structure_find_node (GLib.Node structure, DACP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_get_size")]
	public static uint dmap_structure_get_size (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_increase_by_predicted_size")]
	public static void dmap_structure_increase_by_predicted_size (GLib.Node structure, uint size);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_parse")]
	public static unowned GLib.Node dmap_structure_parse (string buf, int buf_length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_print")]
	public static void dmap_structure_print (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_serialize")]
	public static unowned string dmap_structure_serialize (GLib.Node structure, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_write_next_chunk")]
	public static void dmap_write_next_chunk (Soup.Message message, DACP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmapd_input_stream_strdup_format_extension")]
	public static unowned string dmapd_input_stream_strdup_format_extension (int format_code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "pads_compatible")]
	public static bool pads_compatible (Gst.Pad pad1, Gst.Pad pad2);
}
/* libdmapsharing-3.0-dmap.vapi generated by vapigen, do not modify. */

namespace DMAP {
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class ChunkData {
		public weak Soup.Server server;
		public weak GLib.InputStream stream;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Connection : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Connection ();
		public void authenticate_message (Soup.Session session, Soup.Message message, Soup.Auth auth, string password);
		public virtual unowned Soup.Message build_message (string path, bool need_hash, double version, int req_id, bool send_close);
		public void connect (DMAP.ConnectionCallback callback);
		public void disconnect (DMAP.ConnectionCallback callback);
		public bool @get (string path, bool need_hash, DMAP.ResponseHandler handler);
		public unowned Soup.MessageHeaders get_headers (string uri);
		public unowned GLib.SList get_playlists ();
		[NoWrapper]
		public virtual DMAP.ContentCode get_protocol_version_cc ();
		[NoWrapper]
		public virtual unowned string get_query_metadata ();
		[NoWrapper]
		public virtual unowned DMAP.Record handle_mlcl (DMAP.RecordFactory factory, GLib.Node mlcl, int item_id);
		public bool is_connected ();
		public void setup ();
		[NoAccessorMethod]
		public void* base_uri { get; set; }
		[NoAccessorMethod]
		public int database_id { get; set; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public double dmap_version { get; set; }
		[NoAccessorMethod]
		public void* factory { get; construct; }
		[NoAccessorMethod]
		public string host { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public string password { set; }
		[NoAccessorMethod]
		public uint port { get; construct; }
		[NoAccessorMethod]
		public int revision_number { get; set; }
		[NoAccessorMethod]
		public int session_id { get; set; }
		[NoAccessorMethod]
		public string username { owned get; construct; }
		public virtual signal void authenticate (string name, Soup.Session p1, Soup.Message p2, Soup.Auth p3, bool p4);
		public virtual signal void connected ();
		public virtual signal void connecting (ulong state, float progress);
		public virtual signal void disconnected ();
		public virtual signal void operation_done ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class ContentCodeDefinition {
		public DMAP.ContentCode code;
		public int32 int_code;
		public weak string name;
		[CCode (cname = "string")]
		public weak string str;
		public DMAP.Type type;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DbFilterDefinition {
		public weak string key;
		public bool negate;
		public weak string value;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class GstInputStream : GLib.InputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public GstInputStream (string transcode_mimetype, GLib.InputStream src_stream);
		[NoWrapper]
		public virtual void kill_pipeline ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class GstMP3InputStream : DMAP.GstInputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public GstMP3InputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class GstQtInputStream : DMAP.GstInputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public GstQtInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class GstWAVInputStream : DMAP.GstInputStream, GLib.Seekable {
		[CCode (has_construct_function = false, type = "GInputStream*")]
		public GstWAVInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class HashContext {
		[CCode (array_length = false)]
		public weak uint32[] bits;
		[CCode (array_length = false)]
		public weak uint32[] buf;
		[CCode (array_length = false)]
		public weak uint[] @in;
		public int version;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class MdnsBrowser : GLib.Object {
		[CCode (has_construct_function = false)]
		public MdnsBrowser (DMAP.MdnsBrowserServiceType type);
		public static GLib.Quark error_quark ();
		public DMAP.MdnsBrowserServiceType get_service_type ();
		public unowned GLib.SList get_services ();
		public bool start () throws GLib.Error;
		public bool stop () throws GLib.Error;
		public virtual signal void service_added (void* service);
		public virtual signal void service_removed (string service);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class MdnsBrowserService {
		public weak string host;
		public weak string name;
		public weak string pair;
		public bool password_protected;
		public uint port;
		public weak string service_name;
		public DMAP.MdnsBrowserTransportProtocol transport_protocol;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class MdnsPublisher : GLib.Object {
		[CCode (has_construct_function = false)]
		public MdnsPublisher ();
		public static GLib.Quark error_quark ();
		public bool publish (string name, uint port, string type_of_service, bool password_required, string txt_records) throws GLib.Error;
		public bool rename_at_port (uint port, string name) throws GLib.Error;
		public bool withdraw (uint port) throws GLib.Error;
		public virtual signal void name_collision (string name);
		public virtual signal void published (string name);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class MetaDataMap {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class Playlist {
		public int id;
		public weak string name;
		public weak GLib.List uris;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Share : GLib.Object {
		[CCode (has_construct_function = false)]
		protected Share ();
		[NoWrapper]
		public virtual void add_entry_to_mlcl (void* id, DMAP.Record record, void* mb);
		[NoWrapper]
		public virtual void content_codes (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void ctrl_int (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void databases (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_browse_xxx (Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_items_xxx (Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		public static void free_filter (GLib.SList filter);
		[NoWrapper]
		public virtual uint get_desired_port ();
		[NoWrapper]
		public virtual void* get_meta_data_map ();
		[NoWrapper]
		public virtual unowned string get_type_of_service ();
		[NoWrapper]
		public virtual void login (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void logout (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void message_add_standard_headers (Soup.Message msg);
		[NoWrapper]
		public virtual void name_collision (DMAP.MdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void published (DMAP.MdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void server_info (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void update (Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoAccessorMethod]
		public uint auth_method { get; set; }
		[NoAccessorMethod]
		public void* container_db { get; construct; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint revision_number { get; set; }
		[NoAccessorMethod]
		public Soup.Server server_ipv4 { owned get; }
		[NoAccessorMethod]
		public Soup.Server server_ipv6 { owned get; }
		[NoAccessorMethod]
		public string transcode_mimetype { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] txt_records { owned get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class StructureItem {
		public GLib.Value content;
		public DMAP.ContentCode content_code;
		public uint32 size;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class bitwise {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface ContainerDb : GLib.Object {
		public abstract void add (DMAP.ContainerRecord record);
		public abstract int64 count ();
		public abstract void @foreach (GLib.HFunc func);
		public abstract unowned DMAP.ContainerRecord lookup_by_id (uint id);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface ContainerRecord {
		public abstract void add_entry (DMAP.Record record, int id);
		public abstract unowned DMAP.Db get_entries ();
		public abstract uint64 get_entry_count ();
		public abstract uint get_id ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface Db : GLib.Object {
		public abstract uint add (DMAP.Record record);
		public abstract uint add_path (string path);
		public abstract uint add_with_id (DMAP.Record record, uint id);
		public unowned GLib.HashTable apply_filter (GLib.SList filter_def);
		public abstract int64 count ();
		public abstract void @foreach (GLib.HFunc func);
		public abstract unowned DMAP.Record lookup_by_id (uint id);
		public abstract uint lookup_id_by_location (string location);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface Record : GLib.Object {
		public abstract bool set_from_blob (GLib.ByteArray blob);
		public abstract unowned GLib.ByteArray to_blob ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface RecordFactory {
		public abstract DMAP.Record create (void* user_data);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_")]
	public enum ConnectionState {
		GET_INFO,
		LOGIN,
		GET_REVISION_NUMBER,
		GET_DB_INFO,
		GET_SONGS,
		GET_PLAYLISTS,
		GET_PLAYLIST_ENTRIES,
		LOGOUT,
		DONE
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_", has_type_id = false)]
	public enum ContentCode {
		CC_INVALID,
		RAW,
		CC_MDCL,
		CC_MSTT,
		CC_MIID,
		CC_MINM,
		CC_MIKD,
		CC_MPER,
		CC_MCON,
		CC_MCTI,
		CC_MPCO,
		CC_MSTS,
		CC_MIMC,
		CC_MCTC,
		CC_MRCO,
		CC_MTCO,
		CC_MLCL,
		CC_MLIT,
		CC_MBCL,
		CC_MSRV,
		CC_MSAU,
		CC_MSLR,
		CC_MPRO,
		CC_MSAL,
		CC_MSUP,
		CC_MSPI,
		CC_MSEX,
		CC_MSBR,
		CC_MSQY,
		CC_MSIX,
		CC_MSRS,
		CC_MSTM,
		CC_MSDC,
		CC_MCCR,
		CC_MCNM,
		CC_MCNA,
		CC_MCTY,
		CC_MLOG,
		CC_MLID,
		CC_MUPD,
		CC_MUSR,
		CC_MUTY,
		CC_MUDL,
		CC_MSMA,
		CC_FQUESCH,
		CC_APRO,
		CC_AVDB,
		CC_ABRO,
		CC_ABAL,
		CC_ABAR,
		CC_ABCP,
		CC_ABGN,
		CC_ADBS,
		CC_ASAL,
		CC_ASAI,
		CC_ASAA,
		CC_ASAR,
		CC_ASBT,
		CC_ASBR,
		CC_ASCM,
		CC_ASCO,
		CC_ASDA,
		CC_ASDM,
		CC_ASDC,
		CC_ASDN,
		CC_ASDB,
		CC_ASEQ,
		CC_ASFM,
		CC_ASGN,
		CC_ASDT,
		CC_ASRV,
		CC_ASSR,
		CC_ASSZ,
		CC_ASST,
		CC_ASSP,
		CC_ASTM,
		CC_ASTC,
		CC_ASTN,
		CC_ASUR,
		CC_ASYR,
		CC_ASDK,
		CC_ASUL,
		CC_ASSU,
		CC_ASSA,
		CC_APLY,
		CC_ABPL,
		CC_APSO,
		CC_PRSV,
		CC_ARIF,
		CC_MSAS,
		CC_AGRP,
		CC_AGAL,
		CC_ASCP,
		CC_PPRO,
		CC_PASP,
		CC_PFDT,
		CC_PICD,
		CC_PIMF,
		CC_PFMT,
		CC_PIFS,
		CC_PLSZ,
		CC_PHGT,
		CC_PWTH,
		CC_PRAT,
		CC_PCMT,
		CC_PRET,
		CC_AESV,
		CC_AEHV,
		CC_AESP,
		CC_AEPP,
		CC_AEPS,
		CC_AESG,
		CC_AEMK,
		CC_AEFP,
		CC_CMPA,
		CC_CMNM,
		CC_CMTY,
		CC_CMPG,
		CC_CACI,
		CC_CAPS,
		CC_CASH,
		CC_CARP,
		CC_CAAS,
		CC_CAAR,
		CC_CAIA,
		CC_CANP,
		CC_CANN,
		CC_CANA,
		CC_CANL,
		CC_CANG,
		CC_CANT,
		CC_CASP,
		CC_CASS,
		CC_CAST,
		CC_CASU,
		CC_CASG,
		CC_CACR,
		CC_CMCP,
		CC_CMGT,
		CC_CMIK,
		CC_CMSP,
		CC_CMST,
		CC_CMSV,
		CC_CMSR,
		CC_CMMK,
		CC_CMVO,
		CC_CMPR,
		CC_CAPR,
		CC_AEFR,
		CC_CAOV,
		CC_CMRL,
		CC_CAHP,
		CC_CAIV,
		CC_CAVC
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_PLAY_")]
	public enum DACPPlayState {
		STOPPED,
		PAUSED,
		PLAYING
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_REPEAT_")]
	public enum DACPRepeatState {
		NONE,
		SINGLE,
		ALL
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_ERROR_")]
	public enum MdnsBrowserError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_SERVICE_TYPE_")]
	public enum MdnsBrowserServiceType {
		INVALID,
		DAAP,
		DPAP,
		DACP,
		RAOP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_TRANSPORT_PROTOCOL_")]
	public enum MdnsBrowserTransportProtocol {
		TCP,
		UDP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_PUBLISHER_ERROR_")]
	public enum MdnsPublisherError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MEDIA_KIND_")]
	public enum MediaKind {
		MUSIC,
		MOVIE,
		PODCAST,
		TV_SHOW
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_TYPE_")]
	public enum Type {
		BYTE,
		SIGNED_INT,
		SHORT,
		INT,
		INT64,
		STRING,
		DATE,
		VERSION,
		CONTAINER,
		POINTER
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate bool ConnectionCallback (DMAP.Connection connection, bool result, string reason);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_target = false)]
	public delegate unowned string RecordGetValueFunc (DMAP.Record record);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate void ResponseHandler (DMAP.Connection connection, uint status, GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int HASH_SIZE;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int HAVE_UNALIGNED_ACCESS;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int STATUS_OK;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void chunked_message_finished (Soup.Message message, DMAP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static DMAP.Type content_code_dmap_type (DMAP.ContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned string content_code_name (DMAP.ContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static DMAP.ContentCode content_code_read_from_buffer (string buf);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned string content_code_string (DMAP.ContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static int32 content_code_string_as_int32 (string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned DMAP.ContentCodeDefinition content_codes (uint number);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmapd_input_stream_strdup_format_extension")]
	public static unowned string dmapd_input_stream_strdup_format_extension (int format_code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void hash_generate (short version_major, uchar[] url, uchar hash_select, uchar[] @out, int request_id);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void hash_progressive_final (DMAP.HashContext context, uint[] digest);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void hash_progressive_init (DMAP.HashContext context);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void hash_progressive_to_string (uint digest, string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void hash_progressive_update (DMAP.HashContext context, uint buffer, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_BOOLEAN__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_STRING__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_STRING__ULONG_ULONG (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_ULONG__VOID (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_VOID__STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void marshal_VOID__ULONG_FLOAT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned Avahi.Client mdns_avahi_get_client ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void mdns_avahi_set_entry_group (Avahi.EntryGroup group);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned string mime_to_format (string transcode_mimetype);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "pads_compatible")]
	public static bool pads_compatible (Gst.Pad pad1, Gst.Pad pad2);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned GLib.Node structure_add (GLib.Node parent, DMAP.ContentCode cc);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void structure_destroy (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned DMAP.StructureItem structure_find_item (GLib.Node structure, DMAP.ContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned GLib.Node structure_find_node (GLib.Node structure, DMAP.ContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static uint structure_get_size (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void structure_increase_by_predicted_size (GLib.Node structure, uint size);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned GLib.Node structure_parse (string buf, int buf_length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void structure_print (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static unowned string structure_serialize (GLib.Node structure, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public static void write_next_chunk (Soup.Message message, DMAP.ChunkData cd);
}
/* libdmapsharing-3.0-dpap.vapi generated by vapigen, do not modify. */

namespace DPAP {
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class ChunkData {
		public weak Soup.Server server;
		public weak GLib.InputStream stream;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Connection : DPAP.DMAPConnection {
		[CCode (has_construct_function = false)]
		public Connection (string name, string host, uint port, DMAP.Db db, DMAP.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPConnection : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DMAPConnection ();
		[CCode (cname = "dmap_connection_authenticate_message")]
		public static void authenticate_message (DPAP.DMAPConnection connection, Soup.Session session, Soup.Message message, Soup.Auth auth, string password);
		[CCode (cname = "dmap_connection_build_message")]
		public virtual unowned Soup.Message build_message (DPAP.DMAPConnection connection, string path, bool need_hash, double version, int req_id, bool send_close);
		[CCode (cname = "dmap_connection_connect")]
		public static void connect (DPAP.DMAPConnection connection, DPAP.DMAPConnectionCallback callback);
		[CCode (cname = "dmap_connection_disconnect")]
		public static void disconnect (DPAP.DMAPConnection connection, DPAP.DMAPConnectionCallback callback);
		[CCode (cname = "dmap_connection_get")]
		public bool @get (string path, bool need_hash, DPAP.DMAPResponseHandler handler);
		[CCode (cname = "dmap_connection_get_headers")]
		public static unowned Soup.MessageHeaders get_headers (DPAP.DMAPConnection connection, string uri);
		[CCode (cname = "dmap_connection_get_playlists")]
		public static unowned GLib.SList get_playlists (DPAP.DMAPConnection connection);
		[NoWrapper]
		public virtual DPAP.DMAPContentCode get_protocol_version_cc (DPAP.DMAPConnection connection);
		[NoWrapper]
		public virtual unowned string get_query_metadata (DPAP.DMAPConnection connection);
		[NoWrapper]
		public virtual unowned DPAP.DMAPRecord handle_mlcl (DPAP.DMAPConnection connection, DMAP.RecordFactory factory, GLib.Node mlcl, int item_id);
		[CCode (cname = "dmap_connection_is_connected")]
		public static bool is_connected (DPAP.DMAPConnection connection);
		[CCode (cname = "dmap_connection_setup")]
		public static void setup (DPAP.DMAPConnection connection);
		[NoAccessorMethod]
		public void* base_uri { get; set; }
		[NoAccessorMethod]
		public int database_id { get; set; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public double dmap_version { get; set; }
		[NoAccessorMethod]
		public void* factory { get; construct; }
		[NoAccessorMethod]
		public string host { owned get; construct; }
		[NoAccessorMethod]
		public string name { owned get; construct; }
		[NoAccessorMethod]
		public string password { set; }
		[NoAccessorMethod]
		public uint port { get; construct; }
		[NoAccessorMethod]
		public int revision_number { get; set; }
		[NoAccessorMethod]
		public int session_id { get; set; }
		[NoAccessorMethod]
		public string username { owned get; construct; }
		public virtual signal void authenticate (string name, Soup.Session p1, Soup.Message p2, Soup.Auth p3, bool p4);
		public virtual signal void connected ();
		public virtual signal void connecting (ulong state, float progress);
		public virtual signal void disconnected ();
		public virtual signal void operation_done ();
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPContentCodeDefinition {
		public DPAP.DMAPContentCode code;
		public int32 int_code;
		public weak string name;
		[CCode (cname = "string")]
		public weak string str;
		public DPAP.DMAPType type;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPDbFilterDefinition {
		public weak string key;
		public bool negate;
		public weak string value;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstInputStream : GLib.InputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstInputStream (string transcode_mimetype, GLib.InputStream src_stream);
		[NoWrapper]
		public virtual void kill_pipeline (DPAP.DMAPGstInputStream p1);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstMP3InputStream : DPAP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_mp3_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstMP3InputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstQtInputStream : DPAP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_qt_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstQtInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPGstWAVInputStream : DPAP.DMAPGstInputStream, GLib.Seekable {
		[CCode (cname = "dmap_gst_wav_input_stream_new", has_construct_function = false, type = "GInputStream*")]
		public DMAPGstWAVInputStream (GLib.InputStream stream);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPHashContext {
		[CCode (array_length = false)]
		public weak uint32[] bits;
		[CCode (array_length = false)]
		public weak uint32[] buf;
		[CCode (array_length = false)]
		public weak uint[] @in;
		public int version;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPMdnsBrowser : GLib.Object {
		[CCode (cname = "dmap_mdns_browser_new", has_construct_function = false, type = "DMAPMdnsBrowser*")]
		public DMAPMdnsBrowser (DPAP.DMAPMdnsBrowserServiceType type);
		[CCode (cname = "dmap_mdns_browser_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "dmap_mdns_browser_get_service_type")]
		public static DPAP.DMAPMdnsBrowserServiceType get_service_type (DPAP.DMAPMdnsBrowser browser);
		[CCode (cname = "dmap_mdns_browser_get_services")]
		public static unowned GLib.SList get_services (DPAP.DMAPMdnsBrowser browser);
		[CCode (cname = "dmap_mdns_browser_start")]
		public static bool start (DPAP.DMAPMdnsBrowser browser) throws GLib.Error;
		[CCode (cname = "dmap_mdns_browser_stop")]
		public static bool stop (DPAP.DMAPMdnsBrowser browser) throws GLib.Error;
		public virtual signal void service_added (void* service);
		public virtual signal void service_removed (string service);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPMdnsBrowserService {
		public weak string host;
		public weak string name;
		public weak string pair;
		public bool password_protected;
		public uint port;
		public weak string service_name;
		public DPAP.DMAPMdnsBrowserTransportProtocol transport_protocol;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPMdnsPublisher : GLib.Object {
		[CCode (cname = "dmap_mdns_publisher_new", has_construct_function = false, type = "DMAPMdnsPublisher*")]
		public DMAPMdnsPublisher ();
		[CCode (cname = "dmap_mdns_publisher_error_quark")]
		public static GLib.Quark error_quark ();
		[CCode (cname = "dmap_mdns_publisher_publish")]
		public static bool publish (DPAP.DMAPMdnsPublisher publisher, string name, uint port, string type_of_service, bool password_required, string txt_records) throws GLib.Error;
		[CCode (cname = "dmap_mdns_publisher_rename_at_port")]
		public static bool rename_at_port (DPAP.DMAPMdnsPublisher publisher, uint port, string name) throws GLib.Error;
		[CCode (cname = "dmap_mdns_publisher_withdraw")]
		public static bool withdraw (DPAP.DMAPMdnsPublisher publisher, uint port) throws GLib.Error;
		public virtual signal void name_collision (string name);
		public virtual signal void published (string name);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPMetaDataMap {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPPlaylist {
		public int id;
		public weak string name;
		public weak GLib.List uris;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class DMAPShare : GLib.Object {
		[CCode (has_construct_function = false)]
		protected DMAPShare ();
		[NoWrapper]
		public virtual void add_entry_to_mlcl (void* id, DPAP.DMAPRecord record, void* mb);
		[NoWrapper]
		public virtual void content_codes (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void ctrl_int (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void databases (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_browse_xxx (DPAP.DMAPShare share, Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[NoWrapper]
		public virtual void databases_items_xxx (DPAP.DMAPShare share, Soup.Server server, Soup.Message msg, string path, GLib.HashTable query, Soup.ClientContext context);
		[CCode (cname = "dmap_share_free_filter")]
		public static void free_filter (GLib.SList filter);
		[NoWrapper]
		public virtual uint get_desired_port (DPAP.DMAPShare share);
		[NoWrapper]
		public virtual void* get_meta_data_map (DPAP.DMAPShare share);
		[NoWrapper]
		public virtual unowned string get_type_of_service (DPAP.DMAPShare share);
		[NoWrapper]
		public virtual void login (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void logout (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void message_add_standard_headers (DPAP.DMAPShare share, Soup.Message msg);
		[NoWrapper]
		public virtual void name_collision (DPAP.DMAPShare share, DPAP.DMAPMdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void published (DPAP.DMAPShare share, DPAP.DMAPMdnsPublisher publisher, string name);
		[NoWrapper]
		public virtual void server_info (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoWrapper]
		public virtual void update (DPAP.DMAPShare share, Soup.Server server, Soup.Message message, string path, GLib.HashTable query, Soup.ClientContext ctx);
		[NoAccessorMethod]
		public uint auth_method { get; set; }
		[NoAccessorMethod]
		public void* container_db { get; construct; }
		[NoAccessorMethod]
		public void* db { get; construct; }
		[NoAccessorMethod]
		public string name { owned get; set; }
		[NoAccessorMethod]
		public string password { owned get; set; }
		[NoAccessorMethod]
		public uint revision_number { get; set; }
		[NoAccessorMethod]
		public Soup.Server server_ipv4 { owned get; }
		[NoAccessorMethod]
		public Soup.Server server_ipv6 { owned get; }
		[NoAccessorMethod]
		public string transcode_mimetype { owned get; construct; }
		[CCode (array_length = false, array_null_terminated = true)]
		[NoAccessorMethod]
		public string[] txt_records { owned get; set; }
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class DMAPStructureItem {
		public GLib.Value content;
		public DPAP.DMAPContentCode content_code;
		public uint32 size;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public class Share : DPAP.DMAPShare {
		[CCode (has_construct_function = false)]
		public Share (string name, string password, void* db, void* container_db, string transcode_mimetype);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	[Compact]
	public class bitwise {
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPContainerDb : GLib.Object {
		[CCode (cname = "dmap_container_db_add")]
		public abstract void add (DMAP.ContainerDb db, DPAP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_db_count")]
		public abstract int64 count (DMAP.ContainerDb db);
		[CCode (cname = "dmap_container_db_foreach")]
		public abstract void @foreach (DMAP.ContainerDb db, GLib.HFunc func, void* data);
		[CCode (cname = "dmap_container_db_lookup_by_id")]
		public abstract unowned DPAP.DMAPContainerRecord lookup_by_id (DMAP.ContainerDb db, uint id);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPContainerRecord {
		[CCode (cname = "dmap_container_record_add_entry")]
		public abstract void add_entry (DPAP.DMAPContainerRecord container_record, DPAP.DMAPRecord record, int id);
		[CCode (cname = "dmap_container_record_get_entries")]
		public abstract unowned DMAP.Db get_entries (DPAP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_record_get_entry_count")]
		public abstract uint64 get_entry_count (DPAP.DMAPContainerRecord record);
		[CCode (cname = "dmap_container_record_get_id")]
		public abstract uint get_id (DPAP.DMAPContainerRecord record);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPDb : GLib.Object {
		[CCode (cname = "dmap_db_add")]
		public abstract uint add (DMAP.Db db, DPAP.DMAPRecord record);
		[CCode (cname = "dmap_db_add_path")]
		public abstract uint add_path (DMAP.Db db, string path);
		[CCode (cname = "dmap_db_add_with_id")]
		public abstract uint add_with_id (DMAP.Db db, DPAP.DMAPRecord record, uint id);
		[CCode (cname = "dmap_db_apply_filter")]
		public static unowned GLib.HashTable apply_filter (DMAP.Db db, GLib.SList filter_def);
		[CCode (cname = "dmap_db_count")]
		public abstract int64 count (DMAP.Db db);
		[CCode (cname = "dmap_db_foreach")]
		public abstract void @foreach (DMAP.Db db, GLib.HFunc func, void* data);
		[CCode (cname = "dmap_db_lookup_by_id")]
		public abstract unowned DPAP.DMAPRecord lookup_by_id (DMAP.Db db, uint id);
		[CCode (cname = "dmap_db_lookup_id_by_location")]
		public abstract uint lookup_id_by_location (DMAP.Db db, string location);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPRecord : GLib.Object {
		[CCode (cname = "dmap_record_set_from_blob")]
		public abstract bool set_from_blob (DPAP.DMAPRecord record, GLib.ByteArray blob);
		[CCode (cname = "dmap_record_to_blob")]
		public abstract unowned GLib.ByteArray to_blob (DPAP.DMAPRecord record);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface DMAPRecordFactory {
		[CCode (cname = "dmap_record_factory_create")]
		public abstract unowned DPAP.DMAPRecord create (DMAP.RecordFactory factory);
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public interface Record {
		public abstract unowned GLib.InputStream read () throws GLib.Error;
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_PLAY_")]
	public enum DACPPlayState {
		STOPPED,
		PAUSED,
		PLAYING
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DACP_REPEAT_")]
	public enum DACPRepeatState {
		NONE,
		SINGLE,
		ALL
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_")]
	public enum DMAPConnectionState {
		GET_INFO,
		LOGIN,
		GET_REVISION_NUMBER,
		GET_DB_INFO,
		GET_SONGS,
		GET_PLAYLISTS,
		GET_PLAYLIST_ENTRIES,
		LOGOUT,
		DONE
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_", has_type_id = false)]
	public enum DMAPContentCode {
		CC_INVALID,
		RAW,
		CC_MDCL,
		CC_MSTT,
		CC_MIID,
		CC_MINM,
		CC_MIKD,
		CC_MPER,
		CC_MCON,
		CC_MCTI,
		CC_MPCO,
		CC_MSTS,
		CC_MIMC,
		CC_MCTC,
		CC_MRCO,
		CC_MTCO,
		CC_MLCL,
		CC_MLIT,
		CC_MBCL,
		CC_MSRV,
		CC_MSAU,
		CC_MSLR,
		CC_MPRO,
		CC_MSAL,
		CC_MSUP,
		CC_MSPI,
		CC_MSEX,
		CC_MSBR,
		CC_MSQY,
		CC_MSIX,
		CC_MSRS,
		CC_MSTM,
		CC_MSDC,
		CC_MCCR,
		CC_MCNM,
		CC_MCNA,
		CC_MCTY,
		CC_MLOG,
		CC_MLID,
		CC_MUPD,
		CC_MUSR,
		CC_MUTY,
		CC_MUDL,
		CC_MSMA,
		CC_FQUESCH,
		CC_APRO,
		CC_AVDB,
		CC_ABRO,
		CC_ABAL,
		CC_ABAR,
		CC_ABCP,
		CC_ABGN,
		CC_ADBS,
		CC_ASAL,
		CC_ASAI,
		CC_ASAA,
		CC_ASAR,
		CC_ASBT,
		CC_ASBR,
		CC_ASCM,
		CC_ASCO,
		CC_ASDA,
		CC_ASDM,
		CC_ASDC,
		CC_ASDN,
		CC_ASDB,
		CC_ASEQ,
		CC_ASFM,
		CC_ASGN,
		CC_ASDT,
		CC_ASRV,
		CC_ASSR,
		CC_ASSZ,
		CC_ASST,
		CC_ASSP,
		CC_ASTM,
		CC_ASTC,
		CC_ASTN,
		CC_ASUR,
		CC_ASYR,
		CC_ASDK,
		CC_ASUL,
		CC_ASSU,
		CC_ASSA,
		CC_APLY,
		CC_ABPL,
		CC_APSO,
		CC_PRSV,
		CC_ARIF,
		CC_MSAS,
		CC_AGRP,
		CC_AGAL,
		CC_ASCP,
		CC_PPRO,
		CC_PASP,
		CC_PFDT,
		CC_PICD,
		CC_PIMF,
		CC_PFMT,
		CC_PIFS,
		CC_PLSZ,
		CC_PHGT,
		CC_PWTH,
		CC_PRAT,
		CC_PCMT,
		CC_PRET,
		CC_AESV,
		CC_AEHV,
		CC_AESP,
		CC_AEPP,
		CC_AEPS,
		CC_AESG,
		CC_AEMK,
		CC_AEFP,
		CC_CMPA,
		CC_CMNM,
		CC_CMTY,
		CC_CMPG,
		CC_CACI,
		CC_CAPS,
		CC_CASH,
		CC_CARP,
		CC_CAAS,
		CC_CAAR,
		CC_CAIA,
		CC_CANP,
		CC_CANN,
		CC_CANA,
		CC_CANL,
		CC_CANG,
		CC_CANT,
		CC_CASP,
		CC_CASS,
		CC_CAST,
		CC_CASU,
		CC_CASG,
		CC_CACR,
		CC_CMCP,
		CC_CMGT,
		CC_CMIK,
		CC_CMSP,
		CC_CMST,
		CC_CMSV,
		CC_CMSR,
		CC_CMMK,
		CC_CMVO,
		CC_CMPR,
		CC_CAPR,
		CC_AEFR,
		CC_CAOV,
		CC_CMRL,
		CC_CAHP,
		CC_CAIV,
		CC_CAVC
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_ERROR_")]
	public enum DMAPMdnsBrowserError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_SERVICE_TYPE_")]
	public enum DMAPMdnsBrowserServiceType {
		INVALID,
		DAAP,
		DPAP,
		DACP,
		RAOP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_BROWSER_TRANSPORT_PROTOCOL_")]
	public enum DMAPMdnsBrowserTransportProtocol {
		TCP,
		UDP,
		LAST
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MDNS_PUBLISHER_ERROR_")]
	public enum DMAPMdnsPublisherError {
		NOT_RUNNING,
		FAILED
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_MEDIA_KIND_")]
	public enum DMAPMediaKind {
		MUSIC,
		MOVIE,
		PODCAST,
		TV_SHOW
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cprefix = "DMAP_TYPE_")]
	public enum DMAPType {
		BYTE,
		SIGNED_INT,
		SHORT,
		INT,
		INT64,
		STRING,
		DATE,
		VERSION,
		CONTAINER,
		POINTER
	}
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate bool DMAPConnectionCallback (DPAP.DMAPConnection connection, bool result, string reason);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public delegate void DMAPResponseHandler (DPAP.DMAPConnection connection, uint status, GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", has_target = false)]
	public delegate unowned string RecordGetValueFunc (DPAP.DMAPRecord record);
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_HASH_SIZE;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_HAVE_UNALIGNED_ACCESS;
	[CCode (cheader_filename = "libdmapsharing/dmap.h")]
	public const int DMAP_STATUS_OK;
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_chunked_message_finished")]
	public static void dmap_chunked_message_finished (Soup.Message message, DPAP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_dmap_type")]
	public static DPAP.DMAPType dmap_content_code_dmap_type (DPAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_name")]
	public static unowned string dmap_content_code_name (DPAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_read_from_buffer")]
	public static DPAP.DMAPContentCode dmap_content_code_read_from_buffer (string buf);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_string")]
	public static unowned string dmap_content_code_string (DPAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_code_string_as_int32")]
	public static int32 dmap_content_code_string_as_int32 (string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_content_codes")]
	public static unowned DPAP.DMAPContentCodeDefinition dmap_content_codes (uint number);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_generate")]
	public static void dmap_hash_generate (short version_major, uchar[] url, uchar hash_select, uchar[] @out, int request_id);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_final")]
	public static void dmap_hash_progressive_final (DPAP.DMAPHashContext context, uint[] digest);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_init")]
	public static void dmap_hash_progressive_init (DPAP.DMAPHashContext context);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_to_string")]
	public static void dmap_hash_progressive_to_string (uint digest, string str);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_hash_progressive_update")]
	public static void dmap_hash_progressive_update (DPAP.DMAPHashContext context, uint buffer, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_BOOLEAN__STRING")]
	public static void dmap_marshal_BOOLEAN__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_STRING__STRING")]
	public static void dmap_marshal_STRING__STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_STRING__ULONG_ULONG")]
	public static void dmap_marshal_STRING__ULONG_ULONG (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_ULONG__VOID")]
	public static void dmap_marshal_ULONG__VOID (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_BOOLEAN")]
	public static void dmap_marshal_VOID__STRING_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN")]
	public static void dmap_marshal_VOID__STRING_POINTER_POINTER_POINTER_BOOLEAN (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__STRING_STRING")]
	public static void dmap_marshal_VOID__STRING_STRING (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_marshal_VOID__ULONG_FLOAT")]
	public static void dmap_marshal_VOID__ULONG_FLOAT (GLib.Closure closure, GLib.Value return_value, uint n_param_values, GLib.Value param_values, void* invocation_hint, void* marshal_data);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mdns_avahi_get_client")]
	public static unowned Avahi.Client dmap_mdns_avahi_get_client ();
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mdns_avahi_set_entry_group")]
	public static void dmap_mdns_avahi_set_entry_group (Avahi.EntryGroup group);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_mime_to_format")]
	public static unowned string dmap_mime_to_format (string transcode_mimetype);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_add")]
	public static unowned GLib.Node dmap_structure_add (GLib.Node parent, DPAP.DMAPContentCode cc);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_destroy")]
	public static void dmap_structure_destroy (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_find_item")]
	public static unowned DPAP.DMAPStructureItem dmap_structure_find_item (GLib.Node structure, DPAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_find_node")]
	public static unowned GLib.Node dmap_structure_find_node (GLib.Node structure, DPAP.DMAPContentCode code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_get_size")]
	public static uint dmap_structure_get_size (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_increase_by_predicted_size")]
	public static void dmap_structure_increase_by_predicted_size (GLib.Node structure, uint size);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_parse")]
	public static unowned GLib.Node dmap_structure_parse (string buf, int buf_length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_print")]
	public static void dmap_structure_print (GLib.Node structure);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_structure_serialize")]
	public static unowned string dmap_structure_serialize (GLib.Node structure, uint length);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmap_write_next_chunk")]
	public static void dmap_write_next_chunk (Soup.Message message, DPAP.ChunkData cd);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "dmapd_input_stream_strdup_format_extension")]
	public static unowned string dmapd_input_stream_strdup_format_extension (int format_code);
	[CCode (cheader_filename = "libdmapsharing/dmap.h", cname = "pads_compatible")]
	public static bool pads_compatible (Gst.Pad pad1, Gst.Pad pad2);
}
