/*
 * Copyright (c) 1999-2007 Apple Inc. All rights reserved.
 *
 * @APPLE_OSREFERENCE_LICENSE_HEADER_START@
 * 
 * This file contains Original Code and/or Modifications of Original Code
 * as defined in and that are subject to the Apple Public Source License
 * Version 2.0 (the 'License'). You may not use this file except in
 * compliance with the License. The rights granted to you under the License
 * may not be used to create, or enable the creation or redistribution of,
 * unlawful or unlicensed copies of an Apple operating system, or to
 * circumvent, violate, or enable the circumvention or violation of, any
 * terms of an Apple operating system software license agreement.
 * 
 * Please obtain a copy of the License at
 * http://www.opensource.apple.com/apsl/ and read it before using this file.
 * 
 * The Original Code and all software distributed under the License are
 * distributed on an 'AS IS' basis, WITHOUT WARRANTY OF ANY KIND, EITHER
 * EXPRESS OR IMPLIED, AND APPLE HEREBY DISCLAIMS ALL SUCH WARRANTIES,
 * INCLUDING WITHOUT LIMITATION, ANY WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE, QUIET ENJOYMENT OR NON-INFRINGEMENT.
 * Please see the License for the specific language governing rights and
 * limitations under the License.
 * 
 * @APPLE_OSREFERENCE_LICENSE_HEADER_END@
 */
/* Copyright (c) 1992 NeXT Computer, Inc.  All rights reserved. */

#include "SYS.h"

#if defined(__ppc__) || defined(__ppc64__)

__SYSCALL(__syscall, syscall, 7)

#elif defined(__i386__)

LEAF(___syscall, 0)
	popl	%ecx		// ret addr
	popl	%eax		// syscall number
	pushl	%ecx
	UNIX_SYSCALL_TRAP
	movl	(%esp),%edx	// add one element to stack so
	pushl	%ecx		// caller "pop" will work
	jnb	2f
	BRANCH_EXTERN(cerror)
2:
END(___syscall)

#elif defined(__x86_64__)

// For x86-64, the kernel slides the argument list for us.
// The number of arguments here is variable, but our macros ignore
// that value anyway.
__SYSCALL(__syscall, syscall, 0);

#else
#error Unsupported architecture
#endif
