/*
 * Codepage definitions for libcdatetime
 *
 * Copyright (C) 2006-2015, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This software is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this software.  If not, see <http://www.gnu.org/licenses/>.
 */

#if !defined( _LIBCDATETIME_CODEPAGE_H )
#define _LIBCDATETIME_CODEPAGE_H

#include <libcdatetime/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBCDATETIME_CODEPAGES
{
	LIBCDATETIME_CODEPAGE_ASCII				= 20127,

	LIBCDATETIME_CODEPAGE_ISO_8859_1			= 28591,
	LIBCDATETIME_CODEPAGE_ISO_8859_2			= 28592,
	LIBCDATETIME_CODEPAGE_ISO_8859_3			= 28593,
	LIBCDATETIME_CODEPAGE_ISO_8859_4			= 28594,
	LIBCDATETIME_CODEPAGE_ISO_8859_5			= 28595,
	LIBCDATETIME_CODEPAGE_ISO_8859_6			= 28596,
	LIBCDATETIME_CODEPAGE_ISO_8859_7			= 28597,
	LIBCDATETIME_CODEPAGE_ISO_8859_8			= 28598,
	LIBCDATETIME_CODEPAGE_ISO_8859_9			= 28599,
	LIBCDATETIME_CODEPAGE_ISO_8859_10			= 28600,
	LIBCDATETIME_CODEPAGE_ISO_8859_11			= 28601,
	LIBCDATETIME_CODEPAGE_ISO_8859_13			= 28603,
	LIBCDATETIME_CODEPAGE_ISO_8859_14			= 28604,
	LIBCDATETIME_CODEPAGE_ISO_8859_15			= 28605,
	LIBCDATETIME_CODEPAGE_ISO_8859_16			= 28606,

	LIBCDATETIME_CODEPAGE_KOI8_R			= 20866,
	LIBCDATETIME_CODEPAGE_KOI8_U			= 21866,

	LIBCDATETIME_CODEPAGE_WINDOWS_874			= 874,
	LIBCDATETIME_CODEPAGE_WINDOWS_932			= 932,
	LIBCDATETIME_CODEPAGE_WINDOWS_936			= 936,
	LIBCDATETIME_CODEPAGE_WINDOWS_949			= 949,
	LIBCDATETIME_CODEPAGE_WINDOWS_950			= 950,
	LIBCDATETIME_CODEPAGE_WINDOWS_1250			= 1250,
	LIBCDATETIME_CODEPAGE_WINDOWS_1251			= 1251,
	LIBCDATETIME_CODEPAGE_WINDOWS_1252			= 1252,
	LIBCDATETIME_CODEPAGE_WINDOWS_1253			= 1253,
	LIBCDATETIME_CODEPAGE_WINDOWS_1254			= 1254,
	LIBCDATETIME_CODEPAGE_WINDOWS_1255			= 1255,
	LIBCDATETIME_CODEPAGE_WINDOWS_1256			= 1256,
	LIBCDATETIME_CODEPAGE_WINDOWS_1257			= 1257,
	LIBCDATETIME_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBCDATETIME_CODEPAGE_US_ASCII			LIBCDATETIME_CODEPAGE_ASCII

#define LIBCDATETIME_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBCDATETIME_CODEPAGE_ISO_8859_1
#define LIBCDATETIME_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBCDATETIME_CODEPAGE_ISO_8859_2
#define LIBCDATETIME_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBCDATETIME_CODEPAGE_ISO_8859_3
#define LIBCDATETIME_CODEPAGE_ISO_NORTH_EUROPEAN		LIBCDATETIME_CODEPAGE_ISO_8859_4
#define LIBCDATETIME_CODEPAGE_ISO_CYRILLIC			LIBCDATETIME_CODEPAGE_ISO_8859_5
#define LIBCDATETIME_CODEPAGE_ISO_ARABIC			LIBCDATETIME_CODEPAGE_ISO_8859_6
#define LIBCDATETIME_CODEPAGE_ISO_GREEK			LIBCDATETIME_CODEPAGE_ISO_8859_7
#define LIBCDATETIME_CODEPAGE_ISO_HEBREW			LIBCDATETIME_CODEPAGE_ISO_8859_8
#define LIBCDATETIME_CODEPAGE_ISO_TURKISH			LIBCDATETIME_CODEPAGE_ISO_8859_9
#define LIBCDATETIME_CODEPAGE_ISO_NORDIC			LIBCDATETIME_CODEPAGE_ISO_8859_10
#define LIBCDATETIME_CODEPAGE_ISO_THAI			LIBCDATETIME_CODEPAGE_ISO_8859_11
#define LIBCDATETIME_CODEPAGE_ISO_BALTIC			LIBCDATETIME_CODEPAGE_ISO_8859_13
#define LIBCDATETIME_CODEPAGE_ISO_CELTIC			LIBCDATETIME_CODEPAGE_ISO_8859_14

#define LIBCDATETIME_CODEPAGE_ISO_LATIN_1			LIBCDATETIME_CODEPAGE_ISO_8859_1
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_2			LIBCDATETIME_CODEPAGE_ISO_8859_2
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_3			LIBCDATETIME_CODEPAGE_ISO_8859_3
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_4			LIBCDATETIME_CODEPAGE_ISO_8859_4
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_5			LIBCDATETIME_CODEPAGE_ISO_8859_9
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_6			LIBCDATETIME_CODEPAGE_ISO_8859_10
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_7			LIBCDATETIME_CODEPAGE_ISO_8859_13
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_8			LIBCDATETIME_CODEPAGE_ISO_8859_14
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_9			LIBCDATETIME_CODEPAGE_ISO_8859_15
#define LIBCDATETIME_CODEPAGE_ISO_LATIN_10			LIBCDATETIME_CODEPAGE_ISO_8859_16

#define LIBCDATETIME_CODEPAGE_KOI8_RUSSIAN			LIBCDATETIME_CODEPAGE_KOI8_R
#define LIBCDATETIME_CODEPAGE_KOI8_UKRAINIAN		LIBCDATETIME_CODEPAGE_KOI8_U

#define LIBCDATETIME_CODEPAGE_WINDOWS_THAI			LIBCDATETIME_CODEPAGE_WINDOWS_874
#define LIBCDATETIME_CODEPAGE_WINDOWS_JAPANESE		LIBCDATETIME_CODEPAGE_WINDOWS_932
#define LIBCDATETIME_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBCDATETIME_CODEPAGE_WINDOWS_936
#define LIBCDATETIME_CODEPAGE_WINDOWS_KOREAN		LIBCDATETIME_CODEPAGE_WINDOWS_949
#define LIBCDATETIME_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBCDATETIME_CODEPAGE_WINDOWS_950
#define LIBCDATETIME_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBCDATETIME_CODEPAGE_WINDOWS_1250
#define LIBCDATETIME_CODEPAGE_WINDOWS_CYRILLIC		LIBCDATETIME_CODEPAGE_WINDOWS_1251
#define LIBCDATETIME_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBCDATETIME_CODEPAGE_WINDOWS_1252
#define LIBCDATETIME_CODEPAGE_WINDOWS_GREEK			LIBCDATETIME_CODEPAGE_WINDOWS_1253
#define LIBCDATETIME_CODEPAGE_WINDOWS_TURKISH		LIBCDATETIME_CODEPAGE_WINDOWS_1254
#define LIBCDATETIME_CODEPAGE_WINDOWS_HEBREW		LIBCDATETIME_CODEPAGE_WINDOWS_1255
#define LIBCDATETIME_CODEPAGE_WINDOWS_ARABIC		LIBCDATETIME_CODEPAGE_WINDOWS_1256
#define LIBCDATETIME_CODEPAGE_WINDOWS_BALTIC		LIBCDATETIME_CODEPAGE_WINDOWS_1257
#define LIBCDATETIME_CODEPAGE_WINDOWS_VIETNAMESE		LIBCDATETIME_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif

