/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2007  Hagen Mbius & Aram Altschudjian
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <stdexcept>
#include <string>

#include "LineBuffer.h"

LineBuffer::LineBuffer(void) :
	m_FinishedWithCarriageReturn(false)
{
}

void LineBuffer::PushString(const std::string & String)
{
	m_String += String;
}

std::string LineBuffer::PopLine(void)
{
	std::string::size_type Index(0);
	std::string Result;
	
	while(Index < m_String.length())
	{
		if(m_String[Index] == '\r')
		{
			if(Index + 1 == m_String.length())
			{
				m_FinishedWithCarriageReturn = true;
				Result = m_String.substr(0, Index);
				m_String.erase(0, Index + 1);
				
				return Result;
			}
			else
			{
				if(m_String[Index + 1] == '\n')
				{
					Result = m_String.substr(0, Index);
					m_String.erase(0, Index + 2);
					
					return Result;
				}
				else
				{
					Result = m_String.substr(0, Index);
					m_String.erase(0, Index + 1);
					
					return Result;
				}
			}
		}
		else if(m_String[Index] == '\n')
		{
			if(m_FinishedWithCarriageReturn == true)
			{
				m_FinishedWithCarriageReturn = false;
				if(Index == 0)
				{
					m_String.erase(0, 1);
					
					continue;
				}
				else
				{
					Result = m_String.substr(0, Index);
					m_String.erase(0, Index + 1);
					
					return Result;
				}
			}
			else
			{
				Result = m_String.substr(0, Index);
				m_String.erase(0, Index + 1);
				
				return Result;
			}
		}
		++Index;
	}
	throw std::underflow_error("no newline in buffer");
}

std::string LineBuffer::PopAll(void)
{
	std::string Result(m_String);
	
	m_String.clear();
	
	return Result;
}

bool LineBuffer::IsEmpty(void)
{
	std::string::size_type Index(0);
	
	while(Index < m_String.length())
	{
		if(m_String[Index] == '\r')
		{
			return false;
		}
		else if(m_String[Index] == '\n')
		{
			if((m_FinishedWithCarriageReturn == false) || (Index > 0))
			{
				return false;
			}
		}
		++Index;
	}
	return true;
}
