/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2006  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <string.h>

#include "../Include/Arxx.h"

#include <iomanip>
#include <iostream>

#define EqualTest(A, B) vEqualTest((A), (B), __LINE__)
#define UnequalTest(A, B) vUnequalTest((A), (B), __LINE__)
#define TraceException(A) { g_u4ExceptionLine = __LINE__; (A); g_u4ExceptionLine = 0; }
#define BufferTest(Buffer, Start, End, Expect) vBufferTest(Buffer, Start, End, Expect, __LINE__)
#define ExceptionTest(A, B) { g_u4ExceptionLine = __LINE__; try { (A); throw std::logic_error("exception expected"); } catch(B & exception) { } g_u4ExceptionLine = 0; }

std::string g_sYellow("\033[33;1m");
std::string g_sGreen("\033[32m");
std::string g_sGray("\033[30;1m");
std::string g_sRed("\033[31;1m");
std::string g_sWhite("\033[0m");

#define StartBlock(A) { g_Blocks.push_back((A)); std::cout << "Beginning Block \"" << (A) << "\"." << std::endl; }
#define EndBlock(A) { std::cout << "Ending Block \"" << g_Blocks.back() << "\"." << std::endl; g_Blocks.pop_back(); }
#define StartTest(A) try { std::cout << std::setw(3) << g_sYellow << ++g_u4Tests << ". Test" << g_sWhite << ": " << (A) << " ... " << std::endl;
#define EndTest() std::cout << g_sGreen << "passed" << g_sWhite << '.' << std::endl; } catch(std::exception & Exception) { std::cout << "\n\t" << g_sRed << "Exception" << g_sWhite << ": " << Exception.what() << "\n\t" << g_sYellow; if(g_u4ExceptionLine == 0) { std::cout << "Unknown line." << g_sWhite; } else { std::cout << "Line" << g_sWhite << ": " << g_u4ExceptionLine; g_u4ExceptionLine = 0; } std::cout << std::endl << std::endl; g_bError = true; g_u4Errors++; }

bool g_bError = false;
Arxx::u4byte g_u4Tests(0);
Arxx::u4byte g_u4Errors(0);
Arxx::u4byte g_u4ExceptionLine(0);
std::vector< std::string > g_Blocks;

template < typename T >
void vEqualTest(const T & t1, const T & t2, unsigned long ulLineNumber)
{
	if((t1 == t2) == false)
	{
		std::cout << "\n\n\t" << __FILE__ << ':' << ulLineNumber << ": Equality test failed!" << std::endl;
		std::cout << "\t\tExpected: \"" << t2 << '"' << std::endl;
		std::cout << "\t\tResult  : \"" << t1 << '"';
		g_u4ExceptionLine = ulLineNumber;
		throw std::runtime_error("Equality failed.");
	}
}

template < typename T >
void vUnequalTest(const T & t1, const T & t2, unsigned long ulLineNumber)
{
	if(t1 == t2)
	{
		std::cout << "\n\n\t" << __FILE__ << ':' << ulLineNumber << ": Inequality test failed!" << std::endl;
		std::cout << "\t\tExpected: != \"" << t2 << '"' << std::endl;
		std::cout << "\t\tResult: \"" << t1 << '"';
		g_u4ExceptionLine = ulLineNumber;
		throw std::runtime_error("Inequality failed.");
	}
}

inline void vBufferTest(const Arxx::Buffer & Buffer, const Arxx::Buffer::size_type & stStart, const Arxx::Buffer::size_type & stLength, const char * pcExpectedData, unsigned long ulLineNumber)
{
	size_t stI = 0;
	
	if(strlen(pcExpectedData) != stLength)
	{
		std::cout << "\n\n\t" << __FILE__ << ':' << ulLineNumber << ": Miscoded test!" << std::endl;
		std::cout << "\t\tExpected Length: " << stLength << std::endl;
		std::cout << "\t\tString Length: " << strlen(pcExpectedData) << std::endl;
		g_u4ExceptionLine = ulLineNumber;
		throw std::runtime_error("Miscoded test.");
	}
	while(stI < stLength)
	{
		if(Buffer[stStart + stI] != pcExpectedData[stI])
		{
			std::cout << "\n\n\t" << __FILE__ << ':' << ulLineNumber << ": Buffer test failed!" << std::endl;
			std::cout << "\t\tPosition: " << (stStart + stI) << std::endl;
			std::cout << "\t\tExpected: " << static_cast< Arxx::u4byte >(pcExpectedData[stI]) << std::endl;
			std::cout << "\t\tResult: " << static_cast< Arxx::u4byte >(Buffer[stStart + stI]) << std::endl;
			g_u4ExceptionLine = ulLineNumber;
			throw std::runtime_error("Buffer test failed.");
		}
		++stI;
	}
}

inline int iEndTests(void)
{
	if(g_u4Errors > 0)
	{
		if(g_u4Errors == 1)
		{
			std::cout << std::endl << "There was " << g_sRed << "1 error" << g_sWhite << " running the test suite." << std::endl << std::endl;
		}
		else
		{
			std::cout << std::endl << "There were " << g_sRed << g_u4Errors << " errors" << g_sWhite << " running the test suite." << std::endl << std::endl;
		}
		
		return g_u4Errors;
	}
	else
	{
		std::cout << std::endl << "All tests " << g_sGreen << "passed" << g_sWhite << '.' << std::endl << std::endl;
		
		return 0;
	}
}

inline void PrintBuffer(const Arxx::Buffer & Buffer)
{
	std::cout << "--- Start (" << Buffer.stGetLength() << ") ---" << std::endl;
	for(Arxx::Buffer::size_type Index = 0; Index < Buffer.stGetLength(); ++Index)
	{
		std::cout << Buffer[Index];
	}
	std::cout << "\n--- End (" << Buffer.stGetLength() << ") ---" << std::endl;
}
