/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "../config.h"

#ifdef DEBUG
#include <iostream>
#endif

#include "../Include/Buffer.h"
#include "../Include/DataChannel.h"
#include "../Include/DataRepository.h"
#include "../Include/URI.h"

Arxx::DataRepository Arxx::Repository;


///////////////////////////////////////////////////////////////////////////////////////////////////
// Arxx::DataRepository                                                                           //
///////////////////////////////////////////////////////////////////////////////////////////////////

Arxx::DataRepository::DataRepository(void)
{
}

bool Arxx::DataRepository::bRegisterDataChannel(Arxx::DataChannel * pDataChannel)
{
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(m_DataChannels.find(pDataChannel->GetURI()));
	
	if(iDataChannel != m_DataChannels.end())
	{
		return false;
	}
	m_DataChannels[pDataChannel->GetURI()] = pDataChannel;
	
	return true;
}

bool Arxx::DataRepository::bUnregisterDataChannel(Arxx::DataChannel * pDataChannel)
{
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(m_DataChannels.find(pDataChannel->GetURI()));
	
	if(iDataChannel == m_DataChannels.end())
	{
		return false;
	}
	m_DataChannels.erase(iDataChannel);
	
	return true;
}

bool Arxx::DataRepository::bFetchData(const Arxx::URI & URI, Arxx::Buffer & Buffer, Arxx::FetchStatus & FetchStatus)
{
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(iGetDataChannel(URI));
	
	if(iDataChannel != m_DataChannels.end())
	{
		return iDataChannel->second->bFetchData(URI, Buffer, FetchStatus);
	}
	else
	{
		return false;
	}
}

void Arxx::DataRepository::vReferenceDataChannel(const Arxx::URI & URI)
{
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(iGetDataChannel(URI));
	
	if(iDataChannel != m_DataChannels.end())
	{
		iDataChannel->second->vReference();
	}
}

void Arxx::DataRepository::vDereferenceDataChannel(const Arxx::URI & URI)
{
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(iGetDataChannel(URI));
	
	if(iDataChannel != m_DataChannels.end())
	{
		iDataChannel->second->vDereference();
		if((iDataChannel->second->bIsReferenced() == false) && (iDataChannel->second->bWantsAutoDeletion() == true))
		{
			Arxx::DataChannel * pDataChannel(iDataChannel->second);
			
			m_DataChannels.erase(iDataChannel);
			delete pDataChannel;
		}
	}
}

bool Arxx::DataRepository::bHasDataChannel(const Arxx::URI & URI)
{
#ifdef DEBUG
	std::cerr << "> bHasDataChannel(URI = \"" << URI << "\")." << std::endl;
#endif
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(iGetDataChannel(URI));
	
	if(iDataChannel != m_DataChannels.end())
	{
		return true;
	}
	
	return false;
}

const Arxx::DataChannel * Arxx::DataRepository::pGetDataChannel(const Arxx::URI & URI)
{
#ifdef DEBUG
	std::cerr << "> pGetDataChannel(URI = \"" << URI << "\")." << std::endl;
#endif
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel(iGetDataChannel(URI));
	
	if(iDataChannel != m_DataChannels.end())
	{
		return iDataChannel->second;
	}
	
	return 0;
}

std::map< Arxx::URI, Arxx::DataChannel * >::iterator Arxx::DataRepository::iGetDataChannel(const Arxx::URI & URI)
{
#ifdef DEBUG
	std::cerr << ">   Requesting channel for URI \"" << URI << "\"." << std::endl;
#endif
	/// @todo This DEFINITELY has to be done a better way. Why use a map when we have to walk it all.
	std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannelCandidate(m_DataChannels.end());
	
	for(std::map< Arxx::URI, Arxx::DataChannel * >::iterator iDataChannel = m_DataChannels.begin(); iDataChannel != m_DataChannels.end(); ++iDataChannel)
	{
#ifdef DEBUG
		std::cerr << "      Probing \"" << iDataChannel->first << "\"." << std::endl;
#endif
		if(URI.sGetScheme() > iDataChannel->first.sGetScheme())
		{
			if((iDataChannel->first.sGetScheme() == "") && (iDataChannel->first.sGetAuthority() == "") && (iDataChannel->first.sGetPath() == "") && (iDataChannel->first.sGetQuery() == "") && (iDataChannel->first.sGetFragment() == ""))
			{
				iDataChannelCandidate = iDataChannel;
			}
			
			continue;
		}
		if(URI.sGetScheme() == iDataChannel->first.sGetScheme())
		{
			if(URI.sGetAuthority() > iDataChannel->first.sGetAuthority())
			{
				if((iDataChannel->first.sGetAuthority() == "") && (iDataChannel->first.sGetPath() == "") && (iDataChannel->first.sGetQuery() == "") && (iDataChannel->first.sGetFragment() == ""))
				{
					iDataChannelCandidate = iDataChannel;
				}
				
				continue;
			}
			if(URI.sGetAuthority() == iDataChannel->first.sGetAuthority())
			{
				if(URI.sGetPath() > iDataChannel->first.sGetPath())
				{
					if((iDataChannel->first.sGetPath() == URI.sGetPath().substr(0, iDataChannel->first.sGetPath().length())) && (iDataChannel->first.sGetQuery() == "") && (iDataChannel->first.sGetFragment() == ""))
					{
						iDataChannelCandidate = iDataChannel;
					}
					
					continue;
				}
				if(URI.sGetPath() == iDataChannel->first.sGetPath())
				{
					if(URI.sGetQuery() > iDataChannel->first.sGetQuery())
					{
						if((iDataChannel->first.sGetQuery() == "") && (iDataChannel->first.sGetFragment() == ""))
						{
							iDataChannelCandidate = iDataChannel;
						}
						
						continue;
					}
					if(URI.sGetQuery() == iDataChannel->first.sGetQuery())
					{
						if(URI.sGetFragment() > iDataChannel->first.sGetFragment())
						{
							if(iDataChannel->first.sGetFragment() == "")
							{
								iDataChannelCandidate = iDataChannel;
							}
							
							continue;
						}
						if(URI.sGetFragment() == iDataChannel->first.sGetFragment())
						{
							iDataChannelCandidate = iDataChannel;
						}
						else
						{
							break;
						}
					}
					else
					{
						break;
					}
				}
				else
				{
					break;
				}
			}
			else
			{
				break;
			}
		}
		else
		{
			break;
		}
	}
	if(iDataChannelCandidate != m_DataChannels.end())
	{
#ifdef DEBUG
	std::cerr << "<   Returning channel with URI \"" << iDataChannelCandidate->first << "\"." << std::endl;
#endif
	}
	else
	{
#ifdef DEBUG
		std::cerr << "<   No channel found." << std::endl;
#endif
	}
	
	return iDataChannelCandidate;
}
