/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <iostream>

#include "../config.h"
#include "../Include/DataChannel.h"

///////////////////////////////////////////////////////////////////////////////////////////////////
// Arxx::DataChannel                                                                              //
///////////////////////////////////////////////////////////////////////////////////////////////////

Arxx::DataChannel::DataChannel(const Arxx::URI & URI) :
	m_bWantsAutoDeletion(false),
	m_u4ReferenceCounter(0),
	m_URI(URI)
{
#ifdef DEBUG
	std::cerr << "+ Arxx::DataChannel" << std::endl;
#endif
}

Arxx::DataChannel::~DataChannel(void)
{
	if(m_u4ReferenceCounter > 0)
	{
		std::cerr << " *** Arxx::DataChannel - Error: Use counter for channel with URL \"" << m_URI << "\" is " << m_u4ReferenceCounter << " instead of 0." << std::endl;
	}
#ifdef DEBUG
	std::cerr << "- Arxx::DataChannel" << std::endl;
#endif
}

void Arxx::DataChannel::vReference(void)
{
#ifdef DEBUG
	std::cerr << "! Referencing channel with URI \"" << m_URI << "\"." << std::endl;
#endif
	++m_u4ReferenceCounter;
}

void Arxx::DataChannel::vDereference(void)
{
#ifdef DEBUG
	std::cerr << "! Dereferencing channel with URI \"" << m_URI << "\"." << std::endl;
#endif
	if(m_u4ReferenceCounter == 0)
	{
		std::cerr << " *** Arxx::DataChannel - Error: Illegally releasing the reference counter for " << this << " which is 0." << std::endl;
	}
	--m_u4ReferenceCounter;
	if(m_u4ReferenceCounter == 0)
	{
#ifdef DEBUG
		std::cerr << "!!  Channel with URI \"" << m_URI << "\" is unreferenced." << std::endl;
#endif
		vOnUnreferenced();
	}
}

bool Arxx::DataChannel::bIsReferenced(void) const
{
	return m_u4ReferenceCounter > 0;
}

const Arxx::URI & Arxx::DataChannel::GetURI(void) const
{
	return m_URI;
}

bool Arxx::DataChannel::bWantsAutoDeletion(void) const
{
	return m_bWantsAutoDeletion;
}

void Arxx::DataChannel::vOnUnreferenced(void)
{
}
