/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include "../config.h"
#include "../Include/Archive.h"
#include "../Include/Item.h"
#include "../Include/Merge.h"

///////////////////////////////////////////////////////////////////////////////////////////////////
//  Arxx::Context                                                                                 //
///////////////////////////////////////////////////////////////////////////////////////////////////

Arxx::Context::Context(Arxx::Archive & TargetArchive, Arxx::Archive & SourceArchive) :
	m_TargetArchive(TargetArchive),
	m_SourceArchive(SourceArchive),
	m_pCurrentItem(0)
{
}

Arxx::Item & Arxx::Context::GetCurrentItem(void) const
{
	return *m_pCurrentItem;
}

const Arxx::Archive & Arxx::Context::GetTargetArchive(void) const
{
	return m_TargetArchive;
}

const Arxx::Archive & Arxx::Context::GetSourceArchive(void) const
{
	return m_SourceArchive;
}

void Arxx::Context::vSetCurrentItem(Arxx::Item & Item)
{
	assert(Item.pGetArchive() == 0);
	m_pCurrentItem = &Item;
}

void Arxx::Context::vAddingItem(Arxx::Item & Item)
{
	assert(Item.pGetArchive() == 0);
	m_AddingItems.push_back(&Item);
}

void Arxx::Context::vAddItems(void)
{
	for(std::vector< Arxx::Item * >::size_type stItem = m_AddingItems.size(); stItem > 0; --stItem)
	{
		try
		{
			m_TargetArchive.vRegisterItem(*(m_AddingItems[stItem - 1]));
		}
		catch(Arxx::id_not_unique & Exception)
		{
		}
		m_AddingItems.erase(m_AddingItems.begin() + stItem - 1);
	}
}
