/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <iostream>
#include <fstream>
#include <string>

#include <Arxx.h>
#include <BufferWriter.h>
#include <DataChannel.h>
#include <DataRepository.h>

const Arxx::u4byte g_u4AssembleHostname = 0x00000001;
const Arxx::u4byte g_u4AssembleDomainname = 0x00000002;
const Arxx::u4byte g_u4AssembleOSType = 0x00000003;
const Arxx::u4byte g_u4AssembleOSRelease = 0x00000004;
const Arxx::u4byte g_u4LiveHostname = 0x00000005;
const Arxx::u4byte g_u4LiveDomainname = 0x00000006;
const Arxx::u4byte g_u4LiveOSType = 0x00000007;
const Arxx::u4byte g_u4LiveOSRelease = 0x00000008;

class LocalFileChannel : public Arxx::DataChannel
{
public:
	LocalFileChannel(void) :
		Arxx::DataChannel("file://")
	{
	}
	
	virtual bool bFetchData(const Arxx::URI & URI, Arxx::Buffer & Buffer, Arxx::FetchStatus & FetchStatus)
	{
		if(URI.sGetScheme() != "file")
		{
			std::cerr << " *** LocalFileChannel::bFetchData called with scheme \"" << URI.sGetScheme() << "\" but \"file\" was expected." << std::endl;
			
			return false;
		}
		if((URI.sGetAuthority() != "") && (URI.sGetAuthority() != "localhost") && (URI.sGetAuthority() != "127.0.0.1"))
		{
			std::cerr << " *** LocalFileChannel::bFetchData called with authority \"" << URI.sGetAuthority() << "\" but \"\", \"localhost\" or \"127.0.0.1\" was expected." << std::endl;
			
			return false;
		}
		
		std::ifstream IStream(URI.sGetPath().c_str());
		
		if(IStream == false)
		{
			std::cerr << " *** LocalFileChannel::bFetchData: Could not open file with URI \"" << URI << "\"." << std::endl;
			
			return false;
		}
		Buffer.vSetLength(0);
		
		Arxx::BufferWriter BufferWriter(Buffer);
		
		FetchStatus = Arxx::TRANSFERING;
		BufferWriter << std::make_pair(static_cast< Arxx::Buffer::size_type >(0xFFFFFFFF), reinterpret_cast< std::istream * >(&IStream));
		IStream.close();
		FetchStatus = Arxx::FETCHED;
		
		return true;
	}
} g_LocalFileChannel;
