/**
 * libarxx - Advanced Resource files in C++
 * Copyright (C) 2005  Hagen Möbius
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
**/

#include <BufferWriter.h>

#include "common.h"

int main(int argc, char ** argv)
{	
	Arxx::Archive Archive;
	Arxx::Item Item1(Archive, g_u4Item1);
	Arxx::Item Item2(Archive, g_u4Item2);
	Arxx::Item Item3(Archive, g_u4Item3);
	Arxx::Item Item4(Archive, g_u4Item4);
	Arxx::Item Item5(Archive, g_u4Item5);
	Arxx::Item Item6(Archive, g_u4Item6);
	Arxx::BufferWriter BufferWriter1(Item1);
	Arxx::BufferWriter BufferWriter2(Item2);
	Arxx::BufferWriter BufferWriter3(Item3);
	Arxx::BufferWriter BufferWriter4(Item4);
	Arxx::BufferWriter BufferWriter5(Item5);
	Arxx::BufferWriter BufferWriter6(Item6);
	
	Item1.vSetName("Item 1 (huge)");
	Item2.vSetName("Item 2 (big)");
	Item3.vSetName("Item 3 (only half the size of Item 1)");
	Item4.vSetName("Item 4 (as big as Item 3)");
	Item5.vSetName("Item 5 (big)");
	Item6.vSetName("Item 6 (double the size of Item 4)");
	for(int iI = 0; iI < 100000; ++iI)
	{
		BufferWriter1 << static_cast< Arxx::u4byte >(iI);
		BufferWriter1 << static_cast< Arxx::u4byte >(iI);
		BufferWriter1 << static_cast< Arxx::u4byte >(iI);
		BufferWriter1 << static_cast< Arxx::u4byte >(iI);
		BufferWriter2 << static_cast< Arxx::u4byte >(iI);
		BufferWriter2 << static_cast< Arxx::u4byte >(iI);
		BufferWriter2 << static_cast< Arxx::u4byte >(iI);
		BufferWriter3 << static_cast< Arxx::u4byte >(iI);
		BufferWriter3 << static_cast< Arxx::u4byte >(iI);
		BufferWriter4 << static_cast< Arxx::u4byte >(iI);
		BufferWriter4 << static_cast< Arxx::u4byte >(iI);
		BufferWriter5 << static_cast< Arxx::u4byte >(iI);
		BufferWriter5 << static_cast< Arxx::u4byte >(iI);
		BufferWriter5 << static_cast< Arxx::u4byte >(iI);
		BufferWriter6 << static_cast< Arxx::u4byte >(iI);
		BufferWriter6 << static_cast< Arxx::u4byte >(iI);
		BufferWriter6 << static_cast< Arxx::u4byte >(iI);
		BufferWriter6 << static_cast< Arxx::u4byte >(iI);
	}
	Archive.vSave("example.arx");
	
	return 0;
}
