/*++

Copyright (C) 2019 3MF Consortium (Original Author)

All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

1. Redistributions of source code must retain the above copyright notice, this
list of conditions and the following disclaimer.
2. Redistributions in binary form must reproduce the above copyright notice,
this list of conditions and the following disclaimer in the documentation
and/or other materials provided with the distribution.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

This file has been generated by the Automatic Component Toolkit (ACT) version 1.6.0.

Abstract: This is an autogenerated C++ implementation file in order to allow easy
development of the 3MF Library. The functions in this file need to be implemented. It needs to be generated only once.

Interface version: 2.2.0

*/

#include "lib3mf_abi.hpp"
#include "lib3mf_interfaces.hpp"
#include "lib3mf_interfaceexception.hpp"
#include "lib3mf_interfacejournal.hpp"

#include <map>

using namespace Lib3MF::Impl;

PLib3MFInterfaceJournal m_GlobalJournal;

Lib3MFResult handleLib3MFException(IBase * pIBaseClass, ELib3MFInterfaceException & Exception, CLib3MFInterfaceJournalEntry * pJournalEntry = nullptr)
{
	Lib3MFResult errorCode = Exception.getErrorCode();

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

Lib3MFResult handleStdException(IBase * pIBaseClass, std::exception & Exception, CLib3MFInterfaceJournalEntry * pJournalEntry = nullptr)
{
	Lib3MFResult errorCode = LIB3MF_ERROR_GENERICEXCEPTION;

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage(Exception.what());

	return errorCode;
}

Lib3MFResult handleUnhandledException(IBase * pIBaseClass, CLib3MFInterfaceJournalEntry * pJournalEntry = nullptr)
{
	Lib3MFResult errorCode = LIB3MF_ERROR_GENERICEXCEPTION;

	if (pJournalEntry != nullptr)
		pJournalEntry->writeError(errorCode);

	if (pIBaseClass != nullptr)
		pIBaseClass->RegisterErrorMessage("Unhandled Exception");

	return errorCode;
}



/*************************************************************************************************************************
 Class implementation for Base
**************************************************************************************************************************/

/*************************************************************************************************************************
 Class implementation for Writer
**************************************************************************************************************************/
Lib3MFResult lib3mf_writer_writetofile(Lib3MF_Writer pWriter, const char * pFilename)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "WriteToFile");
			pJournalEntry->addStringParameter("Filename", pFilename);
		}
		if (pFilename == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFilename(pFilename);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->WriteToFile(sFilename);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getstreamsize(Lib3MF_Writer pWriter, Lib3MF_uint64 * pStreamSize)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetStreamSize");
		}
		if (pStreamSize == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStreamSize = pIWriter->GetStreamSize();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("StreamSize", *pStreamSize);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_writetobuffer(Lib3MF_Writer pWriter, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "WriteToBuffer");
		}
		if ((!pBufferBuffer) && !(pBufferNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->WriteToBuffer(nBufferBufferSize, pBufferNeededCount, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_writetocallback(Lib3MF_Writer pWriter, Lib3MFWriteCallback pTheWriteCallback, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "WriteToCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->WriteToCallback(pTheWriteCallback, pTheSeekCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setprogresscallback(Lib3MF_Writer pWriter, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetProgressCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetProgressCallback(pProgressCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getdecimalprecision(Lib3MF_Writer pWriter, Lib3MF_uint32 * pDecimalPrecision)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetDecimalPrecision");
		}
		if (pDecimalPrecision == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pDecimalPrecision = pIWriter->GetDecimalPrecision();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("DecimalPrecision", *pDecimalPrecision);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setdecimalprecision(Lib3MF_Writer pWriter, Lib3MF_uint32 nDecimalPrecision)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetDecimalPrecision");
			pJournalEntry->addUInt32Parameter("DecimalPrecision", nDecimalPrecision);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetDecimalPrecision(nDecimalPrecision);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setstrictmodeactive(Lib3MF_Writer pWriter, bool bStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetStrictModeActive");
			pJournalEntry->addBooleanParameter("StrictModeActive", bStrictModeActive);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetStrictModeActive(bStrictModeActive);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getstrictmodeactive(Lib3MF_Writer pWriter, bool * pStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetStrictModeActive");
		}
		if (pStrictModeActive == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStrictModeActive = pIWriter->GetStrictModeActive();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("StrictModeActive", *pStrictModeActive);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getwarning(Lib3MF_Writer pWriter, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetWarning");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (!pErrorCode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pWarningBuffer) && !(pWarningNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sWarning("");
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sWarning = pIWriter->GetWarning(nIndex, *pErrorCode);

		if (pWarningNeededChars)
			*pWarningNeededChars = (Lib3MF_uint32) (sWarning.size()+1);
		if (pWarningBuffer) {
			if (sWarning.size() >= nWarningBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iWarning = 0; iWarning < sWarning.size(); iWarning++)
				pWarningBuffer[iWarning] = sWarning[iWarning];
			pWarningBuffer[sWarning.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ErrorCode", *pErrorCode);
			pJournalEntry->addStringResult("Warning", sWarning.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_getwarningcount(Lib3MF_Writer pWriter, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "GetWarningCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIWriter->GetWarningCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_addkeywrappingcallback(Lib3MF_Writer pWriter, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "AddKeyWrappingCallback");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->AddKeyWrappingCallback(sConsumerID, pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_writer_setcontentencryptioncallback(Lib3MF_Writer pWriter, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pWriter;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pWriter, "Writer", "SetContentEncryptionCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IWriter* pIWriter = dynamic_cast<IWriter*>(pIBaseClass);
		if (!pIWriter)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIWriter->SetContentEncryptionCallback(pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Reader
**************************************************************************************************************************/
Lib3MFResult lib3mf_reader_readfromfile(Lib3MF_Reader pReader, const char * pFilename)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "ReadFromFile");
			pJournalEntry->addStringParameter("Filename", pFilename);
		}
		if (pFilename == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFilename(pFilename);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->ReadFromFile(sFilename);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_readfrombuffer(Lib3MF_Reader pReader, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "ReadFromBuffer");
		}
		if ( (!pBufferBuffer) && (nBufferBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->ReadFromBuffer(nBufferBufferSize, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_readfromcallback(Lib3MF_Reader pReader, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "ReadFromCallback");
			pJournalEntry->addUInt64Parameter("StreamSize", nStreamSize);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->ReadFromCallback(pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_setprogresscallback(Lib3MF_Reader pReader, Lib3MFProgressCallback pProgressCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "SetProgressCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->SetProgressCallback(pProgressCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_addrelationtoread(Lib3MF_Reader pReader, const char * pRelationShipType)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "AddRelationToRead");
			pJournalEntry->addStringParameter("RelationShipType", pRelationShipType);
		}
		if (pRelationShipType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sRelationShipType(pRelationShipType);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->AddRelationToRead(sRelationShipType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_removerelationtoread(Lib3MF_Reader pReader, const char * pRelationShipType)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "RemoveRelationToRead");
			pJournalEntry->addStringParameter("RelationShipType", pRelationShipType);
		}
		if (pRelationShipType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sRelationShipType(pRelationShipType);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->RemoveRelationToRead(sRelationShipType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_setstrictmodeactive(Lib3MF_Reader pReader, bool bStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "SetStrictModeActive");
			pJournalEntry->addBooleanParameter("StrictModeActive", bStrictModeActive);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->SetStrictModeActive(bStrictModeActive);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_getstrictmodeactive(Lib3MF_Reader pReader, bool * pStrictModeActive)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "GetStrictModeActive");
		}
		if (pStrictModeActive == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStrictModeActive = pIReader->GetStrictModeActive();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("StrictModeActive", *pStrictModeActive);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_getwarning(Lib3MF_Reader pReader, Lib3MF_uint32 nIndex, Lib3MF_uint32 * pErrorCode, const Lib3MF_uint32 nWarningBufferSize, Lib3MF_uint32* pWarningNeededChars, char * pWarningBuffer)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "GetWarning");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (!pErrorCode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pWarningBuffer) && !(pWarningNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sWarning("");
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sWarning = pIReader->GetWarning(nIndex, *pErrorCode);

		if (pWarningNeededChars)
			*pWarningNeededChars = (Lib3MF_uint32) (sWarning.size()+1);
		if (pWarningBuffer) {
			if (sWarning.size() >= nWarningBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iWarning = 0; iWarning < sWarning.size(); iWarning++)
				pWarningBuffer[iWarning] = sWarning[iWarning];
			pWarningBuffer[sWarning.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ErrorCode", *pErrorCode);
			pJournalEntry->addStringResult("Warning", sWarning.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_getwarningcount(Lib3MF_Reader pReader, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "GetWarningCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIReader->GetWarningCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_addkeywrappingcallback(Lib3MF_Reader pReader, const char * pConsumerID, Lib3MFKeyWrappingCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "AddKeyWrappingCallback");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->AddKeyWrappingCallback(sConsumerID, pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_reader_setcontentencryptioncallback(Lib3MF_Reader pReader, Lib3MFContentEncryptionCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pReader;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pReader, "Reader", "SetContentEncryptionCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IReader* pIReader = dynamic_cast<IReader*>(pIBaseClass);
		if (!pIReader)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIReader->SetContentEncryptionCallback(pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for PackagePart
**************************************************************************************************************************/
Lib3MFResult lib3mf_packagepart_getpath(Lib3MF_PackagePart pPackagePart, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pPackagePart;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pPackagePart, "PackagePart", "GetPath");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		IPackagePart* pIPackagePart = dynamic_cast<IPackagePart*>(pIBaseClass);
		if (!pIPackagePart)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sPath = pIPackagePart->GetPath();

		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_packagepart_setpath(Lib3MF_PackagePart pPackagePart, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pPackagePart;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pPackagePart, "PackagePart", "SetPath");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IPackagePart* pIPackagePart = dynamic_cast<IPackagePart*>(pIBaseClass);
		if (!pIPackagePart)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIPackagePart->SetPath(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Resource
**************************************************************************************************************************/
Lib3MFResult lib3mf_resource_getresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "GetResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIResource->GetResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_getuniqueresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "GetUniqueResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIResource->GetUniqueResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_packagepart(Lib3MF_Resource pResource, Lib3MF_PackagePart * pPackagePart)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "PackagePart");
		}
		if (pPackagePart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePackagePart(nullptr);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePackagePart = pIResource->PackagePart();

		*pPackagePart = (IBase*)(pBasePackagePart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("PackagePart", *pPackagePart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_setpackagepart(Lib3MF_Resource pResource, Lib3MF_PackagePart pPackagePart)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "SetPackagePart");
			pJournalEntry->addHandleParameter("PackagePart", pPackagePart);
		}
		IBase* pIBaseClassPackagePart = (IBase *)pPackagePart;
		IPackagePart* pIPackagePart = dynamic_cast<IPackagePart*>(pIBaseClassPackagePart);
		if (!pIPackagePart)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResource->SetPackagePart(pIPackagePart);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resource_getmodelresourceid(Lib3MF_Resource pResource, Lib3MF_uint32 * pModelResourceId)
{
	IBase* pIBaseClass = (IBase *)pResource;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResource, "Resource", "GetModelResourceID");
		}
		if (pModelResourceId == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResource* pIResource = dynamic_cast<IResource*>(pIBaseClass);
		if (!pIResource)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pModelResourceId = pIResource->GetModelResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("ModelResourceId", *pModelResourceId);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ResourceIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourceiterator_movenext(Lib3MF_ResourceIterator pResourceIterator, bool * pHasNext)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "MoveNext");
		}
		if (pHasNext == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasNext = pIResourceIterator->MoveNext();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasNext", *pHasNext);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_moveprevious(Lib3MF_ResourceIterator pResourceIterator, bool * pHasPrevious)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "MovePrevious");
		}
		if (pHasPrevious == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasPrevious = pIResourceIterator->MovePrevious();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrevious", *pHasPrevious);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_getcurrent(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_Resource * pResource)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "GetCurrent");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIResourceIterator->GetCurrent();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_clone(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_ResourceIterator * pOutResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "Clone");
		}
		if (pOutResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseOutResourceIterator(nullptr);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseOutResourceIterator = pIResourceIterator->Clone();

		*pOutResourceIterator = (IBase*)(pBaseOutResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("OutResourceIterator", *pOutResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourceiterator_count(Lib3MF_ResourceIterator pResourceIterator, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pResourceIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceIterator, "ResourceIterator", "Count");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceIterator* pIResourceIterator = dynamic_cast<IResourceIterator*>(pIBaseClass);
		if (!pIResourceIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIResourceIterator->Count();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for SliceStackIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_slicestackiterator_getcurrentslicestack(Lib3MF_SliceStackIterator pSliceStackIterator, Lib3MF_SliceStack * pResource)
{
	IBase* pIBaseClass = (IBase *)pSliceStackIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStackIterator, "SliceStackIterator", "GetCurrentSliceStack");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ISliceStackIterator* pISliceStackIterator = dynamic_cast<ISliceStackIterator*>(pIBaseClass);
		if (!pISliceStackIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pISliceStackIterator->GetCurrentSliceStack();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ObjectIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_objectiterator_getcurrentobject(Lib3MF_ObjectIterator pObjectIterator, Lib3MF_Object * pResource)
{
	IBase* pIBaseClass = (IBase *)pObjectIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObjectIterator, "ObjectIterator", "GetCurrentObject");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IObjectIterator* pIObjectIterator = dynamic_cast<IObjectIterator*>(pIBaseClass);
		if (!pIObjectIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIObjectIterator->GetCurrentObject();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MeshObjectIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_meshobjectiterator_getcurrentmeshobject(Lib3MF_MeshObjectIterator pMeshObjectIterator, Lib3MF_MeshObject * pResource)
{
	IBase* pIBaseClass = (IBase *)pMeshObjectIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObjectIterator, "MeshObjectIterator", "GetCurrentMeshObject");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IMeshObjectIterator* pIMeshObjectIterator = dynamic_cast<IMeshObjectIterator*>(pIBaseClass);
		if (!pIMeshObjectIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIMeshObjectIterator->GetCurrentMeshObject();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ComponentsObjectIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_componentsobjectiterator_getcurrentcomponentsobject(Lib3MF_ComponentsObjectIterator pComponentsObjectIterator, Lib3MF_ComponentsObject * pResource)
{
	IBase* pIBaseClass = (IBase *)pComponentsObjectIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObjectIterator, "ComponentsObjectIterator", "GetCurrentComponentsObject");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IComponentsObjectIterator* pIComponentsObjectIterator = dynamic_cast<IComponentsObjectIterator*>(pIBaseClass);
		if (!pIComponentsObjectIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIComponentsObjectIterator->GetCurrentComponentsObject();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2DIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2diterator_getcurrenttexture2d(Lib3MF_Texture2DIterator pTexture2DIterator, Lib3MF_Texture2D * pResource)
{
	IBase* pIBaseClass = (IBase *)pTexture2DIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DIterator, "Texture2DIterator", "GetCurrentTexture2D");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ITexture2DIterator* pITexture2DIterator = dynamic_cast<ITexture2DIterator*>(pIBaseClass);
		if (!pITexture2DIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pITexture2DIterator->GetCurrentTexture2D();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BaseMaterialGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup(Lib3MF_BaseMaterialGroupIterator pBaseMaterialGroupIterator, Lib3MF_BaseMaterialGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroupIterator, "BaseMaterialGroupIterator", "GetCurrentBaseMaterialGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IBaseMaterialGroupIterator* pIBaseMaterialGroupIterator = dynamic_cast<IBaseMaterialGroupIterator*>(pIBaseClass);
		if (!pIBaseMaterialGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIBaseMaterialGroupIterator->GetCurrentBaseMaterialGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ColorGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_colorgroupiterator_getcurrentcolorgroup(Lib3MF_ColorGroupIterator pColorGroupIterator, Lib3MF_ColorGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pColorGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroupIterator, "ColorGroupIterator", "GetCurrentColorGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IColorGroupIterator* pIColorGroupIterator = dynamic_cast<IColorGroupIterator*>(pIBaseClass);
		if (!pIColorGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIColorGroupIterator->GetCurrentColorGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2DGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup(Lib3MF_Texture2DGroupIterator pTexture2DGroupIterator, Lib3MF_Texture2DGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroupIterator, "Texture2DGroupIterator", "GetCurrentTexture2DGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ITexture2DGroupIterator* pITexture2DGroupIterator = dynamic_cast<ITexture2DGroupIterator*>(pIBaseClass);
		if (!pITexture2DGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pITexture2DGroupIterator->GetCurrentTexture2DGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for CompositeMaterialsIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_compositematerialsiterator_getcurrentcompositematerials(Lib3MF_CompositeMaterialsIterator pCompositeMaterialsIterator, Lib3MF_CompositeMaterials * pResource)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterialsIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterialsIterator, "CompositeMaterialsIterator", "GetCurrentCompositeMaterials");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		ICompositeMaterialsIterator* pICompositeMaterialsIterator = dynamic_cast<ICompositeMaterialsIterator*>(pIBaseClass);
		if (!pICompositeMaterialsIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pICompositeMaterialsIterator->GetCurrentCompositeMaterials();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MultiPropertyGroupIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup(Lib3MF_MultiPropertyGroupIterator pMultiPropertyGroupIterator, Lib3MF_MultiPropertyGroup * pResource)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroupIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroupIterator, "MultiPropertyGroupIterator", "GetCurrentMultiPropertyGroup");
		}
		if (pResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResource(nullptr);
		IMultiPropertyGroupIterator* pIMultiPropertyGroupIterator = dynamic_cast<IMultiPropertyGroupIterator*>(pIBaseClass);
		if (!pIMultiPropertyGroupIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResource = pIMultiPropertyGroupIterator->GetCurrentMultiPropertyGroup();

		*pResource = (IBase*)(pBaseResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Resource", *pResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MetaData
**************************************************************************************************************************/
Lib3MFResult lib3mf_metadata_getnamespace(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameSpaceBufferSize, Lib3MF_uint32* pNameSpaceNeededChars, char * pNameSpaceBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetNameSpace");
		}
		if ( (!pNameSpaceBuffer) && !(pNameSpaceNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sNameSpace = pIMetaData->GetNameSpace();

		if (pNameSpaceNeededChars)
			*pNameSpaceNeededChars = (Lib3MF_uint32) (sNameSpace.size()+1);
		if (pNameSpaceBuffer) {
			if (sNameSpace.size() >= nNameSpaceBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iNameSpace = 0; iNameSpace < sNameSpace.size(); iNameSpace++)
				pNameSpaceBuffer[iNameSpace] = sNameSpace[iNameSpace];
			pNameSpaceBuffer[sNameSpace.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("NameSpace", sNameSpace.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setnamespace(Lib3MF_MetaData pMetaData, const char * pNameSpace)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetNameSpace");
			pJournalEntry->addStringParameter("NameSpace", pNameSpace);
		}
		if (pNameSpace == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetNameSpace(sNameSpace);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getname(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sName = pIMetaData->GetName();

		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setname(Lib3MF_MetaData pMetaData, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getkey(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nKeyBufferSize, Lib3MF_uint32* pKeyNeededChars, char * pKeyBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetKey");
		}
		if ( (!pKeyBuffer) && !(pKeyNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sKey("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sKey = pIMetaData->GetKey();

		if (pKeyNeededChars)
			*pKeyNeededChars = (Lib3MF_uint32) (sKey.size()+1);
		if (pKeyBuffer) {
			if (sKey.size() >= nKeyBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iKey = 0; iKey < sKey.size(); iKey++)
				pKeyBuffer[iKey] = sKey[iKey];
			pKeyBuffer[sKey.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Key", sKey.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getmustpreserve(Lib3MF_MetaData pMetaData, bool * pMustPreserve)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetMustPreserve");
		}
		if (pMustPreserve == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMustPreserve = pIMetaData->GetMustPreserve();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("MustPreserve", *pMustPreserve);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setmustpreserve(Lib3MF_MetaData pMetaData, bool bMustPreserve)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetMustPreserve");
			pJournalEntry->addBooleanParameter("MustPreserve", bMustPreserve);
		}
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetMustPreserve(bMustPreserve);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_gettype(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nTypeBufferSize, Lib3MF_uint32* pTypeNeededChars, char * pTypeBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetType");
		}
		if ( (!pTypeBuffer) && !(pTypeNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sType("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sType = pIMetaData->GetType();

		if (pTypeNeededChars)
			*pTypeNeededChars = (Lib3MF_uint32) (sType.size()+1);
		if (pTypeBuffer) {
			if (sType.size() >= nTypeBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iType = 0; iType < sType.size(); iType++)
				pTypeBuffer[iType] = sType[iType];
			pTypeBuffer[sType.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Type", sType.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_settype(Lib3MF_MetaData pMetaData, const char * pType)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetType");
			pJournalEntry->addStringParameter("Type", pType);
		}
		if (pType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sType(pType);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetType(sType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_getvalue(Lib3MF_MetaData pMetaData, const Lib3MF_uint32 nValueBufferSize, Lib3MF_uint32* pValueNeededChars, char * pValueBuffer)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "GetValue");
		}
		if ( (!pValueBuffer) && !(pValueNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sValue("");
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sValue = pIMetaData->GetValue();

		if (pValueNeededChars)
			*pValueNeededChars = (Lib3MF_uint32) (sValue.size()+1);
		if (pValueBuffer) {
			if (sValue.size() >= nValueBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iValue = 0; iValue < sValue.size(); iValue++)
				pValueBuffer[iValue] = sValue[iValue];
			pValueBuffer[sValue.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Value", sValue.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadata_setvalue(Lib3MF_MetaData pMetaData, const char * pValue)
{
	IBase* pIBaseClass = (IBase *)pMetaData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaData, "MetaData", "SetValue");
			pJournalEntry->addStringParameter("Value", pValue);
		}
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sValue(pValue);
		IMetaData* pIMetaData = dynamic_cast<IMetaData*>(pIBaseClass);
		if (!pIMetaData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaData->SetValue(sValue);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MetaDataGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_metadatagroup_getmetadatacount(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "GetMetaDataCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMetaDataGroup->GetMetaDataCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_getmetadata(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex, Lib3MF_MetaData * pMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "GetMetaData");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pMetaData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMetaData(nullptr);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaData = pIMetaDataGroup->GetMetaData(nIndex);

		*pMetaData = (IBase*)(pBaseMetaData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaData", *pMetaData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_getmetadatabykey(Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, Lib3MF_MetaData * pMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "GetMetaDataByKey");
			pJournalEntry->addStringParameter("NameSpace", pNameSpace);
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pNameSpace == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pMetaData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		std::string sName(pName);
		IBase* pBaseMetaData(nullptr);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaData = pIMetaDataGroup->GetMetaDataByKey(sNameSpace, sName);

		*pMetaData = (IBase*)(pBaseMetaData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaData", *pMetaData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_removemetadatabyindex(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_uint32 nIndex)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "RemoveMetaDataByIndex");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaDataGroup->RemoveMetaDataByIndex(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_removemetadata(Lib3MF_MetaDataGroup pMetaDataGroup, Lib3MF_MetaData pTheMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "RemoveMetaData");
			pJournalEntry->addHandleParameter("TheMetaData", pTheMetaData);
		}
		IBase* pIBaseClassTheMetaData = (IBase *)pTheMetaData;
		IMetaData* pITheMetaData = dynamic_cast<IMetaData*>(pIBaseClassTheMetaData);
		if (!pITheMetaData)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMetaDataGroup->RemoveMetaData(pITheMetaData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_metadatagroup_addmetadata(Lib3MF_MetaDataGroup pMetaDataGroup, const char * pNameSpace, const char * pName, const char * pValue, const char * pType, bool bMustPreserve, Lib3MF_MetaData * pMetaData)
{
	IBase* pIBaseClass = (IBase *)pMetaDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMetaDataGroup, "MetaDataGroup", "AddMetaData");
			pJournalEntry->addStringParameter("NameSpace", pNameSpace);
			pJournalEntry->addStringParameter("Name", pName);
			pJournalEntry->addStringParameter("Value", pValue);
			pJournalEntry->addStringParameter("Type", pType);
			pJournalEntry->addBooleanParameter("MustPreserve", bMustPreserve);
		}
		if (pNameSpace == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pMetaData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sNameSpace(pNameSpace);
		std::string sName(pName);
		std::string sValue(pValue);
		std::string sType(pType);
		IBase* pBaseMetaData(nullptr);
		IMetaDataGroup* pIMetaDataGroup = dynamic_cast<IMetaDataGroup*>(pIBaseClass);
		if (!pIMetaDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaData = pIMetaDataGroup->AddMetaData(sNameSpace, sName, sValue, sType, bMustPreserve);

		*pMetaData = (IBase*)(pBaseMetaData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaData", *pMetaData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Object
**************************************************************************************************************************/
Lib3MFResult lib3mf_object_gettype(Lib3MF_Object pObject, eLib3MFObjectType * pObjectType)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetType");
		}
		if (pObjectType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pObjectType = pIObject->GetType();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ObjectType", "ObjectType", (Lib3MF_int32)(*pObjectType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_settype(Lib3MF_Object pObject, eLib3MFObjectType eObjectType)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetType");
			pJournalEntry->addEnumParameter("ObjectType", "ObjectType", (Lib3MF_int32)(eObjectType));
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetType(eObjectType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getname(Lib3MF_Object pObject, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sName = pIObject->GetName();

		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setname(Lib3MF_Object pObject, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getpartnumber(Lib3MF_Object pObject, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetPartNumber");
		}
		if ( (!pPartNumberBuffer) && !(pPartNumberNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPartNumber("");
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sPartNumber = pIObject->GetPartNumber();

		if (pPartNumberNeededChars)
			*pPartNumberNeededChars = (Lib3MF_uint32) (sPartNumber.size()+1);
		if (pPartNumberBuffer) {
			if (sPartNumber.size() >= nPartNumberBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPartNumber = 0; iPartNumber < sPartNumber.size(); iPartNumber++)
				pPartNumberBuffer[iPartNumber] = sPartNumber[iPartNumber];
			pPartNumberBuffer[sPartNumber.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("PartNumber", sPartNumber.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setpartnumber(Lib3MF_Object pObject, const char * pPartNumber)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetPartNumber");
			pJournalEntry->addStringParameter("PartNumber", pPartNumber);
		}
		if (pPartNumber == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPartNumber(pPartNumber);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetPartNumber(sPartNumber);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_ismeshobject(Lib3MF_Object pObject, bool * pIsMeshObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsMeshObject");
		}
		if (pIsMeshObject == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsMeshObject = pIObject->IsMeshObject();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsMeshObject", *pIsMeshObject);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_iscomponentsobject(Lib3MF_Object pObject, bool * pIsComponentsObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsComponentsObject");
		}
		if (pIsComponentsObject == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsComponentsObject = pIObject->IsComponentsObject();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsComponentsObject", *pIsComponentsObject);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_isvalid(Lib3MF_Object pObject, bool * pIsValid)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "IsValid");
		}
		if (pIsValid == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsValid = pIObject->IsValid();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsValid", *pIsValid);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setattachmentasthumbnail(Lib3MF_Object pObject, Lib3MF_Attachment pAttachment)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetAttachmentAsThumbnail");
			pJournalEntry->addHandleParameter("Attachment", pAttachment);
		}
		IBase* pIBaseClassAttachment = (IBase *)pAttachment;
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClassAttachment);
		if (!pIAttachment)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetAttachmentAsThumbnail(pIAttachment);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getthumbnailattachment(Lib3MF_Object pObject, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetThumbnailAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pIObject->GetThumbnailAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_clearthumbnailattachment(Lib3MF_Object pObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "ClearThumbnailAttachment");
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->ClearThumbnailAttachment();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getoutbox(Lib3MF_Object pObject, sLib3MFBox * pOutbox)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetOutbox");
		}
		if (pOutbox == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOutbox = pIObject->GetOutbox();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getuuid(Lib3MF_Object pObject, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIObject->GetUUID(*pHasUUID);

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setuuid(Lib3MF_Object pObject, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getmetadatagroup(Lib3MF_Object pObject, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetMetaDataGroup");
		}
		if (pMetaDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMetaDataGroup(nullptr);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaDataGroup = pIObject->GetMetaDataGroup();

		*pMetaDataGroup = (IBase*)(pBaseMetaDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaDataGroup", *pMetaDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_setslicesmeshresolution(Lib3MF_Object pObject, eLib3MFSlicesMeshResolution eMeshResolution)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "SetSlicesMeshResolution");
			pJournalEntry->addEnumParameter("MeshResolution", "SlicesMeshResolution", (Lib3MF_int32)(eMeshResolution));
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->SetSlicesMeshResolution(eMeshResolution);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getslicesmeshresolution(Lib3MF_Object pObject, eLib3MFSlicesMeshResolution * pMeshResolution)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetSlicesMeshResolution");
		}
		if (pMeshResolution == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMeshResolution = pIObject->GetSlicesMeshResolution();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("MeshResolution", "SlicesMeshResolution", (Lib3MF_int32)(*pMeshResolution));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_hasslices(Lib3MF_Object pObject, bool bRecursive, bool * pHasSlices)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "HasSlices");
			pJournalEntry->addBooleanParameter("Recursive", bRecursive);
		}
		if (pHasSlices == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasSlices = pIObject->HasSlices(bRecursive);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasSlices", *pHasSlices);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_clearslicestack(Lib3MF_Object pObject)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "ClearSliceStack");
		}
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->ClearSliceStack();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_getslicestack(Lib3MF_Object pObject, Lib3MF_SliceStack * pSliceStackInstance)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "GetSliceStack");
		}
		if (pSliceStackInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSliceStackInstance(nullptr);
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSliceStackInstance = pIObject->GetSliceStack();

		*pSliceStackInstance = (IBase*)(pBaseSliceStackInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("SliceStackInstance", *pSliceStackInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_object_assignslicestack(Lib3MF_Object pObject, Lib3MF_SliceStack pSliceStackInstance)
{
	IBase* pIBaseClass = (IBase *)pObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pObject, "Object", "AssignSliceStack");
			pJournalEntry->addHandleParameter("SliceStackInstance", pSliceStackInstance);
		}
		IBase* pIBaseClassSliceStackInstance = (IBase *)pSliceStackInstance;
		ISliceStack* pISliceStackInstance = dynamic_cast<ISliceStack*>(pIBaseClassSliceStackInstance);
		if (!pISliceStackInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClass);
		if (!pIObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIObject->AssignSliceStack(pISliceStackInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MeshObject
**************************************************************************************************************************/
Lib3MFResult lib3mf_meshobject_getvertexcount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVertexCount");
		}
		if (pVertexCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pVertexCount = pIMeshObject->GetVertexCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("VertexCount", *pVertexCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettrianglecount(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pVertexCount)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleCount");
		}
		if (pVertexCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pVertexCount = pIMeshObject->GetTriangleCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("VertexCount", *pVertexCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getvertex(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFPosition * pCoordinates)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVertex");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pCoordinates == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCoordinates = pIMeshObject->GetVertex(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setvertex(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFPosition * pCoordinates)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetVertex");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetVertex(nIndex, *pCoordinates);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_addvertex(Lib3MF_MeshObject pMeshObject, const sLib3MFPosition * pCoordinates, Lib3MF_uint32 * pNewIndex)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "AddVertex");
		}
		if (pNewIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pNewIndex = pIMeshObject->AddVertex(*pCoordinates);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("NewIndex", *pNewIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getvertices(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition * pVerticesBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetVertices");
		}
		if ((!pVerticesBuffer) && !(pVerticesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetVertices(nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangle(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangle * pIndices)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangle");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pIndices == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndices = pIMeshObject->GetTriangle(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_settriangle(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangle * pIndices)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetTriangle");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetTriangle(nIndex, *pIndices);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_addtriangle(Lib3MF_MeshObject pMeshObject, const sLib3MFTriangle * pIndices, Lib3MF_uint32 * pNewIndex)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "AddTriangle");
		}
		if (pNewIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pNewIndex = pIMeshObject->AddTriangle(*pIndices);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("NewIndex", *pNewIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangleindices(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, sLib3MFTriangle * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleIndices");
		}
		if ((!pIndicesBuffer) && !(pIndicesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetTriangleIndices(nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setobjectlevelproperty(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nUniqueResourceID, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetObjectLevelProperty");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetObjectLevelProperty(nUniqueResourceID, nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getobjectlevelproperty(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 * pUniqueResourceID, Lib3MF_uint32 * pPropertyID, bool * pHasObjectLevelProperty)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetObjectLevelProperty");
		}
		if (!pUniqueResourceID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pPropertyID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pHasObjectLevelProperty == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasObjectLevelProperty = pIMeshObject->GetObjectLevelProperty(*pUniqueResourceID, *pPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->addBooleanResult("HasObjectLevelProperty", *pHasObjectLevelProperty);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_settriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, const sLib3MFTriangleProperties * pProperties)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetTriangleProperties");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetTriangleProperties(nIndex, *pProperties);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_gettriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint32 nIndex, sLib3MFTriangleProperties * pProperty)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetTriangleProperties");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (!pProperty)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetTriangleProperties(nIndex, *pProperty);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setalltriangleproperties(Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nPropertiesArrayBufferSize, const sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetAllTriangleProperties");
		}
		if ( (!pPropertiesArrayBuffer) && (nPropertiesArrayBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetAllTriangleProperties(nPropertiesArrayBufferSize, pPropertiesArrayBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_getalltriangleproperties(Lib3MF_MeshObject pMeshObject, const Lib3MF_uint64 nPropertiesArrayBufferSize, Lib3MF_uint64* pPropertiesArrayNeededCount, sLib3MFTriangleProperties * pPropertiesArrayBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "GetAllTriangleProperties");
		}
		if ((!pPropertiesArrayBuffer) && !(pPropertiesArrayNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->GetAllTriangleProperties(nPropertiesArrayBufferSize, pPropertiesArrayNeededCount, pPropertiesArrayBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_clearallproperties(Lib3MF_MeshObject pMeshObject)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "ClearAllProperties");
		}
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->ClearAllProperties();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_setgeometry(Lib3MF_MeshObject pMeshObject, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition * pVerticesBuffer, Lib3MF_uint64 nIndicesBufferSize, const sLib3MFTriangle * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "SetGeometry");
		}
		if ( (!pVerticesBuffer) && (nVerticesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pIndicesBuffer) && (nIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMeshObject->SetGeometry(nVerticesBufferSize, pVerticesBuffer, nIndicesBufferSize, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_ismanifoldandoriented(Lib3MF_MeshObject pMeshObject, bool * pIsManifoldAndOriented)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "IsManifoldAndOriented");
		}
		if (pIsManifoldAndOriented == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIsManifoldAndOriented = pIMeshObject->IsManifoldAndOriented();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsManifoldAndOriented", *pIsManifoldAndOriented);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_meshobject_beamlattice(Lib3MF_MeshObject pMeshObject, Lib3MF_BeamLattice * pTheBeamLattice)
{
	IBase* pIBaseClass = (IBase *)pMeshObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMeshObject, "MeshObject", "BeamLattice");
		}
		if (pTheBeamLattice == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheBeamLattice(nullptr);
		IMeshObject* pIMeshObject = dynamic_cast<IMeshObject*>(pIBaseClass);
		if (!pIMeshObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheBeamLattice = pIMeshObject->BeamLattice();

		*pTheBeamLattice = (IBase*)(pBaseTheBeamLattice);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheBeamLattice", *pTheBeamLattice);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BeamLattice
**************************************************************************************************************************/
Lib3MFResult lib3mf_beamlattice_getminlength(Lib3MF_BeamLattice pBeamLattice, Lib3MF_double * pMinLength)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetMinLength");
		}
		if (pMinLength == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pMinLength = pIBeamLattice->GetMinLength();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("MinLength", *pMinLength);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setminlength(Lib3MF_BeamLattice pBeamLattice, Lib3MF_double dMinLength)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetMinLength");
			pJournalEntry->addDoubleParameter("MinLength", dMinLength);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetMinLength(dMinLength);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getclipping(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode * pClipMode, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetClipping");
		}
		if (!pClipMode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pUniqueResourceID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetClipping(*pClipMode, *pUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ClipMode", "BeamLatticeClipMode", (Lib3MF_int32)(*pClipMode));
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setclipping(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeClipMode eClipMode, Lib3MF_uint32 nUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetClipping");
			pJournalEntry->addEnumParameter("ClipMode", "BeamLatticeClipMode", (Lib3MF_int32)(eClipMode));
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetClipping(eClipMode, nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getrepresentation(Lib3MF_BeamLattice pBeamLattice, bool * pHasRepresentation, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetRepresentation");
		}
		if (pHasRepresentation == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pUniqueResourceID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasRepresentation = pIBeamLattice->GetRepresentation(*pUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasRepresentation", *pHasRepresentation);
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setrepresentation(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetRepresentation");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetRepresentation(nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getballoptions(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode * pBallMode, Lib3MF_double * pBallRadius)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBallOptions");
		}
		if (!pBallMode)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pBallRadius)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetBallOptions(*pBallMode, *pBallRadius);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("BallMode", "BeamLatticeBallMode", (Lib3MF_int32)(*pBallMode));
			pJournalEntry->addDoubleResult("BallRadius", *pBallRadius);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setballoptions(Lib3MF_BeamLattice pBeamLattice, eLib3MFBeamLatticeBallMode eBallMode, Lib3MF_double dBallRadius)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBallOptions");
			pJournalEntry->addEnumParameter("BallMode", "BeamLatticeBallMode", (Lib3MF_int32)(eBallMode));
			pJournalEntry->addDoubleParameter("BallRadius", dBallRadius);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBallOptions(eBallMode, dBallRadius);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeamcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeamCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamLattice->GetBeamCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeam(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBeam * pBeamInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeam");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pBeamInfo == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pBeamInfo = pIBeamLattice->GetBeam(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_addbeam(Lib3MF_BeamLattice pBeamLattice, const sLib3MFBeam * pBeamInfo, Lib3MF_uint32 * pIndex)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "AddBeam");
		}
		if (pIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndex = pIBeamLattice->AddBeam(*pBeamInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Index", *pIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setbeam(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBeam * pBeamInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBeam");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBeam(nIndex, *pBeamInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setbeams(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBeamInfoBufferSize, const sLib3MFBeam * pBeamInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBeams");
		}
		if ( (!pBeamInfoBuffer) && (nBeamInfoBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBeams(nBeamInfoBufferSize, pBeamInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeams(Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBeamInfoBufferSize, Lib3MF_uint64* pBeamInfoNeededCount, sLib3MFBeam * pBeamInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeams");
		}
		if ((!pBeamInfoBuffer) && !(pBeamInfoNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetBeams(nBeamInfoBufferSize, pBeamInfoNeededCount, pBeamInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getballcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBallCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamLattice->GetBallCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getball(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, sLib3MFBall * pBallInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBall");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pBallInfo == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pBallInfo = pIBeamLattice->GetBall(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_addball(Lib3MF_BeamLattice pBeamLattice, const sLib3MFBall * pBallInfo, Lib3MF_uint32 * pIndex)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "AddBall");
		}
		if (pIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndex = pIBeamLattice->AddBall(*pBallInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Index", *pIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setball(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, const sLib3MFBall * pBallInfo)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBall");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBall(nIndex, *pBallInfo);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_setballs(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint64 nBallInfoBufferSize, const sLib3MFBall * pBallInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "SetBalls");
		}
		if ( (!pBallInfoBuffer) && (nBallInfoBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->SetBalls(nBallInfoBufferSize, pBallInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getballs(Lib3MF_BeamLattice pBeamLattice, const Lib3MF_uint64 nBallInfoBufferSize, Lib3MF_uint64* pBallInfoNeededCount, sLib3MFBall * pBallInfoBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBalls");
		}
		if ((!pBallInfoBuffer) && !(pBallInfoNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamLattice->GetBalls(nBallInfoBufferSize, pBallInfoNeededCount, pBallInfoBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeamsetcount(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeamSetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamLattice->GetBeamSetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_addbeamset(Lib3MF_BeamLattice pBeamLattice, Lib3MF_BeamSet * pBeamSet)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "AddBeamSet");
		}
		if (pBeamSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBeamSet(nullptr);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBeamSet = pIBeamLattice->AddBeamSet();

		*pBeamSet = (IBase*)(pBaseBeamSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BeamSet", *pBeamSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamlattice_getbeamset(Lib3MF_BeamLattice pBeamLattice, Lib3MF_uint32 nIndex, Lib3MF_BeamSet * pBeamSet)
{
	IBase* pIBaseClass = (IBase *)pBeamLattice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamLattice, "BeamLattice", "GetBeamSet");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pBeamSet == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBeamSet(nullptr);
		IBeamLattice* pIBeamLattice = dynamic_cast<IBeamLattice*>(pIBaseClass);
		if (!pIBeamLattice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBeamSet = pIBeamLattice->GetBeamSet(nIndex);

		*pBeamSet = (IBase*)(pBaseBeamSet);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BeamSet", *pBeamSet);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Component
**************************************************************************************************************************/
Lib3MFResult lib3mf_component_getobjectresource(Lib3MF_Component pComponent, Lib3MF_Object * pObjectResource)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetObjectResource");
		}
		if (pObjectResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseObjectResource(nullptr);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseObjectResource = pIComponent->GetObjectResource();

		*pObjectResource = (IBase*)(pBaseObjectResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ObjectResource", *pObjectResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_getobjectresourceid(Lib3MF_Component pComponent, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetObjectResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIComponent->GetObjectResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_getuuid(Lib3MF_Component pComponent, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIComponent->GetUUID(*pHasUUID);

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_setuuid(Lib3MF_Component pComponent, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIComponent->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_hastransform(Lib3MF_Component pComponent, bool * pHasTransform)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "HasTransform");
		}
		if (pHasTransform == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasTransform = pIComponent->HasTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasTransform", *pHasTransform);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_gettransform(Lib3MF_Component pComponent, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "GetTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTransform = pIComponent->GetTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_component_settransform(Lib3MF_Component pComponent, const sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pComponent;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponent, "Component", "SetTransform");
		}
		IComponent* pIComponent = dynamic_cast<IComponent*>(pIBaseClass);
		if (!pIComponent)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIComponent->SetTransform(*pTransform);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ComponentsObject
**************************************************************************************************************************/
Lib3MFResult lib3mf_componentsobject_addcomponent(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_Object pObjectResource, const sLib3MFTransform * pTransform, Lib3MF_Component * pComponentInstance)
{
	IBase* pIBaseClass = (IBase *)pComponentsObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObject, "ComponentsObject", "AddComponent");
			pJournalEntry->addHandleParameter("ObjectResource", pObjectResource);
		}
		if (pComponentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassObjectResource = (IBase *)pObjectResource;
		IObject* pIObjectResource = dynamic_cast<IObject*>(pIBaseClassObjectResource);
		if (!pIObjectResource)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseComponentInstance(nullptr);
		IComponentsObject* pIComponentsObject = dynamic_cast<IComponentsObject*>(pIBaseClass);
		if (!pIComponentsObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentInstance = pIComponentsObject->AddComponent(pIObjectResource, *pTransform);

		*pComponentInstance = (IBase*)(pBaseComponentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentInstance", *pComponentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_componentsobject_getcomponent(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 nIndex, Lib3MF_Component * pComponentInstance)
{
	IBase* pIBaseClass = (IBase *)pComponentsObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObject, "ComponentsObject", "GetComponent");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pComponentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseComponentInstance(nullptr);
		IComponentsObject* pIComponentsObject = dynamic_cast<IComponentsObject*>(pIBaseClass);
		if (!pIComponentsObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentInstance = pIComponentsObject->GetComponent(nIndex);

		*pComponentInstance = (IBase*)(pBaseComponentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentInstance", *pComponentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_componentsobject_getcomponentcount(Lib3MF_ComponentsObject pComponentsObject, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pComponentsObject;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pComponentsObject, "ComponentsObject", "GetComponentCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IComponentsObject* pIComponentsObject = dynamic_cast<IComponentsObject*>(pIBaseClass);
		if (!pIComponentsObject)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIComponentsObject->GetComponentCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BeamSet
**************************************************************************************************************************/
Lib3MFResult lib3mf_beamset_setname(Lib3MF_BeamSet pBeamSet, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetName");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetName(sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getname(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetName");
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sName = pIBeamSet->GetName();

		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_setidentifier(Lib3MF_BeamSet pBeamSet, const char * pIdentifier)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetIdentifier");
			pJournalEntry->addStringParameter("Identifier", pIdentifier);
		}
		if (pIdentifier == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier(pIdentifier);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetIdentifier(sIdentifier);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getidentifier(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint32 nIdentifierBufferSize, Lib3MF_uint32* pIdentifierNeededChars, char * pIdentifierBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetIdentifier");
		}
		if ( (!pIdentifierBuffer) && !(pIdentifierNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sIdentifier("");
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sIdentifier = pIBeamSet->GetIdentifier();

		if (pIdentifierNeededChars)
			*pIdentifierNeededChars = (Lib3MF_uint32) (sIdentifier.size()+1);
		if (pIdentifierBuffer) {
			if (sIdentifier.size() >= nIdentifierBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iIdentifier = 0; iIdentifier < sIdentifier.size(); iIdentifier++)
				pIdentifierBuffer[iIdentifier] = sIdentifier[iIdentifier];
			pIdentifierBuffer[sIdentifier.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Identifier", sIdentifier.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getreferencecount(Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetReferenceCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamSet->GetReferenceCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_setreferences(Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nReferencesBufferSize, const Lib3MF_uint32 * pReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetReferences");
		}
		if ( (!pReferencesBuffer) && (nReferencesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetReferences(nReferencesBufferSize, pReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getreferences(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nReferencesBufferSize, Lib3MF_uint64* pReferencesNeededCount, Lib3MF_uint32 * pReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetReferences");
		}
		if ((!pReferencesBuffer) && !(pReferencesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->GetReferences(nReferencesBufferSize, pReferencesNeededCount, pReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getballreferencecount(Lib3MF_BeamSet pBeamSet, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetBallReferenceCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBeamSet->GetBallReferenceCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_setballreferences(Lib3MF_BeamSet pBeamSet, Lib3MF_uint64 nBallReferencesBufferSize, const Lib3MF_uint32 * pBallReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "SetBallReferences");
		}
		if ( (!pBallReferencesBuffer) && (nBallReferencesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->SetBallReferences(nBallReferencesBufferSize, pBallReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_beamset_getballreferences(Lib3MF_BeamSet pBeamSet, const Lib3MF_uint64 nBallReferencesBufferSize, Lib3MF_uint64* pBallReferencesNeededCount, Lib3MF_uint32 * pBallReferencesBuffer)
{
	IBase* pIBaseClass = (IBase *)pBeamSet;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBeamSet, "BeamSet", "GetBallReferences");
		}
		if ((!pBallReferencesBuffer) && !(pBallReferencesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBeamSet* pIBeamSet = dynamic_cast<IBeamSet*>(pIBaseClass);
		if (!pIBeamSet)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBeamSet->GetBallReferences(nBallReferencesBufferSize, pBallReferencesNeededCount, pBallReferencesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BaseMaterialGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_basematerialgroup_getcount(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBaseMaterialGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_getallpropertyids(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_addmaterial(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, const char * pName, const sLib3MFColor * pDisplayColor, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "AddMaterial");
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pIBaseMaterialGroup->AddMaterial(sName, *pDisplayColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_removematerial(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "RemoveMaterial");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->RemoveMaterial(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_getname(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint32 nNameBufferSize, Lib3MF_uint32* pNameNeededChars, char * pNameBuffer)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetName");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ( (!pNameBuffer) && !(pNameNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName("");
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sName = pIBaseMaterialGroup->GetName(nPropertyID);

		if (pNameNeededChars)
			*pNameNeededChars = (Lib3MF_uint32) (sName.size()+1);
		if (pNameBuffer) {
			if (sName.size() >= nNameBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iName = 0; iName < sName.size(); iName++)
				pNameBuffer[iName] = sName[iName];
			pNameBuffer[sName.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Name", sName.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_setname(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const char * pName)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "SetName");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
			pJournalEntry->addStringParameter("Name", pName);
		}
		if (pName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sName(pName);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->SetName(nPropertyID, sName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_setdisplaycolor(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "SetDisplayColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBaseMaterialGroup->SetDisplayColor(nPropertyID, *pTheColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_basematerialgroup_getdisplaycolor(Lib3MF_BaseMaterialGroup pBaseMaterialGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pBaseMaterialGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBaseMaterialGroup, "BaseMaterialGroup", "GetDisplayColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBaseMaterialGroup* pIBaseMaterialGroup = dynamic_cast<IBaseMaterialGroup*>(pIBaseClass);
		if (!pIBaseMaterialGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTheColor = pIBaseMaterialGroup->GetDisplayColor(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ColorGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_colorgroup_getcount(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIColorGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_getallpropertyids(Lib3MF_ColorGroup pColorGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIColorGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_addcolor(Lib3MF_ColorGroup pColorGroup, const sLib3MFColor * pTheColor, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "AddColor");
		}
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pIColorGroup->AddColor(*pTheColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_removecolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "RemoveColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIColorGroup->RemoveColor(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_setcolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, const sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "SetColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIColorGroup->SetColor(nPropertyID, *pTheColor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colorgroup_getcolor(Lib3MF_ColorGroup pColorGroup, Lib3MF_uint32 nPropertyID, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = (IBase *)pColorGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pColorGroup, "ColorGroup", "GetColor");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IColorGroup* pIColorGroup = dynamic_cast<IColorGroup*>(pIBaseClass);
		if (!pIColorGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTheColor = pIColorGroup->GetColor(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2DGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2dgroup_getcount(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pITexture2DGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_getallpropertyids(Lib3MF_Texture2DGroup pTexture2DGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2DGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_addtex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, const sLib3MFTex2Coord * pUVCoordinate, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "AddTex2Coord");
		}
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pITexture2DGroup->AddTex2Coord(*pUVCoordinate);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_gettex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID, sLib3MFTex2Coord * pUVCoordinate)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetTex2Coord");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if (pUVCoordinate == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUVCoordinate = pITexture2DGroup->GetTex2Coord(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_removetex2coord(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "RemoveTex2Coord");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2DGroup->RemoveTex2Coord(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2dgroup_gettexture2d(Lib3MF_Texture2DGroup pTexture2DGroup, Lib3MF_Texture2D * pTexture2DInstance)
{
	IBase* pIBaseClass = (IBase *)pTexture2DGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2DGroup, "Texture2DGroup", "GetTexture2D");
		}
		if (pTexture2DInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTexture2DInstance(nullptr);
		ITexture2DGroup* pITexture2DGroup = dynamic_cast<ITexture2DGroup*>(pIBaseClass);
		if (!pITexture2DGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DInstance = pITexture2DGroup->GetTexture2D();

		*pTexture2DInstance = (IBase*)(pBaseTexture2DInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DInstance", *pTexture2DInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for CompositeMaterials
**************************************************************************************************************************/
Lib3MFResult lib3mf_compositematerials_getcount(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pICompositeMaterials->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_getallpropertyids(Lib3MF_CompositeMaterials pCompositeMaterials, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pICompositeMaterials->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_getbasematerialgroup(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetBaseMaterialGroup");
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pICompositeMaterials->GetBaseMaterialGroup();

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_addcomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint64 nCompositeBufferSize, const sLib3MFCompositeConstituent * pCompositeBuffer, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "AddComposite");
		}
		if ( (!pCompositeBuffer) && (nCompositeBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pICompositeMaterials->AddComposite(nCompositeBufferSize, pCompositeBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_removecomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "RemoveComposite");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pICompositeMaterials->RemoveComposite(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_compositematerials_getcomposite(Lib3MF_CompositeMaterials pCompositeMaterials, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nCompositeBufferSize, Lib3MF_uint64* pCompositeNeededCount, sLib3MFCompositeConstituent * pCompositeBuffer)
{
	IBase* pIBaseClass = (IBase *)pCompositeMaterials;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pCompositeMaterials, "CompositeMaterials", "GetComposite");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ((!pCompositeBuffer) && !(pCompositeNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ICompositeMaterials* pICompositeMaterials = dynamic_cast<ICompositeMaterials*>(pIBaseClass);
		if (!pICompositeMaterials)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pICompositeMaterials->GetComposite(nPropertyID, nCompositeBufferSize, pCompositeNeededCount, pCompositeBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for MultiPropertyGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_multipropertygroup_getcount(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMultiPropertyGroup->GetCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getallpropertyids(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetAllPropertyIDs");
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->GetAllPropertyIDs(nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_addmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer, Lib3MF_uint32 * pPropertyID)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "AddMultiProperty");
		}
		if ( (!pPropertyIDsBuffer) && (nPropertyIDsBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pPropertyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pPropertyID = pIMultiPropertyGroup->AddMultiProperty(nPropertyIDsBufferSize, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("PropertyID", *pPropertyID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_setmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, Lib3MF_uint64 nPropertyIDsBufferSize, const Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "SetMultiProperty");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ( (!pPropertyIDsBuffer) && (nPropertyIDsBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->SetMultiProperty(nPropertyID, nPropertyIDsBufferSize, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getmultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID, const Lib3MF_uint64 nPropertyIDsBufferSize, Lib3MF_uint64* pPropertyIDsNeededCount, Lib3MF_uint32 * pPropertyIDsBuffer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetMultiProperty");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		if ((!pPropertyIDsBuffer) && !(pPropertyIDsNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->GetMultiProperty(nPropertyID, nPropertyIDsBufferSize, pPropertyIDsNeededCount, pPropertyIDsBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_removemultiproperty(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nPropertyID)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "RemoveMultiProperty");
			pJournalEntry->addUInt32Parameter("PropertyID", nPropertyID);
		}
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->RemoveMultiProperty(nPropertyID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getlayercount(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 * pCount)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetLayerCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIMultiPropertyGroup->GetLayerCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_addlayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, const sLib3MFMultiPropertyLayer * pTheLayer, Lib3MF_uint32 * pLayerIndex)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "AddLayer");
		}
		if (pLayerIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pLayerIndex = pIMultiPropertyGroup->AddLayer(*pTheLayer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("LayerIndex", *pLayerIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_getlayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex, sLib3MFMultiPropertyLayer * pTheLayer)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "GetLayer");
			pJournalEntry->addUInt32Parameter("LayerIndex", nLayerIndex);
		}
		if (pTheLayer == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTheLayer = pIMultiPropertyGroup->GetLayer(nLayerIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_multipropertygroup_removelayer(Lib3MF_MultiPropertyGroup pMultiPropertyGroup, Lib3MF_uint32 nLayerIndex)
{
	IBase* pIBaseClass = (IBase *)pMultiPropertyGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pMultiPropertyGroup, "MultiPropertyGroup", "RemoveLayer");
			pJournalEntry->addUInt32Parameter("LayerIndex", nLayerIndex);
		}
		IMultiPropertyGroup* pIMultiPropertyGroup = dynamic_cast<IMultiPropertyGroup*>(pIBaseClass);
		if (!pIMultiPropertyGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIMultiPropertyGroup->RemoveLayer(nLayerIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Attachment
**************************************************************************************************************************/
Lib3MFResult lib3mf_attachment_getpath(Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "GetPath");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sPath = pIAttachment->GetPath();

		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_setpath(Lib3MF_Attachment pAttachment, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "SetPath");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->SetPath(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_packagepart(Lib3MF_Attachment pAttachment, Lib3MF_PackagePart * pPackagePart)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "PackagePart");
		}
		if (pPackagePart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePackagePart(nullptr);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePackagePart = pIAttachment->PackagePart();

		*pPackagePart = (IBase*)(pBasePackagePart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("PackagePart", *pPackagePart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_getrelationshiptype(Lib3MF_Attachment pAttachment, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "GetRelationShipType");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sPath = pIAttachment->GetRelationShipType();

		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_setrelationshiptype(Lib3MF_Attachment pAttachment, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "SetRelationShipType");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->SetRelationShipType(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_writetofile(Lib3MF_Attachment pAttachment, const char * pFileName)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "WriteToFile");
			pJournalEntry->addStringParameter("FileName", pFileName);
		}
		if (pFileName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFileName(pFileName);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->WriteToFile(sFileName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_readfromfile(Lib3MF_Attachment pAttachment, const char * pFileName)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "ReadFromFile");
			pJournalEntry->addStringParameter("FileName", pFileName);
		}
		if (pFileName == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sFileName(pFileName);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->ReadFromFile(sFileName);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_readfromcallback(Lib3MF_Attachment pAttachment, Lib3MFReadCallback pTheReadCallback, Lib3MF_uint64 nStreamSize, Lib3MFSeekCallback pTheSeekCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "ReadFromCallback");
			pJournalEntry->addUInt64Parameter("StreamSize", nStreamSize);
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->ReadFromCallback(pTheReadCallback, nStreamSize, pTheSeekCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_getstreamsize(Lib3MF_Attachment pAttachment, Lib3MF_uint64 * pStreamSize)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "GetStreamSize");
		}
		if (pStreamSize == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pStreamSize = pIAttachment->GetStreamSize();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("StreamSize", *pStreamSize);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_writetobuffer(Lib3MF_Attachment pAttachment, const Lib3MF_uint64 nBufferBufferSize, Lib3MF_uint64* pBufferNeededCount, Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "WriteToBuffer");
		}
		if ((!pBufferBuffer) && !(pBufferNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->WriteToBuffer(nBufferBufferSize, pBufferNeededCount, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_attachment_readfrombuffer(Lib3MF_Attachment pAttachment, Lib3MF_uint64 nBufferBufferSize, const Lib3MF_uint8 * pBufferBuffer)
{
	IBase* pIBaseClass = (IBase *)pAttachment;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAttachment, "Attachment", "ReadFromBuffer");
		}
		if ( (!pBufferBuffer) && (nBufferBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClass);
		if (!pIAttachment)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIAttachment->ReadFromBuffer(nBufferBufferSize, pBufferBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Texture2D
**************************************************************************************************************************/
Lib3MFResult lib3mf_texture2d_getattachment(Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pITexture2D->GetAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_setattachment(Lib3MF_Texture2D pTexture2D, Lib3MF_Attachment pAttachment)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetAttachment");
			pJournalEntry->addHandleParameter("Attachment", pAttachment);
		}
		IBase* pIBaseClassAttachment = (IBase *)pAttachment;
		IAttachment* pIAttachment = dynamic_cast<IAttachment*>(pIBaseClassAttachment);
		if (!pIAttachment)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetAttachment(pIAttachment);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_getcontenttype(Lib3MF_Texture2D pTexture2D, eLib3MFTextureType * pContentType)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetContentType");
		}
		if (pContentType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pContentType = pITexture2D->GetContentType();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ContentType", "TextureType", (Lib3MF_int32)(*pContentType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_setcontenttype(Lib3MF_Texture2D pTexture2D, eLib3MFTextureType eContentType)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetContentType");
			pJournalEntry->addEnumParameter("ContentType", "TextureType", (Lib3MF_int32)(eContentType));
		}
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetContentType(eContentType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_gettilestyleuv(Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle * pTileStyleU, eLib3MFTextureTileStyle * pTileStyleV)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetTileStyleUV");
		}
		if (!pTileStyleU)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pTileStyleV)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->GetTileStyleUV(*pTileStyleU, *pTileStyleV);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("TileStyleU", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleU));
			pJournalEntry->addEnumResult("TileStyleV", "TextureTileStyle", (Lib3MF_int32)(*pTileStyleV));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_settilestyleuv(Lib3MF_Texture2D pTexture2D, eLib3MFTextureTileStyle eTileStyleU, eLib3MFTextureTileStyle eTileStyleV)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetTileStyleUV");
			pJournalEntry->addEnumParameter("TileStyleU", "TextureTileStyle", (Lib3MF_int32)(eTileStyleU));
			pJournalEntry->addEnumParameter("TileStyleV", "TextureTileStyle", (Lib3MF_int32)(eTileStyleV));
		}
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetTileStyleUV(eTileStyleU, eTileStyleV);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_getfilter(Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter * pFilter)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "GetFilter");
		}
		if (pFilter == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pFilter = pITexture2D->GetFilter();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Filter", "TextureFilter", (Lib3MF_int32)(*pFilter));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_texture2d_setfilter(Lib3MF_Texture2D pTexture2D, eLib3MFTextureFilter eFilter)
{
	IBase* pIBaseClass = (IBase *)pTexture2D;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pTexture2D, "Texture2D", "SetFilter");
			pJournalEntry->addEnumParameter("Filter", "TextureFilter", (Lib3MF_int32)(eFilter));
		}
		ITexture2D* pITexture2D = dynamic_cast<ITexture2D*>(pIBaseClass);
		if (!pITexture2D)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pITexture2D->SetFilter(eFilter);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BuildItem
**************************************************************************************************************************/
Lib3MFResult lib3mf_builditem_getobjectresource(Lib3MF_BuildItem pBuildItem, Lib3MF_Object * pObjectResource)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetObjectResource");
		}
		if (pObjectResource == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseObjectResource(nullptr);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseObjectResource = pIBuildItem->GetObjectResource();

		*pObjectResource = (IBase*)(pBaseObjectResource);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ObjectResource", *pObjectResource);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getuuid(Lib3MF_BuildItem pBuildItem, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIBuildItem->GetUUID(*pHasUUID);

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_setuuid(Lib3MF_BuildItem pBuildItem, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBuildItem->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getobjectresourceid(Lib3MF_BuildItem pBuildItem, Lib3MF_uint32 * pUniqueResourceID)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetObjectResourceID");
		}
		if (pUniqueResourceID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUniqueResourceID = pIBuildItem->GetObjectResourceID();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("UniqueResourceID", *pUniqueResourceID);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_hasobjecttransform(Lib3MF_BuildItem pBuildItem, bool * pHasTransform)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "HasObjectTransform");
		}
		if (pHasTransform == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasTransform = pIBuildItem->HasObjectTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasTransform", *pHasTransform);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getobjecttransform(Lib3MF_BuildItem pBuildItem, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetObjectTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pTransform = pIBuildItem->GetObjectTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_setobjecttransform(Lib3MF_BuildItem pBuildItem, const sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "SetObjectTransform");
		}
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBuildItem->SetObjectTransform(*pTransform);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getpartnumber(Lib3MF_BuildItem pBuildItem, const Lib3MF_uint32 nPartNumberBufferSize, Lib3MF_uint32* pPartNumberNeededChars, char * pPartNumberBuffer)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetPartNumber");
		}
		if ( (!pPartNumberBuffer) && !(pPartNumberNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPartNumber("");
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sPartNumber = pIBuildItem->GetPartNumber();

		if (pPartNumberNeededChars)
			*pPartNumberNeededChars = (Lib3MF_uint32) (sPartNumber.size()+1);
		if (pPartNumberBuffer) {
			if (sPartNumber.size() >= nPartNumberBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPartNumber = 0; iPartNumber < sPartNumber.size(); iPartNumber++)
				pPartNumberBuffer[iPartNumber] = sPartNumber[iPartNumber];
			pPartNumberBuffer[sPartNumber.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("PartNumber", sPartNumber.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_setpartnumber(Lib3MF_BuildItem pBuildItem, const char * pSetPartnumber)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "SetPartNumber");
			pJournalEntry->addStringParameter("SetPartnumber", pSetPartnumber);
		}
		if (pSetPartnumber == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sSetPartnumber(pSetPartnumber);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIBuildItem->SetPartNumber(sSetPartnumber);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getmetadatagroup(Lib3MF_BuildItem pBuildItem, Lib3MF_MetaDataGroup * pMetaDataGroup)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetMetaDataGroup");
		}
		if (pMetaDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMetaDataGroup(nullptr);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMetaDataGroup = pIBuildItem->GetMetaDataGroup();

		*pMetaDataGroup = (IBase*)(pBaseMetaDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MetaDataGroup", *pMetaDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditem_getoutbox(Lib3MF_BuildItem pBuildItem, sLib3MFBox * pOutbox)
{
	IBase* pIBaseClass = (IBase *)pBuildItem;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItem, "BuildItem", "GetOutbox");
		}
		if (pOutbox == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItem* pIBuildItem = dynamic_cast<IBuildItem*>(pIBaseClass);
		if (!pIBuildItem)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOutbox = pIBuildItem->GetOutbox();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for BuildItemIterator
**************************************************************************************************************************/
Lib3MFResult lib3mf_builditemiterator_movenext(Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasNext)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "MoveNext");
		}
		if (pHasNext == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasNext = pIBuildItemIterator->MoveNext();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasNext", *pHasNext);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_moveprevious(Lib3MF_BuildItemIterator pBuildItemIterator, bool * pHasPrevious)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "MovePrevious");
		}
		if (pHasPrevious == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasPrevious = pIBuildItemIterator->MovePrevious();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrevious", *pHasPrevious);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_getcurrent(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItem * pBuildItem)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "GetCurrent");
		}
		if (pBuildItem == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBuildItem(nullptr);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBuildItem = pIBuildItemIterator->GetCurrent();

		*pBuildItem = (IBase*)(pBaseBuildItem);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BuildItem", *pBuildItem);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_clone(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_BuildItemIterator * pOutBuildItemIterator)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "Clone");
		}
		if (pOutBuildItemIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseOutBuildItemIterator(nullptr);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseOutBuildItemIterator = pIBuildItemIterator->Clone();

		*pOutBuildItemIterator = (IBase*)(pBaseOutBuildItemIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("OutBuildItemIterator", *pOutBuildItemIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_builditemiterator_count(Lib3MF_BuildItemIterator pBuildItemIterator, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pBuildItemIterator;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pBuildItemIterator, "BuildItemIterator", "Count");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBuildItemIterator* pIBuildItemIterator = dynamic_cast<IBuildItemIterator*>(pIBaseClass);
		if (!pIBuildItemIterator)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIBuildItemIterator->Count();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Slice
**************************************************************************************************************************/
Lib3MFResult lib3mf_slice_setvertices(Lib3MF_Slice pSlice, Lib3MF_uint64 nVerticesBufferSize, const sLib3MFPosition2D * pVerticesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "SetVertices");
		}
		if ( (!pVerticesBuffer) && (nVerticesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->SetVertices(nVerticesBufferSize, pVerticesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getvertices(Lib3MF_Slice pSlice, const Lib3MF_uint64 nVerticesBufferSize, Lib3MF_uint64* pVerticesNeededCount, sLib3MFPosition2D * pVerticesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetVertices");
		}
		if ((!pVerticesBuffer) && !(pVerticesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->GetVertices(nVerticesBufferSize, pVerticesNeededCount, pVerticesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getvertexcount(Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetVertexCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISlice->GetVertexCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_addpolygon(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer, Lib3MF_uint64 * pIndex)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "AddPolygon");
		}
		if ( (!pIndicesBuffer) && (nIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pIndex == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pIndex = pISlice->AddPolygon(nIndicesBufferSize, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Index", *pIndex);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getpolygoncount(Lib3MF_Slice pSlice, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetPolygonCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISlice->GetPolygonCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_setpolygonindices(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 nIndicesBufferSize, const Lib3MF_uint32 * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "SetPolygonIndices");
			pJournalEntry->addUInt64Parameter("Index", nIndex);
		}
		if ( (!pIndicesBuffer) && (nIndicesBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->SetPolygonIndices(nIndex, nIndicesBufferSize, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getpolygonindices(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, const Lib3MF_uint64 nIndicesBufferSize, Lib3MF_uint64* pIndicesNeededCount, Lib3MF_uint32 * pIndicesBuffer)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetPolygonIndices");
			pJournalEntry->addUInt64Parameter("Index", nIndex);
		}
		if ((!pIndicesBuffer) && !(pIndicesNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISlice->GetPolygonIndices(nIndex, nIndicesBufferSize, pIndicesNeededCount, pIndicesBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getpolygonindexcount(Lib3MF_Slice pSlice, Lib3MF_uint64 nIndex, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetPolygonIndexCount");
			pJournalEntry->addUInt64Parameter("Index", nIndex);
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISlice->GetPolygonIndexCount(nIndex);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slice_getztop(Lib3MF_Slice pSlice, Lib3MF_double * pZTop)
{
	IBase* pIBaseClass = (IBase *)pSlice;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSlice, "Slice", "GetZTop");
		}
		if (pZTop == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISlice* pISlice = dynamic_cast<ISlice*>(pIBaseClass);
		if (!pISlice)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pZTop = pISlice->GetZTop();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("ZTop", *pZTop);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for SliceStack
**************************************************************************************************************************/
Lib3MFResult lib3mf_slicestack_getbottomz(Lib3MF_SliceStack pSliceStack, Lib3MF_double * pZBottom)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetBottomZ");
		}
		if (pZBottom == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pZBottom = pISliceStack->GetBottomZ();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addDoubleResult("ZBottom", *pZBottom);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslicecount(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSliceCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISliceStack->GetSliceCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslice(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceIndex, Lib3MF_Slice * pTheSlice)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSlice");
			pJournalEntry->addUInt64Parameter("SliceIndex", nSliceIndex);
		}
		if (pTheSlice == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheSlice(nullptr);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheSlice = pISliceStack->GetSlice(nSliceIndex);

		*pTheSlice = (IBase*)(pBaseTheSlice);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheSlice", *pTheSlice);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_addslice(Lib3MF_SliceStack pSliceStack, Lib3MF_double dZTop, Lib3MF_Slice * pTheSlice)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "AddSlice");
			pJournalEntry->addDoubleParameter("ZTop", dZTop);
		}
		if (pTheSlice == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheSlice(nullptr);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheSlice = pISliceStack->AddSlice(dZTop);

		*pTheSlice = (IBase*)(pBaseTheSlice);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheSlice", *pTheSlice);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslicerefcount(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSliceRefCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pISliceStack->GetSliceRefCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_addslicestackreference(Lib3MF_SliceStack pSliceStack, Lib3MF_SliceStack pTheSliceStack)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "AddSliceStackReference");
			pJournalEntry->addHandleParameter("TheSliceStack", pTheSliceStack);
		}
		IBase* pIBaseClassTheSliceStack = (IBase *)pTheSliceStack;
		ISliceStack* pITheSliceStack = dynamic_cast<ISliceStack*>(pIBaseClassTheSliceStack);
		if (!pITheSliceStack)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISliceStack->AddSliceStackReference(pITheSliceStack);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getslicestackreference(Lib3MF_SliceStack pSliceStack, Lib3MF_uint64 nSliceRefIndex, Lib3MF_SliceStack * pTheSliceStack)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetSliceStackReference");
			pJournalEntry->addUInt64Parameter("SliceRefIndex", nSliceRefIndex);
		}
		if (pTheSliceStack == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheSliceStack(nullptr);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheSliceStack = pISliceStack->GetSliceStackReference(nSliceRefIndex);

		*pTheSliceStack = (IBase*)(pBaseTheSliceStack);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheSliceStack", *pTheSliceStack);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_collapseslicereferences(Lib3MF_SliceStack pSliceStack)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "CollapseSliceReferences");
		}
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISliceStack->CollapseSliceReferences();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_setownpath(Lib3MF_SliceStack pSliceStack, const char * pPath)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "SetOwnPath");
			pJournalEntry->addStringParameter("Path", pPath);
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath(pPath);
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pISliceStack->SetOwnPath(sPath);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_slicestack_getownpath(Lib3MF_SliceStack pSliceStack, const Lib3MF_uint32 nPathBufferSize, Lib3MF_uint32* pPathNeededChars, char * pPathBuffer)
{
	IBase* pIBaseClass = (IBase *)pSliceStack;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pSliceStack, "SliceStack", "GetOwnPath");
		}
		if ( (!pPathBuffer) && !(pPathNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPath("");
		ISliceStack* pISliceStack = dynamic_cast<ISliceStack*>(pIBaseClass);
		if (!pISliceStack)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sPath = pISliceStack->GetOwnPath();

		if (pPathNeededChars)
			*pPathNeededChars = (Lib3MF_uint32) (sPath.size()+1);
		if (pPathBuffer) {
			if (sPath.size() >= nPathBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPath = 0; iPath < sPath.size(); iPath++)
				pPathBuffer[iPath] = sPath[iPath];
			pPathBuffer[sPath.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Path", sPath.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Consumer
**************************************************************************************************************************/
Lib3MFResult lib3mf_consumer_getconsumerid(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nConsumerIDBufferSize, Lib3MF_uint32* pConsumerIDNeededChars, char * pConsumerIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pConsumer;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConsumer, "Consumer", "GetConsumerID");
		}
		if ( (!pConsumerIDBuffer) && !(pConsumerIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID("");
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClass);
		if (!pIConsumer)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sConsumerID = pIConsumer->GetConsumerID();

		if (pConsumerIDNeededChars)
			*pConsumerIDNeededChars = (Lib3MF_uint32) (sConsumerID.size()+1);
		if (pConsumerIDBuffer) {
			if (sConsumerID.size() >= nConsumerIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iConsumerID = 0; iConsumerID < sConsumerID.size(); iConsumerID++)
				pConsumerIDBuffer[iConsumerID] = sConsumerID[iConsumerID];
			pConsumerIDBuffer[sConsumerID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ConsumerID", sConsumerID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_consumer_getkeyid(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyIDBufferSize, Lib3MF_uint32* pKeyIDNeededChars, char * pKeyIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pConsumer;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConsumer, "Consumer", "GetKeyID");
		}
		if ( (!pKeyIDBuffer) && !(pKeyIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sKeyID("");
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClass);
		if (!pIConsumer)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sKeyID = pIConsumer->GetKeyID();

		if (pKeyIDNeededChars)
			*pKeyIDNeededChars = (Lib3MF_uint32) (sKeyID.size()+1);
		if (pKeyIDBuffer) {
			if (sKeyID.size() >= nKeyIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iKeyID = 0; iKeyID < sKeyID.size(); iKeyID++)
				pKeyIDBuffer[iKeyID] = sKeyID[iKeyID];
			pKeyIDBuffer[sKeyID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("KeyID", sKeyID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_consumer_getkeyvalue(Lib3MF_Consumer pConsumer, const Lib3MF_uint32 nKeyValueBufferSize, Lib3MF_uint32* pKeyValueNeededChars, char * pKeyValueBuffer)
{
	IBase* pIBaseClass = (IBase *)pConsumer;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pConsumer, "Consumer", "GetKeyValue");
		}
		if ( (!pKeyValueBuffer) && !(pKeyValueNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sKeyValue("");
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClass);
		if (!pIConsumer)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sKeyValue = pIConsumer->GetKeyValue();

		if (pKeyValueNeededChars)
			*pKeyValueNeededChars = (Lib3MF_uint32) (sKeyValue.size()+1);
		if (pKeyValueBuffer) {
			if (sKeyValue.size() >= nKeyValueBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iKeyValue = 0; iKeyValue < sKeyValue.size(); iKeyValue++)
				pKeyValueBuffer[iKeyValue] = sKeyValue[iKeyValue];
			pKeyValueBuffer[sKeyValue.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("KeyValue", sKeyValue.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for AccessRight
**************************************************************************************************************************/
Lib3MFResult lib3mf_accessright_getconsumer(Lib3MF_AccessRight pAccessRight, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetConsumer");
		}
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseConsumer(nullptr);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIAccessRight->GetConsumer();

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_accessright_getwrappingalgorithm(Lib3MF_AccessRight pAccessRight, eLib3MFWrappingAlgorithm * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetWrappingAlgorithm");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIAccessRight->GetWrappingAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "WrappingAlgorithm", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_accessright_getmgfalgorithm(Lib3MF_AccessRight pAccessRight, eLib3MFMgfAlgorithm * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetMgfAlgorithm");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIAccessRight->GetMgfAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "MgfAlgorithm", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_accessright_getdigestmethod(Lib3MF_AccessRight pAccessRight, eLib3MFDigestMethod * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pAccessRight;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pAccessRight, "AccessRight", "GetDigestMethod");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IAccessRight* pIAccessRight = dynamic_cast<IAccessRight*>(pIBaseClass);
		if (!pIAccessRight)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIAccessRight->GetDigestMethod();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "DigestMethod", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ContentEncryptionParams
**************************************************************************************************************************/
Lib3MFResult lib3mf_contentencryptionparams_getencryptionalgorithm(Lib3MF_ContentEncryptionParams pContentEncryptionParams, eLib3MFEncryptionAlgorithm * pAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetEncryptionAlgorithm");
		}
		if (pAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAlgorithm = pIContentEncryptionParams->GetEncryptionAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Algorithm", "EncryptionAlgorithm", (Lib3MF_int32)(*pAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getkey(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetKey");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetKey(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getinitializationvector(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetInitializationVector");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetInitializationVector(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getauthenticationtag(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetAuthenticationTag");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetAuthenticationTag(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_setauthenticationtag(Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 nByteDataBufferSize, const Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "SetAuthenticationTag");
		}
		if ( (!pByteDataBuffer) && (nByteDataBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->SetAuthenticationTag(nByteDataBufferSize, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getadditionalauthenticationdata(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetAdditionalAuthenticationData");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIContentEncryptionParams->GetAdditionalAuthenticationData(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getdescriptor(Lib3MF_ContentEncryptionParams pContentEncryptionParams, Lib3MF_uint64 * pDescriptor)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetDescriptor");
		}
		if (pDescriptor == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pDescriptor = pIContentEncryptionParams->GetDescriptor();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Descriptor", *pDescriptor);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_contentencryptionparams_getkeyuuid(Lib3MF_ContentEncryptionParams pContentEncryptionParams, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pContentEncryptionParams;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pContentEncryptionParams, "ContentEncryptionParams", "GetKeyUUID");
		}
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IContentEncryptionParams* pIContentEncryptionParams = dynamic_cast<IContentEncryptionParams*>(pIBaseClass);
		if (!pIContentEncryptionParams)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIContentEncryptionParams->GetKeyUUID();

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ResourceData
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourcedata_getpath(Lib3MF_ResourceData pResourceData, Lib3MF_PackagePart * pPath)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetPath");
		}
		if (pPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBasePath(nullptr);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBasePath = pIResourceData->GetPath();

		*pPath = (IBase*)(pBasePath);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Path", *pPath);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedata_getencryptionalgorithm(Lib3MF_ResourceData pResourceData, eLib3MFEncryptionAlgorithm * pEncryptionAlgorithm)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetEncryptionAlgorithm");
		}
		if (pEncryptionAlgorithm == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pEncryptionAlgorithm = pIResourceData->GetEncryptionAlgorithm();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("EncryptionAlgorithm", "EncryptionAlgorithm", (Lib3MF_int32)(*pEncryptionAlgorithm));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedata_getcompression(Lib3MF_ResourceData pResourceData, eLib3MFCompression * pCompression)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetCompression");
		}
		if (pCompression == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCompression = pIResourceData->GetCompression();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Compression", "Compression", (Lib3MF_int32)(*pCompression));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedata_getadditionalauthenticationdata(Lib3MF_ResourceData pResourceData, const Lib3MF_uint64 nByteDataBufferSize, Lib3MF_uint64* pByteDataNeededCount, Lib3MF_uint8 * pByteDataBuffer)
{
	IBase* pIBaseClass = (IBase *)pResourceData;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceData, "ResourceData", "GetAdditionalAuthenticationData");
		}
		if ((!pByteDataBuffer) && !(pByteDataNeededCount))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClass);
		if (!pIResourceData)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResourceData->GetAdditionalAuthenticationData(nByteDataBufferSize, pByteDataNeededCount, pByteDataBuffer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for ResourceDataGroup
**************************************************************************************************************************/
Lib3MFResult lib3mf_resourcedatagroup_getkeyuuid(Lib3MF_ResourceDataGroup pResourceDataGroup, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "GetKeyUUID");
		}
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIResourceDataGroup->GetKeyUUID();

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedatagroup_addaccessright(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, eLib3MFWrappingAlgorithm eWrappingAlgorithm, eLib3MFMgfAlgorithm eMgfAlgorithm, eLib3MFDigestMethod eDigestMethod, Lib3MF_AccessRight * pTheAccessRight)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "AddAccessRight");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
			pJournalEntry->addEnumParameter("WrappingAlgorithm", "WrappingAlgorithm", (Lib3MF_int32)(eWrappingAlgorithm));
			pJournalEntry->addEnumParameter("MgfAlgorithm", "MgfAlgorithm", (Lib3MF_int32)(eMgfAlgorithm));
			pJournalEntry->addEnumParameter("DigestMethod", "DigestMethod", (Lib3MF_int32)(eDigestMethod));
		}
		if (pTheAccessRight == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTheAccessRight(nullptr);
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheAccessRight = pIResourceDataGroup->AddAccessRight(pIConsumer, eWrappingAlgorithm, eMgfAlgorithm, eDigestMethod);

		*pTheAccessRight = (IBase*)(pBaseTheAccessRight);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheAccessRight", *pTheAccessRight);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedatagroup_findaccessrightbyconsumer(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer, Lib3MF_AccessRight * pTheAccessRight)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "FindAccessRightByConsumer");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
		}
		if (pTheAccessRight == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTheAccessRight(nullptr);
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheAccessRight = pIResourceDataGroup->FindAccessRightByConsumer(pIConsumer);

		*pTheAccessRight = (IBase*)(pBaseTheAccessRight);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheAccessRight", *pTheAccessRight);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_resourcedatagroup_removeaccessright(Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_Consumer pConsumer)
{
	IBase* pIBaseClass = (IBase *)pResourceDataGroup;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pResourceDataGroup, "ResourceDataGroup", "RemoveAccessRight");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
		}
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClass);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIResourceDataGroup->RemoveAccessRight(pIConsumer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for KeyStore
**************************************************************************************************************************/
Lib3MFResult lib3mf_keystore_addconsumer(Lib3MF_KeyStore pKeyStore, const char * pConsumerID, const char * pKeyID, const char * pKeyValue, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "AddConsumer");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
			pJournalEntry->addStringParameter("KeyID", pKeyID);
			pJournalEntry->addStringParameter("KeyValue", pKeyValue);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pKeyID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pKeyValue == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		std::string sKeyID(pKeyID);
		std::string sKeyValue(pKeyValue);
		IBase* pBaseConsumer(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIKeyStore->AddConsumer(sConsumerID, sKeyID, sKeyValue);

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getconsumercount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetConsumerCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIKeyStore->GetConsumerCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getconsumer(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nConsumerIndex, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetConsumer");
			pJournalEntry->addUInt64Parameter("ConsumerIndex", nConsumerIndex);
		}
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseConsumer(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIKeyStore->GetConsumer(nConsumerIndex);

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_removeconsumer(Lib3MF_KeyStore pKeyStore, Lib3MF_Consumer pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "RemoveConsumer");
			pJournalEntry->addHandleParameter("Consumer", pConsumer);
		}
		IBase* pIBaseClassConsumer = (IBase *)pConsumer;
		IConsumer* pIConsumer = dynamic_cast<IConsumer*>(pIBaseClassConsumer);
		if (!pIConsumer)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->RemoveConsumer(pIConsumer);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_findconsumer(Lib3MF_KeyStore pKeyStore, const char * pConsumerID, Lib3MF_Consumer * pConsumer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "FindConsumer");
			pJournalEntry->addStringParameter("ConsumerID", pConsumerID);
		}
		if (pConsumerID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pConsumer == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sConsumerID(pConsumerID);
		IBase* pBaseConsumer(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseConsumer = pIKeyStore->FindConsumer(sConsumerID);

		*pConsumer = (IBase*)(pBaseConsumer);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Consumer", *pConsumer);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedatagroupcount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceDataGroupCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIKeyStore->GetResourceDataGroupCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_addresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "AddResourceDataGroup");
		}
		if (pResourceDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceDataGroup(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceDataGroup = pIKeyStore->AddResourceDataGroup();

		*pResourceDataGroup = (IBase*)(pBaseResourceDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceDataGroup", *pResourceDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceDataGroup");
			pJournalEntry->addUInt64Parameter("ResourceDataIndex", nResourceDataIndex);
		}
		if (pResourceDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceDataGroup(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceDataGroup = pIKeyStore->GetResourceDataGroup(nResourceDataIndex);

		*pResourceDataGroup = (IBase*)(pBaseResourceDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceDataGroup", *pResourceDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_removeresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "RemoveResourceDataGroup");
			pJournalEntry->addHandleParameter("ResourceDataGroup", pResourceDataGroup);
		}
		IBase* pIBaseClassResourceDataGroup = (IBase *)pResourceDataGroup;
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClassResourceDataGroup);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->RemoveResourceDataGroup(pIResourceDataGroup);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_findresourcedatagroup(Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pPartPath, Lib3MF_ResourceDataGroup * pResourceDataGroup)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "FindResourceDataGroup");
			pJournalEntry->addHandleParameter("PartPath", pPartPath);
		}
		if (pResourceDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassPartPath = (IBase *)pPartPath;
		IPackagePart* pIPartPath = dynamic_cast<IPackagePart*>(pIBaseClassPartPath);
		if (!pIPartPath)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseResourceDataGroup(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceDataGroup = pIKeyStore->FindResourceDataGroup(pIPartPath);

		*pResourceDataGroup = (IBase*)(pBaseResourceDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceDataGroup", *pResourceDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_addresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceDataGroup pResourceDataGroup, Lib3MF_PackagePart pPartPath, eLib3MFEncryptionAlgorithm eAlgorithm, eLib3MFCompression eCompression, Lib3MF_uint64 nAdditionalAuthenticationDataBufferSize, const Lib3MF_uint8 * pAdditionalAuthenticationDataBuffer, Lib3MF_ResourceData * pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "AddResourceData");
			pJournalEntry->addHandleParameter("ResourceDataGroup", pResourceDataGroup);
			pJournalEntry->addHandleParameter("PartPath", pPartPath);
			pJournalEntry->addEnumParameter("Algorithm", "EncryptionAlgorithm", (Lib3MF_int32)(eAlgorithm));
			pJournalEntry->addEnumParameter("Compression", "Compression", (Lib3MF_int32)(eCompression));
		}
		if ( (!pAdditionalAuthenticationDataBuffer) && (nAdditionalAuthenticationDataBufferSize>0))
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pResourceData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassResourceDataGroup = (IBase *)pResourceDataGroup;
		IResourceDataGroup* pIResourceDataGroup = dynamic_cast<IResourceDataGroup*>(pIBaseClassResourceDataGroup);
		if (!pIResourceDataGroup)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pIBaseClassPartPath = (IBase *)pPartPath;
		IPackagePart* pIPartPath = dynamic_cast<IPackagePart*>(pIBaseClassPartPath);
		if (!pIPartPath)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseResourceData(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceData = pIKeyStore->AddResourceData(pIResourceDataGroup, pIPartPath, eAlgorithm, eCompression, nAdditionalAuthenticationDataBufferSize, pAdditionalAuthenticationDataBuffer);

		*pResourceData = (IBase*)(pBaseResourceData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceData", *pResourceData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_removeresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_ResourceData pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "RemoveResourceData");
			pJournalEntry->addHandleParameter("ResourceData", pResourceData);
		}
		IBase* pIBaseClassResourceData = (IBase *)pResourceData;
		IResourceData* pIResourceData = dynamic_cast<IResourceData*>(pIBaseClassResourceData);
		if (!pIResourceData)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->RemoveResourceData(pIResourceData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_findresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_PackagePart pResourcePath, Lib3MF_ResourceData * pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "FindResourceData");
			pJournalEntry->addHandleParameter("ResourcePath", pResourcePath);
		}
		if (pResourceData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassResourcePath = (IBase *)pResourcePath;
		IPackagePart* pIResourcePath = dynamic_cast<IPackagePart*>(pIBaseClassResourcePath);
		if (!pIResourcePath)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseResourceData(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceData = pIKeyStore->FindResourceData(pIResourcePath);

		*pResourceData = (IBase*)(pBaseResourceData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceData", *pResourceData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedatacount(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 * pCount)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceDataCount");
		}
		if (pCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pCount = pIKeyStore->GetResourceDataCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt64Result("Count", *pCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getresourcedata(Lib3MF_KeyStore pKeyStore, Lib3MF_uint64 nResourceDataIndex, Lib3MF_ResourceData * pResourceData)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetResourceData");
			pJournalEntry->addUInt64Parameter("ResourceDataIndex", nResourceDataIndex);
		}
		if (pResourceData == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceData(nullptr);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceData = pIKeyStore->GetResourceData(nResourceDataIndex);

		*pResourceData = (IBase*)(pBaseResourceData);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceData", *pResourceData);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_getuuid(Lib3MF_KeyStore pKeyStore, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "GetUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIKeyStore->GetUUID(*pHasUUID);

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_keystore_setuuid(Lib3MF_KeyStore pKeyStore, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pKeyStore;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pKeyStore, "KeyStore", "SetUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IKeyStore* pIKeyStore = dynamic_cast<IKeyStore*>(pIBaseClass);
		if (!pIKeyStore)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIKeyStore->SetUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


/*************************************************************************************************************************
 Class implementation for Model
**************************************************************************************************************************/
Lib3MFResult lib3mf_model_rootmodelpart(Lib3MF_Model pModel, Lib3MF_PackagePart * pRootModelPart)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RootModelPart");
		}
		if (pRootModelPart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseRootModelPart(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseRootModelPart = pIModel->RootModelPart();

		*pRootModelPart = (IBase*)(pBaseRootModelPart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("RootModelPart", *pRootModelPart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_findorcreatepackagepart(Lib3MF_Model pModel, const char * pAbsolutePath, Lib3MF_PackagePart * pModelPart)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "FindOrCreatePackagePart");
			pJournalEntry->addStringParameter("AbsolutePath", pAbsolutePath);
		}
		if (pAbsolutePath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pModelPart == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sAbsolutePath(pAbsolutePath);
		IBase* pBaseModelPart(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseModelPart = pIModel->FindOrCreatePackagePart(sAbsolutePath);

		*pModelPart = (IBase*)(pBaseModelPart);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ModelPart", *pModelPart);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setunit(Lib3MF_Model pModel, eLib3MFModelUnit eUnit)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetUnit");
			pJournalEntry->addEnumParameter("Unit", "ModelUnit", (Lib3MF_int32)(eUnit));
		}
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetUnit(eUnit);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getunit(Lib3MF_Model pModel, eLib3MFModelUnit * pUnit)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetUnit");
		}
		if (pUnit == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pUnit = pIModel->GetUnit();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("Unit", "ModelUnit", (Lib3MF_int32)(*pUnit));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getlanguage(Lib3MF_Model pModel, const Lib3MF_uint32 nLanguageBufferSize, Lib3MF_uint32* pLanguageNeededChars, char * pLanguageBuffer)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetLanguage");
		}
		if ( (!pLanguageBuffer) && !(pLanguageNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sLanguage("");
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sLanguage = pIModel->GetLanguage();

		if (pLanguageNeededChars)
			*pLanguageNeededChars = (Lib3MF_uint32) (sLanguage.size()+1);
		if (pLanguageBuffer) {
			if (sLanguage.size() >= nLanguageBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iLanguage = 0; iLanguage < sLanguage.size(); iLanguage++)
				pLanguageBuffer[iLanguage] = sLanguage[iLanguage];
			pLanguageBuffer[sLanguage.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("Language", sLanguage.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setlanguage(Lib3MF_Model pModel, const char * pLanguage)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetLanguage");
			pJournalEntry->addStringParameter("Language", pLanguage);
		}
		if (pLanguage == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sLanguage(pLanguage);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetLanguage(sLanguage);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_querywriter(Lib3MF_Model pModel, const char * pWriterClass, Lib3MF_Writer * pWriterInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "QueryWriter");
			pJournalEntry->addStringParameter("WriterClass", pWriterClass);
		}
		if (pWriterClass == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pWriterInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sWriterClass(pWriterClass);
		IBase* pBaseWriterInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseWriterInstance = pIModel->QueryWriter(sWriterClass);

		*pWriterInstance = (IBase*)(pBaseWriterInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("WriterInstance", *pWriterInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_queryreader(Lib3MF_Model pModel, const char * pReaderClass, Lib3MF_Reader * pReaderInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "QueryReader");
			pJournalEntry->addStringParameter("ReaderClass", pReaderClass);
		}
		if (pReaderClass == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pReaderInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sReaderClass(pReaderClass);
		IBase* pBaseReaderInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseReaderInstance = pIModel->QueryReader(sReaderClass);

		*pReaderInstance = (IBase*)(pBaseReaderInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ReaderInstance", *pReaderInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2dbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2D * pTextureInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2DByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pTextureInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTextureInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTextureInstance = pIModel->GetTexture2DByID(nUniqueResourceID);

		*pTextureInstance = (IBase*)(pBaseTextureInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TextureInstance", *pTextureInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getpropertytypebyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, eLib3MFPropertyType * pThePropertyType)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetPropertyTypeByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pThePropertyType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pThePropertyType = pIModel->GetPropertyTypeByID(nUniqueResourceID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addEnumResult("ThePropertyType", "PropertyType", (Lib3MF_int32)(*pThePropertyType));
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbasematerialgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBaseMaterialGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pIModel->GetBaseMaterialGroupByID(nUniqueResourceID);

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2dgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2DGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pTexture2DGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTexture2DGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DGroupInstance = pIModel->GetTexture2DGroupByID(nUniqueResourceID);

		*pTexture2DGroupInstance = (IBase*)(pBaseTexture2DGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DGroupInstance", *pTexture2DGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcompositematerialsbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetCompositeMaterialsByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pCompositeMaterialsInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseCompositeMaterialsInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseCompositeMaterialsInstance = pIModel->GetCompositeMaterialsByID(nUniqueResourceID);

		*pCompositeMaterialsInstance = (IBase*)(pBaseCompositeMaterialsInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("CompositeMaterialsInstance", *pCompositeMaterialsInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmultipropertygroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMultiPropertyGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pMultiPropertyGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMultiPropertyGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMultiPropertyGroupInstance = pIModel->GetMultiPropertyGroupByID(nUniqueResourceID);

		*pMultiPropertyGroupInstance = (IBase*)(pBaseMultiPropertyGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MultiPropertyGroupInstance", *pMultiPropertyGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmeshobjectbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_MeshObject * pMeshObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMeshObjectByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pMeshObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMeshObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMeshObjectInstance = pIModel->GetMeshObjectByID(nUniqueResourceID);

		*pMeshObjectInstance = (IBase*)(pBaseMeshObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MeshObjectInstance", *pMeshObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcomponentsobjectbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetComponentsObjectByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pComponentsObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseComponentsObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentsObjectInstance = pIModel->GetComponentsObjectByID(nUniqueResourceID);

		*pComponentsObjectInstance = (IBase*)(pBaseComponentsObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentsObjectInstance", *pComponentsObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcolorgroupbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_ColorGroup * pColorGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetColorGroupByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pColorGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColorGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColorGroupInstance = pIModel->GetColorGroupByID(nUniqueResourceID);

		*pColorGroupInstance = (IBase*)(pBaseColorGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ColorGroupInstance", *pColorGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getslicestackbyid(Lib3MF_Model pModel, Lib3MF_uint32 nUniqueResourceID, Lib3MF_SliceStack * pSliceStacInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetSliceStackByID");
			pJournalEntry->addUInt32Parameter("UniqueResourceID", nUniqueResourceID);
		}
		if (pSliceStacInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSliceStacInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSliceStacInstance = pIModel->GetSliceStackByID(nUniqueResourceID);

		*pSliceStacInstance = (IBase*)(pBaseSliceStacInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("SliceStacInstance", *pSliceStacInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbuilduuid(Lib3MF_Model pModel, bool * pHasUUID, const Lib3MF_uint32 nUUIDBufferSize, Lib3MF_uint32* pUUIDNeededChars, char * pUUIDBuffer)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBuildUUID");
		}
		if (!pHasUUID)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pUUIDBuffer) && !(pUUIDNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID("");
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		sUUID = pIModel->GetBuildUUID(*pHasUUID);

		if (pUUIDNeededChars)
			*pUUIDNeededChars = (Lib3MF_uint32) (sUUID.size()+1);
		if (pUUIDBuffer) {
			if (sUUID.size() >= nUUIDBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iUUID = 0; iUUID < sUUID.size(); iUUID++)
				pUUIDBuffer[iUUID] = sUUID[iUUID];
			pUUIDBuffer[sUUID.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasUUID", *pHasUUID);
			pJournalEntry->addStringResult("UUID", sUUID.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setbuilduuid(Lib3MF_Model pModel, const char * pUUID)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetBuildUUID");
			pJournalEntry->addStringParameter("UUID", pUUID);
		}
		if (pUUID == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sUUID(pUUID);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetBuildUUID(sUUID);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbuilditems(Lib3MF_Model pModel, Lib3MF_BuildItemIterator * pBuildItemIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBuildItems");
		}
		if (pBuildItemIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBuildItemIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBuildItemIterator = pIModel->GetBuildItems();

		*pBuildItemIterator = (IBase*)(pBaseBuildItemIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BuildItemIterator", *pBuildItemIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getoutbox(Lib3MF_Model pModel, sLib3MFBox * pOutbox)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetOutbox");
		}
		if (pOutbox == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pOutbox = pIModel->GetOutbox();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getresources(Lib3MF_Model pModel, Lib3MF_ResourceIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetResources");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetResources();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getobjects(Lib3MF_Model pModel, Lib3MF_ObjectIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetObjects");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetObjects();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmeshobjects(Lib3MF_Model pModel, Lib3MF_MeshObjectIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMeshObjects");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetMeshObjects();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcomponentsobjects(Lib3MF_Model pModel, Lib3MF_ComponentsObjectIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetComponentsObjects");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetComponentsObjects();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2ds(Lib3MF_Model pModel, Lib3MF_Texture2DIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2Ds");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetTexture2Ds();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getbasematerialgroups(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetBaseMaterialGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetBaseMaterialGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcolorgroups(Lib3MF_Model pModel, Lib3MF_ColorGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetColorGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetColorGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_gettexture2dgroups(Lib3MF_Model pModel, Lib3MF_Texture2DGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetTexture2DGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetTexture2DGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getcompositematerials(Lib3MF_Model pModel, Lib3MF_CompositeMaterialsIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetCompositeMaterials");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetCompositeMaterials();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmultipropertygroups(Lib3MF_Model pModel, Lib3MF_MultiPropertyGroupIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMultiPropertyGroups");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetMultiPropertyGroups();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getslicestacks(Lib3MF_Model pModel, Lib3MF_SliceStackIterator * pResourceIterator)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetSliceStacks");
		}
		if (pResourceIterator == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseResourceIterator(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseResourceIterator = pIModel->GetSliceStacks();

		*pResourceIterator = (IBase*)(pBaseResourceIterator);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ResourceIterator", *pResourceIterator);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_mergetomodel(Lib3MF_Model pModel, Lib3MF_Model * pMergedModelInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "MergeToModel");
		}
		if (pMergedModelInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMergedModelInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMergedModelInstance = pIModel->MergeToModel();

		*pMergedModelInstance = (IBase*)(pBaseMergedModelInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MergedModelInstance", *pMergedModelInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addmeshobject(Lib3MF_Model pModel, Lib3MF_MeshObject * pMeshObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddMeshObject");
		}
		if (pMeshObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMeshObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMeshObjectInstance = pIModel->AddMeshObject();

		*pMeshObjectInstance = (IBase*)(pBaseMeshObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MeshObjectInstance", *pMeshObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcomponentsobject(Lib3MF_Model pModel, Lib3MF_ComponentsObject * pComponentsObjectInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddComponentsObject");
		}
		if (pComponentsObjectInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseComponentsObjectInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseComponentsObjectInstance = pIModel->AddComponentsObject();

		*pComponentsObjectInstance = (IBase*)(pBaseComponentsObjectInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ComponentsObjectInstance", *pComponentsObjectInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addslicestack(Lib3MF_Model pModel, Lib3MF_double dZBottom, Lib3MF_SliceStack * pSliceStackInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddSliceStack");
			pJournalEntry->addDoubleParameter("ZBottom", dZBottom);
		}
		if (pSliceStackInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseSliceStackInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseSliceStackInstance = pIModel->AddSliceStack(dZBottom);

		*pSliceStackInstance = (IBase*)(pBaseSliceStackInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("SliceStackInstance", *pSliceStackInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addtexture2dfromattachment(Lib3MF_Model pModel, Lib3MF_Attachment pTextureAttachment, Lib3MF_Texture2D * pTexture2DInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddTexture2DFromAttachment");
			pJournalEntry->addHandleParameter("TextureAttachment", pTextureAttachment);
		}
		if (pTexture2DInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassTextureAttachment = (IBase *)pTextureAttachment;
		IAttachment* pITextureAttachment = dynamic_cast<IAttachment*>(pIBaseClassTextureAttachment);
		if (!pITextureAttachment)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTexture2DInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DInstance = pIModel->AddTexture2DFromAttachment(pITextureAttachment);

		*pTexture2DInstance = (IBase*)(pBaseTexture2DInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DInstance", *pTexture2DInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addbasematerialgroup(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup * pBaseMaterialGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddBaseMaterialGroup");
		}
		if (pBaseMaterialGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseBaseMaterialGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBaseMaterialGroupInstance = pIModel->AddBaseMaterialGroup();

		*pBaseMaterialGroupInstance = (IBase*)(pBaseBaseMaterialGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BaseMaterialGroupInstance", *pBaseMaterialGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcolorgroup(Lib3MF_Model pModel, Lib3MF_ColorGroup * pColorGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddColorGroup");
		}
		if (pColorGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseColorGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseColorGroupInstance = pIModel->AddColorGroup();

		*pColorGroupInstance = (IBase*)(pBaseColorGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("ColorGroupInstance", *pColorGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addtexture2dgroup(Lib3MF_Model pModel, Lib3MF_Texture2D pTexture2DInstance, Lib3MF_Texture2DGroup * pTexture2DGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddTexture2DGroup");
			pJournalEntry->addHandleParameter("Texture2DInstance", pTexture2DInstance);
		}
		if (pTexture2DGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassTexture2DInstance = (IBase *)pTexture2DInstance;
		ITexture2D* pITexture2DInstance = dynamic_cast<ITexture2D*>(pIBaseClassTexture2DInstance);
		if (!pITexture2DInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseTexture2DGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTexture2DGroupInstance = pIModel->AddTexture2DGroup(pITexture2DInstance);

		*pTexture2DGroupInstance = (IBase*)(pBaseTexture2DGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Texture2DGroupInstance", *pTexture2DGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcompositematerials(Lib3MF_Model pModel, Lib3MF_BaseMaterialGroup pBaseMaterialGroupInstance, Lib3MF_CompositeMaterials * pCompositeMaterialsInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddCompositeMaterials");
			pJournalEntry->addHandleParameter("BaseMaterialGroupInstance", pBaseMaterialGroupInstance);
		}
		if (pCompositeMaterialsInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassBaseMaterialGroupInstance = (IBase *)pBaseMaterialGroupInstance;
		IBaseMaterialGroup* pIBaseMaterialGroupInstance = dynamic_cast<IBaseMaterialGroup*>(pIBaseClassBaseMaterialGroupInstance);
		if (!pIBaseMaterialGroupInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseCompositeMaterialsInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseCompositeMaterialsInstance = pIModel->AddCompositeMaterials(pIBaseMaterialGroupInstance);

		*pCompositeMaterialsInstance = (IBase*)(pBaseCompositeMaterialsInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("CompositeMaterialsInstance", *pCompositeMaterialsInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addmultipropertygroup(Lib3MF_Model pModel, Lib3MF_MultiPropertyGroup * pMultiPropertyGroupInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddMultiPropertyGroup");
		}
		if (pMultiPropertyGroupInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseMultiPropertyGroupInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseMultiPropertyGroupInstance = pIModel->AddMultiPropertyGroup();

		*pMultiPropertyGroupInstance = (IBase*)(pBaseMultiPropertyGroupInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("MultiPropertyGroupInstance", *pMultiPropertyGroupInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addbuilditem(Lib3MF_Model pModel, Lib3MF_Object pObject, const sLib3MFTransform * pTransform, Lib3MF_BuildItem * pBuildItemInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddBuildItem");
			pJournalEntry->addHandleParameter("Object", pObject);
		}
		if (pBuildItemInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassObject = (IBase *)pObject;
		IObject* pIObject = dynamic_cast<IObject*>(pIBaseClassObject);
		if (!pIObject)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IBase* pBaseBuildItemInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseBuildItemInstance = pIModel->AddBuildItem(pIObject, *pTransform);

		*pBuildItemInstance = (IBase*)(pBaseBuildItemInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("BuildItemInstance", *pBuildItemInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removebuilditem(Lib3MF_Model pModel, Lib3MF_BuildItem pBuildItemInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveBuildItem");
			pJournalEntry->addHandleParameter("BuildItemInstance", pBuildItemInstance);
		}
		IBase* pIBaseClassBuildItemInstance = (IBase *)pBuildItemInstance;
		IBuildItem* pIBuildItemInstance = dynamic_cast<IBuildItem*>(pIBaseClassBuildItemInstance);
		if (!pIBuildItemInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveBuildItem(pIBuildItemInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getmetadatagroup(Lib3MF_Model pModel, Lib3MF_MetaDataGroup * pTheMetaDataGroup)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetMetaDataGroup");
		}
		if (pTheMetaDataGroup == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseTheMetaDataGroup(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseTheMetaDataGroup = pIModel->GetMetaDataGroup();

		*pTheMetaDataGroup = (IBase*)(pBaseTheMetaDataGroup);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("TheMetaDataGroup", *pTheMetaDataGroup);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addattachment(Lib3MF_Model pModel, const char * pURI, const char * pRelationShipType, Lib3MF_Attachment * pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddAttachment");
			pJournalEntry->addStringParameter("URI", pURI);
			pJournalEntry->addStringParameter("RelationShipType", pRelationShipType);
		}
		if (pURI == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pRelationShipType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pAttachmentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sURI(pURI);
		std::string sRelationShipType(pRelationShipType);
		IBase* pBaseAttachmentInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachmentInstance = pIModel->AddAttachment(sURI, sRelationShipType);

		*pAttachmentInstance = (IBase*)(pBaseAttachmentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("AttachmentInstance", *pAttachmentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removeattachment(Lib3MF_Model pModel, Lib3MF_Attachment pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveAttachment");
			pJournalEntry->addHandleParameter("AttachmentInstance", pAttachmentInstance);
		}
		IBase* pIBaseClassAttachmentInstance = (IBase *)pAttachmentInstance;
		IAttachment* pIAttachmentInstance = dynamic_cast<IAttachment*>(pIBaseClassAttachmentInstance);
		if (!pIAttachmentInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveAttachment(pIAttachmentInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getattachment(Lib3MF_Model pModel, Lib3MF_uint32 nIndex, Lib3MF_Attachment * pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetAttachment");
			pJournalEntry->addUInt32Parameter("Index", nIndex);
		}
		if (pAttachmentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachmentInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachmentInstance = pIModel->GetAttachment(nIndex);

		*pAttachmentInstance = (IBase*)(pBaseAttachmentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("AttachmentInstance", *pAttachmentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_findattachment(Lib3MF_Model pModel, const char * pURI, Lib3MF_Attachment * pAttachmentInstance)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "FindAttachment");
			pJournalEntry->addStringParameter("URI", pURI);
		}
		if (pURI == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pAttachmentInstance == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sURI(pURI);
		IBase* pBaseAttachmentInstance(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachmentInstance = pIModel->FindAttachment(sURI);

		*pAttachmentInstance = (IBase*)(pBaseAttachmentInstance);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("AttachmentInstance", *pAttachmentInstance);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getattachmentcount(Lib3MF_Model pModel, Lib3MF_uint32 * pAttachmentCount)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetAttachmentCount");
		}
		if (pAttachmentCount == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pAttachmentCount = pIModel->GetAttachmentCount();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("AttachmentCount", *pAttachmentCount);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_haspackagethumbnailattachment(Lib3MF_Model pModel, bool * pHasThumbnail)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "HasPackageThumbnailAttachment");
		}
		if (pHasThumbnail == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		*pHasThumbnail = pIModel->HasPackageThumbnailAttachment();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasThumbnail", *pHasThumbnail);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_createpackagethumbnailattachment(Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "CreatePackageThumbnailAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pIModel->CreatePackageThumbnailAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getpackagethumbnailattachment(Lib3MF_Model pModel, Lib3MF_Attachment * pAttachment)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetPackageThumbnailAttachment");
		}
		if (pAttachment == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseAttachment(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseAttachment = pIModel->GetPackageThumbnailAttachment();

		*pAttachment = (IBase*)(pBaseAttachment);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Attachment", *pAttachment);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removepackagethumbnailattachment(Lib3MF_Model pModel)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemovePackageThumbnailAttachment");
		}
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemovePackageThumbnailAttachment();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_addcustomcontenttype(Lib3MF_Model pModel, const char * pExtension, const char * pContentType)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "AddCustomContentType");
			pJournalEntry->addStringParameter("Extension", pExtension);
			pJournalEntry->addStringParameter("ContentType", pContentType);
		}
		if (pExtension == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pContentType == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sExtension(pExtension);
		std::string sContentType(pContentType);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->AddCustomContentType(sExtension, sContentType);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_removecustomcontenttype(Lib3MF_Model pModel, const char * pExtension)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "RemoveCustomContentType");
			pJournalEntry->addStringParameter("Extension", pExtension);
		}
		if (pExtension == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sExtension(pExtension);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->RemoveCustomContentType(sExtension);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_setrandomnumbercallback(Lib3MF_Model pModel, Lib3MFRandomNumberCallback pTheCallback, Lib3MF_pvoid pUserData)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "SetRandomNumberCallback");
			pJournalEntry->addPointerParameter("UserData", pUserData);
		}
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pIModel->SetRandomNumberCallback(pTheCallback, pUserData);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_model_getkeystore(Lib3MF_Model pModel, Lib3MF_KeyStore * pKeyStore)
{
	IBase* pIBaseClass = (IBase *)pModel;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginClassMethod(pModel, "Model", "GetKeyStore");
		}
		if (pKeyStore == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseKeyStore(nullptr);
		IModel* pIModel = dynamic_cast<IModel*>(pIBaseClass);
		if (!pIModel)
			throw ELib3MFInterfaceException(LIB3MF_ERROR_INVALIDCAST);
		
		pBaseKeyStore = pIModel->GetKeyStore();

		*pKeyStore = (IBase*)(pBaseKeyStore);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("KeyStore", *pKeyStore);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}



/*************************************************************************************************************************
 Function table lookup implementation
**************************************************************************************************************************/

Lib3MFResult _lib3mf_getprocaddress_internal(const char * pProcName, void ** ppProcAddress)
{
	static bool sbProcAddressMapHasBeenInitialized = false;
	static std::map<std::string, void*> sProcAddressMap;
	if (!sbProcAddressMapHasBeenInitialized) {
		sProcAddressMap["lib3mf_writer_writetofile"] = (void*)&lib3mf_writer_writetofile;
		sProcAddressMap["lib3mf_writer_getstreamsize"] = (void*)&lib3mf_writer_getstreamsize;
		sProcAddressMap["lib3mf_writer_writetobuffer"] = (void*)&lib3mf_writer_writetobuffer;
		sProcAddressMap["lib3mf_writer_writetocallback"] = (void*)&lib3mf_writer_writetocallback;
		sProcAddressMap["lib3mf_writer_setprogresscallback"] = (void*)&lib3mf_writer_setprogresscallback;
		sProcAddressMap["lib3mf_writer_getdecimalprecision"] = (void*)&lib3mf_writer_getdecimalprecision;
		sProcAddressMap["lib3mf_writer_setdecimalprecision"] = (void*)&lib3mf_writer_setdecimalprecision;
		sProcAddressMap["lib3mf_writer_setstrictmodeactive"] = (void*)&lib3mf_writer_setstrictmodeactive;
		sProcAddressMap["lib3mf_writer_getstrictmodeactive"] = (void*)&lib3mf_writer_getstrictmodeactive;
		sProcAddressMap["lib3mf_writer_getwarning"] = (void*)&lib3mf_writer_getwarning;
		sProcAddressMap["lib3mf_writer_getwarningcount"] = (void*)&lib3mf_writer_getwarningcount;
		sProcAddressMap["lib3mf_writer_addkeywrappingcallback"] = (void*)&lib3mf_writer_addkeywrappingcallback;
		sProcAddressMap["lib3mf_writer_setcontentencryptioncallback"] = (void*)&lib3mf_writer_setcontentencryptioncallback;
		sProcAddressMap["lib3mf_reader_readfromfile"] = (void*)&lib3mf_reader_readfromfile;
		sProcAddressMap["lib3mf_reader_readfrombuffer"] = (void*)&lib3mf_reader_readfrombuffer;
		sProcAddressMap["lib3mf_reader_readfromcallback"] = (void*)&lib3mf_reader_readfromcallback;
		sProcAddressMap["lib3mf_reader_setprogresscallback"] = (void*)&lib3mf_reader_setprogresscallback;
		sProcAddressMap["lib3mf_reader_addrelationtoread"] = (void*)&lib3mf_reader_addrelationtoread;
		sProcAddressMap["lib3mf_reader_removerelationtoread"] = (void*)&lib3mf_reader_removerelationtoread;
		sProcAddressMap["lib3mf_reader_setstrictmodeactive"] = (void*)&lib3mf_reader_setstrictmodeactive;
		sProcAddressMap["lib3mf_reader_getstrictmodeactive"] = (void*)&lib3mf_reader_getstrictmodeactive;
		sProcAddressMap["lib3mf_reader_getwarning"] = (void*)&lib3mf_reader_getwarning;
		sProcAddressMap["lib3mf_reader_getwarningcount"] = (void*)&lib3mf_reader_getwarningcount;
		sProcAddressMap["lib3mf_reader_addkeywrappingcallback"] = (void*)&lib3mf_reader_addkeywrappingcallback;
		sProcAddressMap["lib3mf_reader_setcontentencryptioncallback"] = (void*)&lib3mf_reader_setcontentencryptioncallback;
		sProcAddressMap["lib3mf_packagepart_getpath"] = (void*)&lib3mf_packagepart_getpath;
		sProcAddressMap["lib3mf_packagepart_setpath"] = (void*)&lib3mf_packagepart_setpath;
		sProcAddressMap["lib3mf_resource_getresourceid"] = (void*)&lib3mf_resource_getresourceid;
		sProcAddressMap["lib3mf_resource_getuniqueresourceid"] = (void*)&lib3mf_resource_getuniqueresourceid;
		sProcAddressMap["lib3mf_resource_packagepart"] = (void*)&lib3mf_resource_packagepart;
		sProcAddressMap["lib3mf_resource_setpackagepart"] = (void*)&lib3mf_resource_setpackagepart;
		sProcAddressMap["lib3mf_resource_getmodelresourceid"] = (void*)&lib3mf_resource_getmodelresourceid;
		sProcAddressMap["lib3mf_resourceiterator_movenext"] = (void*)&lib3mf_resourceiterator_movenext;
		sProcAddressMap["lib3mf_resourceiterator_moveprevious"] = (void*)&lib3mf_resourceiterator_moveprevious;
		sProcAddressMap["lib3mf_resourceiterator_getcurrent"] = (void*)&lib3mf_resourceiterator_getcurrent;
		sProcAddressMap["lib3mf_resourceiterator_clone"] = (void*)&lib3mf_resourceiterator_clone;
		sProcAddressMap["lib3mf_resourceiterator_count"] = (void*)&lib3mf_resourceiterator_count;
		sProcAddressMap["lib3mf_slicestackiterator_getcurrentslicestack"] = (void*)&lib3mf_slicestackiterator_getcurrentslicestack;
		sProcAddressMap["lib3mf_objectiterator_getcurrentobject"] = (void*)&lib3mf_objectiterator_getcurrentobject;
		sProcAddressMap["lib3mf_meshobjectiterator_getcurrentmeshobject"] = (void*)&lib3mf_meshobjectiterator_getcurrentmeshobject;
		sProcAddressMap["lib3mf_componentsobjectiterator_getcurrentcomponentsobject"] = (void*)&lib3mf_componentsobjectiterator_getcurrentcomponentsobject;
		sProcAddressMap["lib3mf_texture2diterator_getcurrenttexture2d"] = (void*)&lib3mf_texture2diterator_getcurrenttexture2d;
		sProcAddressMap["lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup"] = (void*)&lib3mf_basematerialgroupiterator_getcurrentbasematerialgroup;
		sProcAddressMap["lib3mf_colorgroupiterator_getcurrentcolorgroup"] = (void*)&lib3mf_colorgroupiterator_getcurrentcolorgroup;
		sProcAddressMap["lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup"] = (void*)&lib3mf_texture2dgroupiterator_getcurrenttexture2dgroup;
		sProcAddressMap["lib3mf_compositematerialsiterator_getcurrentcompositematerials"] = (void*)&lib3mf_compositematerialsiterator_getcurrentcompositematerials;
		sProcAddressMap["lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup"] = (void*)&lib3mf_multipropertygroupiterator_getcurrentmultipropertygroup;
		sProcAddressMap["lib3mf_metadata_getnamespace"] = (void*)&lib3mf_metadata_getnamespace;
		sProcAddressMap["lib3mf_metadata_setnamespace"] = (void*)&lib3mf_metadata_setnamespace;
		sProcAddressMap["lib3mf_metadata_getname"] = (void*)&lib3mf_metadata_getname;
		sProcAddressMap["lib3mf_metadata_setname"] = (void*)&lib3mf_metadata_setname;
		sProcAddressMap["lib3mf_metadata_getkey"] = (void*)&lib3mf_metadata_getkey;
		sProcAddressMap["lib3mf_metadata_getmustpreserve"] = (void*)&lib3mf_metadata_getmustpreserve;
		sProcAddressMap["lib3mf_metadata_setmustpreserve"] = (void*)&lib3mf_metadata_setmustpreserve;
		sProcAddressMap["lib3mf_metadata_gettype"] = (void*)&lib3mf_metadata_gettype;
		sProcAddressMap["lib3mf_metadata_settype"] = (void*)&lib3mf_metadata_settype;
		sProcAddressMap["lib3mf_metadata_getvalue"] = (void*)&lib3mf_metadata_getvalue;
		sProcAddressMap["lib3mf_metadata_setvalue"] = (void*)&lib3mf_metadata_setvalue;
		sProcAddressMap["lib3mf_metadatagroup_getmetadatacount"] = (void*)&lib3mf_metadatagroup_getmetadatacount;
		sProcAddressMap["lib3mf_metadatagroup_getmetadata"] = (void*)&lib3mf_metadatagroup_getmetadata;
		sProcAddressMap["lib3mf_metadatagroup_getmetadatabykey"] = (void*)&lib3mf_metadatagroup_getmetadatabykey;
		sProcAddressMap["lib3mf_metadatagroup_removemetadatabyindex"] = (void*)&lib3mf_metadatagroup_removemetadatabyindex;
		sProcAddressMap["lib3mf_metadatagroup_removemetadata"] = (void*)&lib3mf_metadatagroup_removemetadata;
		sProcAddressMap["lib3mf_metadatagroup_addmetadata"] = (void*)&lib3mf_metadatagroup_addmetadata;
		sProcAddressMap["lib3mf_object_gettype"] = (void*)&lib3mf_object_gettype;
		sProcAddressMap["lib3mf_object_settype"] = (void*)&lib3mf_object_settype;
		sProcAddressMap["lib3mf_object_getname"] = (void*)&lib3mf_object_getname;
		sProcAddressMap["lib3mf_object_setname"] = (void*)&lib3mf_object_setname;
		sProcAddressMap["lib3mf_object_getpartnumber"] = (void*)&lib3mf_object_getpartnumber;
		sProcAddressMap["lib3mf_object_setpartnumber"] = (void*)&lib3mf_object_setpartnumber;
		sProcAddressMap["lib3mf_object_ismeshobject"] = (void*)&lib3mf_object_ismeshobject;
		sProcAddressMap["lib3mf_object_iscomponentsobject"] = (void*)&lib3mf_object_iscomponentsobject;
		sProcAddressMap["lib3mf_object_isvalid"] = (void*)&lib3mf_object_isvalid;
		sProcAddressMap["lib3mf_object_setattachmentasthumbnail"] = (void*)&lib3mf_object_setattachmentasthumbnail;
		sProcAddressMap["lib3mf_object_getthumbnailattachment"] = (void*)&lib3mf_object_getthumbnailattachment;
		sProcAddressMap["lib3mf_object_clearthumbnailattachment"] = (void*)&lib3mf_object_clearthumbnailattachment;
		sProcAddressMap["lib3mf_object_getoutbox"] = (void*)&lib3mf_object_getoutbox;
		sProcAddressMap["lib3mf_object_getuuid"] = (void*)&lib3mf_object_getuuid;
		sProcAddressMap["lib3mf_object_setuuid"] = (void*)&lib3mf_object_setuuid;
		sProcAddressMap["lib3mf_object_getmetadatagroup"] = (void*)&lib3mf_object_getmetadatagroup;
		sProcAddressMap["lib3mf_object_setslicesmeshresolution"] = (void*)&lib3mf_object_setslicesmeshresolution;
		sProcAddressMap["lib3mf_object_getslicesmeshresolution"] = (void*)&lib3mf_object_getslicesmeshresolution;
		sProcAddressMap["lib3mf_object_hasslices"] = (void*)&lib3mf_object_hasslices;
		sProcAddressMap["lib3mf_object_clearslicestack"] = (void*)&lib3mf_object_clearslicestack;
		sProcAddressMap["lib3mf_object_getslicestack"] = (void*)&lib3mf_object_getslicestack;
		sProcAddressMap["lib3mf_object_assignslicestack"] = (void*)&lib3mf_object_assignslicestack;
		sProcAddressMap["lib3mf_meshobject_getvertexcount"] = (void*)&lib3mf_meshobject_getvertexcount;
		sProcAddressMap["lib3mf_meshobject_gettrianglecount"] = (void*)&lib3mf_meshobject_gettrianglecount;
		sProcAddressMap["lib3mf_meshobject_getvertex"] = (void*)&lib3mf_meshobject_getvertex;
		sProcAddressMap["lib3mf_meshobject_setvertex"] = (void*)&lib3mf_meshobject_setvertex;
		sProcAddressMap["lib3mf_meshobject_addvertex"] = (void*)&lib3mf_meshobject_addvertex;
		sProcAddressMap["lib3mf_meshobject_getvertices"] = (void*)&lib3mf_meshobject_getvertices;
		sProcAddressMap["lib3mf_meshobject_gettriangle"] = (void*)&lib3mf_meshobject_gettriangle;
		sProcAddressMap["lib3mf_meshobject_settriangle"] = (void*)&lib3mf_meshobject_settriangle;
		sProcAddressMap["lib3mf_meshobject_addtriangle"] = (void*)&lib3mf_meshobject_addtriangle;
		sProcAddressMap["lib3mf_meshobject_gettriangleindices"] = (void*)&lib3mf_meshobject_gettriangleindices;
		sProcAddressMap["lib3mf_meshobject_setobjectlevelproperty"] = (void*)&lib3mf_meshobject_setobjectlevelproperty;
		sProcAddressMap["lib3mf_meshobject_getobjectlevelproperty"] = (void*)&lib3mf_meshobject_getobjectlevelproperty;
		sProcAddressMap["lib3mf_meshobject_settriangleproperties"] = (void*)&lib3mf_meshobject_settriangleproperties;
		sProcAddressMap["lib3mf_meshobject_gettriangleproperties"] = (void*)&lib3mf_meshobject_gettriangleproperties;
		sProcAddressMap["lib3mf_meshobject_setalltriangleproperties"] = (void*)&lib3mf_meshobject_setalltriangleproperties;
		sProcAddressMap["lib3mf_meshobject_getalltriangleproperties"] = (void*)&lib3mf_meshobject_getalltriangleproperties;
		sProcAddressMap["lib3mf_meshobject_clearallproperties"] = (void*)&lib3mf_meshobject_clearallproperties;
		sProcAddressMap["lib3mf_meshobject_setgeometry"] = (void*)&lib3mf_meshobject_setgeometry;
		sProcAddressMap["lib3mf_meshobject_ismanifoldandoriented"] = (void*)&lib3mf_meshobject_ismanifoldandoriented;
		sProcAddressMap["lib3mf_meshobject_beamlattice"] = (void*)&lib3mf_meshobject_beamlattice;
		sProcAddressMap["lib3mf_beamlattice_getminlength"] = (void*)&lib3mf_beamlattice_getminlength;
		sProcAddressMap["lib3mf_beamlattice_setminlength"] = (void*)&lib3mf_beamlattice_setminlength;
		sProcAddressMap["lib3mf_beamlattice_getclipping"] = (void*)&lib3mf_beamlattice_getclipping;
		sProcAddressMap["lib3mf_beamlattice_setclipping"] = (void*)&lib3mf_beamlattice_setclipping;
		sProcAddressMap["lib3mf_beamlattice_getrepresentation"] = (void*)&lib3mf_beamlattice_getrepresentation;
		sProcAddressMap["lib3mf_beamlattice_setrepresentation"] = (void*)&lib3mf_beamlattice_setrepresentation;
		sProcAddressMap["lib3mf_beamlattice_getballoptions"] = (void*)&lib3mf_beamlattice_getballoptions;
		sProcAddressMap["lib3mf_beamlattice_setballoptions"] = (void*)&lib3mf_beamlattice_setballoptions;
		sProcAddressMap["lib3mf_beamlattice_getbeamcount"] = (void*)&lib3mf_beamlattice_getbeamcount;
		sProcAddressMap["lib3mf_beamlattice_getbeam"] = (void*)&lib3mf_beamlattice_getbeam;
		sProcAddressMap["lib3mf_beamlattice_addbeam"] = (void*)&lib3mf_beamlattice_addbeam;
		sProcAddressMap["lib3mf_beamlattice_setbeam"] = (void*)&lib3mf_beamlattice_setbeam;
		sProcAddressMap["lib3mf_beamlattice_setbeams"] = (void*)&lib3mf_beamlattice_setbeams;
		sProcAddressMap["lib3mf_beamlattice_getbeams"] = (void*)&lib3mf_beamlattice_getbeams;
		sProcAddressMap["lib3mf_beamlattice_getballcount"] = (void*)&lib3mf_beamlattice_getballcount;
		sProcAddressMap["lib3mf_beamlattice_getball"] = (void*)&lib3mf_beamlattice_getball;
		sProcAddressMap["lib3mf_beamlattice_addball"] = (void*)&lib3mf_beamlattice_addball;
		sProcAddressMap["lib3mf_beamlattice_setball"] = (void*)&lib3mf_beamlattice_setball;
		sProcAddressMap["lib3mf_beamlattice_setballs"] = (void*)&lib3mf_beamlattice_setballs;
		sProcAddressMap["lib3mf_beamlattice_getballs"] = (void*)&lib3mf_beamlattice_getballs;
		sProcAddressMap["lib3mf_beamlattice_getbeamsetcount"] = (void*)&lib3mf_beamlattice_getbeamsetcount;
		sProcAddressMap["lib3mf_beamlattice_addbeamset"] = (void*)&lib3mf_beamlattice_addbeamset;
		sProcAddressMap["lib3mf_beamlattice_getbeamset"] = (void*)&lib3mf_beamlattice_getbeamset;
		sProcAddressMap["lib3mf_component_getobjectresource"] = (void*)&lib3mf_component_getobjectresource;
		sProcAddressMap["lib3mf_component_getobjectresourceid"] = (void*)&lib3mf_component_getobjectresourceid;
		sProcAddressMap["lib3mf_component_getuuid"] = (void*)&lib3mf_component_getuuid;
		sProcAddressMap["lib3mf_component_setuuid"] = (void*)&lib3mf_component_setuuid;
		sProcAddressMap["lib3mf_component_hastransform"] = (void*)&lib3mf_component_hastransform;
		sProcAddressMap["lib3mf_component_gettransform"] = (void*)&lib3mf_component_gettransform;
		sProcAddressMap["lib3mf_component_settransform"] = (void*)&lib3mf_component_settransform;
		sProcAddressMap["lib3mf_componentsobject_addcomponent"] = (void*)&lib3mf_componentsobject_addcomponent;
		sProcAddressMap["lib3mf_componentsobject_getcomponent"] = (void*)&lib3mf_componentsobject_getcomponent;
		sProcAddressMap["lib3mf_componentsobject_getcomponentcount"] = (void*)&lib3mf_componentsobject_getcomponentcount;
		sProcAddressMap["lib3mf_beamset_setname"] = (void*)&lib3mf_beamset_setname;
		sProcAddressMap["lib3mf_beamset_getname"] = (void*)&lib3mf_beamset_getname;
		sProcAddressMap["lib3mf_beamset_setidentifier"] = (void*)&lib3mf_beamset_setidentifier;
		sProcAddressMap["lib3mf_beamset_getidentifier"] = (void*)&lib3mf_beamset_getidentifier;
		sProcAddressMap["lib3mf_beamset_getreferencecount"] = (void*)&lib3mf_beamset_getreferencecount;
		sProcAddressMap["lib3mf_beamset_setreferences"] = (void*)&lib3mf_beamset_setreferences;
		sProcAddressMap["lib3mf_beamset_getreferences"] = (void*)&lib3mf_beamset_getreferences;
		sProcAddressMap["lib3mf_beamset_getballreferencecount"] = (void*)&lib3mf_beamset_getballreferencecount;
		sProcAddressMap["lib3mf_beamset_setballreferences"] = (void*)&lib3mf_beamset_setballreferences;
		sProcAddressMap["lib3mf_beamset_getballreferences"] = (void*)&lib3mf_beamset_getballreferences;
		sProcAddressMap["lib3mf_basematerialgroup_getcount"] = (void*)&lib3mf_basematerialgroup_getcount;
		sProcAddressMap["lib3mf_basematerialgroup_getallpropertyids"] = (void*)&lib3mf_basematerialgroup_getallpropertyids;
		sProcAddressMap["lib3mf_basematerialgroup_addmaterial"] = (void*)&lib3mf_basematerialgroup_addmaterial;
		sProcAddressMap["lib3mf_basematerialgroup_removematerial"] = (void*)&lib3mf_basematerialgroup_removematerial;
		sProcAddressMap["lib3mf_basematerialgroup_getname"] = (void*)&lib3mf_basematerialgroup_getname;
		sProcAddressMap["lib3mf_basematerialgroup_setname"] = (void*)&lib3mf_basematerialgroup_setname;
		sProcAddressMap["lib3mf_basematerialgroup_setdisplaycolor"] = (void*)&lib3mf_basematerialgroup_setdisplaycolor;
		sProcAddressMap["lib3mf_basematerialgroup_getdisplaycolor"] = (void*)&lib3mf_basematerialgroup_getdisplaycolor;
		sProcAddressMap["lib3mf_colorgroup_getcount"] = (void*)&lib3mf_colorgroup_getcount;
		sProcAddressMap["lib3mf_colorgroup_getallpropertyids"] = (void*)&lib3mf_colorgroup_getallpropertyids;
		sProcAddressMap["lib3mf_colorgroup_addcolor"] = (void*)&lib3mf_colorgroup_addcolor;
		sProcAddressMap["lib3mf_colorgroup_removecolor"] = (void*)&lib3mf_colorgroup_removecolor;
		sProcAddressMap["lib3mf_colorgroup_setcolor"] = (void*)&lib3mf_colorgroup_setcolor;
		sProcAddressMap["lib3mf_colorgroup_getcolor"] = (void*)&lib3mf_colorgroup_getcolor;
		sProcAddressMap["lib3mf_texture2dgroup_getcount"] = (void*)&lib3mf_texture2dgroup_getcount;
		sProcAddressMap["lib3mf_texture2dgroup_getallpropertyids"] = (void*)&lib3mf_texture2dgroup_getallpropertyids;
		sProcAddressMap["lib3mf_texture2dgroup_addtex2coord"] = (void*)&lib3mf_texture2dgroup_addtex2coord;
		sProcAddressMap["lib3mf_texture2dgroup_gettex2coord"] = (void*)&lib3mf_texture2dgroup_gettex2coord;
		sProcAddressMap["lib3mf_texture2dgroup_removetex2coord"] = (void*)&lib3mf_texture2dgroup_removetex2coord;
		sProcAddressMap["lib3mf_texture2dgroup_gettexture2d"] = (void*)&lib3mf_texture2dgroup_gettexture2d;
		sProcAddressMap["lib3mf_compositematerials_getcount"] = (void*)&lib3mf_compositematerials_getcount;
		sProcAddressMap["lib3mf_compositematerials_getallpropertyids"] = (void*)&lib3mf_compositematerials_getallpropertyids;
		sProcAddressMap["lib3mf_compositematerials_getbasematerialgroup"] = (void*)&lib3mf_compositematerials_getbasematerialgroup;
		sProcAddressMap["lib3mf_compositematerials_addcomposite"] = (void*)&lib3mf_compositematerials_addcomposite;
		sProcAddressMap["lib3mf_compositematerials_removecomposite"] = (void*)&lib3mf_compositematerials_removecomposite;
		sProcAddressMap["lib3mf_compositematerials_getcomposite"] = (void*)&lib3mf_compositematerials_getcomposite;
		sProcAddressMap["lib3mf_multipropertygroup_getcount"] = (void*)&lib3mf_multipropertygroup_getcount;
		sProcAddressMap["lib3mf_multipropertygroup_getallpropertyids"] = (void*)&lib3mf_multipropertygroup_getallpropertyids;
		sProcAddressMap["lib3mf_multipropertygroup_addmultiproperty"] = (void*)&lib3mf_multipropertygroup_addmultiproperty;
		sProcAddressMap["lib3mf_multipropertygroup_setmultiproperty"] = (void*)&lib3mf_multipropertygroup_setmultiproperty;
		sProcAddressMap["lib3mf_multipropertygroup_getmultiproperty"] = (void*)&lib3mf_multipropertygroup_getmultiproperty;
		sProcAddressMap["lib3mf_multipropertygroup_removemultiproperty"] = (void*)&lib3mf_multipropertygroup_removemultiproperty;
		sProcAddressMap["lib3mf_multipropertygroup_getlayercount"] = (void*)&lib3mf_multipropertygroup_getlayercount;
		sProcAddressMap["lib3mf_multipropertygroup_addlayer"] = (void*)&lib3mf_multipropertygroup_addlayer;
		sProcAddressMap["lib3mf_multipropertygroup_getlayer"] = (void*)&lib3mf_multipropertygroup_getlayer;
		sProcAddressMap["lib3mf_multipropertygroup_removelayer"] = (void*)&lib3mf_multipropertygroup_removelayer;
		sProcAddressMap["lib3mf_attachment_getpath"] = (void*)&lib3mf_attachment_getpath;
		sProcAddressMap["lib3mf_attachment_setpath"] = (void*)&lib3mf_attachment_setpath;
		sProcAddressMap["lib3mf_attachment_packagepart"] = (void*)&lib3mf_attachment_packagepart;
		sProcAddressMap["lib3mf_attachment_getrelationshiptype"] = (void*)&lib3mf_attachment_getrelationshiptype;
		sProcAddressMap["lib3mf_attachment_setrelationshiptype"] = (void*)&lib3mf_attachment_setrelationshiptype;
		sProcAddressMap["lib3mf_attachment_writetofile"] = (void*)&lib3mf_attachment_writetofile;
		sProcAddressMap["lib3mf_attachment_readfromfile"] = (void*)&lib3mf_attachment_readfromfile;
		sProcAddressMap["lib3mf_attachment_readfromcallback"] = (void*)&lib3mf_attachment_readfromcallback;
		sProcAddressMap["lib3mf_attachment_getstreamsize"] = (void*)&lib3mf_attachment_getstreamsize;
		sProcAddressMap["lib3mf_attachment_writetobuffer"] = (void*)&lib3mf_attachment_writetobuffer;
		sProcAddressMap["lib3mf_attachment_readfrombuffer"] = (void*)&lib3mf_attachment_readfrombuffer;
		sProcAddressMap["lib3mf_texture2d_getattachment"] = (void*)&lib3mf_texture2d_getattachment;
		sProcAddressMap["lib3mf_texture2d_setattachment"] = (void*)&lib3mf_texture2d_setattachment;
		sProcAddressMap["lib3mf_texture2d_getcontenttype"] = (void*)&lib3mf_texture2d_getcontenttype;
		sProcAddressMap["lib3mf_texture2d_setcontenttype"] = (void*)&lib3mf_texture2d_setcontenttype;
		sProcAddressMap["lib3mf_texture2d_gettilestyleuv"] = (void*)&lib3mf_texture2d_gettilestyleuv;
		sProcAddressMap["lib3mf_texture2d_settilestyleuv"] = (void*)&lib3mf_texture2d_settilestyleuv;
		sProcAddressMap["lib3mf_texture2d_getfilter"] = (void*)&lib3mf_texture2d_getfilter;
		sProcAddressMap["lib3mf_texture2d_setfilter"] = (void*)&lib3mf_texture2d_setfilter;
		sProcAddressMap["lib3mf_builditem_getobjectresource"] = (void*)&lib3mf_builditem_getobjectresource;
		sProcAddressMap["lib3mf_builditem_getuuid"] = (void*)&lib3mf_builditem_getuuid;
		sProcAddressMap["lib3mf_builditem_setuuid"] = (void*)&lib3mf_builditem_setuuid;
		sProcAddressMap["lib3mf_builditem_getobjectresourceid"] = (void*)&lib3mf_builditem_getobjectresourceid;
		sProcAddressMap["lib3mf_builditem_hasobjecttransform"] = (void*)&lib3mf_builditem_hasobjecttransform;
		sProcAddressMap["lib3mf_builditem_getobjecttransform"] = (void*)&lib3mf_builditem_getobjecttransform;
		sProcAddressMap["lib3mf_builditem_setobjecttransform"] = (void*)&lib3mf_builditem_setobjecttransform;
		sProcAddressMap["lib3mf_builditem_getpartnumber"] = (void*)&lib3mf_builditem_getpartnumber;
		sProcAddressMap["lib3mf_builditem_setpartnumber"] = (void*)&lib3mf_builditem_setpartnumber;
		sProcAddressMap["lib3mf_builditem_getmetadatagroup"] = (void*)&lib3mf_builditem_getmetadatagroup;
		sProcAddressMap["lib3mf_builditem_getoutbox"] = (void*)&lib3mf_builditem_getoutbox;
		sProcAddressMap["lib3mf_builditemiterator_movenext"] = (void*)&lib3mf_builditemiterator_movenext;
		sProcAddressMap["lib3mf_builditemiterator_moveprevious"] = (void*)&lib3mf_builditemiterator_moveprevious;
		sProcAddressMap["lib3mf_builditemiterator_getcurrent"] = (void*)&lib3mf_builditemiterator_getcurrent;
		sProcAddressMap["lib3mf_builditemiterator_clone"] = (void*)&lib3mf_builditemiterator_clone;
		sProcAddressMap["lib3mf_builditemiterator_count"] = (void*)&lib3mf_builditemiterator_count;
		sProcAddressMap["lib3mf_slice_setvertices"] = (void*)&lib3mf_slice_setvertices;
		sProcAddressMap["lib3mf_slice_getvertices"] = (void*)&lib3mf_slice_getvertices;
		sProcAddressMap["lib3mf_slice_getvertexcount"] = (void*)&lib3mf_slice_getvertexcount;
		sProcAddressMap["lib3mf_slice_addpolygon"] = (void*)&lib3mf_slice_addpolygon;
		sProcAddressMap["lib3mf_slice_getpolygoncount"] = (void*)&lib3mf_slice_getpolygoncount;
		sProcAddressMap["lib3mf_slice_setpolygonindices"] = (void*)&lib3mf_slice_setpolygonindices;
		sProcAddressMap["lib3mf_slice_getpolygonindices"] = (void*)&lib3mf_slice_getpolygonindices;
		sProcAddressMap["lib3mf_slice_getpolygonindexcount"] = (void*)&lib3mf_slice_getpolygonindexcount;
		sProcAddressMap["lib3mf_slice_getztop"] = (void*)&lib3mf_slice_getztop;
		sProcAddressMap["lib3mf_slicestack_getbottomz"] = (void*)&lib3mf_slicestack_getbottomz;
		sProcAddressMap["lib3mf_slicestack_getslicecount"] = (void*)&lib3mf_slicestack_getslicecount;
		sProcAddressMap["lib3mf_slicestack_getslice"] = (void*)&lib3mf_slicestack_getslice;
		sProcAddressMap["lib3mf_slicestack_addslice"] = (void*)&lib3mf_slicestack_addslice;
		sProcAddressMap["lib3mf_slicestack_getslicerefcount"] = (void*)&lib3mf_slicestack_getslicerefcount;
		sProcAddressMap["lib3mf_slicestack_addslicestackreference"] = (void*)&lib3mf_slicestack_addslicestackreference;
		sProcAddressMap["lib3mf_slicestack_getslicestackreference"] = (void*)&lib3mf_slicestack_getslicestackreference;
		sProcAddressMap["lib3mf_slicestack_collapseslicereferences"] = (void*)&lib3mf_slicestack_collapseslicereferences;
		sProcAddressMap["lib3mf_slicestack_setownpath"] = (void*)&lib3mf_slicestack_setownpath;
		sProcAddressMap["lib3mf_slicestack_getownpath"] = (void*)&lib3mf_slicestack_getownpath;
		sProcAddressMap["lib3mf_consumer_getconsumerid"] = (void*)&lib3mf_consumer_getconsumerid;
		sProcAddressMap["lib3mf_consumer_getkeyid"] = (void*)&lib3mf_consumer_getkeyid;
		sProcAddressMap["lib3mf_consumer_getkeyvalue"] = (void*)&lib3mf_consumer_getkeyvalue;
		sProcAddressMap["lib3mf_accessright_getconsumer"] = (void*)&lib3mf_accessright_getconsumer;
		sProcAddressMap["lib3mf_accessright_getwrappingalgorithm"] = (void*)&lib3mf_accessright_getwrappingalgorithm;
		sProcAddressMap["lib3mf_accessright_getmgfalgorithm"] = (void*)&lib3mf_accessright_getmgfalgorithm;
		sProcAddressMap["lib3mf_accessright_getdigestmethod"] = (void*)&lib3mf_accessright_getdigestmethod;
		sProcAddressMap["lib3mf_contentencryptionparams_getencryptionalgorithm"] = (void*)&lib3mf_contentencryptionparams_getencryptionalgorithm;
		sProcAddressMap["lib3mf_contentencryptionparams_getkey"] = (void*)&lib3mf_contentencryptionparams_getkey;
		sProcAddressMap["lib3mf_contentencryptionparams_getinitializationvector"] = (void*)&lib3mf_contentencryptionparams_getinitializationvector;
		sProcAddressMap["lib3mf_contentencryptionparams_getauthenticationtag"] = (void*)&lib3mf_contentencryptionparams_getauthenticationtag;
		sProcAddressMap["lib3mf_contentencryptionparams_setauthenticationtag"] = (void*)&lib3mf_contentencryptionparams_setauthenticationtag;
		sProcAddressMap["lib3mf_contentencryptionparams_getadditionalauthenticationdata"] = (void*)&lib3mf_contentencryptionparams_getadditionalauthenticationdata;
		sProcAddressMap["lib3mf_contentencryptionparams_getdescriptor"] = (void*)&lib3mf_contentencryptionparams_getdescriptor;
		sProcAddressMap["lib3mf_contentencryptionparams_getkeyuuid"] = (void*)&lib3mf_contentencryptionparams_getkeyuuid;
		sProcAddressMap["lib3mf_resourcedata_getpath"] = (void*)&lib3mf_resourcedata_getpath;
		sProcAddressMap["lib3mf_resourcedata_getencryptionalgorithm"] = (void*)&lib3mf_resourcedata_getencryptionalgorithm;
		sProcAddressMap["lib3mf_resourcedata_getcompression"] = (void*)&lib3mf_resourcedata_getcompression;
		sProcAddressMap["lib3mf_resourcedata_getadditionalauthenticationdata"] = (void*)&lib3mf_resourcedata_getadditionalauthenticationdata;
		sProcAddressMap["lib3mf_resourcedatagroup_getkeyuuid"] = (void*)&lib3mf_resourcedatagroup_getkeyuuid;
		sProcAddressMap["lib3mf_resourcedatagroup_addaccessright"] = (void*)&lib3mf_resourcedatagroup_addaccessright;
		sProcAddressMap["lib3mf_resourcedatagroup_findaccessrightbyconsumer"] = (void*)&lib3mf_resourcedatagroup_findaccessrightbyconsumer;
		sProcAddressMap["lib3mf_resourcedatagroup_removeaccessright"] = (void*)&lib3mf_resourcedatagroup_removeaccessright;
		sProcAddressMap["lib3mf_keystore_addconsumer"] = (void*)&lib3mf_keystore_addconsumer;
		sProcAddressMap["lib3mf_keystore_getconsumercount"] = (void*)&lib3mf_keystore_getconsumercount;
		sProcAddressMap["lib3mf_keystore_getconsumer"] = (void*)&lib3mf_keystore_getconsumer;
		sProcAddressMap["lib3mf_keystore_removeconsumer"] = (void*)&lib3mf_keystore_removeconsumer;
		sProcAddressMap["lib3mf_keystore_findconsumer"] = (void*)&lib3mf_keystore_findconsumer;
		sProcAddressMap["lib3mf_keystore_getresourcedatagroupcount"] = (void*)&lib3mf_keystore_getresourcedatagroupcount;
		sProcAddressMap["lib3mf_keystore_addresourcedatagroup"] = (void*)&lib3mf_keystore_addresourcedatagroup;
		sProcAddressMap["lib3mf_keystore_getresourcedatagroup"] = (void*)&lib3mf_keystore_getresourcedatagroup;
		sProcAddressMap["lib3mf_keystore_removeresourcedatagroup"] = (void*)&lib3mf_keystore_removeresourcedatagroup;
		sProcAddressMap["lib3mf_keystore_findresourcedatagroup"] = (void*)&lib3mf_keystore_findresourcedatagroup;
		sProcAddressMap["lib3mf_keystore_addresourcedata"] = (void*)&lib3mf_keystore_addresourcedata;
		sProcAddressMap["lib3mf_keystore_removeresourcedata"] = (void*)&lib3mf_keystore_removeresourcedata;
		sProcAddressMap["lib3mf_keystore_findresourcedata"] = (void*)&lib3mf_keystore_findresourcedata;
		sProcAddressMap["lib3mf_keystore_getresourcedatacount"] = (void*)&lib3mf_keystore_getresourcedatacount;
		sProcAddressMap["lib3mf_keystore_getresourcedata"] = (void*)&lib3mf_keystore_getresourcedata;
		sProcAddressMap["lib3mf_keystore_getuuid"] = (void*)&lib3mf_keystore_getuuid;
		sProcAddressMap["lib3mf_keystore_setuuid"] = (void*)&lib3mf_keystore_setuuid;
		sProcAddressMap["lib3mf_model_rootmodelpart"] = (void*)&lib3mf_model_rootmodelpart;
		sProcAddressMap["lib3mf_model_findorcreatepackagepart"] = (void*)&lib3mf_model_findorcreatepackagepart;
		sProcAddressMap["lib3mf_model_setunit"] = (void*)&lib3mf_model_setunit;
		sProcAddressMap["lib3mf_model_getunit"] = (void*)&lib3mf_model_getunit;
		sProcAddressMap["lib3mf_model_getlanguage"] = (void*)&lib3mf_model_getlanguage;
		sProcAddressMap["lib3mf_model_setlanguage"] = (void*)&lib3mf_model_setlanguage;
		sProcAddressMap["lib3mf_model_querywriter"] = (void*)&lib3mf_model_querywriter;
		sProcAddressMap["lib3mf_model_queryreader"] = (void*)&lib3mf_model_queryreader;
		sProcAddressMap["lib3mf_model_gettexture2dbyid"] = (void*)&lib3mf_model_gettexture2dbyid;
		sProcAddressMap["lib3mf_model_getpropertytypebyid"] = (void*)&lib3mf_model_getpropertytypebyid;
		sProcAddressMap["lib3mf_model_getbasematerialgroupbyid"] = (void*)&lib3mf_model_getbasematerialgroupbyid;
		sProcAddressMap["lib3mf_model_gettexture2dgroupbyid"] = (void*)&lib3mf_model_gettexture2dgroupbyid;
		sProcAddressMap["lib3mf_model_getcompositematerialsbyid"] = (void*)&lib3mf_model_getcompositematerialsbyid;
		sProcAddressMap["lib3mf_model_getmultipropertygroupbyid"] = (void*)&lib3mf_model_getmultipropertygroupbyid;
		sProcAddressMap["lib3mf_model_getmeshobjectbyid"] = (void*)&lib3mf_model_getmeshobjectbyid;
		sProcAddressMap["lib3mf_model_getcomponentsobjectbyid"] = (void*)&lib3mf_model_getcomponentsobjectbyid;
		sProcAddressMap["lib3mf_model_getcolorgroupbyid"] = (void*)&lib3mf_model_getcolorgroupbyid;
		sProcAddressMap["lib3mf_model_getslicestackbyid"] = (void*)&lib3mf_model_getslicestackbyid;
		sProcAddressMap["lib3mf_model_getbuilduuid"] = (void*)&lib3mf_model_getbuilduuid;
		sProcAddressMap["lib3mf_model_setbuilduuid"] = (void*)&lib3mf_model_setbuilduuid;
		sProcAddressMap["lib3mf_model_getbuilditems"] = (void*)&lib3mf_model_getbuilditems;
		sProcAddressMap["lib3mf_model_getoutbox"] = (void*)&lib3mf_model_getoutbox;
		sProcAddressMap["lib3mf_model_getresources"] = (void*)&lib3mf_model_getresources;
		sProcAddressMap["lib3mf_model_getobjects"] = (void*)&lib3mf_model_getobjects;
		sProcAddressMap["lib3mf_model_getmeshobjects"] = (void*)&lib3mf_model_getmeshobjects;
		sProcAddressMap["lib3mf_model_getcomponentsobjects"] = (void*)&lib3mf_model_getcomponentsobjects;
		sProcAddressMap["lib3mf_model_gettexture2ds"] = (void*)&lib3mf_model_gettexture2ds;
		sProcAddressMap["lib3mf_model_getbasematerialgroups"] = (void*)&lib3mf_model_getbasematerialgroups;
		sProcAddressMap["lib3mf_model_getcolorgroups"] = (void*)&lib3mf_model_getcolorgroups;
		sProcAddressMap["lib3mf_model_gettexture2dgroups"] = (void*)&lib3mf_model_gettexture2dgroups;
		sProcAddressMap["lib3mf_model_getcompositematerials"] = (void*)&lib3mf_model_getcompositematerials;
		sProcAddressMap["lib3mf_model_getmultipropertygroups"] = (void*)&lib3mf_model_getmultipropertygroups;
		sProcAddressMap["lib3mf_model_getslicestacks"] = (void*)&lib3mf_model_getslicestacks;
		sProcAddressMap["lib3mf_model_mergetomodel"] = (void*)&lib3mf_model_mergetomodel;
		sProcAddressMap["lib3mf_model_addmeshobject"] = (void*)&lib3mf_model_addmeshobject;
		sProcAddressMap["lib3mf_model_addcomponentsobject"] = (void*)&lib3mf_model_addcomponentsobject;
		sProcAddressMap["lib3mf_model_addslicestack"] = (void*)&lib3mf_model_addslicestack;
		sProcAddressMap["lib3mf_model_addtexture2dfromattachment"] = (void*)&lib3mf_model_addtexture2dfromattachment;
		sProcAddressMap["lib3mf_model_addbasematerialgroup"] = (void*)&lib3mf_model_addbasematerialgroup;
		sProcAddressMap["lib3mf_model_addcolorgroup"] = (void*)&lib3mf_model_addcolorgroup;
		sProcAddressMap["lib3mf_model_addtexture2dgroup"] = (void*)&lib3mf_model_addtexture2dgroup;
		sProcAddressMap["lib3mf_model_addcompositematerials"] = (void*)&lib3mf_model_addcompositematerials;
		sProcAddressMap["lib3mf_model_addmultipropertygroup"] = (void*)&lib3mf_model_addmultipropertygroup;
		sProcAddressMap["lib3mf_model_addbuilditem"] = (void*)&lib3mf_model_addbuilditem;
		sProcAddressMap["lib3mf_model_removebuilditem"] = (void*)&lib3mf_model_removebuilditem;
		sProcAddressMap["lib3mf_model_getmetadatagroup"] = (void*)&lib3mf_model_getmetadatagroup;
		sProcAddressMap["lib3mf_model_addattachment"] = (void*)&lib3mf_model_addattachment;
		sProcAddressMap["lib3mf_model_removeattachment"] = (void*)&lib3mf_model_removeattachment;
		sProcAddressMap["lib3mf_model_getattachment"] = (void*)&lib3mf_model_getattachment;
		sProcAddressMap["lib3mf_model_findattachment"] = (void*)&lib3mf_model_findattachment;
		sProcAddressMap["lib3mf_model_getattachmentcount"] = (void*)&lib3mf_model_getattachmentcount;
		sProcAddressMap["lib3mf_model_haspackagethumbnailattachment"] = (void*)&lib3mf_model_haspackagethumbnailattachment;
		sProcAddressMap["lib3mf_model_createpackagethumbnailattachment"] = (void*)&lib3mf_model_createpackagethumbnailattachment;
		sProcAddressMap["lib3mf_model_getpackagethumbnailattachment"] = (void*)&lib3mf_model_getpackagethumbnailattachment;
		sProcAddressMap["lib3mf_model_removepackagethumbnailattachment"] = (void*)&lib3mf_model_removepackagethumbnailattachment;
		sProcAddressMap["lib3mf_model_addcustomcontenttype"] = (void*)&lib3mf_model_addcustomcontenttype;
		sProcAddressMap["lib3mf_model_removecustomcontenttype"] = (void*)&lib3mf_model_removecustomcontenttype;
		sProcAddressMap["lib3mf_model_setrandomnumbercallback"] = (void*)&lib3mf_model_setrandomnumbercallback;
		sProcAddressMap["lib3mf_model_getkeystore"] = (void*)&lib3mf_model_getkeystore;
		sProcAddressMap["lib3mf_getlibraryversion"] = (void*)&lib3mf_getlibraryversion;
		sProcAddressMap["lib3mf_getprereleaseinformation"] = (void*)&lib3mf_getprereleaseinformation;
		sProcAddressMap["lib3mf_getbuildinformation"] = (void*)&lib3mf_getbuildinformation;
		sProcAddressMap["lib3mf_getspecificationversion"] = (void*)&lib3mf_getspecificationversion;
		sProcAddressMap["lib3mf_createmodel"] = (void*)&lib3mf_createmodel;
		sProcAddressMap["lib3mf_release"] = (void*)&lib3mf_release;
		sProcAddressMap["lib3mf_acquire"] = (void*)&lib3mf_acquire;
		sProcAddressMap["lib3mf_setjournal"] = (void*)&lib3mf_setjournal;
		sProcAddressMap["lib3mf_getlasterror"] = (void*)&lib3mf_getlasterror;
		sProcAddressMap["lib3mf_getsymbollookupmethod"] = (void*)&lib3mf_getsymbollookupmethod;
		sProcAddressMap["lib3mf_retrieveprogressmessage"] = (void*)&lib3mf_retrieveprogressmessage;
		sProcAddressMap["lib3mf_rgbatocolor"] = (void*)&lib3mf_rgbatocolor;
		sProcAddressMap["lib3mf_floatrgbatocolor"] = (void*)&lib3mf_floatrgbatocolor;
		sProcAddressMap["lib3mf_colortorgba"] = (void*)&lib3mf_colortorgba;
		sProcAddressMap["lib3mf_colortofloatrgba"] = (void*)&lib3mf_colortofloatrgba;
		sProcAddressMap["lib3mf_getidentitytransform"] = (void*)&lib3mf_getidentitytransform;
		sProcAddressMap["lib3mf_getuniformscaletransform"] = (void*)&lib3mf_getuniformscaletransform;
		sProcAddressMap["lib3mf_getscaletransform"] = (void*)&lib3mf_getscaletransform;
		sProcAddressMap["lib3mf_gettranslationtransform"] = (void*)&lib3mf_gettranslationtransform;
		
		sbProcAddressMapHasBeenInitialized = true;
	}
	if (pProcName == nullptr)
		return LIB3MF_ERROR_INVALIDPARAM;
	if (ppProcAddress == nullptr)
		return LIB3MF_ERROR_INVALIDPARAM;
	*ppProcAddress = nullptr;
	std::string sProcName (pProcName);
	
	auto procPair = sProcAddressMap.find(sProcName);
	if (procPair == sProcAddressMap.end()) {
		return LIB3MF_ERROR_COULDNOTFINDLIBRARYEXPORT;
	}
	else {
		*ppProcAddress = procPair->second;
		return LIB3MF_SUCCESS;
	}
	
}

/*************************************************************************************************************************
 Global functions implementation
**************************************************************************************************************************/
Lib3MFResult lib3mf_getlibraryversion(Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetLibraryVersion");
		}
		if (!pMajor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		CWrapper::GetLibraryVersion(*pMajor, *pMinor, *pMicro);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt32Result("Major", *pMajor);
			pJournalEntry->addUInt32Result("Minor", *pMinor);
			pJournalEntry->addUInt32Result("Micro", *pMicro);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getprereleaseinformation(bool * pHasPrereleaseInfo, const Lib3MF_uint32 nPrereleaseInfoBufferSize, Lib3MF_uint32* pPrereleaseInfoNeededChars, char * pPrereleaseInfoBuffer)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetPrereleaseInformation");
		}
		if (pHasPrereleaseInfo == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pPrereleaseInfoBuffer) && !(pPrereleaseInfoNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sPrereleaseInfo("");
		*pHasPrereleaseInfo = CWrapper::GetPrereleaseInformation(sPrereleaseInfo);

		if (pPrereleaseInfoNeededChars)
			*pPrereleaseInfoNeededChars = (Lib3MF_uint32) (sPrereleaseInfo.size()+1);
		if (pPrereleaseInfoBuffer) {
			if (sPrereleaseInfo.size() >= nPrereleaseInfoBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iPrereleaseInfo = 0; iPrereleaseInfo < sPrereleaseInfo.size(); iPrereleaseInfo++)
				pPrereleaseInfoBuffer[iPrereleaseInfo] = sPrereleaseInfo[iPrereleaseInfo];
			pPrereleaseInfoBuffer[sPrereleaseInfo.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasPrereleaseInfo", *pHasPrereleaseInfo);
			pJournalEntry->addStringResult("PrereleaseInfo", sPrereleaseInfo.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getbuildinformation(bool * pHasBuildInfo, const Lib3MF_uint32 nBuildInformationBufferSize, Lib3MF_uint32* pBuildInformationNeededChars, char * pBuildInformationBuffer)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetBuildInformation");
		}
		if (pHasBuildInfo == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if ( (!pBuildInformationBuffer) && !(pBuildInformationNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sBuildInformation("");
		*pHasBuildInfo = CWrapper::GetBuildInformation(sBuildInformation);

		if (pBuildInformationNeededChars)
			*pBuildInformationNeededChars = (Lib3MF_uint32) (sBuildInformation.size()+1);
		if (pBuildInformationBuffer) {
			if (sBuildInformation.size() >= nBuildInformationBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iBuildInformation = 0; iBuildInformation < sBuildInformation.size(); iBuildInformation++)
				pBuildInformationBuffer[iBuildInformation] = sBuildInformation[iBuildInformation];
			pBuildInformationBuffer[sBuildInformation.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("HasBuildInfo", *pHasBuildInfo);
			pJournalEntry->addStringResult("BuildInformation", sBuildInformation.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getspecificationversion(const char * pSpecificationURL, bool * pIsSupported, Lib3MF_uint32 * pMajor, Lib3MF_uint32 * pMinor, Lib3MF_uint32 * pMicro)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetSpecificationVersion");
			pJournalEntry->addStringParameter("SpecificationURL", pSpecificationURL);
		}
		if (pSpecificationURL == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pIsSupported)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMajor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMinor)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pMicro)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sSpecificationURL(pSpecificationURL);
		CWrapper::GetSpecificationVersion(sSpecificationURL, *pIsSupported, *pMajor, *pMinor, *pMicro);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addBooleanResult("IsSupported", *pIsSupported);
			pJournalEntry->addUInt32Result("Major", *pMajor);
			pJournalEntry->addUInt32Result("Minor", *pMinor);
			pJournalEntry->addUInt32Result("Micro", *pMicro);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_createmodel(Lib3MF_Model * pModel)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("CreateModel");
		}
		if (pModel == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pBaseModel(nullptr);
		pBaseModel = CWrapper::CreateModel();

		*pModel = (IBase*)(pBaseModel);
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addHandleResult("Model", *pModel);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_release(Lib3MF_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("Release");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		CWrapper::Release(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_acquire(Lib3MF_Base pInstance)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("Acquire");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		CWrapper::Acquire(pIInstance);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_setjournal(const char * pJournalPath)
{
	IBase* pIBaseClass = nullptr;

	try {
		if (pJournalPath == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sJournalPath(pJournalPath);
		m_GlobalJournal = nullptr;
		if (sJournalPath != "") {
			m_GlobalJournal = std::make_shared<CLib3MFInterfaceJournal> (sJournalPath);
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception);
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException);
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass);
	}
}

Lib3MFResult lib3mf_getlasterror(Lib3MF_Base pInstance, const Lib3MF_uint32 nLastErrorStringBufferSize, Lib3MF_uint32* pLastErrorStringNeededChars, char * pLastErrorStringBuffer, bool * pHasLastError)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetLastError");
			pJournalEntry->addHandleParameter("Instance", pInstance);
		}
		if ( (!pLastErrorStringBuffer) && !(pLastErrorStringNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (pHasLastError == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		IBase* pIBaseClassInstance = (IBase *)pInstance;
		IBase* pIInstance = dynamic_cast<IBase*>(pIBaseClassInstance);
		if (!pIInstance)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDCAST);
		
		std::string sLastErrorString("");
		*pHasLastError = CWrapper::GetLastError(pIInstance, sLastErrorString);

		if (pLastErrorStringNeededChars)
			*pLastErrorStringNeededChars = (Lib3MF_uint32) (sLastErrorString.size()+1);
		if (pLastErrorStringBuffer) {
			if (sLastErrorString.size() >= nLastErrorStringBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iLastErrorString = 0; iLastErrorString < sLastErrorString.size(); iLastErrorString++)
				pLastErrorStringBuffer[iLastErrorString] = sLastErrorString[iLastErrorString];
			pLastErrorStringBuffer[sLastErrorString.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("LastErrorString", sLastErrorString.c_str());
			pJournalEntry->addBooleanResult("HasLastError", *pHasLastError);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getsymbollookupmethod(Lib3MF_pvoid * pSymbolLookupMethod)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetSymbolLookupMethod");
		}
		if (pSymbolLookupMethod == nullptr)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pSymbolLookupMethod = (void*)&_lib3mf_getprocaddress_internal;
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addPointerResult("SymbolLookupMethod", *pSymbolLookupMethod);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_retrieveprogressmessage(eLib3MFProgressIdentifier eTheProgressIdentifier, const Lib3MF_uint32 nProgressMessageBufferSize, Lib3MF_uint32* pProgressMessageNeededChars, char * pProgressMessageBuffer)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("RetrieveProgressMessage");
			pJournalEntry->addEnumParameter("TheProgressIdentifier", "ProgressIdentifier", (Lib3MF_int32)(eTheProgressIdentifier));
		}
		if ( (!pProgressMessageBuffer) && !(pProgressMessageNeededChars) )
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		std::string sProgressMessage("");
		CWrapper::RetrieveProgressMessage(eTheProgressIdentifier, sProgressMessage);

		if (pProgressMessageNeededChars)
			*pProgressMessageNeededChars = (Lib3MF_uint32) (sProgressMessage.size()+1);
		if (pProgressMessageBuffer) {
			if (sProgressMessage.size() >= nProgressMessageBufferSize)
				throw ELib3MFInterfaceException (LIB3MF_ERROR_BUFFERTOOSMALL);
			for (size_t iProgressMessage = 0; iProgressMessage < sProgressMessage.size(); iProgressMessage++)
				pProgressMessageBuffer[iProgressMessage] = sProgressMessage[iProgressMessage];
			pProgressMessageBuffer[sProgressMessage.size()] = 0;
		}
		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addStringResult("ProgressMessage", sProgressMessage.c_str());
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_rgbatocolor(Lib3MF_uint8 nRed, Lib3MF_uint8 nGreen, Lib3MF_uint8 nBlue, Lib3MF_uint8 nAlpha, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("RGBAToColor");
			pJournalEntry->addUInt8Parameter("Red", nRed);
			pJournalEntry->addUInt8Parameter("Green", nGreen);
			pJournalEntry->addUInt8Parameter("Blue", nBlue);
			pJournalEntry->addUInt8Parameter("Alpha", nAlpha);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTheColor = CWrapper::RGBAToColor(nRed, nGreen, nBlue, nAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_floatrgbatocolor(Lib3MF_single fRed, Lib3MF_single fGreen, Lib3MF_single fBlue, Lib3MF_single fAlpha, sLib3MFColor * pTheColor)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("FloatRGBAToColor");
			pJournalEntry->addSingleParameter("Red", fRed);
			pJournalEntry->addSingleParameter("Green", fGreen);
			pJournalEntry->addSingleParameter("Blue", fBlue);
			pJournalEntry->addSingleParameter("Alpha", fAlpha);
		}
		if (pTheColor == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTheColor = CWrapper::FloatRGBAToColor(fRed, fGreen, fBlue, fAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colortorgba(const sLib3MFColor * pTheColor, Lib3MF_uint8 * pRed, Lib3MF_uint8 * pGreen, Lib3MF_uint8 * pBlue, Lib3MF_uint8 * pAlpha)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("ColorToRGBA");
		}
		if (!pRed)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pGreen)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pBlue)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pAlpha)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		CWrapper::ColorToRGBA(*pTheColor, *pRed, *pGreen, *pBlue, *pAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addUInt8Result("Red", *pRed);
			pJournalEntry->addUInt8Result("Green", *pGreen);
			pJournalEntry->addUInt8Result("Blue", *pBlue);
			pJournalEntry->addUInt8Result("Alpha", *pAlpha);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_colortofloatrgba(const sLib3MFColor * pTheColor, Lib3MF_single * pRed, Lib3MF_single * pGreen, Lib3MF_single * pBlue, Lib3MF_single * pAlpha)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("ColorToFloatRGBA");
		}
		if (!pRed)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pGreen)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pBlue)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		if (!pAlpha)
			throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		CWrapper::ColorToFloatRGBA(*pTheColor, *pRed, *pGreen, *pBlue, *pAlpha);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->addSingleResult("Red", *pRed);
			pJournalEntry->addSingleResult("Green", *pGreen);
			pJournalEntry->addSingleResult("Blue", *pBlue);
			pJournalEntry->addSingleResult("Alpha", *pAlpha);
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getidentitytransform(sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetIdentityTransform");
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetIdentityTransform();

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getuniformscaletransform(Lib3MF_single fFactor, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetUniformScaleTransform");
			pJournalEntry->addSingleParameter("Factor", fFactor);
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetUniformScaleTransform(fFactor);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_getscaletransform(Lib3MF_single fFactorX, Lib3MF_single fFactorY, Lib3MF_single fFactorZ, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetScaleTransform");
			pJournalEntry->addSingleParameter("FactorX", fFactorX);
			pJournalEntry->addSingleParameter("FactorY", fFactorY);
			pJournalEntry->addSingleParameter("FactorZ", fFactorZ);
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetScaleTransform(fFactorX, fFactorY, fFactorZ);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}

Lib3MFResult lib3mf_gettranslationtransform(Lib3MF_single fVectorX, Lib3MF_single fVectorY, Lib3MF_single fVectorZ, sLib3MFTransform * pTransform)
{
	IBase* pIBaseClass = nullptr;

	PLib3MFInterfaceJournalEntry pJournalEntry;
	try {
		if (m_GlobalJournal.get() != nullptr)  {
			pJournalEntry = m_GlobalJournal->beginStaticFunction("GetTranslationTransform");
			pJournalEntry->addSingleParameter("VectorX", fVectorX);
			pJournalEntry->addSingleParameter("VectorY", fVectorY);
			pJournalEntry->addSingleParameter("VectorZ", fVectorZ);
		}
		if (pTransform == nullptr)
		throw ELib3MFInterfaceException (LIB3MF_ERROR_INVALIDPARAM);
		*pTransform = CWrapper::GetTranslationTransform(fVectorX, fVectorY, fVectorZ);

		if (pJournalEntry.get() != nullptr) {
			pJournalEntry->writeSuccess();
		}
		return LIB3MF_SUCCESS;
	}
	catch (ELib3MFInterfaceException & Exception) {
		return handleLib3MFException(pIBaseClass, Exception, pJournalEntry.get());
	}
	catch (std::exception & StdException) {
		return handleStdException(pIBaseClass, StdException, pJournalEntry.get());
	}
	catch (...) {
		return handleUnhandledException(pIBaseClass, pJournalEntry.get());
	}
}


