#!/bin/sh
#
# generate function prototypes `prototype.h'.
#

trap "rm -f prototypes.h.tmp prototypes.h.bak" 0 1 2 3 15

CPROTO_FLAGS=
CPPFLAGS='-DSTDC_HEADERS=1
	-DHAVE_STRDUP=1
	-DHAVE_MEMSET=1
	-DHAVE_MEMMOVE=1
	-DHAVE_STRCASECMP=1
	-DHAVE_BASENAME=1
	-DMULTIBYTE_FILENAME=1
	-Dinterrupt=dummy__
	-DNEED_INCREMENTAL_INDICATOR=1
'
# `interrupt' is the reserved word for cproto.

SOURCES='append.c bitio.c crcio.c dhuf.c extract.c header.c
	huf.c indicator.c larc.c lhadd.c lharc.c lhext.c
	lhlist.c maketbl.c maketree.c patmatch.c
	shuf.c slide.c util.c
	pm2.c pm2tree.c pm2hist.c
'

test -f prototypes.h && mv -f prototypes.h prototypes.h.bak

# below makes cproto regard `RETSIGTYPE' as the variable type.
cat <<END >prototypes.h
typedef void RETSIGTYPE;
END

exec 5>&1 > prototypes.h.tmp

cat <<END
/* This file was generated by cproto. */

END

cproto $CPROTO_FLAGS $CPPFLAGS $SOURCES |
	sed -e '/^int main /d' -e 's/dummy__/interrupt/'

cat <<END

/* util.c */
#if !HAVE_MEMMOVE
void *memmove(void *dst, const void *src, size_t cnt);
#endif
#if !HAVE_STRDUP
char *strdup(const char *buf);
#endif
#if !HAVE_MEMSET
char *memset(char *s, int c, size_t n);
#endif
#if !HAVE_STRCASECMP
int strcasecmp(const char *p1, const char *p2);
#endif
#if defined HAVE_DECL_BASENAME && !HAVE_DECL_BASENAME
char *basename(char *s);
#endif

/* vsnprintf.c */
#if !HAVE_VSNPRINTF
int vsnprintf(char *str, size_t n, const char *fmt, va_list ap);
int snprintf(char *str, size_t n, char const *fmt, ...);
#endif
END

exec 1>&5
if test -f prototypes.h.bak && cmp -s prototypes.h.tmp prototypes.h.bak; then
  mv -f prototypes.h.bak prototypes.h
else
  mv -f prototypes.h.tmp prototypes.h
fi
