/*
 * Copyright (C) 2023 Alexander Borisov
 *
 * Author: Alexander Borisov <borisov@lexbor.com>
 */

#ifndef LEXBOR_UNICODE_IDNA_TEST_RES_H
#define LEXBOR_UNICODE_IDNA_TEST_RES_H

#ifdef __cplusplus
extern "C" {
#endif



static const lxb_unicode_idna_test_t lxb_unicode_idna_test_entries[] = {
    {.source = (const lxb_char_t *) "fass.de", .ascii = (const lxb_char_t *) "fass.de", .status = 0} /* 0 */,
    {.source = (const lxb_char_t *) "faß.de", .ascii = (const lxb_char_t *) "xn--fa-hia.de", .status = 0} /* 1 */,
    {.source = (const lxb_char_t *) "Faß.de", .ascii = (const lxb_char_t *) "xn--fa-hia.de", .status = 0} /* 2 */,
    {.source = (const lxb_char_t *) "xn--fa-hia.de", .ascii = (const lxb_char_t *) "xn--fa-hia.de", .status = 0} /* 3 */,
    {.source = (const lxb_char_t *) "à\u05D0", .ascii = (const lxb_char_t *) "xn--0ca24w", .status = 8} /* 4 */,
    {.source = (const lxb_char_t *) "a\u0300\u05D0", .ascii = (const lxb_char_t *) "xn--0ca24w", .status = 8} /* 5 */,
    {.source = (const lxb_char_t *) "A\u0300\u05D0", .ascii = (const lxb_char_t *) "xn--0ca24w", .status = 8} /* 6 */,
    {.source = (const lxb_char_t *) "À\u05D0", .ascii = (const lxb_char_t *) "xn--0ca24w", .status = 8} /* 7 */,
    {.source = (const lxb_char_t *) "xn--0ca24w", .ascii = (const lxb_char_t *) "xn--0ca24w", .status = 8} /* 8 */,
    {.source = (const lxb_char_t *) "0à.\u05D0", .ascii = (const lxb_char_t *) "xn--0-sfa.xn--4db", .status = 4} /* 9 */,
    {.source = (const lxb_char_t *) "0a\u0300.\u05D0", .ascii = (const lxb_char_t *) "xn--0-sfa.xn--4db", .status = 4} /* 10 */,
    {.source = (const lxb_char_t *) "0A\u0300.\u05D0", .ascii = (const lxb_char_t *) "xn--0-sfa.xn--4db", .status = 4} /* 11 */,
    {.source = (const lxb_char_t *) "0À.\u05D0", .ascii = (const lxb_char_t *) "xn--0-sfa.xn--4db", .status = 4} /* 12 */,
    {.source = (const lxb_char_t *) "xn--0-sfa.xn--4db", .ascii = (const lxb_char_t *) "xn--0-sfa.xn--4db", .status = 4} /* 13 */,
    {.source = (const lxb_char_t *) "à.\u05D0\u0308", .ascii = (const lxb_char_t *) "xn--0ca.xn--ssa73l", .status = 0} /* 14 */,
    {.source = (const lxb_char_t *) "a\u0300.\u05D0\u0308", .ascii = (const lxb_char_t *) "xn--0ca.xn--ssa73l", .status = 0} /* 15 */,
    {.source = (const lxb_char_t *) "A\u0300.\u05D0\u0308", .ascii = (const lxb_char_t *) "xn--0ca.xn--ssa73l", .status = 0} /* 16 */,
    {.source = (const lxb_char_t *) "À.\u05D0\u0308", .ascii = (const lxb_char_t *) "xn--0ca.xn--ssa73l", .status = 0} /* 17 */,
    {.source = (const lxb_char_t *) "xn--0ca.xn--ssa73l", .ascii = (const lxb_char_t *) "xn--0ca.xn--ssa73l", .status = 0} /* 18 */,
    {.source = (const lxb_char_t *) "à.\u05D00\u0660\u05D0", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhcb98c", .status = 4} /* 19 */,
    {.source = (const lxb_char_t *) "a\u0300.\u05D00\u0660\u05D0", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhcb98c", .status = 4} /* 20 */,
    {.source = (const lxb_char_t *) "A\u0300.\u05D00\u0660\u05D0", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhcb98c", .status = 4} /* 21 */,
    {.source = (const lxb_char_t *) "À.\u05D00\u0660\u05D0", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhcb98c", .status = 4} /* 22 */,
    {.source = (const lxb_char_t *) "xn--0ca.xn--0-zhcb98c", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhcb98c", .status = 4} /* 23 */,
    {.source = (const lxb_char_t *) "\u0308.\u05D0", .ascii = (const lxb_char_t *) "xn--ssa.xn--4db", .status = 8} /* 24 */,
    {.source = (const lxb_char_t *) "xn--ssa.xn--4db", .ascii = (const lxb_char_t *) "xn--ssa.xn--4db", .status = 8} /* 25 */,
    {.source = (const lxb_char_t *) "à.\u05D00\u0660", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhc74b", .status = 4} /* 26 */,
    {.source = (const lxb_char_t *) "a\u0300.\u05D00\u0660", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhc74b", .status = 4} /* 27 */,
    {.source = (const lxb_char_t *) "A\u0300.\u05D00\u0660", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhc74b", .status = 4} /* 28 */,
    {.source = (const lxb_char_t *) "À.\u05D00\u0660", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhc74b", .status = 4} /* 29 */,
    {.source = (const lxb_char_t *) "xn--0ca.xn--0-zhc74b", .ascii = (const lxb_char_t *) "xn--0ca.xn--0-zhc74b", .status = 4} /* 30 */,
    {.source = (const lxb_char_t *) "àˇ.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca88g.xn--4db", .status = 4} /* 31 */,
    {.source = (const lxb_char_t *) "a\u0300ˇ.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca88g.xn--4db", .status = 4} /* 32 */,
    {.source = (const lxb_char_t *) "A\u0300ˇ.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca88g.xn--4db", .status = 4} /* 33 */,
    {.source = (const lxb_char_t *) "Àˇ.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca88g.xn--4db", .status = 4} /* 34 */,
    {.source = (const lxb_char_t *) "xn--0ca88g.xn--4db", .ascii = (const lxb_char_t *) "xn--0ca88g.xn--4db", .status = 4} /* 35 */,
    {.source = (const lxb_char_t *) "à\u0308.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca81i.xn--4db", .status = 0} /* 36 */,
    {.source = (const lxb_char_t *) "a\u0300\u0308.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca81i.xn--4db", .status = 0} /* 37 */,
    {.source = (const lxb_char_t *) "A\u0300\u0308.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca81i.xn--4db", .status = 0} /* 38 */,
    {.source = (const lxb_char_t *) "À\u0308.\u05D0", .ascii = (const lxb_char_t *) "xn--0ca81i.xn--4db", .status = 0} /* 39 */,
    {.source = (const lxb_char_t *) "xn--0ca81i.xn--4db", .ascii = (const lxb_char_t *) "xn--0ca81i.xn--4db", .status = 0} /* 40 */,
    {.source = (const lxb_char_t *) "a\u200Cb", .ascii = (const lxb_char_t *) "xn--ab-j1t", .status = 4} /* 41 */,
    {.source = (const lxb_char_t *) "A\u200CB", .ascii = (const lxb_char_t *) "xn--ab-j1t", .status = 4} /* 42 */,
    {.source = (const lxb_char_t *) "A\u200Cb", .ascii = (const lxb_char_t *) "xn--ab-j1t", .status = 4} /* 43 */,
    {.source = (const lxb_char_t *) "ab", .ascii = (const lxb_char_t *) "ab", .status = 0} /* 44 */,
    {.source = (const lxb_char_t *) "xn--ab-j1t", .ascii = (const lxb_char_t *) "xn--ab-j1t", .status = 4} /* 45 */,
    {.source = (const lxb_char_t *) "a\u094D\u200Cb", .ascii = (const lxb_char_t *) "xn--ab-fsf604u", .status = 0} /* 46 */,
    {.source = (const lxb_char_t *) "A\u094D\u200CB", .ascii = (const lxb_char_t *) "xn--ab-fsf604u", .status = 0} /* 47 */,
    {.source = (const lxb_char_t *) "A\u094D\u200Cb", .ascii = (const lxb_char_t *) "xn--ab-fsf604u", .status = 0} /* 48 */,
    {.source = (const lxb_char_t *) "xn--ab-fsf", .ascii = (const lxb_char_t *) "xn--ab-fsf", .status = 0} /* 49 */,
    {.source = (const lxb_char_t *) "a\u094Db", .ascii = (const lxb_char_t *) "xn--ab-fsf", .status = 0} /* 50 */,
    {.source = (const lxb_char_t *) "A\u094DB", .ascii = (const lxb_char_t *) "xn--ab-fsf", .status = 0} /* 51 */,
    {.source = (const lxb_char_t *) "A\u094Db", .ascii = (const lxb_char_t *) "xn--ab-fsf", .status = 0} /* 52 */,
    {.source = (const lxb_char_t *) "xn--ab-fsf604u", .ascii = (const lxb_char_t *) "xn--ab-fsf604u", .status = 0} /* 53 */,
    {.source = (const lxb_char_t *) "\u0308\u200C\u0308\u0628b", .ascii = (const lxb_char_t *) "xn--b-bcba413a2w8b", .status = 12} /* 54 */,
    {.source = (const lxb_char_t *) "\u0308\u200C\u0308\u0628B", .ascii = (const lxb_char_t *) "xn--b-bcba413a2w8b", .status = 12} /* 55 */,
    {.source = (const lxb_char_t *) "xn--b-bcba413a", .ascii = (const lxb_char_t *) "xn--b-bcba413a", .status = 8} /* 56 */,
    {.source = (const lxb_char_t *) "xn--b-bcba413a2w8b", .ascii = (const lxb_char_t *) "xn--b-bcba413a2w8b", .status = 12} /* 57 */,
    {.source = (const lxb_char_t *) "a\u0628\u0308\u200C\u0308", .ascii = (const lxb_char_t *) "xn--a-ccba213a5w8b", .status = 12} /* 58 */,
    {.source = (const lxb_char_t *) "A\u0628\u0308\u200C\u0308", .ascii = (const lxb_char_t *) "xn--a-ccba213a5w8b", .status = 12} /* 59 */,
    {.source = (const lxb_char_t *) "xn--a-ccba213a", .ascii = (const lxb_char_t *) "xn--a-ccba213a", .status = 8} /* 60 */,
    {.source = (const lxb_char_t *) "xn--a-ccba213a5w8b", .ascii = (const lxb_char_t *) "xn--a-ccba213a5w8b", .status = 12} /* 61 */,
    {.source = (const lxb_char_t *) "a\u0628\u0308\u200C\u0308\u0628b", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca8057b", .status = 4} /* 62 */,
    {.source = (const lxb_char_t *) "A\u0628\u0308\u200C\u0308\u0628B", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca8057b", .status = 4} /* 63 */,
    {.source = (const lxb_char_t *) "A\u0628\u0308\u200C\u0308\u0628b", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca8057b", .status = 4} /* 64 */,
    {.source = (const lxb_char_t *) "xn--ab-uuba211bca", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca", .status = 4} /* 65 */,
    {.source = (const lxb_char_t *) "xn--ab-uuba211bca8057b", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca8057b", .status = 4} /* 66 */,
    {.source = (const lxb_char_t *) "a\u200Db", .ascii = (const lxb_char_t *) "xn--ab-m1t", .status = 4} /* 67 */,
    {.source = (const lxb_char_t *) "A\u200DB", .ascii = (const lxb_char_t *) "xn--ab-m1t", .status = 4} /* 68 */,
    {.source = (const lxb_char_t *) "A\u200Db", .ascii = (const lxb_char_t *) "xn--ab-m1t", .status = 4} /* 69 */,
    {.source = (const lxb_char_t *) "xn--ab-m1t", .ascii = (const lxb_char_t *) "xn--ab-m1t", .status = 4} /* 70 */,
    {.source = (const lxb_char_t *) "a\u094D\u200Db", .ascii = (const lxb_char_t *) "xn--ab-fsf014u", .status = 0} /* 71 */,
    {.source = (const lxb_char_t *) "A\u094D\u200DB", .ascii = (const lxb_char_t *) "xn--ab-fsf014u", .status = 0} /* 72 */,
    {.source = (const lxb_char_t *) "A\u094D\u200Db", .ascii = (const lxb_char_t *) "xn--ab-fsf014u", .status = 0} /* 73 */,
    {.source = (const lxb_char_t *) "xn--ab-fsf014u", .ascii = (const lxb_char_t *) "xn--ab-fsf014u", .status = 0} /* 74 */,
    {.source = (const lxb_char_t *) "\u0308\u200D\u0308\u0628b", .ascii = (const lxb_char_t *) "xn--b-bcba413a7w8b", .status = 12} /* 75 */,
    {.source = (const lxb_char_t *) "\u0308\u200D\u0308\u0628B", .ascii = (const lxb_char_t *) "xn--b-bcba413a7w8b", .status = 12} /* 76 */,
    {.source = (const lxb_char_t *) "xn--b-bcba413a7w8b", .ascii = (const lxb_char_t *) "xn--b-bcba413a7w8b", .status = 12} /* 77 */,
    {.source = (const lxb_char_t *) "a\u0628\u0308\u200D\u0308", .ascii = (const lxb_char_t *) "xn--a-ccba213abx8b", .status = 12} /* 78 */,
    {.source = (const lxb_char_t *) "A\u0628\u0308\u200D\u0308", .ascii = (const lxb_char_t *) "xn--a-ccba213abx8b", .status = 12} /* 79 */,
    {.source = (const lxb_char_t *) "xn--a-ccba213abx8b", .ascii = (const lxb_char_t *) "xn--a-ccba213abx8b", .status = 12} /* 80 */,
    {.source = (const lxb_char_t *) "a\u0628\u0308\u200D\u0308\u0628b", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca5157b", .status = 8} /* 81 */,
    {.source = (const lxb_char_t *) "A\u0628\u0308\u200D\u0308\u0628B", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca5157b", .status = 8} /* 82 */,
    {.source = (const lxb_char_t *) "A\u0628\u0308\u200D\u0308\u0628b", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca5157b", .status = 8} /* 83 */,
    {.source = (const lxb_char_t *) "xn--ab-uuba211bca5157b", .ascii = (const lxb_char_t *) "xn--ab-uuba211bca5157b", .status = 8} /* 84 */,
    {.source = (const lxb_char_t *) "¡", .ascii = (const lxb_char_t *) "xn--7a", .status = 0} /* 85 */,
    {.source = (const lxb_char_t *) "xn--7a", .ascii = (const lxb_char_t *) "xn--7a", .status = 0} /* 86 */,
    {.source = (const lxb_char_t *) "᧚", .ascii = (const lxb_char_t *) "xn--pkf", .status = 0} /* 87 */,
    {.source = (const lxb_char_t *) "xn--pkf", .ascii = (const lxb_char_t *) "xn--pkf", .status = 0} /* 88 */,
    {.source = (const lxb_char_t *) "。", .ascii = (const lxb_char_t *) ".", .status = 6} /* 89 */,
    {.source = (const lxb_char_t *) ".", .ascii = (const lxb_char_t *) ".", .status = 6} /* 90 */,
    {.source = (const lxb_char_t *) "ꭠ", .ascii = (const lxb_char_t *) "xn--3y9a", .status = 0} /* 91 */,
    {.source = (const lxb_char_t *) "xn--3y9a", .ascii = (const lxb_char_t *) "xn--3y9a", .status = 0} /* 92 */,
    {.source = (const lxb_char_t *) "1234567890ä1234567890123456789012345678901234567890123456", .ascii = (const lxb_char_t *) "xn--12345678901234567890123456789012345678901234567890123456-fxe", .status = 6} /* 93 */,
    {.source = (const lxb_char_t *) "1234567890a\u03081234567890123456789012345678901234567890123456", .ascii = (const lxb_char_t *) "xn--12345678901234567890123456789012345678901234567890123456-fxe", .status = 6} /* 94 */,
    {.source = (const lxb_char_t *) "1234567890A\u03081234567890123456789012345678901234567890123456", .ascii = (const lxb_char_t *) "xn--12345678901234567890123456789012345678901234567890123456-fxe", .status = 6} /* 95 */,
    {.source = (const lxb_char_t *) "1234567890Ä1234567890123456789012345678901234567890123456", .ascii = (const lxb_char_t *) "xn--12345678901234567890123456789012345678901234567890123456-fxe", .status = 6} /* 96 */,
    {.source = (const lxb_char_t *) "xn--12345678901234567890123456789012345678901234567890123456-fxe", .ascii = (const lxb_char_t *) "xn--12345678901234567890123456789012345678901234567890123456-fxe", .status = 6} /* 97 */,
    {.source = (const lxb_char_t *) "www.eXample.cOm", .ascii = (const lxb_char_t *) "www.example.com", .status = 0} /* 98 */,
    {.source = (const lxb_char_t *) "Bücher.de", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 99 */,
    {.source = (const lxb_char_t *) "Bu\u0308cher.de", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 100 */,
    {.source = (const lxb_char_t *) "bu\u0308cher.de", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 101 */,
    {.source = (const lxb_char_t *) "bücher.de", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 102 */,
    {.source = (const lxb_char_t *) "BÜCHER.DE", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 103 */,
    {.source = (const lxb_char_t *) "BU\u0308CHER.DE", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 104 */,
    {.source = (const lxb_char_t *) "xn--bcher-kva.de", .ascii = (const lxb_char_t *) "xn--bcher-kva.de", .status = 0} /* 105 */,
    {.source = (const lxb_char_t *) "ÖBB", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 106 */,
    {.source = (const lxb_char_t *) "O\u0308BB", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 107 */,
    {.source = (const lxb_char_t *) "o\u0308bb", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 108 */,
    {.source = (const lxb_char_t *) "öbb", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 109 */,
    {.source = (const lxb_char_t *) "Öbb", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 110 */,
    {.source = (const lxb_char_t *) "O\u0308bb", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 111 */,
    {.source = (const lxb_char_t *) "xn--bb-eka", .ascii = (const lxb_char_t *) "xn--bb-eka", .status = 0} /* 112 */,
    {.source = (const lxb_char_t *) "βόλος.com", .ascii = (const lxb_char_t *) "xn--nxasmm1c.com", .status = 0} /* 113 */,
    {.source = (const lxb_char_t *) "βο\u0301λος.com", .ascii = (const lxb_char_t *) "xn--nxasmm1c.com", .status = 0} /* 114 */,
    {.source = (const lxb_char_t *) "ΒΟ\u0301ΛΟΣ.COM", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 115 */,
    {.source = (const lxb_char_t *) "ΒΌΛΟΣ.COM", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 116 */,
    {.source = (const lxb_char_t *) "βόλοσ.com", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 117 */,
    {.source = (const lxb_char_t *) "βο\u0301λοσ.com", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 118 */,
    {.source = (const lxb_char_t *) "Βο\u0301λοσ.com", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 119 */,
    {.source = (const lxb_char_t *) "Βόλοσ.com", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 120 */,
    {.source = (const lxb_char_t *) "xn--nxasmq6b.com", .ascii = (const lxb_char_t *) "xn--nxasmq6b.com", .status = 0} /* 121 */,
    {.source = (const lxb_char_t *) "Βο\u0301λος.com", .ascii = (const lxb_char_t *) "xn--nxasmm1c.com", .status = 0} /* 122 */,
    {.source = (const lxb_char_t *) "Βόλος.com", .ascii = (const lxb_char_t *) "xn--nxasmm1c.com", .status = 0} /* 123 */,
    {.source = (const lxb_char_t *) "xn--nxasmm1c.com", .ascii = (const lxb_char_t *) "xn--nxasmm1c.com", .status = 0} /* 124 */,
    {.source = (const lxb_char_t *) "xn--nxasmm1c", .ascii = (const lxb_char_t *) "xn--nxasmm1c", .status = 0} /* 125 */,
    {.source = (const lxb_char_t *) "βόλος", .ascii = (const lxb_char_t *) "xn--nxasmm1c", .status = 0} /* 126 */,
    {.source = (const lxb_char_t *) "βο\u0301λος", .ascii = (const lxb_char_t *) "xn--nxasmm1c", .status = 0} /* 127 */,
    {.source = (const lxb_char_t *) "ΒΟ\u0301ΛΟΣ", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 128 */,
    {.source = (const lxb_char_t *) "ΒΌΛΟΣ", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 129 */,
    {.source = (const lxb_char_t *) "βόλοσ", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 130 */,
    {.source = (const lxb_char_t *) "βο\u0301λοσ", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 131 */,
    {.source = (const lxb_char_t *) "Βο\u0301λοσ", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 132 */,
    {.source = (const lxb_char_t *) "Βόλοσ", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 133 */,
    {.source = (const lxb_char_t *) "xn--nxasmq6b", .ascii = (const lxb_char_t *) "xn--nxasmq6b", .status = 0} /* 134 */,
    {.source = (const lxb_char_t *) "Βόλος", .ascii = (const lxb_char_t *) "xn--nxasmm1c", .status = 0} /* 135 */,
    {.source = (const lxb_char_t *) "Βο\u0301λος", .ascii = (const lxb_char_t *) "xn--nxasmm1c", .status = 0} /* 136 */,
    {.source = (const lxb_char_t *) "www.ශ\u0DCA\u200Dර\u0DD3.com", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b660p.com", .status = 0} /* 137 */,
    {.source = (const lxb_char_t *) "WWW.ශ\u0DCA\u200Dර\u0DD3.COM", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b660p.com", .status = 0} /* 138 */,
    {.source = (const lxb_char_t *) "Www.ශ\u0DCA\u200Dර\u0DD3.com", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b660p.com", .status = 0} /* 139 */,
    {.source = (const lxb_char_t *) "www.xn--10cl1a0b.com", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b.com", .status = 0} /* 140 */,
    {.source = (const lxb_char_t *) "www.ශ\u0DCAර\u0DD3.com", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b.com", .status = 0} /* 141 */,
    {.source = (const lxb_char_t *) "WWW.ශ\u0DCAර\u0DD3.COM", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b.com", .status = 0} /* 142 */,
    {.source = (const lxb_char_t *) "Www.ශ\u0DCAර\u0DD3.com", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b.com", .status = 0} /* 143 */,
    {.source = (const lxb_char_t *) "www.xn--10cl1a0b660p.com", .ascii = (const lxb_char_t *) "www.xn--10cl1a0b660p.com", .status = 0} /* 144 */,
    {.source = (const lxb_char_t *) "\u0646\u0627\u0645\u0647\u200C\u0627\u06CC", .ascii = (const lxb_char_t *) "xn--mgba3gch31f060k", .status = 0} /* 145 */,
    {.source = (const lxb_char_t *) "xn--mgba3gch31f", .ascii = (const lxb_char_t *) "xn--mgba3gch31f", .status = 0} /* 146 */,
    {.source = (const lxb_char_t *) "\u0646\u0627\u0645\u0647\u0627\u06CC", .ascii = (const lxb_char_t *) "xn--mgba3gch31f", .status = 0} /* 147 */,
    {.source = (const lxb_char_t *) "xn--mgba3gch31f060k", .ascii = (const lxb_char_t *) "xn--mgba3gch31f060k", .status = 0} /* 148 */,
    {.source = (const lxb_char_t *) "xn--mgba3gch31f060k.com", .ascii = (const lxb_char_t *) "xn--mgba3gch31f060k.com", .status = 0} /* 149 */,
    {.source = (const lxb_char_t *) "\u0646\u0627\u0645\u0647\u200C\u0627\u06CC.com", .ascii = (const lxb_char_t *) "xn--mgba3gch31f060k.com", .status = 0} /* 150 */,
    {.source = (const lxb_char_t *) "\u0646\u0627\u0645\u0647\u200C\u0627\u06CC.COM", .ascii = (const lxb_char_t *) "xn--mgba3gch31f060k.com", .status = 0} /* 151 */,
    {.source = (const lxb_char_t *) "xn--mgba3gch31f.com", .ascii = (const lxb_char_t *) "xn--mgba3gch31f.com", .status = 0} /* 152 */,
    {.source = (const lxb_char_t *) "\u0646\u0627\u0645\u0647\u0627\u06CC.com", .ascii = (const lxb_char_t *) "xn--mgba3gch31f.com", .status = 0} /* 153 */,
    {.source = (const lxb_char_t *) "\u0646\u0627\u0645\u0647\u0627\u06CC.COM", .ascii = (const lxb_char_t *) "xn--mgba3gch31f.com", .status = 0} /* 154 */,
    {.source = (const lxb_char_t *) "a.b．c。d｡", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 155 */,
    {.source = (const lxb_char_t *) "a.b.c。d。", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 156 */,
    {.source = (const lxb_char_t *) "A.B.C。D。", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 157 */,
    {.source = (const lxb_char_t *) "A.b.c。D。", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 158 */,
    {.source = (const lxb_char_t *) "a.b.c.d.", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 159 */,
    {.source = (const lxb_char_t *) "A.B．C。D｡", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 160 */,
    {.source = (const lxb_char_t *) "A.b．c。D｡", .ascii = (const lxb_char_t *) "a.b.c.d.", .status = 0} /* 161 */,
    {.source = (const lxb_char_t *) "U\u0308.xn--tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 162 */,
    {.source = (const lxb_char_t *) "Ü.xn--tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 163 */,
    {.source = (const lxb_char_t *) "ü.xn--tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 164 */,
    {.source = (const lxb_char_t *) "u\u0308.xn--tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 165 */,
    {.source = (const lxb_char_t *) "U\u0308.XN--TDA", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 166 */,
    {.source = (const lxb_char_t *) "Ü.XN--TDA", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 167 */,
    {.source = (const lxb_char_t *) "Ü.xn--Tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 168 */,
    {.source = (const lxb_char_t *) "U\u0308.xn--Tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 169 */,
    {.source = (const lxb_char_t *) "xn--tda.xn--tda", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 170 */,
    {.source = (const lxb_char_t *) "ü.ü", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 171 */,
    {.source = (const lxb_char_t *) "u\u0308.u\u0308", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 172 */,
    {.source = (const lxb_char_t *) "U\u0308.U\u0308", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 173 */,
    {.source = (const lxb_char_t *) "Ü.Ü", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 174 */,
    {.source = (const lxb_char_t *) "Ü.ü", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 175 */,
    {.source = (const lxb_char_t *) "U\u0308.u\u0308", .ascii = (const lxb_char_t *) "xn--tda.xn--tda", .status = 0} /* 176 */,
    {.source = (const lxb_char_t *) "xn--u-ccb", .ascii = (const lxb_char_t *) "xn--u-ccb", .status = 4} /* 177 */,
    {.source = (const lxb_char_t *) "a⒈com", .ascii = (const lxb_char_t *) "xn--acom-0w1b", .status = 4} /* 178 */,
    {.source = (const lxb_char_t *) "a1.com", .ascii = (const lxb_char_t *) "a1.com", .status = 0} /* 179 */,
    {.source = (const lxb_char_t *) "A⒈COM", .ascii = (const lxb_char_t *) "xn--acom-0w1b", .status = 4} /* 180 */,
    {.source = (const lxb_char_t *) "A⒈Com", .ascii = (const lxb_char_t *) "xn--acom-0w1b", .status = 4} /* 181 */,
    {.source = (const lxb_char_t *) "xn--acom-0w1b", .ascii = (const lxb_char_t *) "xn--acom-0w1b", .status = 4} /* 182 */,
    {.source = (const lxb_char_t *) "xn--a-ecp.ru", .ascii = (const lxb_char_t *) "xn--a-ecp.ru", .status = 4} /* 183 */,
    {.source = (const lxb_char_t *) "xn--0.pt", .ascii = (const lxb_char_t *) "xn--0.pt", .status = 4} /* 184 */,
    {.source = (const lxb_char_t *) "xn--a.pt", .ascii = (const lxb_char_t *) "xn--a.pt", .status = 4} /* 185 */,
    {.source = (const lxb_char_t *) "xn--a-Ä.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 186 */,
    {.source = (const lxb_char_t *) "xn--a-A\u0308.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 187 */,
    {.source = (const lxb_char_t *) "xn--a-a\u0308.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 188 */,
    {.source = (const lxb_char_t *) "xn--a-ä.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 189 */,
    {.source = (const lxb_char_t *) "XN--A-Ä.PT", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 190 */,
    {.source = (const lxb_char_t *) "XN--A-A\u0308.PT", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 191 */,
    {.source = (const lxb_char_t *) "Xn--A-A\u0308.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 192 */,
    {.source = (const lxb_char_t *) "Xn--A-Ä.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 193 */,
    {.source = (const lxb_char_t *) "xn--xn--a--gua.pt", .ascii = (const lxb_char_t *) "xn--xn--a--gua.pt", .status = 4} /* 194 */,
    {.source = (const lxb_char_t *) "日本語。ＪＰ", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 195 */,
    {.source = (const lxb_char_t *) "日本語。JP", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 196 */,
    {.source = (const lxb_char_t *) "日本語。jp", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 197 */,
    {.source = (const lxb_char_t *) "日本語。Jp", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 198 */,
    {.source = (const lxb_char_t *) "xn--wgv71a119e.jp", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 199 */,
    {.source = (const lxb_char_t *) "日本語.jp", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 200 */,
    {.source = (const lxb_char_t *) "日本語.JP", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 201 */,
    {.source = (const lxb_char_t *) "日本語.Jp", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 202 */,
    {.source = (const lxb_char_t *) "日本語。ｊｐ", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 203 */,
    {.source = (const lxb_char_t *) "日本語。Ｊｐ", .ascii = (const lxb_char_t *) "xn--wgv71a119e.jp", .status = 0} /* 204 */,
    {.source = (const lxb_char_t *) "☕", .ascii = (const lxb_char_t *) "xn--53h", .status = 0} /* 205 */,
    {.source = (const lxb_char_t *) "xn--53h", .ascii = (const lxb_char_t *) "xn--53h", .status = 0} /* 206 */,
    {.source = (const lxb_char_t *) "1.aß\u200C\u200Db\u200C\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\u0302ßz", .ascii = (const lxb_char_t *) "1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc", .status = 14} /* 207 */,
    {.source = (const lxb_char_t *) "1.ASS\u200C\u200DB\u200C\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\u0302SSZ", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 208 */,
    {.source = (const lxb_char_t *) "1.ASS\u200C\u200DB\u200C\u200DCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 209 */,
    {.source = (const lxb_char_t *) "1.ass\u200C\u200Db\u200C\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 210 */,
    {.source = (const lxb_char_t *) "1.ass\u200C\u200Db\u200C\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\u0302ssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 211 */,
    {.source = (const lxb_char_t *) "1.Ass\u200C\u200Db\u200C\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\u0302ssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 212 */,
    {.source = (const lxb_char_t *) "1.Ass\u200C\u200Db\u200C\u200Dcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 213 */,
    {.source = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 214 */,
    {.source = (const lxb_char_t *) "1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 215 */,
    {.source = (const lxb_char_t *) "1.assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\u0302ssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 216 */,
    {.source = (const lxb_char_t *) "1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSS\u0302SSZ", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 217 */,
    {.source = (const lxb_char_t *) "1.ASSBCSSSSSSSSDΣΣSSSSSSSSSSSSSSSSESSSSSSSSSSSSSSSSSSSSXSSSSSSSSSSSSSSSSSSSSYSSSSSSSSSSSSSSSŜSSZ", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 218 */,
    {.source = (const lxb_char_t *) "1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssŝssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 219 */,
    {.source = (const lxb_char_t *) "1.Assbcssssssssdσσssssssssssssssssessssssssssssssssssssxssssssssssssssssssssyssssssssssssssss\u0302ssz", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa", .status = 6} /* 220 */,
    {.source = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .ascii = (const lxb_char_t *) "1.xn--assbcssssssssdssssssssssssssssessssssssssssssssssssxssssssssssssssssssssysssssssssssssssssz-pxq1419aa69989dba9gc", .status = 14} /* 221 */,
    {.source = (const lxb_char_t *) "1.Aß\u200C\u200Db\u200C\u200Dcßßßßdςσßßßßßßßßeßßßßßßßßßßxßßßßßßßßßßyßßßßßßßß\u0302ßz", .ascii = (const lxb_char_t *) "1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc", .status = 14} /* 222 */,
    {.source = (const lxb_char_t *) "1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc", .ascii = (const lxb_char_t *) "1.xn--abcdexyz-qyacaaabaaaaaaabaaaaaaaaabaaaaaaaaabaaaaaaaa010ze2isb1140zba8cc", .status = 14} /* 223 */,
    {.source = (const lxb_char_t *) "\u200Cx\u200Dn\u200C-\u200D-bß", .ascii = (const lxb_char_t *) "xn--xn--b-pqa5796ccahd", .status = 8} /* 224 */,
    {.source = (const lxb_char_t *) "\u200CX\u200DN\u200C-\u200D-BSS", .ascii = (const lxb_char_t *) "xn--xn--bss-7z6ccid", .status = 8} /* 225 */,
    {.source = (const lxb_char_t *) "\u200Cx\u200Dn\u200C-\u200D-bss", .ascii = (const lxb_char_t *) "xn--xn--bss-7z6ccid", .status = 8} /* 226 */,
    {.source = (const lxb_char_t *) "\u200CX\u200Dn\u200C-\u200D-Bss", .ascii = (const lxb_char_t *) "xn--xn--bss-7z6ccid", .status = 8} /* 227 */,
    {.source = (const lxb_char_t *) "xn--bss", .ascii = (const lxb_char_t *) "xn--bss", .status = 0} /* 228 */,
    {.source = (const lxb_char_t *) "夙", .ascii = (const lxb_char_t *) "xn--bss", .status = 0} /* 229 */,
    {.source = (const lxb_char_t *) "xn--xn--bss-7z6ccid", .ascii = (const lxb_char_t *) "xn--xn--bss-7z6ccid", .status = 8} /* 230 */,
    {.source = (const lxb_char_t *) "\u200CX\u200Dn\u200C-\u200D-Bß", .ascii = (const lxb_char_t *) "xn--xn--b-pqa5796ccahd", .status = 8} /* 231 */,
    {.source = (const lxb_char_t *) "xn--xn--b-pqa5796ccahd", .ascii = (const lxb_char_t *) "xn--xn--b-pqa5796ccahd", .status = 8} /* 232 */,
    {.source = (const lxb_char_t *) "ˣ\u034Fℕ\u200B﹣\u00AD－\u180Cℬ\uFE00ſ\u2064𝔰󠇯ﬄ", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 233 */,
    {.source = (const lxb_char_t *) "x\u034FN\u200B-\u00AD-\u180CB\uFE00s\u2064s󠇯ffl", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 234 */,
    {.source = (const lxb_char_t *) "x\u034Fn\u200B-\u00AD-\u180Cb\uFE00s\u2064s󠇯ffl", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 235 */,
    {.source = (const lxb_char_t *) "X\u034FN\u200B-\u00AD-\u180CB\uFE00S\u2064S󠇯FFL", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 236 */,
    {.source = (const lxb_char_t *) "X\u034Fn\u200B-\u00AD-\u180CB\uFE00s\u2064s󠇯ffl", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 237 */,
    {.source = (const lxb_char_t *) "xn--bssffl", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 238 */,
    {.source = (const lxb_char_t *) "夡夞夜夙", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 239 */,
    {.source = (const lxb_char_t *) "ˣ\u034Fℕ\u200B﹣\u00AD－\u180Cℬ\uFE00S\u2064𝔰󠇯FFL", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 240 */,
    {.source = (const lxb_char_t *) "x\u034FN\u200B-\u00AD-\u180CB\uFE00S\u2064s󠇯FFL", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 241 */,
    {.source = (const lxb_char_t *) "ˣ\u034Fℕ\u200B﹣\u00AD－\u180Cℬ\uFE00s\u2064𝔰󠇯ffl", .ascii = (const lxb_char_t *) "xn--bssffl", .status = 0} /* 242 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 0} /* 243 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .status = 0} /* 244 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .status = 6} /* 245 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .status = 6} /* 246 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .status = 6} /* 247 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901234.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 12} /* 248 */,
    {.source = (const lxb_char_t *) "ä1234567890123456789012345678901234567890123456789012345", .ascii = (const lxb_char_t *) "xn--1234567890123456789012345678901234567890123456789012345-9te", .status = 0} /* 249 */,
    {.source = (const lxb_char_t *) "a\u03081234567890123456789012345678901234567890123456789012345", .ascii = (const lxb_char_t *) "xn--1234567890123456789012345678901234567890123456789012345-9te", .status = 0} /* 250 */,
    {.source = (const lxb_char_t *) "A\u03081234567890123456789012345678901234567890123456789012345", .ascii = (const lxb_char_t *) "xn--1234567890123456789012345678901234567890123456789012345-9te", .status = 0} /* 251 */,
    {.source = (const lxb_char_t *) "Ä1234567890123456789012345678901234567890123456789012345", .ascii = (const lxb_char_t *) "xn--1234567890123456789012345678901234567890123456789012345-9te", .status = 0} /* 252 */,
    {.source = (const lxb_char_t *) "xn--1234567890123456789012345678901234567890123456789012345-9te", .ascii = (const lxb_char_t *) "xn--1234567890123456789012345678901234567890123456789012345-9te", .status = 0} /* 253 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 0} /* 254 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890a\u0308123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 0} /* 255 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890A\u0308123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 0} /* 256 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 0} /* 257 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 0} /* 258 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .status = 0} /* 259 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890a\u0308123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .status = 0} /* 260 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890A\u0308123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .status = 0} /* 261 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .status = 0} /* 262 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901.", .status = 0} /* 263 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .status = 6} /* 264 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890a\u0308123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .status = 6} /* 265 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890A\u0308123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .status = 6} /* 266 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890Ä123456789012345678901234567890123456789012345.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .status = 6} /* 267 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--1234567890123456789012345678901234567890123456789012345-kue.123456789012345678901234567890123456789012345678901234567890123.12345678901234567890123456789012345678901234567890123456789012", .status = 6} /* 268 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .status = 6} /* 269 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890a\u03081234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .status = 6} /* 270 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890A\u03081234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .status = 6} /* 271 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .status = 6} /* 272 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890", .status = 6} /* 273 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .status = 6} /* 274 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890a\u03081234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .status = 6} /* 275 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890A\u03081234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .status = 6} /* 276 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .status = 6} /* 277 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.123456789012345678901234567890123456789012345678901234567890.", .status = 6} /* 278 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 12} /* 279 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890a\u03081234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 12} /* 280 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890A\u03081234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 12} /* 281 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.1234567890Ä1234567890123456789012345678901234567890123456.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 12} /* 282 */,
    {.source = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .ascii = (const lxb_char_t *) "123456789012345678901234567890123456789012345678901234567890123.xn--12345678901234567890123456789012345678901234567890123456-fxe.123456789012345678901234567890123456789012345678901234567890123.1234567890123456789012345678901234567890123456789012345678901", .status = 12} /* 283 */,
    {.source = (const lxb_char_t *) "a.b..-q--a-.e", .ascii = (const lxb_char_t *) "a.b..-q--a-.e", .status = 14} /* 284 */,
    {.source = (const lxb_char_t *) "a.b..-q--ä-.e", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 285 */,
    {.source = (const lxb_char_t *) "a.b..-q--a\u0308-.e", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 286 */,
    {.source = (const lxb_char_t *) "A.B..-Q--A\u0308-.E", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 287 */,
    {.source = (const lxb_char_t *) "A.B..-Q--Ä-.E", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 288 */,
    {.source = (const lxb_char_t *) "A.b..-Q--Ä-.E", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 289 */,
    {.source = (const lxb_char_t *) "A.b..-Q--A\u0308-.E", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 290 */,
    {.source = (const lxb_char_t *) "a.b..xn---q----jra.e", .ascii = (const lxb_char_t *) "a.b..xn---q----jra.e", .status = 14} /* 291 */,
    {.source = (const lxb_char_t *) "a..c", .ascii = (const lxb_char_t *) "a..c", .status = 6} /* 292 */,
    {.source = (const lxb_char_t *) "a.-b.", .ascii = (const lxb_char_t *) "a.-b.", .status = 4} /* 293 */,
    {.source = (const lxb_char_t *) "a.b-.c", .ascii = (const lxb_char_t *) "a.b-.c", .status = 4} /* 294 */,
    {.source = (const lxb_char_t *) "a.-.c", .ascii = (const lxb_char_t *) "a.-.c", .status = 4} /* 295 */,
    {.source = (const lxb_char_t *) "a.bc--de.f", .ascii = (const lxb_char_t *) "a.bc--de.f", .status = 4} /* 296 */,
    {.source = (const lxb_char_t *) "ä.\u00AD.c", .ascii = (const lxb_char_t *) "xn--4ca..c", .status = 6} /* 297 */,
    {.source = (const lxb_char_t *) "a\u0308.\u00AD.c", .ascii = (const lxb_char_t *) "xn--4ca..c", .status = 6} /* 298 */,
    {.source = (const lxb_char_t *) "A\u0308.\u00AD.C", .ascii = (const lxb_char_t *) "xn--4ca..c", .status = 6} /* 299 */,
    {.source = (const lxb_char_t *) "Ä.\u00AD.C", .ascii = (const lxb_char_t *) "xn--4ca..c", .status = 6} /* 300 */,
    {.source = (const lxb_char_t *) "xn--4ca..c", .ascii = (const lxb_char_t *) "xn--4ca..c", .status = 6} /* 301 */,
    {.source = (const lxb_char_t *) "ä.-b.", .ascii = (const lxb_char_t *) "xn--4ca.-b.", .status = 4} /* 302 */,
    {.source = (const lxb_char_t *) "a\u0308.-b.", .ascii = (const lxb_char_t *) "xn--4ca.-b.", .status = 4} /* 303 */,
    {.source = (const lxb_char_t *) "A\u0308.-B.", .ascii = (const lxb_char_t *) "xn--4ca.-b.", .status = 4} /* 304 */,
    {.source = (const lxb_char_t *) "Ä.-B.", .ascii = (const lxb_char_t *) "xn--4ca.-b.", .status = 4} /* 305 */,
    {.source = (const lxb_char_t *) "xn--4ca.-b.", .ascii = (const lxb_char_t *) "xn--4ca.-b.", .status = 4} /* 306 */,
    {.source = (const lxb_char_t *) "ä.b-.c", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 307 */,
    {.source = (const lxb_char_t *) "a\u0308.b-.c", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 308 */,
    {.source = (const lxb_char_t *) "A\u0308.B-.C", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 309 */,
    {.source = (const lxb_char_t *) "Ä.B-.C", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 310 */,
    {.source = (const lxb_char_t *) "Ä.b-.C", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 311 */,
    {.source = (const lxb_char_t *) "A\u0308.b-.C", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 312 */,
    {.source = (const lxb_char_t *) "xn--4ca.b-.c", .ascii = (const lxb_char_t *) "xn--4ca.b-.c", .status = 4} /* 313 */,
    {.source = (const lxb_char_t *) "ä.-.c", .ascii = (const lxb_char_t *) "xn--4ca.-.c", .status = 4} /* 314 */,
    {.source = (const lxb_char_t *) "a\u0308.-.c", .ascii = (const lxb_char_t *) "xn--4ca.-.c", .status = 4} /* 315 */,
    {.source = (const lxb_char_t *) "A\u0308.-.C", .ascii = (const lxb_char_t *) "xn--4ca.-.c", .status = 4} /* 316 */,
    {.source = (const lxb_char_t *) "Ä.-.C", .ascii = (const lxb_char_t *) "xn--4ca.-.c", .status = 4} /* 317 */,
    {.source = (const lxb_char_t *) "xn--4ca.-.c", .ascii = (const lxb_char_t *) "xn--4ca.-.c", .status = 4} /* 318 */,
    {.source = (const lxb_char_t *) "ä.bc--de.f", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 319 */,
    {.source = (const lxb_char_t *) "a\u0308.bc--de.f", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 320 */,
    {.source = (const lxb_char_t *) "A\u0308.BC--DE.F", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 321 */,
    {.source = (const lxb_char_t *) "Ä.BC--DE.F", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 322 */,
    {.source = (const lxb_char_t *) "Ä.bc--De.f", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 323 */,
    {.source = (const lxb_char_t *) "A\u0308.bc--De.f", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 324 */,
    {.source = (const lxb_char_t *) "xn--4ca.bc--de.f", .ascii = (const lxb_char_t *) "xn--4ca.bc--de.f", .status = 4} /* 325 */,
    {.source = (const lxb_char_t *) "a.b.\u0308c.d", .ascii = (const lxb_char_t *) "a.b.xn--c-bcb.d", .status = 4} /* 326 */,
    {.source = (const lxb_char_t *) "A.B.\u0308C.D", .ascii = (const lxb_char_t *) "a.b.xn--c-bcb.d", .status = 4} /* 327 */,
    {.source = (const lxb_char_t *) "A.b.\u0308c.d", .ascii = (const lxb_char_t *) "a.b.xn--c-bcb.d", .status = 4} /* 328 */,
    {.source = (const lxb_char_t *) "a.b.xn--c-bcb.d", .ascii = (const lxb_char_t *) "a.b.xn--c-bcb.d", .status = 4} /* 329 */,
    {.source = (const lxb_char_t *) "A0", .ascii = (const lxb_char_t *) "a0", .status = 0} /* 330 */,
    {.source = (const lxb_char_t *) "0A", .ascii = (const lxb_char_t *) "0a", .status = 0} /* 331 */,
    {.source = (const lxb_char_t *) "0A.\u05D0", .ascii = (const lxb_char_t *) "0a.xn--4db", .status = 4} /* 332 */,
    {.source = (const lxb_char_t *) "0a.\u05D0", .ascii = (const lxb_char_t *) "0a.xn--4db", .status = 4} /* 333 */,
    {.source = (const lxb_char_t *) "0a.xn--4db", .ascii = (const lxb_char_t *) "0a.xn--4db", .status = 4} /* 334 */,
    {.source = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 335 */,
    {.source = (const lxb_char_t *) "b-.\u05D0", .ascii = (const lxb_char_t *) "b-.xn--4db", .status = 8} /* 336 */,
    {.source = (const lxb_char_t *) "B-.\u05D0", .ascii = (const lxb_char_t *) "b-.xn--4db", .status = 8} /* 337 */,
    {.source = (const lxb_char_t *) "b-.xn--4db", .ascii = (const lxb_char_t *) "b-.xn--4db", .status = 8} /* 338 */,
    {.source = (const lxb_char_t *) "d.xn----dha.xn--4db", .ascii = (const lxb_char_t *) "d.xn----dha.xn--4db", .status = 8} /* 339 */,
    {.source = (const lxb_char_t *) "a\u05D0", .ascii = (const lxb_char_t *) "xn--a-0hc", .status = 8} /* 340 */,
    {.source = (const lxb_char_t *) "A\u05D0", .ascii = (const lxb_char_t *) "xn--a-0hc", .status = 8} /* 341 */,
    {.source = (const lxb_char_t *) "xn--a-0hc", .ascii = (const lxb_char_t *) "xn--a-0hc", .status = 8} /* 342 */,
    {.source = (const lxb_char_t *) "\u05D0\u05C7", .ascii = (const lxb_char_t *) "xn--vdbr", .status = 0} /* 343 */,
    {.source = (const lxb_char_t *) "xn--vdbr", .ascii = (const lxb_char_t *) "xn--vdbr", .status = 0} /* 344 */,
    {.source = (const lxb_char_t *) "\u05D09\u05C7", .ascii = (const lxb_char_t *) "xn--9-ihcz", .status = 0} /* 345 */,
    {.source = (const lxb_char_t *) "xn--9-ihcz", .ascii = (const lxb_char_t *) "xn--9-ihcz", .status = 0} /* 346 */,
    {.source = (const lxb_char_t *) "\u05D0a\u05C7", .ascii = (const lxb_char_t *) "xn--a-ihcz", .status = 8} /* 347 */,
    {.source = (const lxb_char_t *) "\u05D0A\u05C7", .ascii = (const lxb_char_t *) "xn--a-ihcz", .status = 8} /* 348 */,
    {.source = (const lxb_char_t *) "xn--a-ihcz", .ascii = (const lxb_char_t *) "xn--a-ihcz", .status = 8} /* 349 */,
    {.source = (const lxb_char_t *) "\u05D0\u05EA", .ascii = (const lxb_char_t *) "xn--4db6c", .status = 0} /* 350 */,
    {.source = (const lxb_char_t *) "xn--4db6c", .ascii = (const lxb_char_t *) "xn--4db6c", .status = 0} /* 351 */,
    {.source = (const lxb_char_t *) "\u05D0\u05F3\u05EA", .ascii = (const lxb_char_t *) "xn--4db6c0a", .status = 0} /* 352 */,
    {.source = (const lxb_char_t *) "xn--4db6c0a", .ascii = (const lxb_char_t *) "xn--4db6c0a", .status = 0} /* 353 */,
    {.source = (const lxb_char_t *) "a\u05D0Tz", .ascii = (const lxb_char_t *) "xn--atz-qpe", .status = 4} /* 354 */,
    {.source = (const lxb_char_t *) "a\u05D0tz", .ascii = (const lxb_char_t *) "xn--atz-qpe", .status = 4} /* 355 */,
    {.source = (const lxb_char_t *) "A\u05D0TZ", .ascii = (const lxb_char_t *) "xn--atz-qpe", .status = 4} /* 356 */,
    {.source = (const lxb_char_t *) "A\u05D0tz", .ascii = (const lxb_char_t *) "xn--atz-qpe", .status = 4} /* 357 */,
    {.source = (const lxb_char_t *) "xn--atz-qpe", .ascii = (const lxb_char_t *) "xn--atz-qpe", .status = 4} /* 358 */,
    {.source = (const lxb_char_t *) "\u05D0T\u05EA", .ascii = (const lxb_char_t *) "xn--t-zhc3f", .status = 4} /* 359 */,
    {.source = (const lxb_char_t *) "\u05D0t\u05EA", .ascii = (const lxb_char_t *) "xn--t-zhc3f", .status = 4} /* 360 */,
    {.source = (const lxb_char_t *) "xn--t-zhc3f", .ascii = (const lxb_char_t *) "xn--t-zhc3f", .status = 4} /* 361 */,
    {.source = (const lxb_char_t *) "\u05D07\u05EA", .ascii = (const lxb_char_t *) "xn--7-zhc3f", .status = 0} /* 362 */,
    {.source = (const lxb_char_t *) "xn--7-zhc3f", .ascii = (const lxb_char_t *) "xn--7-zhc3f", .status = 0} /* 363 */,
    {.source = (const lxb_char_t *) "\u05D0\u0667\u05EA", .ascii = (const lxb_char_t *) "xn--4db6c6t", .status = 0} /* 364 */,
    {.source = (const lxb_char_t *) "xn--4db6c6t", .ascii = (const lxb_char_t *) "xn--4db6c6t", .status = 0} /* 365 */,
    {.source = (const lxb_char_t *) "a7\u0667z", .ascii = (const lxb_char_t *) "xn--a7z-06e", .status = 4} /* 366 */,
    {.source = (const lxb_char_t *) "A7\u0667Z", .ascii = (const lxb_char_t *) "xn--a7z-06e", .status = 4} /* 367 */,
    {.source = (const lxb_char_t *) "A7\u0667z", .ascii = (const lxb_char_t *) "xn--a7z-06e", .status = 4} /* 368 */,
    {.source = (const lxb_char_t *) "xn--a7z-06e", .ascii = (const lxb_char_t *) "xn--a7z-06e", .status = 4} /* 369 */,
    {.source = (const lxb_char_t *) "\u05D07\u0667\u05EA", .ascii = (const lxb_char_t *) "xn--7-zhc3fty", .status = 4} /* 370 */,
    {.source = (const lxb_char_t *) "xn--7-zhc3fty", .ascii = (const lxb_char_t *) "xn--7-zhc3fty", .status = 4} /* 371 */,
    {.source = (const lxb_char_t *) "ஹ\u0BCD\u200D", .ascii = (const lxb_char_t *) "xn--dmc4b194h", .status = 0} /* 372 */,
    {.source = (const lxb_char_t *) "xn--dmc4b", .ascii = (const lxb_char_t *) "xn--dmc4b", .status = 0} /* 373 */,
    {.source = (const lxb_char_t *) "ஹ\u0BCD", .ascii = (const lxb_char_t *) "xn--dmc4b", .status = 0} /* 374 */,
    {.source = (const lxb_char_t *) "xn--dmc4b194h", .ascii = (const lxb_char_t *) "xn--dmc4b194h", .status = 0} /* 375 */,
    {.source = (const lxb_char_t *) "ஹ\u200D", .ascii = (const lxb_char_t *) "xn--dmc225h", .status = 4} /* 376 */,
    {.source = (const lxb_char_t *) "xn--dmc", .ascii = (const lxb_char_t *) "xn--dmc", .status = 0} /* 377 */,
    {.source = (const lxb_char_t *) "ஹ", .ascii = (const lxb_char_t *) "xn--dmc", .status = 0} /* 378 */,
    {.source = (const lxb_char_t *) "xn--dmc225h", .ascii = (const lxb_char_t *) "xn--dmc225h", .status = 4} /* 379 */,
    {.source = (const lxb_char_t *) "\u200D", .ascii = (const lxb_char_t *) "xn--1ug", .status = 4} /* 380 */,
    {.source = (const lxb_char_t *) "", .ascii = (const lxb_char_t *) "", .status = 6} /* 381 */,
    {.source = (const lxb_char_t *) "xn--1ug", .ascii = (const lxb_char_t *) "xn--1ug", .status = 4} /* 382 */,
    {.source = (const lxb_char_t *) "ஹ\u0BCD\u200C", .ascii = (const lxb_char_t *) "xn--dmc4by94h", .status = 0} /* 383 */,
    {.source = (const lxb_char_t *) "xn--dmc4by94h", .ascii = (const lxb_char_t *) "xn--dmc4by94h", .status = 0} /* 384 */,
    {.source = (const lxb_char_t *) "ஹ\u200C", .ascii = (const lxb_char_t *) "xn--dmc025h", .status = 4} /* 385 */,
    {.source = (const lxb_char_t *) "xn--dmc025h", .ascii = (const lxb_char_t *) "xn--dmc025h", .status = 4} /* 386 */,
    {.source = (const lxb_char_t *) "\u200C", .ascii = (const lxb_char_t *) "xn--0ug", .status = 4} /* 387 */,
    {.source = (const lxb_char_t *) "xn--0ug", .ascii = (const lxb_char_t *) "xn--0ug", .status = 4} /* 388 */,
    {.source = (const lxb_char_t *) "\u0644\u0670\u200C\u06ED\u06EF", .ascii = (const lxb_char_t *) "xn--ghb2gxqia7523a", .status = 0} /* 389 */,
    {.source = (const lxb_char_t *) "xn--ghb2gxqia", .ascii = (const lxb_char_t *) "xn--ghb2gxqia", .status = 0} /* 390 */,
    {.source = (const lxb_char_t *) "\u0644\u0670\u06ED\u06EF", .ascii = (const lxb_char_t *) "xn--ghb2gxqia", .status = 0} /* 391 */,
    {.source = (const lxb_char_t *) "xn--ghb2gxqia7523a", .ascii = (const lxb_char_t *) "xn--ghb2gxqia7523a", .status = 0} /* 392 */,
    {.source = (const lxb_char_t *) "\u0644\u0670\u200C\u06EF", .ascii = (const lxb_char_t *) "xn--ghb2g3qq34f", .status = 0} /* 393 */,
    {.source = (const lxb_char_t *) "xn--ghb2g3q", .ascii = (const lxb_char_t *) "xn--ghb2g3q", .status = 0} /* 394 */,
    {.source = (const lxb_char_t *) "\u0644\u0670\u06EF", .ascii = (const lxb_char_t *) "xn--ghb2g3q", .status = 0} /* 395 */,
    {.source = (const lxb_char_t *) "xn--ghb2g3qq34f", .ascii = (const lxb_char_t *) "xn--ghb2g3qq34f", .status = 0} /* 396 */,
    {.source = (const lxb_char_t *) "\u0644\u200C\u06ED\u06EF", .ascii = (const lxb_char_t *) "xn--ghb25aga828w", .status = 0} /* 397 */,
    {.source = (const lxb_char_t *) "xn--ghb25aga", .ascii = (const lxb_char_t *) "xn--ghb25aga", .status = 0} /* 398 */,
    {.source = (const lxb_char_t *) "\u0644\u06ED\u06EF", .ascii = (const lxb_char_t *) "xn--ghb25aga", .status = 0} /* 399 */,
    {.source = (const lxb_char_t *) "xn--ghb25aga828w", .ascii = (const lxb_char_t *) "xn--ghb25aga828w", .status = 0} /* 400 */,
    {.source = (const lxb_char_t *) "\u0644\u200C\u06EF", .ascii = (const lxb_char_t *) "xn--ghb65a953d", .status = 0} /* 401 */,
    {.source = (const lxb_char_t *) "xn--ghb65a", .ascii = (const lxb_char_t *) "xn--ghb65a", .status = 0} /* 402 */,
    {.source = (const lxb_char_t *) "\u0644\u06EF", .ascii = (const lxb_char_t *) "xn--ghb65a", .status = 0} /* 403 */,
    {.source = (const lxb_char_t *) "xn--ghb65a953d", .ascii = (const lxb_char_t *) "xn--ghb65a953d", .status = 0} /* 404 */,
    {.source = (const lxb_char_t *) "\u0644\u0670\u200C\u06ED", .ascii = (const lxb_char_t *) "xn--ghb2gxqy34f", .status = 8} /* 405 */,
    {.source = (const lxb_char_t *) "xn--ghb2gxq", .ascii = (const lxb_char_t *) "xn--ghb2gxq", .status = 0} /* 406 */,
    {.source = (const lxb_char_t *) "\u0644\u0670\u06ED", .ascii = (const lxb_char_t *) "xn--ghb2gxq", .status = 0} /* 407 */,
    {.source = (const lxb_char_t *) "xn--ghb2gxqy34f", .ascii = (const lxb_char_t *) "xn--ghb2gxqy34f", .status = 8} /* 408 */,
    {.source = (const lxb_char_t *) "\u06EF\u200C\u06EF", .ascii = (const lxb_char_t *) "xn--cmba004q", .status = 4} /* 409 */,
    {.source = (const lxb_char_t *) "xn--cmba", .ascii = (const lxb_char_t *) "xn--cmba", .status = 0} /* 410 */,
    {.source = (const lxb_char_t *) "\u06EF\u06EF", .ascii = (const lxb_char_t *) "xn--cmba", .status = 0} /* 411 */,
    {.source = (const lxb_char_t *) "xn--cmba004q", .ascii = (const lxb_char_t *) "xn--cmba004q", .status = 4} /* 412 */,
    {.source = (const lxb_char_t *) "\u0644\u200C", .ascii = (const lxb_char_t *) "xn--ghb413k", .status = 8} /* 413 */,
    {.source = (const lxb_char_t *) "xn--ghb", .ascii = (const lxb_char_t *) "xn--ghb", .status = 0} /* 414 */,
    {.source = (const lxb_char_t *) "\u0644", .ascii = (const lxb_char_t *) "xn--ghb", .status = 0} /* 415 */,
    {.source = (const lxb_char_t *) "xn--ghb413k", .ascii = (const lxb_char_t *) "xn--ghb413k", .status = 8} /* 416 */,
    {.source = (const lxb_char_t *) "a。。b", .ascii = (const lxb_char_t *) "a..b", .status = 6} /* 417 */,
    {.source = (const lxb_char_t *) "A。。B", .ascii = (const lxb_char_t *) "a..b", .status = 6} /* 418 */,
    {.source = (const lxb_char_t *) "a..b", .ascii = (const lxb_char_t *) "a..b", .status = 6} /* 419 */,
    {.source = (const lxb_char_t *) "\u200D。。\u06B9\u200C", .ascii = (const lxb_char_t *) "xn--1ug..xn--skb080k", .status = 22} /* 420 */,
    {.source = (const lxb_char_t *) "..xn--skb", .ascii = (const lxb_char_t *) "..xn--skb", .status = 6} /* 421 */,
    {.source = (const lxb_char_t *) "xn--1ug..xn--skb080k", .ascii = (const lxb_char_t *) "xn--1ug..xn--skb080k", .status = 22} /* 422 */,
    {.source = (const lxb_char_t *) "\u05D00\u0660", .ascii = (const lxb_char_t *) "xn--0-zhc74b", .status = 4} /* 423 */,
    {.source = (const lxb_char_t *) "xn--0-zhc74b", .ascii = (const lxb_char_t *) "xn--0-zhc74b", .status = 4} /* 424 */,
    {.source = (const lxb_char_t *) "$", .ascii = (const lxb_char_t *) "$", .status = 4} /* 425 */,
    {.source = (const lxb_char_t *) "c.0ü.\u05D0", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 426 */,
    {.source = (const lxb_char_t *) "c.0u\u0308.\u05D0", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 427 */,
    {.source = (const lxb_char_t *) "C.0U\u0308.\u05D0", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 428 */,
    {.source = (const lxb_char_t *) "C.0Ü.\u05D0", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 429 */,
    {.source = (const lxb_char_t *) "C.0ü.\u05D0", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 430 */,
    {.source = (const lxb_char_t *) "C.0u\u0308.\u05D0", .ascii = (const lxb_char_t *) "c.xn--0-eha.xn--4db", .status = 4} /* 431 */,
    {.source = (const lxb_char_t *) "⒕∝\u065F򓤦．-󠄯", .ascii = (const lxb_char_t *) "xn--7hb713lfwbi1311b.-", .status = 8} /* 432 */,
    {.source = (const lxb_char_t *) "14.∝\u065F򓤦.-󠄯", .ascii = (const lxb_char_t *) "14.xn--7hb713l3v90n.-", .status = 8} /* 433 */,
    {.source = (const lxb_char_t *) "14.xn--7hb713l3v90n.-", .ascii = (const lxb_char_t *) "14.xn--7hb713l3v90n.-", .status = 8} /* 434 */,
    {.source = (const lxb_char_t *) "xn--7hb713lfwbi1311b.-", .ascii = (const lxb_char_t *) "xn--7hb713lfwbi1311b.-", .status = 8} /* 435 */,
    {.source = (const lxb_char_t *) "ꡣ.\u07CF", .ascii = (const lxb_char_t *) "xn--8c9a.xn--qsb", .status = 0} /* 436 */,
    {.source = (const lxb_char_t *) "xn--8c9a.xn--qsb", .ascii = (const lxb_char_t *) "xn--8c9a.xn--qsb", .status = 0} /* 437 */,
    {.source = (const lxb_char_t *) "≯\u0603｡-", .ascii = (const lxb_char_t *) "xn--lfb566l.-", .status = 12} /* 438 */,
    {.source = (const lxb_char_t *) ">\u0338\u0603｡-", .ascii = (const lxb_char_t *) "xn--lfb566l.-", .status = 12} /* 439 */,
    {.source = (const lxb_char_t *) "≯\u0603。-", .ascii = (const lxb_char_t *) "xn--lfb566l.-", .status = 12} /* 440 */,
    {.source = (const lxb_char_t *) ">\u0338\u0603。-", .ascii = (const lxb_char_t *) "xn--lfb566l.-", .status = 12} /* 441 */,
    {.source = (const lxb_char_t *) "xn--lfb566l.-", .ascii = (const lxb_char_t *) "xn--lfb566l.-", .status = 12} /* 442 */,
    {.source = (const lxb_char_t *) "⾛𐹧⾕.\u115F󠗰ςႭ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa827dhpae6345i", .status = 8} /* 443 */,
    {.source = (const lxb_char_t *) "走𐹧谷.\u115F󠗰ςႭ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa827dhpae6345i", .status = 8} /* 444 */,
    {.source = (const lxb_char_t *) "走𐹧谷.\u115F󠗰ςⴍ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa380eotvh7453a", .status = 8} /* 445 */,
    {.source = (const lxb_char_t *) "走𐹧谷.\u115F󠗰ΣႭ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa627dhpae6345i", .status = 8} /* 446 */,
    {.source = (const lxb_char_t *) "走𐹧谷.\u115F󠗰σⴍ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa180eotvh7453a", .status = 8} /* 447 */,
    {.source = (const lxb_char_t *) "走𐹧谷.\u115F󠗰Σⴍ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa180eotvh7453a", .status = 8} /* 448 */,
    {.source = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa180eotvh7453a", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa180eotvh7453a", .status = 8} /* 449 */,
    {.source = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa627dhpae6345i", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa627dhpae6345i", .status = 8} /* 450 */,
    {.source = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa380eotvh7453a", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa380eotvh7453a", .status = 8} /* 451 */,
    {.source = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa827dhpae6345i", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa827dhpae6345i", .status = 8} /* 452 */,
    {.source = (const lxb_char_t *) "⾛𐹧⾕.\u115F󠗰ςⴍ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--3xa380eotvh7453a", .status = 8} /* 453 */,
    {.source = (const lxb_char_t *) "⾛𐹧⾕.\u115F󠗰ΣႭ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa627dhpae6345i", .status = 8} /* 454 */,
    {.source = (const lxb_char_t *) "⾛𐹧⾕.\u115F󠗰σⴍ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa180eotvh7453a", .status = 8} /* 455 */,
    {.source = (const lxb_char_t *) "⾛𐹧⾕.\u115F󠗰Σⴍ", .ascii = (const lxb_char_t *) "xn--6g3a1x434z.xn--4xa180eotvh7453a", .status = 8} /* 456 */,
    {.source = (const lxb_char_t *) "\u200D≠ᢙ≯.솣-ᡴႠ", .ascii = (const lxb_char_t *) "xn--jbf929a90b0b.xn----6zg521d196p", .status = 8} /* 457 */,
    {.source = (const lxb_char_t *) "\u200D=\u0338ᢙ>\u0338.솣-ᡴႠ", .ascii = (const lxb_char_t *) "xn--jbf929a90b0b.xn----6zg521d196p", .status = 8} /* 458 */,
    {.source = (const lxb_char_t *) "\u200D=\u0338ᢙ>\u0338.솣-ᡴⴀ", .ascii = (const lxb_char_t *) "xn--jbf929a90b0b.xn----p9j493ivi4l", .status = 4} /* 459 */,
    {.source = (const lxb_char_t *) "\u200D≠ᢙ≯.솣-ᡴⴀ", .ascii = (const lxb_char_t *) "xn--jbf929a90b0b.xn----p9j493ivi4l", .status = 4} /* 460 */,
    {.source = (const lxb_char_t *) "xn--jbf911clb.xn----p9j493ivi4l", .ascii = (const lxb_char_t *) "xn--jbf911clb.xn----p9j493ivi4l", .status = 0} /* 461 */,
    {.source = (const lxb_char_t *) "≠ᢙ≯.솣-ᡴⴀ", .ascii = (const lxb_char_t *) "xn--jbf911clb.xn----p9j493ivi4l", .status = 0} /* 462 */,
    {.source = (const lxb_char_t *) "=\u0338ᢙ>\u0338.솣-ᡴⴀ", .ascii = (const lxb_char_t *) "xn--jbf911clb.xn----p9j493ivi4l", .status = 0} /* 463 */,
    {.source = (const lxb_char_t *) "=\u0338ᢙ>\u0338.솣-ᡴႠ", .ascii = (const lxb_char_t *) "xn--jbf911clb.xn----6zg521d196p", .status = 4} /* 464 */,
    {.source = (const lxb_char_t *) "≠ᢙ≯.솣-ᡴႠ", .ascii = (const lxb_char_t *) "xn--jbf911clb.xn----6zg521d196p", .status = 4} /* 465 */,
    {.source = (const lxb_char_t *) "xn--jbf911clb.xn----6zg521d196p", .ascii = (const lxb_char_t *) "xn--jbf911clb.xn----6zg521d196p", .status = 4} /* 466 */,
    {.source = (const lxb_char_t *) "xn--jbf929a90b0b.xn----p9j493ivi4l", .ascii = (const lxb_char_t *) "xn--jbf929a90b0b.xn----p9j493ivi4l", .status = 4} /* 467 */,
    {.source = (const lxb_char_t *) "xn--jbf929a90b0b.xn----6zg521d196p", .ascii = (const lxb_char_t *) "xn--jbf929a90b0b.xn----6zg521d196p", .status = 8} /* 468 */,
    {.source = (const lxb_char_t *) "񯞜．𐿇\u0FA2\u077D\u0600", .ascii = (const lxb_char_t *) "xn--gw68a.xn--ifb57ev2psc6027m", .status = 4} /* 469 */,
    {.source = (const lxb_char_t *) "񯞜．𐿇\u0FA1\u0FB7\u077D\u0600", .ascii = (const lxb_char_t *) "xn--gw68a.xn--ifb57ev2psc6027m", .status = 4} /* 470 */,
    {.source = (const lxb_char_t *) "񯞜.𐿇\u0FA1\u0FB7\u077D\u0600", .ascii = (const lxb_char_t *) "xn--gw68a.xn--ifb57ev2psc6027m", .status = 4} /* 471 */,
    {.source = (const lxb_char_t *) "xn--gw68a.xn--ifb57ev2psc6027m", .ascii = (const lxb_char_t *) "xn--gw68a.xn--ifb57ev2psc6027m", .status = 4} /* 472 */,
    {.source = (const lxb_char_t *) "𣳔\u0303.𑓂", .ascii = (const lxb_char_t *) "xn--nsa95820a.xn--wz1d", .status = 4} /* 473 */,
    {.source = (const lxb_char_t *) "xn--nsa95820a.xn--wz1d", .ascii = (const lxb_char_t *) "xn--nsa95820a.xn--wz1d", .status = 4} /* 474 */,
    {.source = (const lxb_char_t *) "𞤀𞥅񘐱。󠄌Ⴣꡥ", .ascii = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--7nd0578e", .status = 12} /* 475 */,
    {.source = (const lxb_char_t *) "𞤢𞥅񘐱。󠄌ⴣꡥ", .ascii = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--rlju750b", .status = 12} /* 476 */,
    {.source = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--rlju750b", .ascii = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--rlju750b", .status = 12} /* 477 */,
    {.source = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--7nd0578e", .ascii = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--7nd0578e", .status = 12} /* 478 */,
    {.source = (const lxb_char_t *) "𞤀𞥅񘐱。󠄌ⴣꡥ", .ascii = (const lxb_char_t *) "xn--9d6hgcy3556a.xn--rlju750b", .status = 12} /* 479 */,
    {.source = (const lxb_char_t *) "\u08E2𑁿ς𖬱。󠅡렧", .ascii = (const lxb_char_t *) "xn--3xa73xp48ys2xc.xn--kn2b", .status = 8} /* 480 */,
    {.source = (const lxb_char_t *) "\u08E2𑁿ς𖬱。󠅡렧", .ascii = (const lxb_char_t *) "xn--3xa73xp48ys2xc.xn--kn2b", .status = 8} /* 481 */,
    {.source = (const lxb_char_t *) "\u08E2𑁿Σ𖬱。󠅡렧", .ascii = (const lxb_char_t *) "xn--4xa53xp48ys2xc.xn--kn2b", .status = 8} /* 482 */,
    {.source = (const lxb_char_t *) "\u08E2𑁿Σ𖬱。󠅡렧", .ascii = (const lxb_char_t *) "xn--4xa53xp48ys2xc.xn--kn2b", .status = 8} /* 483 */,
    {.source = (const lxb_char_t *) "\u08E2𑁿σ𖬱。󠅡렧", .ascii = (const lxb_char_t *) "xn--4xa53xp48ys2xc.xn--kn2b", .status = 8} /* 484 */,
    {.source = (const lxb_char_t *) "\u08E2𑁿σ𖬱。󠅡렧", .ascii = (const lxb_char_t *) "xn--4xa53xp48ys2xc.xn--kn2b", .status = 8} /* 485 */,
    {.source = (const lxb_char_t *) "xn--4xa53xp48ys2xc.xn--kn2b", .ascii = (const lxb_char_t *) "xn--4xa53xp48ys2xc.xn--kn2b", .status = 8} /* 486 */,
    {.source = (const lxb_char_t *) "xn--3xa73xp48ys2xc.xn--kn2b", .ascii = (const lxb_char_t *) "xn--3xa73xp48ys2xc.xn--kn2b", .status = 8} /* 487 */,
    {.source = (const lxb_char_t *) "-\u200D。𞤍\u200C\u200D⒈", .ascii = (const lxb_char_t *) "xn----ugn.xn--0ugc555aiv51d", .status = 20} /* 488 */,
    {.source = (const lxb_char_t *) "-\u200D。𞤍\u200C\u200D1.", .ascii = (const lxb_char_t *) "xn----ugn.xn--1-rgnd61297b.", .status = 16} /* 489 */,
    {.source = (const lxb_char_t *) "-\u200D。𞤯\u200C\u200D1.", .ascii = (const lxb_char_t *) "xn----ugn.xn--1-rgnd61297b.", .status = 16} /* 490 */,
    {.source = (const lxb_char_t *) "-.xn--1-0i8r.", .ascii = (const lxb_char_t *) "-.xn--1-0i8r.", .status = 8} /* 491 */,
    {.source = (const lxb_char_t *) "xn----ugn.xn--1-rgnd61297b.", .ascii = (const lxb_char_t *) "xn----ugn.xn--1-rgnd61297b.", .status = 16} /* 492 */,
    {.source = (const lxb_char_t *) "-\u200D。𞤯\u200C\u200D⒈", .ascii = (const lxb_char_t *) "xn----ugn.xn--0ugc555aiv51d", .status = 20} /* 493 */,
    {.source = (const lxb_char_t *) "-.xn--tsh3666n", .ascii = (const lxb_char_t *) "-.xn--tsh3666n", .status = 12} /* 494 */,
    {.source = (const lxb_char_t *) "xn----ugn.xn--0ugc555aiv51d", .ascii = (const lxb_char_t *) "xn----ugn.xn--0ugc555aiv51d", .status = 20} /* 495 */,
    {.source = (const lxb_char_t *) "\u200C򅎭.Ⴒ𑇀", .ascii = (const lxb_char_t *) "xn--0ug15083f.xn--qnd6272k", .status = 8} /* 496 */,
    {.source = (const lxb_char_t *) "\u200C򅎭.ⴒ𑇀", .ascii = (const lxb_char_t *) "xn--0ug15083f.xn--9kj2034e", .status = 8} /* 497 */,
    {.source = (const lxb_char_t *) "xn--bn95b.xn--9kj2034e", .ascii = (const lxb_char_t *) "xn--bn95b.xn--9kj2034e", .status = 4} /* 498 */,
    {.source = (const lxb_char_t *) "xn--0ug15083f.xn--9kj2034e", .ascii = (const lxb_char_t *) "xn--0ug15083f.xn--9kj2034e", .status = 8} /* 499 */,
    {.source = (const lxb_char_t *) "xn--bn95b.xn--qnd6272k", .ascii = (const lxb_char_t *) "xn--bn95b.xn--qnd6272k", .status = 4} /* 500 */,
    {.source = (const lxb_char_t *) "xn--0ug15083f.xn--qnd6272k", .ascii = (const lxb_char_t *) "xn--0ug15083f.xn--qnd6272k", .status = 8} /* 501 */,
    {.source = (const lxb_char_t *) "繱𑖿\u200D.８︒", .ascii = (const lxb_char_t *) "xn--1ug6928ac48e.xn--8-o89h", .status = 4} /* 502 */,
    {.source = (const lxb_char_t *) "繱𑖿\u200D.8。", .ascii = (const lxb_char_t *) "xn--1ug6928ac48e.8.", .status = 0} /* 503 */,
    {.source = (const lxb_char_t *) "xn--gl0as212a.8.", .ascii = (const lxb_char_t *) "xn--gl0as212a.8.", .status = 0} /* 504 */,
    {.source = (const lxb_char_t *) "繱𑖿.8.", .ascii = (const lxb_char_t *) "xn--gl0as212a.8.", .status = 0} /* 505 */,
    {.source = (const lxb_char_t *) "xn--1ug6928ac48e.8.", .ascii = (const lxb_char_t *) "xn--1ug6928ac48e.8.", .status = 0} /* 506 */,
    {.source = (const lxb_char_t *) "繱𑖿\u200D.8.", .ascii = (const lxb_char_t *) "xn--1ug6928ac48e.8.", .status = 0} /* 507 */,
    {.source = (const lxb_char_t *) "xn--gl0as212a.xn--8-o89h", .ascii = (const lxb_char_t *) "xn--gl0as212a.xn--8-o89h", .status = 4} /* 508 */,
    {.source = (const lxb_char_t *) "xn--1ug6928ac48e.xn--8-o89h", .ascii = (const lxb_char_t *) "xn--1ug6928ac48e.xn--8-o89h", .status = 4} /* 509 */,
    {.source = (const lxb_char_t *) "󠆾．𞀈", .ascii = (const lxb_char_t *) ".xn--ph4h", .status = 10} /* 510 */,
    {.source = (const lxb_char_t *) "󠆾.𞀈", .ascii = (const lxb_char_t *) ".xn--ph4h", .status = 10} /* 511 */,
    {.source = (const lxb_char_t *) ".xn--ph4h", .ascii = (const lxb_char_t *) ".xn--ph4h", .status = 10} /* 512 */,
    {.source = (const lxb_char_t *) "ß\u06EB。\u200D", .ascii = (const lxb_char_t *) "xn--zca012a.xn--1ug", .status = 4} /* 513 */,
    {.source = (const lxb_char_t *) "SS\u06EB。\u200D", .ascii = (const lxb_char_t *) "xn--ss-59d.xn--1ug", .status = 4} /* 514 */,
    {.source = (const lxb_char_t *) "ss\u06EB。\u200D", .ascii = (const lxb_char_t *) "xn--ss-59d.xn--1ug", .status = 4} /* 515 */,
    {.source = (const lxb_char_t *) "Ss\u06EB。\u200D", .ascii = (const lxb_char_t *) "xn--ss-59d.xn--1ug", .status = 4} /* 516 */,
    {.source = (const lxb_char_t *) "xn--ss-59d.", .ascii = (const lxb_char_t *) "xn--ss-59d.", .status = 0} /* 517 */,
    {.source = (const lxb_char_t *) "ss\u06EB.", .ascii = (const lxb_char_t *) "xn--ss-59d.", .status = 0} /* 518 */,
    {.source = (const lxb_char_t *) "SS\u06EB.", .ascii = (const lxb_char_t *) "xn--ss-59d.", .status = 0} /* 519 */,
    {.source = (const lxb_char_t *) "Ss\u06EB.", .ascii = (const lxb_char_t *) "xn--ss-59d.", .status = 0} /* 520 */,
    {.source = (const lxb_char_t *) "xn--ss-59d.xn--1ug", .ascii = (const lxb_char_t *) "xn--ss-59d.xn--1ug", .status = 4} /* 521 */,
    {.source = (const lxb_char_t *) "xn--zca012a.xn--1ug", .ascii = (const lxb_char_t *) "xn--zca012a.xn--1ug", .status = 4} /* 522 */,
    {.source = (const lxb_char_t *) "󠐵\u200C⒈．󠎇", .ascii = (const lxb_char_t *) "xn--0ug88o47900b.xn--tv36e", .status = 8} /* 523 */,
    {.source = (const lxb_char_t *) "󠐵\u200C1..󠎇", .ascii = (const lxb_char_t *) "xn--1-rgn37671n..xn--tv36e", .status = 14} /* 524 */,
    {.source = (const lxb_char_t *) "xn--1-bs31m..xn--tv36e", .ascii = (const lxb_char_t *) "xn--1-bs31m..xn--tv36e", .status = 10} /* 525 */,
    {.source = (const lxb_char_t *) "xn--1-rgn37671n..xn--tv36e", .ascii = (const lxb_char_t *) "xn--1-rgn37671n..xn--tv36e", .status = 14} /* 526 */,
    {.source = (const lxb_char_t *) "xn--tshz2001k.xn--tv36e", .ascii = (const lxb_char_t *) "xn--tshz2001k.xn--tv36e", .status = 4} /* 527 */,
    {.source = (const lxb_char_t *) "xn--0ug88o47900b.xn--tv36e", .ascii = (const lxb_char_t *) "xn--0ug88o47900b.xn--tv36e", .status = 8} /* 528 */,
    {.source = (const lxb_char_t *) "󟈣\u065F\uAAB2ß。󌓧", .ascii = (const lxb_char_t *) "xn--zca92z0t7n5w96j.xn--bb79d", .status = 4} /* 529 */,
    {.source = (const lxb_char_t *) "󟈣\u065F\uAAB2SS。󌓧", .ascii = (const lxb_char_t *) "xn--ss-3xd2839nncy1m.xn--bb79d", .status = 4} /* 530 */,
    {.source = (const lxb_char_t *) "󟈣\u065F\uAAB2ss。󌓧", .ascii = (const lxb_char_t *) "xn--ss-3xd2839nncy1m.xn--bb79d", .status = 4} /* 531 */,
    {.source = (const lxb_char_t *) "󟈣\u065F\uAAB2Ss。󌓧", .ascii = (const lxb_char_t *) "xn--ss-3xd2839nncy1m.xn--bb79d", .status = 4} /* 532 */,
    {.source = (const lxb_char_t *) "xn--ss-3xd2839nncy1m.xn--bb79d", .ascii = (const lxb_char_t *) "xn--ss-3xd2839nncy1m.xn--bb79d", .status = 4} /* 533 */,
    {.source = (const lxb_char_t *) "xn--zca92z0t7n5w96j.xn--bb79d", .ascii = (const lxb_char_t *) "xn--zca92z0t7n5w96j.xn--bb79d", .status = 4} /* 534 */,
    {.source = (const lxb_char_t *) "\u0774\u200C𞤿。𽘐䉜\u200D񿤼", .ascii = (const lxb_char_t *) "xn--4pb607jjt73a.xn--1ug236ke314donv1a", .status = 12} /* 535 */,
    {.source = (const lxb_char_t *) "\u0774\u200C𞤝。𽘐䉜\u200D񿤼", .ascii = (const lxb_char_t *) "xn--4pb607jjt73a.xn--1ug236ke314donv1a", .status = 12} /* 536 */,
    {.source = (const lxb_char_t *) "xn--4pb2977v.xn--z0nt555ukbnv", .ascii = (const lxb_char_t *) "xn--4pb2977v.xn--z0nt555ukbnv", .status = 4} /* 537 */,
    {.source = (const lxb_char_t *) "xn--4pb607jjt73a.xn--1ug236ke314donv1a", .ascii = (const lxb_char_t *) "xn--4pb607jjt73a.xn--1ug236ke314donv1a", .status = 12} /* 538 */,
    {.source = (const lxb_char_t *) "򔭜ςᡱ⒈.≮𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--3xa407hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 539 */,
    {.source = (const lxb_char_t *) "򔭜ςᡱ⒈.<\u0338𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--3xa407hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 540 */,
    {.source = (const lxb_char_t *) "򔭜ςᡱ1..≮𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--1-xmb999meq63t..xn--1ug85gn777ahze", .status = 14} /* 541 */,
    {.source = (const lxb_char_t *) "򔭜ςᡱ1..<\u0338𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--1-xmb999meq63t..xn--1ug85gn777ahze", .status = 14} /* 542 */,
    {.source = (const lxb_char_t *) "򔭜Σᡱ1..<\u0338𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--1ug85gn777ahze", .status = 14} /* 543 */,
    {.source = (const lxb_char_t *) "򔭜Σᡱ1..≮𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--1ug85gn777ahze", .status = 14} /* 544 */,
    {.source = (const lxb_char_t *) "򔭜σᡱ1..≮𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--1ug85gn777ahze", .status = 14} /* 545 */,
    {.source = (const lxb_char_t *) "򔭜σᡱ1..<\u0338𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--1ug85gn777ahze", .status = 14} /* 546 */,
    {.source = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--gdh5392g6sd", .ascii = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--gdh5392g6sd", .status = 14} /* 547 */,
    {.source = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--1ug85gn777ahze", .ascii = (const lxb_char_t *) "xn--1-zmb699meq63t..xn--1ug85gn777ahze", .status = 14} /* 548 */,
    {.source = (const lxb_char_t *) "xn--1-xmb999meq63t..xn--1ug85gn777ahze", .ascii = (const lxb_char_t *) "xn--1-xmb999meq63t..xn--1ug85gn777ahze", .status = 14} /* 549 */,
    {.source = (const lxb_char_t *) "򔭜Σᡱ⒈.<\u0338𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 550 */,
    {.source = (const lxb_char_t *) "򔭜Σᡱ⒈.≮𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 551 */,
    {.source = (const lxb_char_t *) "򔭜σᡱ⒈.≮𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 552 */,
    {.source = (const lxb_char_t *) "򔭜σᡱ⒈.<\u0338𑄳\u200D𐮍", .ascii = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 553 */,
    {.source = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--gdh5392g6sd", .ascii = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--gdh5392g6sd", .status = 8} /* 554 */,
    {.source = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--1ug85gn777ahze", .ascii = (const lxb_char_t *) "xn--4xa207hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 555 */,
    {.source = (const lxb_char_t *) "xn--3xa407hkzinr77u.xn--1ug85gn777ahze", .ascii = (const lxb_char_t *) "xn--3xa407hkzinr77u.xn--1ug85gn777ahze", .status = 8} /* 556 */,
    {.source = (const lxb_char_t *) "\u3164\u094DႠ\u17D0.\u180B", .ascii = (const lxb_char_t *) "xn--n3b468azngju2a.", .status = 4} /* 557 */,
    {.source = (const lxb_char_t *) "\u1160\u094DႠ\u17D0.\u180B", .ascii = (const lxb_char_t *) "xn--n3b468aoqa89r.", .status = 4} /* 558 */,
    {.source = (const lxb_char_t *) "\u1160\u094Dⴀ\u17D0.\u180B", .ascii = (const lxb_char_t *) "xn--n3b742bkqf4ty.", .status = 4} /* 559 */,
    {.source = (const lxb_char_t *) "xn--n3b742bkqf4ty.", .ascii = (const lxb_char_t *) "xn--n3b742bkqf4ty.", .status = 4} /* 560 */,
    {.source = (const lxb_char_t *) "xn--n3b468aoqa89r.", .ascii = (const lxb_char_t *) "xn--n3b468aoqa89r.", .status = 4} /* 561 */,
    {.source = (const lxb_char_t *) "\u3164\u094Dⴀ\u17D0.\u180B", .ascii = (const lxb_char_t *) "xn--n3b445e53po6d.", .status = 4} /* 562 */,
    {.source = (const lxb_char_t *) "xn--n3b445e53po6d.", .ascii = (const lxb_char_t *) "xn--n3b445e53po6d.", .status = 4} /* 563 */,
    {.source = (const lxb_char_t *) "xn--n3b468azngju2a.", .ascii = (const lxb_char_t *) "xn--n3b468azngju2a.", .status = 4} /* 564 */,
    {.source = (const lxb_char_t *) "❣\u200D．\u09CD𑰽\u0612\uA929", .ascii = (const lxb_char_t *) "xn--1ugy10a.xn--0fb32q3w7q2g4d", .status = 8} /* 565 */,
    {.source = (const lxb_char_t *) "❣\u200D.\u09CD𑰽\u0612\uA929", .ascii = (const lxb_char_t *) "xn--1ugy10a.xn--0fb32q3w7q2g4d", .status = 8} /* 566 */,
    {.source = (const lxb_char_t *) "xn--pei.xn--0fb32q3w7q2g4d", .ascii = (const lxb_char_t *) "xn--pei.xn--0fb32q3w7q2g4d", .status = 4} /* 567 */,
    {.source = (const lxb_char_t *) "xn--1ugy10a.xn--0fb32q3w7q2g4d", .ascii = (const lxb_char_t *) "xn--1ugy10a.xn--0fb32q3w7q2g4d", .status = 8} /* 568 */,
    {.source = (const lxb_char_t *) "≮𐳺𐹄.≯񪮸ꡅ", .ascii = (const lxb_char_t *) "xn--gdh7943gk2a.xn--hdh1383c5e36c", .status = 8} /* 569 */,
    {.source = (const lxb_char_t *) "<\u0338𐳺𐹄.>\u0338񪮸ꡅ", .ascii = (const lxb_char_t *) "xn--gdh7943gk2a.xn--hdh1383c5e36c", .status = 8} /* 570 */,
    {.source = (const lxb_char_t *) "xn--gdh7943gk2a.xn--hdh1383c5e36c", .ascii = (const lxb_char_t *) "xn--gdh7943gk2a.xn--hdh1383c5e36c", .status = 8} /* 571 */,
    {.source = (const lxb_char_t *) "\u0CCC𐧅𐳏󠲺｡\u0CCDᠦ", .ascii = (const lxb_char_t *) "xn--7tc6360ky5bn2732c.xn--8tc429c", .status = 12} /* 572 */,
    {.source = (const lxb_char_t *) "\u0CCC𐧅𐳏󠲺。\u0CCDᠦ", .ascii = (const lxb_char_t *) "xn--7tc6360ky5bn2732c.xn--8tc429c", .status = 12} /* 573 */,
    {.source = (const lxb_char_t *) "\u0CCC𐧅𐲏󠲺。\u0CCDᠦ", .ascii = (const lxb_char_t *) "xn--7tc6360ky5bn2732c.xn--8tc429c", .status = 12} /* 574 */,
    {.source = (const lxb_char_t *) "xn--7tc6360ky5bn2732c.xn--8tc429c", .ascii = (const lxb_char_t *) "xn--7tc6360ky5bn2732c.xn--8tc429c", .status = 12} /* 575 */,
    {.source = (const lxb_char_t *) "\u0CCC𐧅𐲏󠲺｡\u0CCDᠦ", .ascii = (const lxb_char_t *) "xn--7tc6360ky5bn2732c.xn--8tc429c", .status = 12} /* 576 */,
    {.source = (const lxb_char_t *) "\u0349。𧡫", .ascii = (const lxb_char_t *) "xn--nua.xn--bc6k", .status = 4} /* 577 */,
    {.source = (const lxb_char_t *) "xn--nua.xn--bc6k", .ascii = (const lxb_char_t *) "xn--nua.xn--bc6k", .status = 4} /* 578 */,
    {.source = (const lxb_char_t *) "𑰿󠅦．\u1160", .ascii = (const lxb_char_t *) "xn--ok3d.xn--psd", .status = 8} /* 579 */,
    {.source = (const lxb_char_t *) "𑰿󠅦.\u1160", .ascii = (const lxb_char_t *) "xn--ok3d.xn--psd", .status = 8} /* 580 */,
    {.source = (const lxb_char_t *) "xn--ok3d.xn--psd", .ascii = (const lxb_char_t *) "xn--ok3d.xn--psd", .status = 8} /* 581 */,
    {.source = (const lxb_char_t *) "-𞤆\u200D。󸼄𞳒", .ascii = (const lxb_char_t *) "xn----ugnx367r.xn--846h96596c", .status = 24} /* 582 */,
    {.source = (const lxb_char_t *) "-𞤨\u200D。󸼄𞳒", .ascii = (const lxb_char_t *) "xn----ugnx367r.xn--846h96596c", .status = 24} /* 583 */,
    {.source = (const lxb_char_t *) "xn----ni8r.xn--846h96596c", .ascii = (const lxb_char_t *) "xn----ni8r.xn--846h96596c", .status = 20} /* 584 */,
    {.source = (const lxb_char_t *) "xn----ugnx367r.xn--846h96596c", .ascii = (const lxb_char_t *) "xn----ugnx367r.xn--846h96596c", .status = 24} /* 585 */,
    {.source = (const lxb_char_t *) "ꡏ󠇶≯𳾽。\u1DFD⾇滸𐹰", .ascii = (const lxb_char_t *) "xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", .status = 12} /* 586 */,
    {.source = (const lxb_char_t *) "ꡏ󠇶>\u0338𳾽。\u1DFD⾇滸𐹰", .ascii = (const lxb_char_t *) "xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", .status = 12} /* 587 */,
    {.source = (const lxb_char_t *) "ꡏ󠇶≯𳾽。\u1DFD舛滸𐹰", .ascii = (const lxb_char_t *) "xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", .status = 12} /* 588 */,
    {.source = (const lxb_char_t *) "ꡏ󠇶>\u0338𳾽。\u1DFD舛滸𐹰", .ascii = (const lxb_char_t *) "xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", .status = 12} /* 589 */,
    {.source = (const lxb_char_t *) "xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", .ascii = (const lxb_char_t *) "xn--hdh7483cu6twwki8e.xn--yfg0765a58l0n6k", .status = 12} /* 590 */,
    {.source = (const lxb_char_t *) "蔏｡𑰺", .ascii = (const lxb_char_t *) "xn--uy1a.xn--jk3d", .status = 4} /* 591 */,
    {.source = (const lxb_char_t *) "蔏。𑰺", .ascii = (const lxb_char_t *) "xn--uy1a.xn--jk3d", .status = 4} /* 592 */,
    {.source = (const lxb_char_t *) "xn--uy1a.xn--jk3d", .ascii = (const lxb_char_t *) "xn--uy1a.xn--jk3d", .status = 4} /* 593 */,
    {.source = (const lxb_char_t *) "𝟿𐮋。󠄊", .ascii = (const lxb_char_t *) "xn--9-rv5i.", .status = 4} /* 594 */,
    {.source = (const lxb_char_t *) "9𐮋。󠄊", .ascii = (const lxb_char_t *) "xn--9-rv5i.", .status = 4} /* 595 */,
    {.source = (const lxb_char_t *) "xn--9-rv5i.", .ascii = (const lxb_char_t *) "xn--9-rv5i.", .status = 4} /* 596 */,
    {.source = (const lxb_char_t *) "󟇇-䟖F。\u07CB⒈\u0662", .ascii = (const lxb_char_t *) "xn---f-mz8b08788k.xn--bib53ev44d", .status = 8} /* 597 */,
    {.source = (const lxb_char_t *) "󟇇-䟖F。\u07CB1.\u0662", .ascii = (const lxb_char_t *) "xn---f-mz8b08788k.xn--1-ybd.xn--bib", .status = 8} /* 598 */,
    {.source = (const lxb_char_t *) "󟇇-䟖f。\u07CB1.\u0662", .ascii = (const lxb_char_t *) "xn---f-mz8b08788k.xn--1-ybd.xn--bib", .status = 8} /* 599 */,
    {.source = (const lxb_char_t *) "xn---f-mz8b08788k.xn--1-ybd.xn--bib", .ascii = (const lxb_char_t *) "xn---f-mz8b08788k.xn--1-ybd.xn--bib", .status = 8} /* 600 */,
    {.source = (const lxb_char_t *) "󟇇-䟖f。\u07CB⒈\u0662", .ascii = (const lxb_char_t *) "xn---f-mz8b08788k.xn--bib53ev44d", .status = 8} /* 601 */,
    {.source = (const lxb_char_t *) "xn---f-mz8b08788k.xn--bib53ev44d", .ascii = (const lxb_char_t *) "xn---f-mz8b08788k.xn--bib53ev44d", .status = 8} /* 602 */,
    {.source = (const lxb_char_t *) "\u200C｡𐹺", .ascii = (const lxb_char_t *) "xn--0ug.xn--yo0d", .status = 8} /* 603 */,
    {.source = (const lxb_char_t *) "\u200C。𐹺", .ascii = (const lxb_char_t *) "xn--0ug.xn--yo0d", .status = 8} /* 604 */,
    {.source = (const lxb_char_t *) ".xn--yo0d", .ascii = (const lxb_char_t *) ".xn--yo0d", .status = 10} /* 605 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--yo0d", .ascii = (const lxb_char_t *) "xn--0ug.xn--yo0d", .status = 8} /* 606 */,
    {.source = (const lxb_char_t *) "𐡆.≯\u200C-𞥀", .ascii = (const lxb_char_t *) "xn--le9c.xn----rgn40iy359e", .status = 8} /* 607 */,
    {.source = (const lxb_char_t *) "𐡆.>\u0338\u200C-𞥀", .ascii = (const lxb_char_t *) "xn--le9c.xn----rgn40iy359e", .status = 8} /* 608 */,
    {.source = (const lxb_char_t *) "𐡆.>\u0338\u200C-𞤞", .ascii = (const lxb_char_t *) "xn--le9c.xn----rgn40iy359e", .status = 8} /* 609 */,
    {.source = (const lxb_char_t *) "𐡆.≯\u200C-𞤞", .ascii = (const lxb_char_t *) "xn--le9c.xn----rgn40iy359e", .status = 8} /* 610 */,
    {.source = (const lxb_char_t *) "xn--le9c.xn----ogo9956r", .ascii = (const lxb_char_t *) "xn--le9c.xn----ogo9956r", .status = 4} /* 611 */,
    {.source = (const lxb_char_t *) "xn--le9c.xn----rgn40iy359e", .ascii = (const lxb_char_t *) "xn--le9c.xn----rgn40iy359e", .status = 8} /* 612 */,
    {.source = (const lxb_char_t *) "󠁀-。≠\uFCD7", .ascii = (const lxb_char_t *) "xn----f411m.xn--rgb7c611j", .status = 12} /* 613 */,
    {.source = (const lxb_char_t *) "󠁀-。=\u0338\uFCD7", .ascii = (const lxb_char_t *) "xn----f411m.xn--rgb7c611j", .status = 12} /* 614 */,
    {.source = (const lxb_char_t *) "󠁀-。≠\u0647\u062C", .ascii = (const lxb_char_t *) "xn----f411m.xn--rgb7c611j", .status = 12} /* 615 */,
    {.source = (const lxb_char_t *) "󠁀-。=\u0338\u0647\u062C", .ascii = (const lxb_char_t *) "xn----f411m.xn--rgb7c611j", .status = 12} /* 616 */,
    {.source = (const lxb_char_t *) "xn----f411m.xn--rgb7c611j", .ascii = (const lxb_char_t *) "xn----f411m.xn--rgb7c611j", .status = 12} /* 617 */,
    {.source = (const lxb_char_t *) "񻬹𑈵。\u200D𞨶", .ascii = (const lxb_char_t *) "xn--8g1d12120a.xn--1ug6651p", .status = 12} /* 618 */,
    {.source = (const lxb_char_t *) "xn--8g1d12120a.xn--5l6h", .ascii = (const lxb_char_t *) "xn--8g1d12120a.xn--5l6h", .status = 4} /* 619 */,
    {.source = (const lxb_char_t *) "xn--8g1d12120a.xn--1ug6651p", .ascii = (const lxb_char_t *) "xn--8g1d12120a.xn--1ug6651p", .status = 12} /* 620 */,
    {.source = (const lxb_char_t *) "𑋧\uA9C02｡㧉򒖄", .ascii = (const lxb_char_t *) "xn--2-5z4eu89y.xn--97l02706d", .status = 8} /* 621 */,
    {.source = (const lxb_char_t *) "𑋧\uA9C02。㧉򒖄", .ascii = (const lxb_char_t *) "xn--2-5z4eu89y.xn--97l02706d", .status = 8} /* 622 */,
    {.source = (const lxb_char_t *) "xn--2-5z4eu89y.xn--97l02706d", .ascii = (const lxb_char_t *) "xn--2-5z4eu89y.xn--97l02706d", .status = 8} /* 623 */,
    {.source = (const lxb_char_t *) "\u200C𽬄𐹴𞩥。≯6", .ascii = (const lxb_char_t *) "xn--0ug7105gf5wfxepq.xn--6-ogo", .status = 12} /* 624 */,
    {.source = (const lxb_char_t *) "\u200C𽬄𐹴𞩥。>\u03386", .ascii = (const lxb_char_t *) "xn--0ug7105gf5wfxepq.xn--6-ogo", .status = 12} /* 625 */,
    {.source = (const lxb_char_t *) "xn--so0du768aim9m.xn--6-ogo", .ascii = (const lxb_char_t *) "xn--so0du768aim9m.xn--6-ogo", .status = 16} /* 626 */,
    {.source = (const lxb_char_t *) "xn--0ug7105gf5wfxepq.xn--6-ogo", .ascii = (const lxb_char_t *) "xn--0ug7105gf5wfxepq.xn--6-ogo", .status = 12} /* 627 */,
    {.source = (const lxb_char_t *) "𑁿．𐹦𻞵-\u200D", .ascii = (const lxb_char_t *) "xn--q30d.xn----ugn1088hfsxv", .status = 16} /* 628 */,
    {.source = (const lxb_char_t *) "𑁿.𐹦𻞵-\u200D", .ascii = (const lxb_char_t *) "xn--q30d.xn----ugn1088hfsxv", .status = 16} /* 629 */,
    {.source = (const lxb_char_t *) "xn--q30d.xn----i26i1299n", .ascii = (const lxb_char_t *) "xn--q30d.xn----i26i1299n", .status = 16} /* 630 */,
    {.source = (const lxb_char_t *) "xn--q30d.xn----ugn1088hfsxv", .ascii = (const lxb_char_t *) "xn--q30d.xn----ugn1088hfsxv", .status = 16} /* 631 */,
    {.source = (const lxb_char_t *) "⤸ς𺱀｡\uFFA0", .ascii = (const lxb_char_t *) "xn--3xa392qmp03d.xn--cl7c", .status = 4} /* 632 */,
    {.source = (const lxb_char_t *) "⤸ς𺱀。\u1160", .ascii = (const lxb_char_t *) "xn--3xa392qmp03d.xn--psd", .status = 4} /* 633 */,
    {.source = (const lxb_char_t *) "⤸Σ𺱀。\u1160", .ascii = (const lxb_char_t *) "xn--4xa192qmp03d.xn--psd", .status = 4} /* 634 */,
    {.source = (const lxb_char_t *) "⤸σ𺱀。\u1160", .ascii = (const lxb_char_t *) "xn--4xa192qmp03d.xn--psd", .status = 4} /* 635 */,
    {.source = (const lxb_char_t *) "xn--4xa192qmp03d.xn--psd", .ascii = (const lxb_char_t *) "xn--4xa192qmp03d.xn--psd", .status = 4} /* 636 */,
    {.source = (const lxb_char_t *) "xn--3xa392qmp03d.xn--psd", .ascii = (const lxb_char_t *) "xn--3xa392qmp03d.xn--psd", .status = 4} /* 637 */,
    {.source = (const lxb_char_t *) "⤸Σ𺱀｡\uFFA0", .ascii = (const lxb_char_t *) "xn--4xa192qmp03d.xn--cl7c", .status = 4} /* 638 */,
    {.source = (const lxb_char_t *) "⤸σ𺱀｡\uFFA0", .ascii = (const lxb_char_t *) "xn--4xa192qmp03d.xn--cl7c", .status = 4} /* 639 */,
    {.source = (const lxb_char_t *) "xn--4xa192qmp03d.xn--cl7c", .ascii = (const lxb_char_t *) "xn--4xa192qmp03d.xn--cl7c", .status = 4} /* 640 */,
    {.source = (const lxb_char_t *) "xn--3xa392qmp03d.xn--cl7c", .ascii = (const lxb_char_t *) "xn--3xa392qmp03d.xn--cl7c", .status = 4} /* 641 */,
    {.source = (const lxb_char_t *) "\u0765\u1035𐫔\u06D5.𐦬𑋪Ⴃ", .ascii = (const lxb_char_t *) "xn--llb10as9tqp5y.xn--bnd9168j21f", .status = 12} /* 642 */,
    {.source = (const lxb_char_t *) "\u0765\u1035𐫔\u06D5.𐦬𑋪ⴃ", .ascii = (const lxb_char_t *) "xn--llb10as9tqp5y.xn--ukj7371e21f", .status = 8} /* 643 */,
    {.source = (const lxb_char_t *) "xn--llb10as9tqp5y.xn--ukj7371e21f", .ascii = (const lxb_char_t *) "xn--llb10as9tqp5y.xn--ukj7371e21f", .status = 8} /* 644 */,
    {.source = (const lxb_char_t *) "xn--llb10as9tqp5y.xn--bnd9168j21f", .ascii = (const lxb_char_t *) "xn--llb10as9tqp5y.xn--bnd9168j21f", .status = 12} /* 645 */,
    {.source = (const lxb_char_t *) "\u0661\u1B44-킼.\u1BAA\u0616\u066C≯", .ascii = (const lxb_char_t *) "xn----9pc551nk39n.xn--4fb6o571degg", .status = 16} /* 646 */,
    {.source = (const lxb_char_t *) "\u0661\u1B44-킼.\u1BAA\u0616\u066C>\u0338", .ascii = (const lxb_char_t *) "xn----9pc551nk39n.xn--4fb6o571degg", .status = 16} /* 647 */,
    {.source = (const lxb_char_t *) "xn----9pc551nk39n.xn--4fb6o571degg", .ascii = (const lxb_char_t *) "xn----9pc551nk39n.xn--4fb6o571degg", .status = 16} /* 648 */,
    {.source = (const lxb_char_t *) "-。\u06C2\u0604򅖡𑓂", .ascii = (const lxb_char_t *) "-.xn--mfb39a7208dzgs3d", .status = 20} /* 649 */,
    {.source = (const lxb_char_t *) "-。\u06C1\u0654\u0604򅖡𑓂", .ascii = (const lxb_char_t *) "-.xn--mfb39a7208dzgs3d", .status = 20} /* 650 */,
    {.source = (const lxb_char_t *) "-.xn--mfb39a7208dzgs3d", .ascii = (const lxb_char_t *) "-.xn--mfb39a7208dzgs3d", .status = 20} /* 651 */,
    {.source = (const lxb_char_t *) "\u200D󯑖󠁐．\u05BD𙮰ꡝ𐋡", .ascii = (const lxb_char_t *) "xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg", .status = 12} /* 652 */,
    {.source = (const lxb_char_t *) "\u200D󯑖󠁐.\u05BD𙮰ꡝ𐋡", .ascii = (const lxb_char_t *) "xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg", .status = 12} /* 653 */,
    {.source = (const lxb_char_t *) "xn--b726ey18m.xn--ldb8734fg0qcyzzg", .ascii = (const lxb_char_t *) "xn--b726ey18m.xn--ldb8734fg0qcyzzg", .status = 8} /* 654 */,
    {.source = (const lxb_char_t *) "xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg", .ascii = (const lxb_char_t *) "xn--1ug66101lt8me.xn--ldb8734fg0qcyzzg", .status = 12} /* 655 */,
    {.source = (const lxb_char_t *) "︒􃈵ς񀠇｡𐮈", .ascii = (const lxb_char_t *) "xn--3xa3729jwz5t7gl5f.xn--f29c", .status = 8} /* 656 */,
    {.source = (const lxb_char_t *) "。􃈵ς񀠇。𐮈", .ascii = (const lxb_char_t *) ".xn--3xa88573c7n64d.xn--f29c", .status = 10} /* 657 */,
    {.source = (const lxb_char_t *) "。􃈵Σ񀠇。𐮈", .ascii = (const lxb_char_t *) ".xn--4xa68573c7n64d.xn--f29c", .status = 10} /* 658 */,
    {.source = (const lxb_char_t *) "。􃈵σ񀠇。𐮈", .ascii = (const lxb_char_t *) ".xn--4xa68573c7n64d.xn--f29c", .status = 10} /* 659 */,
    {.source = (const lxb_char_t *) ".xn--4xa68573c7n64d.xn--f29c", .ascii = (const lxb_char_t *) ".xn--4xa68573c7n64d.xn--f29c", .status = 10} /* 660 */,
    {.source = (const lxb_char_t *) ".xn--3xa88573c7n64d.xn--f29c", .ascii = (const lxb_char_t *) ".xn--3xa88573c7n64d.xn--f29c", .status = 10} /* 661 */,
    {.source = (const lxb_char_t *) "︒􃈵Σ񀠇｡𐮈", .ascii = (const lxb_char_t *) "xn--4xa1729jwz5t7gl5f.xn--f29c", .status = 8} /* 662 */,
    {.source = (const lxb_char_t *) "︒􃈵σ񀠇｡𐮈", .ascii = (const lxb_char_t *) "xn--4xa1729jwz5t7gl5f.xn--f29c", .status = 8} /* 663 */,
    {.source = (const lxb_char_t *) "xn--4xa1729jwz5t7gl5f.xn--f29c", .ascii = (const lxb_char_t *) "xn--4xa1729jwz5t7gl5f.xn--f29c", .status = 8} /* 664 */,
    {.source = (const lxb_char_t *) "xn--3xa3729jwz5t7gl5f.xn--f29c", .ascii = (const lxb_char_t *) "xn--3xa3729jwz5t7gl5f.xn--f29c", .status = 8} /* 665 */,
    {.source = (const lxb_char_t *) "\u07D9．\u06EE󆾃≯󠅲", .ascii = (const lxb_char_t *) "xn--0sb.xn--bmb691l0524t", .status = 12} /* 666 */,
    {.source = (const lxb_char_t *) "\u07D9．\u06EE󆾃>\u0338󠅲", .ascii = (const lxb_char_t *) "xn--0sb.xn--bmb691l0524t", .status = 12} /* 667 */,
    {.source = (const lxb_char_t *) "\u07D9.\u06EE󆾃≯󠅲", .ascii = (const lxb_char_t *) "xn--0sb.xn--bmb691l0524t", .status = 12} /* 668 */,
    {.source = (const lxb_char_t *) "\u07D9.\u06EE󆾃>\u0338󠅲", .ascii = (const lxb_char_t *) "xn--0sb.xn--bmb691l0524t", .status = 12} /* 669 */,
    {.source = (const lxb_char_t *) "xn--0sb.xn--bmb691l0524t", .ascii = (const lxb_char_t *) "xn--0sb.xn--bmb691l0524t", .status = 12} /* 670 */,
    {.source = (const lxb_char_t *) "\u1A73󚙸.𐭍", .ascii = (const lxb_char_t *) "xn--2of22352n.xn--q09c", .status = 12} /* 671 */,
    {.source = (const lxb_char_t *) "xn--2of22352n.xn--q09c", .ascii = (const lxb_char_t *) "xn--2of22352n.xn--q09c", .status = 12} /* 672 */,
    {.source = (const lxb_char_t *) "⒉󠊓≠｡Ⴟ⬣Ⴈ", .ascii = (const lxb_char_t *) "xn--1ch07f91401d.xn--gnd9b297j", .status = 4} /* 673 */,
    {.source = (const lxb_char_t *) "⒉󠊓=\u0338｡Ⴟ⬣Ⴈ", .ascii = (const lxb_char_t *) "xn--1ch07f91401d.xn--gnd9b297j", .status = 4} /* 674 */,
    {.source = (const lxb_char_t *) "2.󠊓≠。Ⴟ⬣Ⴈ", .ascii = (const lxb_char_t *) "2.xn--1chz4101l.xn--gnd9b297j", .status = 4} /* 675 */,
    {.source = (const lxb_char_t *) "2.󠊓=\u0338。Ⴟ⬣Ⴈ", .ascii = (const lxb_char_t *) "2.xn--1chz4101l.xn--gnd9b297j", .status = 4} /* 676 */,
    {.source = (const lxb_char_t *) "2.󠊓=\u0338。ⴟ⬣ⴈ", .ascii = (const lxb_char_t *) "2.xn--1chz4101l.xn--45iz7d6b", .status = 4} /* 677 */,
    {.source = (const lxb_char_t *) "2.󠊓≠。ⴟ⬣ⴈ", .ascii = (const lxb_char_t *) "2.xn--1chz4101l.xn--45iz7d6b", .status = 4} /* 678 */,
    {.source = (const lxb_char_t *) "2.xn--1chz4101l.xn--45iz7d6b", .ascii = (const lxb_char_t *) "2.xn--1chz4101l.xn--45iz7d6b", .status = 4} /* 679 */,
    {.source = (const lxb_char_t *) "2.xn--1chz4101l.xn--gnd9b297j", .ascii = (const lxb_char_t *) "2.xn--1chz4101l.xn--gnd9b297j", .status = 4} /* 680 */,
    {.source = (const lxb_char_t *) "⒉󠊓=\u0338｡ⴟ⬣ⴈ", .ascii = (const lxb_char_t *) "xn--1ch07f91401d.xn--45iz7d6b", .status = 4} /* 681 */,
    {.source = (const lxb_char_t *) "⒉󠊓≠｡ⴟ⬣ⴈ", .ascii = (const lxb_char_t *) "xn--1ch07f91401d.xn--45iz7d6b", .status = 4} /* 682 */,
    {.source = (const lxb_char_t *) "xn--1ch07f91401d.xn--45iz7d6b", .ascii = (const lxb_char_t *) "xn--1ch07f91401d.xn--45iz7d6b", .status = 4} /* 683 */,
    {.source = (const lxb_char_t *) "xn--1ch07f91401d.xn--gnd9b297j", .ascii = (const lxb_char_t *) "xn--1ch07f91401d.xn--gnd9b297j", .status = 4} /* 684 */,
    {.source = (const lxb_char_t *) "-󠉱\u0FB8Ⴥ。-𐹽\u0774𞣑", .ascii = (const lxb_char_t *) "xn----xmg12fm2555h.xn----05c4213ryr0g", .status = 12} /* 685 */,
    {.source = (const lxb_char_t *) "-󠉱\u0FB8ⴥ。-𐹽\u0774𞣑", .ascii = (const lxb_char_t *) "xn----xmg317tgv352a.xn----05c4213ryr0g", .status = 12} /* 686 */,
    {.source = (const lxb_char_t *) "xn----xmg317tgv352a.xn----05c4213ryr0g", .ascii = (const lxb_char_t *) "xn----xmg317tgv352a.xn----05c4213ryr0g", .status = 12} /* 687 */,
    {.source = (const lxb_char_t *) "xn----xmg12fm2555h.xn----05c4213ryr0g", .ascii = (const lxb_char_t *) "xn----xmg12fm2555h.xn----05c4213ryr0g", .status = 12} /* 688 */,
    {.source = (const lxb_char_t *) "\u0659。𑄴︒\u0627\u07DD", .ascii = (const lxb_char_t *) "xn--1hb.xn--mgb09fp820c08pa", .status = 12} /* 689 */,
    {.source = (const lxb_char_t *) "\u0659。𑄴。\u0627\u07DD", .ascii = (const lxb_char_t *) "xn--1hb.xn--w80d.xn--mgb09f", .status = 8} /* 690 */,
    {.source = (const lxb_char_t *) "xn--1hb.xn--w80d.xn--mgb09f", .ascii = (const lxb_char_t *) "xn--1hb.xn--w80d.xn--mgb09f", .status = 8} /* 691 */,
    {.source = (const lxb_char_t *) "xn--1hb.xn--mgb09fp820c08pa", .ascii = (const lxb_char_t *) "xn--1hb.xn--mgb09fp820c08pa", .status = 12} /* 692 */,
    {.source = (const lxb_char_t *) "Ⴙ\u0638.󠆓\u200D", .ascii = (const lxb_char_t *) "xn--3gb194c.xn--1ug", .status = 20} /* 693 */,
    {.source = (const lxb_char_t *) "ⴙ\u0638.󠆓\u200D", .ascii = (const lxb_char_t *) "xn--3gb910r.xn--1ug", .status = 16} /* 694 */,
    {.source = (const lxb_char_t *) "xn--3gb910r.", .ascii = (const lxb_char_t *) "xn--3gb910r.", .status = 8} /* 695 */,
    {.source = (const lxb_char_t *) "xn--3gb910r.xn--1ug", .ascii = (const lxb_char_t *) "xn--3gb910r.xn--1ug", .status = 16} /* 696 */,
    {.source = (const lxb_char_t *) "xn--3gb194c.", .ascii = (const lxb_char_t *) "xn--3gb194c.", .status = 12} /* 697 */,
    {.source = (const lxb_char_t *) "xn--3gb194c.xn--1ug", .ascii = (const lxb_char_t *) "xn--3gb194c.xn--1ug", .status = 20} /* 698 */,
    {.source = (const lxb_char_t *) "󠆸｡₆０𐺧\u0756", .ascii = (const lxb_char_t *) ".xn--60-cke9470y", .status = 10} /* 699 */,
    {.source = (const lxb_char_t *) "󠆸。60𐺧\u0756", .ascii = (const lxb_char_t *) ".xn--60-cke9470y", .status = 10} /* 700 */,
    {.source = (const lxb_char_t *) ".xn--60-cke9470y", .ascii = (const lxb_char_t *) ".xn--60-cke9470y", .status = 10} /* 701 */,
    {.source = (const lxb_char_t *) "6\u084F｡-𑈴", .ascii = (const lxb_char_t *) "xn--6-jjd.xn----6n8i", .status = 8} /* 702 */,
    {.source = (const lxb_char_t *) "6\u084F。-𑈴", .ascii = (const lxb_char_t *) "xn--6-jjd.xn----6n8i", .status = 8} /* 703 */,
    {.source = (const lxb_char_t *) "xn--6-jjd.xn----6n8i", .ascii = (const lxb_char_t *) "xn--6-jjd.xn----6n8i", .status = 8} /* 704 */,
    {.source = (const lxb_char_t *) "\u200D񋌿𐹰｡\u0ACDς𞰎\u08D6", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--3xa41xcwbfz15g", .status = 16} /* 705 */,
    {.source = (const lxb_char_t *) "\u200D񋌿𐹰。\u0ACDς𞰎\u08D6", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--3xa41xcwbfz15g", .status = 16} /* 706 */,
    {.source = (const lxb_char_t *) "\u200D񋌿𐹰。\u0ACDΣ𞰎\u08D6", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--4xa21xcwbfz15g", .status = 16} /* 707 */,
    {.source = (const lxb_char_t *) "\u200D񋌿𐹰。\u0ACDσ𞰎\u08D6", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--4xa21xcwbfz15g", .status = 16} /* 708 */,
    {.source = (const lxb_char_t *) "xn--oo0d1330n.xn--4xa21xcwbfz15g", .ascii = (const lxb_char_t *) "xn--oo0d1330n.xn--4xa21xcwbfz15g", .status = 20} /* 709 */,
    {.source = (const lxb_char_t *) "xn--1ugx105gq26y.xn--4xa21xcwbfz15g", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--4xa21xcwbfz15g", .status = 16} /* 710 */,
    {.source = (const lxb_char_t *) "xn--1ugx105gq26y.xn--3xa41xcwbfz15g", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--3xa41xcwbfz15g", .status = 16} /* 711 */,
    {.source = (const lxb_char_t *) "\u200D񋌿𐹰｡\u0ACDΣ𞰎\u08D6", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--4xa21xcwbfz15g", .status = 16} /* 712 */,
    {.source = (const lxb_char_t *) "\u200D񋌿𐹰｡\u0ACDσ𞰎\u08D6", .ascii = (const lxb_char_t *) "xn--1ugx105gq26y.xn--4xa21xcwbfz15g", .status = 16} /* 713 */,
    {.source = (const lxb_char_t *) "⒈񟄜Ⴓ⒪．\u0DCA򘘶\u088B𐹢", .ascii = (const lxb_char_t *) "xn--rnd762h7cx3027d.xn--3xb99xpx1yoes3e", .status = 12} /* 714 */,
    {.source = (const lxb_char_t *) "1.񟄜Ⴓ(o).\u0DCA򘘶\u088B𐹢", .ascii = (const lxb_char_t *) "1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e", .status = 16} /* 715 */,
    {.source = (const lxb_char_t *) "1.񟄜ⴓ(o).\u0DCA򘘶\u088B𐹢", .ascii = (const lxb_char_t *) "1.xn--(o)-ej1bu5389e.xn--3xb99xpx1yoes3e", .status = 16} /* 716 */,
    {.source = (const lxb_char_t *) "1.񟄜Ⴓ(O).\u0DCA򘘶\u088B𐹢", .ascii = (const lxb_char_t *) "1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e", .status = 16} /* 717 */,
    {.source = (const lxb_char_t *) "1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e", .ascii = (const lxb_char_t *) "1.xn--(o)-7sn88849j.xn--3xb99xpx1yoes3e", .status = 16} /* 718 */,
    {.source = (const lxb_char_t *) "1.xn--(o)-ej1bu5389e.xn--3xb99xpx1yoes3e", .ascii = (const lxb_char_t *) "1.xn--(o)-ej1bu5389e.xn--3xb99xpx1yoes3e", .status = 16} /* 719 */,
    {.source = (const lxb_char_t *) "⒈񟄜ⴓ⒪．\u0DCA򘘶\u088B𐹢", .ascii = (const lxb_char_t *) "xn--tsh0ds63atl31n.xn--3xb99xpx1yoes3e", .status = 12} /* 720 */,
    {.source = (const lxb_char_t *) "xn--tsh0ds63atl31n.xn--3xb99xpx1yoes3e", .ascii = (const lxb_char_t *) "xn--tsh0ds63atl31n.xn--3xb99xpx1yoes3e", .status = 12} /* 721 */,
    {.source = (const lxb_char_t *) "xn--rnd762h7cx3027d.xn--3xb99xpx1yoes3e", .ascii = (const lxb_char_t *) "xn--rnd762h7cx3027d.xn--3xb99xpx1yoes3e", .status = 12} /* 722 */,
    {.source = (const lxb_char_t *) "𞤷.𐮐𞢁𐹠\u0624", .ascii = (const lxb_char_t *) "xn--ve6h.xn--jgb1694kz0b2176a", .status = 0} /* 723 */,
    {.source = (const lxb_char_t *) "𞤷.𐮐𞢁𐹠\u0648\u0654", .ascii = (const lxb_char_t *) "xn--ve6h.xn--jgb1694kz0b2176a", .status = 0} /* 724 */,
    {.source = (const lxb_char_t *) "𞤕.𐮐𞢁𐹠\u0648\u0654", .ascii = (const lxb_char_t *) "xn--ve6h.xn--jgb1694kz0b2176a", .status = 0} /* 725 */,
    {.source = (const lxb_char_t *) "𞤕.𐮐𞢁𐹠\u0624", .ascii = (const lxb_char_t *) "xn--ve6h.xn--jgb1694kz0b2176a", .status = 0} /* 726 */,
    {.source = (const lxb_char_t *) "xn--ve6h.xn--jgb1694kz0b2176a", .ascii = (const lxb_char_t *) "xn--ve6h.xn--jgb1694kz0b2176a", .status = 0} /* 727 */,
    {.source = (const lxb_char_t *) "𐲈-｡𑄳񢌻", .ascii = (const lxb_char_t *) "xn----ue6i.xn--v80d6662t", .status = 20} /* 728 */,
    {.source = (const lxb_char_t *) "𐲈-。𑄳񢌻", .ascii = (const lxb_char_t *) "xn----ue6i.xn--v80d6662t", .status = 20} /* 729 */,
    {.source = (const lxb_char_t *) "𐳈-。𑄳񢌻", .ascii = (const lxb_char_t *) "xn----ue6i.xn--v80d6662t", .status = 20} /* 730 */,
    {.source = (const lxb_char_t *) "xn----ue6i.xn--v80d6662t", .ascii = (const lxb_char_t *) "xn----ue6i.xn--v80d6662t", .status = 20} /* 731 */,
    {.source = (const lxb_char_t *) "𐳈-｡𑄳񢌻", .ascii = (const lxb_char_t *) "xn----ue6i.xn--v80d6662t", .status = 20} /* 732 */,
    {.source = (const lxb_char_t *) "-󠉖ꡧ．󠊂񇆃🄉", .ascii = (const lxb_char_t *) "xn----hg4ei0361g.xn--207ht163h7m94c", .status = 8} /* 733 */,
    {.source = (const lxb_char_t *) "-󠉖ꡧ.󠊂񇆃8,", .ascii = (const lxb_char_t *) "xn----hg4ei0361g.xn--8,-k362evu488a", .status = 8} /* 734 */,
    {.source = (const lxb_char_t *) "xn----hg4ei0361g.xn--8,-k362evu488a", .ascii = (const lxb_char_t *) "xn----hg4ei0361g.xn--8,-k362evu488a", .status = 8} /* 735 */,
    {.source = (const lxb_char_t *) "xn----hg4ei0361g.xn--207ht163h7m94c", .ascii = (const lxb_char_t *) "xn----hg4ei0361g.xn--207ht163h7m94c", .status = 8} /* 736 */,
    {.source = (const lxb_char_t *) "󠾛󠈴臯𧔤.\u0768𝟝", .ascii = (const lxb_char_t *) "xn--zb1at733hm579ddhla.xn--5-b5c", .status = 8} /* 737 */,
    {.source = (const lxb_char_t *) "󠾛󠈴臯𧔤.\u07685", .ascii = (const lxb_char_t *) "xn--zb1at733hm579ddhla.xn--5-b5c", .status = 8} /* 738 */,
    {.source = (const lxb_char_t *) "xn--zb1at733hm579ddhla.xn--5-b5c", .ascii = (const lxb_char_t *) "xn--zb1at733hm579ddhla.xn--5-b5c", .status = 8} /* 739 */,
    {.source = (const lxb_char_t *) "≮𐹣．𝨿", .ascii = (const lxb_char_t *) "xn--gdh1504g.xn--e92h", .status = 8} /* 740 */,
    {.source = (const lxb_char_t *) "<\u0338𐹣．𝨿", .ascii = (const lxb_char_t *) "xn--gdh1504g.xn--e92h", .status = 8} /* 741 */,
    {.source = (const lxb_char_t *) "≮𐹣.𝨿", .ascii = (const lxb_char_t *) "xn--gdh1504g.xn--e92h", .status = 8} /* 742 */,
    {.source = (const lxb_char_t *) "<\u0338𐹣.𝨿", .ascii = (const lxb_char_t *) "xn--gdh1504g.xn--e92h", .status = 8} /* 743 */,
    {.source = (const lxb_char_t *) "xn--gdh1504g.xn--e92h", .ascii = (const lxb_char_t *) "xn--gdh1504g.xn--e92h", .status = 8} /* 744 */,
    {.source = (const lxb_char_t *) "𐹯ᯛ\u0A4D｡脥", .ascii = (const lxb_char_t *) "xn--ybc101g3m1p.xn--740a", .status = 4} /* 745 */,
    {.source = (const lxb_char_t *) "𐹯ᯛ\u0A4D。脥", .ascii = (const lxb_char_t *) "xn--ybc101g3m1p.xn--740a", .status = 4} /* 746 */,
    {.source = (const lxb_char_t *) "xn--ybc101g3m1p.xn--740a", .ascii = (const lxb_char_t *) "xn--ybc101g3m1p.xn--740a", .status = 4} /* 747 */,
    {.source = (const lxb_char_t *) "\u1B44\u115F𞷿򃀍.-", .ascii = (const lxb_char_t *) "xn--osd971cpx70btgt8b.-", .status = 20} /* 748 */,
    {.source = (const lxb_char_t *) "xn--osd971cpx70btgt8b.-", .ascii = (const lxb_char_t *) "xn--osd971cpx70btgt8b.-", .status = 20} /* 749 */,
    {.source = (const lxb_char_t *) "\u200C｡\u0354", .ascii = (const lxb_char_t *) "xn--0ug.xn--yua", .status = 8} /* 750 */,
    {.source = (const lxb_char_t *) "\u200C。\u0354", .ascii = (const lxb_char_t *) "xn--0ug.xn--yua", .status = 8} /* 751 */,
    {.source = (const lxb_char_t *) ".xn--yua", .ascii = (const lxb_char_t *) ".xn--yua", .status = 10} /* 752 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--yua", .ascii = (const lxb_char_t *) "xn--0ug.xn--yua", .status = 8} /* 753 */,
    {.source = (const lxb_char_t *) "𞤥󠅮．ᡄႮ", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 754 */,
    {.source = (const lxb_char_t *) "𞤥󠅮.ᡄႮ", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 755 */,
    {.source = (const lxb_char_t *) "𞤥󠅮.ᡄⴎ", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 756 */,
    {.source = (const lxb_char_t *) "𞤃󠅮.ᡄႮ", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 757 */,
    {.source = (const lxb_char_t *) "𞤃󠅮.ᡄⴎ", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 758 */,
    {.source = (const lxb_char_t *) "xn--de6h.xn--37e857h", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 759 */,
    {.source = (const lxb_char_t *) "𞤥.ᡄⴎ", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 760 */,
    {.source = (const lxb_char_t *) "𞤃.ᡄႮ", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 761 */,
    {.source = (const lxb_char_t *) "𞤃.ᡄⴎ", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 762 */,
    {.source = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 763 */,
    {.source = (const lxb_char_t *) "𞤥󠅮．ᡄⴎ", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 764 */,
    {.source = (const lxb_char_t *) "𞤃󠅮．ᡄႮ", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 765 */,
    {.source = (const lxb_char_t *) "𞤃󠅮．ᡄⴎ", .ascii = (const lxb_char_t *) "xn--de6h.xn--37e857h", .status = 0} /* 766 */,
    {.source = (const lxb_char_t *) "𞤥.ᡄႮ", .ascii = (const lxb_char_t *) "xn--de6h.xn--mnd799a", .status = 4} /* 767 */,
    {.source = (const lxb_char_t *) "𞤧𝨨Ξ．𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 768 */,
    {.source = (const lxb_char_t *) "𞤧𝨨Ξ.𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 769 */,
    {.source = (const lxb_char_t *) "𞤧𝨨ξ.𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 770 */,
    {.source = (const lxb_char_t *) "𞤅𝨨Ξ.𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 771 */,
    {.source = (const lxb_char_t *) "𞤅𝨨ξ.𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 772 */,
    {.source = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 773 */,
    {.source = (const lxb_char_t *) "𞤧𝨨ξ．𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 774 */,
    {.source = (const lxb_char_t *) "𞤅𝨨Ξ．𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 775 */,
    {.source = (const lxb_char_t *) "𞤅𝨨ξ．𪺏㛨❸", .ascii = (const lxb_char_t *) "xn--zxa5691vboja.xn--bfi293ci119b", .status = 12} /* 776 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-｡Ⴛ𐦅︒", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd2362jhgh", .status = 24} /* 777 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-｡Ⴛ𐦅︒", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd2362jhgh", .status = 24} /* 778 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-。Ⴛ𐦅。", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd4948j.", .status = 24} /* 779 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-。Ⴛ𐦅。", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd4948j.", .status = 24} /* 780 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-。ⴛ𐦅。", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlju661e.", .status = 24} /* 781 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-。ⴛ𐦅。", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlju661e.", .status = 24} /* 782 */,
    {.source = (const lxb_char_t *) "xn----e3j6620g.xn--jlju661e.", .ascii = (const lxb_char_t *) "xn----e3j6620g.xn--jlju661e.", .status = 20} /* 783 */,
    {.source = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlju661e.", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlju661e.", .status = 24} /* 784 */,
    {.source = (const lxb_char_t *) "xn----e3j6620g.xn--znd4948j.", .ascii = (const lxb_char_t *) "xn----e3j6620g.xn--znd4948j.", .status = 20} /* 785 */,
    {.source = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd4948j.", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd4948j.", .status = 24} /* 786 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-｡ⴛ𐦅︒", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlj4997dhgh", .status = 24} /* 787 */,
    {.source = (const lxb_char_t *) "᠆몆\u200C-｡ⴛ𐦅︒", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlj4997dhgh", .status = 24} /* 788 */,
    {.source = (const lxb_char_t *) "xn----e3j6620g.xn--jlj4997dhgh", .ascii = (const lxb_char_t *) "xn----e3j6620g.xn--jlj4997dhgh", .status = 20} /* 789 */,
    {.source = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlj4997dhgh", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--jlj4997dhgh", .status = 24} /* 790 */,
    {.source = (const lxb_char_t *) "xn----e3j6620g.xn--znd2362jhgh", .ascii = (const lxb_char_t *) "xn----e3j6620g.xn--znd2362jhgh", .status = 20} /* 791 */,
    {.source = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd2362jhgh", .ascii = (const lxb_char_t *) "xn----e3j425bsk1o.xn--znd2362jhgh", .status = 24} /* 792 */,
    {.source = (const lxb_char_t *) "󠾳.︒⥱\u200C𐹬", .ascii = (const lxb_char_t *) "xn--uf66e.xn--0ugz28axl3pqxna", .status = 12} /* 793 */,
    {.source = (const lxb_char_t *) "󠾳.。⥱\u200C𐹬", .ascii = (const lxb_char_t *) "xn--uf66e..xn--0ugz28as66q", .status = 18} /* 794 */,
    {.source = (const lxb_char_t *) "xn--uf66e..xn--qti2829e", .ascii = (const lxb_char_t *) "xn--uf66e..xn--qti2829e", .status = 14} /* 795 */,
    {.source = (const lxb_char_t *) "xn--uf66e..xn--0ugz28as66q", .ascii = (const lxb_char_t *) "xn--uf66e..xn--0ugz28as66q", .status = 18} /* 796 */,
    {.source = (const lxb_char_t *) "xn--uf66e.xn--qtiz073e3ik", .ascii = (const lxb_char_t *) "xn--uf66e.xn--qtiz073e3ik", .status = 8} /* 797 */,
    {.source = (const lxb_char_t *) "xn--uf66e.xn--0ugz28axl3pqxna", .ascii = (const lxb_char_t *) "xn--uf66e.xn--0ugz28axl3pqxna", .status = 12} /* 798 */,
    {.source = (const lxb_char_t *) "𐯖.𐹠Ⴑ񚇜𐫊", .ascii = (const lxb_char_t *) "xn--n49c.xn--pnd4619jwicl862o", .status = 8} /* 799 */,
    {.source = (const lxb_char_t *) "𐯖.𐹠ⴑ񚇜𐫊", .ascii = (const lxb_char_t *) "xn--n49c.xn--8kj8702ewicl862o", .status = 8} /* 800 */,
    {.source = (const lxb_char_t *) "xn--n49c.xn--8kj8702ewicl862o", .ascii = (const lxb_char_t *) "xn--n49c.xn--8kj8702ewicl862o", .status = 8} /* 801 */,
    {.source = (const lxb_char_t *) "xn--n49c.xn--pnd4619jwicl862o", .ascii = (const lxb_char_t *) "xn--n49c.xn--pnd4619jwicl862o", .status = 8} /* 802 */,
    {.source = (const lxb_char_t *) "\u0FA4񱤯．𝟭Ⴛ", .ascii = (const lxb_char_t *) "xn--0fd40533g.xn--1-q1g", .status = 8} /* 803 */,
    {.source = (const lxb_char_t *) "\u0FA4񱤯.1Ⴛ", .ascii = (const lxb_char_t *) "xn--0fd40533g.xn--1-q1g", .status = 8} /* 804 */,
    {.source = (const lxb_char_t *) "\u0FA4񱤯.1ⴛ", .ascii = (const lxb_char_t *) "xn--0fd40533g.xn--1-tws", .status = 8} /* 805 */,
    {.source = (const lxb_char_t *) "xn--0fd40533g.xn--1-tws", .ascii = (const lxb_char_t *) "xn--0fd40533g.xn--1-tws", .status = 8} /* 806 */,
    {.source = (const lxb_char_t *) "xn--0fd40533g.xn--1-q1g", .ascii = (const lxb_char_t *) "xn--0fd40533g.xn--1-q1g", .status = 8} /* 807 */,
    {.source = (const lxb_char_t *) "\u0FA4񱤯．𝟭ⴛ", .ascii = (const lxb_char_t *) "xn--0fd40533g.xn--1-tws", .status = 8} /* 808 */,
    {.source = (const lxb_char_t *) "-\u0826齀。릿𐸋", .ascii = (const lxb_char_t *) "xn----6gd0617i.xn--7y2bm55m", .status = 20} /* 809 */,
    {.source = (const lxb_char_t *) "-\u0826齀。릿𐸋", .ascii = (const lxb_char_t *) "xn----6gd0617i.xn--7y2bm55m", .status = 20} /* 810 */,
    {.source = (const lxb_char_t *) "xn----6gd0617i.xn--7y2bm55m", .ascii = (const lxb_char_t *) "xn----6gd0617i.xn--7y2bm55m", .status = 20} /* 811 */,
    {.source = (const lxb_char_t *) "󠔊\u071C鹝꾗。񾵐\u200D\u200D⏃", .ascii = (const lxb_char_t *) "xn--mnb6558e91kyq533a.xn--1uga46zs309y", .status = 16} /* 812 */,
    {.source = (const lxb_char_t *) "󠔊\u071C鹝꾗。񾵐\u200D\u200D⏃", .ascii = (const lxb_char_t *) "xn--mnb6558e91kyq533a.xn--1uga46zs309y", .status = 16} /* 813 */,
    {.source = (const lxb_char_t *) "xn--mnb6558e91kyq533a.xn--6mh27269e", .ascii = (const lxb_char_t *) "xn--mnb6558e91kyq533a.xn--6mh27269e", .status = 12} /* 814 */,
    {.source = (const lxb_char_t *) "xn--mnb6558e91kyq533a.xn--1uga46zs309y", .ascii = (const lxb_char_t *) "xn--mnb6558e91kyq533a.xn--1uga46zs309y", .status = 16} /* 815 */,
    {.source = (const lxb_char_t *) "≮．-\u0708--", .ascii = (const lxb_char_t *) "xn--gdh.xn------eqf", .status = 12} /* 816 */,
    {.source = (const lxb_char_t *) "<\u0338．-\u0708--", .ascii = (const lxb_char_t *) "xn--gdh.xn------eqf", .status = 12} /* 817 */,
    {.source = (const lxb_char_t *) "≮.-\u0708--", .ascii = (const lxb_char_t *) "xn--gdh.xn------eqf", .status = 12} /* 818 */,
    {.source = (const lxb_char_t *) "<\u0338.-\u0708--", .ascii = (const lxb_char_t *) "xn--gdh.xn------eqf", .status = 12} /* 819 */,
    {.source = (const lxb_char_t *) "xn--gdh.xn------eqf", .ascii = (const lxb_char_t *) "xn--gdh.xn------eqf", .status = 12} /* 820 */,
    {.source = (const lxb_char_t *) "𐹸󠋳。\u200Dς𝟩", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-xmb248s", .status = 12} /* 821 */,
    {.source = (const lxb_char_t *) "𐹸󠋳。\u200Dς7", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-xmb248s", .status = 12} /* 822 */,
    {.source = (const lxb_char_t *) "𐹸󠋳。\u200DΣ7", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb938s", .status = 12} /* 823 */,
    {.source = (const lxb_char_t *) "𐹸󠋳。\u200Dσ7", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb938s", .status = 12} /* 824 */,
    {.source = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb", .status = 8} /* 825 */,
    {.source = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb938s", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb938s", .status = 12} /* 826 */,
    {.source = (const lxb_char_t *) "xn--wo0di5177c.xn--7-xmb248s", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-xmb248s", .status = 12} /* 827 */,
    {.source = (const lxb_char_t *) "𐹸󠋳。\u200DΣ𝟩", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb938s", .status = 12} /* 828 */,
    {.source = (const lxb_char_t *) "𐹸󠋳。\u200Dσ𝟩", .ascii = (const lxb_char_t *) "xn--wo0di5177c.xn--7-zmb938s", .status = 12} /* 829 */,
    {.source = (const lxb_char_t *) "ς򅜌８.𞭤", .ascii = (const lxb_char_t *) "xn--8-xmb44974n.xn--su6h", .status = 4} /* 830 */,
    {.source = (const lxb_char_t *) "ς򅜌8.𞭤", .ascii = (const lxb_char_t *) "xn--8-xmb44974n.xn--su6h", .status = 4} /* 831 */,
    {.source = (const lxb_char_t *) "Σ򅜌8.𞭤", .ascii = (const lxb_char_t *) "xn--8-zmb14974n.xn--su6h", .status = 4} /* 832 */,
    {.source = (const lxb_char_t *) "σ򅜌8.𞭤", .ascii = (const lxb_char_t *) "xn--8-zmb14974n.xn--su6h", .status = 4} /* 833 */,
    {.source = (const lxb_char_t *) "xn--8-zmb14974n.xn--su6h", .ascii = (const lxb_char_t *) "xn--8-zmb14974n.xn--su6h", .status = 4} /* 834 */,
    {.source = (const lxb_char_t *) "xn--8-xmb44974n.xn--su6h", .ascii = (const lxb_char_t *) "xn--8-xmb44974n.xn--su6h", .status = 4} /* 835 */,
    {.source = (const lxb_char_t *) "Σ򅜌８.𞭤", .ascii = (const lxb_char_t *) "xn--8-zmb14974n.xn--su6h", .status = 4} /* 836 */,
    {.source = (const lxb_char_t *) "σ򅜌８.𞭤", .ascii = (const lxb_char_t *) "xn--8-zmb14974n.xn--su6h", .status = 4} /* 837 */,
    {.source = (const lxb_char_t *) "\u200Cᡑ🄀\u0684．-𐫄𑲤", .ascii = (const lxb_char_t *) "xn--9ib722gvtfi563c.xn----ek5i065b", .status = 16} /* 838 */,
    {.source = (const lxb_char_t *) "\u200Cᡑ0.\u0684.-𐫄𑲤", .ascii = (const lxb_char_t *) "xn--0-o7j263b.xn--9ib.xn----ek5i065b", .status = 12} /* 839 */,
    {.source = (const lxb_char_t *) "xn--0-o7j.xn--9ib.xn----ek5i065b", .ascii = (const lxb_char_t *) "xn--0-o7j.xn--9ib.xn----ek5i065b", .status = 8} /* 840 */,
    {.source = (const lxb_char_t *) "xn--0-o7j263b.xn--9ib.xn----ek5i065b", .ascii = (const lxb_char_t *) "xn--0-o7j263b.xn--9ib.xn----ek5i065b", .status = 12} /* 841 */,
    {.source = (const lxb_char_t *) "xn--9ib722gbw95a.xn----ek5i065b", .ascii = (const lxb_char_t *) "xn--9ib722gbw95a.xn----ek5i065b", .status = 20} /* 842 */,
    {.source = (const lxb_char_t *) "xn--9ib722gvtfi563c.xn----ek5i065b", .ascii = (const lxb_char_t *) "xn--9ib722gvtfi563c.xn----ek5i065b", .status = 16} /* 843 */,
    {.source = (const lxb_char_t *) "𖠍。𐪿넯򞵲", .ascii = (const lxb_char_t *) "xn--4e9e.xn--l60bj21opd57g", .status = 12} /* 844 */,
    {.source = (const lxb_char_t *) "𖠍。𐪿넯򞵲", .ascii = (const lxb_char_t *) "xn--4e9e.xn--l60bj21opd57g", .status = 12} /* 845 */,
    {.source = (const lxb_char_t *) "xn--4e9e.xn--l60bj21opd57g", .ascii = (const lxb_char_t *) "xn--4e9e.xn--l60bj21opd57g", .status = 12} /* 846 */,
    {.source = (const lxb_char_t *) "᠇Ⴘ。\u0603Ⴈ𝆊", .ascii = (const lxb_char_t *) "xn--wnd558a.xn--lfb465c1v87a", .status = 8} /* 847 */,
    {.source = (const lxb_char_t *) "᠇ⴘ。\u0603ⴈ𝆊", .ascii = (const lxb_char_t *) "xn--d6e009h.xn--lfb290rfu3z", .status = 8} /* 848 */,
    {.source = (const lxb_char_t *) "xn--d6e009h.xn--lfb290rfu3z", .ascii = (const lxb_char_t *) "xn--d6e009h.xn--lfb290rfu3z", .status = 8} /* 849 */,
    {.source = (const lxb_char_t *) "xn--wnd558a.xn--lfb465c1v87a", .ascii = (const lxb_char_t *) "xn--wnd558a.xn--lfb465c1v87a", .status = 8} /* 850 */,
    {.source = (const lxb_char_t *) "⒚󠋑𞤰。牣\u0667Ⴜᣥ", .ascii = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib404ccxgh00h", .status = 12} /* 851 */,
    {.source = (const lxb_char_t *) "19.󠋑𞤰。牣\u0667Ⴜᣥ", .ascii = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib404ccxgh00h", .status = 12} /* 852 */,
    {.source = (const lxb_char_t *) "19.󠋑𞤰。牣\u0667ⴜᣥ", .ascii = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib285gtxo2l9d", .status = 12} /* 853 */,
    {.source = (const lxb_char_t *) "19.󠋑𞤎。牣\u0667Ⴜᣥ", .ascii = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib404ccxgh00h", .status = 12} /* 854 */,
    {.source = (const lxb_char_t *) "19.󠋑𞤎。牣\u0667ⴜᣥ", .ascii = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib285gtxo2l9d", .status = 12} /* 855 */,
    {.source = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib285gtxo2l9d", .ascii = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib285gtxo2l9d", .status = 12} /* 856 */,
    {.source = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib404ccxgh00h", .ascii = (const lxb_char_t *) "19.xn--oe6h75760c.xn--gib404ccxgh00h", .status = 12} /* 857 */,
    {.source = (const lxb_char_t *) "⒚󠋑𞤰。牣\u0667ⴜᣥ", .ascii = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib285gtxo2l9d", .status = 12} /* 858 */,
    {.source = (const lxb_char_t *) "⒚󠋑𞤎。牣\u0667Ⴜᣥ", .ascii = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib404ccxgh00h", .status = 12} /* 859 */,
    {.source = (const lxb_char_t *) "⒚󠋑𞤎。牣\u0667ⴜᣥ", .ascii = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib285gtxo2l9d", .status = 12} /* 860 */,
    {.source = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib285gtxo2l9d", .ascii = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib285gtxo2l9d", .status = 12} /* 861 */,
    {.source = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib404ccxgh00h", .ascii = (const lxb_char_t *) "xn--cthy466n29j3e.xn--gib404ccxgh00h", .status = 12} /* 862 */,
    {.source = (const lxb_char_t *) "-𐋱𐰽⒈.Ⴓ", .ascii = (const lxb_char_t *) "xn----ecp0206g90h.xn--rnd", .status = 12} /* 863 */,
    {.source = (const lxb_char_t *) "-𐋱𐰽1..Ⴓ", .ascii = (const lxb_char_t *) "xn---1-895nq11a..xn--rnd", .status = 18} /* 864 */,
    {.source = (const lxb_char_t *) "-𐋱𐰽1..ⴓ", .ascii = (const lxb_char_t *) "xn---1-895nq11a..xn--blj", .status = 14} /* 865 */,
    {.source = (const lxb_char_t *) "xn---1-895nq11a..xn--blj", .ascii = (const lxb_char_t *) "xn---1-895nq11a..xn--blj", .status = 14} /* 866 */,
    {.source = (const lxb_char_t *) "xn---1-895nq11a..xn--rnd", .ascii = (const lxb_char_t *) "xn---1-895nq11a..xn--rnd", .status = 18} /* 867 */,
    {.source = (const lxb_char_t *) "-𐋱𐰽⒈.ⴓ", .ascii = (const lxb_char_t *) "xn----ecp0206g90h.xn--blj", .status = 12} /* 868 */,
    {.source = (const lxb_char_t *) "xn----ecp0206g90h.xn--blj", .ascii = (const lxb_char_t *) "xn----ecp0206g90h.xn--blj", .status = 12} /* 869 */,
    {.source = (const lxb_char_t *) "xn----ecp0206g90h.xn--rnd", .ascii = (const lxb_char_t *) "xn----ecp0206g90h.xn--rnd", .status = 12} /* 870 */,
    {.source = (const lxb_char_t *) "\u200C긃.榶-", .ascii = (const lxb_char_t *) "xn--0ug3307c.xn----d87b", .status = 8} /* 871 */,
    {.source = (const lxb_char_t *) "\u200C긃.榶-", .ascii = (const lxb_char_t *) "xn--0ug3307c.xn----d87b", .status = 8} /* 872 */,
    {.source = (const lxb_char_t *) "xn--ej0b.xn----d87b", .ascii = (const lxb_char_t *) "xn--ej0b.xn----d87b", .status = 4} /* 873 */,
    {.source = (const lxb_char_t *) "xn--0ug3307c.xn----d87b", .ascii = (const lxb_char_t *) "xn--0ug3307c.xn----d87b", .status = 8} /* 874 */,
    {.source = (const lxb_char_t *) "뉓泓𜵽.\u09CD\u200D", .ascii = (const lxb_char_t *) "xn--lwwp69lqs7m.xn--b7b605i", .status = 8} /* 875 */,
    {.source = (const lxb_char_t *) "뉓泓𜵽.\u09CD\u200D", .ascii = (const lxb_char_t *) "xn--lwwp69lqs7m.xn--b7b605i", .status = 8} /* 876 */,
    {.source = (const lxb_char_t *) "xn--lwwp69lqs7m.xn--b7b", .ascii = (const lxb_char_t *) "xn--lwwp69lqs7m.xn--b7b", .status = 8} /* 877 */,
    {.source = (const lxb_char_t *) "xn--lwwp69lqs7m.xn--b7b605i", .ascii = (const lxb_char_t *) "xn--lwwp69lqs7m.xn--b7b605i", .status = 8} /* 878 */,
    {.source = (const lxb_char_t *) "\u200D𐹴ß｡\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--zca770nip7n.xn--57c638l8774i", .status = 16} /* 879 */,
    {.source = (const lxb_char_t *) "\u200D𐹴ß。\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--zca770nip7n.xn--57c638l8774i", .status = 16} /* 880 */,
    {.source = (const lxb_char_t *) "\u200D𐹴SS。\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 881 */,
    {.source = (const lxb_char_t *) "\u200D𐹴ss。\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 882 */,
    {.source = (const lxb_char_t *) "\u200D𐹴Ss。\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 883 */,
    {.source = (const lxb_char_t *) "xn--ss-ti3o.xn--57c638l8774i", .ascii = (const lxb_char_t *) "xn--ss-ti3o.xn--57c638l8774i", .status = 12} /* 884 */,
    {.source = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 885 */,
    {.source = (const lxb_char_t *) "xn--zca770nip7n.xn--57c638l8774i", .ascii = (const lxb_char_t *) "xn--zca770nip7n.xn--57c638l8774i", .status = 16} /* 886 */,
    {.source = (const lxb_char_t *) "\u200D𐹴SS｡\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 887 */,
    {.source = (const lxb_char_t *) "\u200D𐹴ss｡\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 888 */,
    {.source = (const lxb_char_t *) "\u200D𐹴Ss｡\u0EB4\u2B75񪅌", .ascii = (const lxb_char_t *) "xn--ss-l1t5169j.xn--57c638l8774i", .status = 16} /* 889 */,
    {.source = (const lxb_char_t *) "\u1B44．\u1BAA-≮≠", .ascii = (const lxb_char_t *) "xn--1uf.xn----nmlz65aub", .status = 4} /* 890 */,
    {.source = (const lxb_char_t *) "\u1B44．\u1BAA-<\u0338=\u0338", .ascii = (const lxb_char_t *) "xn--1uf.xn----nmlz65aub", .status = 4} /* 891 */,
    {.source = (const lxb_char_t *) "\u1B44.\u1BAA-≮≠", .ascii = (const lxb_char_t *) "xn--1uf.xn----nmlz65aub", .status = 4} /* 892 */,
    {.source = (const lxb_char_t *) "\u1B44.\u1BAA-<\u0338=\u0338", .ascii = (const lxb_char_t *) "xn--1uf.xn----nmlz65aub", .status = 4} /* 893 */,
    {.source = (const lxb_char_t *) "xn--1uf.xn----nmlz65aub", .ascii = (const lxb_char_t *) "xn--1uf.xn----nmlz65aub", .status = 4} /* 894 */,
    {.source = (const lxb_char_t *) "\u1BF3Ⴑ\u115F．𑄴Ⅎ", .ascii = (const lxb_char_t *) "xn--pnd26a55x.xn--f3g7465g", .status = 8} /* 895 */,
    {.source = (const lxb_char_t *) "\u1BF3Ⴑ\u115F.𑄴Ⅎ", .ascii = (const lxb_char_t *) "xn--pnd26a55x.xn--f3g7465g", .status = 8} /* 896 */,
    {.source = (const lxb_char_t *) "\u1BF3ⴑ\u115F.𑄴ⅎ", .ascii = (const lxb_char_t *) "xn--osd925cvyn.xn--73g3065g", .status = 8} /* 897 */,
    {.source = (const lxb_char_t *) "\u1BF3Ⴑ\u115F.𑄴ⅎ", .ascii = (const lxb_char_t *) "xn--pnd26a55x.xn--73g3065g", .status = 8} /* 898 */,
    {.source = (const lxb_char_t *) "xn--pnd26a55x.xn--73g3065g", .ascii = (const lxb_char_t *) "xn--pnd26a55x.xn--73g3065g", .status = 8} /* 899 */,
    {.source = (const lxb_char_t *) "xn--osd925cvyn.xn--73g3065g", .ascii = (const lxb_char_t *) "xn--osd925cvyn.xn--73g3065g", .status = 8} /* 900 */,
    {.source = (const lxb_char_t *) "xn--pnd26a55x.xn--f3g7465g", .ascii = (const lxb_char_t *) "xn--pnd26a55x.xn--f3g7465g", .status = 8} /* 901 */,
    {.source = (const lxb_char_t *) "\u1BF3ⴑ\u115F．𑄴ⅎ", .ascii = (const lxb_char_t *) "xn--osd925cvyn.xn--73g3065g", .status = 8} /* 902 */,
    {.source = (const lxb_char_t *) "\u1BF3Ⴑ\u115F．𑄴ⅎ", .ascii = (const lxb_char_t *) "xn--pnd26a55x.xn--73g3065g", .status = 8} /* 903 */,
    {.source = (const lxb_char_t *) "𜉆。Ⴃ𐴣𐹹똯", .ascii = (const lxb_char_t *) "xn--187g.xn--bnd4785f8r8bdeb", .status = 8} /* 904 */,
    {.source = (const lxb_char_t *) "𜉆。Ⴃ𐴣𐹹똯", .ascii = (const lxb_char_t *) "xn--187g.xn--bnd4785f8r8bdeb", .status = 8} /* 905 */,
    {.source = (const lxb_char_t *) "𜉆。ⴃ𐴣𐹹똯", .ascii = (const lxb_char_t *) "xn--187g.xn--ukjy205b8rscdeb", .status = 8} /* 906 */,
    {.source = (const lxb_char_t *) "𜉆。ⴃ𐴣𐹹똯", .ascii = (const lxb_char_t *) "xn--187g.xn--ukjy205b8rscdeb", .status = 8} /* 907 */,
    {.source = (const lxb_char_t *) "xn--187g.xn--ukjy205b8rscdeb", .ascii = (const lxb_char_t *) "xn--187g.xn--ukjy205b8rscdeb", .status = 8} /* 908 */,
    {.source = (const lxb_char_t *) "xn--187g.xn--bnd4785f8r8bdeb", .ascii = (const lxb_char_t *) "xn--187g.xn--bnd4785f8r8bdeb", .status = 8} /* 909 */,
    {.source = (const lxb_char_t *) "𐫀｡⳻󠙾󠄷\u3164", .ascii = (const lxb_char_t *) "xn--pw9c.xn--mkj83l4v899a", .status = 8} /* 910 */,
    {.source = (const lxb_char_t *) "𐫀。⳻󠙾󠄷\u1160", .ascii = (const lxb_char_t *) "xn--pw9c.xn--psd742lxt32w", .status = 8} /* 911 */,
    {.source = (const lxb_char_t *) "xn--pw9c.xn--psd742lxt32w", .ascii = (const lxb_char_t *) "xn--pw9c.xn--psd742lxt32w", .status = 8} /* 912 */,
    {.source = (const lxb_char_t *) "xn--pw9c.xn--mkj83l4v899a", .ascii = (const lxb_char_t *) "xn--pw9c.xn--mkj83l4v899a", .status = 8} /* 913 */,
    {.source = (const lxb_char_t *) "\u079A⾇．\u071E-𐋰", .ascii = (const lxb_char_t *) "xn--7qb6383d.xn----20c3154q", .status = 8} /* 914 */,
    {.source = (const lxb_char_t *) "\u079A舛.\u071E-𐋰", .ascii = (const lxb_char_t *) "xn--7qb6383d.xn----20c3154q", .status = 8} /* 915 */,
    {.source = (const lxb_char_t *) "xn--7qb6383d.xn----20c3154q", .ascii = (const lxb_char_t *) "xn--7qb6383d.xn----20c3154q", .status = 8} /* 916 */,
    {.source = (const lxb_char_t *) "Ⴉ猕󹛫≮．︒", .ascii = (const lxb_char_t *) "xn--hnd212gz32d54x5r.xn--y86c", .status = 4} /* 917 */,
    {.source = (const lxb_char_t *) "Ⴉ猕󹛫<\u0338．︒", .ascii = (const lxb_char_t *) "xn--hnd212gz32d54x5r.xn--y86c", .status = 4} /* 918 */,
    {.source = (const lxb_char_t *) "Ⴉ猕󹛫≮.。", .ascii = (const lxb_char_t *) "xn--hnd212gz32d54x5r..", .status = 10} /* 919 */,
    {.source = (const lxb_char_t *) "Ⴉ猕󹛫<\u0338.。", .ascii = (const lxb_char_t *) "xn--hnd212gz32d54x5r..", .status = 10} /* 920 */,
    {.source = (const lxb_char_t *) "ⴉ猕󹛫<\u0338.。", .ascii = (const lxb_char_t *) "xn--gdh892bbz0d5438s..", .status = 10} /* 921 */,
    {.source = (const lxb_char_t *) "ⴉ猕󹛫≮.。", .ascii = (const lxb_char_t *) "xn--gdh892bbz0d5438s..", .status = 10} /* 922 */,
    {.source = (const lxb_char_t *) "xn--gdh892bbz0d5438s..", .ascii = (const lxb_char_t *) "xn--gdh892bbz0d5438s..", .status = 10} /* 923 */,
    {.source = (const lxb_char_t *) "xn--hnd212gz32d54x5r..", .ascii = (const lxb_char_t *) "xn--hnd212gz32d54x5r..", .status = 10} /* 924 */,
    {.source = (const lxb_char_t *) "ⴉ猕󹛫<\u0338．︒", .ascii = (const lxb_char_t *) "xn--gdh892bbz0d5438s.xn--y86c", .status = 4} /* 925 */,
    {.source = (const lxb_char_t *) "ⴉ猕󹛫≮．︒", .ascii = (const lxb_char_t *) "xn--gdh892bbz0d5438s.xn--y86c", .status = 4} /* 926 */,
    {.source = (const lxb_char_t *) "xn--gdh892bbz0d5438s.xn--y86c", .ascii = (const lxb_char_t *) "xn--gdh892bbz0d5438s.xn--y86c", .status = 4} /* 927 */,
    {.source = (const lxb_char_t *) "xn--hnd212gz32d54x5r.xn--y86c", .ascii = (const lxb_char_t *) "xn--hnd212gz32d54x5r.xn--y86c", .status = 4} /* 928 */,
    {.source = (const lxb_char_t *) "🏮｡\u062B鳳\u07E2󠅉", .ascii = (const lxb_char_t *) "xn--8m8h.xn--qgb29f6z90a", .status = 8} /* 929 */,
    {.source = (const lxb_char_t *) "🏮。\u062B鳳\u07E2󠅉", .ascii = (const lxb_char_t *) "xn--8m8h.xn--qgb29f6z90a", .status = 8} /* 930 */,
    {.source = (const lxb_char_t *) "xn--8m8h.xn--qgb29f6z90a", .ascii = (const lxb_char_t *) "xn--8m8h.xn--qgb29f6z90a", .status = 8} /* 931 */,
    {.source = (const lxb_char_t *) "\u200D𐹶。ß", .ascii = (const lxb_char_t *) "xn--1ug9105g.xn--zca", .status = 8} /* 932 */,
    {.source = (const lxb_char_t *) "\u200D𐹶。SS", .ascii = (const lxb_char_t *) "xn--1ug9105g.ss", .status = 8} /* 933 */,
    {.source = (const lxb_char_t *) "\u200D𐹶。ss", .ascii = (const lxb_char_t *) "xn--1ug9105g.ss", .status = 8} /* 934 */,
    {.source = (const lxb_char_t *) "\u200D𐹶。Ss", .ascii = (const lxb_char_t *) "xn--1ug9105g.ss", .status = 8} /* 935 */,
    {.source = (const lxb_char_t *) "xn--uo0d.ss", .ascii = (const lxb_char_t *) "xn--uo0d.ss", .status = 4} /* 936 */,
    {.source = (const lxb_char_t *) "xn--1ug9105g.ss", .ascii = (const lxb_char_t *) "xn--1ug9105g.ss", .status = 8} /* 937 */,
    {.source = (const lxb_char_t *) "xn--1ug9105g.xn--zca", .ascii = (const lxb_char_t *) "xn--1ug9105g.xn--zca", .status = 8} /* 938 */,
    {.source = (const lxb_char_t *) "Å둄-．\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 939 */,
    {.source = (const lxb_char_t *) "A\u030A둄-．\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 940 */,
    {.source = (const lxb_char_t *) "Å둄-.\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 941 */,
    {.source = (const lxb_char_t *) "A\u030A둄-.\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 942 */,
    {.source = (const lxb_char_t *) "a\u030A둄-.\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 943 */,
    {.source = (const lxb_char_t *) "å둄-.\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 944 */,
    {.source = (const lxb_char_t *) "xn----1fa1788k.", .ascii = (const lxb_char_t *) "xn----1fa1788k.", .status = 4} /* 945 */,
    {.source = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 946 */,
    {.source = (const lxb_char_t *) "a\u030A둄-．\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 947 */,
    {.source = (const lxb_char_t *) "å둄-．\u200C", .ascii = (const lxb_char_t *) "xn----1fa1788k.xn--0ug", .status = 8} /* 948 */,
    {.source = (const lxb_char_t *) "\u3099򬎑\u1DD7𞤀.򱲢-\u0953", .ascii = (const lxb_char_t *) "xn--veg121fwg63altj9d.xn----eyd92688s", .status = 16} /* 949 */,
    {.source = (const lxb_char_t *) "\u3099򬎑\u1DD7𞤢.򱲢-\u0953", .ascii = (const lxb_char_t *) "xn--veg121fwg63altj9d.xn----eyd92688s", .status = 16} /* 950 */,
    {.source = (const lxb_char_t *) "xn--veg121fwg63altj9d.xn----eyd92688s", .ascii = (const lxb_char_t *) "xn--veg121fwg63altj9d.xn----eyd92688s", .status = 16} /* 951 */,
    {.source = (const lxb_char_t *) "ς.ß񴱄\u06DD\u2D7F", .ascii = (const lxb_char_t *) "xn--3xa.xn--zca281az71b8x73m", .status = 12} /* 952 */,
    {.source = (const lxb_char_t *) "Σ.SS񴱄\u06DD\u2D7F", .ascii = (const lxb_char_t *) "xn--4xa.xn--ss-y8d4760biv60n", .status = 12} /* 953 */,
    {.source = (const lxb_char_t *) "σ.ss񴱄\u06DD\u2D7F", .ascii = (const lxb_char_t *) "xn--4xa.xn--ss-y8d4760biv60n", .status = 12} /* 954 */,
    {.source = (const lxb_char_t *) "Σ.ss񴱄\u06DD\u2D7F", .ascii = (const lxb_char_t *) "xn--4xa.xn--ss-y8d4760biv60n", .status = 12} /* 955 */,
    {.source = (const lxb_char_t *) "xn--4xa.xn--ss-y8d4760biv60n", .ascii = (const lxb_char_t *) "xn--4xa.xn--ss-y8d4760biv60n", .status = 12} /* 956 */,
    {.source = (const lxb_char_t *) "Σ.ß񴱄\u06DD\u2D7F", .ascii = (const lxb_char_t *) "xn--4xa.xn--zca281az71b8x73m", .status = 12} /* 957 */,
    {.source = (const lxb_char_t *) "σ.ß񴱄\u06DD\u2D7F", .ascii = (const lxb_char_t *) "xn--4xa.xn--zca281az71b8x73m", .status = 12} /* 958 */,
    {.source = (const lxb_char_t *) "xn--4xa.xn--zca281az71b8x73m", .ascii = (const lxb_char_t *) "xn--4xa.xn--zca281az71b8x73m", .status = 12} /* 959 */,
    {.source = (const lxb_char_t *) "xn--3xa.xn--zca281az71b8x73m", .ascii = (const lxb_char_t *) "xn--3xa.xn--zca281az71b8x73m", .status = 12} /* 960 */,
    {.source = (const lxb_char_t *) "ꡀ𞀟｡\u066B\u0599", .ascii = (const lxb_char_t *) "xn--8b9a1720d.xn--kcb33b", .status = 4} /* 961 */,
    {.source = (const lxb_char_t *) "ꡀ𞀟。\u066B\u0599", .ascii = (const lxb_char_t *) "xn--8b9a1720d.xn--kcb33b", .status = 4} /* 962 */,
    {.source = (const lxb_char_t *) "xn--8b9a1720d.xn--kcb33b", .ascii = (const lxb_char_t *) "xn--8b9a1720d.xn--kcb33b", .status = 4} /* 963 */,
    {.source = (const lxb_char_t *) "򈛉\u200C\u08A9｡⧅񘘡-𐭡", .ascii = (const lxb_char_t *) "xn--yyb780jll63m.xn----zir1232guu71b", .status = 20} /* 964 */,
    {.source = (const lxb_char_t *) "򈛉\u200C\u08A9。⧅񘘡-𐭡", .ascii = (const lxb_char_t *) "xn--yyb780jll63m.xn----zir1232guu71b", .status = 20} /* 965 */,
    {.source = (const lxb_char_t *) "xn--yyb56242i.xn----zir1232guu71b", .ascii = (const lxb_char_t *) "xn--yyb56242i.xn----zir1232guu71b", .status = 16} /* 966 */,
    {.source = (const lxb_char_t *) "xn--yyb780jll63m.xn----zir1232guu71b", .ascii = (const lxb_char_t *) "xn--yyb780jll63m.xn----zir1232guu71b", .status = 20} /* 967 */,
    {.source = (const lxb_char_t *) "룱\u200D𰍨\u200C。𝨖︒", .ascii = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--y86cl899a", .status = 16} /* 968 */,
    {.source = (const lxb_char_t *) "룱\u200D𰍨\u200C。𝨖︒", .ascii = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--y86cl899a", .status = 16} /* 969 */,
    {.source = (const lxb_char_t *) "룱\u200D𰍨\u200C。𝨖。", .ascii = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--772h.", .status = 12} /* 970 */,
    {.source = (const lxb_char_t *) "룱\u200D𰍨\u200C。𝨖。", .ascii = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--772h.", .status = 12} /* 971 */,
    {.source = (const lxb_char_t *) "xn--ct2b0738h.xn--772h.", .ascii = (const lxb_char_t *) "xn--ct2b0738h.xn--772h.", .status = 4} /* 972 */,
    {.source = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--772h.", .ascii = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--772h.", .status = 12} /* 973 */,
    {.source = (const lxb_char_t *) "xn--ct2b0738h.xn--y86cl899a", .ascii = (const lxb_char_t *) "xn--ct2b0738h.xn--y86cl899a", .status = 8} /* 974 */,
    {.source = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--y86cl899a", .ascii = (const lxb_char_t *) "xn--0ugb3358ili2v.xn--y86cl899a", .status = 16} /* 975 */,
    {.source = (const lxb_char_t *) "🄄．\u1CDC⒈ß", .ascii = (const lxb_char_t *) "xn--x07h.xn--zca344lmif", .status = 8} /* 976 */,
    {.source = (const lxb_char_t *) "3,.\u1CDC1.ß", .ascii = (const lxb_char_t *) "3,.xn--1-43l.xn--zca", .status = 8} /* 977 */,
    {.source = (const lxb_char_t *) "3,.\u1CDC1.SS", .ascii = (const lxb_char_t *) "3,.xn--1-43l.ss", .status = 8} /* 978 */,
    {.source = (const lxb_char_t *) "3,.\u1CDC1.ss", .ascii = (const lxb_char_t *) "3,.xn--1-43l.ss", .status = 8} /* 979 */,
    {.source = (const lxb_char_t *) "3,.\u1CDC1.Ss", .ascii = (const lxb_char_t *) "3,.xn--1-43l.ss", .status = 8} /* 980 */,
    {.source = (const lxb_char_t *) "3,.xn--1-43l.ss", .ascii = (const lxb_char_t *) "3,.xn--1-43l.ss", .status = 8} /* 981 */,
    {.source = (const lxb_char_t *) "3,.xn--1-43l.xn--zca", .ascii = (const lxb_char_t *) "3,.xn--1-43l.xn--zca", .status = 8} /* 982 */,
    {.source = (const lxb_char_t *) "🄄．\u1CDC⒈SS", .ascii = (const lxb_char_t *) "xn--x07h.xn--ss-k1r094b", .status = 8} /* 983 */,
    {.source = (const lxb_char_t *) "🄄．\u1CDC⒈ss", .ascii = (const lxb_char_t *) "xn--x07h.xn--ss-k1r094b", .status = 8} /* 984 */,
    {.source = (const lxb_char_t *) "🄄．\u1CDC⒈Ss", .ascii = (const lxb_char_t *) "xn--x07h.xn--ss-k1r094b", .status = 8} /* 985 */,
    {.source = (const lxb_char_t *) "xn--x07h.xn--ss-k1r094b", .ascii = (const lxb_char_t *) "xn--x07h.xn--ss-k1r094b", .status = 8} /* 986 */,
    {.source = (const lxb_char_t *) "xn--x07h.xn--zca344lmif", .ascii = (const lxb_char_t *) "xn--x07h.xn--zca344lmif", .status = 8} /* 987 */,
    {.source = (const lxb_char_t *) "񇌍\u2D7F｡𞼓򡄨𑐺", .ascii = (const lxb_char_t *) "xn--eoj16016a.xn--0v1d3848a3lr0d", .status = 12} /* 988 */,
    {.source = (const lxb_char_t *) "񇌍\u2D7F。𞼓򡄨𑐺", .ascii = (const lxb_char_t *) "xn--eoj16016a.xn--0v1d3848a3lr0d", .status = 12} /* 989 */,
    {.source = (const lxb_char_t *) "xn--eoj16016a.xn--0v1d3848a3lr0d", .ascii = (const lxb_char_t *) "xn--eoj16016a.xn--0v1d3848a3lr0d", .status = 12} /* 990 */,
    {.source = (const lxb_char_t *) "\u1DFD\u103A\u094D．≠\u200D㇛", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .status = 8} /* 991 */,
    {.source = (const lxb_char_t *) "\u103A\u094D\u1DFD．≠\u200D㇛", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .status = 8} /* 992 */,
    {.source = (const lxb_char_t *) "\u103A\u094D\u1DFD．=\u0338\u200D㇛", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .status = 8} /* 993 */,
    {.source = (const lxb_char_t *) "\u103A\u094D\u1DFD.≠\u200D㇛", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .status = 8} /* 994 */,
    {.source = (const lxb_char_t *) "\u103A\u094D\u1DFD.=\u0338\u200D㇛", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .status = 8} /* 995 */,
    {.source = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ch912d", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ch912d", .status = 4} /* 996 */,
    {.source = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .ascii = (const lxb_char_t *) "xn--n3b956a9zm.xn--1ug63gz5w", .status = 8} /* 997 */,
    {.source = (const lxb_char_t *) "Ⴁ𐋨娤.\u200D\u033C\u0662𑖿", .ascii = (const lxb_char_t *) "xn--8md2578ag21g.xn--9ta62ngt6aou8t", .status = 12} /* 998 */,
    {.source = (const lxb_char_t *) "ⴁ𐋨娤.\u200D\u033C\u0662𑖿", .ascii = (const lxb_char_t *) "xn--skjw75lg29h.xn--9ta62ngt6aou8t", .status = 8} /* 999 */,
    {.source = (const lxb_char_t *) "xn--skjw75lg29h.xn--9ta62nrv36a", .ascii = (const lxb_char_t *) "xn--skjw75lg29h.xn--9ta62nrv36a", .status = 8} /* 1000 */,
    {.source = (const lxb_char_t *) "xn--skjw75lg29h.xn--9ta62ngt6aou8t", .ascii = (const lxb_char_t *) "xn--skjw75lg29h.xn--9ta62ngt6aou8t", .status = 8} /* 1001 */,
    {.source = (const lxb_char_t *) "xn--8md2578ag21g.xn--9ta62nrv36a", .ascii = (const lxb_char_t *) "xn--8md2578ag21g.xn--9ta62nrv36a", .status = 12} /* 1002 */,
    {.source = (const lxb_char_t *) "xn--8md2578ag21g.xn--9ta62ngt6aou8t", .ascii = (const lxb_char_t *) "xn--8md2578ag21g.xn--9ta62ngt6aou8t", .status = 12} /* 1003 */,
    {.source = (const lxb_char_t *) "🄀Ⴄ\u0669\u0820。⒈\u0FB6ß", .ascii = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--zca117e3vp", .status = 8} /* 1004 */,
    {.source = (const lxb_char_t *) "0.Ⴄ\u0669\u0820。1.\u0FB6ß", .ascii = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--zca117e", .status = 20} /* 1005 */,
    {.source = (const lxb_char_t *) "0.ⴄ\u0669\u0820。1.\u0FB6ß", .ascii = (const lxb_char_t *) "0.xn--iib29fp25e.1.xn--zca117e", .status = 16} /* 1006 */,
    {.source = (const lxb_char_t *) "0.Ⴄ\u0669\u0820。1.\u0FB6SS", .ascii = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--ss-1sj", .status = 20} /* 1007 */,
    {.source = (const lxb_char_t *) "0.ⴄ\u0669\u0820。1.\u0FB6ss", .ascii = (const lxb_char_t *) "0.xn--iib29fp25e.1.xn--ss-1sj", .status = 16} /* 1008 */,
    {.source = (const lxb_char_t *) "0.Ⴄ\u0669\u0820。1.\u0FB6Ss", .ascii = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--ss-1sj", .status = 20} /* 1009 */,
    {.source = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--ss-1sj", .ascii = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--ss-1sj", .status = 20} /* 1010 */,
    {.source = (const lxb_char_t *) "0.xn--iib29fp25e.1.xn--ss-1sj", .ascii = (const lxb_char_t *) "0.xn--iib29fp25e.1.xn--ss-1sj", .status = 16} /* 1011 */,
    {.source = (const lxb_char_t *) "0.xn--iib29fp25e.1.xn--zca117e", .ascii = (const lxb_char_t *) "0.xn--iib29fp25e.1.xn--zca117e", .status = 16} /* 1012 */,
    {.source = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--zca117e", .ascii = (const lxb_char_t *) "0.xn--iib29f26o.1.xn--zca117e", .status = 20} /* 1013 */,
    {.source = (const lxb_char_t *) "🄀ⴄ\u0669\u0820。⒈\u0FB6ß", .ascii = (const lxb_char_t *) "xn--iib29fp25e0219a.xn--zca117e3vp", .status = 8} /* 1014 */,
    {.source = (const lxb_char_t *) "🄀Ⴄ\u0669\u0820。⒈\u0FB6SS", .ascii = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--ss-1sj588o", .status = 8} /* 1015 */,
    {.source = (const lxb_char_t *) "🄀ⴄ\u0669\u0820。⒈\u0FB6ss", .ascii = (const lxb_char_t *) "xn--iib29fp25e0219a.xn--ss-1sj588o", .status = 8} /* 1016 */,
    {.source = (const lxb_char_t *) "🄀Ⴄ\u0669\u0820。⒈\u0FB6Ss", .ascii = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--ss-1sj588o", .status = 8} /* 1017 */,
    {.source = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--ss-1sj588o", .ascii = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--ss-1sj588o", .status = 8} /* 1018 */,
    {.source = (const lxb_char_t *) "xn--iib29fp25e0219a.xn--ss-1sj588o", .ascii = (const lxb_char_t *) "xn--iib29fp25e0219a.xn--ss-1sj588o", .status = 8} /* 1019 */,
    {.source = (const lxb_char_t *) "xn--iib29fp25e0219a.xn--zca117e3vp", .ascii = (const lxb_char_t *) "xn--iib29fp25e0219a.xn--zca117e3vp", .status = 8} /* 1020 */,
    {.source = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--zca117e3vp", .ascii = (const lxb_char_t *) "xn--iib29f26o6n43c.xn--zca117e3vp", .status = 8} /* 1021 */,
    {.source = (const lxb_char_t *) "≠.\u200C-\u066B", .ascii = (const lxb_char_t *) "xn--1ch.xn----vqc597q", .status = 8} /* 1022 */,
    {.source = (const lxb_char_t *) "=\u0338.\u200C-\u066B", .ascii = (const lxb_char_t *) "xn--1ch.xn----vqc597q", .status = 8} /* 1023 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn----vqc", .ascii = (const lxb_char_t *) "xn--1ch.xn----vqc", .status = 8} /* 1024 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn----vqc597q", .ascii = (const lxb_char_t *) "xn--1ch.xn----vqc597q", .status = 8} /* 1025 */,
    {.source = (const lxb_char_t *) "\u0660۱｡󠳶𞠁\u0665", .ascii = (const lxb_char_t *) "xn--8hb40a.xn--eib7967vner3e", .status = 8} /* 1026 */,
    {.source = (const lxb_char_t *) "\u0660۱。󠳶𞠁\u0665", .ascii = (const lxb_char_t *) "xn--8hb40a.xn--eib7967vner3e", .status = 8} /* 1027 */,
    {.source = (const lxb_char_t *) "xn--8hb40a.xn--eib7967vner3e", .ascii = (const lxb_char_t *) "xn--8hb40a.xn--eib7967vner3e", .status = 8} /* 1028 */,
    {.source = (const lxb_char_t *) "\u200C\u0663⒖。󱅉𽷛\u1BF3", .ascii = (const lxb_char_t *) "xn--cib152kwgd.xn--1zf13512buy41d", .status = 12} /* 1029 */,
    {.source = (const lxb_char_t *) "\u200C\u066315.。󱅉𽷛\u1BF3", .ascii = (const lxb_char_t *) "xn--15-gyd983x..xn--1zf13512buy41d", .status = 18} /* 1030 */,
    {.source = (const lxb_char_t *) "xn--15-gyd..xn--1zf13512buy41d", .ascii = (const lxb_char_t *) "xn--15-gyd..xn--1zf13512buy41d", .status = 14} /* 1031 */,
    {.source = (const lxb_char_t *) "xn--15-gyd983x..xn--1zf13512buy41d", .ascii = (const lxb_char_t *) "xn--15-gyd983x..xn--1zf13512buy41d", .status = 18} /* 1032 */,
    {.source = (const lxb_char_t *) "xn--cib675m.xn--1zf13512buy41d", .ascii = (const lxb_char_t *) "xn--cib675m.xn--1zf13512buy41d", .status = 8} /* 1033 */,
    {.source = (const lxb_char_t *) "xn--cib152kwgd.xn--1zf13512buy41d", .ascii = (const lxb_char_t *) "xn--cib152kwgd.xn--1zf13512buy41d", .status = 12} /* 1034 */,
    {.source = (const lxb_char_t *) "\u1BF3.-逋񳦭󙙮", .ascii = (const lxb_char_t *) "xn--1zf.xn----483d46987byr50b", .status = 12} /* 1035 */,
    {.source = (const lxb_char_t *) "xn--1zf.xn----483d46987byr50b", .ascii = (const lxb_char_t *) "xn--1zf.xn----483d46987byr50b", .status = 12} /* 1036 */,
    {.source = (const lxb_char_t *) "\u0756。\u3164\u200Dς", .ascii = (const lxb_char_t *) "xn--9ob.xn--3xa995lq2l", .status = 8} /* 1037 */,
    {.source = (const lxb_char_t *) "\u0756。\u1160\u200Dς", .ascii = (const lxb_char_t *) "xn--9ob.xn--3xa580ebol", .status = 8} /* 1038 */,
    {.source = (const lxb_char_t *) "\u0756。\u1160\u200DΣ", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa380ebol", .status = 8} /* 1039 */,
    {.source = (const lxb_char_t *) "\u0756。\u1160\u200Dσ", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa380ebol", .status = 8} /* 1040 */,
    {.source = (const lxb_char_t *) "xn--9ob.xn--4xa380e", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa380e", .status = 4} /* 1041 */,
    {.source = (const lxb_char_t *) "xn--9ob.xn--4xa380ebol", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa380ebol", .status = 8} /* 1042 */,
    {.source = (const lxb_char_t *) "xn--9ob.xn--3xa580ebol", .ascii = (const lxb_char_t *) "xn--9ob.xn--3xa580ebol", .status = 8} /* 1043 */,
    {.source = (const lxb_char_t *) "\u0756。\u3164\u200DΣ", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa795lq2l", .status = 8} /* 1044 */,
    {.source = (const lxb_char_t *) "\u0756。\u3164\u200Dσ", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa795lq2l", .status = 8} /* 1045 */,
    {.source = (const lxb_char_t *) "xn--9ob.xn--4xa574u", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa574u", .status = 4} /* 1046 */,
    {.source = (const lxb_char_t *) "xn--9ob.xn--4xa795lq2l", .ascii = (const lxb_char_t *) "xn--9ob.xn--4xa795lq2l", .status = 8} /* 1047 */,
    {.source = (const lxb_char_t *) "xn--9ob.xn--3xa995lq2l", .ascii = (const lxb_char_t *) "xn--9ob.xn--3xa995lq2l", .status = 8} /* 1048 */,
    {.source = (const lxb_char_t *) "ᡆႣ｡󞢧\u0315\u200D\u200D", .ascii = (const lxb_char_t *) "xn--bnd320b.xn--5sa649la993427a", .status = 8} /* 1049 */,
    {.source = (const lxb_char_t *) "ᡆႣ。󞢧\u0315\u200D\u200D", .ascii = (const lxb_char_t *) "xn--bnd320b.xn--5sa649la993427a", .status = 8} /* 1050 */,
    {.source = (const lxb_char_t *) "ᡆⴃ。󞢧\u0315\u200D\u200D", .ascii = (const lxb_char_t *) "xn--57e237h.xn--5sa649la993427a", .status = 8} /* 1051 */,
    {.source = (const lxb_char_t *) "xn--57e237h.xn--5sa98523p", .ascii = (const lxb_char_t *) "xn--57e237h.xn--5sa98523p", .status = 4} /* 1052 */,
    {.source = (const lxb_char_t *) "xn--57e237h.xn--5sa649la993427a", .ascii = (const lxb_char_t *) "xn--57e237h.xn--5sa649la993427a", .status = 8} /* 1053 */,
    {.source = (const lxb_char_t *) "xn--bnd320b.xn--5sa98523p", .ascii = (const lxb_char_t *) "xn--bnd320b.xn--5sa98523p", .status = 4} /* 1054 */,
    {.source = (const lxb_char_t *) "xn--bnd320b.xn--5sa649la993427a", .ascii = (const lxb_char_t *) "xn--bnd320b.xn--5sa649la993427a", .status = 8} /* 1055 */,
    {.source = (const lxb_char_t *) "ᡆⴃ｡󞢧\u0315\u200D\u200D", .ascii = (const lxb_char_t *) "xn--57e237h.xn--5sa649la993427a", .status = 8} /* 1056 */,
    {.source = (const lxb_char_t *) "㭄\u200D\u084F𑚵．ς𐮮\u200C\u200D", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--3xa895lda6932v", .status = 16} /* 1057 */,
    {.source = (const lxb_char_t *) "㭄\u200D\u084F𑚵.ς𐮮\u200C\u200D", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--3xa895lda6932v", .status = 16} /* 1058 */,
    {.source = (const lxb_char_t *) "㭄\u200D\u084F𑚵.Σ𐮮\u200C\u200D", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--4xa695lda6932v", .status = 16} /* 1059 */,
    {.source = (const lxb_char_t *) "㭄\u200D\u084F𑚵.σ𐮮\u200C\u200D", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--4xa695lda6932v", .status = 16} /* 1060 */,
    {.source = (const lxb_char_t *) "xn--ewb302xhu1l.xn--4xa0426k", .ascii = (const lxb_char_t *) "xn--ewb302xhu1l.xn--4xa0426k", .status = 8} /* 1061 */,
    {.source = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--4xa695lda6932v", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--4xa695lda6932v", .status = 16} /* 1062 */,
    {.source = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--3xa895lda6932v", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--3xa895lda6932v", .status = 16} /* 1063 */,
    {.source = (const lxb_char_t *) "㭄\u200D\u084F𑚵．Σ𐮮\u200C\u200D", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--4xa695lda6932v", .status = 16} /* 1064 */,
    {.source = (const lxb_char_t *) "㭄\u200D\u084F𑚵．σ𐮮\u200C\u200D", .ascii = (const lxb_char_t *) "xn--ewb962jfitku4r.xn--4xa695lda6932v", .status = 16} /* 1065 */,
    {.source = (const lxb_char_t *) "\u17B5。𞯸ꡀ🄋", .ascii = (const lxb_char_t *) "xn--03e.xn--8b9ar252dngd", .status = 20} /* 1066 */,
    {.source = (const lxb_char_t *) "xn--03e.xn--8b9ar252dngd", .ascii = (const lxb_char_t *) "xn--03e.xn--8b9ar252dngd", .status = 20} /* 1067 */,
    {.source = (const lxb_char_t *) "󐪺暑．⾑\u0668", .ascii = (const lxb_char_t *) "xn--tlvq3513e.xn--hib9228d", .status = 12} /* 1068 */,
    {.source = (const lxb_char_t *) "󐪺暑.襾\u0668", .ascii = (const lxb_char_t *) "xn--tlvq3513e.xn--hib9228d", .status = 12} /* 1069 */,
    {.source = (const lxb_char_t *) "xn--tlvq3513e.xn--hib9228d", .ascii = (const lxb_char_t *) "xn--tlvq3513e.xn--hib9228d", .status = 12} /* 1070 */,
    {.source = (const lxb_char_t *) "󠄚≯ꡢ。\u0891\u1DFF", .ascii = (const lxb_char_t *) "xn--hdh7783c.xn--9xb680i", .status = 8} /* 1071 */,
    {.source = (const lxb_char_t *) "󠄚>\u0338ꡢ。\u0891\u1DFF", .ascii = (const lxb_char_t *) "xn--hdh7783c.xn--9xb680i", .status = 8} /* 1072 */,
    {.source = (const lxb_char_t *) "xn--hdh7783c.xn--9xb680i", .ascii = (const lxb_char_t *) "xn--hdh7783c.xn--9xb680i", .status = 8} /* 1073 */,
    {.source = (const lxb_char_t *) "\uFDC3𮁱\u0B4D𐨿.󐧤Ⴗ", .ascii = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--vnd55511o", .status = 12} /* 1074 */,
    {.source = (const lxb_char_t *) "\u0643\u0645\u0645𮁱\u0B4D𐨿.󐧤Ⴗ", .ascii = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--vnd55511o", .status = 12} /* 1075 */,
    {.source = (const lxb_char_t *) "\u0643\u0645\u0645𮁱\u0B4D𐨿.󐧤ⴗ", .ascii = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--fljz2846h", .status = 12} /* 1076 */,
    {.source = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--fljz2846h", .ascii = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--fljz2846h", .status = 12} /* 1077 */,
    {.source = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--vnd55511o", .ascii = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--vnd55511o", .status = 12} /* 1078 */,
    {.source = (const lxb_char_t *) "\uFDC3𮁱\u0B4D𐨿.󐧤ⴗ", .ascii = (const lxb_char_t *) "xn--fhbea662czx68a2tju.xn--fljz2846h", .status = 12} /* 1079 */,
    {.source = (const lxb_char_t *) "𞀨｡\u1B44򡛨𞎇", .ascii = (const lxb_char_t *) "xn--mi4h.xn--1uf6843smg20c", .status = 8} /* 1080 */,
    {.source = (const lxb_char_t *) "𞀨。\u1B44򡛨𞎇", .ascii = (const lxb_char_t *) "xn--mi4h.xn--1uf6843smg20c", .status = 8} /* 1081 */,
    {.source = (const lxb_char_t *) "xn--mi4h.xn--1uf6843smg20c", .ascii = (const lxb_char_t *) "xn--mi4h.xn--1uf6843smg20c", .status = 8} /* 1082 */,
    {.source = (const lxb_char_t *) "󠣼\u200C．𐺰\u200Cᡟ", .ascii = (const lxb_char_t *) "xn--0ug18531l.xn--v8e340bp21t", .status = 20} /* 1083 */,
    {.source = (const lxb_char_t *) "󠣼\u200C.𐺰\u200Cᡟ", .ascii = (const lxb_char_t *) "xn--0ug18531l.xn--v8e340bp21t", .status = 20} /* 1084 */,
    {.source = (const lxb_char_t *) "xn--q046e.xn--v8e7227j", .ascii = (const lxb_char_t *) "xn--q046e.xn--v8e7227j", .status = 16} /* 1085 */,
    {.source = (const lxb_char_t *) "xn--0ug18531l.xn--v8e340bp21t", .ascii = (const lxb_char_t *) "xn--0ug18531l.xn--v8e340bp21t", .status = 20} /* 1086 */,
    {.source = (const lxb_char_t *) "ᢛ󨅟ß.ጧ", .ascii = (const lxb_char_t *) "xn--zca562jc642x.xn--p5d", .status = 4} /* 1087 */,
    {.source = (const lxb_char_t *) "ᢛ󨅟SS.ጧ", .ascii = (const lxb_char_t *) "xn--ss-7dp66033t.xn--p5d", .status = 4} /* 1088 */,
    {.source = (const lxb_char_t *) "ᢛ󨅟ss.ጧ", .ascii = (const lxb_char_t *) "xn--ss-7dp66033t.xn--p5d", .status = 4} /* 1089 */,
    {.source = (const lxb_char_t *) "ᢛ󨅟Ss.ጧ", .ascii = (const lxb_char_t *) "xn--ss-7dp66033t.xn--p5d", .status = 4} /* 1090 */,
    {.source = (const lxb_char_t *) "xn--ss-7dp66033t.xn--p5d", .ascii = (const lxb_char_t *) "xn--ss-7dp66033t.xn--p5d", .status = 4} /* 1091 */,
    {.source = (const lxb_char_t *) "xn--zca562jc642x.xn--p5d", .ascii = (const lxb_char_t *) "xn--zca562jc642x.xn--p5d", .status = 4} /* 1092 */,
    {.source = (const lxb_char_t *) "⮒\u200C.񒚗\u200C", .ascii = (const lxb_char_t *) "xn--0ugx66b.xn--0ugz2871c", .status = 8} /* 1093 */,
    {.source = (const lxb_char_t *) "xn--b9i.xn--5p9y", .ascii = (const lxb_char_t *) "xn--b9i.xn--5p9y", .status = 4} /* 1094 */,
    {.source = (const lxb_char_t *) "xn--0ugx66b.xn--0ugz2871c", .ascii = (const lxb_char_t *) "xn--0ugx66b.xn--0ugz2871c", .status = 8} /* 1095 */,
    {.source = (const lxb_char_t *) "𞤂񹞁𐹯。Ⴜ", .ascii = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--0nd", .status = 8} /* 1096 */,
    {.source = (const lxb_char_t *) "𞤤񹞁𐹯。ⴜ", .ascii = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--klj", .status = 8} /* 1097 */,
    {.source = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--klj", .ascii = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--klj", .status = 8} /* 1098 */,
    {.source = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--0nd", .ascii = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--0nd", .status = 8} /* 1099 */,
    {.source = (const lxb_char_t *) "𞤂񹞁𐹯。ⴜ", .ascii = (const lxb_char_t *) "xn--no0dr648a51o3b.xn--klj", .status = 8} /* 1100 */,
    {.source = (const lxb_char_t *) "𐹵⮣\u200C𑄰｡񷴿\uFCB7", .ascii = (const lxb_char_t *) "xn--0ug586bcj8p7jc.xn--1gb4a66004i", .status = 20} /* 1101 */,
    {.source = (const lxb_char_t *) "𐹵⮣\u200C𑄰。񷴿\u0636\u0645", .ascii = (const lxb_char_t *) "xn--0ug586bcj8p7jc.xn--1gb4a66004i", .status = 20} /* 1102 */,
    {.source = (const lxb_char_t *) "xn--s9i5458e7yb.xn--1gb4a66004i", .ascii = (const lxb_char_t *) "xn--s9i5458e7yb.xn--1gb4a66004i", .status = 16} /* 1103 */,
    {.source = (const lxb_char_t *) "xn--0ug586bcj8p7jc.xn--1gb4a66004i", .ascii = (const lxb_char_t *) "xn--0ug586bcj8p7jc.xn--1gb4a66004i", .status = 20} /* 1104 */,
    {.source = (const lxb_char_t *) "Ⴒ。デß𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--zca669cmr3a0f28a", .status = 12} /* 1105 */,
    {.source = (const lxb_char_t *) "Ⴒ。テ\u3099ß𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--zca669cmr3a0f28a", .status = 12} /* 1106 */,
    {.source = (const lxb_char_t *) "ⴒ。テ\u3099ß𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--9kj.xn--zca669cmr3a0f28a", .status = 8} /* 1107 */,
    {.source = (const lxb_char_t *) "ⴒ。デß𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--9kj.xn--zca669cmr3a0f28a", .status = 8} /* 1108 */,
    {.source = (const lxb_char_t *) "Ⴒ。デSS𞤓\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1109 */,
    {.source = (const lxb_char_t *) "Ⴒ。テ\u3099SS𞤓\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1110 */,
    {.source = (const lxb_char_t *) "ⴒ。テ\u3099ss𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--9kj.xn--ss-9nh3648ahh20b", .status = 8} /* 1111 */,
    {.source = (const lxb_char_t *) "ⴒ。デss𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--9kj.xn--ss-9nh3648ahh20b", .status = 8} /* 1112 */,
    {.source = (const lxb_char_t *) "Ⴒ。デSs𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1113 */,
    {.source = (const lxb_char_t *) "Ⴒ。テ\u3099Ss𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1114 */,
    {.source = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1115 */,
    {.source = (const lxb_char_t *) "xn--9kj.xn--ss-9nh3648ahh20b", .ascii = (const lxb_char_t *) "xn--9kj.xn--ss-9nh3648ahh20b", .status = 8} /* 1116 */,
    {.source = (const lxb_char_t *) "xn--9kj.xn--zca669cmr3a0f28a", .ascii = (const lxb_char_t *) "xn--9kj.xn--zca669cmr3a0f28a", .status = 8} /* 1117 */,
    {.source = (const lxb_char_t *) "xn--qnd.xn--zca669cmr3a0f28a", .ascii = (const lxb_char_t *) "xn--qnd.xn--zca669cmr3a0f28a", .status = 12} /* 1118 */,
    {.source = (const lxb_char_t *) "Ⴒ。デSS𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1119 */,
    {.source = (const lxb_char_t *) "Ⴒ。テ\u3099SS𞤵\u0C4D", .ascii = (const lxb_char_t *) "xn--qnd.xn--ss-9nh3648ahh20b", .status = 12} /* 1120 */,
    {.source = (const lxb_char_t *) "𑁿\u0D4D．７-\u07D2", .ascii = (const lxb_char_t *) "xn--wxc1283k.xn--7--yue", .status = 8} /* 1121 */,
    {.source = (const lxb_char_t *) "𑁿\u0D4D.7-\u07D2", .ascii = (const lxb_char_t *) "xn--wxc1283k.xn--7--yue", .status = 8} /* 1122 */,
    {.source = (const lxb_char_t *) "xn--wxc1283k.xn--7--yue", .ascii = (const lxb_char_t *) "xn--wxc1283k.xn--7--yue", .status = 8} /* 1123 */,
    {.source = (const lxb_char_t *) "≯𑜫󠭇.\u1734񒞤𑍬ᢧ", .ascii = (const lxb_char_t *) "xn--hdhx157g68o0g.xn--c0e65eu616c34o7a", .status = 8} /* 1124 */,
    {.source = (const lxb_char_t *) ">\u0338𑜫󠭇.\u1734񒞤𑍬ᢧ", .ascii = (const lxb_char_t *) "xn--hdhx157g68o0g.xn--c0e65eu616c34o7a", .status = 8} /* 1125 */,
    {.source = (const lxb_char_t *) "xn--hdhx157g68o0g.xn--c0e65eu616c34o7a", .ascii = (const lxb_char_t *) "xn--hdhx157g68o0g.xn--c0e65eu616c34o7a", .status = 8} /* 1126 */,
    {.source = (const lxb_char_t *) "\u1DDB򎐙Ⴗ쏔。\u0781", .ascii = (const lxb_char_t *) "xn--vnd148d733ky6n9e.xn--iqb", .status = 12} /* 1127 */,
    {.source = (const lxb_char_t *) "\u1DDB򎐙Ⴗ쏔。\u0781", .ascii = (const lxb_char_t *) "xn--vnd148d733ky6n9e.xn--iqb", .status = 12} /* 1128 */,
    {.source = (const lxb_char_t *) "\u1DDB򎐙ⴗ쏔。\u0781", .ascii = (const lxb_char_t *) "xn--zegy26dw47iy6w2f.xn--iqb", .status = 12} /* 1129 */,
    {.source = (const lxb_char_t *) "\u1DDB򎐙ⴗ쏔。\u0781", .ascii = (const lxb_char_t *) "xn--zegy26dw47iy6w2f.xn--iqb", .status = 12} /* 1130 */,
    {.source = (const lxb_char_t *) "xn--zegy26dw47iy6w2f.xn--iqb", .ascii = (const lxb_char_t *) "xn--zegy26dw47iy6w2f.xn--iqb", .status = 12} /* 1131 */,
    {.source = (const lxb_char_t *) "xn--vnd148d733ky6n9e.xn--iqb", .ascii = (const lxb_char_t *) "xn--vnd148d733ky6n9e.xn--iqb", .status = 12} /* 1132 */,
    {.source = (const lxb_char_t *) "ß｡𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd10cu829c", .status = 4} /* 1133 */,
    {.source = (const lxb_char_t *) "ß。𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd10cu829c", .status = 4} /* 1134 */,
    {.source = (const lxb_char_t *) "ß。𐋳ⴌ\u0FB8", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd921mvv0m", .status = 0} /* 1135 */,
    {.source = (const lxb_char_t *) "SS。𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1136 */,
    {.source = (const lxb_char_t *) "ss。𐋳ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd921mvv0m", .status = 0} /* 1137 */,
    {.source = (const lxb_char_t *) "Ss。𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1138 */,
    {.source = (const lxb_char_t *) "ss.xn--lgd10cu829c", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1139 */,
    {.source = (const lxb_char_t *) "ss.xn--lgd921mvv0m", .ascii = (const lxb_char_t *) "ss.xn--lgd921mvv0m", .status = 0} /* 1140 */,
    {.source = (const lxb_char_t *) "ss.𐋳ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd921mvv0m", .status = 0} /* 1141 */,
    {.source = (const lxb_char_t *) "SS.𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1142 */,
    {.source = (const lxb_char_t *) "Ss.𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1143 */,
    {.source = (const lxb_char_t *) "xn--zca.xn--lgd921mvv0m", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd921mvv0m", .status = 0} /* 1144 */,
    {.source = (const lxb_char_t *) "ß.𐋳ⴌ\u0FB8", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd921mvv0m", .status = 0} /* 1145 */,
    {.source = (const lxb_char_t *) "xn--zca.xn--lgd10cu829c", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd10cu829c", .status = 4} /* 1146 */,
    {.source = (const lxb_char_t *) "ß｡𐋳ⴌ\u0FB8", .ascii = (const lxb_char_t *) "xn--zca.xn--lgd921mvv0m", .status = 0} /* 1147 */,
    {.source = (const lxb_char_t *) "SS｡𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1148 */,
    {.source = (const lxb_char_t *) "ss｡𐋳ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd921mvv0m", .status = 0} /* 1149 */,
    {.source = (const lxb_char_t *) "Ss｡𐋳Ⴌ\u0FB8", .ascii = (const lxb_char_t *) "ss.xn--lgd10cu829c", .status = 4} /* 1150 */,
    {.source = (const lxb_char_t *) "-\u069E𐶡.\u200C⾝\u09CD", .ascii = (const lxb_char_t *) "xn----stc7013r.xn--b7b305imj2f", .status = 16} /* 1151 */,
    {.source = (const lxb_char_t *) "-\u069E𐶡.\u200C身\u09CD", .ascii = (const lxb_char_t *) "xn----stc7013r.xn--b7b305imj2f", .status = 16} /* 1152 */,
    {.source = (const lxb_char_t *) "xn----stc7013r.xn--b7b1419d", .ascii = (const lxb_char_t *) "xn----stc7013r.xn--b7b1419d", .status = 12} /* 1153 */,
    {.source = (const lxb_char_t *) "xn----stc7013r.xn--b7b305imj2f", .ascii = (const lxb_char_t *) "xn----stc7013r.xn--b7b305imj2f", .status = 16} /* 1154 */,
    {.source = (const lxb_char_t *) "😮\u0764𑈵𞀖.💅\u200D", .ascii = (const lxb_char_t *) "xn--opb4277kuc7elqsa.xn--1ug5265p", .status = 8} /* 1155 */,
    {.source = (const lxb_char_t *) "😮\u0764𑈵𞀖.💅\u200D", .ascii = (const lxb_char_t *) "xn--opb4277kuc7elqsa.xn--1ug5265p", .status = 8} /* 1156 */,
    {.source = (const lxb_char_t *) "xn--opb4277kuc7elqsa.xn--kr8h", .ascii = (const lxb_char_t *) "xn--opb4277kuc7elqsa.xn--kr8h", .status = 4} /* 1157 */,
    {.source = (const lxb_char_t *) "xn--opb4277kuc7elqsa.xn--1ug5265p", .ascii = (const lxb_char_t *) "xn--opb4277kuc7elqsa.xn--1ug5265p", .status = 8} /* 1158 */,
    {.source = (const lxb_char_t *) "\u08F2\u200D꙳\u0712.ᢏ\u200C󠍄", .ascii = (const lxb_char_t *) "xn--cnb37g904be26j.xn--89e849ax9363a", .status = 24} /* 1159 */,
    {.source = (const lxb_char_t *) "xn--cnb37gdy00a.xn--89e02253p", .ascii = (const lxb_char_t *) "xn--cnb37gdy00a.xn--89e02253p", .status = 16} /* 1160 */,
    {.source = (const lxb_char_t *) "xn--cnb37g904be26j.xn--89e849ax9363a", .ascii = (const lxb_char_t *) "xn--cnb37g904be26j.xn--89e849ax9363a", .status = 24} /* 1161 */,
    {.source = (const lxb_char_t *) "Ⴑ．\u06BF𞯓ᠲ", .ascii = (const lxb_char_t *) "xn--pnd.xn--ykb840gd555a", .status = 12} /* 1162 */,
    {.source = (const lxb_char_t *) "Ⴑ.\u06BF𞯓ᠲ", .ascii = (const lxb_char_t *) "xn--pnd.xn--ykb840gd555a", .status = 12} /* 1163 */,
    {.source = (const lxb_char_t *) "ⴑ.\u06BF𞯓ᠲ", .ascii = (const lxb_char_t *) "xn--8kj.xn--ykb840gd555a", .status = 12} /* 1164 */,
    {.source = (const lxb_char_t *) "xn--8kj.xn--ykb840gd555a", .ascii = (const lxb_char_t *) "xn--8kj.xn--ykb840gd555a", .status = 12} /* 1165 */,
    {.source = (const lxb_char_t *) "xn--pnd.xn--ykb840gd555a", .ascii = (const lxb_char_t *) "xn--pnd.xn--ykb840gd555a", .status = 12} /* 1166 */,
    {.source = (const lxb_char_t *) "ⴑ．\u06BF𞯓ᠲ", .ascii = (const lxb_char_t *) "xn--8kj.xn--ykb840gd555a", .status = 12} /* 1167 */,
    {.source = (const lxb_char_t *) "\u1A5A𛦝\u0C4D。𚝬𝟵", .ascii = (const lxb_char_t *) "xn--lqc703ebm93a.xn--9-000p", .status = 8} /* 1168 */,
    {.source = (const lxb_char_t *) "\u1A5A𛦝\u0C4D。𚝬9", .ascii = (const lxb_char_t *) "xn--lqc703ebm93a.xn--9-000p", .status = 8} /* 1169 */,
    {.source = (const lxb_char_t *) "xn--lqc703ebm93a.xn--9-000p", .ascii = (const lxb_char_t *) "xn--lqc703ebm93a.xn--9-000p", .status = 8} /* 1170 */,
    {.source = (const lxb_char_t *) "\u200C\u06A0𿺆𝟗｡Ⴣ꒘\uFCD0񐘖", .ascii = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c", .status = 16} /* 1171 */,
    {.source = (const lxb_char_t *) "\u200C\u06A0𿺆9。Ⴣ꒘\u0645\u062E񐘖", .ascii = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c", .status = 16} /* 1172 */,
    {.source = (const lxb_char_t *) "\u200C\u06A0𿺆9。ⴣ꒘\u0645\u062E񐘖", .ascii = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c", .status = 16} /* 1173 */,
    {.source = (const lxb_char_t *) "xn--9-vtc42319e.xn--tgb9bz87p833hw316c", .ascii = (const lxb_char_t *) "xn--9-vtc42319e.xn--tgb9bz87p833hw316c", .status = 12} /* 1174 */,
    {.source = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c", .ascii = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c", .status = 16} /* 1175 */,
    {.source = (const lxb_char_t *) "xn--9-vtc42319e.xn--tgb9bz61cfn8mw3t2c", .ascii = (const lxb_char_t *) "xn--9-vtc42319e.xn--tgb9bz61cfn8mw3t2c", .status = 12} /* 1176 */,
    {.source = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c", .ascii = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz61cfn8mw3t2c", .status = 16} /* 1177 */,
    {.source = (const lxb_char_t *) "\u200C\u06A0𿺆𝟗｡ⴣ꒘\uFCD0񐘖", .ascii = (const lxb_char_t *) "xn--9-vtc736qts91g.xn--tgb9bz87p833hw316c", .status = 16} /* 1178 */,
    {.source = (const lxb_char_t *) "ᡖ｡\u031F񗛨\u0B82-", .ascii = (const lxb_char_t *) "xn--m8e.xn----mdb555dkk71m", .status = 12} /* 1179 */,
    {.source = (const lxb_char_t *) "ᡖ。\u031F񗛨\u0B82-", .ascii = (const lxb_char_t *) "xn--m8e.xn----mdb555dkk71m", .status = 12} /* 1180 */,
    {.source = (const lxb_char_t *) "xn--m8e.xn----mdb555dkk71m", .ascii = (const lxb_char_t *) "xn--m8e.xn----mdb555dkk71m", .status = 12} /* 1181 */,
    {.source = (const lxb_char_t *) "𞠠浘。絧𞀀", .ascii = (const lxb_char_t *) "xn--e0wp491f.xn--ud0a3573e", .status = 8} /* 1182 */,
    {.source = (const lxb_char_t *) "xn--e0wp491f.xn--ud0a3573e", .ascii = (const lxb_char_t *) "xn--e0wp491f.xn--ud0a3573e", .status = 8} /* 1183 */,
    {.source = (const lxb_char_t *) "\u0596Ⴋ．𝟳≯︒\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb887c.xn--7-pgoy530h", .status = 8} /* 1184 */,
    {.source = (const lxb_char_t *) "\u0596Ⴋ．𝟳>\u0338︒\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb887c.xn--7-pgoy530h", .status = 8} /* 1185 */,
    {.source = (const lxb_char_t *) "\u0596Ⴋ.7≯。\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb887c.xn--7-pgo.", .status = 8} /* 1186 */,
    {.source = (const lxb_char_t *) "\u0596Ⴋ.7>\u0338。\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb887c.xn--7-pgo.", .status = 8} /* 1187 */,
    {.source = (const lxb_char_t *) "\u0596ⴋ.7>\u0338。\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb613r.xn--7-pgo.", .status = 4} /* 1188 */,
    {.source = (const lxb_char_t *) "\u0596ⴋ.7≯。\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb613r.xn--7-pgo.", .status = 4} /* 1189 */,
    {.source = (const lxb_char_t *) "xn--hcb613r.xn--7-pgo.", .ascii = (const lxb_char_t *) "xn--hcb613r.xn--7-pgo.", .status = 4} /* 1190 */,
    {.source = (const lxb_char_t *) "xn--hcb887c.xn--7-pgo.", .ascii = (const lxb_char_t *) "xn--hcb887c.xn--7-pgo.", .status = 8} /* 1191 */,
    {.source = (const lxb_char_t *) "\u0596ⴋ．𝟳>\u0338︒\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb613r.xn--7-pgoy530h", .status = 8} /* 1192 */,
    {.source = (const lxb_char_t *) "\u0596ⴋ．𝟳≯︒\uFE0A", .ascii = (const lxb_char_t *) "xn--hcb613r.xn--7-pgoy530h", .status = 8} /* 1193 */,
    {.source = (const lxb_char_t *) "xn--hcb613r.xn--7-pgoy530h", .ascii = (const lxb_char_t *) "xn--hcb613r.xn--7-pgoy530h", .status = 8} /* 1194 */,
    {.source = (const lxb_char_t *) "xn--hcb887c.xn--7-pgoy530h", .ascii = (const lxb_char_t *) "xn--hcb887c.xn--7-pgoy530h", .status = 8} /* 1195 */,
    {.source = (const lxb_char_t *) "\u200DF𑓂。󠺨︒\u077E𐹢", .ascii = (const lxb_char_t *) "xn--f-tgn9761i.xn--fqb1637j8hky9452a", .status = 12} /* 1196 */,
    {.source = (const lxb_char_t *) "\u200DF𑓂。󠺨。\u077E𐹢", .ascii = (const lxb_char_t *) "xn--f-tgn9761i.xn--7656e.xn--fqb4175k", .status = 12} /* 1197 */,
    {.source = (const lxb_char_t *) "\u200Df𑓂。󠺨。\u077E𐹢", .ascii = (const lxb_char_t *) "xn--f-tgn9761i.xn--7656e.xn--fqb4175k", .status = 12} /* 1198 */,
    {.source = (const lxb_char_t *) "xn--f-kq9i.xn--7656e.xn--fqb4175k", .ascii = (const lxb_char_t *) "xn--f-kq9i.xn--7656e.xn--fqb4175k", .status = 8} /* 1199 */,
    {.source = (const lxb_char_t *) "xn--f-tgn9761i.xn--7656e.xn--fqb4175k", .ascii = (const lxb_char_t *) "xn--f-tgn9761i.xn--7656e.xn--fqb4175k", .status = 12} /* 1200 */,
    {.source = (const lxb_char_t *) "\u200Df𑓂。󠺨︒\u077E𐹢", .ascii = (const lxb_char_t *) "xn--f-tgn9761i.xn--fqb1637j8hky9452a", .status = 12} /* 1201 */,
    {.source = (const lxb_char_t *) "xn--f-kq9i.xn--fqb1637j8hky9452a", .ascii = (const lxb_char_t *) "xn--f-kq9i.xn--fqb1637j8hky9452a", .status = 8} /* 1202 */,
    {.source = (const lxb_char_t *) "xn--f-tgn9761i.xn--fqb1637j8hky9452a", .ascii = (const lxb_char_t *) "xn--f-tgn9761i.xn--fqb1637j8hky9452a", .status = 12} /* 1203 */,
    {.source = (const lxb_char_t *) "\u0845🄇𐼗︒｡𐹻𑜫", .ascii = (const lxb_char_t *) "xn--3vb4696jpxkjh7s.xn--zo0di2m", .status = 12} /* 1204 */,
    {.source = (const lxb_char_t *) "\u08456,𐼗。。𐹻𑜫", .ascii = (const lxb_char_t *) "xn--6,-r4e4420y..xn--zo0di2m", .status = 14} /* 1205 */,
    {.source = (const lxb_char_t *) "xn--6,-r4e4420y..xn--zo0di2m", .ascii = (const lxb_char_t *) "xn--6,-r4e4420y..xn--zo0di2m", .status = 14} /* 1206 */,
    {.source = (const lxb_char_t *) "xn--3vb4696jpxkjh7s.xn--zo0di2m", .ascii = (const lxb_char_t *) "xn--3vb4696jpxkjh7s.xn--zo0di2m", .status = 12} /* 1207 */,
    {.source = (const lxb_char_t *) "𐹈.\u1DC0𑈱𐦭", .ascii = (const lxb_char_t *) "xn--jn0d.xn--7dg0871h3lf", .status = 12} /* 1208 */,
    {.source = (const lxb_char_t *) "xn--jn0d.xn--7dg0871h3lf", .ascii = (const lxb_char_t *) "xn--jn0d.xn--7dg0871h3lf", .status = 12} /* 1209 */,
    {.source = (const lxb_char_t *) "Ⴂ䠺。𞤃񅏎󙮦\u0693", .ascii = (const lxb_char_t *) "xn--9md875z.xn--pjb9818vg4xno967d", .status = 8} /* 1210 */,
    {.source = (const lxb_char_t *) "ⴂ䠺。𞤥񅏎󙮦\u0693", .ascii = (const lxb_char_t *) "xn--tkj638f.xn--pjb9818vg4xno967d", .status = 8} /* 1211 */,
    {.source = (const lxb_char_t *) "xn--tkj638f.xn--pjb9818vg4xno967d", .ascii = (const lxb_char_t *) "xn--tkj638f.xn--pjb9818vg4xno967d", .status = 8} /* 1212 */,
    {.source = (const lxb_char_t *) "xn--9md875z.xn--pjb9818vg4xno967d", .ascii = (const lxb_char_t *) "xn--9md875z.xn--pjb9818vg4xno967d", .status = 8} /* 1213 */,
    {.source = (const lxb_char_t *) "ⴂ䠺。𞤃񅏎󙮦\u0693", .ascii = (const lxb_char_t *) "xn--tkj638f.xn--pjb9818vg4xno967d", .status = 8} /* 1214 */,
    {.source = (const lxb_char_t *) "🄇伐︒.𜙚\uA8C4", .ascii = (const lxb_char_t *) "xn--woqs083bel0g.xn--0f9ao925c", .status = 4} /* 1215 */,
    {.source = (const lxb_char_t *) "6,伐。.𜙚\uA8C4", .ascii = (const lxb_char_t *) "xn--6,-7i3c..xn--0f9ao925c", .status = 10} /* 1216 */,
    {.source = (const lxb_char_t *) "xn--6,-7i3c..xn--0f9ao925c", .ascii = (const lxb_char_t *) "xn--6,-7i3c..xn--0f9ao925c", .status = 10} /* 1217 */,
    {.source = (const lxb_char_t *) "xn--woqs083bel0g.xn--0f9ao925c", .ascii = (const lxb_char_t *) "xn--woqs083bel0g.xn--0f9ao925c", .status = 4} /* 1218 */,
    {.source = (const lxb_char_t *) "\u200D𐹠\uABED\uFFFB。\u200D𐫓Ⴚ𑂹", .ascii = (const lxb_char_t *) "xn--1ugz126coy7bdbm.xn--ynd959evs1pv6e", .status = 12} /* 1219 */,
    {.source = (const lxb_char_t *) "\u200D𐹠\uABED\uFFFB。\u200D𐫓ⴚ𑂹", .ascii = (const lxb_char_t *) "xn--1ugz126coy7bdbm.xn--1ug062chv7ov6e", .status = 12} /* 1220 */,
    {.source = (const lxb_char_t *) "xn--429az70n29i.xn--ilj7702eqyd", .ascii = (const lxb_char_t *) "xn--429az70n29i.xn--ilj7702eqyd", .status = 16} /* 1221 */,
    {.source = (const lxb_char_t *) "xn--1ugz126coy7bdbm.xn--1ug062chv7ov6e", .ascii = (const lxb_char_t *) "xn--1ugz126coy7bdbm.xn--1ug062chv7ov6e", .status = 12} /* 1222 */,
    {.source = (const lxb_char_t *) "xn--429az70n29i.xn--ynd3619jqyd", .ascii = (const lxb_char_t *) "xn--429az70n29i.xn--ynd3619jqyd", .status = 16} /* 1223 */,
    {.source = (const lxb_char_t *) "xn--1ugz126coy7bdbm.xn--ynd959evs1pv6e", .ascii = (const lxb_char_t *) "xn--1ugz126coy7bdbm.xn--ynd959evs1pv6e", .status = 12} /* 1224 */,
    {.source = (const lxb_char_t *) "󠆠．񷐴󌟈", .ascii = (const lxb_char_t *) ".xn--rx21bhv12i", .status = 10} /* 1225 */,
    {.source = (const lxb_char_t *) "󠆠.񷐴󌟈", .ascii = (const lxb_char_t *) ".xn--rx21bhv12i", .status = 10} /* 1226 */,
    {.source = (const lxb_char_t *) ".xn--rx21bhv12i", .ascii = (const lxb_char_t *) ".xn--rx21bhv12i", .status = 10} /* 1227 */,
    {.source = (const lxb_char_t *) "𐫃\u200CႦ.≠𞷙", .ascii = (const lxb_char_t *) "xn--end799ekr1p.xn--1ch2802p", .status = 20} /* 1228 */,
    {.source = (const lxb_char_t *) "𐫃\u200CႦ.=\u0338𞷙", .ascii = (const lxb_char_t *) "xn--end799ekr1p.xn--1ch2802p", .status = 20} /* 1229 */,
    {.source = (const lxb_char_t *) "𐫃\u200Cⴆ.=\u0338𞷙", .ascii = (const lxb_char_t *) "xn--0ug132csv7o.xn--1ch2802p", .status = 20} /* 1230 */,
    {.source = (const lxb_char_t *) "𐫃\u200Cⴆ.≠𞷙", .ascii = (const lxb_char_t *) "xn--0ug132csv7o.xn--1ch2802p", .status = 20} /* 1231 */,
    {.source = (const lxb_char_t *) "xn--xkjz802e.xn--1ch2802p", .ascii = (const lxb_char_t *) "xn--xkjz802e.xn--1ch2802p", .status = 16} /* 1232 */,
    {.source = (const lxb_char_t *) "xn--0ug132csv7o.xn--1ch2802p", .ascii = (const lxb_char_t *) "xn--0ug132csv7o.xn--1ch2802p", .status = 20} /* 1233 */,
    {.source = (const lxb_char_t *) "xn--end1719j.xn--1ch2802p", .ascii = (const lxb_char_t *) "xn--end1719j.xn--1ch2802p", .status = 16} /* 1234 */,
    {.source = (const lxb_char_t *) "xn--end799ekr1p.xn--1ch2802p", .ascii = (const lxb_char_t *) "xn--end799ekr1p.xn--1ch2802p", .status = 20} /* 1235 */,
    {.source = (const lxb_char_t *) "󠁲𙩢𝟥ꘌ．\u0841", .ascii = (const lxb_char_t *) "xn--3-0g3es485d8i15h.xn--zvb", .status = 8} /* 1236 */,
    {.source = (const lxb_char_t *) "󠁲𙩢3ꘌ.\u0841", .ascii = (const lxb_char_t *) "xn--3-0g3es485d8i15h.xn--zvb", .status = 8} /* 1237 */,
    {.source = (const lxb_char_t *) "xn--3-0g3es485d8i15h.xn--zvb", .ascii = (const lxb_char_t *) "xn--3-0g3es485d8i15h.xn--zvb", .status = 8} /* 1238 */,
    {.source = (const lxb_char_t *) "-.\u1886󡲣-", .ascii = (const lxb_char_t *) "-.xn----pbkx6497q", .status = 12} /* 1239 */,
    {.source = (const lxb_char_t *) "-.xn----pbkx6497q", .ascii = (const lxb_char_t *) "-.xn----pbkx6497q", .status = 12} /* 1240 */,
    {.source = (const lxb_char_t *) "󲚗\u200C｡\u200C𞰆ς", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--3xa795lhn92a", .status = 16} /* 1241 */,
    {.source = (const lxb_char_t *) "󲚗\u200C。\u200C𞰆ς", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--3xa795lhn92a", .status = 16} /* 1242 */,
    {.source = (const lxb_char_t *) "󲚗\u200C。\u200C𞰆Σ", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--4xa595lhn92a", .status = 16} /* 1243 */,
    {.source = (const lxb_char_t *) "󲚗\u200C。\u200C𞰆σ", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--4xa595lhn92a", .status = 16} /* 1244 */,
    {.source = (const lxb_char_t *) "xn--qp42f.xn--4xa3011w", .ascii = (const lxb_char_t *) "xn--qp42f.xn--4xa3011w", .status = 12} /* 1245 */,
    {.source = (const lxb_char_t *) "xn--0ug76062m.xn--4xa595lhn92a", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--4xa595lhn92a", .status = 16} /* 1246 */,
    {.source = (const lxb_char_t *) "xn--0ug76062m.xn--3xa795lhn92a", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--3xa795lhn92a", .status = 16} /* 1247 */,
    {.source = (const lxb_char_t *) "󲚗\u200C｡\u200C𞰆Σ", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--4xa595lhn92a", .status = 16} /* 1248 */,
    {.source = (const lxb_char_t *) "󲚗\u200C｡\u200C𞰆σ", .ascii = (const lxb_char_t *) "xn--0ug76062m.xn--4xa595lhn92a", .status = 16} /* 1249 */,
    {.source = (const lxb_char_t *) "堕𑓂\u1B02。𐮇𞤽\u200C-", .ascii = (const lxb_char_t *) "xn--5sf345zdk8h.xn----rgnt157hwl9g", .status = 12} /* 1250 */,
    {.source = (const lxb_char_t *) "堕𑓂\u1B02。𐮇𞤛\u200C-", .ascii = (const lxb_char_t *) "xn--5sf345zdk8h.xn----rgnt157hwl9g", .status = 12} /* 1251 */,
    {.source = (const lxb_char_t *) "xn--5sf345zdk8h.xn----iv5iw606c", .ascii = (const lxb_char_t *) "xn--5sf345zdk8h.xn----iv5iw606c", .status = 8} /* 1252 */,
    {.source = (const lxb_char_t *) "xn--5sf345zdk8h.xn----rgnt157hwl9g", .ascii = (const lxb_char_t *) "xn--5sf345zdk8h.xn----rgnt157hwl9g", .status = 12} /* 1253 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢｡ᡥς\u062Aς", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xaa16plx4a", .status = 8} /* 1254 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢。ᡥς\u062Aς", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xaa16plx4a", .status = 8} /* 1255 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤀。ᡥΣ\u062AΣ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1256 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢。ᡥσ\u062Aσ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1257 */,
    {.source = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1258 */,
    {.source = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xaa16plx4a", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xaa16plx4a", .status = 8} /* 1259 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤀｡ᡥΣ\u062AΣ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1260 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢｡ᡥσ\u062Aσ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1261 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢。ᡥΣ\u062AΣ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1262 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢。ᡥΣ\u062Aσ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1263 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢。ᡥΣ\u062Aς", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xab95plx4a", .status = 8} /* 1264 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢。ᡥσ\u062Aς", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xab95plx4a", .status = 8} /* 1265 */,
    {.source = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xab95plx4a", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xab95plx4a", .status = 8} /* 1266 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢｡ᡥΣ\u062AΣ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1267 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢｡ᡥΣ\u062Aσ", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--4xaa85plx4a", .status = 8} /* 1268 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢｡ᡥΣ\u062Aς", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xab95plx4a", .status = 8} /* 1269 */,
    {.source = (const lxb_char_t *) "𐹶𑁆ᡕ𞤢｡ᡥσ\u062Aς", .ascii = (const lxb_char_t *) "xn--l8e1317j1ebz456b.xn--3xab95plx4a", .status = 8} /* 1270 */,
    {.source = (const lxb_char_t *) "󏒰．-𝟻ß", .ascii = (const lxb_char_t *) "xn--t960e.xn---5-hia", .status = 8} /* 1271 */,
    {.source = (const lxb_char_t *) "󏒰.-5ß", .ascii = (const lxb_char_t *) "xn--t960e.xn---5-hia", .status = 8} /* 1272 */,
    {.source = (const lxb_char_t *) "󏒰.-5SS", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1273 */,
    {.source = (const lxb_char_t *) "󏒰.-5ss", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1274 */,
    {.source = (const lxb_char_t *) "xn--t960e.-5ss", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1275 */,
    {.source = (const lxb_char_t *) "xn--t960e.xn---5-hia", .ascii = (const lxb_char_t *) "xn--t960e.xn---5-hia", .status = 8} /* 1276 */,
    {.source = (const lxb_char_t *) "󏒰．-𝟻SS", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1277 */,
    {.source = (const lxb_char_t *) "󏒰．-𝟻ss", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1278 */,
    {.source = (const lxb_char_t *) "󏒰．-𝟻Ss", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1279 */,
    {.source = (const lxb_char_t *) "󏒰.-5Ss", .ascii = (const lxb_char_t *) "xn--t960e.-5ss", .status = 8} /* 1280 */,
    {.source = (const lxb_char_t *) "\u200D𐨿.🤒Ⴥ򑮶", .ascii = (const lxb_char_t *) "xn--1ug9533g.xn--9nd3211w0gz4b", .status = 8} /* 1281 */,
    {.source = (const lxb_char_t *) "\u200D𐨿.🤒ⴥ򑮶", .ascii = (const lxb_char_t *) "xn--1ug9533g.xn--tljz038l0gz4b", .status = 8} /* 1282 */,
    {.source = (const lxb_char_t *) "xn--0s9c.xn--tljz038l0gz4b", .ascii = (const lxb_char_t *) "xn--0s9c.xn--tljz038l0gz4b", .status = 8} /* 1283 */,
    {.source = (const lxb_char_t *) "xn--1ug9533g.xn--tljz038l0gz4b", .ascii = (const lxb_char_t *) "xn--1ug9533g.xn--tljz038l0gz4b", .status = 8} /* 1284 */,
    {.source = (const lxb_char_t *) "xn--0s9c.xn--9nd3211w0gz4b", .ascii = (const lxb_char_t *) "xn--0s9c.xn--9nd3211w0gz4b", .status = 8} /* 1285 */,
    {.source = (const lxb_char_t *) "xn--1ug9533g.xn--9nd3211w0gz4b", .ascii = (const lxb_char_t *) "xn--1ug9533g.xn--9nd3211w0gz4b", .status = 8} /* 1286 */,
    {.source = (const lxb_char_t *) "𵋅。ß𬵩\u200D", .ascii = (const lxb_char_t *) "xn--ey1p.xn--zca870nz438b", .status = 8} /* 1287 */,
    {.source = (const lxb_char_t *) "𵋅。SS𬵩\u200D", .ascii = (const lxb_char_t *) "xn--ey1p.xn--ss-n1tx0508a", .status = 8} /* 1288 */,
    {.source = (const lxb_char_t *) "𵋅。ss𬵩\u200D", .ascii = (const lxb_char_t *) "xn--ey1p.xn--ss-n1tx0508a", .status = 8} /* 1289 */,
    {.source = (const lxb_char_t *) "𵋅。Ss𬵩\u200D", .ascii = (const lxb_char_t *) "xn--ey1p.xn--ss-n1tx0508a", .status = 8} /* 1290 */,
    {.source = (const lxb_char_t *) "xn--ey1p.xn--ss-eq36b", .ascii = (const lxb_char_t *) "xn--ey1p.xn--ss-eq36b", .status = 4} /* 1291 */,
    {.source = (const lxb_char_t *) "xn--ey1p.xn--ss-n1tx0508a", .ascii = (const lxb_char_t *) "xn--ey1p.xn--ss-n1tx0508a", .status = 8} /* 1292 */,
    {.source = (const lxb_char_t *) "xn--ey1p.xn--zca870nz438b", .ascii = (const lxb_char_t *) "xn--ey1p.xn--zca870nz438b", .status = 8} /* 1293 */,
    {.source = (const lxb_char_t *) "\u200C𭉝。\u07F1\u0301𞹻", .ascii = (const lxb_char_t *) "xn--0ugy003y.xn--lsa46nuub", .status = 12} /* 1294 */,
    {.source = (const lxb_char_t *) "\u200C𭉝。\u07F1\u0301\u063A", .ascii = (const lxb_char_t *) "xn--0ugy003y.xn--lsa46nuub", .status = 12} /* 1295 */,
    {.source = (const lxb_char_t *) "xn--634m.xn--lsa46nuub", .ascii = (const lxb_char_t *) "xn--634m.xn--lsa46nuub", .status = 8} /* 1296 */,
    {.source = (const lxb_char_t *) "xn--0ugy003y.xn--lsa46nuub", .ascii = (const lxb_char_t *) "xn--0ugy003y.xn--lsa46nuub", .status = 12} /* 1297 */,
    {.source = (const lxb_char_t *) "𞼌\u200C𑈶。𐹡", .ascii = (const lxb_char_t *) "xn--0ug7946gzpxf.xn--8n0d", .status = 16} /* 1298 */,
    {.source = (const lxb_char_t *) "xn--9g1d1288a.xn--8n0d", .ascii = (const lxb_char_t *) "xn--9g1d1288a.xn--8n0d", .status = 8} /* 1299 */,
    {.source = (const lxb_char_t *) "xn--0ug7946gzpxf.xn--8n0d", .ascii = (const lxb_char_t *) "xn--0ug7946gzpxf.xn--8n0d", .status = 16} /* 1300 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭｡𑖿\u1ABBς≠", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", .status = 12} /* 1301 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭｡𑖿\u1ABBς=\u0338", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", .status = 12} /* 1302 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭。𑖿\u1ABBς≠", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", .status = 12} /* 1303 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭。𑖿\u1ABBς=\u0338", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", .status = 12} /* 1304 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭。𑖿\u1ABBΣ=\u0338", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1305 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭。𑖿\u1ABBΣ≠", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1306 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭。𑖿\u1ABBσ≠", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1307 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭。𑖿\u1ABBσ=\u0338", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1308 */,
    {.source = (const lxb_char_t *) "xn--zb9h5968x.xn--4xa378i1mfjw7y", .ascii = (const lxb_char_t *) "xn--zb9h5968x.xn--4xa378i1mfjw7y", .status = 8} /* 1309 */,
    {.source = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1310 */,
    {.source = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--3xa578i1mfjw7y", .status = 12} /* 1311 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭｡𑖿\u1ABBΣ=\u0338", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1312 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭｡𑖿\u1ABBΣ≠", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1313 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭｡𑖿\u1ABBσ≠", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1314 */,
    {.source = (const lxb_char_t *) "󠅯򇽭\u200C🜭｡𑖿\u1ABBσ=\u0338", .ascii = (const lxb_char_t *) "xn--0ug3766p5nm1b.xn--4xa378i1mfjw7y", .status = 12} /* 1315 */,
    {.source = (const lxb_char_t *) "⒋｡⒈\u200D򳴢", .ascii = (const lxb_char_t *) "xn--wsh.xn--1ug58o74922a", .status = 8} /* 1316 */,
    {.source = (const lxb_char_t *) "4.。1.\u200D򳴢", .ascii = (const lxb_char_t *) "4..1.xn--1ug64613i", .status = 14} /* 1317 */,
    {.source = (const lxb_char_t *) "4..1.xn--sf51d", .ascii = (const lxb_char_t *) "4..1.xn--sf51d", .status = 10} /* 1318 */,
    {.source = (const lxb_char_t *) "4..1.xn--1ug64613i", .ascii = (const lxb_char_t *) "4..1.xn--1ug64613i", .status = 14} /* 1319 */,
    {.source = (const lxb_char_t *) "xn--wsh.xn--tsh07994h", .ascii = (const lxb_char_t *) "xn--wsh.xn--tsh07994h", .status = 4} /* 1320 */,
    {.source = (const lxb_char_t *) "xn--wsh.xn--1ug58o74922a", .ascii = (const lxb_char_t *) "xn--wsh.xn--1ug58o74922a", .status = 8} /* 1321 */,
    {.source = (const lxb_char_t *) "\u0644ß｡𐇽\u1A60򾅢𞤾", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1322 */,
    {.source = (const lxb_char_t *) "\u0644ß｡\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1323 */,
    {.source = (const lxb_char_t *) "\u0644ß。\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1324 */,
    {.source = (const lxb_char_t *) "\u0644SS。\u1A60𐇽򾅢𞤜", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1325 */,
    {.source = (const lxb_char_t *) "\u0644ss。\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1326 */,
    {.source = (const lxb_char_t *) "\u0644ss。\u1A60𐇽򾅢𞤜", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1327 */,
    {.source = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1328 */,
    {.source = (const lxb_char_t *) "\u0644ß。\u1A60𐇽򾅢𞤜", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1329 */,
    {.source = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1330 */,
    {.source = (const lxb_char_t *) "\u0644SS｡\u1A60𐇽򾅢𞤜", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1331 */,
    {.source = (const lxb_char_t *) "\u0644ss｡\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1332 */,
    {.source = (const lxb_char_t *) "\u0644ss｡\u1A60𐇽򾅢𞤜", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1333 */,
    {.source = (const lxb_char_t *) "\u0644ß｡\u1A60𐇽򾅢𞤜", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1334 */,
    {.source = (const lxb_char_t *) "\u0644SS｡𐇽\u1A60򾅢𞤜", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1335 */,
    {.source = (const lxb_char_t *) "\u0644ss｡𐇽\u1A60򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1336 */,
    {.source = (const lxb_char_t *) "\u0644ss｡𐇽\u1A60򾅢𞤜", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1337 */,
    {.source = (const lxb_char_t *) "\u0644ß｡𐇽\u1A60򾅢𞤜", .ascii = (const lxb_char_t *) "xn--zca57y.xn--jof2298hn83fln78f", .status = 20} /* 1338 */,
    {.source = (const lxb_char_t *) "\u0644SS。\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1339 */,
    {.source = (const lxb_char_t *) "\u0644Ss。\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1340 */,
    {.source = (const lxb_char_t *) "\u0644SS｡\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1341 */,
    {.source = (const lxb_char_t *) "\u0644Ss｡\u1A60𐇽򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1342 */,
    {.source = (const lxb_char_t *) "\u0644SS｡𐇽\u1A60򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1343 */,
    {.source = (const lxb_char_t *) "\u0644Ss｡𐇽\u1A60򾅢𞤾", .ascii = (const lxb_char_t *) "xn--ss-svd.xn--jof2298hn83fln78f", .status = 20} /* 1344 */,
    {.source = (const lxb_char_t *) "𐹽𑄳񼜲.\u1DDF\u17B8\uA806𑜫", .ascii = (const lxb_char_t *) "xn--1o0di0c0652w.xn--33e362arr1l153d", .status = 12} /* 1345 */,
    {.source = (const lxb_char_t *) "xn--1o0di0c0652w.xn--33e362arr1l153d", .ascii = (const lxb_char_t *) "xn--1o0di0c0652w.xn--33e362arr1l153d", .status = 12} /* 1346 */,
    {.source = (const lxb_char_t *) "Ⴓ𑜫\u200D򗭓．\u06A7𑰶", .ascii = (const lxb_char_t *) "xn--rnd479ep20q7x12e.xn--9jb4223l", .status = 4} /* 1347 */,
    {.source = (const lxb_char_t *) "Ⴓ𑜫\u200D򗭓.\u06A7𑰶", .ascii = (const lxb_char_t *) "xn--rnd479ep20q7x12e.xn--9jb4223l", .status = 4} /* 1348 */,
    {.source = (const lxb_char_t *) "ⴓ𑜫\u200D򗭓.\u06A7𑰶", .ascii = (const lxb_char_t *) "xn--1ugy52cym7p7xu5e.xn--9jb4223l", .status = 4} /* 1349 */,
    {.source = (const lxb_char_t *) "xn--blj6306ey091d.xn--9jb4223l", .ascii = (const lxb_char_t *) "xn--blj6306ey091d.xn--9jb4223l", .status = 4} /* 1350 */,
    {.source = (const lxb_char_t *) "xn--1ugy52cym7p7xu5e.xn--9jb4223l", .ascii = (const lxb_char_t *) "xn--1ugy52cym7p7xu5e.xn--9jb4223l", .status = 4} /* 1351 */,
    {.source = (const lxb_char_t *) "xn--rnd8945ky009c.xn--9jb4223l", .ascii = (const lxb_char_t *) "xn--rnd8945ky009c.xn--9jb4223l", .status = 4} /* 1352 */,
    {.source = (const lxb_char_t *) "xn--rnd479ep20q7x12e.xn--9jb4223l", .ascii = (const lxb_char_t *) "xn--rnd479ep20q7x12e.xn--9jb4223l", .status = 4} /* 1353 */,
    {.source = (const lxb_char_t *) "ⴓ𑜫\u200D򗭓．\u06A7𑰶", .ascii = (const lxb_char_t *) "xn--1ugy52cym7p7xu5e.xn--9jb4223l", .status = 4} /* 1354 */,
    {.source = (const lxb_char_t *) "𐨿.🄆—", .ascii = (const lxb_char_t *) "xn--0s9c.xn--8ug8324p", .status = 8} /* 1355 */,
    {.source = (const lxb_char_t *) "𐨿.5,—", .ascii = (const lxb_char_t *) "xn--0s9c.xn--5,-81t", .status = 8} /* 1356 */,
    {.source = (const lxb_char_t *) "xn--0s9c.xn--5,-81t", .ascii = (const lxb_char_t *) "xn--0s9c.xn--5,-81t", .status = 8} /* 1357 */,
    {.source = (const lxb_char_t *) "xn--0s9c.xn--8ug8324p", .ascii = (const lxb_char_t *) "xn--0s9c.xn--8ug8324p", .status = 8} /* 1358 */,
    {.source = (const lxb_char_t *) "򔊱񁦮۸。󠾭-", .ascii = (const lxb_char_t *) "xn--lmb18944c0g2z.xn----2k81m", .status = 8} /* 1359 */,
    {.source = (const lxb_char_t *) "xn--lmb18944c0g2z.xn----2k81m", .ascii = (const lxb_char_t *) "xn--lmb18944c0g2z.xn----2k81m", .status = 8} /* 1360 */,
    {.source = (const lxb_char_t *) "𼗸\u07CD𐹮。\u06DDᡎᠴ", .ascii = (const lxb_char_t *) "xn--osb0855kcc2r.xn--tlb299fhc", .status = 16} /* 1361 */,
    {.source = (const lxb_char_t *) "xn--osb0855kcc2r.xn--tlb299fhc", .ascii = (const lxb_char_t *) "xn--osb0855kcc2r.xn--tlb299fhc", .status = 16} /* 1362 */,
    {.source = (const lxb_char_t *) "\u200DᠮႾ🄂.🚗\u0841𮹌\u200C", .ascii = (const lxb_char_t *) "xn--2nd129ay2gnw71c.xn--zvb692j9664aic1g", .status = 16} /* 1363 */,
    {.source = (const lxb_char_t *) "\u200DᠮႾ1,.🚗\u0841𮹌\u200C", .ascii = (const lxb_char_t *) "xn--1,-ogkx89c39j.xn--zvb692j9664aic1g", .status = 16} /* 1364 */,
    {.source = (const lxb_char_t *) "\u200Dᠮⴞ1,.🚗\u0841𮹌\u200C", .ascii = (const lxb_char_t *) "xn--1,-v3o161c53q.xn--zvb692j9664aic1g", .status = 16} /* 1365 */,
    {.source = (const lxb_char_t *) "xn--1,-v3o625k.xn--zvb3124wpkpf", .ascii = (const lxb_char_t *) "xn--1,-v3o625k.xn--zvb3124wpkpf", .status = 12} /* 1366 */,
    {.source = (const lxb_char_t *) "xn--1,-v3o161c53q.xn--zvb692j9664aic1g", .ascii = (const lxb_char_t *) "xn--1,-v3o161c53q.xn--zvb692j9664aic1g", .status = 16} /* 1367 */,
    {.source = (const lxb_char_t *) "xn--1,-ogkx89c.xn--zvb3124wpkpf", .ascii = (const lxb_char_t *) "xn--1,-ogkx89c.xn--zvb3124wpkpf", .status = 12} /* 1368 */,
    {.source = (const lxb_char_t *) "xn--1,-ogkx89c39j.xn--zvb692j9664aic1g", .ascii = (const lxb_char_t *) "xn--1,-ogkx89c39j.xn--zvb692j9664aic1g", .status = 16} /* 1369 */,
    {.source = (const lxb_char_t *) "\u200Dᠮⴞ🄂.🚗\u0841𮹌\u200C", .ascii = (const lxb_char_t *) "xn--h7e341b0wlbv45b.xn--zvb692j9664aic1g", .status = 16} /* 1370 */,
    {.source = (const lxb_char_t *) "xn--h7e438h1p44a.xn--zvb3124wpkpf", .ascii = (const lxb_char_t *) "xn--h7e438h1p44a.xn--zvb3124wpkpf", .status = 8} /* 1371 */,
    {.source = (const lxb_char_t *) "xn--h7e341b0wlbv45b.xn--zvb692j9664aic1g", .ascii = (const lxb_char_t *) "xn--h7e341b0wlbv45b.xn--zvb692j9664aic1g", .status = 16} /* 1372 */,
    {.source = (const lxb_char_t *) "xn--2nd129ai554b.xn--zvb3124wpkpf", .ascii = (const lxb_char_t *) "xn--2nd129ai554b.xn--zvb3124wpkpf", .status = 8} /* 1373 */,
    {.source = (const lxb_char_t *) "xn--2nd129ay2gnw71c.xn--zvb692j9664aic1g", .ascii = (const lxb_char_t *) "xn--2nd129ay2gnw71c.xn--zvb692j9664aic1g", .status = 16} /* 1374 */,
    {.source = (const lxb_char_t *) "\u0601\u0697．𑚶񼡷⾆", .ascii = (const lxb_char_t *) "xn--jfb41a.xn--tc1ap851axo39c", .status = 12} /* 1375 */,
    {.source = (const lxb_char_t *) "\u0601\u0697.𑚶񼡷舌", .ascii = (const lxb_char_t *) "xn--jfb41a.xn--tc1ap851axo39c", .status = 12} /* 1376 */,
    {.source = (const lxb_char_t *) "xn--jfb41a.xn--tc1ap851axo39c", .ascii = (const lxb_char_t *) "xn--jfb41a.xn--tc1ap851axo39c", .status = 12} /* 1377 */,
    {.source = (const lxb_char_t *) "🞅󠳡󜍙.񲖷", .ascii = (const lxb_char_t *) "xn--ie9hi1349bqdlb.xn--oj69a", .status = 4} /* 1378 */,
    {.source = (const lxb_char_t *) "xn--ie9hi1349bqdlb.xn--oj69a", .ascii = (const lxb_char_t *) "xn--ie9hi1349bqdlb.xn--oj69a", .status = 4} /* 1379 */,
    {.source = (const lxb_char_t *) "\u20E7񯡎-򫣝.4Ⴄ\u200C", .ascii = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-f0g649i", .status = 12} /* 1380 */,
    {.source = (const lxb_char_t *) "\u20E7񯡎-򫣝.4ⴄ\u200C", .ascii = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-sgn589c", .status = 12} /* 1381 */,
    {.source = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-ivs", .ascii = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-ivs", .status = 8} /* 1382 */,
    {.source = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-sgn589c", .ascii = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-sgn589c", .status = 12} /* 1383 */,
    {.source = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-f0g", .ascii = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-f0g", .status = 8} /* 1384 */,
    {.source = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-f0g649i", .ascii = (const lxb_char_t *) "xn----9snu5320fi76w.xn--4-f0g649i", .status = 12} /* 1385 */,
    {.source = (const lxb_char_t *) "ᚭ｡𝌠ß𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--zca4946pblnc", .status = 0} /* 1386 */,
    {.source = (const lxb_char_t *) "ᚭ。𝌠ß𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--zca4946pblnc", .status = 0} /* 1387 */,
    {.source = (const lxb_char_t *) "ᚭ。𝌠SS𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1388 */,
    {.source = (const lxb_char_t *) "ᚭ。𝌠ss𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1389 */,
    {.source = (const lxb_char_t *) "ᚭ。𝌠Ss𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1390 */,
    {.source = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1391 */,
    {.source = (const lxb_char_t *) "ᚭ.𝌠ss𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1392 */,
    {.source = (const lxb_char_t *) "ᚭ.𝌠SS𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1393 */,
    {.source = (const lxb_char_t *) "ᚭ.𝌠Ss𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1394 */,
    {.source = (const lxb_char_t *) "xn--hwe.xn--zca4946pblnc", .ascii = (const lxb_char_t *) "xn--hwe.xn--zca4946pblnc", .status = 0} /* 1395 */,
    {.source = (const lxb_char_t *) "ᚭ.𝌠ß𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--zca4946pblnc", .status = 0} /* 1396 */,
    {.source = (const lxb_char_t *) "ᚭ｡𝌠SS𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1397 */,
    {.source = (const lxb_char_t *) "ᚭ｡𝌠ss𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1398 */,
    {.source = (const lxb_char_t *) "ᚭ｡𝌠Ss𖫱", .ascii = (const lxb_char_t *) "xn--hwe.xn--ss-ci1ub261a", .status = 0} /* 1399 */,
    {.source = (const lxb_char_t *) "₁｡𞤫ꡪ", .ascii = (const lxb_char_t *) "1.xn--gd9al691d", .status = 12} /* 1400 */,
    {.source = (const lxb_char_t *) "1。𞤫ꡪ", .ascii = (const lxb_char_t *) "1.xn--gd9al691d", .status = 12} /* 1401 */,
    {.source = (const lxb_char_t *) "1。𞤉ꡪ", .ascii = (const lxb_char_t *) "1.xn--gd9al691d", .status = 12} /* 1402 */,
    {.source = (const lxb_char_t *) "1.xn--gd9al691d", .ascii = (const lxb_char_t *) "1.xn--gd9al691d", .status = 12} /* 1403 */,
    {.source = (const lxb_char_t *) "₁｡𞤉ꡪ", .ascii = (const lxb_char_t *) "1.xn--gd9al691d", .status = 12} /* 1404 */,
    {.source = (const lxb_char_t *) "𯻼\u200C.𞶞򻙤񥘇", .ascii = (const lxb_char_t *) "xn--0ug27500a.xn--2b7hs861pl540a", .status = 20} /* 1405 */,
    {.source = (const lxb_char_t *) "xn--kg4n.xn--2b7hs861pl540a", .ascii = (const lxb_char_t *) "xn--kg4n.xn--2b7hs861pl540a", .status = 12} /* 1406 */,
    {.source = (const lxb_char_t *) "xn--0ug27500a.xn--2b7hs861pl540a", .ascii = (const lxb_char_t *) "xn--0ug27500a.xn--2b7hs861pl540a", .status = 20} /* 1407 */,
    {.source = (const lxb_char_t *) "𑑄≯｡𑜤", .ascii = (const lxb_char_t *) "xn--hdh5636g.xn--ci2d", .status = 4} /* 1408 */,
    {.source = (const lxb_char_t *) "𑑄>\u0338｡𑜤", .ascii = (const lxb_char_t *) "xn--hdh5636g.xn--ci2d", .status = 4} /* 1409 */,
    {.source = (const lxb_char_t *) "𑑄≯。𑜤", .ascii = (const lxb_char_t *) "xn--hdh5636g.xn--ci2d", .status = 4} /* 1410 */,
    {.source = (const lxb_char_t *) "𑑄>\u0338。𑜤", .ascii = (const lxb_char_t *) "xn--hdh5636g.xn--ci2d", .status = 4} /* 1411 */,
    {.source = (const lxb_char_t *) "xn--hdh5636g.xn--ci2d", .ascii = (const lxb_char_t *) "xn--hdh5636g.xn--ci2d", .status = 4} /* 1412 */,
    {.source = (const lxb_char_t *) "Ⴋ≮𱲆。\u200D\u07A7𐋣", .ascii = (const lxb_char_t *) "xn--jnd802gsm17c.xn--lrb506jqr4n", .status = 8} /* 1413 */,
    {.source = (const lxb_char_t *) "Ⴋ<\u0338𱲆。\u200D\u07A7𐋣", .ascii = (const lxb_char_t *) "xn--jnd802gsm17c.xn--lrb506jqr4n", .status = 8} /* 1414 */,
    {.source = (const lxb_char_t *) "ⴋ<\u0338𱲆。\u200D\u07A7𐋣", .ascii = (const lxb_char_t *) "xn--gdhz03bxt42d.xn--lrb506jqr4n", .status = 4} /* 1415 */,
    {.source = (const lxb_char_t *) "ⴋ≮𱲆。\u200D\u07A7𐋣", .ascii = (const lxb_char_t *) "xn--gdhz03bxt42d.xn--lrb506jqr4n", .status = 4} /* 1416 */,
    {.source = (const lxb_char_t *) "xn--gdhz03bxt42d.xn--lrb6479j", .ascii = (const lxb_char_t *) "xn--gdhz03bxt42d.xn--lrb6479j", .status = 4} /* 1417 */,
    {.source = (const lxb_char_t *) "xn--gdhz03bxt42d.xn--lrb506jqr4n", .ascii = (const lxb_char_t *) "xn--gdhz03bxt42d.xn--lrb506jqr4n", .status = 4} /* 1418 */,
    {.source = (const lxb_char_t *) "xn--jnd802gsm17c.xn--lrb6479j", .ascii = (const lxb_char_t *) "xn--jnd802gsm17c.xn--lrb6479j", .status = 8} /* 1419 */,
    {.source = (const lxb_char_t *) "xn--jnd802gsm17c.xn--lrb506jqr4n", .ascii = (const lxb_char_t *) "xn--jnd802gsm17c.xn--lrb506jqr4n", .status = 8} /* 1420 */,
    {.source = (const lxb_char_t *) "\u17D2.򆽒≯", .ascii = (const lxb_char_t *) "xn--u4e.xn--hdhx0084f", .status = 8} /* 1421 */,
    {.source = (const lxb_char_t *) "\u17D2.򆽒>\u0338", .ascii = (const lxb_char_t *) "xn--u4e.xn--hdhx0084f", .status = 8} /* 1422 */,
    {.source = (const lxb_char_t *) "xn--u4e.xn--hdhx0084f", .ascii = (const lxb_char_t *) "xn--u4e.xn--hdhx0084f", .status = 8} /* 1423 */,
    {.source = (const lxb_char_t *) "񏁇\u1734．𐨺É⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1424 */,
    {.source = (const lxb_char_t *) "񏁇\u1734．𐨺E\u0301⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1425 */,
    {.source = (const lxb_char_t *) "񏁇\u1734.𐨺É⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1426 */,
    {.source = (const lxb_char_t *) "񏁇\u1734.𐨺E\u0301⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1427 */,
    {.source = (const lxb_char_t *) "񏁇\u1734.𐨺e\u0301⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1428 */,
    {.source = (const lxb_char_t *) "񏁇\u1734.𐨺é⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1429 */,
    {.source = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1430 */,
    {.source = (const lxb_char_t *) "񏁇\u1734．𐨺e\u0301⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1431 */,
    {.source = (const lxb_char_t *) "񏁇\u1734．𐨺é⬓𑄴", .ascii = (const lxb_char_t *) "xn--c0e34564d.xn--9ca207st53lg3f", .status = 8} /* 1432 */,
    {.source = (const lxb_char_t *) "ᢇ\u200D\uA8C4｡︒𞤺", .ascii = (const lxb_char_t *) "xn--09e669a6x8j.xn--y86cv562b", .status = 16} /* 1433 */,
    {.source = (const lxb_char_t *) "ᢇ\u200D\uA8C4。。𞤺", .ascii = (const lxb_char_t *) "xn--09e669a6x8j..xn--ye6h", .status = 14} /* 1434 */,
    {.source = (const lxb_char_t *) "ᢇ\u200D\uA8C4。。𞤘", .ascii = (const lxb_char_t *) "xn--09e669a6x8j..xn--ye6h", .status = 14} /* 1435 */,
    {.source = (const lxb_char_t *) "xn--09e4694e..xn--ye6h", .ascii = (const lxb_char_t *) "xn--09e4694e..xn--ye6h", .status = 6} /* 1436 */,
    {.source = (const lxb_char_t *) "xn--09e669a6x8j..xn--ye6h", .ascii = (const lxb_char_t *) "xn--09e669a6x8j..xn--ye6h", .status = 14} /* 1437 */,
    {.source = (const lxb_char_t *) "ᢇ\u200D\uA8C4｡︒𞤘", .ascii = (const lxb_char_t *) "xn--09e669a6x8j.xn--y86cv562b", .status = 16} /* 1438 */,
    {.source = (const lxb_char_t *) "xn--09e4694e.xn--y86cv562b", .ascii = (const lxb_char_t *) "xn--09e4694e.xn--y86cv562b", .status = 8} /* 1439 */,
    {.source = (const lxb_char_t *) "xn--09e669a6x8j.xn--y86cv562b", .ascii = (const lxb_char_t *) "xn--09e669a6x8j.xn--y86cv562b", .status = 16} /* 1440 */,
    {.source = (const lxb_char_t *) "𞩬򖙱\u1714\u200C｡\u0631\u07AA≮", .ascii = (const lxb_char_t *) "xn--fze607b9651bjwl7c.xn--wgb86el10d", .status = 12} /* 1441 */,
    {.source = (const lxb_char_t *) "𞩬򖙱\u1714\u200C｡\u0631\u07AA<\u0338", .ascii = (const lxb_char_t *) "xn--fze607b9651bjwl7c.xn--wgb86el10d", .status = 12} /* 1442 */,
    {.source = (const lxb_char_t *) "𞩬򖙱\u1714\u200C。\u0631\u07AA≮", .ascii = (const lxb_char_t *) "xn--fze607b9651bjwl7c.xn--wgb86el10d", .status = 12} /* 1443 */,
    {.source = (const lxb_char_t *) "𞩬򖙱\u1714\u200C。\u0631\u07AA<\u0338", .ascii = (const lxb_char_t *) "xn--fze607b9651bjwl7c.xn--wgb86el10d", .status = 12} /* 1444 */,
    {.source = (const lxb_char_t *) "xn--fze3930v7hz6b.xn--wgb86el10d", .ascii = (const lxb_char_t *) "xn--fze3930v7hz6b.xn--wgb86el10d", .status = 12} /* 1445 */,
    {.source = (const lxb_char_t *) "xn--fze607b9651bjwl7c.xn--wgb86el10d", .ascii = (const lxb_char_t *) "xn--fze607b9651bjwl7c.xn--wgb86el10d", .status = 12} /* 1446 */,
    {.source = (const lxb_char_t *) "Ⴣ．\u0653ᢤ", .ascii = (const lxb_char_t *) "xn--7nd.xn--vhb294g", .status = 8} /* 1447 */,
    {.source = (const lxb_char_t *) "Ⴣ.\u0653ᢤ", .ascii = (const lxb_char_t *) "xn--7nd.xn--vhb294g", .status = 8} /* 1448 */,
    {.source = (const lxb_char_t *) "ⴣ.\u0653ᢤ", .ascii = (const lxb_char_t *) "xn--rlj.xn--vhb294g", .status = 4} /* 1449 */,
    {.source = (const lxb_char_t *) "xn--rlj.xn--vhb294g", .ascii = (const lxb_char_t *) "xn--rlj.xn--vhb294g", .status = 4} /* 1450 */,
    {.source = (const lxb_char_t *) "xn--7nd.xn--vhb294g", .ascii = (const lxb_char_t *) "xn--7nd.xn--vhb294g", .status = 8} /* 1451 */,
    {.source = (const lxb_char_t *) "ⴣ．\u0653ᢤ", .ascii = (const lxb_char_t *) "xn--rlj.xn--vhb294g", .status = 4} /* 1452 */,
    {.source = (const lxb_char_t *) "󠄈\u0813．싉򄆻Ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--8nd9522gpe69cviva", .status = 4} /* 1453 */,
    {.source = (const lxb_char_t *) "󠄈\u0813．싉򄆻Ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--8nd9522gpe69cviva", .status = 4} /* 1454 */,
    {.source = (const lxb_char_t *) "󠄈\u0813.싉򄆻Ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--8nd9522gpe69cviva", .status = 4} /* 1455 */,
    {.source = (const lxb_char_t *) "󠄈\u0813.싉򄆻Ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--8nd9522gpe69cviva", .status = 4} /* 1456 */,
    {.source = (const lxb_char_t *) "󠄈\u0813.싉򄆻ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--sljz109bpe25dviva", .status = 4} /* 1457 */,
    {.source = (const lxb_char_t *) "󠄈\u0813.싉򄆻ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--sljz109bpe25dviva", .status = 4} /* 1458 */,
    {.source = (const lxb_char_t *) "xn--oub.xn--sljz109bpe25dviva", .ascii = (const lxb_char_t *) "xn--oub.xn--sljz109bpe25dviva", .status = 4} /* 1459 */,
    {.source = (const lxb_char_t *) "xn--oub.xn--8nd9522gpe69cviva", .ascii = (const lxb_char_t *) "xn--oub.xn--8nd9522gpe69cviva", .status = 4} /* 1460 */,
    {.source = (const lxb_char_t *) "󠄈\u0813．싉򄆻ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--sljz109bpe25dviva", .status = 4} /* 1461 */,
    {.source = (const lxb_char_t *) "󠄈\u0813．싉򄆻ⴤ򂡐", .ascii = (const lxb_char_t *) "xn--oub.xn--sljz109bpe25dviva", .status = 4} /* 1462 */,
    {.source = (const lxb_char_t *) "\uAA2C𑲫≮．⤂", .ascii = (const lxb_char_t *) "xn--gdh1854cn19c.xn--kqi", .status = 4} /* 1463 */,
    {.source = (const lxb_char_t *) "\uAA2C𑲫<\u0338．⤂", .ascii = (const lxb_char_t *) "xn--gdh1854cn19c.xn--kqi", .status = 4} /* 1464 */,
    {.source = (const lxb_char_t *) "\uAA2C𑲫≮.⤂", .ascii = (const lxb_char_t *) "xn--gdh1854cn19c.xn--kqi", .status = 4} /* 1465 */,
    {.source = (const lxb_char_t *) "\uAA2C𑲫<\u0338.⤂", .ascii = (const lxb_char_t *) "xn--gdh1854cn19c.xn--kqi", .status = 4} /* 1466 */,
    {.source = (const lxb_char_t *) "xn--gdh1854cn19c.xn--kqi", .ascii = (const lxb_char_t *) "xn--gdh1854cn19c.xn--kqi", .status = 4} /* 1467 */,
    {.source = (const lxb_char_t *) "\u0604𐩔≮Ⴢ．Ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--bnd", .status = 8} /* 1468 */,
    {.source = (const lxb_char_t *) "\u0604𐩔<\u0338Ⴢ．Ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--bnd", .status = 8} /* 1469 */,
    {.source = (const lxb_char_t *) "\u0604𐩔≮Ⴢ.Ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--bnd", .status = 8} /* 1470 */,
    {.source = (const lxb_char_t *) "\u0604𐩔<\u0338Ⴢ.Ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--bnd", .status = 8} /* 1471 */,
    {.source = (const lxb_char_t *) "\u0604𐩔<\u0338ⴢ.ⴃ", .ascii = (const lxb_char_t *) "xn--mfb266l4khr54u.xn--ukj", .status = 8} /* 1472 */,
    {.source = (const lxb_char_t *) "\u0604𐩔≮ⴢ.ⴃ", .ascii = (const lxb_char_t *) "xn--mfb266l4khr54u.xn--ukj", .status = 8} /* 1473 */,
    {.source = (const lxb_char_t *) "\u0604𐩔≮Ⴢ.ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--ukj", .status = 8} /* 1474 */,
    {.source = (const lxb_char_t *) "\u0604𐩔<\u0338Ⴢ.ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--ukj", .status = 8} /* 1475 */,
    {.source = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--ukj", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--ukj", .status = 8} /* 1476 */,
    {.source = (const lxb_char_t *) "xn--mfb266l4khr54u.xn--ukj", .ascii = (const lxb_char_t *) "xn--mfb266l4khr54u.xn--ukj", .status = 8} /* 1477 */,
    {.source = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--bnd", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--bnd", .status = 8} /* 1478 */,
    {.source = (const lxb_char_t *) "\u0604𐩔<\u0338ⴢ．ⴃ", .ascii = (const lxb_char_t *) "xn--mfb266l4khr54u.xn--ukj", .status = 8} /* 1479 */,
    {.source = (const lxb_char_t *) "\u0604𐩔≮ⴢ．ⴃ", .ascii = (const lxb_char_t *) "xn--mfb266l4khr54u.xn--ukj", .status = 8} /* 1480 */,
    {.source = (const lxb_char_t *) "\u0604𐩔≮Ⴢ．ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--ukj", .status = 8} /* 1481 */,
    {.source = (const lxb_char_t *) "\u0604𐩔<\u0338Ⴢ．ⴃ", .ascii = (const lxb_char_t *) "xn--mfb416c0jox02t.xn--ukj", .status = 8} /* 1482 */,
    {.source = (const lxb_char_t *) "𑁅。-", .ascii = (const lxb_char_t *) "xn--210d.-", .status = 8} /* 1483 */,
    {.source = (const lxb_char_t *) "xn--210d.-", .ascii = (const lxb_char_t *) "xn--210d.-", .status = 8} /* 1484 */,
    {.source = (const lxb_char_t *) "\u0DCA򕸽󠧱｡饈≠\u0664", .ascii = (const lxb_char_t *) "xn--h1c25913jfwov.xn--dib144ler5f", .status = 20} /* 1485 */,
    {.source = (const lxb_char_t *) "\u0DCA򕸽󠧱｡饈=\u0338\u0664", .ascii = (const lxb_char_t *) "xn--h1c25913jfwov.xn--dib144ler5f", .status = 20} /* 1486 */,
    {.source = (const lxb_char_t *) "\u0DCA򕸽󠧱。饈≠\u0664", .ascii = (const lxb_char_t *) "xn--h1c25913jfwov.xn--dib144ler5f", .status = 20} /* 1487 */,
    {.source = (const lxb_char_t *) "\u0DCA򕸽󠧱。饈=\u0338\u0664", .ascii = (const lxb_char_t *) "xn--h1c25913jfwov.xn--dib144ler5f", .status = 20} /* 1488 */,
    {.source = (const lxb_char_t *) "xn--h1c25913jfwov.xn--dib144ler5f", .ascii = (const lxb_char_t *) "xn--h1c25913jfwov.xn--dib144ler5f", .status = 20} /* 1489 */,
    {.source = (const lxb_char_t *) "𞥃ᠠ⁷｡≯邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1490 */,
    {.source = (const lxb_char_t *) "𞥃ᠠ⁷｡>\u0338邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1491 */,
    {.source = (const lxb_char_t *) "𞥃ᠠ7。≯邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1492 */,
    {.source = (const lxb_char_t *) "𞥃ᠠ7。>\u0338邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1493 */,
    {.source = (const lxb_char_t *) "𞤡ᠠ7。>\u0338邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1494 */,
    {.source = (const lxb_char_t *) "𞤡ᠠ7。≯邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1495 */,
    {.source = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1496 */,
    {.source = (const lxb_char_t *) "𞤡ᠠ⁷｡>\u0338邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1497 */,
    {.source = (const lxb_char_t *) "𞤡ᠠ⁷｡≯邅⬻4", .ascii = (const lxb_char_t *) "xn--7-v4j2826w.xn--4-ogoy01bou3i", .status = 8} /* 1498 */,
    {.source = (const lxb_char_t *) "򠿯ᡳ-𑐻.𐹴𐋫\u0605󑎳", .ascii = (const lxb_char_t *) "xn----m9j3429kxmy7e.xn--nfb7950kdihrp812a", .status = 12} /* 1499 */,
    {.source = (const lxb_char_t *) "xn----m9j3429kxmy7e.xn--nfb7950kdihrp812a", .ascii = (const lxb_char_t *) "xn----m9j3429kxmy7e.xn--nfb7950kdihrp812a", .status = 12} /* 1500 */,
    {.source = (const lxb_char_t *) "򠶆\u0845\u0A51.넨-󶧈", .ascii = (const lxb_char_t *) "xn--3vb26hb6834b.xn----i37ez0957g", .status = 12} /* 1501 */,
    {.source = (const lxb_char_t *) "򠶆\u0845\u0A51.넨-󶧈", .ascii = (const lxb_char_t *) "xn--3vb26hb6834b.xn----i37ez0957g", .status = 12} /* 1502 */,
    {.source = (const lxb_char_t *) "xn--3vb26hb6834b.xn----i37ez0957g", .ascii = (const lxb_char_t *) "xn--3vb26hb6834b.xn----i37ez0957g", .status = 12} /* 1503 */,
    {.source = (const lxb_char_t *) "ꡦᡑ\u200D⒈。𐋣-", .ascii = (const lxb_char_t *) "xn--h8e470bl0d838o.xn----381i", .status = 12} /* 1504 */,
    {.source = (const lxb_char_t *) "ꡦᡑ\u200D1.。𐋣-", .ascii = (const lxb_char_t *) "xn--1-o7j663bdl7m..xn----381i", .status = 14} /* 1505 */,
    {.source = (const lxb_char_t *) "xn--1-o7j0610f..xn----381i", .ascii = (const lxb_char_t *) "xn--1-o7j0610f..xn----381i", .status = 10} /* 1506 */,
    {.source = (const lxb_char_t *) "xn--1-o7j663bdl7m..xn----381i", .ascii = (const lxb_char_t *) "xn--1-o7j663bdl7m..xn----381i", .status = 14} /* 1507 */,
    {.source = (const lxb_char_t *) "xn--h8e863drj7h.xn----381i", .ascii = (const lxb_char_t *) "xn--h8e863drj7h.xn----381i", .status = 8} /* 1508 */,
    {.source = (const lxb_char_t *) "xn--h8e470bl0d838o.xn----381i", .ascii = (const lxb_char_t *) "xn--h8e470bl0d838o.xn----381i", .status = 12} /* 1509 */,
    {.source = (const lxb_char_t *) "Ⴌ。􍼠\uFB69", .ascii = (const lxb_char_t *) "xn--knd.xn--yib19191t", .status = 12} /* 1510 */,
    {.source = (const lxb_char_t *) "Ⴌ。􍼠\u0679", .ascii = (const lxb_char_t *) "xn--knd.xn--yib19191t", .status = 12} /* 1511 */,
    {.source = (const lxb_char_t *) "ⴌ。􍼠\u0679", .ascii = (const lxb_char_t *) "xn--3kj.xn--yib19191t", .status = 12} /* 1512 */,
    {.source = (const lxb_char_t *) "xn--3kj.xn--yib19191t", .ascii = (const lxb_char_t *) "xn--3kj.xn--yib19191t", .status = 12} /* 1513 */,
    {.source = (const lxb_char_t *) "xn--knd.xn--yib19191t", .ascii = (const lxb_char_t *) "xn--knd.xn--yib19191t", .status = 12} /* 1514 */,
    {.source = (const lxb_char_t *) "ⴌ。􍼠\uFB69", .ascii = (const lxb_char_t *) "xn--3kj.xn--yib19191t", .status = 12} /* 1515 */,
    {.source = (const lxb_char_t *) "𐮁𐭱.\u0F84\u135E-ᳺ", .ascii = (const lxb_char_t *) "xn--r19c5a.xn----xjg270ag3m", .status = 8} /* 1516 */,
    {.source = (const lxb_char_t *) "xn--r19c5a.xn----xjg270ag3m", .ascii = (const lxb_char_t *) "xn--r19c5a.xn----xjg270ag3m", .status = 8} /* 1517 */,
    {.source = (const lxb_char_t *) "⒈䰹\u200D-。웈", .ascii = (const lxb_char_t *) "xn----tgnx5rjr6c.xn--kp5b", .status = 12} /* 1518 */,
    {.source = (const lxb_char_t *) "⒈䰹\u200D-。웈", .ascii = (const lxb_char_t *) "xn----tgnx5rjr6c.xn--kp5b", .status = 12} /* 1519 */,
    {.source = (const lxb_char_t *) "1.䰹\u200D-。웈", .ascii = (const lxb_char_t *) "1.xn----tgnz80r.xn--kp5b", .status = 8} /* 1520 */,
    {.source = (const lxb_char_t *) "1.䰹\u200D-。웈", .ascii = (const lxb_char_t *) "1.xn----tgnz80r.xn--kp5b", .status = 8} /* 1521 */,
    {.source = (const lxb_char_t *) "1.xn----zw5a.xn--kp5b", .ascii = (const lxb_char_t *) "1.xn----zw5a.xn--kp5b", .status = 4} /* 1522 */,
    {.source = (const lxb_char_t *) "1.xn----tgnz80r.xn--kp5b", .ascii = (const lxb_char_t *) "1.xn----tgnz80r.xn--kp5b", .status = 8} /* 1523 */,
    {.source = (const lxb_char_t *) "xn----dcp160o.xn--kp5b", .ascii = (const lxb_char_t *) "xn----dcp160o.xn--kp5b", .status = 8} /* 1524 */,
    {.source = (const lxb_char_t *) "xn----tgnx5rjr6c.xn--kp5b", .ascii = (const lxb_char_t *) "xn----tgnx5rjr6c.xn--kp5b", .status = 12} /* 1525 */,
    {.source = (const lxb_char_t *) "て。\u200C󠳽\u07F3", .ascii = (const lxb_char_t *) "xn--m9j.xn--rtb154j9l73w", .status = 8} /* 1526 */,
    {.source = (const lxb_char_t *) "xn--m9j.xn--rtb10784p", .ascii = (const lxb_char_t *) "xn--m9j.xn--rtb10784p", .status = 4} /* 1527 */,
    {.source = (const lxb_char_t *) "xn--m9j.xn--rtb154j9l73w", .ascii = (const lxb_char_t *) "xn--m9j.xn--rtb154j9l73w", .status = 8} /* 1528 */,
    {.source = (const lxb_char_t *) "ς｡\uA9C0\u06E7", .ascii = (const lxb_char_t *) "xn--3xa.xn--3lb1944f", .status = 4} /* 1529 */,
    {.source = (const lxb_char_t *) "ς。\uA9C0\u06E7", .ascii = (const lxb_char_t *) "xn--3xa.xn--3lb1944f", .status = 4} /* 1530 */,
    {.source = (const lxb_char_t *) "Σ。\uA9C0\u06E7", .ascii = (const lxb_char_t *) "xn--4xa.xn--3lb1944f", .status = 4} /* 1531 */,
    {.source = (const lxb_char_t *) "σ。\uA9C0\u06E7", .ascii = (const lxb_char_t *) "xn--4xa.xn--3lb1944f", .status = 4} /* 1532 */,
    {.source = (const lxb_char_t *) "xn--4xa.xn--3lb1944f", .ascii = (const lxb_char_t *) "xn--4xa.xn--3lb1944f", .status = 4} /* 1533 */,
    {.source = (const lxb_char_t *) "xn--3xa.xn--3lb1944f", .ascii = (const lxb_char_t *) "xn--3xa.xn--3lb1944f", .status = 4} /* 1534 */,
    {.source = (const lxb_char_t *) "Σ｡\uA9C0\u06E7", .ascii = (const lxb_char_t *) "xn--4xa.xn--3lb1944f", .status = 4} /* 1535 */,
    {.source = (const lxb_char_t *) "σ｡\uA9C0\u06E7", .ascii = (const lxb_char_t *) "xn--4xa.xn--3lb1944f", .status = 4} /* 1536 */,
    {.source = (const lxb_char_t *) "\u0BCD󥫅򌉑.ႢႵ", .ascii = (const lxb_char_t *) "xn--xmc83135idcxza.xn--9md2b", .status = 8} /* 1537 */,
    {.source = (const lxb_char_t *) "\u0BCD󥫅򌉑.ⴂⴕ", .ascii = (const lxb_char_t *) "xn--xmc83135idcxza.xn--tkjwb", .status = 8} /* 1538 */,
    {.source = (const lxb_char_t *) "\u0BCD󥫅򌉑.Ⴂⴕ", .ascii = (const lxb_char_t *) "xn--xmc83135idcxza.xn--9md086l", .status = 8} /* 1539 */,
    {.source = (const lxb_char_t *) "xn--xmc83135idcxza.xn--9md086l", .ascii = (const lxb_char_t *) "xn--xmc83135idcxza.xn--9md086l", .status = 8} /* 1540 */,
    {.source = (const lxb_char_t *) "xn--xmc83135idcxza.xn--tkjwb", .ascii = (const lxb_char_t *) "xn--xmc83135idcxza.xn--tkjwb", .status = 8} /* 1541 */,
    {.source = (const lxb_char_t *) "xn--xmc83135idcxza.xn--9md2b", .ascii = (const lxb_char_t *) "xn--xmc83135idcxza.xn--9md2b", .status = 8} /* 1542 */,
    {.source = (const lxb_char_t *) "\u1C32🄈⾛\u05A6．\u200D򯥤\u07FD", .ascii = (const lxb_char_t *) "xn--xcb756i493fwi5o.xn--1tb334j1197q", .status = 12} /* 1543 */,
    {.source = (const lxb_char_t *) "\u1C327,走\u05A6.\u200D򯥤\u07FD", .ascii = (const lxb_char_t *) "xn--7,-bid991urn3k.xn--1tb334j1197q", .status = 12} /* 1544 */,
    {.source = (const lxb_char_t *) "xn--7,-bid991urn3k.xn--1tb13454l", .ascii = (const lxb_char_t *) "xn--7,-bid991urn3k.xn--1tb13454l", .status = 8} /* 1545 */,
    {.source = (const lxb_char_t *) "xn--7,-bid991urn3k.xn--1tb334j1197q", .ascii = (const lxb_char_t *) "xn--7,-bid991urn3k.xn--1tb334j1197q", .status = 12} /* 1546 */,
    {.source = (const lxb_char_t *) "xn--xcb756i493fwi5o.xn--1tb13454l", .ascii = (const lxb_char_t *) "xn--xcb756i493fwi5o.xn--1tb13454l", .status = 8} /* 1547 */,
    {.source = (const lxb_char_t *) "xn--xcb756i493fwi5o.xn--1tb334j1197q", .ascii = (const lxb_char_t *) "xn--xcb756i493fwi5o.xn--1tb334j1197q", .status = 12} /* 1548 */,
    {.source = (const lxb_char_t *) "ᢗ｡Ӏ񝄻", .ascii = (const lxb_char_t *) "xn--hbf.xn--d5a86117e", .status = 4} /* 1549 */,
    {.source = (const lxb_char_t *) "ᢗ。Ӏ񝄻", .ascii = (const lxb_char_t *) "xn--hbf.xn--d5a86117e", .status = 4} /* 1550 */,
    {.source = (const lxb_char_t *) "ᢗ。ӏ񝄻", .ascii = (const lxb_char_t *) "xn--hbf.xn--s5a83117e", .status = 4} /* 1551 */,
    {.source = (const lxb_char_t *) "xn--hbf.xn--s5a83117e", .ascii = (const lxb_char_t *) "xn--hbf.xn--s5a83117e", .status = 4} /* 1552 */,
    {.source = (const lxb_char_t *) "xn--hbf.xn--d5a86117e", .ascii = (const lxb_char_t *) "xn--hbf.xn--d5a86117e", .status = 4} /* 1553 */,
    {.source = (const lxb_char_t *) "ᢗ｡ӏ񝄻", .ascii = (const lxb_char_t *) "xn--hbf.xn--s5a83117e", .status = 4} /* 1554 */,
    {.source = (const lxb_char_t *) "\u0668-。񠏇🝆ᄾ", .ascii = (const lxb_char_t *) "xn----oqc.xn--qrd1699v327w", .status = 12} /* 1555 */,
    {.source = (const lxb_char_t *) "xn----oqc.xn--qrd1699v327w", .ascii = (const lxb_char_t *) "xn----oqc.xn--qrd1699v327w", .status = 12} /* 1556 */,
    {.source = (const lxb_char_t *) "-𐋷𖾑。󠆬", .ascii = (const lxb_char_t *) "xn----991iq40y.", .status = 4} /* 1557 */,
    {.source = (const lxb_char_t *) "xn----991iq40y.", .ascii = (const lxb_char_t *) "xn----991iq40y.", .status = 4} /* 1558 */,
    {.source = (const lxb_char_t *) "\u200C𐹳🐴멈.\uABED񐡼", .ascii = (const lxb_char_t *) "xn--0ug6681d406b7bwk.xn--429a8682s", .status = 16} /* 1559 */,
    {.source = (const lxb_char_t *) "\u200C𐹳🐴멈.\uABED񐡼", .ascii = (const lxb_char_t *) "xn--0ug6681d406b7bwk.xn--429a8682s", .status = 16} /* 1560 */,
    {.source = (const lxb_char_t *) "xn--422b325mqb6i.xn--429a8682s", .ascii = (const lxb_char_t *) "xn--422b325mqb6i.xn--429a8682s", .status = 12} /* 1561 */,
    {.source = (const lxb_char_t *) "xn--0ug6681d406b7bwk.xn--429a8682s", .ascii = (const lxb_char_t *) "xn--0ug6681d406b7bwk.xn--429a8682s", .status = 16} /* 1562 */,
    {.source = (const lxb_char_t *) "≮.\u0769\u0603", .ascii = (const lxb_char_t *) "xn--gdh.xn--lfb92e", .status = 8} /* 1563 */,
    {.source = (const lxb_char_t *) "<\u0338.\u0769\u0603", .ascii = (const lxb_char_t *) "xn--gdh.xn--lfb92e", .status = 8} /* 1564 */,
    {.source = (const lxb_char_t *) "xn--gdh.xn--lfb92e", .ascii = (const lxb_char_t *) "xn--gdh.xn--lfb92e", .status = 8} /* 1565 */,
    {.source = (const lxb_char_t *) "𐶭⾆｡\u200C𑚶򟱃𞰘", .ascii = (const lxb_char_t *) "xn--tc1ao37z.xn--0ugx728gi1nfwqz2e", .status = 20} /* 1566 */,
    {.source = (const lxb_char_t *) "𐶭舌。\u200C𑚶򟱃𞰘", .ascii = (const lxb_char_t *) "xn--tc1ao37z.xn--0ugx728gi1nfwqz2e", .status = 20} /* 1567 */,
    {.source = (const lxb_char_t *) "xn--tc1ao37z.xn--6e2dw557azds2d", .ascii = (const lxb_char_t *) "xn--tc1ao37z.xn--6e2dw557azds2d", .status = 24} /* 1568 */,
    {.source = (const lxb_char_t *) "xn--tc1ao37z.xn--0ugx728gi1nfwqz2e", .ascii = (const lxb_char_t *) "xn--tc1ao37z.xn--0ugx728gi1nfwqz2e", .status = 20} /* 1569 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.𝟷ς𞴺ς", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-ymba92321c", .status = 16} /* 1570 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.1ς𞴺ς", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-ymba92321c", .status = 16} /* 1571 */,
    {.source = (const lxb_char_t *) "\u200Cⴠ-.1ς𞴺ς", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-ymba92321c", .status = 12} /* 1572 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.1Σ𞴺Σ", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-0mba52321c", .status = 16} /* 1573 */,
    {.source = (const lxb_char_t *) "\u200Cⴠ-.1σ𞴺σ", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-0mba52321c", .status = 12} /* 1574 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.1σ𞴺Σ", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-0mba52321c", .status = 16} /* 1575 */,
    {.source = (const lxb_char_t *) "xn----z1g.xn--1-0mba52321c", .ascii = (const lxb_char_t *) "xn----z1g.xn--1-0mba52321c", .status = 16} /* 1576 */,
    {.source = (const lxb_char_t *) "xn----z1g168i.xn--1-0mba52321c", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-0mba52321c", .status = 16} /* 1577 */,
    {.source = (const lxb_char_t *) "xn----2ws.xn--1-0mba52321c", .ascii = (const lxb_char_t *) "xn----2ws.xn--1-0mba52321c", .status = 12} /* 1578 */,
    {.source = (const lxb_char_t *) "xn----rgn530d.xn--1-0mba52321c", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-0mba52321c", .status = 12} /* 1579 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.1ς𞴺Σ", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-ymbd52321c", .status = 16} /* 1580 */,
    {.source = (const lxb_char_t *) "\u200Cⴠ-.1ς𞴺σ", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-ymbd52321c", .status = 12} /* 1581 */,
    {.source = (const lxb_char_t *) "xn----rgn530d.xn--1-ymbd52321c", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-ymbd52321c", .status = 12} /* 1582 */,
    {.source = (const lxb_char_t *) "xn----z1g168i.xn--1-ymbd52321c", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-ymbd52321c", .status = 16} /* 1583 */,
    {.source = (const lxb_char_t *) "xn----rgn530d.xn--1-ymba92321c", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-ymba92321c", .status = 12} /* 1584 */,
    {.source = (const lxb_char_t *) "xn----z1g168i.xn--1-ymba92321c", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-ymba92321c", .status = 16} /* 1585 */,
    {.source = (const lxb_char_t *) "\u200Cⴠ-.𝟷ς𞴺ς", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-ymba92321c", .status = 12} /* 1586 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.𝟷Σ𞴺Σ", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-0mba52321c", .status = 16} /* 1587 */,
    {.source = (const lxb_char_t *) "\u200Cⴠ-.𝟷σ𞴺σ", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-0mba52321c", .status = 12} /* 1588 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.𝟷σ𞴺Σ", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-0mba52321c", .status = 16} /* 1589 */,
    {.source = (const lxb_char_t *) "\u200CჀ-.𝟷ς𞴺Σ", .ascii = (const lxb_char_t *) "xn----z1g168i.xn--1-ymbd52321c", .status = 16} /* 1590 */,
    {.source = (const lxb_char_t *) "\u200Cⴠ-.𝟷ς𞴺σ", .ascii = (const lxb_char_t *) "xn----rgn530d.xn--1-ymbd52321c", .status = 12} /* 1591 */,
    {.source = (const lxb_char_t *) "𑲘󠄒𓑡｡𝟪Ⴜ", .ascii = (const lxb_char_t *) "xn--7m3d291b.xn--8-s1g", .status = 8} /* 1592 */,
    {.source = (const lxb_char_t *) "𑲘󠄒𓑡。8Ⴜ", .ascii = (const lxb_char_t *) "xn--7m3d291b.xn--8-s1g", .status = 8} /* 1593 */,
    {.source = (const lxb_char_t *) "𑲘󠄒𓑡。8ⴜ", .ascii = (const lxb_char_t *) "xn--7m3d291b.xn--8-vws", .status = 8} /* 1594 */,
    {.source = (const lxb_char_t *) "xn--7m3d291b.xn--8-vws", .ascii = (const lxb_char_t *) "xn--7m3d291b.xn--8-vws", .status = 8} /* 1595 */,
    {.source = (const lxb_char_t *) "xn--7m3d291b.xn--8-s1g", .ascii = (const lxb_char_t *) "xn--7m3d291b.xn--8-s1g", .status = 8} /* 1596 */,
    {.source = (const lxb_char_t *) "𑲘󠄒𓑡｡𝟪ⴜ", .ascii = (const lxb_char_t *) "xn--7m3d291b.xn--8-vws", .status = 8} /* 1597 */,
    {.source = (const lxb_char_t *) "䪏\u06AB\u07E0\u0941｡뭕ᢝ\u17B9", .ascii = (const lxb_char_t *) "xn--ekb23dj4at01n.xn--43e96bh910b", .status = 8} /* 1598 */,
    {.source = (const lxb_char_t *) "䪏\u06AB\u07E0\u0941｡뭕ᢝ\u17B9", .ascii = (const lxb_char_t *) "xn--ekb23dj4at01n.xn--43e96bh910b", .status = 8} /* 1599 */,
    {.source = (const lxb_char_t *) "䪏\u06AB\u07E0\u0941。뭕ᢝ\u17B9", .ascii = (const lxb_char_t *) "xn--ekb23dj4at01n.xn--43e96bh910b", .status = 8} /* 1600 */,
    {.source = (const lxb_char_t *) "䪏\u06AB\u07E0\u0941。뭕ᢝ\u17B9", .ascii = (const lxb_char_t *) "xn--ekb23dj4at01n.xn--43e96bh910b", .status = 8} /* 1601 */,
    {.source = (const lxb_char_t *) "xn--ekb23dj4at01n.xn--43e96bh910b", .ascii = (const lxb_char_t *) "xn--ekb23dj4at01n.xn--43e96bh910b", .status = 8} /* 1602 */,
    {.source = (const lxb_char_t *) "\u1BAB｡🂉󠁰", .ascii = (const lxb_char_t *) "xn--zxf.xn--fx7ho0250c", .status = 8} /* 1603 */,
    {.source = (const lxb_char_t *) "\u1BAB。🂉󠁰", .ascii = (const lxb_char_t *) "xn--zxf.xn--fx7ho0250c", .status = 8} /* 1604 */,
    {.source = (const lxb_char_t *) "xn--zxf.xn--fx7ho0250c", .ascii = (const lxb_char_t *) "xn--zxf.xn--fx7ho0250c", .status = 8} /* 1605 */,
    {.source = (const lxb_char_t *) "󩎃\u0AC4。ς\u200D𐹮𑈵", .ascii = (const lxb_char_t *) "xn--dfc53161q.xn--3xa006lzo7nsfd", .status = 12} /* 1606 */,
    {.source = (const lxb_char_t *) "󩎃\u0AC4。Σ\u200D𐹮𑈵", .ascii = (const lxb_char_t *) "xn--dfc53161q.xn--4xa895lzo7nsfd", .status = 12} /* 1607 */,
    {.source = (const lxb_char_t *) "󩎃\u0AC4。σ\u200D𐹮𑈵", .ascii = (const lxb_char_t *) "xn--dfc53161q.xn--4xa895lzo7nsfd", .status = 12} /* 1608 */,
    {.source = (const lxb_char_t *) "xn--dfc53161q.xn--4xa8467k5mc", .ascii = (const lxb_char_t *) "xn--dfc53161q.xn--4xa8467k5mc", .status = 8} /* 1609 */,
    {.source = (const lxb_char_t *) "xn--dfc53161q.xn--4xa895lzo7nsfd", .ascii = (const lxb_char_t *) "xn--dfc53161q.xn--4xa895lzo7nsfd", .status = 12} /* 1610 */,
    {.source = (const lxb_char_t *) "xn--dfc53161q.xn--3xa006lzo7nsfd", .ascii = (const lxb_char_t *) "xn--dfc53161q.xn--3xa006lzo7nsfd", .status = 12} /* 1611 */,
    {.source = (const lxb_char_t *) "𐫀ᡂ𑜫．𑘿", .ascii = (const lxb_char_t *) "xn--17e9625js1h.xn--sb2d", .status = 16} /* 1612 */,
    {.source = (const lxb_char_t *) "𐫀ᡂ𑜫.𑘿", .ascii = (const lxb_char_t *) "xn--17e9625js1h.xn--sb2d", .status = 16} /* 1613 */,
    {.source = (const lxb_char_t *) "xn--17e9625js1h.xn--sb2d", .ascii = (const lxb_char_t *) "xn--17e9625js1h.xn--sb2d", .status = 16} /* 1614 */,
    {.source = (const lxb_char_t *) "󬚶󸋖򖩰-。\u200C", .ascii = (const lxb_char_t *) "xn----7i12hu122k9ire.xn--0ug", .status = 12} /* 1615 */,
    {.source = (const lxb_char_t *) "xn----7i12hu122k9ire.", .ascii = (const lxb_char_t *) "xn----7i12hu122k9ire.", .status = 8} /* 1616 */,
    {.source = (const lxb_char_t *) "xn----7i12hu122k9ire.xn--0ug", .ascii = (const lxb_char_t *) "xn----7i12hu122k9ire.xn--0ug", .status = 12} /* 1617 */,
    {.source = (const lxb_char_t *) "𐹣．\u07C2", .ascii = (const lxb_char_t *) "xn--bo0d.xn--dsb", .status = 4} /* 1618 */,
    {.source = (const lxb_char_t *) "𐹣.\u07C2", .ascii = (const lxb_char_t *) "xn--bo0d.xn--dsb", .status = 4} /* 1619 */,
    {.source = (const lxb_char_t *) "xn--bo0d.xn--dsb", .ascii = (const lxb_char_t *) "xn--bo0d.xn--dsb", .status = 4} /* 1620 */,
    {.source = (const lxb_char_t *) "-\u07E1｡Ↄ", .ascii = (const lxb_char_t *) "xn----8cd.xn--q5g", .status = 12} /* 1621 */,
    {.source = (const lxb_char_t *) "-\u07E1。Ↄ", .ascii = (const lxb_char_t *) "xn----8cd.xn--q5g", .status = 12} /* 1622 */,
    {.source = (const lxb_char_t *) "-\u07E1。ↄ", .ascii = (const lxb_char_t *) "xn----8cd.xn--r5g", .status = 8} /* 1623 */,
    {.source = (const lxb_char_t *) "xn----8cd.xn--r5g", .ascii = (const lxb_char_t *) "xn----8cd.xn--r5g", .status = 8} /* 1624 */,
    {.source = (const lxb_char_t *) "xn----8cd.xn--q5g", .ascii = (const lxb_char_t *) "xn----8cd.xn--q5g", .status = 12} /* 1625 */,
    {.source = (const lxb_char_t *) "-\u07E1｡ↄ", .ascii = (const lxb_char_t *) "xn----8cd.xn--r5g", .status = 8} /* 1626 */,
    {.source = (const lxb_char_t *) "\u200D-︒󠄄。ß哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgnt341h.xn--zca670n5f0binyk", .status = 24} /* 1627 */,
    {.source = (const lxb_char_t *) "\u200D-。󠄄。ß哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgn..xn--zca670n5f0binyk", .status = 34} /* 1628 */,
    {.source = (const lxb_char_t *) "\u200D-。󠄄。SS哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgn..xn--ss-k1ts75zb8ym", .status = 34} /* 1629 */,
    {.source = (const lxb_char_t *) "\u200D-。󠄄。ss哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgn..xn--ss-k1ts75zb8ym", .status = 34} /* 1630 */,
    {.source = (const lxb_char_t *) "\u200D-。󠄄。Ss哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgn..xn--ss-k1ts75zb8ym", .status = 34} /* 1631 */,
    {.source = (const lxb_char_t *) "-..xn--ss-h46c5711e", .ascii = (const lxb_char_t *) "-..xn--ss-h46c5711e", .status = 26} /* 1632 */,
    {.source = (const lxb_char_t *) "xn----tgn..xn--ss-k1ts75zb8ym", .ascii = (const lxb_char_t *) "xn----tgn..xn--ss-k1ts75zb8ym", .status = 34} /* 1633 */,
    {.source = (const lxb_char_t *) "xn----tgn..xn--zca670n5f0binyk", .ascii = (const lxb_char_t *) "xn----tgn..xn--zca670n5f0binyk", .status = 34} /* 1634 */,
    {.source = (const lxb_char_t *) "\u200D-︒󠄄。SS哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgnt341h.xn--ss-k1ts75zb8ym", .status = 24} /* 1635 */,
    {.source = (const lxb_char_t *) "\u200D-︒󠄄。ss哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgnt341h.xn--ss-k1ts75zb8ym", .status = 24} /* 1636 */,
    {.source = (const lxb_char_t *) "\u200D-︒󠄄。Ss哑\u200C𐵿", .ascii = (const lxb_char_t *) "xn----tgnt341h.xn--ss-k1ts75zb8ym", .status = 24} /* 1637 */,
    {.source = (const lxb_char_t *) "xn----o89h.xn--ss-h46c5711e", .ascii = (const lxb_char_t *) "xn----o89h.xn--ss-h46c5711e", .status = 20} /* 1638 */,
    {.source = (const lxb_char_t *) "xn----tgnt341h.xn--ss-k1ts75zb8ym", .ascii = (const lxb_char_t *) "xn----tgnt341h.xn--ss-k1ts75zb8ym", .status = 24} /* 1639 */,
    {.source = (const lxb_char_t *) "xn----tgnt341h.xn--zca670n5f0binyk", .ascii = (const lxb_char_t *) "xn----tgnt341h.xn--zca670n5f0binyk", .status = 24} /* 1640 */,
    {.source = (const lxb_char_t *) "︒．\uFE2F𑑂", .ascii = (const lxb_char_t *) "xn--y86c.xn--s96cu30b", .status = 8} /* 1641 */,
    {.source = (const lxb_char_t *) "︒．𑑂\uFE2F", .ascii = (const lxb_char_t *) "xn--y86c.xn--s96cu30b", .status = 8} /* 1642 */,
    {.source = (const lxb_char_t *) "。.𑑂\uFE2F", .ascii = (const lxb_char_t *) "..xn--s96cu30b", .status = 10} /* 1643 */,
    {.source = (const lxb_char_t *) "..xn--s96cu30b", .ascii = (const lxb_char_t *) "..xn--s96cu30b", .status = 10} /* 1644 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--s96cu30b", .ascii = (const lxb_char_t *) "xn--y86c.xn--s96cu30b", .status = 8} /* 1645 */,
    {.source = (const lxb_char_t *) "\uA92C。\u200D", .ascii = (const lxb_char_t *) "xn--zi9a.xn--1ug", .status = 8} /* 1646 */,
    {.source = (const lxb_char_t *) "xn--zi9a.", .ascii = (const lxb_char_t *) "xn--zi9a.", .status = 4} /* 1647 */,
    {.source = (const lxb_char_t *) "xn--zi9a.xn--1ug", .ascii = (const lxb_char_t *) "xn--zi9a.xn--1ug", .status = 8} /* 1648 */,
    {.source = (const lxb_char_t *) "\u200D󠸡｡\uFCD7", .ascii = (const lxb_char_t *) "xn--1ug80651l.xn--rgb7c", .status = 12} /* 1649 */,
    {.source = (const lxb_char_t *) "\u200D󠸡。\u0647\u062C", .ascii = (const lxb_char_t *) "xn--1ug80651l.xn--rgb7c", .status = 12} /* 1650 */,
    {.source = (const lxb_char_t *) "xn--d356e.xn--rgb7c", .ascii = (const lxb_char_t *) "xn--d356e.xn--rgb7c", .status = 8} /* 1651 */,
    {.source = (const lxb_char_t *) "xn--1ug80651l.xn--rgb7c", .ascii = (const lxb_char_t *) "xn--1ug80651l.xn--rgb7c", .status = 12} /* 1652 */,
    {.source = (const lxb_char_t *) "-Ⴄ𝟢\u0663．𑍴ς", .ascii = (const lxb_char_t *) "xn---0-iyd216h.xn--3xa1220l", .status = 16} /* 1653 */,
    {.source = (const lxb_char_t *) "-Ⴄ0\u0663.𑍴ς", .ascii = (const lxb_char_t *) "xn---0-iyd216h.xn--3xa1220l", .status = 16} /* 1654 */,
    {.source = (const lxb_char_t *) "-ⴄ0\u0663.𑍴ς", .ascii = (const lxb_char_t *) "xn---0-iyd8660b.xn--3xa1220l", .status = 12} /* 1655 */,
    {.source = (const lxb_char_t *) "-Ⴄ0\u0663.𑍴Σ", .ascii = (const lxb_char_t *) "xn---0-iyd216h.xn--4xa9120l", .status = 16} /* 1656 */,
    {.source = (const lxb_char_t *) "-ⴄ0\u0663.𑍴σ", .ascii = (const lxb_char_t *) "xn---0-iyd8660b.xn--4xa9120l", .status = 12} /* 1657 */,
    {.source = (const lxb_char_t *) "xn---0-iyd8660b.xn--4xa9120l", .ascii = (const lxb_char_t *) "xn---0-iyd8660b.xn--4xa9120l", .status = 12} /* 1658 */,
    {.source = (const lxb_char_t *) "xn---0-iyd216h.xn--4xa9120l", .ascii = (const lxb_char_t *) "xn---0-iyd216h.xn--4xa9120l", .status = 16} /* 1659 */,
    {.source = (const lxb_char_t *) "xn---0-iyd8660b.xn--3xa1220l", .ascii = (const lxb_char_t *) "xn---0-iyd8660b.xn--3xa1220l", .status = 12} /* 1660 */,
    {.source = (const lxb_char_t *) "xn---0-iyd216h.xn--3xa1220l", .ascii = (const lxb_char_t *) "xn---0-iyd216h.xn--3xa1220l", .status = 16} /* 1661 */,
    {.source = (const lxb_char_t *) "-ⴄ𝟢\u0663．𑍴ς", .ascii = (const lxb_char_t *) "xn---0-iyd8660b.xn--3xa1220l", .status = 12} /* 1662 */,
    {.source = (const lxb_char_t *) "-Ⴄ𝟢\u0663．𑍴Σ", .ascii = (const lxb_char_t *) "xn---0-iyd216h.xn--4xa9120l", .status = 16} /* 1663 */,
    {.source = (const lxb_char_t *) "-ⴄ𝟢\u0663．𑍴σ", .ascii = (const lxb_char_t *) "xn---0-iyd8660b.xn--4xa9120l", .status = 12} /* 1664 */,
    {.source = (const lxb_char_t *) "󦈄。-", .ascii = (const lxb_char_t *) "xn--xm38e.-", .status = 8} /* 1665 */,
    {.source = (const lxb_char_t *) "xn--xm38e.-", .ascii = (const lxb_char_t *) "xn--xm38e.-", .status = 8} /* 1666 */,
    {.source = (const lxb_char_t *) "⋠𐋮．򶈮\u0F18ß≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--zca593eo6oc013y", .status = 4} /* 1667 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮．򶈮\u0F18ß>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--zca593eo6oc013y", .status = 4} /* 1668 */,
    {.source = (const lxb_char_t *) "⋠𐋮.򶈮\u0F18ß≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--zca593eo6oc013y", .status = 4} /* 1669 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮.򶈮\u0F18ß>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--zca593eo6oc013y", .status = 4} /* 1670 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮.򶈮\u0F18SS>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1671 */,
    {.source = (const lxb_char_t *) "⋠𐋮.򶈮\u0F18SS≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1672 */,
    {.source = (const lxb_char_t *) "⋠𐋮.򶈮\u0F18ss≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1673 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮.򶈮\u0F18ss>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1674 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮.򶈮\u0F18Ss>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1675 */,
    {.source = (const lxb_char_t *) "⋠𐋮.򶈮\u0F18Ss≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1676 */,
    {.source = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1677 */,
    {.source = (const lxb_char_t *) "xn--pgh4639f.xn--zca593eo6oc013y", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--zca593eo6oc013y", .status = 4} /* 1678 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮．򶈮\u0F18SS>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1679 */,
    {.source = (const lxb_char_t *) "⋠𐋮．򶈮\u0F18SS≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1680 */,
    {.source = (const lxb_char_t *) "⋠𐋮．򶈮\u0F18ss≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1681 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮．򶈮\u0F18ss>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1682 */,
    {.source = (const lxb_char_t *) "≼\u0338𐋮．򶈮\u0F18Ss>\u0338", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1683 */,
    {.source = (const lxb_char_t *) "⋠𐋮．򶈮\u0F18Ss≯", .ascii = (const lxb_char_t *) "xn--pgh4639f.xn--ss-ifj426nle504a", .status = 4} /* 1684 */,
    {.source = (const lxb_char_t *) "1𐋸\u0664｡󠢮\uFBA4񷝊", .ascii = (const lxb_char_t *) "xn--1-hqc3905q.xn--zkb83268gqee4a", .status = 8} /* 1685 */,
    {.source = (const lxb_char_t *) "1𐋸\u0664。󠢮\u06C0񷝊", .ascii = (const lxb_char_t *) "xn--1-hqc3905q.xn--zkb83268gqee4a", .status = 8} /* 1686 */,
    {.source = (const lxb_char_t *) "1𐋸\u0664。󠢮\u06D5\u0654񷝊", .ascii = (const lxb_char_t *) "xn--1-hqc3905q.xn--zkb83268gqee4a", .status = 8} /* 1687 */,
    {.source = (const lxb_char_t *) "xn--1-hqc3905q.xn--zkb83268gqee4a", .ascii = (const lxb_char_t *) "xn--1-hqc3905q.xn--zkb83268gqee4a", .status = 8} /* 1688 */,
    {.source = (const lxb_char_t *) "儭-｡𐹴Ⴢ񥳠\u200C", .ascii = (const lxb_char_t *) "xn----gz7a.xn--6nd249ejl4pusr7b", .status = 20} /* 1689 */,
    {.source = (const lxb_char_t *) "儭-。𐹴Ⴢ񥳠\u200C", .ascii = (const lxb_char_t *) "xn----gz7a.xn--6nd249ejl4pusr7b", .status = 20} /* 1690 */,
    {.source = (const lxb_char_t *) "儭-。𐹴ⴢ񥳠\u200C", .ascii = (const lxb_char_t *) "xn----gz7a.xn--0ug472cfq0pus98b", .status = 20} /* 1691 */,
    {.source = (const lxb_char_t *) "xn----gz7a.xn--qlj9223eywx0b", .ascii = (const lxb_char_t *) "xn----gz7a.xn--qlj9223eywx0b", .status = 16} /* 1692 */,
    {.source = (const lxb_char_t *) "xn----gz7a.xn--0ug472cfq0pus98b", .ascii = (const lxb_char_t *) "xn----gz7a.xn--0ug472cfq0pus98b", .status = 20} /* 1693 */,
    {.source = (const lxb_char_t *) "xn----gz7a.xn--6nd5001kyw98a", .ascii = (const lxb_char_t *) "xn----gz7a.xn--6nd5001kyw98a", .status = 16} /* 1694 */,
    {.source = (const lxb_char_t *) "xn----gz7a.xn--6nd249ejl4pusr7b", .ascii = (const lxb_char_t *) "xn----gz7a.xn--6nd249ejl4pusr7b", .status = 20} /* 1695 */,
    {.source = (const lxb_char_t *) "儭-｡𐹴ⴢ񥳠\u200C", .ascii = (const lxb_char_t *) "xn----gz7a.xn--0ug472cfq0pus98b", .status = 20} /* 1696 */,
    {.source = (const lxb_char_t *) "𝟺𐋷\u06B9．𞤭򿍡", .ascii = (const lxb_char_t *) "xn--4-cvc5384q.xn--le6hi7322b", .status = 16} /* 1697 */,
    {.source = (const lxb_char_t *) "4𐋷\u06B9.𞤭򿍡", .ascii = (const lxb_char_t *) "xn--4-cvc5384q.xn--le6hi7322b", .status = 16} /* 1698 */,
    {.source = (const lxb_char_t *) "4𐋷\u06B9.𞤋򿍡", .ascii = (const lxb_char_t *) "xn--4-cvc5384q.xn--le6hi7322b", .status = 16} /* 1699 */,
    {.source = (const lxb_char_t *) "xn--4-cvc5384q.xn--le6hi7322b", .ascii = (const lxb_char_t *) "xn--4-cvc5384q.xn--le6hi7322b", .status = 16} /* 1700 */,
    {.source = (const lxb_char_t *) "𝟺𐋷\u06B9．𞤋򿍡", .ascii = (const lxb_char_t *) "xn--4-cvc5384q.xn--le6hi7322b", .status = 16} /* 1701 */,
    {.source = (const lxb_char_t *) "≯-ꡋ𑲣.⒈𐹭", .ascii = (const lxb_char_t *) "xn----ogox061d5i8d.xn--tsh0666f", .status = 8} /* 1702 */,
    {.source = (const lxb_char_t *) ">\u0338-ꡋ𑲣.⒈𐹭", .ascii = (const lxb_char_t *) "xn----ogox061d5i8d.xn--tsh0666f", .status = 8} /* 1703 */,
    {.source = (const lxb_char_t *) "≯-ꡋ𑲣.1.𐹭", .ascii = (const lxb_char_t *) "xn----ogox061d5i8d.1.xn--lo0d", .status = 4} /* 1704 */,
    {.source = (const lxb_char_t *) ">\u0338-ꡋ𑲣.1.𐹭", .ascii = (const lxb_char_t *) "xn----ogox061d5i8d.1.xn--lo0d", .status = 4} /* 1705 */,
    {.source = (const lxb_char_t *) "xn----ogox061d5i8d.1.xn--lo0d", .ascii = (const lxb_char_t *) "xn----ogox061d5i8d.1.xn--lo0d", .status = 4} /* 1706 */,
    {.source = (const lxb_char_t *) "xn----ogox061d5i8d.xn--tsh0666f", .ascii = (const lxb_char_t *) "xn----ogox061d5i8d.xn--tsh0666f", .status = 8} /* 1707 */,
    {.source = (const lxb_char_t *) "\u0330．󰜱蚀", .ascii = (const lxb_char_t *) "xn--xta.xn--e91aw9417e", .status = 8} /* 1708 */,
    {.source = (const lxb_char_t *) "\u0330.󰜱蚀", .ascii = (const lxb_char_t *) "xn--xta.xn--e91aw9417e", .status = 8} /* 1709 */,
    {.source = (const lxb_char_t *) "xn--xta.xn--e91aw9417e", .ascii = (const lxb_char_t *) "xn--xta.xn--e91aw9417e", .status = 8} /* 1710 */,
    {.source = (const lxb_char_t *) "\uFB39Ⴘ.𞡼𑇀ß\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--zca284nhg9nrrxg", .status = 12} /* 1711 */,
    {.source = (const lxb_char_t *) "\u05D9\u05BCႸ.𞡼𑇀ß\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--zca284nhg9nrrxg", .status = 12} /* 1712 */,
    {.source = (const lxb_char_t *) "\u05D9\u05BCⴘ.𞡼𑇀ß\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d278n.xn--zca284nhg9nrrxg", .status = 8} /* 1713 */,
    {.source = (const lxb_char_t *) "\u05D9\u05BCႸ.𞡼𑇀SS\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--ss-yju5690ken9h", .status = 12} /* 1714 */,
    {.source = (const lxb_char_t *) "\u05D9\u05BCⴘ.𞡼𑇀ss\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d278n.xn--ss-yju5690ken9h", .status = 8} /* 1715 */,
    {.source = (const lxb_char_t *) "xn--kdb1d278n.xn--ss-yju5690ken9h", .ascii = (const lxb_char_t *) "xn--kdb1d278n.xn--ss-yju5690ken9h", .status = 8} /* 1716 */,
    {.source = (const lxb_char_t *) "xn--kdb1d867b.xn--ss-yju5690ken9h", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--ss-yju5690ken9h", .status = 12} /* 1717 */,
    {.source = (const lxb_char_t *) "xn--kdb1d278n.xn--zca284nhg9nrrxg", .ascii = (const lxb_char_t *) "xn--kdb1d278n.xn--zca284nhg9nrrxg", .status = 8} /* 1718 */,
    {.source = (const lxb_char_t *) "xn--kdb1d867b.xn--zca284nhg9nrrxg", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--zca284nhg9nrrxg", .status = 12} /* 1719 */,
    {.source = (const lxb_char_t *) "\uFB39ⴘ.𞡼𑇀ß\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d278n.xn--zca284nhg9nrrxg", .status = 8} /* 1720 */,
    {.source = (const lxb_char_t *) "\uFB39Ⴘ.𞡼𑇀SS\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--ss-yju5690ken9h", .status = 12} /* 1721 */,
    {.source = (const lxb_char_t *) "\uFB39ⴘ.𞡼𑇀ss\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d278n.xn--ss-yju5690ken9h", .status = 8} /* 1722 */,
    {.source = (const lxb_char_t *) "\u05D9\u05BCႸ.𞡼𑇀ss\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--ss-yju5690ken9h", .status = 12} /* 1723 */,
    {.source = (const lxb_char_t *) "\uFB39Ⴘ.𞡼𑇀ss\u20D7", .ascii = (const lxb_char_t *) "xn--kdb1d867b.xn--ss-yju5690ken9h", .status = 12} /* 1724 */,
    {.source = (const lxb_char_t *) "\u1BA3𐹰򁱓｡凬", .ascii = (const lxb_char_t *) "xn--rxfz314ilg20c.xn--t9q", .status = 12} /* 1725 */,
    {.source = (const lxb_char_t *) "\u1BA3𐹰򁱓。凬", .ascii = (const lxb_char_t *) "xn--rxfz314ilg20c.xn--t9q", .status = 12} /* 1726 */,
    {.source = (const lxb_char_t *) "xn--rxfz314ilg20c.xn--t9q", .ascii = (const lxb_char_t *) "xn--rxfz314ilg20c.xn--t9q", .status = 12} /* 1727 */,
    {.source = (const lxb_char_t *) "🢟🄈\u200Dꡎ｡\u0F84", .ascii = (const lxb_char_t *) "xn--1ug4874cfd0kbmg.xn--3ed", .status = 12} /* 1728 */,
    {.source = (const lxb_char_t *) "🢟7,\u200Dꡎ。\u0F84", .ascii = (const lxb_char_t *) "xn--7,-n1t0654eqo3o.xn--3ed", .status = 12} /* 1729 */,
    {.source = (const lxb_char_t *) "xn--7,-gh9hg322i.xn--3ed", .ascii = (const lxb_char_t *) "xn--7,-gh9hg322i.xn--3ed", .status = 8} /* 1730 */,
    {.source = (const lxb_char_t *) "xn--7,-n1t0654eqo3o.xn--3ed", .ascii = (const lxb_char_t *) "xn--7,-n1t0654eqo3o.xn--3ed", .status = 12} /* 1731 */,
    {.source = (const lxb_char_t *) "xn--nc9aq743ds0e.xn--3ed", .ascii = (const lxb_char_t *) "xn--nc9aq743ds0e.xn--3ed", .status = 8} /* 1732 */,
    {.source = (const lxb_char_t *) "xn--1ug4874cfd0kbmg.xn--3ed", .ascii = (const lxb_char_t *) "xn--1ug4874cfd0kbmg.xn--3ed", .status = 12} /* 1733 */,
    {.source = (const lxb_char_t *) "ꡔ。\u1039ᢇ", .ascii = (const lxb_char_t *) "xn--tc9a.xn--9jd663b", .status = 4} /* 1734 */,
    {.source = (const lxb_char_t *) "xn--tc9a.xn--9jd663b", .ascii = (const lxb_char_t *) "xn--tc9a.xn--9jd663b", .status = 4} /* 1735 */,
    {.source = (const lxb_char_t *) "\u20EB≮.𝨖", .ascii = (const lxb_char_t *) "xn--e1g71d.xn--772h", .status = 4} /* 1736 */,
    {.source = (const lxb_char_t *) "\u20EB<\u0338.𝨖", .ascii = (const lxb_char_t *) "xn--e1g71d.xn--772h", .status = 4} /* 1737 */,
    {.source = (const lxb_char_t *) "xn--e1g71d.xn--772h", .ascii = (const lxb_char_t *) "xn--e1g71d.xn--772h", .status = 4} /* 1738 */,
    {.source = (const lxb_char_t *) "Ⴢ≯褦．ᠪ\u07EAႾ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x49td2h", .status = 12} /* 1739 */,
    {.source = (const lxb_char_t *) "Ⴢ>\u0338褦．ᠪ\u07EAႾ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x49td2h", .status = 12} /* 1740 */,
    {.source = (const lxb_char_t *) "Ⴢ≯褦.ᠪ\u07EAႾ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x49td2h", .status = 12} /* 1741 */,
    {.source = (const lxb_char_t *) "Ⴢ>\u0338褦.ᠪ\u07EAႾ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x49td2h", .status = 12} /* 1742 */,
    {.source = (const lxb_char_t *) "ⴢ>\u0338褦.ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--hdh433bev8e.xn--rpb5x392bcyt", .status = 8} /* 1743 */,
    {.source = (const lxb_char_t *) "ⴢ≯褦.ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--hdh433bev8e.xn--rpb5x392bcyt", .status = 8} /* 1744 */,
    {.source = (const lxb_char_t *) "Ⴢ≯褦.ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x392bcyt", .status = 12} /* 1745 */,
    {.source = (const lxb_char_t *) "Ⴢ>\u0338褦.ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x392bcyt", .status = 12} /* 1746 */,
    {.source = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x392bcyt", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x392bcyt", .status = 12} /* 1747 */,
    {.source = (const lxb_char_t *) "xn--hdh433bev8e.xn--rpb5x392bcyt", .ascii = (const lxb_char_t *) "xn--hdh433bev8e.xn--rpb5x392bcyt", .status = 8} /* 1748 */,
    {.source = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x49td2h", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x49td2h", .status = 12} /* 1749 */,
    {.source = (const lxb_char_t *) "ⴢ>\u0338褦．ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--hdh433bev8e.xn--rpb5x392bcyt", .status = 8} /* 1750 */,
    {.source = (const lxb_char_t *) "ⴢ≯褦．ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--hdh433bev8e.xn--rpb5x392bcyt", .status = 8} /* 1751 */,
    {.source = (const lxb_char_t *) "Ⴢ≯褦．ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x392bcyt", .status = 12} /* 1752 */,
    {.source = (const lxb_char_t *) "Ⴢ>\u0338褦．ᠪ\u07EAⴞ\u0767", .ascii = (const lxb_char_t *) "xn--6nd461g478e.xn--rpb5x392bcyt", .status = 12} /* 1753 */,
    {.source = (const lxb_char_t *) "򊉆󠆒\u200C\uA953。𞤙\u067Bꡘ", .ascii = (const lxb_char_t *) "xn--0ug8815chtz0e.xn--0ib8893fegvj", .status = 16} /* 1754 */,
    {.source = (const lxb_char_t *) "򊉆󠆒\u200C\uA953。𞤻\u067Bꡘ", .ascii = (const lxb_char_t *) "xn--0ug8815chtz0e.xn--0ib8893fegvj", .status = 16} /* 1755 */,
    {.source = (const lxb_char_t *) "xn--3j9al6189a.xn--0ib8893fegvj", .ascii = (const lxb_char_t *) "xn--3j9al6189a.xn--0ib8893fegvj", .status = 12} /* 1756 */,
    {.source = (const lxb_char_t *) "xn--0ug8815chtz0e.xn--0ib8893fegvj", .ascii = (const lxb_char_t *) "xn--0ug8815chtz0e.xn--0ib8893fegvj", .status = 16} /* 1757 */,
    {.source = (const lxb_char_t *) "\u200C.≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--hdh", .status = 4} /* 1758 */,
    {.source = (const lxb_char_t *) "\u200C.>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--hdh", .status = 4} /* 1759 */,
    {.source = (const lxb_char_t *) ".xn--hdh", .ascii = (const lxb_char_t *) ".xn--hdh", .status = 6} /* 1760 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--hdh", .ascii = (const lxb_char_t *) "xn--0ug.xn--hdh", .status = 4} /* 1761 */,
    {.source = (const lxb_char_t *) "𰅧񣩠-．\uABED-悜", .ascii = (const lxb_char_t *) "xn----7m53aj640l.xn----8f4br83t", .status = 12} /* 1762 */,
    {.source = (const lxb_char_t *) "𰅧񣩠-.\uABED-悜", .ascii = (const lxb_char_t *) "xn----7m53aj640l.xn----8f4br83t", .status = 12} /* 1763 */,
    {.source = (const lxb_char_t *) "xn----7m53aj640l.xn----8f4br83t", .ascii = (const lxb_char_t *) "xn----7m53aj640l.xn----8f4br83t", .status = 12} /* 1764 */,
    {.source = (const lxb_char_t *) "ᡉ𶓧⬞ᢜ.-\u200D𞣑\u202E", .ascii = (const lxb_char_t *) "xn--87e0ol04cdl39e.xn----ugn5e3763s", .status = 12} /* 1765 */,
    {.source = (const lxb_char_t *) "xn--87e0ol04cdl39e.xn----qinu247r", .ascii = (const lxb_char_t *) "xn--87e0ol04cdl39e.xn----qinu247r", .status = 8} /* 1766 */,
    {.source = (const lxb_char_t *) "xn--87e0ol04cdl39e.xn----ugn5e3763s", .ascii = (const lxb_char_t *) "xn--87e0ol04cdl39e.xn----ugn5e3763s", .status = 12} /* 1767 */,
    {.source = (const lxb_char_t *) "⒐\u200C衃Ⴝ.\u0682Ⴔ", .ascii = (const lxb_char_t *) "xn--1nd159ecmd785k.xn--7ib433c", .status = 20} /* 1768 */,
    {.source = (const lxb_char_t *) "9.\u200C衃Ⴝ.\u0682Ⴔ", .ascii = (const lxb_char_t *) "9.xn--1nd159e1y2f.xn--7ib433c", .status = 20} /* 1769 */,
    {.source = (const lxb_char_t *) "9.\u200C衃ⴝ.\u0682ⴔ", .ascii = (const lxb_char_t *) "9.xn--0ug862cbm5e.xn--7ib268q", .status = 16} /* 1770 */,
    {.source = (const lxb_char_t *) "9.\u200C衃Ⴝ.\u0682ⴔ", .ascii = (const lxb_char_t *) "9.xn--1nd159e1y2f.xn--7ib268q", .status = 20} /* 1771 */,
    {.source = (const lxb_char_t *) "9.xn--1nd9032d.xn--7ib268q", .ascii = (const lxb_char_t *) "9.xn--1nd9032d.xn--7ib268q", .status = 16} /* 1772 */,
    {.source = (const lxb_char_t *) "9.xn--1nd159e1y2f.xn--7ib268q", .ascii = (const lxb_char_t *) "9.xn--1nd159e1y2f.xn--7ib268q", .status = 20} /* 1773 */,
    {.source = (const lxb_char_t *) "9.xn--llj1920a.xn--7ib268q", .ascii = (const lxb_char_t *) "9.xn--llj1920a.xn--7ib268q", .status = 12} /* 1774 */,
    {.source = (const lxb_char_t *) "9.xn--0ug862cbm5e.xn--7ib268q", .ascii = (const lxb_char_t *) "9.xn--0ug862cbm5e.xn--7ib268q", .status = 16} /* 1775 */,
    {.source = (const lxb_char_t *) "9.xn--1nd9032d.xn--7ib433c", .ascii = (const lxb_char_t *) "9.xn--1nd9032d.xn--7ib433c", .status = 16} /* 1776 */,
    {.source = (const lxb_char_t *) "9.xn--1nd159e1y2f.xn--7ib433c", .ascii = (const lxb_char_t *) "9.xn--1nd159e1y2f.xn--7ib433c", .status = 20} /* 1777 */,
    {.source = (const lxb_char_t *) "⒐\u200C衃ⴝ.\u0682ⴔ", .ascii = (const lxb_char_t *) "xn--0ugx0px1izu2h.xn--7ib268q", .status = 20} /* 1778 */,
    {.source = (const lxb_char_t *) "⒐\u200C衃Ⴝ.\u0682ⴔ", .ascii = (const lxb_char_t *) "xn--1nd159ecmd785k.xn--7ib268q", .status = 20} /* 1779 */,
    {.source = (const lxb_char_t *) "xn--1nd362hy16e.xn--7ib268q", .ascii = (const lxb_char_t *) "xn--1nd362hy16e.xn--7ib268q", .status = 16} /* 1780 */,
    {.source = (const lxb_char_t *) "xn--1nd159ecmd785k.xn--7ib268q", .ascii = (const lxb_char_t *) "xn--1nd159ecmd785k.xn--7ib268q", .status = 20} /* 1781 */,
    {.source = (const lxb_char_t *) "xn--1shy52abz3f.xn--7ib268q", .ascii = (const lxb_char_t *) "xn--1shy52abz3f.xn--7ib268q", .status = 16} /* 1782 */,
    {.source = (const lxb_char_t *) "xn--0ugx0px1izu2h.xn--7ib268q", .ascii = (const lxb_char_t *) "xn--0ugx0px1izu2h.xn--7ib268q", .status = 20} /* 1783 */,
    {.source = (const lxb_char_t *) "xn--1nd362hy16e.xn--7ib433c", .ascii = (const lxb_char_t *) "xn--1nd362hy16e.xn--7ib433c", .status = 16} /* 1784 */,
    {.source = (const lxb_char_t *) "xn--1nd159ecmd785k.xn--7ib433c", .ascii = (const lxb_char_t *) "xn--1nd159ecmd785k.xn--7ib433c", .status = 20} /* 1785 */,
    {.source = (const lxb_char_t *) "\u07E1\u200C。--⸬", .ascii = (const lxb_char_t *) "xn--8sb884j.xn-----iw2a", .status = 16} /* 1786 */,
    {.source = (const lxb_char_t *) "xn--8sb.xn-----iw2a", .ascii = (const lxb_char_t *) "xn--8sb.xn-----iw2a", .status = 8} /* 1787 */,
    {.source = (const lxb_char_t *) "xn--8sb884j.xn-----iw2a", .ascii = (const lxb_char_t *) "xn--8sb884j.xn-----iw2a", .status = 16} /* 1788 */,
    {.source = (const lxb_char_t *) "𞥓．\u0718", .ascii = (const lxb_char_t *) "xn--of6h.xn--inb", .status = 0} /* 1789 */,
    {.source = (const lxb_char_t *) "𞥓.\u0718", .ascii = (const lxb_char_t *) "xn--of6h.xn--inb", .status = 0} /* 1790 */,
    {.source = (const lxb_char_t *) "xn--of6h.xn--inb", .ascii = (const lxb_char_t *) "xn--of6h.xn--inb", .status = 0} /* 1791 */,
    {.source = (const lxb_char_t *) "󠄽-．-\u0DCA", .ascii = (const lxb_char_t *) "-.xn----ptf", .status = 4} /* 1792 */,
    {.source = (const lxb_char_t *) "󠄽-.-\u0DCA", .ascii = (const lxb_char_t *) "-.xn----ptf", .status = 4} /* 1793 */,
    {.source = (const lxb_char_t *) "-.xn----ptf", .ascii = (const lxb_char_t *) "-.xn----ptf", .status = 4} /* 1794 */,
    {.source = (const lxb_char_t *) "󠇝\u075B-.\u1927", .ascii = (const lxb_char_t *) "xn----k4c.xn--lff", .status = 16} /* 1795 */,
    {.source = (const lxb_char_t *) "xn----k4c.xn--lff", .ascii = (const lxb_char_t *) "xn----k4c.xn--lff", .status = 16} /* 1796 */,
    {.source = (const lxb_char_t *) "𞤴󠆹⦉𐹺.\uA806⒌󘤸", .ascii = (const lxb_char_t *) "xn--fuix729epewf.xn--xsh5029b6e77i", .status = 12} /* 1797 */,
    {.source = (const lxb_char_t *) "𞤴󠆹⦉𐹺.\uA8065.󘤸", .ascii = (const lxb_char_t *) "xn--fuix729epewf.xn--5-w93e.xn--7b83e", .status = 12} /* 1798 */,
    {.source = (const lxb_char_t *) "𞤒󠆹⦉𐹺.\uA8065.󘤸", .ascii = (const lxb_char_t *) "xn--fuix729epewf.xn--5-w93e.xn--7b83e", .status = 12} /* 1799 */,
    {.source = (const lxb_char_t *) "xn--fuix729epewf.xn--5-w93e.xn--7b83e", .ascii = (const lxb_char_t *) "xn--fuix729epewf.xn--5-w93e.xn--7b83e", .status = 12} /* 1800 */,
    {.source = (const lxb_char_t *) "𞤒󠆹⦉𐹺.\uA806⒌󘤸", .ascii = (const lxb_char_t *) "xn--fuix729epewf.xn--xsh5029b6e77i", .status = 12} /* 1801 */,
    {.source = (const lxb_char_t *) "xn--fuix729epewf.xn--xsh5029b6e77i", .ascii = (const lxb_char_t *) "xn--fuix729epewf.xn--xsh5029b6e77i", .status = 12} /* 1802 */,
    {.source = (const lxb_char_t *) "󠄸₀。𑖿\u200C𐦂\u200D", .ascii = (const lxb_char_t *) "0.xn--0ugc8040p9hk", .status = 12} /* 1803 */,
    {.source = (const lxb_char_t *) "󠄸0。𑖿\u200C𐦂\u200D", .ascii = (const lxb_char_t *) "0.xn--0ugc8040p9hk", .status = 12} /* 1804 */,
    {.source = (const lxb_char_t *) "0.xn--mn9cz2s", .ascii = (const lxb_char_t *) "0.xn--mn9cz2s", .status = 8} /* 1805 */,
    {.source = (const lxb_char_t *) "0.xn--0ugc8040p9hk", .ascii = (const lxb_char_t *) "0.xn--0ugc8040p9hk", .status = 12} /* 1806 */,
    {.source = (const lxb_char_t *) "Ⴚ𐋸󠄄。𝟝ퟶ\u103A", .ascii = (const lxb_char_t *) "xn--ynd2415j.xn--5-dug9054m", .status = 4} /* 1807 */,
    {.source = (const lxb_char_t *) "Ⴚ𐋸󠄄。5ퟶ\u103A", .ascii = (const lxb_char_t *) "xn--ynd2415j.xn--5-dug9054m", .status = 4} /* 1808 */,
    {.source = (const lxb_char_t *) "ⴚ𐋸󠄄。5ퟶ\u103A", .ascii = (const lxb_char_t *) "xn--ilj2659d.xn--5-dug9054m", .status = 0} /* 1809 */,
    {.source = (const lxb_char_t *) "xn--ilj2659d.xn--5-dug9054m", .ascii = (const lxb_char_t *) "xn--ilj2659d.xn--5-dug9054m", .status = 0} /* 1810 */,
    {.source = (const lxb_char_t *) "ⴚ𐋸.5ퟶ\u103A", .ascii = (const lxb_char_t *) "xn--ilj2659d.xn--5-dug9054m", .status = 0} /* 1811 */,
    {.source = (const lxb_char_t *) "Ⴚ𐋸.5ퟶ\u103A", .ascii = (const lxb_char_t *) "xn--ynd2415j.xn--5-dug9054m", .status = 4} /* 1812 */,
    {.source = (const lxb_char_t *) "xn--ynd2415j.xn--5-dug9054m", .ascii = (const lxb_char_t *) "xn--ynd2415j.xn--5-dug9054m", .status = 4} /* 1813 */,
    {.source = (const lxb_char_t *) "ⴚ𐋸󠄄。𝟝ퟶ\u103A", .ascii = (const lxb_char_t *) "xn--ilj2659d.xn--5-dug9054m", .status = 0} /* 1814 */,
    {.source = (const lxb_char_t *) "\u200D-ᠹ﹪.\u1DE1\u1922", .ascii = (const lxb_char_t *) "xn----c6j614b1z4v.xn--gff52t", .status = 12} /* 1815 */,
    {.source = (const lxb_char_t *) "\u200D-ᠹ%.\u1DE1\u1922", .ascii = (const lxb_char_t *) "xn---%-u4oy48b.xn--gff52t", .status = 12} /* 1816 */,
    {.source = (const lxb_char_t *) "xn---%-u4o.xn--gff52t", .ascii = (const lxb_char_t *) "xn---%-u4o.xn--gff52t", .status = 12} /* 1817 */,
    {.source = (const lxb_char_t *) "xn---%-u4oy48b.xn--gff52t", .ascii = (const lxb_char_t *) "xn---%-u4oy48b.xn--gff52t", .status = 12} /* 1818 */,
    {.source = (const lxb_char_t *) "xn----c6jx047j.xn--gff52t", .ascii = (const lxb_char_t *) "xn----c6jx047j.xn--gff52t", .status = 12} /* 1819 */,
    {.source = (const lxb_char_t *) "xn----c6j614b1z4v.xn--gff52t", .ascii = (const lxb_char_t *) "xn----c6j614b1z4v.xn--gff52t", .status = 12} /* 1820 */,
    {.source = (const lxb_char_t *) "≠.ᠿ", .ascii = (const lxb_char_t *) "xn--1ch.xn--y7e", .status = 0} /* 1821 */,
    {.source = (const lxb_char_t *) "=\u0338.ᠿ", .ascii = (const lxb_char_t *) "xn--1ch.xn--y7e", .status = 0} /* 1822 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn--y7e", .ascii = (const lxb_char_t *) "xn--1ch.xn--y7e", .status = 0} /* 1823 */,
    {.source = (const lxb_char_t *) "\u0723\u05A3｡㌪", .ascii = (const lxb_char_t *) "xn--ucb18e.xn--eck4c5a", .status = 0} /* 1824 */,
    {.source = (const lxb_char_t *) "\u0723\u05A3。ハイツ", .ascii = (const lxb_char_t *) "xn--ucb18e.xn--eck4c5a", .status = 0} /* 1825 */,
    {.source = (const lxb_char_t *) "xn--ucb18e.xn--eck4c5a", .ascii = (const lxb_char_t *) "xn--ucb18e.xn--eck4c5a", .status = 0} /* 1826 */,
    {.source = (const lxb_char_t *) "\u0723\u05A3.ハイツ", .ascii = (const lxb_char_t *) "xn--ucb18e.xn--eck4c5a", .status = 0} /* 1827 */,
    {.source = (const lxb_char_t *) "𞷥󠆀≮.\u2D7F-", .ascii = (const lxb_char_t *) "xn--gdhx802p.xn----i2s", .status = 20} /* 1828 */,
    {.source = (const lxb_char_t *) "𞷥󠆀<\u0338.\u2D7F-", .ascii = (const lxb_char_t *) "xn--gdhx802p.xn----i2s", .status = 20} /* 1829 */,
    {.source = (const lxb_char_t *) "xn--gdhx802p.xn----i2s", .ascii = (const lxb_char_t *) "xn--gdhx802p.xn----i2s", .status = 20} /* 1830 */,
    {.source = (const lxb_char_t *) "₆榎򦖎\u0D4D｡𞤅\u06ED\uFC5A󠮨", .ascii = (const lxb_char_t *) "xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", .status = 12} /* 1831 */,
    {.source = (const lxb_char_t *) "6榎򦖎\u0D4D。𞤅\u06ED\u064A\u064A󠮨", .ascii = (const lxb_char_t *) "xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", .status = 12} /* 1832 */,
    {.source = (const lxb_char_t *) "6榎򦖎\u0D4D。𞤧\u06ED\u064A\u064A󠮨", .ascii = (const lxb_char_t *) "xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", .status = 12} /* 1833 */,
    {.source = (const lxb_char_t *) "xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", .ascii = (const lxb_char_t *) "xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", .status = 12} /* 1834 */,
    {.source = (const lxb_char_t *) "₆榎򦖎\u0D4D｡𞤧\u06ED\uFC5A󠮨", .ascii = (const lxb_char_t *) "xn--6-kmf4691ejv41j.xn--mhba10ch545mn8v8h", .status = 12} /* 1835 */,
    {.source = (const lxb_char_t *) "𣩫．򌑲", .ascii = (const lxb_char_t *) "xn--td3j.xn--4628b", .status = 4} /* 1836 */,
    {.source = (const lxb_char_t *) "𣩫.򌑲", .ascii = (const lxb_char_t *) "xn--td3j.xn--4628b", .status = 4} /* 1837 */,
    {.source = (const lxb_char_t *) "xn--td3j.xn--4628b", .ascii = (const lxb_char_t *) "xn--td3j.xn--4628b", .status = 4} /* 1838 */,
    {.source = (const lxb_char_t *) "\u200D︒｡\u06B9\u200C", .ascii = (const lxb_char_t *) "xn--1ug2658f.xn--skb080k", .status = 20} /* 1839 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--skb", .ascii = (const lxb_char_t *) "xn--y86c.xn--skb", .status = 8} /* 1840 */,
    {.source = (const lxb_char_t *) "xn--1ug2658f.xn--skb080k", .ascii = (const lxb_char_t *) "xn--1ug2658f.xn--skb080k", .status = 20} /* 1841 */,
    {.source = (const lxb_char_t *) "xn--skb", .ascii = (const lxb_char_t *) "xn--skb", .status = 0} /* 1842 */,
    {.source = (const lxb_char_t *) "\u06B9", .ascii = (const lxb_char_t *) "xn--skb", .status = 0} /* 1843 */,
    {.source = (const lxb_char_t *) "𐹦\u200C𐹶。\u206D", .ascii = (const lxb_char_t *) "xn--0ug4994goba.xn--sxg", .status = 12} /* 1844 */,
    {.source = (const lxb_char_t *) "xn--eo0d6a.xn--sxg", .ascii = (const lxb_char_t *) "xn--eo0d6a.xn--sxg", .status = 8} /* 1845 */,
    {.source = (const lxb_char_t *) "xn--0ug4994goba.xn--sxg", .ascii = (const lxb_char_t *) "xn--0ug4994goba.xn--sxg", .status = 12} /* 1846 */,
    {.source = (const lxb_char_t *) "\u0C4D𝨾\u05A9𝟭。-𑜨", .ascii = (const lxb_char_t *) "xn--1-rfc312cdp45c.xn----nq0j", .status = 8} /* 1847 */,
    {.source = (const lxb_char_t *) "\u0C4D𝨾\u05A91。-𑜨", .ascii = (const lxb_char_t *) "xn--1-rfc312cdp45c.xn----nq0j", .status = 8} /* 1848 */,
    {.source = (const lxb_char_t *) "xn--1-rfc312cdp45c.xn----nq0j", .ascii = (const lxb_char_t *) "xn--1-rfc312cdp45c.xn----nq0j", .status = 8} /* 1849 */,
    {.source = (const lxb_char_t *) "򣿈。뙏", .ascii = (const lxb_char_t *) "xn--ph26c.xn--281b", .status = 4} /* 1850 */,
    {.source = (const lxb_char_t *) "򣿈。뙏", .ascii = (const lxb_char_t *) "xn--ph26c.xn--281b", .status = 4} /* 1851 */,
    {.source = (const lxb_char_t *) "xn--ph26c.xn--281b", .ascii = (const lxb_char_t *) "xn--ph26c.xn--281b", .status = 4} /* 1852 */,
    {.source = (const lxb_char_t *) "񕨚󠄌󑽀ᡀ.\u08B6", .ascii = (const lxb_char_t *) "xn--z7e98100evc01b.xn--czb", .status = 4} /* 1853 */,
    {.source = (const lxb_char_t *) "xn--z7e98100evc01b.xn--czb", .ascii = (const lxb_char_t *) "xn--z7e98100evc01b.xn--czb", .status = 4} /* 1854 */,
    {.source = (const lxb_char_t *) "\u200D｡񅁛", .ascii = (const lxb_char_t *) "xn--1ug.xn--6x4u", .status = 8} /* 1855 */,
    {.source = (const lxb_char_t *) "\u200D。񅁛", .ascii = (const lxb_char_t *) "xn--1ug.xn--6x4u", .status = 8} /* 1856 */,
    {.source = (const lxb_char_t *) ".xn--6x4u", .ascii = (const lxb_char_t *) ".xn--6x4u", .status = 10} /* 1857 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--6x4u", .ascii = (const lxb_char_t *) "xn--1ug.xn--6x4u", .status = 8} /* 1858 */,
    {.source = (const lxb_char_t *) "\u084B皥．-", .ascii = (const lxb_char_t *) "xn--9vb4167c.-", .status = 16} /* 1859 */,
    {.source = (const lxb_char_t *) "\u084B皥.-", .ascii = (const lxb_char_t *) "xn--9vb4167c.-", .status = 16} /* 1860 */,
    {.source = (const lxb_char_t *) "xn--9vb4167c.-", .ascii = (const lxb_char_t *) "xn--9vb4167c.-", .status = 16} /* 1861 */,
    {.source = (const lxb_char_t *) "𐣸\u0315𐮇．⒈ꡦ", .ascii = (const lxb_char_t *) "xn--5sa9915kgvb.xn--tshw539b", .status = 8} /* 1862 */,
    {.source = (const lxb_char_t *) "𐣸\u0315𐮇.1.ꡦ", .ascii = (const lxb_char_t *) "xn--5sa9915kgvb.1.xn--cd9a", .status = 8} /* 1863 */,
    {.source = (const lxb_char_t *) "xn--5sa9915kgvb.1.xn--cd9a", .ascii = (const lxb_char_t *) "xn--5sa9915kgvb.1.xn--cd9a", .status = 8} /* 1864 */,
    {.source = (const lxb_char_t *) "xn--5sa9915kgvb.xn--tshw539b", .ascii = (const lxb_char_t *) "xn--5sa9915kgvb.xn--tshw539b", .status = 8} /* 1865 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\uFFA0ā𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda9741khjj", .status = 20} /* 1866 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\uFFA0a\u0304𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda9741khjj", .status = 20} /* 1867 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\u1160ā𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda594fdn5q", .status = 20} /* 1868 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\u1160a\u0304𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda594fdn5q", .status = 20} /* 1869 */,
    {.source = (const lxb_char_t *) "ⴛ\u200C\u05A2\u200D。\u1160a\u0304𐹦", .ascii = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda594fdn5q", .status = 20} /* 1870 */,
    {.source = (const lxb_char_t *) "ⴛ\u200C\u05A2\u200D。\u1160ā𐹦", .ascii = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda594fdn5q", .status = 20} /* 1871 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\u1160Ā𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda594fdn5q", .status = 20} /* 1872 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\u1160A\u0304𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda594fdn5q", .status = 20} /* 1873 */,
    {.source = (const lxb_char_t *) "xn--tcb597c.xn--yda594fdn5q", .ascii = (const lxb_char_t *) "xn--tcb597c.xn--yda594fdn5q", .status = 12} /* 1874 */,
    {.source = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda594fdn5q", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda594fdn5q", .status = 20} /* 1875 */,
    {.source = (const lxb_char_t *) "xn--tcb323r.xn--yda594fdn5q", .ascii = (const lxb_char_t *) "xn--tcb323r.xn--yda594fdn5q", .status = 12} /* 1876 */,
    {.source = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda594fdn5q", .ascii = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda594fdn5q", .status = 20} /* 1877 */,
    {.source = (const lxb_char_t *) "ⴛ\u200C\u05A2\u200D。\uFFA0a\u0304𐹦", .ascii = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda9741khjj", .status = 20} /* 1878 */,
    {.source = (const lxb_char_t *) "ⴛ\u200C\u05A2\u200D。\uFFA0ā𐹦", .ascii = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda9741khjj", .status = 20} /* 1879 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\uFFA0Ā𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda9741khjj", .status = 20} /* 1880 */,
    {.source = (const lxb_char_t *) "Ⴛ\u200C\u05A2\u200D。\uFFA0A\u0304𐹦", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda9741khjj", .status = 20} /* 1881 */,
    {.source = (const lxb_char_t *) "xn--tcb597c.xn--yda9741khjj", .ascii = (const lxb_char_t *) "xn--tcb597c.xn--yda9741khjj", .status = 12} /* 1882 */,
    {.source = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda9741khjj", .ascii = (const lxb_char_t *) "xn--tcb597cdmmfa.xn--yda9741khjj", .status = 20} /* 1883 */,
    {.source = (const lxb_char_t *) "xn--tcb323r.xn--yda9741khjj", .ascii = (const lxb_char_t *) "xn--tcb323r.xn--yda9741khjj", .status = 12} /* 1884 */,
    {.source = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda9741khjj", .ascii = (const lxb_char_t *) "xn--tcb736kea974k.xn--yda9741khjj", .status = 20} /* 1885 */,
    {.source = (const lxb_char_t *) "\uFFF9\u200C｡曳⾑𐋰≯", .ascii = (const lxb_char_t *) "xn--0ug2139f.xn--hdh501y8wvfs5h", .status = 8} /* 1886 */,
    {.source = (const lxb_char_t *) "\uFFF9\u200C｡曳⾑𐋰>\u0338", .ascii = (const lxb_char_t *) "xn--0ug2139f.xn--hdh501y8wvfs5h", .status = 8} /* 1887 */,
    {.source = (const lxb_char_t *) "\uFFF9\u200C。曳襾𐋰≯", .ascii = (const lxb_char_t *) "xn--0ug2139f.xn--hdh501y8wvfs5h", .status = 8} /* 1888 */,
    {.source = (const lxb_char_t *) "\uFFF9\u200C。曳襾𐋰>\u0338", .ascii = (const lxb_char_t *) "xn--0ug2139f.xn--hdh501y8wvfs5h", .status = 8} /* 1889 */,
    {.source = (const lxb_char_t *) "xn--vn7c.xn--hdh501y8wvfs5h", .ascii = (const lxb_char_t *) "xn--vn7c.xn--hdh501y8wvfs5h", .status = 4} /* 1890 */,
    {.source = (const lxb_char_t *) "xn--0ug2139f.xn--hdh501y8wvfs5h", .ascii = (const lxb_char_t *) "xn--0ug2139f.xn--hdh501y8wvfs5h", .status = 8} /* 1891 */,
    {.source = (const lxb_char_t *) "≯⒈。ß", .ascii = (const lxb_char_t *) "xn--hdh84f.xn--zca", .status = 4} /* 1892 */,
    {.source = (const lxb_char_t *) ">\u0338⒈。ß", .ascii = (const lxb_char_t *) "xn--hdh84f.xn--zca", .status = 4} /* 1893 */,
    {.source = (const lxb_char_t *) "≯1.。ß", .ascii = (const lxb_char_t *) "xn--1-ogo..xn--zca", .status = 6} /* 1894 */,
    {.source = (const lxb_char_t *) ">\u03381.。ß", .ascii = (const lxb_char_t *) "xn--1-ogo..xn--zca", .status = 6} /* 1895 */,
    {.source = (const lxb_char_t *) ">\u03381.。SS", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1896 */,
    {.source = (const lxb_char_t *) "≯1.。SS", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1897 */,
    {.source = (const lxb_char_t *) "≯1.。ss", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1898 */,
    {.source = (const lxb_char_t *) ">\u03381.。ss", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1899 */,
    {.source = (const lxb_char_t *) ">\u03381.。Ss", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1900 */,
    {.source = (const lxb_char_t *) "≯1.。Ss", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1901 */,
    {.source = (const lxb_char_t *) "xn--1-ogo..ss", .ascii = (const lxb_char_t *) "xn--1-ogo..ss", .status = 6} /* 1902 */,
    {.source = (const lxb_char_t *) "xn--1-ogo..xn--zca", .ascii = (const lxb_char_t *) "xn--1-ogo..xn--zca", .status = 6} /* 1903 */,
    {.source = (const lxb_char_t *) ">\u0338⒈。SS", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1904 */,
    {.source = (const lxb_char_t *) "≯⒈。SS", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1905 */,
    {.source = (const lxb_char_t *) "≯⒈。ss", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1906 */,
    {.source = (const lxb_char_t *) ">\u0338⒈。ss", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1907 */,
    {.source = (const lxb_char_t *) ">\u0338⒈。Ss", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1908 */,
    {.source = (const lxb_char_t *) "≯⒈。Ss", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1909 */,
    {.source = (const lxb_char_t *) "xn--hdh84f.ss", .ascii = (const lxb_char_t *) "xn--hdh84f.ss", .status = 4} /* 1910 */,
    {.source = (const lxb_char_t *) "xn--hdh84f.xn--zca", .ascii = (const lxb_char_t *) "xn--hdh84f.xn--zca", .status = 4} /* 1911 */,
    {.source = (const lxb_char_t *) "\u0667\u200D\uFB96｡\u07DA-₆Ⴙ", .ascii = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve002g", .status = 20} /* 1912 */,
    {.source = (const lxb_char_t *) "\u0667\u200D\u06B3。\u07DA-6Ⴙ", .ascii = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve002g", .status = 20} /* 1913 */,
    {.source = (const lxb_char_t *) "\u0667\u200D\u06B3。\u07DA-6ⴙ", .ascii = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve6529a", .status = 16} /* 1914 */,
    {.source = (const lxb_char_t *) "xn--gib6m.xn---6-lve6529a", .ascii = (const lxb_char_t *) "xn--gib6m.xn---6-lve6529a", .status = 12} /* 1915 */,
    {.source = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve6529a", .ascii = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve6529a", .status = 16} /* 1916 */,
    {.source = (const lxb_char_t *) "xn--gib6m.xn---6-lve002g", .ascii = (const lxb_char_t *) "xn--gib6m.xn---6-lve002g", .status = 16} /* 1917 */,
    {.source = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve002g", .ascii = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve002g", .status = 20} /* 1918 */,
    {.source = (const lxb_char_t *) "\u0667\u200D\uFB96｡\u07DA-₆ⴙ", .ascii = (const lxb_char_t *) "xn--gib6m343e.xn---6-lve6529a", .status = 16} /* 1919 */,
    {.source = (const lxb_char_t *) "\u200C｡≠", .ascii = (const lxb_char_t *) "xn--0ug.xn--1ch", .status = 4} /* 1920 */,
    {.source = (const lxb_char_t *) "\u200C｡=\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--1ch", .status = 4} /* 1921 */,
    {.source = (const lxb_char_t *) "\u200C。≠", .ascii = (const lxb_char_t *) "xn--0ug.xn--1ch", .status = 4} /* 1922 */,
    {.source = (const lxb_char_t *) "\u200C。=\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--1ch", .status = 4} /* 1923 */,
    {.source = (const lxb_char_t *) ".xn--1ch", .ascii = (const lxb_char_t *) ".xn--1ch", .status = 6} /* 1924 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--1ch", .ascii = (const lxb_char_t *) "xn--0ug.xn--1ch", .status = 4} /* 1925 */,
    {.source = (const lxb_char_t *) "𑖿𝨔.ᡟ𑖿\u1B42\u200C", .ascii = (const lxb_char_t *) "xn--461dw464a.xn--v8e29ldzfo952a", .status = 8} /* 1926 */,
    {.source = (const lxb_char_t *) "xn--461dw464a.xn--v8e29loy65a", .ascii = (const lxb_char_t *) "xn--461dw464a.xn--v8e29loy65a", .status = 4} /* 1927 */,
    {.source = (const lxb_char_t *) "xn--461dw464a.xn--v8e29ldzfo952a", .ascii = (const lxb_char_t *) "xn--461dw464a.xn--v8e29ldzfo952a", .status = 8} /* 1928 */,
    {.source = (const lxb_char_t *) "򔣳\u200D򑝱.𖬴Ↄ≠-", .ascii = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----61n81bt713h", .status = 16} /* 1929 */,
    {.source = (const lxb_char_t *) "򔣳\u200D򑝱.𖬴Ↄ=\u0338-", .ascii = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----61n81bt713h", .status = 16} /* 1930 */,
    {.source = (const lxb_char_t *) "򔣳\u200D򑝱.𖬴ↄ=\u0338-", .ascii = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----81n51bt713h", .status = 16} /* 1931 */,
    {.source = (const lxb_char_t *) "򔣳\u200D򑝱.𖬴ↄ≠-", .ascii = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----81n51bt713h", .status = 16} /* 1932 */,
    {.source = (const lxb_char_t *) "xn--6j00chy9a.xn----81n51bt713h", .ascii = (const lxb_char_t *) "xn--6j00chy9a.xn----81n51bt713h", .status = 12} /* 1933 */,
    {.source = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----81n51bt713h", .ascii = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----81n51bt713h", .status = 16} /* 1934 */,
    {.source = (const lxb_char_t *) "xn--6j00chy9a.xn----61n81bt713h", .ascii = (const lxb_char_t *) "xn--6j00chy9a.xn----61n81bt713h", .status = 12} /* 1935 */,
    {.source = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----61n81bt713h", .ascii = (const lxb_char_t *) "xn--1ug15151gkb5a.xn----61n81bt713h", .status = 16} /* 1936 */,
    {.source = (const lxb_char_t *) "\u07E2ς\u200D𝟳。蔑򛖢", .ascii = (const lxb_char_t *) "xn--7-xmb182aez5a.xn--wy1ao4929b", .status = 12} /* 1937 */,
    {.source = (const lxb_char_t *) "\u07E2ς\u200D7。蔑򛖢", .ascii = (const lxb_char_t *) "xn--7-xmb182aez5a.xn--wy1ao4929b", .status = 12} /* 1938 */,
    {.source = (const lxb_char_t *) "\u07E2Σ\u200D7。蔑򛖢", .ascii = (const lxb_char_t *) "xn--7-zmb872aez5a.xn--wy1ao4929b", .status = 12} /* 1939 */,
    {.source = (const lxb_char_t *) "\u07E2σ\u200D7。蔑򛖢", .ascii = (const lxb_char_t *) "xn--7-zmb872aez5a.xn--wy1ao4929b", .status = 12} /* 1940 */,
    {.source = (const lxb_char_t *) "xn--7-zmb872a.xn--wy1ao4929b", .ascii = (const lxb_char_t *) "xn--7-zmb872a.xn--wy1ao4929b", .status = 8} /* 1941 */,
    {.source = (const lxb_char_t *) "xn--7-zmb872aez5a.xn--wy1ao4929b", .ascii = (const lxb_char_t *) "xn--7-zmb872aez5a.xn--wy1ao4929b", .status = 12} /* 1942 */,
    {.source = (const lxb_char_t *) "xn--7-xmb182aez5a.xn--wy1ao4929b", .ascii = (const lxb_char_t *) "xn--7-xmb182aez5a.xn--wy1ao4929b", .status = 12} /* 1943 */,
    {.source = (const lxb_char_t *) "\u07E2Σ\u200D𝟳。蔑򛖢", .ascii = (const lxb_char_t *) "xn--7-zmb872aez5a.xn--wy1ao4929b", .status = 12} /* 1944 */,
    {.source = (const lxb_char_t *) "\u07E2σ\u200D𝟳。蔑򛖢", .ascii = (const lxb_char_t *) "xn--7-zmb872aez5a.xn--wy1ao4929b", .status = 12} /* 1945 */,
    {.source = (const lxb_char_t *) "𐹰.\u0600", .ascii = (const lxb_char_t *) "xn--oo0d.xn--ifb", .status = 8} /* 1946 */,
    {.source = (const lxb_char_t *) "xn--oo0d.xn--ifb", .ascii = (const lxb_char_t *) "xn--oo0d.xn--ifb", .status = 8} /* 1947 */,
    {.source = (const lxb_char_t *) "-\u08A8.𱠖", .ascii = (const lxb_char_t *) "xn----mod.xn--5o9n", .status = 8} /* 1948 */,
    {.source = (const lxb_char_t *) "xn----mod.xn--5o9n", .ascii = (const lxb_char_t *) "xn----mod.xn--5o9n", .status = 8} /* 1949 */,
    {.source = (const lxb_char_t *) "≯𞱸󠇀。誆⒈", .ascii = (const lxb_char_t *) "xn--hdh7151p.xn--tsh1248a", .status = 8} /* 1950 */,
    {.source = (const lxb_char_t *) ">\u0338𞱸󠇀。誆⒈", .ascii = (const lxb_char_t *) "xn--hdh7151p.xn--tsh1248a", .status = 8} /* 1951 */,
    {.source = (const lxb_char_t *) "≯𞱸󠇀。誆1.", .ascii = (const lxb_char_t *) "xn--hdh7151p.xn--1-dy1d.", .status = 4} /* 1952 */,
    {.source = (const lxb_char_t *) ">\u0338𞱸󠇀。誆1.", .ascii = (const lxb_char_t *) "xn--hdh7151p.xn--1-dy1d.", .status = 4} /* 1953 */,
    {.source = (const lxb_char_t *) "xn--hdh7151p.xn--1-dy1d.", .ascii = (const lxb_char_t *) "xn--hdh7151p.xn--1-dy1d.", .status = 4} /* 1954 */,
    {.source = (const lxb_char_t *) "xn--hdh7151p.xn--tsh1248a", .ascii = (const lxb_char_t *) "xn--hdh7151p.xn--tsh1248a", .status = 8} /* 1955 */,
    {.source = (const lxb_char_t *) "\u0616𞥙䐊\u0650．︒\u0645↺\u069C", .ascii = (const lxb_char_t *) "xn--4fb0j490qjg4x.xn--hhb8o948euo5r", .status = 12} /* 1956 */,
    {.source = (const lxb_char_t *) "\u0616𞥙䐊\u0650.。\u0645↺\u069C", .ascii = (const lxb_char_t *) "xn--4fb0j490qjg4x..xn--hhb8o948e", .status = 14} /* 1957 */,
    {.source = (const lxb_char_t *) "xn--4fb0j490qjg4x..xn--hhb8o948e", .ascii = (const lxb_char_t *) "xn--4fb0j490qjg4x..xn--hhb8o948e", .status = 14} /* 1958 */,
    {.source = (const lxb_char_t *) "xn--4fb0j490qjg4x.xn--hhb8o948euo5r", .ascii = (const lxb_char_t *) "xn--4fb0j490qjg4x.xn--hhb8o948euo5r", .status = 12} /* 1959 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.\u200C\u0AC5󩸤۴", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1960 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.\u200C\u0AC5󩸤۴", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1961 */,
    {.source = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1962 */,
    {.source = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1963 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.xn--hmb76q74166b", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1964 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.xn--hmb76q74166b", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1965 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.XN--HMB76Q74166B", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1966 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.XN--HMB76Q74166B", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1967 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.Xn--Hmb76q74166b", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1968 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.Xn--Hmb76q74166b", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q74166b", .status = 8} /* 1969 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.xn--hmb76q48y18505a", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1970 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.xn--hmb76q48y18505a", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1971 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.XN--HMB76Q48Y18505A", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1972 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.XN--HMB76Q48Y18505A", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1973 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.Xn--Hmb76q48y18505a", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1974 */,
    {.source = (const lxb_char_t *) "퀬-?񶳒.Xn--Hmb76q48y18505a", .ascii = (const lxb_char_t *) "xn---?-6g4k75207c.xn--hmb76q48y18505a", .status = 8} /* 1975 */,
    {.source = (const lxb_char_t *) "Ⴌ.𐹾︒𑁿𞾄", .ascii = (const lxb_char_t *) "xn--knd.xn--y86c030a9ob6374b", .status = 8} /* 1976 */,
    {.source = (const lxb_char_t *) "Ⴌ.𐹾。𑁿𞾄", .ascii = (const lxb_char_t *) "xn--knd.xn--2o0d.xn--q30dg029a", .status = 12} /* 1977 */,
    {.source = (const lxb_char_t *) "ⴌ.𐹾。𑁿𞾄", .ascii = (const lxb_char_t *) "xn--3kj.xn--2o0d.xn--q30dg029a", .status = 12} /* 1978 */,
    {.source = (const lxb_char_t *) "xn--3kj.xn--2o0d.xn--q30dg029a", .ascii = (const lxb_char_t *) "xn--3kj.xn--2o0d.xn--q30dg029a", .status = 12} /* 1979 */,
    {.source = (const lxb_char_t *) "xn--knd.xn--2o0d.xn--q30dg029a", .ascii = (const lxb_char_t *) "xn--knd.xn--2o0d.xn--q30dg029a", .status = 12} /* 1980 */,
    {.source = (const lxb_char_t *) "ⴌ.𐹾︒𑁿𞾄", .ascii = (const lxb_char_t *) "xn--3kj.xn--y86c030a9ob6374b", .status = 8} /* 1981 */,
    {.source = (const lxb_char_t *) "xn--3kj.xn--y86c030a9ob6374b", .ascii = (const lxb_char_t *) "xn--3kj.xn--y86c030a9ob6374b", .status = 8} /* 1982 */,
    {.source = (const lxb_char_t *) "xn--knd.xn--y86c030a9ob6374b", .ascii = (const lxb_char_t *) "xn--knd.xn--y86c030a9ob6374b", .status = 8} /* 1983 */,
    {.source = (const lxb_char_t *) "񧞿╏。𞩕󠁾", .ascii = (const lxb_char_t *) "xn--iyh90030d.xn--1m6hs0260c", .status = 12} /* 1984 */,
    {.source = (const lxb_char_t *) "xn--iyh90030d.xn--1m6hs0260c", .ascii = (const lxb_char_t *) "xn--iyh90030d.xn--1m6hs0260c", .status = 12} /* 1985 */,
    {.source = (const lxb_char_t *) "\u200D┮󠇐．\u0C00\u0C4D\u1734\u200D", .ascii = (const lxb_char_t *) "xn--1ug04r.xn--eoc8m432a40i", .status = 8} /* 1986 */,
    {.source = (const lxb_char_t *) "\u200D┮󠇐.\u0C00\u0C4D\u1734\u200D", .ascii = (const lxb_char_t *) "xn--1ug04r.xn--eoc8m432a40i", .status = 8} /* 1987 */,
    {.source = (const lxb_char_t *) "xn--kxh.xn--eoc8m432a", .ascii = (const lxb_char_t *) "xn--kxh.xn--eoc8m432a", .status = 4} /* 1988 */,
    {.source = (const lxb_char_t *) "xn--1ug04r.xn--eoc8m432a40i", .ascii = (const lxb_char_t *) "xn--1ug04r.xn--eoc8m432a40i", .status = 8} /* 1989 */,
    {.source = (const lxb_char_t *) "򹚪｡🄂", .ascii = (const lxb_char_t *) "xn--n433d.xn--v07h", .status = 4} /* 1990 */,
    {.source = (const lxb_char_t *) "򹚪。1,", .ascii = (const lxb_char_t *) "xn--n433d.1,", .status = 4} /* 1991 */,
    {.source = (const lxb_char_t *) "xn--n433d.1,", .ascii = (const lxb_char_t *) "xn--n433d.1,", .status = 4} /* 1992 */,
    {.source = (const lxb_char_t *) "xn--n433d.xn--v07h", .ascii = (const lxb_char_t *) "xn--n433d.xn--v07h", .status = 4} /* 1993 */,
    {.source = (const lxb_char_t *) "𑍨刍.🛦", .ascii = (const lxb_char_t *) "xn--rbry728b.xn--y88h", .status = 4} /* 1994 */,
    {.source = (const lxb_char_t *) "xn--rbry728b.xn--y88h", .ascii = (const lxb_char_t *) "xn--rbry728b.xn--y88h", .status = 4} /* 1995 */,
    {.source = (const lxb_char_t *) "󠌏3｡\u1BF1𝟒", .ascii = (const lxb_char_t *) "xn--3-ib31m.xn--4-pql", .status = 8} /* 1996 */,
    {.source = (const lxb_char_t *) "󠌏3。\u1BF14", .ascii = (const lxb_char_t *) "xn--3-ib31m.xn--4-pql", .status = 8} /* 1997 */,
    {.source = (const lxb_char_t *) "xn--3-ib31m.xn--4-pql", .ascii = (const lxb_char_t *) "xn--3-ib31m.xn--4-pql", .status = 8} /* 1998 */,
    {.source = (const lxb_char_t *) "\u0687６Ⴔ辘.\uFD22\u0687\u200C", .ascii = (const lxb_char_t *) "xn--6-gsc039eqq6k.xn--0gb6bxkx18g", .status = 16} /* 1999 */,
    {.source = (const lxb_char_t *) "\u06876Ⴔ辘.\u0635\u064A\u0687\u200C", .ascii = (const lxb_char_t *) "xn--6-gsc039eqq6k.xn--0gb6bxkx18g", .status = 16} /* 2000 */,
    {.source = (const lxb_char_t *) "\u06876ⴔ辘.\u0635\u064A\u0687\u200C", .ascii = (const lxb_char_t *) "xn--6-gsc2270akm6f.xn--0gb6bxkx18g", .status = 12} /* 2001 */,
    {.source = (const lxb_char_t *) "xn--6-gsc2270akm6f.xn--0gb6bxk", .ascii = (const lxb_char_t *) "xn--6-gsc2270akm6f.xn--0gb6bxk", .status = 8} /* 2002 */,
    {.source = (const lxb_char_t *) "xn--6-gsc2270akm6f.xn--0gb6bxkx18g", .ascii = (const lxb_char_t *) "xn--6-gsc2270akm6f.xn--0gb6bxkx18g", .status = 12} /* 2003 */,
    {.source = (const lxb_char_t *) "xn--6-gsc039eqq6k.xn--0gb6bxk", .ascii = (const lxb_char_t *) "xn--6-gsc039eqq6k.xn--0gb6bxk", .status = 12} /* 2004 */,
    {.source = (const lxb_char_t *) "xn--6-gsc039eqq6k.xn--0gb6bxkx18g", .ascii = (const lxb_char_t *) "xn--6-gsc039eqq6k.xn--0gb6bxkx18g", .status = 16} /* 2005 */,
    {.source = (const lxb_char_t *) "\u0687６ⴔ辘.\uFD22\u0687\u200C", .ascii = (const lxb_char_t *) "xn--6-gsc2270akm6f.xn--0gb6bxkx18g", .status = 12} /* 2006 */,
    {.source = (const lxb_char_t *) "󠄍.𐮭𞰬򻫞۹", .ascii = (const lxb_char_t *) ".xn--mmb3954kd0uf1zx7f", .status = 14} /* 2007 */,
    {.source = (const lxb_char_t *) ".xn--mmb3954kd0uf1zx7f", .ascii = (const lxb_char_t *) ".xn--mmb3954kd0uf1zx7f", .status = 14} /* 2008 */,
    {.source = (const lxb_char_t *) "\uA87D≯．򻲀򒳄", .ascii = (const lxb_char_t *) "xn--hdh8193c.xn--5z40cp629b", .status = 4} /* 2009 */,
    {.source = (const lxb_char_t *) "\uA87D>\u0338．򻲀򒳄", .ascii = (const lxb_char_t *) "xn--hdh8193c.xn--5z40cp629b", .status = 4} /* 2010 */,
    {.source = (const lxb_char_t *) "\uA87D≯.򻲀򒳄", .ascii = (const lxb_char_t *) "xn--hdh8193c.xn--5z40cp629b", .status = 4} /* 2011 */,
    {.source = (const lxb_char_t *) "\uA87D>\u0338.򻲀򒳄", .ascii = (const lxb_char_t *) "xn--hdh8193c.xn--5z40cp629b", .status = 4} /* 2012 */,
    {.source = (const lxb_char_t *) "xn--hdh8193c.xn--5z40cp629b", .ascii = (const lxb_char_t *) "xn--hdh8193c.xn--5z40cp629b", .status = 4} /* 2013 */,
    {.source = (const lxb_char_t *) "ςო\u067B.ς\u0714", .ascii = (const lxb_char_t *) "xn--3xa80l26n.xn--3xa41o", .status = 8} /* 2014 */,
    {.source = (const lxb_char_t *) "ΣᲝ\u067B.Σ\u0714", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--4xa21o", .status = 8} /* 2015 */,
    {.source = (const lxb_char_t *) "σო\u067B.σ\u0714", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--4xa21o", .status = 8} /* 2016 */,
    {.source = (const lxb_char_t *) "Σო\u067B.σ\u0714", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--4xa21o", .status = 8} /* 2017 */,
    {.source = (const lxb_char_t *) "xn--4xa60l26n.xn--4xa21o", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--4xa21o", .status = 8} /* 2018 */,
    {.source = (const lxb_char_t *) "Σო\u067B.ς\u0714", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--3xa41o", .status = 8} /* 2019 */,
    {.source = (const lxb_char_t *) "σო\u067B.ς\u0714", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--3xa41o", .status = 8} /* 2020 */,
    {.source = (const lxb_char_t *) "xn--4xa60l26n.xn--3xa41o", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--3xa41o", .status = 8} /* 2021 */,
    {.source = (const lxb_char_t *) "xn--3xa80l26n.xn--3xa41o", .ascii = (const lxb_char_t *) "xn--3xa80l26n.xn--3xa41o", .status = 8} /* 2022 */,
    {.source = (const lxb_char_t *) "Σო\u067B.Σ\u0714", .ascii = (const lxb_char_t *) "xn--4xa60l26n.xn--4xa21o", .status = 8} /* 2023 */,
    {.source = (const lxb_char_t *) "򄖚\u0748𠄯\u075F｡󠛩", .ascii = (const lxb_char_t *) "xn--vob0c4369twfv8b.xn--kl46e", .status = 16} /* 2024 */,
    {.source = (const lxb_char_t *) "򄖚\u0748𠄯\u075F。󠛩", .ascii = (const lxb_char_t *) "xn--vob0c4369twfv8b.xn--kl46e", .status = 16} /* 2025 */,
    {.source = (const lxb_char_t *) "xn--vob0c4369twfv8b.xn--kl46e", .ascii = (const lxb_char_t *) "xn--vob0c4369twfv8b.xn--kl46e", .status = 16} /* 2026 */,
    {.source = (const lxb_char_t *) "󠳛．\u200D䤫≠Ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--2nd159e9vb743e", .status = 8} /* 2027 */,
    {.source = (const lxb_char_t *) "󠳛．\u200D䤫=\u0338Ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--2nd159e9vb743e", .status = 8} /* 2028 */,
    {.source = (const lxb_char_t *) "󠳛.\u200D䤫≠Ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--2nd159e9vb743e", .status = 8} /* 2029 */,
    {.source = (const lxb_char_t *) "󠳛.\u200D䤫=\u0338Ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--2nd159e9vb743e", .status = 8} /* 2030 */,
    {.source = (const lxb_char_t *) "󠳛.\u200D䤫=\u0338ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--1ug73gzzpwi3a", .status = 8} /* 2031 */,
    {.source = (const lxb_char_t *) "󠳛.\u200D䤫≠ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--1ug73gzzpwi3a", .status = 8} /* 2032 */,
    {.source = (const lxb_char_t *) "xn--1t56e.xn--1ch153bqvw", .ascii = (const lxb_char_t *) "xn--1t56e.xn--1ch153bqvw", .status = 4} /* 2033 */,
    {.source = (const lxb_char_t *) "xn--1t56e.xn--1ug73gzzpwi3a", .ascii = (const lxb_char_t *) "xn--1t56e.xn--1ug73gzzpwi3a", .status = 8} /* 2034 */,
    {.source = (const lxb_char_t *) "xn--1t56e.xn--2nd141ghl2a", .ascii = (const lxb_char_t *) "xn--1t56e.xn--2nd141ghl2a", .status = 4} /* 2035 */,
    {.source = (const lxb_char_t *) "xn--1t56e.xn--2nd159e9vb743e", .ascii = (const lxb_char_t *) "xn--1t56e.xn--2nd159e9vb743e", .status = 8} /* 2036 */,
    {.source = (const lxb_char_t *) "󠳛．\u200D䤫=\u0338ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--1ug73gzzpwi3a", .status = 8} /* 2037 */,
    {.source = (const lxb_char_t *) "󠳛．\u200D䤫≠ⴞ", .ascii = (const lxb_char_t *) "xn--1t56e.xn--1ug73gzzpwi3a", .status = 8} /* 2038 */,
    {.source = (const lxb_char_t *) "𐽘𑈵．𐹣🕥", .ascii = (const lxb_char_t *) "xn--bv0d02c.xn--bo0dq650b", .status = 12} /* 2039 */,
    {.source = (const lxb_char_t *) "𐽘𑈵.𐹣🕥", .ascii = (const lxb_char_t *) "xn--bv0d02c.xn--bo0dq650b", .status = 12} /* 2040 */,
    {.source = (const lxb_char_t *) "xn--bv0d02c.xn--bo0dq650b", .ascii = (const lxb_char_t *) "xn--bv0d02c.xn--bo0dq650b", .status = 12} /* 2041 */,
    {.source = (const lxb_char_t *) "⒊⒈𑁄。9", .ascii = (const lxb_char_t *) "xn--tshd3512p.9", .status = 4} /* 2042 */,
    {.source = (const lxb_char_t *) "3.1.𑁄。9", .ascii = (const lxb_char_t *) "3.1.xn--110d.9", .status = 4} /* 2043 */,
    {.source = (const lxb_char_t *) "3.1.xn--110d.9", .ascii = (const lxb_char_t *) "3.1.xn--110d.9", .status = 4} /* 2044 */,
    {.source = (const lxb_char_t *) "xn--tshd3512p.9", .ascii = (const lxb_char_t *) "xn--tshd3512p.9", .status = 4} /* 2045 */,
    {.source = (const lxb_char_t *) "-\u200C\u2DF1≮．𐹱򭏴4₉", .ascii = (const lxb_char_t *) "xn----sgn20i14s.xn--49-ki3om2611f", .status = 16} /* 2046 */,
    {.source = (const lxb_char_t *) "-\u200C\u2DF1<\u0338．𐹱򭏴4₉", .ascii = (const lxb_char_t *) "xn----sgn20i14s.xn--49-ki3om2611f", .status = 16} /* 2047 */,
    {.source = (const lxb_char_t *) "-\u200C\u2DF1≮.𐹱򭏴49", .ascii = (const lxb_char_t *) "xn----sgn20i14s.xn--49-ki3om2611f", .status = 16} /* 2048 */,
    {.source = (const lxb_char_t *) "-\u200C\u2DF1<\u0338.𐹱򭏴49", .ascii = (const lxb_char_t *) "xn----sgn20i14s.xn--49-ki3om2611f", .status = 16} /* 2049 */,
    {.source = (const lxb_char_t *) "xn----ngo823c.xn--49-ki3om2611f", .ascii = (const lxb_char_t *) "xn----ngo823c.xn--49-ki3om2611f", .status = 12} /* 2050 */,
    {.source = (const lxb_char_t *) "xn----sgn20i14s.xn--49-ki3om2611f", .ascii = (const lxb_char_t *) "xn----sgn20i14s.xn--49-ki3om2611f", .status = 16} /* 2051 */,
    {.source = (const lxb_char_t *) "-≯딾｡\u0847", .ascii = (const lxb_char_t *) "xn----pgow547d.xn--5vb", .status = 8} /* 2052 */,
    {.source = (const lxb_char_t *) "->\u0338딾｡\u0847", .ascii = (const lxb_char_t *) "xn----pgow547d.xn--5vb", .status = 8} /* 2053 */,
    {.source = (const lxb_char_t *) "-≯딾。\u0847", .ascii = (const lxb_char_t *) "xn----pgow547d.xn--5vb", .status = 8} /* 2054 */,
    {.source = (const lxb_char_t *) "->\u0338딾。\u0847", .ascii = (const lxb_char_t *) "xn----pgow547d.xn--5vb", .status = 8} /* 2055 */,
    {.source = (const lxb_char_t *) "xn----pgow547d.xn--5vb", .ascii = (const lxb_char_t *) "xn----pgow547d.xn--5vb", .status = 8} /* 2056 */,
    {.source = (const lxb_char_t *) "𑙢⒈𐹠-｡󠗐\u200C", .ascii = (const lxb_char_t *) "xn----dcpy090hiyg.xn--0ug23321l", .status = 16} /* 2057 */,
    {.source = (const lxb_char_t *) "𑙢1.𐹠-。󠗐\u200C", .ascii = (const lxb_char_t *) "xn--1-bf0j.xn----516i.xn--0ug23321l", .status = 16} /* 2058 */,
    {.source = (const lxb_char_t *) "xn--1-bf0j.xn----516i.xn--jd46e", .ascii = (const lxb_char_t *) "xn--1-bf0j.xn----516i.xn--jd46e", .status = 12} /* 2059 */,
    {.source = (const lxb_char_t *) "xn--1-bf0j.xn----516i.xn--0ug23321l", .ascii = (const lxb_char_t *) "xn--1-bf0j.xn----516i.xn--0ug23321l", .status = 16} /* 2060 */,
    {.source = (const lxb_char_t *) "xn----dcpy090hiyg.xn--jd46e", .ascii = (const lxb_char_t *) "xn----dcpy090hiyg.xn--jd46e", .status = 12} /* 2061 */,
    {.source = (const lxb_char_t *) "xn----dcpy090hiyg.xn--0ug23321l", .ascii = (const lxb_char_t *) "xn----dcpy090hiyg.xn--0ug23321l", .status = 16} /* 2062 */,
    {.source = (const lxb_char_t *) "\u034A．𐨎", .ascii = (const lxb_char_t *) "xn--oua.xn--mr9c", .status = 4} /* 2063 */,
    {.source = (const lxb_char_t *) "\u034A.𐨎", .ascii = (const lxb_char_t *) "xn--oua.xn--mr9c", .status = 4} /* 2064 */,
    {.source = (const lxb_char_t *) "xn--oua.xn--mr9c", .ascii = (const lxb_char_t *) "xn--oua.xn--mr9c", .status = 4} /* 2065 */,
    {.source = (const lxb_char_t *) "훉≮｡\u0E34", .ascii = (const lxb_char_t *) "xn--gdh2512e.xn--i4c", .status = 4} /* 2066 */,
    {.source = (const lxb_char_t *) "훉<\u0338｡\u0E34", .ascii = (const lxb_char_t *) "xn--gdh2512e.xn--i4c", .status = 4} /* 2067 */,
    {.source = (const lxb_char_t *) "훉≮。\u0E34", .ascii = (const lxb_char_t *) "xn--gdh2512e.xn--i4c", .status = 4} /* 2068 */,
    {.source = (const lxb_char_t *) "훉<\u0338。\u0E34", .ascii = (const lxb_char_t *) "xn--gdh2512e.xn--i4c", .status = 4} /* 2069 */,
    {.source = (const lxb_char_t *) "xn--gdh2512e.xn--i4c", .ascii = (const lxb_char_t *) "xn--gdh2512e.xn--i4c", .status = 4} /* 2070 */,
    {.source = (const lxb_char_t *) "\u2DF7򞣉🃘．𴈇𝟸\u0659𞤯", .ascii = (const lxb_char_t *) "xn--trj8045le6s9b.xn--2-upc23918acjsj", .status = 20} /* 2071 */,
    {.source = (const lxb_char_t *) "\u2DF7򞣉🃘.𴈇2\u0659𞤯", .ascii = (const lxb_char_t *) "xn--trj8045le6s9b.xn--2-upc23918acjsj", .status = 20} /* 2072 */,
    {.source = (const lxb_char_t *) "\u2DF7򞣉🃘.𴈇2\u0659𞤍", .ascii = (const lxb_char_t *) "xn--trj8045le6s9b.xn--2-upc23918acjsj", .status = 20} /* 2073 */,
    {.source = (const lxb_char_t *) "xn--trj8045le6s9b.xn--2-upc23918acjsj", .ascii = (const lxb_char_t *) "xn--trj8045le6s9b.xn--2-upc23918acjsj", .status = 20} /* 2074 */,
    {.source = (const lxb_char_t *) "\u2DF7򞣉🃘．𴈇𝟸\u0659𞤍", .ascii = (const lxb_char_t *) "xn--trj8045le6s9b.xn--2-upc23918acjsj", .status = 20} /* 2075 */,
    {.source = (const lxb_char_t *) "󗇩ßᢞ\u200C。\u0660𞷻\uFCD4-", .ascii = (const lxb_char_t *) "xn--zca272jbif10059a.xn----dnc5e1er384z", .status = 20} /* 2076 */,
    {.source = (const lxb_char_t *) "󗇩ßᢞ\u200C。\u0660𞷻\u0646\u062E-", .ascii = (const lxb_char_t *) "xn--zca272jbif10059a.xn----dnc5e1er384z", .status = 20} /* 2077 */,
    {.source = (const lxb_char_t *) "󗇩SSᢞ\u200C。\u0660𞷻\u0646\u062E-", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2078 */,
    {.source = (const lxb_char_t *) "󗇩ssᢞ\u200C。\u0660𞷻\u0646\u062E-", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2079 */,
    {.source = (const lxb_char_t *) "󗇩Ssᢞ\u200C。\u0660𞷻\u0646\u062E-", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2080 */,
    {.source = (const lxb_char_t *) "xn--ss-jepz4596r.xn----dnc5e1er384z", .ascii = (const lxb_char_t *) "xn--ss-jepz4596r.xn----dnc5e1er384z", .status = 12} /* 2081 */,
    {.source = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2082 */,
    {.source = (const lxb_char_t *) "xn--zca272jbif10059a.xn----dnc5e1er384z", .ascii = (const lxb_char_t *) "xn--zca272jbif10059a.xn----dnc5e1er384z", .status = 20} /* 2083 */,
    {.source = (const lxb_char_t *) "󗇩SSᢞ\u200C。\u0660𞷻\uFCD4-", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2084 */,
    {.source = (const lxb_char_t *) "󗇩ssᢞ\u200C。\u0660𞷻\uFCD4-", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2085 */,
    {.source = (const lxb_char_t *) "󗇩Ssᢞ\u200C。\u0660𞷻\uFCD4-", .ascii = (const lxb_char_t *) "xn--ss-jep006bqt765b.xn----dnc5e1er384z", .status = 20} /* 2086 */,
    {.source = (const lxb_char_t *) "ꡆ。Ↄ\u0FB5놮-", .ascii = (const lxb_char_t *) "xn--fc9a.xn----qmg787k869k", .status = 8} /* 2087 */,
    {.source = (const lxb_char_t *) "ꡆ。Ↄ\u0FB5놮-", .ascii = (const lxb_char_t *) "xn--fc9a.xn----qmg787k869k", .status = 8} /* 2088 */,
    {.source = (const lxb_char_t *) "ꡆ。ↄ\u0FB5놮-", .ascii = (const lxb_char_t *) "xn--fc9a.xn----qmg097k469k", .status = 4} /* 2089 */,
    {.source = (const lxb_char_t *) "ꡆ。ↄ\u0FB5놮-", .ascii = (const lxb_char_t *) "xn--fc9a.xn----qmg097k469k", .status = 4} /* 2090 */,
    {.source = (const lxb_char_t *) "xn--fc9a.xn----qmg097k469k", .ascii = (const lxb_char_t *) "xn--fc9a.xn----qmg097k469k", .status = 4} /* 2091 */,
    {.source = (const lxb_char_t *) "xn--fc9a.xn----qmg787k869k", .ascii = (const lxb_char_t *) "xn--fc9a.xn----qmg787k869k", .status = 8} /* 2092 */,
    {.source = (const lxb_char_t *) "\uFDAD\u200D.񥰌\u06A9", .ascii = (const lxb_char_t *) "xn--ghbcp494x.xn--ckb36214f", .status = 20} /* 2093 */,
    {.source = (const lxb_char_t *) "\u0644\u0645\u064A\u200D.񥰌\u06A9", .ascii = (const lxb_char_t *) "xn--ghbcp494x.xn--ckb36214f", .status = 20} /* 2094 */,
    {.source = (const lxb_char_t *) "xn--ghbcp.xn--ckb36214f", .ascii = (const lxb_char_t *) "xn--ghbcp.xn--ckb36214f", .status = 12} /* 2095 */,
    {.source = (const lxb_char_t *) "xn--ghbcp494x.xn--ckb36214f", .ascii = (const lxb_char_t *) "xn--ghbcp494x.xn--ckb36214f", .status = 20} /* 2096 */,
    {.source = (const lxb_char_t *) "Ⴜ\u1C2F𐳒≯。\u06E0\u1732\u0FBA", .ascii = (const lxb_char_t *) "xn--0nd679cf3eq67y.xn--wlb646b4ng", .status = 20} /* 2097 */,
    {.source = (const lxb_char_t *) "Ⴜ\u1C2F𐳒>\u0338。\u06E0\u1732\u0FBA", .ascii = (const lxb_char_t *) "xn--0nd679cf3eq67y.xn--wlb646b4ng", .status = 20} /* 2098 */,
    {.source = (const lxb_char_t *) "ⴜ\u1C2F𐳒>\u0338。\u06E0\u1732\u0FBA", .ascii = (const lxb_char_t *) "xn--r1f68xh1jgv7u.xn--wlb646b4ng", .status = 16} /* 2099 */,
    {.source = (const lxb_char_t *) "ⴜ\u1C2F𐳒≯。\u06E0\u1732\u0FBA", .ascii = (const lxb_char_t *) "xn--r1f68xh1jgv7u.xn--wlb646b4ng", .status = 16} /* 2100 */,
    {.source = (const lxb_char_t *) "Ⴜ\u1C2F𐲒≯。\u06E0\u1732\u0FBA", .ascii = (const lxb_char_t *) "xn--0nd679cf3eq67y.xn--wlb646b4ng", .status = 20} /* 2101 */,
    {.source = (const lxb_char_t *) "Ⴜ\u1C2F𐲒>\u0338。\u06E0\u1732\u0FBA", .ascii = (const lxb_char_t *) "xn--0nd679cf3eq67y.xn--wlb646b4ng", .status = 20} /* 2102 */,
    {.source = (const lxb_char_t *) "xn--0nd679cf3eq67y.xn--wlb646b4ng", .ascii = (const lxb_char_t *) "xn--0nd679cf3eq67y.xn--wlb646b4ng", .status = 20} /* 2103 */,
    {.source = (const lxb_char_t *) "xn--r1f68xh1jgv7u.xn--wlb646b4ng", .ascii = (const lxb_char_t *) "xn--r1f68xh1jgv7u.xn--wlb646b4ng", .status = 16} /* 2104 */,
    {.source = (const lxb_char_t *) "𐋵。\uFCEC", .ascii = (const lxb_char_t *) "xn--p97c.xn--fhbe", .status = 4} /* 2105 */,
    {.source = (const lxb_char_t *) "𐋵。\u0643\u0645", .ascii = (const lxb_char_t *) "xn--p97c.xn--fhbe", .status = 4} /* 2106 */,
    {.source = (const lxb_char_t *) "xn--p97c.xn--fhbe", .ascii = (const lxb_char_t *) "xn--p97c.xn--fhbe", .status = 4} /* 2107 */,
    {.source = (const lxb_char_t *) "𐋵.\u0643\u0645", .ascii = (const lxb_char_t *) "xn--p97c.xn--fhbe", .status = 4} /* 2108 */,
    {.source = (const lxb_char_t *) "≮𝅶．񱲁\uAAEC⹈󰥭", .ascii = (const lxb_char_t *) "xn--gdh0880o.xn--4tjx101bsg00ds9pyc", .status = 4} /* 2109 */,
    {.source = (const lxb_char_t *) "<\u0338𝅶．񱲁\uAAEC⹈󰥭", .ascii = (const lxb_char_t *) "xn--gdh0880o.xn--4tjx101bsg00ds9pyc", .status = 4} /* 2110 */,
    {.source = (const lxb_char_t *) "≮𝅶.񱲁\uAAEC⹈󰥭", .ascii = (const lxb_char_t *) "xn--gdh0880o.xn--4tjx101bsg00ds9pyc", .status = 4} /* 2111 */,
    {.source = (const lxb_char_t *) "<\u0338𝅶.񱲁\uAAEC⹈󰥭", .ascii = (const lxb_char_t *) "xn--gdh0880o.xn--4tjx101bsg00ds9pyc", .status = 4} /* 2112 */,
    {.source = (const lxb_char_t *) "xn--gdh0880o.xn--4tjx101bsg00ds9pyc", .ascii = (const lxb_char_t *) "xn--gdh0880o.xn--4tjx101bsg00ds9pyc", .status = 4} /* 2113 */,
    {.source = (const lxb_char_t *) "\u2DF0\u0358ᢕ．\u0361𐹷󠴍", .ascii = (const lxb_char_t *) "xn--2ua889htsp.xn--cva2687k2tv0g", .status = 12} /* 2114 */,
    {.source = (const lxb_char_t *) "\u2DF0\u0358ᢕ.\u0361𐹷󠴍", .ascii = (const lxb_char_t *) "xn--2ua889htsp.xn--cva2687k2tv0g", .status = 12} /* 2115 */,
    {.source = (const lxb_char_t *) "xn--2ua889htsp.xn--cva2687k2tv0g", .ascii = (const lxb_char_t *) "xn--2ua889htsp.xn--cva2687k2tv0g", .status = 12} /* 2116 */,
    {.source = (const lxb_char_t *) "\uFD79ᡐ\u200C\u06AD．𑋪\u05C7", .ascii = (const lxb_char_t *) "xn--5gbwa03bg24eptk.xn--vdb1198k", .status = 12} /* 2117 */,
    {.source = (const lxb_char_t *) "\u063A\u0645\u0645ᡐ\u200C\u06AD.𑋪\u05C7", .ascii = (const lxb_char_t *) "xn--5gbwa03bg24eptk.xn--vdb1198k", .status = 12} /* 2118 */,
    {.source = (const lxb_char_t *) "xn--5gbwa03bg24e.xn--vdb1198k", .ascii = (const lxb_char_t *) "xn--5gbwa03bg24e.xn--vdb1198k", .status = 12} /* 2119 */,
    {.source = (const lxb_char_t *) "xn--5gbwa03bg24eptk.xn--vdb1198k", .ascii = (const lxb_char_t *) "xn--5gbwa03bg24eptk.xn--vdb1198k", .status = 12} /* 2120 */,
    {.source = (const lxb_char_t *) "𑑂｡\u200D󥞀🞕򥁔", .ascii = (const lxb_char_t *) "xn--8v1d.xn--1ug1386plvx1cd8vya", .status = 12} /* 2121 */,
    {.source = (const lxb_char_t *) "𑑂。\u200D󥞀🞕򥁔", .ascii = (const lxb_char_t *) "xn--8v1d.xn--1ug1386plvx1cd8vya", .status = 12} /* 2122 */,
    {.source = (const lxb_char_t *) "xn--8v1d.xn--ye9h41035a2qqs", .ascii = (const lxb_char_t *) "xn--8v1d.xn--ye9h41035a2qqs", .status = 8} /* 2123 */,
    {.source = (const lxb_char_t *) "xn--8v1d.xn--1ug1386plvx1cd8vya", .ascii = (const lxb_char_t *) "xn--8v1d.xn--1ug1386plvx1cd8vya", .status = 12} /* 2124 */,
    {.source = (const lxb_char_t *) "-\u05E9。⒚", .ascii = (const lxb_char_t *) "xn----gjc.xn--cth", .status = 12} /* 2125 */,
    {.source = (const lxb_char_t *) "-\u05E9。19.", .ascii = (const lxb_char_t *) "xn----gjc.19.", .status = 8} /* 2126 */,
    {.source = (const lxb_char_t *) "xn----gjc.19.", .ascii = (const lxb_char_t *) "xn----gjc.19.", .status = 8} /* 2127 */,
    {.source = (const lxb_char_t *) "xn----gjc.xn--cth", .ascii = (const lxb_char_t *) "xn----gjc.xn--cth", .status = 12} /* 2128 */,
    {.source = (const lxb_char_t *) "􊾻\u0845\u200C｡ᢎ\u200D", .ascii = (const lxb_char_t *) "xn--3vb882jz4411a.xn--79e259a", .status = 20} /* 2129 */,
    {.source = (const lxb_char_t *) "􊾻\u0845\u200C。ᢎ\u200D", .ascii = (const lxb_char_t *) "xn--3vb882jz4411a.xn--79e259a", .status = 20} /* 2130 */,
    {.source = (const lxb_char_t *) "xn--3vb50049s.xn--79e", .ascii = (const lxb_char_t *) "xn--3vb50049s.xn--79e", .status = 12} /* 2131 */,
    {.source = (const lxb_char_t *) "xn--3vb882jz4411a.xn--79e259a", .ascii = (const lxb_char_t *) "xn--3vb882jz4411a.xn--79e259a", .status = 20} /* 2132 */,
    {.source = (const lxb_char_t *) "ß\u09C1\u1DED。\u06208₅", .ascii = (const lxb_char_t *) "xn--zca266bwrr.xn--85-psd", .status = 0} /* 2133 */,
    {.source = (const lxb_char_t *) "ß\u09C1\u1DED。\u062085", .ascii = (const lxb_char_t *) "xn--zca266bwrr.xn--85-psd", .status = 0} /* 2134 */,
    {.source = (const lxb_char_t *) "SS\u09C1\u1DED。\u062085", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2135 */,
    {.source = (const lxb_char_t *) "ss\u09C1\u1DED。\u062085", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2136 */,
    {.source = (const lxb_char_t *) "Ss\u09C1\u1DED。\u062085", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2137 */,
    {.source = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2138 */,
    {.source = (const lxb_char_t *) "ss\u09C1\u1DED.\u062085", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2139 */,
    {.source = (const lxb_char_t *) "SS\u09C1\u1DED.\u062085", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2140 */,
    {.source = (const lxb_char_t *) "Ss\u09C1\u1DED.\u062085", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2141 */,
    {.source = (const lxb_char_t *) "xn--zca266bwrr.xn--85-psd", .ascii = (const lxb_char_t *) "xn--zca266bwrr.xn--85-psd", .status = 0} /* 2142 */,
    {.source = (const lxb_char_t *) "ß\u09C1\u1DED.\u062085", .ascii = (const lxb_char_t *) "xn--zca266bwrr.xn--85-psd", .status = 0} /* 2143 */,
    {.source = (const lxb_char_t *) "SS\u09C1\u1DED。\u06208₅", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2144 */,
    {.source = (const lxb_char_t *) "ss\u09C1\u1DED。\u06208₅", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2145 */,
    {.source = (const lxb_char_t *) "Ss\u09C1\u1DED。\u06208₅", .ascii = (const lxb_char_t *) "xn--ss-e2f077r.xn--85-psd", .status = 0} /* 2146 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅𝟣．₃𐹥ß", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3-qfa7018r", .status = 8} /* 2147 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅1.3𐹥ß", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3-qfa7018r", .status = 8} /* 2148 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅1.3𐹥SS", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2149 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅1.3𐹥ss", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2150 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅1.3𐹥Ss", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2151 */,
    {.source = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2152 */,
    {.source = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3-qfa7018r", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3-qfa7018r", .status = 8} /* 2153 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅𝟣．₃𐹥SS", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2154 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅𝟣．₃𐹥ss", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2155 */,
    {.source = (const lxb_char_t *) "\u0ACD\u0484魅𝟣．₃𐹥Ss", .ascii = (const lxb_char_t *) "xn--1-0xb049b102o.xn--3ss-nv9t", .status = 8} /* 2156 */,
    {.source = (const lxb_char_t *) "\u072B｡𑓂⒈𑜫󠿻", .ascii = (const lxb_char_t *) "xn--1nb.xn--tsh7798f6rbrt828c", .status = 12} /* 2157 */,
    {.source = (const lxb_char_t *) "\u072B。𑓂1.𑜫󠿻", .ascii = (const lxb_char_t *) "xn--1nb.xn--1-jq9i.xn--ji2dg9877c", .status = 12} /* 2158 */,
    {.source = (const lxb_char_t *) "xn--1nb.xn--1-jq9i.xn--ji2dg9877c", .ascii = (const lxb_char_t *) "xn--1nb.xn--1-jq9i.xn--ji2dg9877c", .status = 12} /* 2159 */,
    {.source = (const lxb_char_t *) "xn--1nb.xn--tsh7798f6rbrt828c", .ascii = (const lxb_char_t *) "xn--1nb.xn--tsh7798f6rbrt828c", .status = 12} /* 2160 */,
    {.source = (const lxb_char_t *) "\uFE0Dછ。嵨", .ascii = (const lxb_char_t *) "xn--6dc.xn--tot", .status = 0} /* 2161 */,
    {.source = (const lxb_char_t *) "xn--6dc.xn--tot", .ascii = (const lxb_char_t *) "xn--6dc.xn--tot", .status = 0} /* 2162 */,
    {.source = (const lxb_char_t *) "છ.嵨", .ascii = (const lxb_char_t *) "xn--6dc.xn--tot", .status = 0} /* 2163 */,
    {.source = (const lxb_char_t *) "Ⴔ≠Ⴀ.𐹥𐹰", .ascii = (const lxb_char_t *) "xn--7md3b171g.xn--do0dwa", .status = 8} /* 2164 */,
    {.source = (const lxb_char_t *) "Ⴔ=\u0338Ⴀ.𐹥𐹰", .ascii = (const lxb_char_t *) "xn--7md3b171g.xn--do0dwa", .status = 8} /* 2165 */,
    {.source = (const lxb_char_t *) "ⴔ=\u0338ⴀ.𐹥𐹰", .ascii = (const lxb_char_t *) "xn--1ch603bxb.xn--do0dwa", .status = 4} /* 2166 */,
    {.source = (const lxb_char_t *) "ⴔ≠ⴀ.𐹥𐹰", .ascii = (const lxb_char_t *) "xn--1ch603bxb.xn--do0dwa", .status = 4} /* 2167 */,
    {.source = (const lxb_char_t *) "xn--1ch603bxb.xn--do0dwa", .ascii = (const lxb_char_t *) "xn--1ch603bxb.xn--do0dwa", .status = 4} /* 2168 */,
    {.source = (const lxb_char_t *) "xn--7md3b171g.xn--do0dwa", .ascii = (const lxb_char_t *) "xn--7md3b171g.xn--do0dwa", .status = 8} /* 2169 */,
    {.source = (const lxb_char_t *) "-\u200C⒙𐫥｡𝨵", .ascii = (const lxb_char_t *) "xn----sgn18r3191a.xn--382h", .status = 16} /* 2170 */,
    {.source = (const lxb_char_t *) "-\u200C18.𐫥。𝨵", .ascii = (const lxb_char_t *) "xn---18-9m0a.xn--rx9c.xn--382h", .status = 12} /* 2171 */,
    {.source = (const lxb_char_t *) "-18.xn--rx9c.xn--382h", .ascii = (const lxb_char_t *) "-18.xn--rx9c.xn--382h", .status = 8} /* 2172 */,
    {.source = (const lxb_char_t *) "xn---18-9m0a.xn--rx9c.xn--382h", .ascii = (const lxb_char_t *) "xn---18-9m0a.xn--rx9c.xn--382h", .status = 12} /* 2173 */,
    {.source = (const lxb_char_t *) "xn----ddps939g.xn--382h", .ascii = (const lxb_char_t *) "xn----ddps939g.xn--382h", .status = 12} /* 2174 */,
    {.source = (const lxb_char_t *) "xn----sgn18r3191a.xn--382h", .ascii = (const lxb_char_t *) "xn----sgn18r3191a.xn--382h", .status = 16} /* 2175 */,
    {.source = (const lxb_char_t *) "︒.ʌᠣ-𐹽", .ascii = (const lxb_char_t *) "xn--y86c.xn----73a596nuh9t", .status = 16} /* 2176 */,
    {.source = (const lxb_char_t *) "。.ʌᠣ-𐹽", .ascii = (const lxb_char_t *) "..xn----73a596nuh9t", .status = 14} /* 2177 */,
    {.source = (const lxb_char_t *) "。.Ʌᠣ-𐹽", .ascii = (const lxb_char_t *) "..xn----73a596nuh9t", .status = 14} /* 2178 */,
    {.source = (const lxb_char_t *) "..xn----73a596nuh9t", .ascii = (const lxb_char_t *) "..xn----73a596nuh9t", .status = 14} /* 2179 */,
    {.source = (const lxb_char_t *) "︒.Ʌᠣ-𐹽", .ascii = (const lxb_char_t *) "xn--y86c.xn----73a596nuh9t", .status = 16} /* 2180 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn----73a596nuh9t", .ascii = (const lxb_char_t *) "xn--y86c.xn----73a596nuh9t", .status = 16} /* 2181 */,
    {.source = (const lxb_char_t *) "\uFE05︒。𦀾\u1CE0", .ascii = (const lxb_char_t *) "xn--y86c.xn--t6f5138v", .status = 4} /* 2182 */,
    {.source = (const lxb_char_t *) "\uFE05。。𦀾\u1CE0", .ascii = (const lxb_char_t *) "..xn--t6f5138v", .status = 6} /* 2183 */,
    {.source = (const lxb_char_t *) "..xn--t6f5138v", .ascii = (const lxb_char_t *) "..xn--t6f5138v", .status = 6} /* 2184 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--t6f5138v", .ascii = (const lxb_char_t *) "xn--y86c.xn--t6f5138v", .status = 4} /* 2185 */,
    {.source = (const lxb_char_t *) "xn--t6f5138v", .ascii = (const lxb_char_t *) "xn--t6f5138v", .status = 0} /* 2186 */,
    {.source = (const lxb_char_t *) "𦀾\u1CE0", .ascii = (const lxb_char_t *) "xn--t6f5138v", .status = 0} /* 2187 */,
    {.source = (const lxb_char_t *) "𞮑ß􏞞。ᡁ", .ascii = (const lxb_char_t *) "xn--zca9432wb989f.xn--07e", .status = 12} /* 2188 */,
    {.source = (const lxb_char_t *) "𞮑SS􏞞。ᡁ", .ascii = (const lxb_char_t *) "xn--ss-o412ac6305g.xn--07e", .status = 12} /* 2189 */,
    {.source = (const lxb_char_t *) "𞮑ss􏞞。ᡁ", .ascii = (const lxb_char_t *) "xn--ss-o412ac6305g.xn--07e", .status = 12} /* 2190 */,
    {.source = (const lxb_char_t *) "𞮑Ss􏞞。ᡁ", .ascii = (const lxb_char_t *) "xn--ss-o412ac6305g.xn--07e", .status = 12} /* 2191 */,
    {.source = (const lxb_char_t *) "xn--ss-o412ac6305g.xn--07e", .ascii = (const lxb_char_t *) "xn--ss-o412ac6305g.xn--07e", .status = 12} /* 2192 */,
    {.source = (const lxb_char_t *) "xn--zca9432wb989f.xn--07e", .ascii = (const lxb_char_t *) "xn--zca9432wb989f.xn--07e", .status = 12} /* 2193 */,
    {.source = (const lxb_char_t *) "\uA953\u200D\u062C\u066C。𱆎󻡟\u200C󠅆", .ascii = (const lxb_char_t *) "xn--rgb2k500fhq9j.xn--0ug78870a5sp9d", .status = 20} /* 2194 */,
    {.source = (const lxb_char_t *) "xn--rgb2k6711c.xn--ec8nj3948b", .ascii = (const lxb_char_t *) "xn--rgb2k6711c.xn--ec8nj3948b", .status = 16} /* 2195 */,
    {.source = (const lxb_char_t *) "xn--rgb2k500fhq9j.xn--0ug78870a5sp9d", .ascii = (const lxb_char_t *) "xn--rgb2k500fhq9j.xn--0ug78870a5sp9d", .status = 20} /* 2196 */,
    {.source = (const lxb_char_t *) "󠕏．-ß\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn----qfa750ve7b", .status = 12} /* 2197 */,
    {.source = (const lxb_char_t *) "󠕏．-ß\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn----qfa750ve7b", .status = 12} /* 2198 */,
    {.source = (const lxb_char_t *) "󠕏.-ß\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn----qfa750ve7b", .status = 12} /* 2199 */,
    {.source = (const lxb_char_t *) "󠕏.-ß\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn----qfa750ve7b", .status = 12} /* 2200 */,
    {.source = (const lxb_char_t *) "󠕏.-SS\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2201 */,
    {.source = (const lxb_char_t *) "󠕏.-SS\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2202 */,
    {.source = (const lxb_char_t *) "󠕏.-ss\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2203 */,
    {.source = (const lxb_char_t *) "󠕏.-ss\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2204 */,
    {.source = (const lxb_char_t *) "󠕏.-Ss\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2205 */,
    {.source = (const lxb_char_t *) "󠕏.-Ss\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2206 */,
    {.source = (const lxb_char_t *) "xn--u836e.xn---ss-gl2a", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-gl2a", .status = 8} /* 2207 */,
    {.source = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2208 */,
    {.source = (const lxb_char_t *) "xn--u836e.xn----qfa750ve7b", .ascii = (const lxb_char_t *) "xn--u836e.xn----qfa750ve7b", .status = 12} /* 2209 */,
    {.source = (const lxb_char_t *) "󠕏．-SS\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2210 */,
    {.source = (const lxb_char_t *) "󠕏．-SS\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2211 */,
    {.source = (const lxb_char_t *) "󠕏．-ss\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2212 */,
    {.source = (const lxb_char_t *) "󠕏．-ss\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2213 */,
    {.source = (const lxb_char_t *) "󠕏．-Ss\u200C=\u0338", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2214 */,
    {.source = (const lxb_char_t *) "󠕏．-Ss\u200C≠", .ascii = (const lxb_char_t *) "xn--u836e.xn---ss-cn0at5l", .status = 12} /* 2215 */,
    {.source = (const lxb_char_t *) "ᡙ\u200C｡≯𐋲≠", .ascii = (const lxb_char_t *) "xn--p8e650b.xn--1ch3a7084l", .status = 4} /* 2216 */,
    {.source = (const lxb_char_t *) "ᡙ\u200C｡>\u0338𐋲=\u0338", .ascii = (const lxb_char_t *) "xn--p8e650b.xn--1ch3a7084l", .status = 4} /* 2217 */,
    {.source = (const lxb_char_t *) "ᡙ\u200C。≯𐋲≠", .ascii = (const lxb_char_t *) "xn--p8e650b.xn--1ch3a7084l", .status = 4} /* 2218 */,
    {.source = (const lxb_char_t *) "ᡙ\u200C。>\u0338𐋲=\u0338", .ascii = (const lxb_char_t *) "xn--p8e650b.xn--1ch3a7084l", .status = 4} /* 2219 */,
    {.source = (const lxb_char_t *) "xn--p8e.xn--1ch3a7084l", .ascii = (const lxb_char_t *) "xn--p8e.xn--1ch3a7084l", .status = 0} /* 2220 */,
    {.source = (const lxb_char_t *) "ᡙ.≯𐋲≠", .ascii = (const lxb_char_t *) "xn--p8e.xn--1ch3a7084l", .status = 0} /* 2221 */,
    {.source = (const lxb_char_t *) "ᡙ.>\u0338𐋲=\u0338", .ascii = (const lxb_char_t *) "xn--p8e.xn--1ch3a7084l", .status = 0} /* 2222 */,
    {.source = (const lxb_char_t *) "xn--p8e650b.xn--1ch3a7084l", .ascii = (const lxb_char_t *) "xn--p8e650b.xn--1ch3a7084l", .status = 4} /* 2223 */,
    {.source = (const lxb_char_t *) "𐹧𞲄󠁭񆼩。\u034E🄀", .ascii = (const lxb_char_t *) "xn--fo0dw409aq58qrn69d.xn--sua6883w", .status = 12} /* 2224 */,
    {.source = (const lxb_char_t *) "𐹧𞲄󠁭񆼩。\u034E0.", .ascii = (const lxb_char_t *) "xn--fo0dw409aq58qrn69d.xn--0-bgb.", .status = 12} /* 2225 */,
    {.source = (const lxb_char_t *) "xn--fo0dw409aq58qrn69d.xn--0-bgb.", .ascii = (const lxb_char_t *) "xn--fo0dw409aq58qrn69d.xn--0-bgb.", .status = 12} /* 2226 */,
    {.source = (const lxb_char_t *) "xn--fo0dw409aq58qrn69d.xn--sua6883w", .ascii = (const lxb_char_t *) "xn--fo0dw409aq58qrn69d.xn--sua6883w", .status = 12} /* 2227 */,
    {.source = (const lxb_char_t *) "Ⴄ．\u200D\u0721󻣋ς", .ascii = (const lxb_char_t *) "xn--cnd.xn--3xa93o3t5ajq467a", .status = 12} /* 2228 */,
    {.source = (const lxb_char_t *) "Ⴄ.\u200D\u0721󻣋ς", .ascii = (const lxb_char_t *) "xn--cnd.xn--3xa93o3t5ajq467a", .status = 12} /* 2229 */,
    {.source = (const lxb_char_t *) "ⴄ.\u200D\u0721󻣋ς", .ascii = (const lxb_char_t *) "xn--vkj.xn--3xa93o3t5ajq467a", .status = 12} /* 2230 */,
    {.source = (const lxb_char_t *) "Ⴄ.\u200D\u0721󻣋Σ", .ascii = (const lxb_char_t *) "xn--cnd.xn--4xa73o3t5ajq467a", .status = 12} /* 2231 */,
    {.source = (const lxb_char_t *) "ⴄ.\u200D\u0721󻣋σ", .ascii = (const lxb_char_t *) "xn--vkj.xn--4xa73o3t5ajq467a", .status = 12} /* 2232 */,
    {.source = (const lxb_char_t *) "xn--vkj.xn--4xa73ob5892c", .ascii = (const lxb_char_t *) "xn--vkj.xn--4xa73ob5892c", .status = 12} /* 2233 */,
    {.source = (const lxb_char_t *) "xn--vkj.xn--4xa73o3t5ajq467a", .ascii = (const lxb_char_t *) "xn--vkj.xn--4xa73o3t5ajq467a", .status = 12} /* 2234 */,
    {.source = (const lxb_char_t *) "xn--cnd.xn--4xa73ob5892c", .ascii = (const lxb_char_t *) "xn--cnd.xn--4xa73ob5892c", .status = 12} /* 2235 */,
    {.source = (const lxb_char_t *) "xn--cnd.xn--4xa73o3t5ajq467a", .ascii = (const lxb_char_t *) "xn--cnd.xn--4xa73o3t5ajq467a", .status = 12} /* 2236 */,
    {.source = (const lxb_char_t *) "xn--vkj.xn--3xa93o3t5ajq467a", .ascii = (const lxb_char_t *) "xn--vkj.xn--3xa93o3t5ajq467a", .status = 12} /* 2237 */,
    {.source = (const lxb_char_t *) "xn--cnd.xn--3xa93o3t5ajq467a", .ascii = (const lxb_char_t *) "xn--cnd.xn--3xa93o3t5ajq467a", .status = 12} /* 2238 */,
    {.source = (const lxb_char_t *) "ⴄ．\u200D\u0721󻣋ς", .ascii = (const lxb_char_t *) "xn--vkj.xn--3xa93o3t5ajq467a", .status = 12} /* 2239 */,
    {.source = (const lxb_char_t *) "Ⴄ．\u200D\u0721󻣋Σ", .ascii = (const lxb_char_t *) "xn--cnd.xn--4xa73o3t5ajq467a", .status = 12} /* 2240 */,
    {.source = (const lxb_char_t *) "ⴄ．\u200D\u0721󻣋σ", .ascii = (const lxb_char_t *) "xn--vkj.xn--4xa73o3t5ajq467a", .status = 12} /* 2241 */,
    {.source = (const lxb_char_t *) "򮵛\u0613.Ⴕ", .ascii = (const lxb_char_t *) "xn--1fb94204l.xn--tnd", .status = 4} /* 2242 */,
    {.source = (const lxb_char_t *) "򮵛\u0613.ⴕ", .ascii = (const lxb_char_t *) "xn--1fb94204l.xn--dlj", .status = 4} /* 2243 */,
    {.source = (const lxb_char_t *) "xn--1fb94204l.xn--dlj", .ascii = (const lxb_char_t *) "xn--1fb94204l.xn--dlj", .status = 4} /* 2244 */,
    {.source = (const lxb_char_t *) "xn--1fb94204l.xn--tnd", .ascii = (const lxb_char_t *) "xn--1fb94204l.xn--tnd", .status = 4} /* 2245 */,
    {.source = (const lxb_char_t *) "≯\u1DF3𞤥。\u200C\uA8C4󠪉\u200D", .ascii = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0ugc0116hix29k", .status = 16} /* 2246 */,
    {.source = (const lxb_char_t *) ">\u0338\u1DF3𞤥。\u200C\uA8C4󠪉\u200D", .ascii = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0ugc0116hix29k", .status = 16} /* 2247 */,
    {.source = (const lxb_char_t *) ">\u0338\u1DF3𞤃。\u200C\uA8C4󠪉\u200D", .ascii = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0ugc0116hix29k", .status = 16} /* 2248 */,
    {.source = (const lxb_char_t *) "≯\u1DF3𞤃。\u200C\uA8C4󠪉\u200D", .ascii = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0ugc0116hix29k", .status = 16} /* 2249 */,
    {.source = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0f9au6706d", .ascii = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0f9au6706d", .status = 12} /* 2250 */,
    {.source = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0ugc0116hix29k", .ascii = (const lxb_char_t *) "xn--ofg13qyr21c.xn--0ugc0116hix29k", .status = 16} /* 2251 */,
    {.source = (const lxb_char_t *) "\u200C󠄷｡򒑁", .ascii = (const lxb_char_t *) "xn--0ug.xn--w720c", .status = 8} /* 2252 */,
    {.source = (const lxb_char_t *) "\u200C󠄷。򒑁", .ascii = (const lxb_char_t *) "xn--0ug.xn--w720c", .status = 8} /* 2253 */,
    {.source = (const lxb_char_t *) ".xn--w720c", .ascii = (const lxb_char_t *) ".xn--w720c", .status = 10} /* 2254 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--w720c", .ascii = (const lxb_char_t *) "xn--0ug.xn--w720c", .status = 8} /* 2255 */,
    {.source = (const lxb_char_t *) "⒈\u0DD6焅.󗡙\u200Dꡟ", .ascii = (const lxb_char_t *) "xn--t1c337io97c.xn--1ugz184c9lw7i", .status = 8} /* 2256 */,
    {.source = (const lxb_char_t *) "1.\u0DD6焅.󗡙\u200Dꡟ", .ascii = (const lxb_char_t *) "1.xn--t1c6981c.xn--1ugz184c9lw7i", .status = 12} /* 2257 */,
    {.source = (const lxb_char_t *) "1.xn--t1c6981c.xn--4c9a21133d", .ascii = (const lxb_char_t *) "1.xn--t1c6981c.xn--4c9a21133d", .status = 8} /* 2258 */,
    {.source = (const lxb_char_t *) "1.xn--t1c6981c.xn--1ugz184c9lw7i", .ascii = (const lxb_char_t *) "1.xn--t1c6981c.xn--1ugz184c9lw7i", .status = 12} /* 2259 */,
    {.source = (const lxb_char_t *) "xn--t1c337io97c.xn--4c9a21133d", .ascii = (const lxb_char_t *) "xn--t1c337io97c.xn--4c9a21133d", .status = 4} /* 2260 */,
    {.source = (const lxb_char_t *) "xn--t1c337io97c.xn--1ugz184c9lw7i", .ascii = (const lxb_char_t *) "xn--t1c337io97c.xn--1ugz184c9lw7i", .status = 8} /* 2261 */,
    {.source = (const lxb_char_t *) "\u1DCDς≮.ς𝪦𞤕0", .ascii = (const lxb_char_t *) "xn--3xa744kvid.xn--0-xmb85727aggma", .status = 12} /* 2262 */,
    {.source = (const lxb_char_t *) "\u1DCDς<\u0338.ς𝪦𞤕0", .ascii = (const lxb_char_t *) "xn--3xa744kvid.xn--0-xmb85727aggma", .status = 12} /* 2263 */,
    {.source = (const lxb_char_t *) "\u1DCDς<\u0338.ς𝪦𞤷0", .ascii = (const lxb_char_t *) "xn--3xa744kvid.xn--0-xmb85727aggma", .status = 12} /* 2264 */,
    {.source = (const lxb_char_t *) "\u1DCDς≮.ς𝪦𞤷0", .ascii = (const lxb_char_t *) "xn--3xa744kvid.xn--0-xmb85727aggma", .status = 12} /* 2265 */,
    {.source = (const lxb_char_t *) "\u1DCDΣ≮.Σ𝪦𞤕0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2266 */,
    {.source = (const lxb_char_t *) "\u1DCDΣ<\u0338.Σ𝪦𞤕0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2267 */,
    {.source = (const lxb_char_t *) "\u1DCDσ<\u0338.σ𝪦𞤷0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2268 */,
    {.source = (const lxb_char_t *) "\u1DCDσ≮.σ𝪦𞤷0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2269 */,
    {.source = (const lxb_char_t *) "\u1DCDΣ≮.Σ𝪦𞤷0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2270 */,
    {.source = (const lxb_char_t *) "\u1DCDΣ<\u0338.Σ𝪦𞤷0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2271 */,
    {.source = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2272 */,
    {.source = (const lxb_char_t *) "xn--3xa744kvid.xn--0-xmb85727aggma", .ascii = (const lxb_char_t *) "xn--3xa744kvid.xn--0-xmb85727aggma", .status = 12} /* 2273 */,
    {.source = (const lxb_char_t *) "\u1DCDσ≮.σ𝪦𞤕0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2274 */,
    {.source = (const lxb_char_t *) "\u1DCDσ<\u0338.σ𝪦𞤕0", .ascii = (const lxb_char_t *) "xn--4xa544kvid.xn--0-zmb55727aggma", .status = 12} /* 2275 */,
    {.source = (const lxb_char_t *) "򢦾ß\u05B9𐫙.\u05AD\u08A1", .ascii = (const lxb_char_t *) "xn--zca89v339zj118e.xn--4cb62m", .status = 20} /* 2276 */,
    {.source = (const lxb_char_t *) "򢦾SS\u05B9𐫙.\u05AD\u08A1", .ascii = (const lxb_char_t *) "xn--ss-xjd6058xlz50g.xn--4cb62m", .status = 20} /* 2277 */,
    {.source = (const lxb_char_t *) "򢦾ss\u05B9𐫙.\u05AD\u08A1", .ascii = (const lxb_char_t *) "xn--ss-xjd6058xlz50g.xn--4cb62m", .status = 20} /* 2278 */,
    {.source = (const lxb_char_t *) "򢦾Ss\u05B9𐫙.\u05AD\u08A1", .ascii = (const lxb_char_t *) "xn--ss-xjd6058xlz50g.xn--4cb62m", .status = 20} /* 2279 */,
    {.source = (const lxb_char_t *) "xn--ss-xjd6058xlz50g.xn--4cb62m", .ascii = (const lxb_char_t *) "xn--ss-xjd6058xlz50g.xn--4cb62m", .status = 20} /* 2280 */,
    {.source = (const lxb_char_t *) "xn--zca89v339zj118e.xn--4cb62m", .ascii = (const lxb_char_t *) "xn--zca89v339zj118e.xn--4cb62m", .status = 20} /* 2281 */,
    {.source = (const lxb_char_t *) "-𞣄｡⒈", .ascii = (const lxb_char_t *) "xn----xc8r.xn--tsh", .status = 12} /* 2282 */,
    {.source = (const lxb_char_t *) "-𞣄。1.", .ascii = (const lxb_char_t *) "xn----xc8r.1.", .status = 8} /* 2283 */,
    {.source = (const lxb_char_t *) "xn----xc8r.1.", .ascii = (const lxb_char_t *) "xn----xc8r.1.", .status = 8} /* 2284 */,
    {.source = (const lxb_char_t *) "xn----xc8r.xn--tsh", .ascii = (const lxb_char_t *) "xn----xc8r.xn--tsh", .status = 12} /* 2285 */,
    {.source = (const lxb_char_t *) "񈠢𐫖𝟡。\u063E𑘿", .ascii = (const lxb_char_t *) "xn--9-el5iv442t.xn--9gb0830l", .status = 8} /* 2286 */,
    {.source = (const lxb_char_t *) "񈠢𐫖9。\u063E𑘿", .ascii = (const lxb_char_t *) "xn--9-el5iv442t.xn--9gb0830l", .status = 8} /* 2287 */,
    {.source = (const lxb_char_t *) "xn--9-el5iv442t.xn--9gb0830l", .ascii = (const lxb_char_t *) "xn--9-el5iv442t.xn--9gb0830l", .status = 8} /* 2288 */,
    {.source = (const lxb_char_t *) "\u0668\uFC8C\u0668\u1A5D.\u200D", .ascii = (const lxb_char_t *) "xn--hhbb5hc956w.xn--1ug", .status = 8} /* 2289 */,
    {.source = (const lxb_char_t *) "\u0668\u0646\u0645\u0668\u1A5D.\u200D", .ascii = (const lxb_char_t *) "xn--hhbb5hc956w.xn--1ug", .status = 8} /* 2290 */,
    {.source = (const lxb_char_t *) "xn--hhbb5hc956w.", .ascii = (const lxb_char_t *) "xn--hhbb5hc956w.", .status = 4} /* 2291 */,
    {.source = (const lxb_char_t *) "xn--hhbb5hc956w.xn--1ug", .ascii = (const lxb_char_t *) "xn--hhbb5hc956w.xn--1ug", .status = 8} /* 2292 */,
    {.source = (const lxb_char_t *) "𝟘．Ⴇ󀳑\uFD50񫃱", .ascii = (const lxb_char_t *) "0.xn--pgbe9e344c2725svff8b", .status = 12} /* 2293 */,
    {.source = (const lxb_char_t *) "0.Ⴇ󀳑\u062A\u062C\u0645񫃱", .ascii = (const lxb_char_t *) "0.xn--pgbe9e344c2725svff8b", .status = 12} /* 2294 */,
    {.source = (const lxb_char_t *) "0.ⴇ󀳑\u062A\u062C\u0645񫃱", .ascii = (const lxb_char_t *) "0.xn--pgbe9ez79qd207lvff8b", .status = 12} /* 2295 */,
    {.source = (const lxb_char_t *) "0.xn--pgbe9ez79qd207lvff8b", .ascii = (const lxb_char_t *) "0.xn--pgbe9ez79qd207lvff8b", .status = 12} /* 2296 */,
    {.source = (const lxb_char_t *) "0.xn--pgbe9e344c2725svff8b", .ascii = (const lxb_char_t *) "0.xn--pgbe9e344c2725svff8b", .status = 12} /* 2297 */,
    {.source = (const lxb_char_t *) "𝟘．ⴇ󀳑\uFD50񫃱", .ascii = (const lxb_char_t *) "0.xn--pgbe9ez79qd207lvff8b", .status = 12} /* 2298 */,
    {.source = (const lxb_char_t *) "𑇀▍.⁞ᠰ", .ascii = (const lxb_char_t *) "xn--9zh3057f.xn--j7e103b", .status = 4} /* 2299 */,
    {.source = (const lxb_char_t *) "xn--9zh3057f.xn--j7e103b", .ascii = (const lxb_char_t *) "xn--9zh3057f.xn--j7e103b", .status = 4} /* 2300 */,
    {.source = (const lxb_char_t *) "\u200D-\u067A.򏯩", .ascii = (const lxb_char_t *) "xn----qrc357q.xn--ts49b", .status = 12} /* 2301 */,
    {.source = (const lxb_char_t *) "xn----qrc.xn--ts49b", .ascii = (const lxb_char_t *) "xn----qrc.xn--ts49b", .status = 12} /* 2302 */,
    {.source = (const lxb_char_t *) "xn----qrc357q.xn--ts49b", .ascii = (const lxb_char_t *) "xn----qrc357q.xn--ts49b", .status = 12} /* 2303 */,
    {.source = (const lxb_char_t *) "ᠢ𐮂𐫘寐｡\u200C≯✳", .ascii = (const lxb_char_t *) "xn--46e6675axzzhota.xn--0ug06gu8f", .status = 12} /* 2304 */,
    {.source = (const lxb_char_t *) "ᠢ𐮂𐫘寐｡\u200C>\u0338✳", .ascii = (const lxb_char_t *) "xn--46e6675axzzhota.xn--0ug06gu8f", .status = 12} /* 2305 */,
    {.source = (const lxb_char_t *) "ᠢ𐮂𐫘寐。\u200C≯✳", .ascii = (const lxb_char_t *) "xn--46e6675axzzhota.xn--0ug06gu8f", .status = 12} /* 2306 */,
    {.source = (const lxb_char_t *) "ᠢ𐮂𐫘寐。\u200C>\u0338✳", .ascii = (const lxb_char_t *) "xn--46e6675axzzhota.xn--0ug06gu8f", .status = 12} /* 2307 */,
    {.source = (const lxb_char_t *) "xn--46e6675axzzhota.xn--hdh99p", .ascii = (const lxb_char_t *) "xn--46e6675axzzhota.xn--hdh99p", .status = 8} /* 2308 */,
    {.source = (const lxb_char_t *) "xn--46e6675axzzhota.xn--0ug06gu8f", .ascii = (const lxb_char_t *) "xn--46e6675axzzhota.xn--0ug06gu8f", .status = 12} /* 2309 */,
    {.source = (const lxb_char_t *) "\u200D｡󸲜ႺႴ𞨇", .ascii = (const lxb_char_t *) "xn--1ug.xn--sndl01647an3h1h", .status = 20} /* 2310 */,
    {.source = (const lxb_char_t *) "\u200D。󸲜ႺႴ𞨇", .ascii = (const lxb_char_t *) "xn--1ug.xn--sndl01647an3h1h", .status = 20} /* 2311 */,
    {.source = (const lxb_char_t *) "\u200D。󸲜ⴚⴔ𞨇", .ascii = (const lxb_char_t *) "xn--1ug.xn--cljl81825an3r4h", .status = 20} /* 2312 */,
    {.source = (const lxb_char_t *) "\u200D。󸲜Ⴚⴔ𞨇", .ascii = (const lxb_char_t *) "xn--1ug.xn--ynd036lq981an3r4h", .status = 20} /* 2313 */,
    {.source = (const lxb_char_t *) ".xn--ynd036lq981an3r4h", .ascii = (const lxb_char_t *) ".xn--ynd036lq981an3r4h", .status = 18} /* 2314 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--ynd036lq981an3r4h", .ascii = (const lxb_char_t *) "xn--1ug.xn--ynd036lq981an3r4h", .status = 20} /* 2315 */,
    {.source = (const lxb_char_t *) ".xn--cljl81825an3r4h", .ascii = (const lxb_char_t *) ".xn--cljl81825an3r4h", .status = 18} /* 2316 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--cljl81825an3r4h", .ascii = (const lxb_char_t *) "xn--1ug.xn--cljl81825an3r4h", .status = 20} /* 2317 */,
    {.source = (const lxb_char_t *) ".xn--sndl01647an3h1h", .ascii = (const lxb_char_t *) ".xn--sndl01647an3h1h", .status = 18} /* 2318 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--sndl01647an3h1h", .ascii = (const lxb_char_t *) "xn--1ug.xn--sndl01647an3h1h", .status = 20} /* 2319 */,
    {.source = (const lxb_char_t *) "\u200D｡󸲜ⴚⴔ𞨇", .ascii = (const lxb_char_t *) "xn--1ug.xn--cljl81825an3r4h", .status = 20} /* 2320 */,
    {.source = (const lxb_char_t *) "\u200D｡󸲜Ⴚⴔ𞨇", .ascii = (const lxb_char_t *) "xn--1ug.xn--ynd036lq981an3r4h", .status = 20} /* 2321 */,
    {.source = (const lxb_char_t *) "-3.\u200Dヌᢕ", .ascii = (const lxb_char_t *) "-3.xn--fbf739aq5o", .status = 8} /* 2322 */,
    {.source = (const lxb_char_t *) "-3.xn--fbf115j", .ascii = (const lxb_char_t *) "-3.xn--fbf115j", .status = 4} /* 2323 */,
    {.source = (const lxb_char_t *) "-3.xn--fbf739aq5o", .ascii = (const lxb_char_t *) "-3.xn--fbf739aq5o", .status = 8} /* 2324 */,
    {.source = (const lxb_char_t *) "🂃\u0666ß\u200D。󠠂򭰍𞩒-", .ascii = (const lxb_char_t *) "xn--zca34z68yzu83b.xn----nz8rh7531csznt", .status = 16} /* 2325 */,
    {.source = (const lxb_char_t *) "🂃\u0666SS\u200D。󠠂򭰍𞩒-", .ascii = (const lxb_char_t *) "xn--ss-pyd483x5k99b.xn----nz8rh7531csznt", .status = 16} /* 2326 */,
    {.source = (const lxb_char_t *) "🂃\u0666ss\u200D。󠠂򭰍𞩒-", .ascii = (const lxb_char_t *) "xn--ss-pyd483x5k99b.xn----nz8rh7531csznt", .status = 16} /* 2327 */,
    {.source = (const lxb_char_t *) "xn--ss-pyd98921c.xn----nz8rh7531csznt", .ascii = (const lxb_char_t *) "xn--ss-pyd98921c.xn----nz8rh7531csznt", .status = 12} /* 2328 */,
    {.source = (const lxb_char_t *) "xn--ss-pyd483x5k99b.xn----nz8rh7531csznt", .ascii = (const lxb_char_t *) "xn--ss-pyd483x5k99b.xn----nz8rh7531csznt", .status = 16} /* 2329 */,
    {.source = (const lxb_char_t *) "xn--zca34z68yzu83b.xn----nz8rh7531csznt", .ascii = (const lxb_char_t *) "xn--zca34z68yzu83b.xn----nz8rh7531csznt", .status = 16} /* 2330 */,
    {.source = (const lxb_char_t *) "🂃\u0666Ss\u200D。󠠂򭰍𞩒-", .ascii = (const lxb_char_t *) "xn--ss-pyd483x5k99b.xn----nz8rh7531csznt", .status = 16} /* 2331 */,
    {.source = (const lxb_char_t *) "ꇟ-𐾺\u069F。򰀺\u200C", .ascii = (const lxb_char_t *) "xn----utc4430jd3zd.xn--0ugx6670i", .status = 16} /* 2332 */,
    {.source = (const lxb_char_t *) "xn----utc4430jd3zd.xn--bp20d", .ascii = (const lxb_char_t *) "xn----utc4430jd3zd.xn--bp20d", .status = 12} /* 2333 */,
    {.source = (const lxb_char_t *) "xn----utc4430jd3zd.xn--0ugx6670i", .ascii = (const lxb_char_t *) "xn----utc4430jd3zd.xn--0ugx6670i", .status = 16} /* 2334 */,
    {.source = (const lxb_char_t *) "\u0665.\u0484𐨗𝩋𴤃", .ascii = (const lxb_char_t *) "xn--eib.xn--n3a0405kus8eft5l", .status = 12} /* 2335 */,
    {.source = (const lxb_char_t *) "xn--eib.xn--n3a0405kus8eft5l", .ascii = (const lxb_char_t *) "xn--eib.xn--n3a0405kus8eft5l", .status = 12} /* 2336 */,
    {.source = (const lxb_char_t *) "-.񱼓\u0649𐨿", .ascii = (const lxb_char_t *) "-.xn--lhb4124khbq4b", .status = 20} /* 2337 */,
    {.source = (const lxb_char_t *) "-.xn--lhb4124khbq4b", .ascii = (const lxb_char_t *) "-.xn--lhb4124khbq4b", .status = 20} /* 2338 */,
    {.source = (const lxb_char_t *) "󾬨ς.𞶙녫ß", .ascii = (const lxb_char_t *) "xn--3xa96659r.xn--zca5051g4h4i", .status = 12} /* 2339 */,
    {.source = (const lxb_char_t *) "󾬨ς.𞶙녫ß", .ascii = (const lxb_char_t *) "xn--3xa96659r.xn--zca5051g4h4i", .status = 12} /* 2340 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫SS", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2341 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫SS", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2342 */,
    {.source = (const lxb_char_t *) "󾬨σ.𞶙녫ss", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2343 */,
    {.source = (const lxb_char_t *) "󾬨σ.𞶙녫ss", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2344 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫ss", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2345 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫ss", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2346 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫Ss", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2347 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫Ss", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2348 */,
    {.source = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--ss-d64i8755h", .status = 12} /* 2349 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫ß", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--zca5051g4h4i", .status = 12} /* 2350 */,
    {.source = (const lxb_char_t *) "󾬨Σ.𞶙녫ß", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--zca5051g4h4i", .status = 12} /* 2351 */,
    {.source = (const lxb_char_t *) "󾬨σ.𞶙녫ß", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--zca5051g4h4i", .status = 12} /* 2352 */,
    {.source = (const lxb_char_t *) "󾬨σ.𞶙녫ß", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--zca5051g4h4i", .status = 12} /* 2353 */,
    {.source = (const lxb_char_t *) "xn--4xa76659r.xn--zca5051g4h4i", .ascii = (const lxb_char_t *) "xn--4xa76659r.xn--zca5051g4h4i", .status = 12} /* 2354 */,
    {.source = (const lxb_char_t *) "xn--3xa96659r.xn--zca5051g4h4i", .ascii = (const lxb_char_t *) "xn--3xa96659r.xn--zca5051g4h4i", .status = 12} /* 2355 */,
    {.source = (const lxb_char_t *) "Ⅎ\u17D2\u200D｡≠\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bcza.xn--0ugb89o", .status = 12} /* 2356 */,
    {.source = (const lxb_char_t *) "Ⅎ\u17D2\u200D｡=\u0338\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bcza.xn--0ugb89o", .status = 12} /* 2357 */,
    {.source = (const lxb_char_t *) "Ⅎ\u17D2\u200D。≠\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bcza.xn--0ugb89o", .status = 12} /* 2358 */,
    {.source = (const lxb_char_t *) "Ⅎ\u17D2\u200D。=\u0338\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bcza.xn--0ugb89o", .status = 12} /* 2359 */,
    {.source = (const lxb_char_t *) "ⅎ\u17D2\u200D。=\u0338\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bq1a.xn--0ugb89o", .status = 8} /* 2360 */,
    {.source = (const lxb_char_t *) "ⅎ\u17D2\u200D。≠\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bq1a.xn--0ugb89o", .status = 8} /* 2361 */,
    {.source = (const lxb_char_t *) "xn--u4e969b.xn--1ch", .ascii = (const lxb_char_t *) "xn--u4e969b.xn--1ch", .status = 0} /* 2362 */,
    {.source = (const lxb_char_t *) "ⅎ\u17D2.≠", .ascii = (const lxb_char_t *) "xn--u4e969b.xn--1ch", .status = 0} /* 2363 */,
    {.source = (const lxb_char_t *) "ⅎ\u17D2.=\u0338", .ascii = (const lxb_char_t *) "xn--u4e969b.xn--1ch", .status = 0} /* 2364 */,
    {.source = (const lxb_char_t *) "Ⅎ\u17D2.=\u0338", .ascii = (const lxb_char_t *) "xn--u4e319b.xn--1ch", .status = 4} /* 2365 */,
    {.source = (const lxb_char_t *) "Ⅎ\u17D2.≠", .ascii = (const lxb_char_t *) "xn--u4e319b.xn--1ch", .status = 4} /* 2366 */,
    {.source = (const lxb_char_t *) "xn--u4e319b.xn--1ch", .ascii = (const lxb_char_t *) "xn--u4e319b.xn--1ch", .status = 4} /* 2367 */,
    {.source = (const lxb_char_t *) "xn--u4e823bq1a.xn--0ugb89o", .ascii = (const lxb_char_t *) "xn--u4e823bq1a.xn--0ugb89o", .status = 8} /* 2368 */,
    {.source = (const lxb_char_t *) "xn--u4e823bcza.xn--0ugb89o", .ascii = (const lxb_char_t *) "xn--u4e823bcza.xn--0ugb89o", .status = 12} /* 2369 */,
    {.source = (const lxb_char_t *) "ⅎ\u17D2\u200D｡=\u0338\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bq1a.xn--0ugb89o", .status = 8} /* 2370 */,
    {.source = (const lxb_char_t *) "ⅎ\u17D2\u200D｡≠\u200D\u200C", .ascii = (const lxb_char_t *) "xn--u4e823bq1a.xn--0ugb89o", .status = 8} /* 2371 */,
    {.source = (const lxb_char_t *) "𐋺\uAAF6\uA953󧦉．\u200C\u1714\u068F", .ascii = (const lxb_char_t *) "xn--3j9a14ak27osbz2o.xn--ljb175f1wg", .status = 12} /* 2372 */,
    {.source = (const lxb_char_t *) "𐋺\uAAF6\uA953󧦉.\u200C\u1714\u068F", .ascii = (const lxb_char_t *) "xn--3j9a14ak27osbz2o.xn--ljb175f1wg", .status = 12} /* 2373 */,
    {.source = (const lxb_char_t *) "xn--3j9a14ak27osbz2o.xn--ljb175f", .ascii = (const lxb_char_t *) "xn--3j9a14ak27osbz2o.xn--ljb175f", .status = 12} /* 2374 */,
    {.source = (const lxb_char_t *) "xn--3j9a14ak27osbz2o.xn--ljb175f1wg", .ascii = (const lxb_char_t *) "xn--3j9a14ak27osbz2o.xn--ljb175f1wg", .status = 12} /* 2375 */,
    {.source = (const lxb_char_t *) "񺔯\u0FA8．≯", .ascii = (const lxb_char_t *) "xn--4fd57150h.xn--hdh", .status = 4} /* 2376 */,
    {.source = (const lxb_char_t *) "񺔯\u0FA8．>\u0338", .ascii = (const lxb_char_t *) "xn--4fd57150h.xn--hdh", .status = 4} /* 2377 */,
    {.source = (const lxb_char_t *) "񺔯\u0FA8.≯", .ascii = (const lxb_char_t *) "xn--4fd57150h.xn--hdh", .status = 4} /* 2378 */,
    {.source = (const lxb_char_t *) "񺔯\u0FA8.>\u0338", .ascii = (const lxb_char_t *) "xn--4fd57150h.xn--hdh", .status = 4} /* 2379 */,
    {.source = (const lxb_char_t *) "xn--4fd57150h.xn--hdh", .ascii = (const lxb_char_t *) "xn--4fd57150h.xn--hdh", .status = 4} /* 2380 */,
    {.source = (const lxb_char_t *) "\u200D𞡄Ⴓ．𐇽", .ascii = (const lxb_char_t *) "xn--rnd379ex885a.xn--m27c", .status = 16} /* 2381 */,
    {.source = (const lxb_char_t *) "\u200D𞡄Ⴓ.𐇽", .ascii = (const lxb_char_t *) "xn--rnd379ex885a.xn--m27c", .status = 16} /* 2382 */,
    {.source = (const lxb_char_t *) "\u200D𞡄ⴓ.𐇽", .ascii = (const lxb_char_t *) "xn--1ugz52c4i16a.xn--m27c", .status = 12} /* 2383 */,
    {.source = (const lxb_char_t *) "xn--blj7492l.xn--m27c", .ascii = (const lxb_char_t *) "xn--blj7492l.xn--m27c", .status = 16} /* 2384 */,
    {.source = (const lxb_char_t *) "xn--1ugz52c4i16a.xn--m27c", .ascii = (const lxb_char_t *) "xn--1ugz52c4i16a.xn--m27c", .status = 12} /* 2385 */,
    {.source = (const lxb_char_t *) "xn--rnd5552v.xn--m27c", .ascii = (const lxb_char_t *) "xn--rnd5552v.xn--m27c", .status = 20} /* 2386 */,
    {.source = (const lxb_char_t *) "xn--rnd379ex885a.xn--m27c", .ascii = (const lxb_char_t *) "xn--rnd379ex885a.xn--m27c", .status = 16} /* 2387 */,
    {.source = (const lxb_char_t *) "\u200D𞡄ⴓ．𐇽", .ascii = (const lxb_char_t *) "xn--1ugz52c4i16a.xn--m27c", .status = 12} /* 2388 */,
    {.source = (const lxb_char_t *) "𐪒ß\uA8EA．ᡤ", .ascii = (const lxb_char_t *) "xn--zca2517f2hvc.xn--08e", .status = 8} /* 2389 */,
    {.source = (const lxb_char_t *) "𐪒ß\uA8EA.ᡤ", .ascii = (const lxb_char_t *) "xn--zca2517f2hvc.xn--08e", .status = 8} /* 2390 */,
    {.source = (const lxb_char_t *) "𐪒SS\uA8EA.ᡤ", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2391 */,
    {.source = (const lxb_char_t *) "𐪒ss\uA8EA.ᡤ", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2392 */,
    {.source = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2393 */,
    {.source = (const lxb_char_t *) "xn--zca2517f2hvc.xn--08e", .ascii = (const lxb_char_t *) "xn--zca2517f2hvc.xn--08e", .status = 8} /* 2394 */,
    {.source = (const lxb_char_t *) "𐪒SS\uA8EA．ᡤ", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2395 */,
    {.source = (const lxb_char_t *) "𐪒ss\uA8EA．ᡤ", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2396 */,
    {.source = (const lxb_char_t *) "𐪒Ss\uA8EA.ᡤ", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2397 */,
    {.source = (const lxb_char_t *) "𐪒Ss\uA8EA．ᡤ", .ascii = (const lxb_char_t *) "xn--ss-tu9hw933a.xn--08e", .status = 8} /* 2398 */,
    {.source = (const lxb_char_t *) "𐨿󠆌鸮𑚶.ς", .ascii = (const lxb_char_t *) "xn--l76a726rt2h.xn--3xa", .status = 4} /* 2399 */,
    {.source = (const lxb_char_t *) "𐨿󠆌鸮𑚶.Σ", .ascii = (const lxb_char_t *) "xn--l76a726rt2h.xn--4xa", .status = 4} /* 2400 */,
    {.source = (const lxb_char_t *) "𐨿󠆌鸮𑚶.σ", .ascii = (const lxb_char_t *) "xn--l76a726rt2h.xn--4xa", .status = 4} /* 2401 */,
    {.source = (const lxb_char_t *) "xn--l76a726rt2h.xn--4xa", .ascii = (const lxb_char_t *) "xn--l76a726rt2h.xn--4xa", .status = 4} /* 2402 */,
    {.source = (const lxb_char_t *) "xn--l76a726rt2h.xn--3xa", .ascii = (const lxb_char_t *) "xn--l76a726rt2h.xn--3xa", .status = 4} /* 2403 */,
    {.source = (const lxb_char_t *) "⒗𞤬。-𑚶", .ascii = (const lxb_char_t *) "xn--8shw466n.xn----4j0j", .status = 12} /* 2404 */,
    {.source = (const lxb_char_t *) "16.𞤬。-𑚶", .ascii = (const lxb_char_t *) "16.xn--ke6h.xn----4j0j", .status = 8} /* 2405 */,
    {.source = (const lxb_char_t *) "16.𞤊。-𑚶", .ascii = (const lxb_char_t *) "16.xn--ke6h.xn----4j0j", .status = 8} /* 2406 */,
    {.source = (const lxb_char_t *) "16.xn--ke6h.xn----4j0j", .ascii = (const lxb_char_t *) "16.xn--ke6h.xn----4j0j", .status = 8} /* 2407 */,
    {.source = (const lxb_char_t *) "⒗𞤊。-𑚶", .ascii = (const lxb_char_t *) "xn--8shw466n.xn----4j0j", .status = 12} /* 2408 */,
    {.source = (const lxb_char_t *) "xn--8shw466n.xn----4j0j", .ascii = (const lxb_char_t *) "xn--8shw466n.xn----4j0j", .status = 12} /* 2409 */,
    {.source = (const lxb_char_t *) "\u08B3𞤿⾫｡𐹣\u068F⒈", .ascii = (const lxb_char_t *) "xn--8yb0383efiwk.xn--ljb064mol4n", .status = 16} /* 2410 */,
    {.source = (const lxb_char_t *) "\u08B3𞤿隹。𐹣\u068F1.", .ascii = (const lxb_char_t *) "xn--8yb0383efiwk.xn--1-wsc3373r.", .status = 12} /* 2411 */,
    {.source = (const lxb_char_t *) "\u08B3𞤝隹。𐹣\u068F1.", .ascii = (const lxb_char_t *) "xn--8yb0383efiwk.xn--1-wsc3373r.", .status = 12} /* 2412 */,
    {.source = (const lxb_char_t *) "xn--8yb0383efiwk.xn--1-wsc3373r.", .ascii = (const lxb_char_t *) "xn--8yb0383efiwk.xn--1-wsc3373r.", .status = 12} /* 2413 */,
    {.source = (const lxb_char_t *) "\u08B3𞤝⾫｡𐹣\u068F⒈", .ascii = (const lxb_char_t *) "xn--8yb0383efiwk.xn--ljb064mol4n", .status = 16} /* 2414 */,
    {.source = (const lxb_char_t *) "xn--8yb0383efiwk.xn--ljb064mol4n", .ascii = (const lxb_char_t *) "xn--8yb0383efiwk.xn--ljb064mol4n", .status = 16} /* 2415 */,
    {.source = (const lxb_char_t *) "\u2433𚎛𝟧\u0661.ᡢ8\u0F72\u0600", .ascii = (const lxb_char_t *) "xn--5-bqc410un435a.xn--8-rkc763epjj", .status = 12} /* 2416 */,
    {.source = (const lxb_char_t *) "\u2433𚎛5\u0661.ᡢ8\u0F72\u0600", .ascii = (const lxb_char_t *) "xn--5-bqc410un435a.xn--8-rkc763epjj", .status = 12} /* 2417 */,
    {.source = (const lxb_char_t *) "xn--5-bqc410un435a.xn--8-rkc763epjj", .ascii = (const lxb_char_t *) "xn--5-bqc410un435a.xn--8-rkc763epjj", .status = 12} /* 2418 */,
    {.source = (const lxb_char_t *) "𐹠.🄀⒒-󨰈", .ascii = (const lxb_char_t *) "xn--7n0d.xn----xcp9757q1s13g", .status = 8} /* 2419 */,
    {.source = (const lxb_char_t *) "𐹠.0.11.-󨰈", .ascii = (const lxb_char_t *) "xn--7n0d.0.11.xn----8j07m", .status = 12} /* 2420 */,
    {.source = (const lxb_char_t *) "xn--7n0d.0.11.xn----8j07m", .ascii = (const lxb_char_t *) "xn--7n0d.0.11.xn----8j07m", .status = 12} /* 2421 */,
    {.source = (const lxb_char_t *) "xn--7n0d.xn----xcp9757q1s13g", .ascii = (const lxb_char_t *) "xn--7n0d.xn----xcp9757q1s13g", .status = 8} /* 2422 */,
    {.source = (const lxb_char_t *) "ς-。\u200C𝟭-", .ascii = (const lxb_char_t *) "xn----xmb.xn--1--i1t", .status = 8} /* 2423 */,
    {.source = (const lxb_char_t *) "ς-。\u200C1-", .ascii = (const lxb_char_t *) "xn----xmb.xn--1--i1t", .status = 8} /* 2424 */,
    {.source = (const lxb_char_t *) "Σ-。\u200C1-", .ascii = (const lxb_char_t *) "xn----zmb.xn--1--i1t", .status = 8} /* 2425 */,
    {.source = (const lxb_char_t *) "σ-。\u200C1-", .ascii = (const lxb_char_t *) "xn----zmb.xn--1--i1t", .status = 8} /* 2426 */,
    {.source = (const lxb_char_t *) "xn----zmb.1-", .ascii = (const lxb_char_t *) "xn----zmb.1-", .status = 4} /* 2427 */,
    {.source = (const lxb_char_t *) "xn----zmb.xn--1--i1t", .ascii = (const lxb_char_t *) "xn----zmb.xn--1--i1t", .status = 8} /* 2428 */,
    {.source = (const lxb_char_t *) "xn----xmb.xn--1--i1t", .ascii = (const lxb_char_t *) "xn----xmb.xn--1--i1t", .status = 8} /* 2429 */,
    {.source = (const lxb_char_t *) "Σ-。\u200C𝟭-", .ascii = (const lxb_char_t *) "xn----zmb.xn--1--i1t", .status = 8} /* 2430 */,
    {.source = (const lxb_char_t *) "σ-。\u200C𝟭-", .ascii = (const lxb_char_t *) "xn----zmb.xn--1--i1t", .status = 8} /* 2431 */,
    {.source = (const lxb_char_t *) "\u1734-\u0CE2．󠄩Ⴄ", .ascii = (const lxb_char_t *) "xn----ggf830f.xn--cnd", .status = 8} /* 2432 */,
    {.source = (const lxb_char_t *) "\u1734-\u0CE2.󠄩Ⴄ", .ascii = (const lxb_char_t *) "xn----ggf830f.xn--cnd", .status = 8} /* 2433 */,
    {.source = (const lxb_char_t *) "\u1734-\u0CE2.󠄩ⴄ", .ascii = (const lxb_char_t *) "xn----ggf830f.xn--vkj", .status = 4} /* 2434 */,
    {.source = (const lxb_char_t *) "xn----ggf830f.xn--vkj", .ascii = (const lxb_char_t *) "xn----ggf830f.xn--vkj", .status = 4} /* 2435 */,
    {.source = (const lxb_char_t *) "xn----ggf830f.xn--cnd", .ascii = (const lxb_char_t *) "xn----ggf830f.xn--cnd", .status = 8} /* 2436 */,
    {.source = (const lxb_char_t *) "\u1734-\u0CE2．󠄩ⴄ", .ascii = (const lxb_char_t *) "xn----ggf830f.xn--vkj", .status = 4} /* 2437 */,
    {.source = (const lxb_char_t *) "򭈗♋\u06BB𐦥｡\u0954⒈", .ascii = (const lxb_char_t *) "xn--ukb372n129m3rs7f.xn--u3b240l", .status = 20} /* 2438 */,
    {.source = (const lxb_char_t *) "򭈗♋\u06BB𐦥。\u09541.", .ascii = (const lxb_char_t *) "xn--ukb372n129m3rs7f.xn--1-fyd.", .status = 20} /* 2439 */,
    {.source = (const lxb_char_t *) "xn--ukb372n129m3rs7f.xn--1-fyd.", .ascii = (const lxb_char_t *) "xn--ukb372n129m3rs7f.xn--1-fyd.", .status = 20} /* 2440 */,
    {.source = (const lxb_char_t *) "xn--ukb372n129m3rs7f.xn--u3b240l", .ascii = (const lxb_char_t *) "xn--ukb372n129m3rs7f.xn--u3b240l", .status = 20} /* 2441 */,
    {.source = (const lxb_char_t *) "\u05A4．\u06C1\u1AB3\u200C", .ascii = (const lxb_char_t *) "xn--vcb.xn--0kb623hm1d", .status = 16} /* 2442 */,
    {.source = (const lxb_char_t *) "\u05A4.\u06C1\u1AB3\u200C", .ascii = (const lxb_char_t *) "xn--vcb.xn--0kb623hm1d", .status = 16} /* 2443 */,
    {.source = (const lxb_char_t *) "xn--vcb.xn--0kb623h", .ascii = (const lxb_char_t *) "xn--vcb.xn--0kb623h", .status = 8} /* 2444 */,
    {.source = (const lxb_char_t *) "xn--vcb.xn--0kb623hm1d", .ascii = (const lxb_char_t *) "xn--vcb.xn--0kb623hm1d", .status = 16} /* 2445 */,
    {.source = (const lxb_char_t *) "񢭏\u0846≮\u0ACD．𞦊", .ascii = (const lxb_char_t *) "xn--4vb80kq29ayo62l.xn--8g6h", .status = 12} /* 2446 */,
    {.source = (const lxb_char_t *) "񢭏\u0846<\u0338\u0ACD．𞦊", .ascii = (const lxb_char_t *) "xn--4vb80kq29ayo62l.xn--8g6h", .status = 12} /* 2447 */,
    {.source = (const lxb_char_t *) "񢭏\u0846≮\u0ACD.𞦊", .ascii = (const lxb_char_t *) "xn--4vb80kq29ayo62l.xn--8g6h", .status = 12} /* 2448 */,
    {.source = (const lxb_char_t *) "񢭏\u0846<\u0338\u0ACD.𞦊", .ascii = (const lxb_char_t *) "xn--4vb80kq29ayo62l.xn--8g6h", .status = 12} /* 2449 */,
    {.source = (const lxb_char_t *) "xn--4vb80kq29ayo62l.xn--8g6h", .ascii = (const lxb_char_t *) "xn--4vb80kq29ayo62l.xn--8g6h", .status = 12} /* 2450 */,
    {.source = (const lxb_char_t *) "\u200D。𞀘⒈ꡍ擉", .ascii = (const lxb_char_t *) "xn--1ug.xn--tsh026uql4bew9p", .status = 12} /* 2451 */,
    {.source = (const lxb_char_t *) "\u200D。𞀘1.ꡍ擉", .ascii = (const lxb_char_t *) "xn--1ug.xn--1-1p4r.xn--s7uv61m", .status = 8} /* 2452 */,
    {.source = (const lxb_char_t *) ".xn--1-1p4r.xn--s7uv61m", .ascii = (const lxb_char_t *) ".xn--1-1p4r.xn--s7uv61m", .status = 10} /* 2453 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--1-1p4r.xn--s7uv61m", .ascii = (const lxb_char_t *) "xn--1ug.xn--1-1p4r.xn--s7uv61m", .status = 8} /* 2454 */,
    {.source = (const lxb_char_t *) ".xn--tsh026uql4bew9p", .ascii = (const lxb_char_t *) ".xn--tsh026uql4bew9p", .status = 14} /* 2455 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--tsh026uql4bew9p", .ascii = (const lxb_char_t *) "xn--1ug.xn--tsh026uql4bew9p", .status = 12} /* 2456 */,
    {.source = (const lxb_char_t *) "₈\u07CB．\uFB64≠", .ascii = (const lxb_char_t *) "xn--8-zbd.xn--4ib883l", .status = 8} /* 2457 */,
    {.source = (const lxb_char_t *) "₈\u07CB．\uFB64=\u0338", .ascii = (const lxb_char_t *) "xn--8-zbd.xn--4ib883l", .status = 8} /* 2458 */,
    {.source = (const lxb_char_t *) "8\u07CB.\u067F≠", .ascii = (const lxb_char_t *) "xn--8-zbd.xn--4ib883l", .status = 8} /* 2459 */,
    {.source = (const lxb_char_t *) "8\u07CB.\u067F=\u0338", .ascii = (const lxb_char_t *) "xn--8-zbd.xn--4ib883l", .status = 8} /* 2460 */,
    {.source = (const lxb_char_t *) "xn--8-zbd.xn--4ib883l", .ascii = (const lxb_char_t *) "xn--8-zbd.xn--4ib883l", .status = 8} /* 2461 */,
    {.source = (const lxb_char_t *) "ᢡ\u07DE򹐣.⒒\u0642𑍦", .ascii = (const lxb_char_t *) "xn--5sb596fi873t.xn--ehb336mvy7n", .status = 12} /* 2462 */,
    {.source = (const lxb_char_t *) "ᢡ\u07DE򹐣.11.\u0642𑍦", .ascii = (const lxb_char_t *) "xn--5sb596fi873t.11.xn--ehb4198k", .status = 12} /* 2463 */,
    {.source = (const lxb_char_t *) "xn--5sb596fi873t.11.xn--ehb4198k", .ascii = (const lxb_char_t *) "xn--5sb596fi873t.11.xn--ehb4198k", .status = 12} /* 2464 */,
    {.source = (const lxb_char_t *) "xn--5sb596fi873t.xn--ehb336mvy7n", .ascii = (const lxb_char_t *) "xn--5sb596fi873t.xn--ehb336mvy7n", .status = 12} /* 2465 */,
    {.source = (const lxb_char_t *) "\u0E48-𐹺𝟜.\u0363\u06E1⒏", .ascii = (const lxb_char_t *) "xn---4-owiz479s.xn--eva20pjv9a", .status = 12} /* 2466 */,
    {.source = (const lxb_char_t *) "\u0E48-𐹺4.\u0363\u06E18.", .ascii = (const lxb_char_t *) "xn---4-owiz479s.xn--8-ihb69x.", .status = 8} /* 2467 */,
    {.source = (const lxb_char_t *) "xn---4-owiz479s.xn--8-ihb69x.", .ascii = (const lxb_char_t *) "xn---4-owiz479s.xn--8-ihb69x.", .status = 8} /* 2468 */,
    {.source = (const lxb_char_t *) "xn---4-owiz479s.xn--eva20pjv9a", .ascii = (const lxb_char_t *) "xn---4-owiz479s.xn--eva20pjv9a", .status = 12} /* 2469 */,
    {.source = (const lxb_char_t *) "⫐｡Ⴠ-󃐢", .ascii = (const lxb_char_t *) "xn--r3i.xn----z1g58579u", .status = 4} /* 2470 */,
    {.source = (const lxb_char_t *) "⫐。Ⴠ-󃐢", .ascii = (const lxb_char_t *) "xn--r3i.xn----z1g58579u", .status = 4} /* 2471 */,
    {.source = (const lxb_char_t *) "⫐。ⴠ-󃐢", .ascii = (const lxb_char_t *) "xn--r3i.xn----2wst7439i", .status = 4} /* 2472 */,
    {.source = (const lxb_char_t *) "xn--r3i.xn----2wst7439i", .ascii = (const lxb_char_t *) "xn--r3i.xn----2wst7439i", .status = 4} /* 2473 */,
    {.source = (const lxb_char_t *) "xn--r3i.xn----z1g58579u", .ascii = (const lxb_char_t *) "xn--r3i.xn----z1g58579u", .status = 4} /* 2474 */,
    {.source = (const lxb_char_t *) "⫐｡ⴠ-󃐢", .ascii = (const lxb_char_t *) "xn--r3i.xn----2wst7439i", .status = 4} /* 2475 */,
    {.source = (const lxb_char_t *) "𑑂◊．⦟∠", .ascii = (const lxb_char_t *) "xn--01h3338f.xn--79g270a", .status = 4} /* 2476 */,
    {.source = (const lxb_char_t *) "𑑂◊.⦟∠", .ascii = (const lxb_char_t *) "xn--01h3338f.xn--79g270a", .status = 4} /* 2477 */,
    {.source = (const lxb_char_t *) "xn--01h3338f.xn--79g270a", .ascii = (const lxb_char_t *) "xn--01h3338f.xn--79g270a", .status = 4} /* 2478 */,
    {.source = (const lxb_char_t *) "𿌰-\u0662。󋸛ꡂ", .ascii = (const lxb_char_t *) "xn----dqc20828e.xn--bc9an2879c", .status = 12} /* 2479 */,
    {.source = (const lxb_char_t *) "xn----dqc20828e.xn--bc9an2879c", .ascii = (const lxb_char_t *) "xn----dqc20828e.xn--bc9an2879c", .status = 12} /* 2480 */,
    {.source = (const lxb_char_t *) "\u0678。󠏬\u0741𞪭𐹪", .ascii = (const lxb_char_t *) "xn--mhb8f.xn--oob2585kfdsfsbo7h", .status = 8} /* 2481 */,
    {.source = (const lxb_char_t *) "\u064A\u0674。󠏬\u0741𞪭𐹪", .ascii = (const lxb_char_t *) "xn--mhb8f.xn--oob2585kfdsfsbo7h", .status = 8} /* 2482 */,
    {.source = (const lxb_char_t *) "xn--mhb8f.xn--oob2585kfdsfsbo7h", .ascii = (const lxb_char_t *) "xn--mhb8f.xn--oob2585kfdsfsbo7h", .status = 8} /* 2483 */,
    {.source = (const lxb_char_t *) "𐫆ꌄ｡\u200Dᣬ", .ascii = (const lxb_char_t *) "xn--y77ao18q.xn--wdf367a", .status = 16} /* 2484 */,
    {.source = (const lxb_char_t *) "𐫆ꌄ。\u200Dᣬ", .ascii = (const lxb_char_t *) "xn--y77ao18q.xn--wdf367a", .status = 16} /* 2485 */,
    {.source = (const lxb_char_t *) "xn--y77ao18q.xn--wdf", .ascii = (const lxb_char_t *) "xn--y77ao18q.xn--wdf", .status = 8} /* 2486 */,
    {.source = (const lxb_char_t *) "xn--y77ao18q.xn--wdf367a", .ascii = (const lxb_char_t *) "xn--y77ao18q.xn--wdf367a", .status = 16} /* 2487 */,
    {.source = (const lxb_char_t *) "₀\u0662。󅪞≯-", .ascii = (const lxb_char_t *) "xn--0-dqc.xn----ogov3342l", .status = 16} /* 2488 */,
    {.source = (const lxb_char_t *) "₀\u0662。󅪞>\u0338-", .ascii = (const lxb_char_t *) "xn--0-dqc.xn----ogov3342l", .status = 16} /* 2489 */,
    {.source = (const lxb_char_t *) "0\u0662。󅪞≯-", .ascii = (const lxb_char_t *) "xn--0-dqc.xn----ogov3342l", .status = 16} /* 2490 */,
    {.source = (const lxb_char_t *) "0\u0662。󅪞>\u0338-", .ascii = (const lxb_char_t *) "xn--0-dqc.xn----ogov3342l", .status = 16} /* 2491 */,
    {.source = (const lxb_char_t *) "xn--0-dqc.xn----ogov3342l", .ascii = (const lxb_char_t *) "xn--0-dqc.xn----ogov3342l", .status = 16} /* 2492 */,
    {.source = (const lxb_char_t *) "\u031C𐹫-𞯃.𐋤\u0845", .ascii = (const lxb_char_t *) "xn----gdb7046r692g.xn--3vb1349j", .status = 12} /* 2493 */,
    {.source = (const lxb_char_t *) "xn----gdb7046r692g.xn--3vb1349j", .ascii = (const lxb_char_t *) "xn----gdb7046r692g.xn--3vb1349j", .status = 12} /* 2494 */,
    {.source = (const lxb_char_t *) "≠｡𝩑𐹩Ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb538c649rypog", .status = 12} /* 2495 */,
    {.source = (const lxb_char_t *) "=\u0338｡𝩑𐹩Ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb538c649rypog", .status = 12} /* 2496 */,
    {.source = (const lxb_char_t *) "≠。𝩑𐹩Ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb538c649rypog", .status = 12} /* 2497 */,
    {.source = (const lxb_char_t *) "=\u0338。𝩑𐹩Ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb538c649rypog", .status = 12} /* 2498 */,
    {.source = (const lxb_char_t *) "=\u0338。𝩑𐹩ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb363rk03mypug", .status = 8} /* 2499 */,
    {.source = (const lxb_char_t *) "≠。𝩑𐹩ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb363rk03mypug", .status = 8} /* 2500 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn--fcb363rk03mypug", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb363rk03mypug", .status = 8} /* 2501 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn--fcb538c649rypog", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb538c649rypog", .status = 12} /* 2502 */,
    {.source = (const lxb_char_t *) "=\u0338｡𝩑𐹩ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb363rk03mypug", .status = 8} /* 2503 */,
    {.source = (const lxb_char_t *) "≠｡𝩑𐹩ⴡ\u0594", .ascii = (const lxb_char_t *) "xn--1ch.xn--fcb363rk03mypug", .status = 8} /* 2504 */,
    {.source = (const lxb_char_t *) "𖫳≠.Ⴀ𐮀", .ascii = (const lxb_char_t *) "xn--1ch9250k.xn--7md2659j", .status = 20} /* 2505 */,
    {.source = (const lxb_char_t *) "𖫳=\u0338.Ⴀ𐮀", .ascii = (const lxb_char_t *) "xn--1ch9250k.xn--7md2659j", .status = 20} /* 2506 */,
    {.source = (const lxb_char_t *) "𖫳=\u0338.ⴀ𐮀", .ascii = (const lxb_char_t *) "xn--1ch9250k.xn--rkj6232e", .status = 16} /* 2507 */,
    {.source = (const lxb_char_t *) "𖫳≠.ⴀ𐮀", .ascii = (const lxb_char_t *) "xn--1ch9250k.xn--rkj6232e", .status = 16} /* 2508 */,
    {.source = (const lxb_char_t *) "xn--1ch9250k.xn--rkj6232e", .ascii = (const lxb_char_t *) "xn--1ch9250k.xn--rkj6232e", .status = 16} /* 2509 */,
    {.source = (const lxb_char_t *) "xn--1ch9250k.xn--7md2659j", .ascii = (const lxb_char_t *) "xn--1ch9250k.xn--7md2659j", .status = 20} /* 2510 */,
    {.source = (const lxb_char_t *) "󠅾\u0736\u0726．ᢚ閪\u08E2𝩟", .ascii = (const lxb_char_t *) "xn--wnb5a.xn--l0b161fis8gbp5m", .status = 20} /* 2511 */,
    {.source = (const lxb_char_t *) "󠅾\u0736\u0726.ᢚ閪\u08E2𝩟", .ascii = (const lxb_char_t *) "xn--wnb5a.xn--l0b161fis8gbp5m", .status = 20} /* 2512 */,
    {.source = (const lxb_char_t *) "xn--wnb5a.xn--l0b161fis8gbp5m", .ascii = (const lxb_char_t *) "xn--wnb5a.xn--l0b161fis8gbp5m", .status = 20} /* 2513 */,
    {.source = (const lxb_char_t *) "\u200D󠇜\u06CB\uA8E9｡\u20DD\u0FB0-ᛟ", .ascii = (const lxb_char_t *) "xn--blb540ke10h.xn----gmg236cj6k", .status = 12} /* 2514 */,
    {.source = (const lxb_char_t *) "\u200D󠇜\u06CB\uA8E9。\u20DD\u0FB0-ᛟ", .ascii = (const lxb_char_t *) "xn--blb540ke10h.xn----gmg236cj6k", .status = 12} /* 2515 */,
    {.source = (const lxb_char_t *) "xn--blb8114f.xn----gmg236cj6k", .ascii = (const lxb_char_t *) "xn--blb8114f.xn----gmg236cj6k", .status = 8} /* 2516 */,
    {.source = (const lxb_char_t *) "xn--blb540ke10h.xn----gmg236cj6k", .ascii = (const lxb_char_t *) "xn--blb540ke10h.xn----gmg236cj6k", .status = 12} /* 2517 */,
    {.source = (const lxb_char_t *) "헁󘖙\u0E3A󚍚。\u06BA𝟜", .ascii = (const lxb_char_t *) "xn--o4c1723h8g85gt4ya.xn--4-dvc", .status = 4} /* 2518 */,
    {.source = (const lxb_char_t *) "헁󘖙\u0E3A󚍚。\u06BA𝟜", .ascii = (const lxb_char_t *) "xn--o4c1723h8g85gt4ya.xn--4-dvc", .status = 4} /* 2519 */,
    {.source = (const lxb_char_t *) "헁󘖙\u0E3A󚍚。\u06BA4", .ascii = (const lxb_char_t *) "xn--o4c1723h8g85gt4ya.xn--4-dvc", .status = 4} /* 2520 */,
    {.source = (const lxb_char_t *) "헁󘖙\u0E3A󚍚。\u06BA4", .ascii = (const lxb_char_t *) "xn--o4c1723h8g85gt4ya.xn--4-dvc", .status = 4} /* 2521 */,
    {.source = (const lxb_char_t *) "xn--o4c1723h8g85gt4ya.xn--4-dvc", .ascii = (const lxb_char_t *) "xn--o4c1723h8g85gt4ya.xn--4-dvc", .status = 4} /* 2522 */,
    {.source = (const lxb_char_t *) "𐹭｡󃱂\u200CႾ", .ascii = (const lxb_char_t *) "xn--lo0d.xn--2nd949eqw95u", .status = 12} /* 2523 */,
    {.source = (const lxb_char_t *) "𐹭。󃱂\u200CႾ", .ascii = (const lxb_char_t *) "xn--lo0d.xn--2nd949eqw95u", .status = 12} /* 2524 */,
    {.source = (const lxb_char_t *) "𐹭。󃱂\u200Cⴞ", .ascii = (const lxb_char_t *) "xn--lo0d.xn--0ugx72cwi33v", .status = 12} /* 2525 */,
    {.source = (const lxb_char_t *) "xn--lo0d.xn--mljx1099g", .ascii = (const lxb_char_t *) "xn--lo0d.xn--mljx1099g", .status = 8} /* 2526 */,
    {.source = (const lxb_char_t *) "xn--lo0d.xn--0ugx72cwi33v", .ascii = (const lxb_char_t *) "xn--lo0d.xn--0ugx72cwi33v", .status = 12} /* 2527 */,
    {.source = (const lxb_char_t *) "xn--lo0d.xn--2nd75260n", .ascii = (const lxb_char_t *) "xn--lo0d.xn--2nd75260n", .status = 8} /* 2528 */,
    {.source = (const lxb_char_t *) "xn--lo0d.xn--2nd949eqw95u", .ascii = (const lxb_char_t *) "xn--lo0d.xn--2nd949eqw95u", .status = 12} /* 2529 */,
    {.source = (const lxb_char_t *) "𐹭｡󃱂\u200Cⴞ", .ascii = (const lxb_char_t *) "xn--lo0d.xn--0ugx72cwi33v", .status = 12} /* 2530 */,
    {.source = (const lxb_char_t *) "\uA953.\u033D𑂽馋", .ascii = (const lxb_char_t *) "xn--3j9a.xn--bua0708eqzrd", .status = 8} /* 2531 */,
    {.source = (const lxb_char_t *) "xn--3j9a.xn--bua0708eqzrd", .ascii = (const lxb_char_t *) "xn--3j9a.xn--bua0708eqzrd", .status = 8} /* 2532 */,
    {.source = (const lxb_char_t *) "󈫝򪛸\u200D｡䜖", .ascii = (const lxb_char_t *) "xn--1ug30527h9mxi.xn--k0o", .status = 8} /* 2533 */,
    {.source = (const lxb_char_t *) "󈫝򪛸\u200D。䜖", .ascii = (const lxb_char_t *) "xn--1ug30527h9mxi.xn--k0o", .status = 8} /* 2534 */,
    {.source = (const lxb_char_t *) "xn--g138cxw05a.xn--k0o", .ascii = (const lxb_char_t *) "xn--g138cxw05a.xn--k0o", .status = 4} /* 2535 */,
    {.source = (const lxb_char_t *) "xn--1ug30527h9mxi.xn--k0o", .ascii = (const lxb_char_t *) "xn--1ug30527h9mxi.xn--k0o", .status = 8} /* 2536 */,
    {.source = (const lxb_char_t *) "ᡯ⚉姶🄉．۷\u200D🎪\u200D", .ascii = (const lxb_char_t *) "xn--c9e433epi4b3j20a.xn--kmb859ja94998b", .status = 8} /* 2537 */,
    {.source = (const lxb_char_t *) "ᡯ⚉姶8,.۷\u200D🎪\u200D", .ascii = (const lxb_char_t *) "xn--8,-g9oy26fzu4d.xn--kmb859ja94998b", .status = 8} /* 2538 */,
    {.source = (const lxb_char_t *) "xn--8,-g9oy26fzu4d.xn--kmb6733w", .ascii = (const lxb_char_t *) "xn--8,-g9oy26fzu4d.xn--kmb6733w", .status = 4} /* 2539 */,
    {.source = (const lxb_char_t *) "xn--8,-g9oy26fzu4d.xn--kmb859ja94998b", .ascii = (const lxb_char_t *) "xn--8,-g9oy26fzu4d.xn--kmb859ja94998b", .status = 8} /* 2540 */,
    {.source = (const lxb_char_t *) "xn--c9e433epi4b3j20a.xn--kmb6733w", .ascii = (const lxb_char_t *) "xn--c9e433epi4b3j20a.xn--kmb6733w", .status = 4} /* 2541 */,
    {.source = (const lxb_char_t *) "xn--c9e433epi4b3j20a.xn--kmb859ja94998b", .ascii = (const lxb_char_t *) "xn--c9e433epi4b3j20a.xn--kmb859ja94998b", .status = 8} /* 2542 */,
    {.source = (const lxb_char_t *) "𞽀.𐹸🚖\u0E3A", .ascii = (const lxb_char_t *) "xn--0n7h.xn--o4c9032klszf", .status = 8} /* 2543 */,
    {.source = (const lxb_char_t *) "xn--0n7h.xn--o4c9032klszf", .ascii = (const lxb_char_t *) "xn--0n7h.xn--o4c9032klszf", .status = 8} /* 2544 */,
    {.source = (const lxb_char_t *) "Ⴔᠵ｡𐹧\u0747۹", .ascii = (const lxb_char_t *) "xn--snd659a.xn--mmb9ml895e", .status = 8} /* 2545 */,
    {.source = (const lxb_char_t *) "Ⴔᠵ。𐹧\u0747۹", .ascii = (const lxb_char_t *) "xn--snd659a.xn--mmb9ml895e", .status = 8} /* 2546 */,
    {.source = (const lxb_char_t *) "ⴔᠵ。𐹧\u0747۹", .ascii = (const lxb_char_t *) "xn--o7e997h.xn--mmb9ml895e", .status = 4} /* 2547 */,
    {.source = (const lxb_char_t *) "xn--o7e997h.xn--mmb9ml895e", .ascii = (const lxb_char_t *) "xn--o7e997h.xn--mmb9ml895e", .status = 4} /* 2548 */,
    {.source = (const lxb_char_t *) "xn--snd659a.xn--mmb9ml895e", .ascii = (const lxb_char_t *) "xn--snd659a.xn--mmb9ml895e", .status = 8} /* 2549 */,
    {.source = (const lxb_char_t *) "ⴔᠵ｡𐹧\u0747۹", .ascii = (const lxb_char_t *) "xn--o7e997h.xn--mmb9ml895e", .status = 4} /* 2550 */,
    {.source = (const lxb_char_t *) "\u135Fᡈ\u200C．︒-𖾐-", .ascii = (const lxb_char_t *) "xn--b7d82wo4h.xn-----c82nz547a", .status = 16} /* 2551 */,
    {.source = (const lxb_char_t *) "\u135Fᡈ\u200C.。-𖾐-", .ascii = (const lxb_char_t *) "xn--b7d82wo4h..xn-----pe4u", .status = 18} /* 2552 */,
    {.source = (const lxb_char_t *) "xn--b7d82w..xn-----pe4u", .ascii = (const lxb_char_t *) "xn--b7d82w..xn-----pe4u", .status = 14} /* 2553 */,
    {.source = (const lxb_char_t *) "xn--b7d82wo4h..xn-----pe4u", .ascii = (const lxb_char_t *) "xn--b7d82wo4h..xn-----pe4u", .status = 18} /* 2554 */,
    {.source = (const lxb_char_t *) "xn--b7d82w.xn-----c82nz547a", .ascii = (const lxb_char_t *) "xn--b7d82w.xn-----c82nz547a", .status = 12} /* 2555 */,
    {.source = (const lxb_char_t *) "xn--b7d82wo4h.xn-----c82nz547a", .ascii = (const lxb_char_t *) "xn--b7d82wo4h.xn-----c82nz547a", .status = 16} /* 2556 */,
    {.source = (const lxb_char_t *) "⒈\u0601⒖\u200C.\u1DF0\u07DB", .ascii = (const lxb_char_t *) "xn--jfb844kmfdwb.xn--2sb914i", .status = 16} /* 2557 */,
    {.source = (const lxb_char_t *) "1.\u060115.\u200C.\u1DF0\u07DB", .ascii = (const lxb_char_t *) "1.xn--15-1pd.xn--0ug.xn--2sb914i", .status = 16} /* 2558 */,
    {.source = (const lxb_char_t *) "1.xn--15-1pd..xn--2sb914i", .ascii = (const lxb_char_t *) "1.xn--15-1pd..xn--2sb914i", .status = 18} /* 2559 */,
    {.source = (const lxb_char_t *) "1.xn--15-1pd.xn--0ug.xn--2sb914i", .ascii = (const lxb_char_t *) "1.xn--15-1pd.xn--0ug.xn--2sb914i", .status = 16} /* 2560 */,
    {.source = (const lxb_char_t *) "xn--jfb347mib.xn--2sb914i", .ascii = (const lxb_char_t *) "xn--jfb347mib.xn--2sb914i", .status = 12} /* 2561 */,
    {.source = (const lxb_char_t *) "xn--jfb844kmfdwb.xn--2sb914i", .ascii = (const lxb_char_t *) "xn--jfb844kmfdwb.xn--2sb914i", .status = 16} /* 2562 */,
    {.source = (const lxb_char_t *) "𝩜。-\u0B4DႫ", .ascii = (const lxb_char_t *) "xn--792h.xn----bse632b", .status = 12} /* 2563 */,
    {.source = (const lxb_char_t *) "𝩜。-\u0B4Dⴋ", .ascii = (const lxb_char_t *) "xn--792h.xn----bse820x", .status = 8} /* 2564 */,
    {.source = (const lxb_char_t *) "xn--792h.xn----bse820x", .ascii = (const lxb_char_t *) "xn--792h.xn----bse820x", .status = 8} /* 2565 */,
    {.source = (const lxb_char_t *) "xn--792h.xn----bse632b", .ascii = (const lxb_char_t *) "xn--792h.xn----bse632b", .status = 12} /* 2566 */,
    {.source = (const lxb_char_t *) "ßჀ.\u0620刯Ⴝ", .ascii = (const lxb_char_t *) "xn--zca442f.xn--fgb845cb66c", .status = 12} /* 2567 */,
    {.source = (const lxb_char_t *) "ßⴠ.\u0620刯ⴝ", .ascii = (const lxb_char_t *) "xn--zca277t.xn--fgb670rovy", .status = 8} /* 2568 */,
    {.source = (const lxb_char_t *) "SSჀ.\u0620刯Ⴝ", .ascii = (const lxb_char_t *) "xn--ss-wgk.xn--fgb845cb66c", .status = 12} /* 2569 */,
    {.source = (const lxb_char_t *) "ssⴠ.\u0620刯ⴝ", .ascii = (const lxb_char_t *) "xn--ss-j81a.xn--fgb670rovy", .status = 8} /* 2570 */,
    {.source = (const lxb_char_t *) "Ssⴠ.\u0620刯Ⴝ", .ascii = (const lxb_char_t *) "xn--ss-j81a.xn--fgb845cb66c", .status = 12} /* 2571 */,
    {.source = (const lxb_char_t *) "xn--ss-j81a.xn--fgb845cb66c", .ascii = (const lxb_char_t *) "xn--ss-j81a.xn--fgb845cb66c", .status = 12} /* 2572 */,
    {.source = (const lxb_char_t *) "xn--ss-j81a.xn--fgb670rovy", .ascii = (const lxb_char_t *) "xn--ss-j81a.xn--fgb670rovy", .status = 8} /* 2573 */,
    {.source = (const lxb_char_t *) "xn--ss-wgk.xn--fgb845cb66c", .ascii = (const lxb_char_t *) "xn--ss-wgk.xn--fgb845cb66c", .status = 12} /* 2574 */,
    {.source = (const lxb_char_t *) "xn--zca277t.xn--fgb670rovy", .ascii = (const lxb_char_t *) "xn--zca277t.xn--fgb670rovy", .status = 8} /* 2575 */,
    {.source = (const lxb_char_t *) "xn--zca442f.xn--fgb845cb66c", .ascii = (const lxb_char_t *) "xn--zca442f.xn--fgb845cb66c", .status = 12} /* 2576 */,
    {.source = (const lxb_char_t *) "\u1BAAႣℲ｡ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957cone.xn--sib102gc69k", .status = 16} /* 2577 */,
    {.source = (const lxb_char_t *) "\u1BAAႣℲ｡ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957cone.xn--sib102gc69k", .status = 16} /* 2578 */,
    {.source = (const lxb_char_t *) "\u1BAAႣℲ。ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957cone.xn--sib102gc69k", .status = 16} /* 2579 */,
    {.source = (const lxb_char_t *) "\u1BAAႣℲ。ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957cone.xn--sib102gc69k", .status = 16} /* 2580 */,
    {.source = (const lxb_char_t *) "\u1BAAⴃⅎ。ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--yxf24x4ol.xn--sib102gc69k", .status = 12} /* 2581 */,
    {.source = (const lxb_char_t *) "\u1BAAⴃⅎ。ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--yxf24x4ol.xn--sib102gc69k", .status = 12} /* 2582 */,
    {.source = (const lxb_char_t *) "\u1BAAႣⅎ。ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957c2pe.xn--sib102gc69k", .status = 16} /* 2583 */,
    {.source = (const lxb_char_t *) "\u1BAAႣⅎ。ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957c2pe.xn--sib102gc69k", .status = 16} /* 2584 */,
    {.source = (const lxb_char_t *) "xn--bnd957c2pe.xn--sib102gc69k", .ascii = (const lxb_char_t *) "xn--bnd957c2pe.xn--sib102gc69k", .status = 16} /* 2585 */,
    {.source = (const lxb_char_t *) "xn--yxf24x4ol.xn--sib102gc69k", .ascii = (const lxb_char_t *) "xn--yxf24x4ol.xn--sib102gc69k", .status = 12} /* 2586 */,
    {.source = (const lxb_char_t *) "xn--bnd957cone.xn--sib102gc69k", .ascii = (const lxb_char_t *) "xn--bnd957cone.xn--sib102gc69k", .status = 16} /* 2587 */,
    {.source = (const lxb_char_t *) "\u1BAAⴃⅎ｡ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--yxf24x4ol.xn--sib102gc69k", .status = 12} /* 2588 */,
    {.source = (const lxb_char_t *) "\u1BAAⴃⅎ｡ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--yxf24x4ol.xn--sib102gc69k", .status = 12} /* 2589 */,
    {.source = (const lxb_char_t *) "\u1BAAႣⅎ｡ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957c2pe.xn--sib102gc69k", .status = 16} /* 2590 */,
    {.source = (const lxb_char_t *) "\u1BAAႣⅎ｡ᠳ툻\u0673", .ascii = (const lxb_char_t *) "xn--bnd957c2pe.xn--sib102gc69k", .status = 16} /* 2591 */,
    {.source = (const lxb_char_t *) "\u06EC.\u08A2𐹫\u067C", .ascii = (const lxb_char_t *) "xn--8lb.xn--1ib31ily45b", .status = 8} /* 2592 */,
    {.source = (const lxb_char_t *) "xn--8lb.xn--1ib31ily45b", .ascii = (const lxb_char_t *) "xn--8lb.xn--1ib31ily45b", .status = 8} /* 2593 */,
    {.source = (const lxb_char_t *) "\u06B6\u06DF。₇\uA806", .ascii = (const lxb_char_t *) "xn--pkb6f.xn--7-x93e", .status = 4} /* 2594 */,
    {.source = (const lxb_char_t *) "\u06B6\u06DF。7\uA806", .ascii = (const lxb_char_t *) "xn--pkb6f.xn--7-x93e", .status = 4} /* 2595 */,
    {.source = (const lxb_char_t *) "xn--pkb6f.xn--7-x93e", .ascii = (const lxb_char_t *) "xn--pkb6f.xn--7-x93e", .status = 4} /* 2596 */,
    {.source = (const lxb_char_t *) "\u06B6\u06DF.7\uA806", .ascii = (const lxb_char_t *) "xn--pkb6f.xn--7-x93e", .status = 4} /* 2597 */,
    {.source = (const lxb_char_t *) "Ⴣ𐹻.\u200C𝪣≮󠩉", .ascii = (const lxb_char_t *) "xn--7nd8101k.xn--0ugy6gn120eb103g", .status = 20} /* 2598 */,
    {.source = (const lxb_char_t *) "Ⴣ𐹻.\u200C𝪣<\u0338󠩉", .ascii = (const lxb_char_t *) "xn--7nd8101k.xn--0ugy6gn120eb103g", .status = 20} /* 2599 */,
    {.source = (const lxb_char_t *) "ⴣ𐹻.\u200C𝪣<\u0338󠩉", .ascii = (const lxb_char_t *) "xn--rlj6323e.xn--0ugy6gn120eb103g", .status = 20} /* 2600 */,
    {.source = (const lxb_char_t *) "ⴣ𐹻.\u200C𝪣≮󠩉", .ascii = (const lxb_char_t *) "xn--rlj6323e.xn--0ugy6gn120eb103g", .status = 20} /* 2601 */,
    {.source = (const lxb_char_t *) "xn--rlj6323e.xn--gdh4944ob3x3e", .ascii = (const lxb_char_t *) "xn--rlj6323e.xn--gdh4944ob3x3e", .status = 20} /* 2602 */,
    {.source = (const lxb_char_t *) "xn--rlj6323e.xn--0ugy6gn120eb103g", .ascii = (const lxb_char_t *) "xn--rlj6323e.xn--0ugy6gn120eb103g", .status = 20} /* 2603 */,
    {.source = (const lxb_char_t *) "xn--7nd8101k.xn--gdh4944ob3x3e", .ascii = (const lxb_char_t *) "xn--7nd8101k.xn--gdh4944ob3x3e", .status = 20} /* 2604 */,
    {.source = (const lxb_char_t *) "xn--7nd8101k.xn--0ugy6gn120eb103g", .ascii = (const lxb_char_t *) "xn--7nd8101k.xn--0ugy6gn120eb103g", .status = 20} /* 2605 */,
    {.source = (const lxb_char_t *) "𝟵隁⯮．\u180D\u200C", .ascii = (const lxb_char_t *) "xn--9-mfs8024b.xn--0ug", .status = 4} /* 2606 */,
    {.source = (const lxb_char_t *) "9隁⯮.\u180D\u200C", .ascii = (const lxb_char_t *) "xn--9-mfs8024b.xn--0ug", .status = 4} /* 2607 */,
    {.source = (const lxb_char_t *) "xn--9-mfs8024b.", .ascii = (const lxb_char_t *) "xn--9-mfs8024b.", .status = 0} /* 2608 */,
    {.source = (const lxb_char_t *) "9隁⯮.", .ascii = (const lxb_char_t *) "xn--9-mfs8024b.", .status = 0} /* 2609 */,
    {.source = (const lxb_char_t *) "xn--9-mfs8024b.xn--0ug", .ascii = (const lxb_char_t *) "xn--9-mfs8024b.xn--0ug", .status = 4} /* 2610 */,
    {.source = (const lxb_char_t *) "⒏𐹧｡Ⴣ\u0F84彦", .ascii = (const lxb_char_t *) "xn--0sh2466f.xn--3ed15dt93o", .status = 8} /* 2611 */,
    {.source = (const lxb_char_t *) "8.𐹧。Ⴣ\u0F84彦", .ascii = (const lxb_char_t *) "8.xn--fo0d.xn--3ed15dt93o", .status = 8} /* 2612 */,
    {.source = (const lxb_char_t *) "8.𐹧。ⴣ\u0F84彦", .ascii = (const lxb_char_t *) "8.xn--fo0d.xn--3ed972m6o8a", .status = 4} /* 2613 */,
    {.source = (const lxb_char_t *) "8.xn--fo0d.xn--3ed972m6o8a", .ascii = (const lxb_char_t *) "8.xn--fo0d.xn--3ed972m6o8a", .status = 4} /* 2614 */,
    {.source = (const lxb_char_t *) "8.xn--fo0d.xn--3ed15dt93o", .ascii = (const lxb_char_t *) "8.xn--fo0d.xn--3ed15dt93o", .status = 8} /* 2615 */,
    {.source = (const lxb_char_t *) "⒏𐹧｡ⴣ\u0F84彦", .ascii = (const lxb_char_t *) "xn--0sh2466f.xn--3ed972m6o8a", .status = 8} /* 2616 */,
    {.source = (const lxb_char_t *) "xn--0sh2466f.xn--3ed972m6o8a", .ascii = (const lxb_char_t *) "xn--0sh2466f.xn--3ed972m6o8a", .status = 8} /* 2617 */,
    {.source = (const lxb_char_t *) "xn--0sh2466f.xn--3ed15dt93o", .ascii = (const lxb_char_t *) "xn--0sh2466f.xn--3ed15dt93o", .status = 8} /* 2618 */,
    {.source = (const lxb_char_t *) "-问񬰔⒛。\u0604-񜗉橬", .ascii = (const lxb_char_t *) "xn----hdpu849bhis3e.xn----ykc7228efm46d", .status = 12} /* 2619 */,
    {.source = (const lxb_char_t *) "-问񬰔20.。\u0604-񜗉橬", .ascii = (const lxb_char_t *) "xn---20-658jx1776d..xn----ykc7228efm46d", .status = 18} /* 2620 */,
    {.source = (const lxb_char_t *) "xn---20-658jx1776d..xn----ykc7228efm46d", .ascii = (const lxb_char_t *) "xn---20-658jx1776d..xn----ykc7228efm46d", .status = 18} /* 2621 */,
    {.source = (const lxb_char_t *) "xn----hdpu849bhis3e.xn----ykc7228efm46d", .ascii = (const lxb_char_t *) "xn----hdpu849bhis3e.xn----ykc7228efm46d", .status = 12} /* 2622 */,
    {.source = (const lxb_char_t *) "\u1BACႬ\u200C\u0325。𝟸", .ascii = (const lxb_char_t *) "xn--mta930emribme.2", .status = 12} /* 2623 */,
    {.source = (const lxb_char_t *) "\u1BACႬ\u200C\u0325。2", .ascii = (const lxb_char_t *) "xn--mta930emribme.2", .status = 12} /* 2624 */,
    {.source = (const lxb_char_t *) "\u1BACⴌ\u200C\u0325。2", .ascii = (const lxb_char_t *) "xn--mta176j97cl2q.2", .status = 8} /* 2625 */,
    {.source = (const lxb_char_t *) "xn--mta176jjjm.2", .ascii = (const lxb_char_t *) "xn--mta176jjjm.2", .status = 4} /* 2626 */,
    {.source = (const lxb_char_t *) "xn--mta176j97cl2q.2", .ascii = (const lxb_char_t *) "xn--mta176j97cl2q.2", .status = 8} /* 2627 */,
    {.source = (const lxb_char_t *) "xn--mta930emri.2", .ascii = (const lxb_char_t *) "xn--mta930emri.2", .status = 8} /* 2628 */,
    {.source = (const lxb_char_t *) "xn--mta930emribme.2", .ascii = (const lxb_char_t *) "xn--mta930emribme.2", .status = 12} /* 2629 */,
    {.source = (const lxb_char_t *) "\u1BACⴌ\u200C\u0325。𝟸", .ascii = (const lxb_char_t *) "xn--mta176j97cl2q.2", .status = 8} /* 2630 */,
    {.source = (const lxb_char_t *) "?。\uA806\u0669󠒩", .ascii = (const lxb_char_t *) "?.xn--iib9583fusy0i", .status = 12} /* 2631 */,
    {.source = (const lxb_char_t *) "?.xn--iib9583fusy0i", .ascii = (const lxb_char_t *) "?.xn--iib9583fusy0i", .status = 12} /* 2632 */,
    {.source = (const lxb_char_t *) "󠄁\u035F⾶｡₇︒눇≮", .ascii = (const lxb_char_t *) "xn--9ua0567e.xn--7-ngou006d1ttc", .status = 8} /* 2633 */,
    {.source = (const lxb_char_t *) "󠄁\u035F⾶｡₇︒눇<\u0338", .ascii = (const lxb_char_t *) "xn--9ua0567e.xn--7-ngou006d1ttc", .status = 8} /* 2634 */,
    {.source = (const lxb_char_t *) "󠄁\u035F飛。7。눇≮", .ascii = (const lxb_char_t *) "xn--9ua0567e.7.xn--gdh6767c", .status = 4} /* 2635 */,
    {.source = (const lxb_char_t *) "󠄁\u035F飛。7。눇<\u0338", .ascii = (const lxb_char_t *) "xn--9ua0567e.7.xn--gdh6767c", .status = 4} /* 2636 */,
    {.source = (const lxb_char_t *) "xn--9ua0567e.7.xn--gdh6767c", .ascii = (const lxb_char_t *) "xn--9ua0567e.7.xn--gdh6767c", .status = 4} /* 2637 */,
    {.source = (const lxb_char_t *) "xn--9ua0567e.xn--7-ngou006d1ttc", .ascii = (const lxb_char_t *) "xn--9ua0567e.xn--7-ngou006d1ttc", .status = 8} /* 2638 */,
    {.source = (const lxb_char_t *) "\u200C\uFE09𐹴\u200D．\u200C⿃", .ascii = (const lxb_char_t *) "xn--0ugc6024p.xn--0ug1920c", .status = 12} /* 2639 */,
    {.source = (const lxb_char_t *) "\u200C\uFE09𐹴\u200D.\u200C鳥", .ascii = (const lxb_char_t *) "xn--0ugc6024p.xn--0ug1920c", .status = 12} /* 2640 */,
    {.source = (const lxb_char_t *) "xn--so0d.xn--6x6a", .ascii = (const lxb_char_t *) "xn--so0d.xn--6x6a", .status = 4} /* 2641 */,
    {.source = (const lxb_char_t *) "xn--0ugc6024p.xn--0ug1920c", .ascii = (const lxb_char_t *) "xn--0ugc6024p.xn--0ug1920c", .status = 12} /* 2642 */,
    {.source = (const lxb_char_t *) "🍮．\u200D󠗒𐦁𝨝", .ascii = (const lxb_char_t *) "xn--lj8h.xn--1ug6603gr1pfwq37h", .status = 12} /* 2643 */,
    {.source = (const lxb_char_t *) "🍮.\u200D󠗒𐦁𝨝", .ascii = (const lxb_char_t *) "xn--lj8h.xn--1ug6603gr1pfwq37h", .status = 12} /* 2644 */,
    {.source = (const lxb_char_t *) "xn--lj8h.xn--ln9ci476aqmr2g", .ascii = (const lxb_char_t *) "xn--lj8h.xn--ln9ci476aqmr2g", .status = 8} /* 2645 */,
    {.source = (const lxb_char_t *) "xn--lj8h.xn--1ug6603gr1pfwq37h", .ascii = (const lxb_char_t *) "xn--lj8h.xn--1ug6603gr1pfwq37h", .status = 12} /* 2646 */,
    {.source = (const lxb_char_t *) "\u067D\u0943.𞤓\u200D", .ascii = (const lxb_char_t *) "xn--2ib43l.xn--1ugy711p", .status = 8} /* 2647 */,
    {.source = (const lxb_char_t *) "\u067D\u0943.𞤵\u200D", .ascii = (const lxb_char_t *) "xn--2ib43l.xn--1ugy711p", .status = 8} /* 2648 */,
    {.source = (const lxb_char_t *) "xn--2ib43l.xn--te6h", .ascii = (const lxb_char_t *) "xn--2ib43l.xn--te6h", .status = 0} /* 2649 */,
    {.source = (const lxb_char_t *) "\u067D\u0943.𞤵", .ascii = (const lxb_char_t *) "xn--2ib43l.xn--te6h", .status = 0} /* 2650 */,
    {.source = (const lxb_char_t *) "\u067D\u0943.𞤓", .ascii = (const lxb_char_t *) "xn--2ib43l.xn--te6h", .status = 0} /* 2651 */,
    {.source = (const lxb_char_t *) "xn--2ib43l.xn--1ugy711p", .ascii = (const lxb_char_t *) "xn--2ib43l.xn--1ugy711p", .status = 8} /* 2652 */,
    {.source = (const lxb_char_t *) "\u0664\u0A4D-．󥜽\u1039񦦐", .ascii = (const lxb_char_t *) "xn----gqc711a.xn--9jd88234f3qm0b", .status = 12} /* 2653 */,
    {.source = (const lxb_char_t *) "\u0664\u0A4D-.󥜽\u1039񦦐", .ascii = (const lxb_char_t *) "xn----gqc711a.xn--9jd88234f3qm0b", .status = 12} /* 2654 */,
    {.source = (const lxb_char_t *) "xn----gqc711a.xn--9jd88234f3qm0b", .ascii = (const lxb_char_t *) "xn----gqc711a.xn--9jd88234f3qm0b", .status = 12} /* 2655 */,
    {.source = (const lxb_char_t *) "4\u103A-𐹸｡\uAA29\u200C𐹴≮", .ascii = (const lxb_char_t *) "xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", .status = 12} /* 2656 */,
    {.source = (const lxb_char_t *) "4\u103A-𐹸｡\uAA29\u200C𐹴<\u0338", .ascii = (const lxb_char_t *) "xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", .status = 12} /* 2657 */,
    {.source = (const lxb_char_t *) "4\u103A-𐹸。\uAA29\u200C𐹴≮", .ascii = (const lxb_char_t *) "xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", .status = 12} /* 2658 */,
    {.source = (const lxb_char_t *) "4\u103A-𐹸。\uAA29\u200C𐹴<\u0338", .ascii = (const lxb_char_t *) "xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", .status = 12} /* 2659 */,
    {.source = (const lxb_char_t *) "xn--4--e4j7831r.xn--gdh8754cz40c", .ascii = (const lxb_char_t *) "xn--4--e4j7831r.xn--gdh8754cz40c", .status = 8} /* 2660 */,
    {.source = (const lxb_char_t *) "xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", .ascii = (const lxb_char_t *) "xn--4--e4j7831r.xn--0ugy6gjy5sl3ud", .status = 12} /* 2661 */,
    {.source = (const lxb_char_t *) "\u200C。\uFFA0\u0F84\u0F96", .ascii = (const lxb_char_t *) "xn--0ug.xn--3ed0by082k", .status = 8} /* 2662 */,
    {.source = (const lxb_char_t *) "\u200C。\u1160\u0F84\u0F96", .ascii = (const lxb_char_t *) "xn--0ug.xn--3ed0b20h", .status = 8} /* 2663 */,
    {.source = (const lxb_char_t *) ".xn--3ed0b20h", .ascii = (const lxb_char_t *) ".xn--3ed0b20h", .status = 10} /* 2664 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--3ed0b20h", .ascii = (const lxb_char_t *) "xn--0ug.xn--3ed0b20h", .status = 8} /* 2665 */,
    {.source = (const lxb_char_t *) ".xn--3ed0by082k", .ascii = (const lxb_char_t *) ".xn--3ed0by082k", .status = 10} /* 2666 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--3ed0by082k", .ascii = (const lxb_char_t *) "xn--0ug.xn--3ed0by082k", .status = 8} /* 2667 */,
    {.source = (const lxb_char_t *) "≯򍘅．\u200D𐅼򲇛", .ascii = (const lxb_char_t *) "xn--hdh84488f.xn--1ug8099fbjp4e", .status = 8} /* 2668 */,
    {.source = (const lxb_char_t *) ">\u0338򍘅．\u200D𐅼򲇛", .ascii = (const lxb_char_t *) "xn--hdh84488f.xn--1ug8099fbjp4e", .status = 8} /* 2669 */,
    {.source = (const lxb_char_t *) "≯򍘅.\u200D𐅼򲇛", .ascii = (const lxb_char_t *) "xn--hdh84488f.xn--1ug8099fbjp4e", .status = 8} /* 2670 */,
    {.source = (const lxb_char_t *) ">\u0338򍘅.\u200D𐅼򲇛", .ascii = (const lxb_char_t *) "xn--hdh84488f.xn--1ug8099fbjp4e", .status = 8} /* 2671 */,
    {.source = (const lxb_char_t *) "xn--hdh84488f.xn--xy7cw2886b", .ascii = (const lxb_char_t *) "xn--hdh84488f.xn--xy7cw2886b", .status = 4} /* 2672 */,
    {.source = (const lxb_char_t *) "xn--hdh84488f.xn--1ug8099fbjp4e", .ascii = (const lxb_char_t *) "xn--hdh84488f.xn--1ug8099fbjp4e", .status = 8} /* 2673 */,
    {.source = (const lxb_char_t *) "\u0641ß𐰯｡𝟕𐫫", .ascii = (const lxb_char_t *) "xn--zca96ys96y.xn--7-mm5i", .status = 8} /* 2674 */,
    {.source = (const lxb_char_t *) "\u0641ß𐰯。7𐫫", .ascii = (const lxb_char_t *) "xn--zca96ys96y.xn--7-mm5i", .status = 8} /* 2675 */,
    {.source = (const lxb_char_t *) "\u0641SS𐰯。7𐫫", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2676 */,
    {.source = (const lxb_char_t *) "\u0641ss𐰯。7𐫫", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2677 */,
    {.source = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2678 */,
    {.source = (const lxb_char_t *) "xn--zca96ys96y.xn--7-mm5i", .ascii = (const lxb_char_t *) "xn--zca96ys96y.xn--7-mm5i", .status = 8} /* 2679 */,
    {.source = (const lxb_char_t *) "\u0641SS𐰯｡𝟕𐫫", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2680 */,
    {.source = (const lxb_char_t *) "\u0641ss𐰯｡𝟕𐫫", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2681 */,
    {.source = (const lxb_char_t *) "\u0641Ss𐰯。7𐫫", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2682 */,
    {.source = (const lxb_char_t *) "\u0641Ss𐰯｡𝟕𐫫", .ascii = (const lxb_char_t *) "xn--ss-jvd2339x.xn--7-mm5i", .status = 8} /* 2683 */,
    {.source = (const lxb_char_t *) "ß\u07AC\u07A7\u08B1。𐭁􅮙𐹲", .ascii = (const lxb_char_t *) "xn--zca685aoa95h.xn--e09co8cr9861c", .status = 16} /* 2684 */,
    {.source = (const lxb_char_t *) "SS\u07AC\u07A7\u08B1。𐭁􅮙𐹲", .ascii = (const lxb_char_t *) "xn--ss-9qet02k.xn--e09co8cr9861c", .status = 16} /* 2685 */,
    {.source = (const lxb_char_t *) "ss\u07AC\u07A7\u08B1。𐭁􅮙𐹲", .ascii = (const lxb_char_t *) "xn--ss-9qet02k.xn--e09co8cr9861c", .status = 16} /* 2686 */,
    {.source = (const lxb_char_t *) "Ss\u07AC\u07A7\u08B1。𐭁􅮙𐹲", .ascii = (const lxb_char_t *) "xn--ss-9qet02k.xn--e09co8cr9861c", .status = 16} /* 2687 */,
    {.source = (const lxb_char_t *) "xn--ss-9qet02k.xn--e09co8cr9861c", .ascii = (const lxb_char_t *) "xn--ss-9qet02k.xn--e09co8cr9861c", .status = 16} /* 2688 */,
    {.source = (const lxb_char_t *) "xn--zca685aoa95h.xn--e09co8cr9861c", .ascii = (const lxb_char_t *) "xn--zca685aoa95h.xn--e09co8cr9861c", .status = 16} /* 2689 */,
    {.source = (const lxb_char_t *) "-｡󠉗⒌𞯛", .ascii = (const lxb_char_t *) "-.xn--xsh6367n1bi3e", .status = 12} /* 2690 */,
    {.source = (const lxb_char_t *) "-。󠉗5.𞯛", .ascii = (const lxb_char_t *) "-.xn--5-zz21m.xn--6x6h", .status = 12} /* 2691 */,
    {.source = (const lxb_char_t *) "-.xn--5-zz21m.xn--6x6h", .ascii = (const lxb_char_t *) "-.xn--5-zz21m.xn--6x6h", .status = 12} /* 2692 */,
    {.source = (const lxb_char_t *) "-.xn--xsh6367n1bi3e", .ascii = (const lxb_char_t *) "-.xn--xsh6367n1bi3e", .status = 12} /* 2693 */,
    {.source = (const lxb_char_t *) "𼎏ς．-≮\uFCAB", .ascii = (const lxb_char_t *) "xn--3xa13520c.xn----9mcf1400a", .status = 12} /* 2694 */,
    {.source = (const lxb_char_t *) "𼎏ς．-<\u0338\uFCAB", .ascii = (const lxb_char_t *) "xn--3xa13520c.xn----9mcf1400a", .status = 12} /* 2695 */,
    {.source = (const lxb_char_t *) "𼎏ς.-≮\u062E\u062C", .ascii = (const lxb_char_t *) "xn--3xa13520c.xn----9mcf1400a", .status = 12} /* 2696 */,
    {.source = (const lxb_char_t *) "𼎏ς.-<\u0338\u062E\u062C", .ascii = (const lxb_char_t *) "xn--3xa13520c.xn----9mcf1400a", .status = 12} /* 2697 */,
    {.source = (const lxb_char_t *) "𼎏Σ.-<\u0338\u062E\u062C", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2698 */,
    {.source = (const lxb_char_t *) "𼎏Σ.-≮\u062E\u062C", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2699 */,
    {.source = (const lxb_char_t *) "𼎏σ.-≮\u062E\u062C", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2700 */,
    {.source = (const lxb_char_t *) "𼎏σ.-<\u0338\u062E\u062C", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2701 */,
    {.source = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2702 */,
    {.source = (const lxb_char_t *) "xn--3xa13520c.xn----9mcf1400a", .ascii = (const lxb_char_t *) "xn--3xa13520c.xn----9mcf1400a", .status = 12} /* 2703 */,
    {.source = (const lxb_char_t *) "𼎏Σ．-<\u0338\uFCAB", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2704 */,
    {.source = (const lxb_char_t *) "𼎏Σ．-≮\uFCAB", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2705 */,
    {.source = (const lxb_char_t *) "𼎏σ．-≮\uFCAB", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2706 */,
    {.source = (const lxb_char_t *) "𼎏σ．-<\u0338\uFCAB", .ascii = (const lxb_char_t *) "xn--4xa92520c.xn----9mcf1400a", .status = 12} /* 2707 */,
    {.source = (const lxb_char_t *) "ꡗ\u08B8\u0719．񔤔󠛙\u0C4D\uFC3E", .ascii = (const lxb_char_t *) "xn--jnb34fs003a.xn--fhbo927bk128mpi24d", .status = 12} /* 2708 */,
    {.source = (const lxb_char_t *) "ꡗ\u08B8\u0719.񔤔󠛙\u0C4D\u0643\u064A", .ascii = (const lxb_char_t *) "xn--jnb34fs003a.xn--fhbo927bk128mpi24d", .status = 12} /* 2709 */,
    {.source = (const lxb_char_t *) "xn--jnb34fs003a.xn--fhbo927bk128mpi24d", .ascii = (const lxb_char_t *) "xn--jnb34fs003a.xn--fhbo927bk128mpi24d", .status = 12} /* 2710 */,
    {.source = (const lxb_char_t *) "𐠰\u08B7𞤌𐫭。𐋦\u17CD𝩃", .ascii = (const lxb_char_t *) "xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", .status = 4} /* 2711 */,
    {.source = (const lxb_char_t *) "𐠰\u08B7𞤮𐫭。𐋦\u17CD𝩃", .ascii = (const lxb_char_t *) "xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", .status = 4} /* 2712 */,
    {.source = (const lxb_char_t *) "xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", .ascii = (const lxb_char_t *) "xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", .status = 4} /* 2713 */,
    {.source = (const lxb_char_t *) "𐠰\u08B7𞤮𐫭.𐋦\u17CD𝩃", .ascii = (const lxb_char_t *) "xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", .status = 4} /* 2714 */,
    {.source = (const lxb_char_t *) "𐠰\u08B7𞤌𐫭.𐋦\u17CD𝩃", .ascii = (const lxb_char_t *) "xn--dzb5191kezbrw47a.xn--p4e3841jz9tf", .status = 4} /* 2715 */,
    {.source = (const lxb_char_t *) "₂㘷--。\u06D3\u200C𐫆𑖿", .ascii = (const lxb_char_t *) "xn--2---u58b.xn--jlb820ku99nbgj", .status = 16} /* 2716 */,
    {.source = (const lxb_char_t *) "₂㘷--。\u06D2\u0654\u200C𐫆𑖿", .ascii = (const lxb_char_t *) "xn--2---u58b.xn--jlb820ku99nbgj", .status = 16} /* 2717 */,
    {.source = (const lxb_char_t *) "2㘷--。\u06D3\u200C𐫆𑖿", .ascii = (const lxb_char_t *) "xn--2---u58b.xn--jlb820ku99nbgj", .status = 16} /* 2718 */,
    {.source = (const lxb_char_t *) "2㘷--。\u06D2\u0654\u200C𐫆𑖿", .ascii = (const lxb_char_t *) "xn--2---u58b.xn--jlb820ku99nbgj", .status = 16} /* 2719 */,
    {.source = (const lxb_char_t *) "xn--2---u58b.xn--jlb8024k14g", .ascii = (const lxb_char_t *) "xn--2---u58b.xn--jlb8024k14g", .status = 12} /* 2720 */,
    {.source = (const lxb_char_t *) "xn--2---u58b.xn--jlb820ku99nbgj", .ascii = (const lxb_char_t *) "xn--2---u58b.xn--jlb820ku99nbgj", .status = 16} /* 2721 */,
    {.source = (const lxb_char_t *) "-𘊻．ᡮ\u062D-", .ascii = (const lxb_char_t *) "xn----bp5n.xn----bnc231l", .status = 16} /* 2722 */,
    {.source = (const lxb_char_t *) "-𘊻.ᡮ\u062D-", .ascii = (const lxb_char_t *) "xn----bp5n.xn----bnc231l", .status = 16} /* 2723 */,
    {.source = (const lxb_char_t *) "xn----bp5n.xn----bnc231l", .ascii = (const lxb_char_t *) "xn----bp5n.xn----bnc231l", .status = 16} /* 2724 */,
    {.source = (const lxb_char_t *) "\u200C-ß｡ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn----qfa550v.xn--bhb925glx3p", .status = 16} /* 2725 */,
    {.source = (const lxb_char_t *) "\u200C-ß。ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn----qfa550v.xn--bhb925glx3p", .status = 16} /* 2726 */,
    {.source = (const lxb_char_t *) "\u200C-SS。ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2727 */,
    {.source = (const lxb_char_t *) "\u200C-ss。ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2728 */,
    {.source = (const lxb_char_t *) "\u200C-Ss。ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2729 */,
    {.source = (const lxb_char_t *) "-ss.xn--bhb925glx3p", .ascii = (const lxb_char_t *) "-ss.xn--bhb925glx3p", .status = 16} /* 2730 */,
    {.source = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2731 */,
    {.source = (const lxb_char_t *) "xn----qfa550v.xn--bhb925glx3p", .ascii = (const lxb_char_t *) "xn----qfa550v.xn--bhb925glx3p", .status = 16} /* 2732 */,
    {.source = (const lxb_char_t *) "\u200C-SS｡ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2733 */,
    {.source = (const lxb_char_t *) "\u200C-ss｡ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2734 */,
    {.source = (const lxb_char_t *) "\u200C-Ss｡ᢣ𐹭\u063F", .ascii = (const lxb_char_t *) "xn---ss-8m0a.xn--bhb925glx3p", .status = 16} /* 2735 */,
    {.source = (const lxb_char_t *) "꧐Ӏ\u1BAA\u08F6．눵", .ascii = (const lxb_char_t *) "xn--d5a07sn4u297k.xn--2e1b", .status = 4} /* 2736 */,
    {.source = (const lxb_char_t *) "꧐Ӏ\u1BAA\u08F6．눵", .ascii = (const lxb_char_t *) "xn--d5a07sn4u297k.xn--2e1b", .status = 4} /* 2737 */,
    {.source = (const lxb_char_t *) "꧐Ӏ\u1BAA\u08F6.눵", .ascii = (const lxb_char_t *) "xn--d5a07sn4u297k.xn--2e1b", .status = 4} /* 2738 */,
    {.source = (const lxb_char_t *) "꧐Ӏ\u1BAA\u08F6.눵", .ascii = (const lxb_char_t *) "xn--d5a07sn4u297k.xn--2e1b", .status = 4} /* 2739 */,
    {.source = (const lxb_char_t *) "꧐ӏ\u1BAA\u08F6.눵", .ascii = (const lxb_char_t *) "xn--s5a04sn4u297k.xn--2e1b", .status = 0} /* 2740 */,
    {.source = (const lxb_char_t *) "꧐ӏ\u1BAA\u08F6.눵", .ascii = (const lxb_char_t *) "xn--s5a04sn4u297k.xn--2e1b", .status = 0} /* 2741 */,
    {.source = (const lxb_char_t *) "xn--s5a04sn4u297k.xn--2e1b", .ascii = (const lxb_char_t *) "xn--s5a04sn4u297k.xn--2e1b", .status = 0} /* 2742 */,
    {.source = (const lxb_char_t *) "xn--d5a07sn4u297k.xn--2e1b", .ascii = (const lxb_char_t *) "xn--d5a07sn4u297k.xn--2e1b", .status = 4} /* 2743 */,
    {.source = (const lxb_char_t *) "꧐ӏ\u1BAA\u08F6．눵", .ascii = (const lxb_char_t *) "xn--s5a04sn4u297k.xn--2e1b", .status = 0} /* 2744 */,
    {.source = (const lxb_char_t *) "꧐ӏ\u1BAA\u08F6．눵", .ascii = (const lxb_char_t *) "xn--s5a04sn4u297k.xn--2e1b", .status = 0} /* 2745 */,
    {.source = (const lxb_char_t *) "\uA8EA｡𖄿𑆾󠇗", .ascii = (const lxb_char_t *) "xn--3g9a.xn--ud1dz07k", .status = 8} /* 2746 */,
    {.source = (const lxb_char_t *) "\uA8EA。𖄿𑆾󠇗", .ascii = (const lxb_char_t *) "xn--3g9a.xn--ud1dz07k", .status = 8} /* 2747 */,
    {.source = (const lxb_char_t *) "xn--3g9a.xn--ud1dz07k", .ascii = (const lxb_char_t *) "xn--3g9a.xn--ud1dz07k", .status = 8} /* 2748 */,
    {.source = (const lxb_char_t *) "󇓓𑚳。񐷿≯⾇", .ascii = (const lxb_char_t *) "xn--3e2d79770c.xn--hdh0088abyy1c", .status = 4} /* 2749 */,
    {.source = (const lxb_char_t *) "󇓓𑚳。񐷿>\u0338⾇", .ascii = (const lxb_char_t *) "xn--3e2d79770c.xn--hdh0088abyy1c", .status = 4} /* 2750 */,
    {.source = (const lxb_char_t *) "󇓓𑚳。񐷿≯舛", .ascii = (const lxb_char_t *) "xn--3e2d79770c.xn--hdh0088abyy1c", .status = 4} /* 2751 */,
    {.source = (const lxb_char_t *) "󇓓𑚳。񐷿>\u0338舛", .ascii = (const lxb_char_t *) "xn--3e2d79770c.xn--hdh0088abyy1c", .status = 4} /* 2752 */,
    {.source = (const lxb_char_t *) "xn--3e2d79770c.xn--hdh0088abyy1c", .ascii = (const lxb_char_t *) "xn--3e2d79770c.xn--hdh0088abyy1c", .status = 4} /* 2753 */,
    {.source = (const lxb_char_t *) "𐫇\u0661\u200C．\u200D\u200C", .ascii = (const lxb_char_t *) "xn--9hb652kv99n.xn--0ugb", .status = 16} /* 2754 */,
    {.source = (const lxb_char_t *) "𐫇\u0661\u200C.\u200D\u200C", .ascii = (const lxb_char_t *) "xn--9hb652kv99n.xn--0ugb", .status = 16} /* 2755 */,
    {.source = (const lxb_char_t *) "xn--9hb7344k.", .ascii = (const lxb_char_t *) "xn--9hb7344k.", .status = 0} /* 2756 */,
    {.source = (const lxb_char_t *) "𐫇\u0661.", .ascii = (const lxb_char_t *) "xn--9hb7344k.", .status = 0} /* 2757 */,
    {.source = (const lxb_char_t *) "xn--9hb652kv99n.xn--0ugb", .ascii = (const lxb_char_t *) "xn--9hb652kv99n.xn--0ugb", .status = 16} /* 2758 */,
    {.source = (const lxb_char_t *) "񡅈砪≯ᢑ｡≯𝩚򓴔\u200C", .ascii = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", .status = 8} /* 2759 */,
    {.source = (const lxb_char_t *) "񡅈砪>\u0338ᢑ｡>\u0338𝩚򓴔\u200C", .ascii = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", .status = 8} /* 2760 */,
    {.source = (const lxb_char_t *) "񡅈砪≯ᢑ。≯𝩚򓴔\u200C", .ascii = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", .status = 8} /* 2761 */,
    {.source = (const lxb_char_t *) "񡅈砪>\u0338ᢑ。>\u0338𝩚򓴔\u200C", .ascii = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", .status = 8} /* 2762 */,
    {.source = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--hdh0834o7mj6b", .ascii = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--hdh0834o7mj6b", .status = 4} /* 2763 */,
    {.source = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", .ascii = (const lxb_char_t *) "xn--bbf561cf95e57y3e.xn--0ugz6gc910ejro8c", .status = 8} /* 2764 */,
    {.source = (const lxb_char_t *) "Ⴥ.𑄳㊸", .ascii = (const lxb_char_t *) "xn--9nd.xn--43-274o", .status = 8} /* 2765 */,
    {.source = (const lxb_char_t *) "Ⴥ.𑄳43", .ascii = (const lxb_char_t *) "xn--9nd.xn--43-274o", .status = 8} /* 2766 */,
    {.source = (const lxb_char_t *) "ⴥ.𑄳43", .ascii = (const lxb_char_t *) "xn--tlj.xn--43-274o", .status = 4} /* 2767 */,
    {.source = (const lxb_char_t *) "xn--tlj.xn--43-274o", .ascii = (const lxb_char_t *) "xn--tlj.xn--43-274o", .status = 4} /* 2768 */,
    {.source = (const lxb_char_t *) "xn--9nd.xn--43-274o", .ascii = (const lxb_char_t *) "xn--9nd.xn--43-274o", .status = 8} /* 2769 */,
    {.source = (const lxb_char_t *) "ⴥ.𑄳㊸", .ascii = (const lxb_char_t *) "xn--tlj.xn--43-274o", .status = 4} /* 2770 */,
    {.source = (const lxb_char_t *) "𝟎\u0663。Ⴒᡇ\u08F2𐹠", .ascii = (const lxb_char_t *) "xn--0-fqc.xn--10b180bnwgfy0z", .status = 16} /* 2771 */,
    {.source = (const lxb_char_t *) "0\u0663。Ⴒᡇ\u08F2𐹠", .ascii = (const lxb_char_t *) "xn--0-fqc.xn--10b180bnwgfy0z", .status = 16} /* 2772 */,
    {.source = (const lxb_char_t *) "0\u0663。ⴒᡇ\u08F2𐹠", .ascii = (const lxb_char_t *) "xn--0-fqc.xn--10b369eivp359r", .status = 12} /* 2773 */,
    {.source = (const lxb_char_t *) "xn--0-fqc.xn--10b369eivp359r", .ascii = (const lxb_char_t *) "xn--0-fqc.xn--10b369eivp359r", .status = 12} /* 2774 */,
    {.source = (const lxb_char_t *) "xn--0-fqc.xn--10b180bnwgfy0z", .ascii = (const lxb_char_t *) "xn--0-fqc.xn--10b180bnwgfy0z", .status = 16} /* 2775 */,
    {.source = (const lxb_char_t *) "𝟎\u0663。ⴒᡇ\u08F2𐹠", .ascii = (const lxb_char_t *) "xn--0-fqc.xn--10b369eivp359r", .status = 12} /* 2776 */,
    {.source = (const lxb_char_t *) "񗪨󠄉\uFFA0\u0FB7.񸞰\uA953", .ascii = (const lxb_char_t *) "xn--kgd7493jee34a.xn--3j9au7544a", .status = 4} /* 2777 */,
    {.source = (const lxb_char_t *) "񗪨󠄉\u1160\u0FB7.񸞰\uA953", .ascii = (const lxb_char_t *) "xn--kgd36f9z57y.xn--3j9au7544a", .status = 4} /* 2778 */,
    {.source = (const lxb_char_t *) "xn--kgd36f9z57y.xn--3j9au7544a", .ascii = (const lxb_char_t *) "xn--kgd36f9z57y.xn--3j9au7544a", .status = 4} /* 2779 */,
    {.source = (const lxb_char_t *) "xn--kgd7493jee34a.xn--3j9au7544a", .ascii = (const lxb_char_t *) "xn--kgd7493jee34a.xn--3j9au7544a", .status = 4} /* 2780 */,
    {.source = (const lxb_char_t *) "\u0618.۳\u200C\uA953", .ascii = (const lxb_char_t *) "xn--6fb.xn--gmb469jjf1h", .status = 8} /* 2781 */,
    {.source = (const lxb_char_t *) "xn--6fb.xn--gmb0524f", .ascii = (const lxb_char_t *) "xn--6fb.xn--gmb0524f", .status = 4} /* 2782 */,
    {.source = (const lxb_char_t *) "xn--6fb.xn--gmb469jjf1h", .ascii = (const lxb_char_t *) "xn--6fb.xn--gmb469jjf1h", .status = 8} /* 2783 */,
    {.source = (const lxb_char_t *) "ᡌ．︒ᢑ", .ascii = (const lxb_char_t *) "xn--c8e.xn--bbf9168i", .status = 4} /* 2784 */,
    {.source = (const lxb_char_t *) "ᡌ.。ᢑ", .ascii = (const lxb_char_t *) "xn--c8e..xn--bbf", .status = 6} /* 2785 */,
    {.source = (const lxb_char_t *) "xn--c8e..xn--bbf", .ascii = (const lxb_char_t *) "xn--c8e..xn--bbf", .status = 6} /* 2786 */,
    {.source = (const lxb_char_t *) "xn--c8e.xn--bbf9168i", .ascii = (const lxb_char_t *) "xn--c8e.xn--bbf9168i", .status = 4} /* 2787 */,
    {.source = (const lxb_char_t *) "𑋪\u1073｡𞽧", .ascii = (const lxb_char_t *) "xn--xld7443k.xn--4o7h", .status = 12} /* 2788 */,
    {.source = (const lxb_char_t *) "𑋪\u1073。𞽧", .ascii = (const lxb_char_t *) "xn--xld7443k.xn--4o7h", .status = 12} /* 2789 */,
    {.source = (const lxb_char_t *) "xn--xld7443k.xn--4o7h", .ascii = (const lxb_char_t *) "xn--xld7443k.xn--4o7h", .status = 12} /* 2790 */,
    {.source = (const lxb_char_t *) "𞷏。ᠢ򓘆", .ascii = (const lxb_char_t *) "xn--hd7h.xn--46e66060j", .status = 4} /* 2791 */,
    {.source = (const lxb_char_t *) "xn--hd7h.xn--46e66060j", .ascii = (const lxb_char_t *) "xn--hd7h.xn--46e66060j", .status = 4} /* 2792 */,
    {.source = (const lxb_char_t *) "𑄳㴼．\u200C𐹡\u20EB񫺦", .ascii = (const lxb_char_t *) "xn--iym9428c.xn--0ug46a7218cllv0c", .status = 16} /* 2793 */,
    {.source = (const lxb_char_t *) "𑄳㴼.\u200C𐹡\u20EB񫺦", .ascii = (const lxb_char_t *) "xn--iym9428c.xn--0ug46a7218cllv0c", .status = 16} /* 2794 */,
    {.source = (const lxb_char_t *) "xn--iym9428c.xn--e1g3464g08p3b", .ascii = (const lxb_char_t *) "xn--iym9428c.xn--e1g3464g08p3b", .status = 12} /* 2795 */,
    {.source = (const lxb_char_t *) "xn--iym9428c.xn--0ug46a7218cllv0c", .ascii = (const lxb_char_t *) "xn--iym9428c.xn--0ug46a7218cllv0c", .status = 16} /* 2796 */,
    {.source = (const lxb_char_t *) "񠻟𐹳𑈯｡\u031D", .ascii = (const lxb_char_t *) "xn--ro0dw7dey96m.xn--eta", .status = 20} /* 2797 */,
    {.source = (const lxb_char_t *) "񠻟𐹳𑈯。\u031D", .ascii = (const lxb_char_t *) "xn--ro0dw7dey96m.xn--eta", .status = 20} /* 2798 */,
    {.source = (const lxb_char_t *) "xn--ro0dw7dey96m.xn--eta", .ascii = (const lxb_char_t *) "xn--ro0dw7dey96m.xn--eta", .status = 20} /* 2799 */,
    {.source = (const lxb_char_t *) "ᢊ뾜󠱴𑚶。\u089D𐹥", .ascii = (const lxb_char_t *) "xn--39e4566fjv8bwmt6n.xn--myb6415k", .status = 12} /* 2800 */,
    {.source = (const lxb_char_t *) "ᢊ뾜󠱴𑚶。\u089D𐹥", .ascii = (const lxb_char_t *) "xn--39e4566fjv8bwmt6n.xn--myb6415k", .status = 12} /* 2801 */,
    {.source = (const lxb_char_t *) "xn--39e4566fjv8bwmt6n.xn--myb6415k", .ascii = (const lxb_char_t *) "xn--39e4566fjv8bwmt6n.xn--myb6415k", .status = 12} /* 2802 */,
    {.source = (const lxb_char_t *) "𐹥≠｡𐋲󠧠\u200C", .ascii = (const lxb_char_t *) "xn--1ch6704g.xn--0ug3840g51u4g", .status = 12} /* 2803 */,
    {.source = (const lxb_char_t *) "𐹥=\u0338｡𐋲󠧠\u200C", .ascii = (const lxb_char_t *) "xn--1ch6704g.xn--0ug3840g51u4g", .status = 12} /* 2804 */,
    {.source = (const lxb_char_t *) "𐹥≠。𐋲󠧠\u200C", .ascii = (const lxb_char_t *) "xn--1ch6704g.xn--0ug3840g51u4g", .status = 12} /* 2805 */,
    {.source = (const lxb_char_t *) "𐹥=\u0338。𐋲󠧠\u200C", .ascii = (const lxb_char_t *) "xn--1ch6704g.xn--0ug3840g51u4g", .status = 12} /* 2806 */,
    {.source = (const lxb_char_t *) "xn--1ch6704g.xn--m97cw2999c", .ascii = (const lxb_char_t *) "xn--1ch6704g.xn--m97cw2999c", .status = 8} /* 2807 */,
    {.source = (const lxb_char_t *) "xn--1ch6704g.xn--0ug3840g51u4g", .ascii = (const lxb_char_t *) "xn--1ch6704g.xn--0ug3840g51u4g", .status = 12} /* 2808 */,
    {.source = (const lxb_char_t *) "\u115F񙯠\u094D．\u200D\uA953𐪤", .ascii = (const lxb_char_t *) "xn--n3b542bb085j.xn--1ug6815co9wc", .status = 12} /* 2809 */,
    {.source = (const lxb_char_t *) "\u115F񙯠\u094D.\u200D\uA953𐪤", .ascii = (const lxb_char_t *) "xn--n3b542bb085j.xn--1ug6815co9wc", .status = 12} /* 2810 */,
    {.source = (const lxb_char_t *) "xn--n3b542bb085j.xn--3j9al95p", .ascii = (const lxb_char_t *) "xn--n3b542bb085j.xn--3j9al95p", .status = 16} /* 2811 */,
    {.source = (const lxb_char_t *) "xn--n3b542bb085j.xn--1ug6815co9wc", .ascii = (const lxb_char_t *) "xn--n3b542bb085j.xn--1ug6815co9wc", .status = 12} /* 2812 */,
    {.source = (const lxb_char_t *) "򌋔󠆎󠆗𑲕。≮", .ascii = (const lxb_char_t *) "xn--4m3dv4354a.xn--gdh", .status = 4} /* 2813 */,
    {.source = (const lxb_char_t *) "򌋔󠆎󠆗𑲕。<\u0338", .ascii = (const lxb_char_t *) "xn--4m3dv4354a.xn--gdh", .status = 4} /* 2814 */,
    {.source = (const lxb_char_t *) "xn--4m3dv4354a.xn--gdh", .ascii = (const lxb_char_t *) "xn--4m3dv4354a.xn--gdh", .status = 4} /* 2815 */,
    {.source = (const lxb_char_t *) "󠆦.\u08E3暀≠", .ascii = (const lxb_char_t *) ".xn--m0b461k3g2c", .status = 10} /* 2816 */,
    {.source = (const lxb_char_t *) "󠆦.\u08E3暀=\u0338", .ascii = (const lxb_char_t *) ".xn--m0b461k3g2c", .status = 10} /* 2817 */,
    {.source = (const lxb_char_t *) ".xn--m0b461k3g2c", .ascii = (const lxb_char_t *) ".xn--m0b461k3g2c", .status = 10} /* 2818 */,
    {.source = (const lxb_char_t *) "𐡤\uABED｡\uFD30򜖅\u1DF0", .ascii = (const lxb_char_t *) "xn--429ak76o.xn--zgb8a701kox37t", .status = 12} /* 2819 */,
    {.source = (const lxb_char_t *) "𐡤\uABED。\u0634\u0645򜖅\u1DF0", .ascii = (const lxb_char_t *) "xn--429ak76o.xn--zgb8a701kox37t", .status = 12} /* 2820 */,
    {.source = (const lxb_char_t *) "xn--429ak76o.xn--zgb8a701kox37t", .ascii = (const lxb_char_t *) "xn--429ak76o.xn--zgb8a701kox37t", .status = 12} /* 2821 */,
    {.source = (const lxb_char_t *) "𝉃\u200D⒈｡Ⴌ𞱓", .ascii = (const lxb_char_t *) "xn--1ug68oq348b.xn--knd8464v", .status = 24} /* 2822 */,
    {.source = (const lxb_char_t *) "𝉃\u200D1.。Ⴌ𞱓", .ascii = (const lxb_char_t *) "xn--1-tgn9827q..xn--knd8464v", .status = 30} /* 2823 */,
    {.source = (const lxb_char_t *) "𝉃\u200D1.。ⴌ𞱓", .ascii = (const lxb_char_t *) "xn--1-tgn9827q..xn--3kj4524l", .status = 30} /* 2824 */,
    {.source = (const lxb_char_t *) "xn--1-px8q..xn--3kj4524l", .ascii = (const lxb_char_t *) "xn--1-px8q..xn--3kj4524l", .status = 26} /* 2825 */,
    {.source = (const lxb_char_t *) "xn--1-tgn9827q..xn--3kj4524l", .ascii = (const lxb_char_t *) "xn--1-tgn9827q..xn--3kj4524l", .status = 30} /* 2826 */,
    {.source = (const lxb_char_t *) "xn--1-px8q..xn--knd8464v", .ascii = (const lxb_char_t *) "xn--1-px8q..xn--knd8464v", .status = 26} /* 2827 */,
    {.source = (const lxb_char_t *) "xn--1-tgn9827q..xn--knd8464v", .ascii = (const lxb_char_t *) "xn--1-tgn9827q..xn--knd8464v", .status = 30} /* 2828 */,
    {.source = (const lxb_char_t *) "𝉃\u200D⒈｡ⴌ𞱓", .ascii = (const lxb_char_t *) "xn--1ug68oq348b.xn--3kj4524l", .status = 24} /* 2829 */,
    {.source = (const lxb_char_t *) "xn--tshz828m.xn--3kj4524l", .ascii = (const lxb_char_t *) "xn--tshz828m.xn--3kj4524l", .status = 20} /* 2830 */,
    {.source = (const lxb_char_t *) "xn--1ug68oq348b.xn--3kj4524l", .ascii = (const lxb_char_t *) "xn--1ug68oq348b.xn--3kj4524l", .status = 24} /* 2831 */,
    {.source = (const lxb_char_t *) "xn--tshz828m.xn--knd8464v", .ascii = (const lxb_char_t *) "xn--tshz828m.xn--knd8464v", .status = 20} /* 2832 */,
    {.source = (const lxb_char_t *) "xn--1ug68oq348b.xn--knd8464v", .ascii = (const lxb_char_t *) "xn--1ug68oq348b.xn--knd8464v", .status = 24} /* 2833 */,
    {.source = (const lxb_char_t *) "󠣙\u0A4D𱫘𞤸.ς񵯞􈰔", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b", .status = 8} /* 2834 */,
    {.source = (const lxb_char_t *) "󠣙\u0A4D𱫘𞤖.Σ񵯞􈰔", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", .status = 8} /* 2835 */,
    {.source = (const lxb_char_t *) "󠣙\u0A4D𱫘𞤸.σ񵯞􈰔", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", .status = 8} /* 2836 */,
    {.source = (const lxb_char_t *) "󠣙\u0A4D𱫘𞤖.σ񵯞􈰔", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", .status = 8} /* 2837 */,
    {.source = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", .status = 8} /* 2838 */,
    {.source = (const lxb_char_t *) "󠣙\u0A4D𱫘𞤖.ς񵯞􈰔", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b", .status = 8} /* 2839 */,
    {.source = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--3xa03737giye6b", .status = 8} /* 2840 */,
    {.source = (const lxb_char_t *) "󠣙\u0A4D𱫘𞤸.Σ񵯞􈰔", .ascii = (const lxb_char_t *) "xn--ybc0236vjvxgt5q0g.xn--4xa82737giye6b", .status = 8} /* 2841 */,
    {.source = (const lxb_char_t *) "\u07D3。\u200C𐫀򞭱", .ascii = (const lxb_char_t *) "xn--usb.xn--0ug9553gm3v5d", .status = 12} /* 2842 */,
    {.source = (const lxb_char_t *) "xn--usb.xn--pw9ci1099a", .ascii = (const lxb_char_t *) "xn--usb.xn--pw9ci1099a", .status = 12} /* 2843 */,
    {.source = (const lxb_char_t *) "xn--usb.xn--0ug9553gm3v5d", .ascii = (const lxb_char_t *) "xn--usb.xn--0ug9553gm3v5d", .status = 12} /* 2844 */,
    {.source = (const lxb_char_t *) "\u1C2E𞀝.\u05A6ꡟ𞤕󠆖", .ascii = (const lxb_char_t *) "xn--q1f4493q.xn--xcb8244fifvj", .status = 8} /* 2845 */,
    {.source = (const lxb_char_t *) "\u1C2E𞀝.\u05A6ꡟ𞤷󠆖", .ascii = (const lxb_char_t *) "xn--q1f4493q.xn--xcb8244fifvj", .status = 8} /* 2846 */,
    {.source = (const lxb_char_t *) "xn--q1f4493q.xn--xcb8244fifvj", .ascii = (const lxb_char_t *) "xn--q1f4493q.xn--xcb8244fifvj", .status = 8} /* 2847 */,
    {.source = (const lxb_char_t *) "䂹󾖅𐋦．\u200D", .ascii = (const lxb_char_t *) "xn--0on3543c5981i.xn--1ug", .status = 8} /* 2848 */,
    {.source = (const lxb_char_t *) "䂹󾖅𐋦.\u200D", .ascii = (const lxb_char_t *) "xn--0on3543c5981i.xn--1ug", .status = 8} /* 2849 */,
    {.source = (const lxb_char_t *) "xn--0on3543c5981i.", .ascii = (const lxb_char_t *) "xn--0on3543c5981i.", .status = 4} /* 2850 */,
    {.source = (const lxb_char_t *) "xn--0on3543c5981i.xn--1ug", .ascii = (const lxb_char_t *) "xn--0on3543c5981i.xn--1ug", .status = 8} /* 2851 */,
    {.source = (const lxb_char_t *) "\uA9C0\u200C𐹲\u200C｡\u0767🄉", .ascii = (const lxb_char_t *) "xn--0uga8686hdgvd.xn--rpb6081w", .status = 20} /* 2852 */,
    {.source = (const lxb_char_t *) "\uA9C0\u200C𐹲\u200C。\u07678,", .ascii = (const lxb_char_t *) "xn--0uga8686hdgvd.xn--8,-qle", .status = 24} /* 2853 */,
    {.source = (const lxb_char_t *) "xn--7m9an32q.xn--8,-qle", .ascii = (const lxb_char_t *) "xn--7m9an32q.xn--8,-qle", .status = 20} /* 2854 */,
    {.source = (const lxb_char_t *) "xn--0uga8686hdgvd.xn--8,-qle", .ascii = (const lxb_char_t *) "xn--0uga8686hdgvd.xn--8,-qle", .status = 24} /* 2855 */,
    {.source = (const lxb_char_t *) "xn--7m9an32q.xn--rpb6081w", .ascii = (const lxb_char_t *) "xn--7m9an32q.xn--rpb6081w", .status = 16} /* 2856 */,
    {.source = (const lxb_char_t *) "xn--0uga8686hdgvd.xn--rpb6081w", .ascii = (const lxb_char_t *) "xn--0uga8686hdgvd.xn--rpb6081w", .status = 20} /* 2857 */,
    {.source = (const lxb_char_t *) "︒｡Ⴃ≯", .ascii = (const lxb_char_t *) "xn--y86c.xn--bnd622g", .status = 4} /* 2858 */,
    {.source = (const lxb_char_t *) "︒｡Ⴃ>\u0338", .ascii = (const lxb_char_t *) "xn--y86c.xn--bnd622g", .status = 4} /* 2859 */,
    {.source = (const lxb_char_t *) "。。Ⴃ≯", .ascii = (const lxb_char_t *) "..xn--bnd622g", .status = 10} /* 2860 */,
    {.source = (const lxb_char_t *) "。。Ⴃ>\u0338", .ascii = (const lxb_char_t *) "..xn--bnd622g", .status = 10} /* 2861 */,
    {.source = (const lxb_char_t *) "。。ⴃ>\u0338", .ascii = (const lxb_char_t *) "..xn--hdh782b", .status = 6} /* 2862 */,
    {.source = (const lxb_char_t *) "。。ⴃ≯", .ascii = (const lxb_char_t *) "..xn--hdh782b", .status = 6} /* 2863 */,
    {.source = (const lxb_char_t *) "..xn--hdh782b", .ascii = (const lxb_char_t *) "..xn--hdh782b", .status = 6} /* 2864 */,
    {.source = (const lxb_char_t *) "..xn--bnd622g", .ascii = (const lxb_char_t *) "..xn--bnd622g", .status = 10} /* 2865 */,
    {.source = (const lxb_char_t *) "︒｡ⴃ>\u0338", .ascii = (const lxb_char_t *) "xn--y86c.xn--hdh782b", .status = 4} /* 2866 */,
    {.source = (const lxb_char_t *) "︒｡ⴃ≯", .ascii = (const lxb_char_t *) "xn--y86c.xn--hdh782b", .status = 4} /* 2867 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--hdh782b", .ascii = (const lxb_char_t *) "xn--y86c.xn--hdh782b", .status = 4} /* 2868 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--bnd622g", .ascii = (const lxb_char_t *) "xn--y86c.xn--bnd622g", .status = 4} /* 2869 */,
    {.source = (const lxb_char_t *) "𐹮｡󠢼\u200D", .ascii = (const lxb_char_t *) "xn--mo0d.xn--1ug18431l", .status = 12} /* 2870 */,
    {.source = (const lxb_char_t *) "𐹮。󠢼\u200D", .ascii = (const lxb_char_t *) "xn--mo0d.xn--1ug18431l", .status = 12} /* 2871 */,
    {.source = (const lxb_char_t *) "xn--mo0d.xn--wy46e", .ascii = (const lxb_char_t *) "xn--mo0d.xn--wy46e", .status = 8} /* 2872 */,
    {.source = (const lxb_char_t *) "xn--mo0d.xn--1ug18431l", .ascii = (const lxb_char_t *) "xn--mo0d.xn--1ug18431l", .status = 12} /* 2873 */,
    {.source = (const lxb_char_t *) "Ⴞ𐹨｡︒\u077D\u200DႯ", .ascii = (const lxb_char_t *) "xn--2nd0990k.xn--eqb228bgzmvp0t", .status = 20} /* 2874 */,
    {.source = (const lxb_char_t *) "Ⴞ𐹨。。\u077D\u200DႯ", .ascii = (const lxb_char_t *) "xn--2nd0990k..xn--eqb228bgzm", .status = 30} /* 2875 */,
    {.source = (const lxb_char_t *) "ⴞ𐹨。。\u077D\u200Dⴏ", .ascii = (const lxb_char_t *) "xn--mlju223e..xn--eqb096jpgj", .status = 26} /* 2876 */,
    {.source = (const lxb_char_t *) "Ⴞ𐹨。。\u077D\u200Dⴏ", .ascii = (const lxb_char_t *) "xn--2nd0990k..xn--eqb096jpgj", .status = 30} /* 2877 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k..xn--eqb053q", .ascii = (const lxb_char_t *) "xn--2nd0990k..xn--eqb053q", .status = 26} /* 2878 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k..xn--eqb096jpgj", .ascii = (const lxb_char_t *) "xn--2nd0990k..xn--eqb096jpgj", .status = 30} /* 2879 */,
    {.source = (const lxb_char_t *) "xn--mlju223e..xn--eqb053q", .ascii = (const lxb_char_t *) "xn--mlju223e..xn--eqb053q", .status = 22} /* 2880 */,
    {.source = (const lxb_char_t *) "xn--mlju223e..xn--eqb096jpgj", .ascii = (const lxb_char_t *) "xn--mlju223e..xn--eqb096jpgj", .status = 26} /* 2881 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k..xn--eqb228b", .ascii = (const lxb_char_t *) "xn--2nd0990k..xn--eqb228b", .status = 26} /* 2882 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k..xn--eqb228bgzm", .ascii = (const lxb_char_t *) "xn--2nd0990k..xn--eqb228bgzm", .status = 30} /* 2883 */,
    {.source = (const lxb_char_t *) "ⴞ𐹨｡︒\u077D\u200Dⴏ", .ascii = (const lxb_char_t *) "xn--mlju223e.xn--eqb096jpgj9y7r", .status = 20} /* 2884 */,
    {.source = (const lxb_char_t *) "Ⴞ𐹨｡︒\u077D\u200Dⴏ", .ascii = (const lxb_char_t *) "xn--2nd0990k.xn--eqb096jpgj9y7r", .status = 20} /* 2885 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k.xn--eqb053qjk7l", .ascii = (const lxb_char_t *) "xn--2nd0990k.xn--eqb053qjk7l", .status = 16} /* 2886 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k.xn--eqb096jpgj9y7r", .ascii = (const lxb_char_t *) "xn--2nd0990k.xn--eqb096jpgj9y7r", .status = 20} /* 2887 */,
    {.source = (const lxb_char_t *) "xn--mlju223e.xn--eqb053qjk7l", .ascii = (const lxb_char_t *) "xn--mlju223e.xn--eqb053qjk7l", .status = 16} /* 2888 */,
    {.source = (const lxb_char_t *) "xn--mlju223e.xn--eqb096jpgj9y7r", .ascii = (const lxb_char_t *) "xn--mlju223e.xn--eqb096jpgj9y7r", .status = 20} /* 2889 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k.xn--eqb228b583r", .ascii = (const lxb_char_t *) "xn--2nd0990k.xn--eqb228b583r", .status = 16} /* 2890 */,
    {.source = (const lxb_char_t *) "xn--2nd0990k.xn--eqb228bgzmvp0t", .ascii = (const lxb_char_t *) "xn--2nd0990k.xn--eqb228bgzmvp0t", .status = 20} /* 2891 */,
    {.source = (const lxb_char_t *) "\u200CႦ𝟹。-\u20D2-\u07D1", .ascii = (const lxb_char_t *) "xn--3-i0g939i.xn-----vue617w", .status = 16} /* 2892 */,
    {.source = (const lxb_char_t *) "\u200CႦ3。-\u20D2-\u07D1", .ascii = (const lxb_char_t *) "xn--3-i0g939i.xn-----vue617w", .status = 16} /* 2893 */,
    {.source = (const lxb_char_t *) "\u200Cⴆ3。-\u20D2-\u07D1", .ascii = (const lxb_char_t *) "xn--3-rgnv99c.xn-----vue617w", .status = 12} /* 2894 */,
    {.source = (const lxb_char_t *) "xn--3-lvs.xn-----vue617w", .ascii = (const lxb_char_t *) "xn--3-lvs.xn-----vue617w", .status = 8} /* 2895 */,
    {.source = (const lxb_char_t *) "xn--3-rgnv99c.xn-----vue617w", .ascii = (const lxb_char_t *) "xn--3-rgnv99c.xn-----vue617w", .status = 12} /* 2896 */,
    {.source = (const lxb_char_t *) "xn--3-i0g.xn-----vue617w", .ascii = (const lxb_char_t *) "xn--3-i0g.xn-----vue617w", .status = 12} /* 2897 */,
    {.source = (const lxb_char_t *) "xn--3-i0g939i.xn-----vue617w", .ascii = (const lxb_char_t *) "xn--3-i0g939i.xn-----vue617w", .status = 16} /* 2898 */,
    {.source = (const lxb_char_t *) "\u200Cⴆ𝟹。-\u20D2-\u07D1", .ascii = (const lxb_char_t *) "xn--3-rgnv99c.xn-----vue617w", .status = 12} /* 2899 */,
    {.source = (const lxb_char_t *) "箃Ⴡ-󠁝｡≠-🤖", .ascii = (const lxb_char_t *) "xn----11g3013fy8x5m.xn----tfot873s", .status = 4} /* 2900 */,
    {.source = (const lxb_char_t *) "箃Ⴡ-󠁝｡=\u0338-🤖", .ascii = (const lxb_char_t *) "xn----11g3013fy8x5m.xn----tfot873s", .status = 4} /* 2901 */,
    {.source = (const lxb_char_t *) "箃Ⴡ-󠁝。≠-🤖", .ascii = (const lxb_char_t *) "xn----11g3013fy8x5m.xn----tfot873s", .status = 4} /* 2902 */,
    {.source = (const lxb_char_t *) "箃Ⴡ-󠁝。=\u0338-🤖", .ascii = (const lxb_char_t *) "xn----11g3013fy8x5m.xn----tfot873s", .status = 4} /* 2903 */,
    {.source = (const lxb_char_t *) "箃ⴡ-󠁝。=\u0338-🤖", .ascii = (const lxb_char_t *) "xn----4wsr321ay823p.xn----tfot873s", .status = 4} /* 2904 */,
    {.source = (const lxb_char_t *) "箃ⴡ-󠁝。≠-🤖", .ascii = (const lxb_char_t *) "xn----4wsr321ay823p.xn----tfot873s", .status = 4} /* 2905 */,
    {.source = (const lxb_char_t *) "xn----4wsr321ay823p.xn----tfot873s", .ascii = (const lxb_char_t *) "xn----4wsr321ay823p.xn----tfot873s", .status = 4} /* 2906 */,
    {.source = (const lxb_char_t *) "xn----11g3013fy8x5m.xn----tfot873s", .ascii = (const lxb_char_t *) "xn----11g3013fy8x5m.xn----tfot873s", .status = 4} /* 2907 */,
    {.source = (const lxb_char_t *) "箃ⴡ-󠁝｡=\u0338-🤖", .ascii = (const lxb_char_t *) "xn----4wsr321ay823p.xn----tfot873s", .status = 4} /* 2908 */,
    {.source = (const lxb_char_t *) "箃ⴡ-󠁝｡≠-🤖", .ascii = (const lxb_char_t *) "xn----4wsr321ay823p.xn----tfot873s", .status = 4} /* 2909 */,
    {.source = (const lxb_char_t *) "\u07E5.\u06B5", .ascii = (const lxb_char_t *) "xn--dtb.xn--okb", .status = 0} /* 2910 */,
    {.source = (const lxb_char_t *) "xn--dtb.xn--okb", .ascii = (const lxb_char_t *) "xn--dtb.xn--okb", .status = 0} /* 2911 */,
    {.source = (const lxb_char_t *) "\u200C\u200D.𞤿", .ascii = (const lxb_char_t *) "xn--0ugc.xn--3e6h", .status = 12} /* 2912 */,
    {.source = (const lxb_char_t *) "\u200C\u200D.𞤝", .ascii = (const lxb_char_t *) "xn--0ugc.xn--3e6h", .status = 12} /* 2913 */,
    {.source = (const lxb_char_t *) ".xn--3e6h", .ascii = (const lxb_char_t *) ".xn--3e6h", .status = 6} /* 2914 */,
    {.source = (const lxb_char_t *) "xn--0ugc.xn--3e6h", .ascii = (const lxb_char_t *) "xn--0ugc.xn--3e6h", .status = 12} /* 2915 */,
    {.source = (const lxb_char_t *) "xn--3e6h", .ascii = (const lxb_char_t *) "xn--3e6h", .status = 0} /* 2916 */,
    {.source = (const lxb_char_t *) "𞤿", .ascii = (const lxb_char_t *) "xn--3e6h", .status = 0} /* 2917 */,
    {.source = (const lxb_char_t *) "𞤝", .ascii = (const lxb_char_t *) "xn--3e6h", .status = 0} /* 2918 */,
    {.source = (const lxb_char_t *) "🜑𐹧\u0639.ς𑍍蜹", .ascii = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--3xa4248dy27d", .status = 4} /* 2919 */,
    {.source = (const lxb_char_t *) "🜑𐹧\u0639.Σ𑍍蜹", .ascii = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--4xa2248dy27d", .status = 4} /* 2920 */,
    {.source = (const lxb_char_t *) "🜑𐹧\u0639.σ𑍍蜹", .ascii = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--4xa2248dy27d", .status = 4} /* 2921 */,
    {.source = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--4xa2248dy27d", .ascii = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--4xa2248dy27d", .status = 4} /* 2922 */,
    {.source = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--3xa4248dy27d", .ascii = (const lxb_char_t *) "xn--4gb3736kk4zf.xn--3xa4248dy27d", .status = 4} /* 2923 */,
    {.source = (const lxb_char_t *) "򫠐ス􆟤\u0669．󚃟", .ascii = (const lxb_char_t *) "xn--iib777sp230oo708a.xn--7824e", .status = 12} /* 2924 */,
    {.source = (const lxb_char_t *) "򫠐ス􆟤\u0669.󚃟", .ascii = (const lxb_char_t *) "xn--iib777sp230oo708a.xn--7824e", .status = 12} /* 2925 */,
    {.source = (const lxb_char_t *) "xn--iib777sp230oo708a.xn--7824e", .ascii = (const lxb_char_t *) "xn--iib777sp230oo708a.xn--7824e", .status = 12} /* 2926 */,
    {.source = (const lxb_char_t *) "𝪣򕡝．\u059A?\u06C2", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2927 */,
    {.source = (const lxb_char_t *) "𝪣򕡝．\u059A?\u06C1\u0654", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2928 */,
    {.source = (const lxb_char_t *) "𝪣򕡝.\u059A?\u06C2", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2929 */,
    {.source = (const lxb_char_t *) "𝪣򕡝.\u059A?\u06C1\u0654", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2930 */,
    {.source = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2931 */,
    {.source = (const lxb_char_t *) "xn--8c3hu7971a.\u059A?\u06C2", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2932 */,
    {.source = (const lxb_char_t *) "xn--8c3hu7971a.\u059A?\u06C1\u0654", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2933 */,
    {.source = (const lxb_char_t *) "XN--8C3HU7971A.\u059A?\u06C1\u0654", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2934 */,
    {.source = (const lxb_char_t *) "XN--8C3HU7971A.\u059A?\u06C2", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2935 */,
    {.source = (const lxb_char_t *) "Xn--8c3hu7971a.\u059A?\u06C2", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2936 */,
    {.source = (const lxb_char_t *) "Xn--8c3hu7971a.\u059A?\u06C1\u0654", .ascii = (const lxb_char_t *) "xn--8c3hu7971a.xn--?-wec30g", .status = 12} /* 2937 */,
    {.source = (const lxb_char_t *) "\u0660򪓵\u200C。\u0757", .ascii = (const lxb_char_t *) "xn--8hb852ke991q.xn--bpb", .status = 12} /* 2938 */,
    {.source = (const lxb_char_t *) "xn--8hb82030l.xn--bpb", .ascii = (const lxb_char_t *) "xn--8hb82030l.xn--bpb", .status = 8} /* 2939 */,
    {.source = (const lxb_char_t *) "xn--8hb852ke991q.xn--bpb", .ascii = (const lxb_char_t *) "xn--8hb852ke991q.xn--bpb", .status = 12} /* 2940 */,
    {.source = (const lxb_char_t *) "\u103A\u200D\u200C。-\u200C", .ascii = (const lxb_char_t *) "xn--bkd412fca.xn----sgn", .status = 12} /* 2941 */,
    {.source = (const lxb_char_t *) "xn--bkd.-", .ascii = (const lxb_char_t *) "xn--bkd.-", .status = 8} /* 2942 */,
    {.source = (const lxb_char_t *) "xn--bkd412fca.xn----sgn", .ascii = (const lxb_char_t *) "xn--bkd412fca.xn----sgn", .status = 12} /* 2943 */,
    {.source = (const lxb_char_t *) "︒｡\u1B44ᡉ", .ascii = (const lxb_char_t *) "xn--y86c.xn--87e93m", .status = 8} /* 2944 */,
    {.source = (const lxb_char_t *) "。。\u1B44ᡉ", .ascii = (const lxb_char_t *) "..xn--87e93m", .status = 10} /* 2945 */,
    {.source = (const lxb_char_t *) "..xn--87e93m", .ascii = (const lxb_char_t *) "..xn--87e93m", .status = 10} /* 2946 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--87e93m", .ascii = (const lxb_char_t *) "xn--y86c.xn--87e93m", .status = 8} /* 2947 */,
    {.source = (const lxb_char_t *) "\u0758ß。ጫᢊ\u0768𝟐", .ascii = (const lxb_char_t *) "xn--zca724a.xn--2-b5c641gfmf", .status = 12} /* 2948 */,
    {.source = (const lxb_char_t *) "\u0758ß。ጫᢊ\u07682", .ascii = (const lxb_char_t *) "xn--zca724a.xn--2-b5c641gfmf", .status = 12} /* 2949 */,
    {.source = (const lxb_char_t *) "\u0758SS。ጫᢊ\u07682", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2950 */,
    {.source = (const lxb_char_t *) "\u0758ss。ጫᢊ\u07682", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2951 */,
    {.source = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2952 */,
    {.source = (const lxb_char_t *) "xn--zca724a.xn--2-b5c641gfmf", .ascii = (const lxb_char_t *) "xn--zca724a.xn--2-b5c641gfmf", .status = 12} /* 2953 */,
    {.source = (const lxb_char_t *) "\u0758SS。ጫᢊ\u0768𝟐", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2954 */,
    {.source = (const lxb_char_t *) "\u0758ss。ጫᢊ\u0768𝟐", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2955 */,
    {.source = (const lxb_char_t *) "\u0758Ss。ጫᢊ\u07682", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2956 */,
    {.source = (const lxb_char_t *) "\u0758Ss。ጫᢊ\u0768𝟐", .ascii = (const lxb_char_t *) "xn--ss-gke.xn--2-b5c641gfmf", .status = 12} /* 2957 */,
    {.source = (const lxb_char_t *) "\u07C3𞶇ᚲ.\u0902\u0353𝟚\u09CD", .ascii = (const lxb_char_t *) "xn--esb067enh07a.xn--2-lgb874bjxa", .status = 20} /* 2958 */,
    {.source = (const lxb_char_t *) "\u07C3𞶇ᚲ.\u0902\u03532\u09CD", .ascii = (const lxb_char_t *) "xn--esb067enh07a.xn--2-lgb874bjxa", .status = 20} /* 2959 */,
    {.source = (const lxb_char_t *) "xn--esb067enh07a.xn--2-lgb874bjxa", .ascii = (const lxb_char_t *) "xn--esb067enh07a.xn--2-lgb874bjxa", .status = 20} /* 2960 */,
    {.source = (const lxb_char_t *) "-\u1BAB︒\u200D.񒶈񥹓", .ascii = (const lxb_char_t *) "xn----qmlv7tw180a.xn--x50zy803a", .status = 12} /* 2961 */,
    {.source = (const lxb_char_t *) "-\u1BAB。\u200D.񒶈񥹓", .ascii = (const lxb_char_t *) "xn----qml.xn--1ug.xn--x50zy803a", .status = 12} /* 2962 */,
    {.source = (const lxb_char_t *) "xn----qml..xn--x50zy803a", .ascii = (const lxb_char_t *) "xn----qml..xn--x50zy803a", .status = 14} /* 2963 */,
    {.source = (const lxb_char_t *) "xn----qml.xn--1ug.xn--x50zy803a", .ascii = (const lxb_char_t *) "xn----qml.xn--1ug.xn--x50zy803a", .status = 12} /* 2964 */,
    {.source = (const lxb_char_t *) "xn----qml1407i.xn--x50zy803a", .ascii = (const lxb_char_t *) "xn----qml1407i.xn--x50zy803a", .status = 8} /* 2965 */,
    {.source = (const lxb_char_t *) "xn----qmlv7tw180a.xn--x50zy803a", .ascii = (const lxb_char_t *) "xn----qmlv7tw180a.xn--x50zy803a", .status = 12} /* 2966 */,
    {.source = (const lxb_char_t *) "󠦮.≯𞀆", .ascii = (const lxb_char_t *) "xn--t546e.xn--hdh5166o", .status = 4} /* 2967 */,
    {.source = (const lxb_char_t *) "󠦮.>\u0338𞀆", .ascii = (const lxb_char_t *) "xn--t546e.xn--hdh5166o", .status = 4} /* 2968 */,
    {.source = (const lxb_char_t *) "xn--t546e.xn--hdh5166o", .ascii = (const lxb_char_t *) "xn--t546e.xn--hdh5166o", .status = 4} /* 2969 */,
    {.source = (const lxb_char_t *) "-𑄳󠊗𐹩。𞮱", .ascii = (const lxb_char_t *) "xn----p26i72em2894c.xn--zw6h", .status = 12} /* 2970 */,
    {.source = (const lxb_char_t *) "xn----p26i72em2894c.xn--zw6h", .ascii = (const lxb_char_t *) "xn----p26i72em2894c.xn--zw6h", .status = 12} /* 2971 */,
    {.source = (const lxb_char_t *) "\u06B9．ᡳ\u115F", .ascii = (const lxb_char_t *) "xn--skb.xn--osd737a", .status = 4} /* 2972 */,
    {.source = (const lxb_char_t *) "\u06B9.ᡳ\u115F", .ascii = (const lxb_char_t *) "xn--skb.xn--osd737a", .status = 4} /* 2973 */,
    {.source = (const lxb_char_t *) "xn--skb.xn--osd737a", .ascii = (const lxb_char_t *) "xn--skb.xn--osd737a", .status = 4} /* 2974 */,
    {.source = (const lxb_char_t *) "㨛𘱎.︒𝟕\u0D01", .ascii = (const lxb_char_t *) "xn--mbm8237g.xn--7-7hf1526p", .status = 4} /* 2975 */,
    {.source = (const lxb_char_t *) "㨛𘱎.。7\u0D01", .ascii = (const lxb_char_t *) "xn--mbm8237g..xn--7-7hf", .status = 6} /* 2976 */,
    {.source = (const lxb_char_t *) "xn--mbm8237g..xn--7-7hf", .ascii = (const lxb_char_t *) "xn--mbm8237g..xn--7-7hf", .status = 6} /* 2977 */,
    {.source = (const lxb_char_t *) "xn--mbm8237g.xn--7-7hf1526p", .ascii = (const lxb_char_t *) "xn--mbm8237g.xn--7-7hf1526p", .status = 4} /* 2978 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-｡𞷁\u2064𞤣≮", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2979 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-｡𞷁\u2064𞤣<\u0338", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2980 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-。𞷁\u2064𞤣≮", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2981 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-。𞷁\u2064𞤣<\u0338", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2982 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-。𞷁\u2064𞤁<\u0338", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2983 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-。𞷁\u2064𞤁≮", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2984 */,
    {.source = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2985 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-｡𞷁\u2064𞤁<\u0338", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2986 */,
    {.source = (const lxb_char_t *) "\u06DD𻱧-｡𞷁\u2064𞤁≮", .ascii = (const lxb_char_t *) "xn----dxc06304e.xn--gdh5020pk5c", .status = 16} /* 2987 */,
    {.source = (const lxb_char_t *) "ß\u200C\uAAF6ᢥ．⊶ჁႶ", .ascii = (const lxb_char_t *) "xn--zca682johfi89m.xn--undv409k", .status = 8} /* 2988 */,
    {.source = (const lxb_char_t *) "ß\u200C\uAAF6ᢥ.⊶ჁႶ", .ascii = (const lxb_char_t *) "xn--zca682johfi89m.xn--undv409k", .status = 8} /* 2989 */,
    {.source = (const lxb_char_t *) "ß\u200C\uAAF6ᢥ.⊶ⴡⴖ", .ascii = (const lxb_char_t *) "xn--zca682johfi89m.xn--ifh802b6a", .status = 4} /* 2990 */,
    {.source = (const lxb_char_t *) "SS\u200C\uAAF6ᢥ.⊶ჁႶ", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--undv409k", .status = 8} /* 2991 */,
    {.source = (const lxb_char_t *) "ss\u200C\uAAF6ᢥ.⊶ⴡⴖ", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--ifh802b6a", .status = 4} /* 2992 */,
    {.source = (const lxb_char_t *) "Ss\u200C\uAAF6ᢥ.⊶Ⴡⴖ", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--5nd703gyrh", .status = 8} /* 2993 */,
    {.source = (const lxb_char_t *) "xn--ss-4epx629f.xn--5nd703gyrh", .ascii = (const lxb_char_t *) "xn--ss-4epx629f.xn--5nd703gyrh", .status = 4} /* 2994 */,
    {.source = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--5nd703gyrh", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--5nd703gyrh", .status = 8} /* 2995 */,
    {.source = (const lxb_char_t *) "xn--ss-4epx629f.xn--ifh802b6a", .ascii = (const lxb_char_t *) "xn--ss-4epx629f.xn--ifh802b6a", .status = 0} /* 2996 */,
    {.source = (const lxb_char_t *) "ss\uAAF6ᢥ.⊶ⴡⴖ", .ascii = (const lxb_char_t *) "xn--ss-4epx629f.xn--ifh802b6a", .status = 0} /* 2997 */,
    {.source = (const lxb_char_t *) "SS\uAAF6ᢥ.⊶ჁႶ", .ascii = (const lxb_char_t *) "xn--ss-4epx629f.xn--undv409k", .status = 4} /* 2998 */,
    {.source = (const lxb_char_t *) "Ss\uAAF6ᢥ.⊶Ⴡⴖ", .ascii = (const lxb_char_t *) "xn--ss-4epx629f.xn--5nd703gyrh", .status = 4} /* 2999 */,
    {.source = (const lxb_char_t *) "xn--ss-4epx629f.xn--undv409k", .ascii = (const lxb_char_t *) "xn--ss-4epx629f.xn--undv409k", .status = 4} /* 3000 */,
    {.source = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--ifh802b6a", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--ifh802b6a", .status = 4} /* 3001 */,
    {.source = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--undv409k", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--undv409k", .status = 8} /* 3002 */,
    {.source = (const lxb_char_t *) "xn--zca682johfi89m.xn--ifh802b6a", .ascii = (const lxb_char_t *) "xn--zca682johfi89m.xn--ifh802b6a", .status = 4} /* 3003 */,
    {.source = (const lxb_char_t *) "xn--zca682johfi89m.xn--undv409k", .ascii = (const lxb_char_t *) "xn--zca682johfi89m.xn--undv409k", .status = 8} /* 3004 */,
    {.source = (const lxb_char_t *) "ß\u200C\uAAF6ᢥ．⊶ⴡⴖ", .ascii = (const lxb_char_t *) "xn--zca682johfi89m.xn--ifh802b6a", .status = 4} /* 3005 */,
    {.source = (const lxb_char_t *) "SS\u200C\uAAF6ᢥ．⊶ჁႶ", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--undv409k", .status = 8} /* 3006 */,
    {.source = (const lxb_char_t *) "ss\u200C\uAAF6ᢥ．⊶ⴡⴖ", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--ifh802b6a", .status = 4} /* 3007 */,
    {.source = (const lxb_char_t *) "Ss\u200C\uAAF6ᢥ．⊶Ⴡⴖ", .ascii = (const lxb_char_t *) "xn--ss-4ep585bkm5p.xn--5nd703gyrh", .status = 8} /* 3008 */,
    {.source = (const lxb_char_t *) "\u200D。ς󠁉", .ascii = (const lxb_char_t *) "xn--1ug.xn--3xa44344p", .status = 8} /* 3009 */,
    {.source = (const lxb_char_t *) "\u200D。Σ󠁉", .ascii = (const lxb_char_t *) "xn--1ug.xn--4xa24344p", .status = 8} /* 3010 */,
    {.source = (const lxb_char_t *) "\u200D。σ󠁉", .ascii = (const lxb_char_t *) "xn--1ug.xn--4xa24344p", .status = 8} /* 3011 */,
    {.source = (const lxb_char_t *) ".xn--4xa24344p", .ascii = (const lxb_char_t *) ".xn--4xa24344p", .status = 10} /* 3012 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--4xa24344p", .ascii = (const lxb_char_t *) "xn--1ug.xn--4xa24344p", .status = 8} /* 3013 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--3xa44344p", .ascii = (const lxb_char_t *) "xn--1ug.xn--3xa44344p", .status = 8} /* 3014 */,
    {.source = (const lxb_char_t *) "𞵑ß.\u0751\u200D𞤛-", .ascii = (const lxb_char_t *) "xn--zca5423w.xn----z3c011q9513b", .status = 20} /* 3015 */,
    {.source = (const lxb_char_t *) "𞵑ß.\u0751\u200D𞤽-", .ascii = (const lxb_char_t *) "xn--zca5423w.xn----z3c011q9513b", .status = 20} /* 3016 */,
    {.source = (const lxb_char_t *) "𞵑SS.\u0751\u200D𞤛-", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .status = 20} /* 3017 */,
    {.source = (const lxb_char_t *) "𞵑ss.\u0751\u200D𞤽-", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .status = 20} /* 3018 */,
    {.source = (const lxb_char_t *) "𞵑Ss.\u0751\u200D𞤽-", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .status = 20} /* 3019 */,
    {.source = (const lxb_char_t *) "xn--ss-2722a.xn----z3c03218a", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c03218a", .status = 16} /* 3020 */,
    {.source = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .status = 20} /* 3021 */,
    {.source = (const lxb_char_t *) "xn--zca5423w.xn----z3c011q9513b", .ascii = (const lxb_char_t *) "xn--zca5423w.xn----z3c011q9513b", .status = 20} /* 3022 */,
    {.source = (const lxb_char_t *) "𞵑ss.\u0751\u200D𞤛-", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .status = 20} /* 3023 */,
    {.source = (const lxb_char_t *) "𞵑Ss.\u0751\u200D𞤛-", .ascii = (const lxb_char_t *) "xn--ss-2722a.xn----z3c011q9513b", .status = 20} /* 3024 */,
    {.source = (const lxb_char_t *) "𑘽\u200D𞤧．𐹧󡦪-", .ascii = (const lxb_char_t *) "xn--1ugz808gdimf.xn----k26iq1483f", .status = 20} /* 3025 */,
    {.source = (const lxb_char_t *) "𑘽\u200D𞤧.𐹧󡦪-", .ascii = (const lxb_char_t *) "xn--1ugz808gdimf.xn----k26iq1483f", .status = 20} /* 3026 */,
    {.source = (const lxb_char_t *) "𑘽\u200D𞤅.𐹧󡦪-", .ascii = (const lxb_char_t *) "xn--1ugz808gdimf.xn----k26iq1483f", .status = 20} /* 3027 */,
    {.source = (const lxb_char_t *) "xn--qb2ds317a.xn----k26iq1483f", .ascii = (const lxb_char_t *) "xn--qb2ds317a.xn----k26iq1483f", .status = 16} /* 3028 */,
    {.source = (const lxb_char_t *) "xn--1ugz808gdimf.xn----k26iq1483f", .ascii = (const lxb_char_t *) "xn--1ugz808gdimf.xn----k26iq1483f", .status = 20} /* 3029 */,
    {.source = (const lxb_char_t *) "𑘽\u200D𞤅．𐹧󡦪-", .ascii = (const lxb_char_t *) "xn--1ugz808gdimf.xn----k26iq1483f", .status = 20} /* 3030 */,
    {.source = (const lxb_char_t *) "⒒򨘙򳳠𑓀.-󞡊", .ascii = (const lxb_char_t *) "xn--3shy698frsu9dt1me.xn----x310m", .status = 8} /* 3031 */,
    {.source = (const lxb_char_t *) "11.򨘙򳳠𑓀.-󞡊", .ascii = (const lxb_char_t *) "11.xn--uz1d59632bxujd.xn----x310m", .status = 8} /* 3032 */,
    {.source = (const lxb_char_t *) "11.xn--uz1d59632bxujd.xn----x310m", .ascii = (const lxb_char_t *) "11.xn--uz1d59632bxujd.xn----x310m", .status = 8} /* 3033 */,
    {.source = (const lxb_char_t *) "xn--3shy698frsu9dt1me.xn----x310m", .ascii = (const lxb_char_t *) "xn--3shy698frsu9dt1me.xn----x310m", .status = 8} /* 3034 */,
    {.source = (const lxb_char_t *) "-｡\u200D", .ascii = (const lxb_char_t *) "-.xn--1ug", .status = 8} /* 3035 */,
    {.source = (const lxb_char_t *) "-。\u200D", .ascii = (const lxb_char_t *) "-.xn--1ug", .status = 8} /* 3036 */,
    {.source = (const lxb_char_t *) "-.", .ascii = (const lxb_char_t *) "-.", .status = 4} /* 3037 */,
    {.source = (const lxb_char_t *) "-.xn--1ug", .ascii = (const lxb_char_t *) "-.xn--1ug", .status = 8} /* 3038 */,
    {.source = (const lxb_char_t *) "≮ᡬ．ς¹-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3039 */,
    {.source = (const lxb_char_t *) "<\u0338ᡬ．ς¹-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3040 */,
    {.source = (const lxb_char_t *) "≮ᡬ.ς1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3041 */,
    {.source = (const lxb_char_t *) "<\u0338ᡬ.ς1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3042 */,
    {.source = (const lxb_char_t *) "<\u0338ᡬ.Σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3043 */,
    {.source = (const lxb_char_t *) "≮ᡬ.Σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3044 */,
    {.source = (const lxb_char_t *) "≮ᡬ.σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3045 */,
    {.source = (const lxb_char_t *) "<\u0338ᡬ.σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3046 */,
    {.source = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3047 */,
    {.source = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3048 */,
    {.source = (const lxb_char_t *) "<\u0338ᡬ．Σ¹-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3049 */,
    {.source = (const lxb_char_t *) "≮ᡬ．Σ¹-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3050 */,
    {.source = (const lxb_char_t *) "≮ᡬ．σ¹-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3051 */,
    {.source = (const lxb_char_t *) "<\u0338ᡬ．σ¹-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3052 */,
    {.source = (const lxb_char_t *) "xn--88e732c.σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3053 */,
    {.source = (const lxb_char_t *) "XN--88E732C.Σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3054 */,
    {.source = (const lxb_char_t *) "xn--88e732c.ς1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3055 */,
    {.source = (const lxb_char_t *) "Xn--88e732c.ς1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-lzc", .status = 4} /* 3056 */,
    {.source = (const lxb_char_t *) "Xn--88e732c.σ1-?", .ascii = (const lxb_char_t *) "xn--88e732c.xn--1-?-pzc", .status = 4} /* 3057 */,
    {.source = (const lxb_char_t *) "ቬ򔠼񁗶｡𐨬𝟠", .ascii = (const lxb_char_t *) "xn--d0d41273c887z.xn--8-ob5i", .status = 4} /* 3058 */,
    {.source = (const lxb_char_t *) "ቬ򔠼񁗶。𐨬8", .ascii = (const lxb_char_t *) "xn--d0d41273c887z.xn--8-ob5i", .status = 4} /* 3059 */,
    {.source = (const lxb_char_t *) "xn--d0d41273c887z.xn--8-ob5i", .ascii = (const lxb_char_t *) "xn--d0d41273c887z.xn--8-ob5i", .status = 4} /* 3060 */,
    {.source = (const lxb_char_t *) "𐱲。蔫\u0766", .ascii = (const lxb_char_t *) "xn--389c.xn--qpb7055d", .status = 12} /* 3061 */,
    {.source = (const lxb_char_t *) "xn--389c.xn--qpb7055d", .ascii = (const lxb_char_t *) "xn--389c.xn--qpb7055d", .status = 12} /* 3062 */,
    {.source = (const lxb_char_t *) "򒲧₃｡ꡚ𛇑󠄳\u0647", .ascii = (const lxb_char_t *) "xn--3-ep59g.xn--jhb5904fcp0h", .status = 12} /* 3063 */,
    {.source = (const lxb_char_t *) "򒲧3。ꡚ𛇑󠄳\u0647", .ascii = (const lxb_char_t *) "xn--3-ep59g.xn--jhb5904fcp0h", .status = 12} /* 3064 */,
    {.source = (const lxb_char_t *) "xn--3-ep59g.xn--jhb5904fcp0h", .ascii = (const lxb_char_t *) "xn--3-ep59g.xn--jhb5904fcp0h", .status = 12} /* 3065 */,
    {.source = (const lxb_char_t *) "蓸\u0642≠.ß", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.xn--zca", .status = 8} /* 3066 */,
    {.source = (const lxb_char_t *) "蓸\u0642=\u0338.ß", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.xn--zca", .status = 8} /* 3067 */,
    {.source = (const lxb_char_t *) "蓸\u0642=\u0338.SS", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3068 */,
    {.source = (const lxb_char_t *) "蓸\u0642≠.SS", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3069 */,
    {.source = (const lxb_char_t *) "蓸\u0642≠.ss", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3070 */,
    {.source = (const lxb_char_t *) "蓸\u0642=\u0338.ss", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3071 */,
    {.source = (const lxb_char_t *) "蓸\u0642=\u0338.Ss", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3072 */,
    {.source = (const lxb_char_t *) "蓸\u0642≠.Ss", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3073 */,
    {.source = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.ss", .status = 8} /* 3074 */,
    {.source = (const lxb_char_t *) "xn--ehb015lnt1e.xn--zca", .ascii = (const lxb_char_t *) "xn--ehb015lnt1e.xn--zca", .status = 8} /* 3075 */,
    {.source = (const lxb_char_t *) "\u084E\u067A\u0DD3⒊.𐹹𞱩󠃪\u200C", .ascii = (const lxb_char_t *) "xn--zib94gfziuq1a.xn--0ug3205g7eyf3c96h", .status = 12} /* 3076 */,
    {.source = (const lxb_char_t *) "\u084E\u067A\u0DD33..𐹹𞱩󠃪\u200C", .ascii = (const lxb_char_t *) "xn--3-prc71ls9j..xn--0ug3205g7eyf3c96h", .status = 18} /* 3077 */,
    {.source = (const lxb_char_t *) "xn--3-prc71ls9j..xn--xo0dw109an237f", .ascii = (const lxb_char_t *) "xn--3-prc71ls9j..xn--xo0dw109an237f", .status = 14} /* 3078 */,
    {.source = (const lxb_char_t *) "xn--3-prc71ls9j..xn--0ug3205g7eyf3c96h", .ascii = (const lxb_char_t *) "xn--3-prc71ls9j..xn--0ug3205g7eyf3c96h", .status = 18} /* 3079 */,
    {.source = (const lxb_char_t *) "xn--zib94gfziuq1a.xn--xo0dw109an237f", .ascii = (const lxb_char_t *) "xn--zib94gfziuq1a.xn--xo0dw109an237f", .status = 8} /* 3080 */,
    {.source = (const lxb_char_t *) "xn--zib94gfziuq1a.xn--0ug3205g7eyf3c96h", .ascii = (const lxb_char_t *) "xn--zib94gfziuq1a.xn--0ug3205g7eyf3c96h", .status = 12} /* 3081 */,
    {.source = (const lxb_char_t *) "ς\u200D-.Ⴣ𦟙", .ascii = (const lxb_char_t *) "xn----xmb348s.xn--7nd64871a", .status = 12} /* 3082 */,
    {.source = (const lxb_char_t *) "ς\u200D-.ⴣ𦟙", .ascii = (const lxb_char_t *) "xn----xmb348s.xn--rlj2573p", .status = 8} /* 3083 */,
    {.source = (const lxb_char_t *) "Σ\u200D-.Ⴣ𦟙", .ascii = (const lxb_char_t *) "xn----zmb048s.xn--7nd64871a", .status = 12} /* 3084 */,
    {.source = (const lxb_char_t *) "σ\u200D-.ⴣ𦟙", .ascii = (const lxb_char_t *) "xn----zmb048s.xn--rlj2573p", .status = 8} /* 3085 */,
    {.source = (const lxb_char_t *) "xn----zmb.xn--rlj2573p", .ascii = (const lxb_char_t *) "xn----zmb.xn--rlj2573p", .status = 4} /* 3086 */,
    {.source = (const lxb_char_t *) "xn----zmb048s.xn--rlj2573p", .ascii = (const lxb_char_t *) "xn----zmb048s.xn--rlj2573p", .status = 8} /* 3087 */,
    {.source = (const lxb_char_t *) "xn----zmb.xn--7nd64871a", .ascii = (const lxb_char_t *) "xn----zmb.xn--7nd64871a", .status = 8} /* 3088 */,
    {.source = (const lxb_char_t *) "xn----zmb048s.xn--7nd64871a", .ascii = (const lxb_char_t *) "xn----zmb048s.xn--7nd64871a", .status = 12} /* 3089 */,
    {.source = (const lxb_char_t *) "xn----xmb348s.xn--rlj2573p", .ascii = (const lxb_char_t *) "xn----xmb348s.xn--rlj2573p", .status = 8} /* 3090 */,
    {.source = (const lxb_char_t *) "xn----xmb348s.xn--7nd64871a", .ascii = (const lxb_char_t *) "xn----xmb348s.xn--7nd64871a", .status = 12} /* 3091 */,
    {.source = (const lxb_char_t *) "≠。🞳𝟲", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3092 */,
    {.source = (const lxb_char_t *) "=\u0338。🞳𝟲", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3093 */,
    {.source = (const lxb_char_t *) "≠。🞳6", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3094 */,
    {.source = (const lxb_char_t *) "=\u0338。🞳6", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3095 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3096 */,
    {.source = (const lxb_char_t *) "≠.🞳6", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3097 */,
    {.source = (const lxb_char_t *) "=\u0338.🞳6", .ascii = (const lxb_char_t *) "xn--1ch.xn--6-dl4s", .status = 0} /* 3098 */,
    {.source = (const lxb_char_t *) "󅬽.蠔", .ascii = (const lxb_char_t *) "xn--g747d.xn--xl2a", .status = 4} /* 3099 */,
    {.source = (const lxb_char_t *) "xn--g747d.xn--xl2a", .ascii = (const lxb_char_t *) "xn--g747d.xn--xl2a", .status = 4} /* 3100 */,
    {.source = (const lxb_char_t *) "\u08E6\u200D．뼽", .ascii = (const lxb_char_t *) "xn--p0b869i.xn--e43b", .status = 8} /* 3101 */,
    {.source = (const lxb_char_t *) "\u08E6\u200D．뼽", .ascii = (const lxb_char_t *) "xn--p0b869i.xn--e43b", .status = 8} /* 3102 */,
    {.source = (const lxb_char_t *) "\u08E6\u200D.뼽", .ascii = (const lxb_char_t *) "xn--p0b869i.xn--e43b", .status = 8} /* 3103 */,
    {.source = (const lxb_char_t *) "\u08E6\u200D.뼽", .ascii = (const lxb_char_t *) "xn--p0b869i.xn--e43b", .status = 8} /* 3104 */,
    {.source = (const lxb_char_t *) "xn--p0b.xn--e43b", .ascii = (const lxb_char_t *) "xn--p0b.xn--e43b", .status = 4} /* 3105 */,
    {.source = (const lxb_char_t *) "xn--p0b869i.xn--e43b", .ascii = (const lxb_char_t *) "xn--p0b869i.xn--e43b", .status = 8} /* 3106 */,
    {.source = (const lxb_char_t *) "₇\u0BCD􃂷\u06D2。👖\u0675-𞪑", .ascii = (const lxb_char_t *) "xn--7-rwc839aj3073c.xn----ymc5uv818oghka", .status = 8} /* 3107 */,
    {.source = (const lxb_char_t *) "7\u0BCD􃂷\u06D2。👖\u0627\u0674-𞪑", .ascii = (const lxb_char_t *) "xn--7-rwc839aj3073c.xn----ymc5uv818oghka", .status = 8} /* 3108 */,
    {.source = (const lxb_char_t *) "xn--7-rwc839aj3073c.xn----ymc5uv818oghka", .ascii = (const lxb_char_t *) "xn--7-rwc839aj3073c.xn----ymc5uv818oghka", .status = 8} /* 3109 */,
    {.source = (const lxb_char_t *) "-｡\u077B", .ascii = (const lxb_char_t *) "-.xn--cqb", .status = 8} /* 3110 */,
    {.source = (const lxb_char_t *) "-。\u077B", .ascii = (const lxb_char_t *) "-.xn--cqb", .status = 8} /* 3111 */,
    {.source = (const lxb_char_t *) "-.xn--cqb", .ascii = (const lxb_char_t *) "-.xn--cqb", .status = 8} /* 3112 */,
    {.source = (const lxb_char_t *) "𑇌𵛓｡-⒈ꡏ\u072B", .ascii = (const lxb_char_t *) "xn--8d1dg030h.xn----u1c466tp10j", .status = 16} /* 3113 */,
    {.source = (const lxb_char_t *) "𑇌𵛓。-1.ꡏ\u072B", .ascii = (const lxb_char_t *) "xn--8d1dg030h.-1.xn--1nb7163f", .status = 24} /* 3114 */,
    {.source = (const lxb_char_t *) "xn--8d1dg030h.-1.xn--1nb7163f", .ascii = (const lxb_char_t *) "xn--8d1dg030h.-1.xn--1nb7163f", .status = 24} /* 3115 */,
    {.source = (const lxb_char_t *) "xn--8d1dg030h.xn----u1c466tp10j", .ascii = (const lxb_char_t *) "xn--8d1dg030h.xn----u1c466tp10j", .status = 16} /* 3116 */,
    {.source = (const lxb_char_t *) "璛\u1734\u06AF.-", .ascii = (const lxb_char_t *) "xn--ikb175frt4e.-", .status = 16} /* 3117 */,
    {.source = (const lxb_char_t *) "xn--ikb175frt4e.-", .ascii = (const lxb_char_t *) "xn--ikb175frt4e.-", .status = 16} /* 3118 */,
    {.source = (const lxb_char_t *) "󠆰\u08A1\u0A4D샕．𐹲휁", .ascii = (const lxb_char_t *) "xn--qyb07fj857a.xn--728bv72h", .status = 12} /* 3119 */,
    {.source = (const lxb_char_t *) "󠆰\u08A1\u0A4D샕．𐹲휁", .ascii = (const lxb_char_t *) "xn--qyb07fj857a.xn--728bv72h", .status = 12} /* 3120 */,
    {.source = (const lxb_char_t *) "󠆰\u08A1\u0A4D샕.𐹲휁", .ascii = (const lxb_char_t *) "xn--qyb07fj857a.xn--728bv72h", .status = 12} /* 3121 */,
    {.source = (const lxb_char_t *) "󠆰\u08A1\u0A4D샕.𐹲휁", .ascii = (const lxb_char_t *) "xn--qyb07fj857a.xn--728bv72h", .status = 12} /* 3122 */,
    {.source = (const lxb_char_t *) "xn--qyb07fj857a.xn--728bv72h", .ascii = (const lxb_char_t *) "xn--qyb07fj857a.xn--728bv72h", .status = 12} /* 3123 */,
    {.source = (const lxb_char_t *) "񍨽．񋸕", .ascii = (const lxb_char_t *) "xn--pr3x.xn--rv7w", .status = 4} /* 3124 */,
    {.source = (const lxb_char_t *) "񍨽.񋸕", .ascii = (const lxb_char_t *) "xn--pr3x.xn--rv7w", .status = 4} /* 3125 */,
    {.source = (const lxb_char_t *) "xn--pr3x.xn--rv7w", .ascii = (const lxb_char_t *) "xn--pr3x.xn--rv7w", .status = 4} /* 3126 */,
    {.source = (const lxb_char_t *) "\u067D𞥕｡𑑂𞤶Ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----w0g2740ro9vg", .status = 16} /* 3127 */,
    {.source = (const lxb_char_t *) "\u067D𞥕。𑑂𞤶Ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----w0g2740ro9vg", .status = 16} /* 3128 */,
    {.source = (const lxb_char_t *) "\u067D𞥕。𑑂𞤶ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----zvs0199fo91g", .status = 12} /* 3129 */,
    {.source = (const lxb_char_t *) "\u067D𞥕。𑑂𞤔Ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----w0g2740ro9vg", .status = 16} /* 3130 */,
    {.source = (const lxb_char_t *) "\u067D𞥕。𑑂𞤔ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----zvs0199fo91g", .status = 12} /* 3131 */,
    {.source = (const lxb_char_t *) "xn--2ib0338v.xn----zvs0199fo91g", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----zvs0199fo91g", .status = 12} /* 3132 */,
    {.source = (const lxb_char_t *) "xn--2ib0338v.xn----w0g2740ro9vg", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----w0g2740ro9vg", .status = 16} /* 3133 */,
    {.source = (const lxb_char_t *) "\u067D𞥕｡𑑂𞤶ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----zvs0199fo91g", .status = 12} /* 3134 */,
    {.source = (const lxb_char_t *) "\u067D𞥕｡𑑂𞤔Ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----w0g2740ro9vg", .status = 16} /* 3135 */,
    {.source = (const lxb_char_t *) "\u067D𞥕｡𑑂𞤔ⴍ-", .ascii = (const lxb_char_t *) "xn--2ib0338v.xn----zvs0199fo91g", .status = 12} /* 3136 */,
    {.source = (const lxb_char_t *) "𐯀𐸉𞧏。񢚧₄Ⴋ񂹫", .ascii = (const lxb_char_t *) "xn--039c42bq865a.xn--4-t0g49302fnrzm", .status = 4} /* 3137 */,
    {.source = (const lxb_char_t *) "𐯀𐸉𞧏。񢚧4Ⴋ񂹫", .ascii = (const lxb_char_t *) "xn--039c42bq865a.xn--4-t0g49302fnrzm", .status = 4} /* 3138 */,
    {.source = (const lxb_char_t *) "𐯀𐸉𞧏。񢚧4ⴋ񂹫", .ascii = (const lxb_char_t *) "xn--039c42bq865a.xn--4-wvs27840bnrzm", .status = 4} /* 3139 */,
    {.source = (const lxb_char_t *) "xn--039c42bq865a.xn--4-wvs27840bnrzm", .ascii = (const lxb_char_t *) "xn--039c42bq865a.xn--4-wvs27840bnrzm", .status = 4} /* 3140 */,
    {.source = (const lxb_char_t *) "xn--039c42bq865a.xn--4-t0g49302fnrzm", .ascii = (const lxb_char_t *) "xn--039c42bq865a.xn--4-t0g49302fnrzm", .status = 4} /* 3141 */,
    {.source = (const lxb_char_t *) "𐯀𐸉𞧏。񢚧₄ⴋ񂹫", .ascii = (const lxb_char_t *) "xn--039c42bq865a.xn--4-wvs27840bnrzm", .status = 4} /* 3142 */,
    {.source = (const lxb_char_t *) "4\u06BD︒󠑥.≠", .ascii = (const lxb_char_t *) "xn--4-kvc5601q2h50i.xn--1ch", .status = 8} /* 3143 */,
    {.source = (const lxb_char_t *) "4\u06BD︒󠑥.=\u0338", .ascii = (const lxb_char_t *) "xn--4-kvc5601q2h50i.xn--1ch", .status = 8} /* 3144 */,
    {.source = (const lxb_char_t *) "4\u06BD。󠑥.≠", .ascii = (const lxb_char_t *) "xn--4-kvc.xn--5136e.xn--1ch", .status = 8} /* 3145 */,
    {.source = (const lxb_char_t *) "4\u06BD。󠑥.=\u0338", .ascii = (const lxb_char_t *) "xn--4-kvc.xn--5136e.xn--1ch", .status = 8} /* 3146 */,
    {.source = (const lxb_char_t *) "xn--4-kvc.xn--5136e.xn--1ch", .ascii = (const lxb_char_t *) "xn--4-kvc.xn--5136e.xn--1ch", .status = 8} /* 3147 */,
    {.source = (const lxb_char_t *) "xn--4-kvc5601q2h50i.xn--1ch", .ascii = (const lxb_char_t *) "xn--4-kvc5601q2h50i.xn--1ch", .status = 8} /* 3148 */,
    {.source = (const lxb_char_t *) "𝟓。\u06D7", .ascii = (const lxb_char_t *) "5.xn--nlb", .status = 4} /* 3149 */,
    {.source = (const lxb_char_t *) "5。\u06D7", .ascii = (const lxb_char_t *) "5.xn--nlb", .status = 4} /* 3150 */,
    {.source = (const lxb_char_t *) "5.xn--nlb", .ascii = (const lxb_char_t *) "5.xn--nlb", .status = 4} /* 3151 */,
    {.source = (const lxb_char_t *) "\u200C򺸩.⾕", .ascii = (const lxb_char_t *) "xn--0ug26167i.xn--6g3a", .status = 8} /* 3152 */,
    {.source = (const lxb_char_t *) "\u200C򺸩.谷", .ascii = (const lxb_char_t *) "xn--0ug26167i.xn--6g3a", .status = 8} /* 3153 */,
    {.source = (const lxb_char_t *) "xn--i183d.xn--6g3a", .ascii = (const lxb_char_t *) "xn--i183d.xn--6g3a", .status = 4} /* 3154 */,
    {.source = (const lxb_char_t *) "xn--0ug26167i.xn--6g3a", .ascii = (const lxb_char_t *) "xn--0ug26167i.xn--6g3a", .status = 8} /* 3155 */,
    {.source = (const lxb_char_t *) "︒󎰇\u200D.-\u073C\u200C", .ascii = (const lxb_char_t *) "xn--1ug1658ftw26f.xn----t2c071q", .status = 16} /* 3156 */,
    {.source = (const lxb_char_t *) "。󎰇\u200D.-\u073C\u200C", .ascii = (const lxb_char_t *) ".xn--1ug05310k.xn----t2c071q", .status = 22} /* 3157 */,
    {.source = (const lxb_char_t *) ".xn--hh50e.xn----t2c", .ascii = (const lxb_char_t *) ".xn--hh50e.xn----t2c", .status = 14} /* 3158 */,
    {.source = (const lxb_char_t *) ".xn--1ug05310k.xn----t2c071q", .ascii = (const lxb_char_t *) ".xn--1ug05310k.xn----t2c071q", .status = 22} /* 3159 */,
    {.source = (const lxb_char_t *) "xn--y86c71305c.xn----t2c", .ascii = (const lxb_char_t *) "xn--y86c71305c.xn----t2c", .status = 8} /* 3160 */,
    {.source = (const lxb_char_t *) "xn--1ug1658ftw26f.xn----t2c071q", .ascii = (const lxb_char_t *) "xn--1ug1658ftw26f.xn----t2c071q", .status = 16} /* 3161 */,
    {.source = (const lxb_char_t *) "≯𞤟。ᡨ", .ascii = (const lxb_char_t *) "xn--hdhz520p.xn--48e", .status = 4} /* 3162 */,
    {.source = (const lxb_char_t *) ">\u0338𞤟。ᡨ", .ascii = (const lxb_char_t *) "xn--hdhz520p.xn--48e", .status = 4} /* 3163 */,
    {.source = (const lxb_char_t *) ">\u0338𞥁。ᡨ", .ascii = (const lxb_char_t *) "xn--hdhz520p.xn--48e", .status = 4} /* 3164 */,
    {.source = (const lxb_char_t *) "≯𞥁。ᡨ", .ascii = (const lxb_char_t *) "xn--hdhz520p.xn--48e", .status = 4} /* 3165 */,
    {.source = (const lxb_char_t *) "xn--hdhz520p.xn--48e", .ascii = (const lxb_char_t *) "xn--hdhz520p.xn--48e", .status = 4} /* 3166 */,
    {.source = (const lxb_char_t *) "\u0F74𫫰𝨄。\u0713𐹦", .ascii = (const lxb_char_t *) "xn--ned8985uo92e.xn--dnb6395k", .status = 8} /* 3167 */,
    {.source = (const lxb_char_t *) "xn--ned8985uo92e.xn--dnb6395k", .ascii = (const lxb_char_t *) "xn--ned8985uo92e.xn--dnb6395k", .status = 8} /* 3168 */,
    {.source = (const lxb_char_t *) "\u033C\u07DB⁷𝟹｡𝟬", .ascii = (const lxb_char_t *) "xn--73-9yb648b.0", .status = 8} /* 3169 */,
    {.source = (const lxb_char_t *) "\u033C\u07DB73。0", .ascii = (const lxb_char_t *) "xn--73-9yb648b.0", .status = 8} /* 3170 */,
    {.source = (const lxb_char_t *) "xn--73-9yb648b.0", .ascii = (const lxb_char_t *) "xn--73-9yb648b.0", .status = 8} /* 3171 */,
    {.source = (const lxb_char_t *) "\u200D．𝟗", .ascii = (const lxb_char_t *) "xn--1ug.9", .status = 4} /* 3172 */,
    {.source = (const lxb_char_t *) "\u200D.9", .ascii = (const lxb_char_t *) "xn--1ug.9", .status = 4} /* 3173 */,
    {.source = (const lxb_char_t *) ".9", .ascii = (const lxb_char_t *) ".9", .status = 6} /* 3174 */,
    {.source = (const lxb_char_t *) "xn--1ug.9", .ascii = (const lxb_char_t *) "xn--1ug.9", .status = 4} /* 3175 */,
    {.source = (const lxb_char_t *) "9", .ascii = (const lxb_char_t *) "9", .status = 0} /* 3176 */,
    {.source = (const lxb_char_t *) "\u0779ᡭ𪕈。\u06B6\u08D9", .ascii = (const lxb_char_t *) "xn--9pb497fs270c.xn--pkb80i", .status = 8} /* 3177 */,
    {.source = (const lxb_char_t *) "xn--9pb497fs270c.xn--pkb80i", .ascii = (const lxb_char_t *) "xn--9pb497fs270c.xn--pkb80i", .status = 8} /* 3178 */,
    {.source = (const lxb_char_t *) "\u0726５\u07E2겙。\u1CF4𐷚", .ascii = (const lxb_char_t *) "xn--5-j1c97c2483c.xn--e7f2093h", .status = 20} /* 3179 */,
    {.source = (const lxb_char_t *) "\u0726５\u07E2겙。\u1CF4𐷚", .ascii = (const lxb_char_t *) "xn--5-j1c97c2483c.xn--e7f2093h", .status = 20} /* 3180 */,
    {.source = (const lxb_char_t *) "\u07265\u07E2겙。\u1CF4𐷚", .ascii = (const lxb_char_t *) "xn--5-j1c97c2483c.xn--e7f2093h", .status = 20} /* 3181 */,
    {.source = (const lxb_char_t *) "\u07265\u07E2겙。\u1CF4𐷚", .ascii = (const lxb_char_t *) "xn--5-j1c97c2483c.xn--e7f2093h", .status = 20} /* 3182 */,
    {.source = (const lxb_char_t *) "xn--5-j1c97c2483c.xn--e7f2093h", .ascii = (const lxb_char_t *) "xn--5-j1c97c2483c.xn--e7f2093h", .status = 20} /* 3183 */,
    {.source = (const lxb_char_t *) "Ⴍ𿣍ꡨ\u05AE。Ⴞ\u200C\u200C", .ascii = (const lxb_char_t *) "xn--5cb347co96jug15a.xn--2nd059ea", .status = 8} /* 3184 */,
    {.source = (const lxb_char_t *) "ⴍ𿣍ꡨ\u05AE。ⴞ\u200C\u200C", .ascii = (const lxb_char_t *) "xn--5cb172r175fug38a.xn--0uga051h", .status = 8} /* 3185 */,
    {.source = (const lxb_char_t *) "xn--5cb172r175fug38a.xn--mlj", .ascii = (const lxb_char_t *) "xn--5cb172r175fug38a.xn--mlj", .status = 4} /* 3186 */,
    {.source = (const lxb_char_t *) "xn--5cb172r175fug38a.xn--0uga051h", .ascii = (const lxb_char_t *) "xn--5cb172r175fug38a.xn--0uga051h", .status = 8} /* 3187 */,
    {.source = (const lxb_char_t *) "xn--5cb347co96jug15a.xn--2nd", .ascii = (const lxb_char_t *) "xn--5cb347co96jug15a.xn--2nd", .status = 4} /* 3188 */,
    {.source = (const lxb_char_t *) "xn--5cb347co96jug15a.xn--2nd059ea", .ascii = (const lxb_char_t *) "xn--5cb347co96jug15a.xn--2nd059ea", .status = 8} /* 3189 */,
    {.source = (const lxb_char_t *) "𐋰。󑓱", .ascii = (const lxb_char_t *) "xn--k97c.xn--q031e", .status = 4} /* 3190 */,
    {.source = (const lxb_char_t *) "xn--k97c.xn--q031e", .ascii = (const lxb_char_t *) "xn--k97c.xn--q031e", .status = 4} /* 3191 */,
    {.source = (const lxb_char_t *) "󡎦\u17B4\u0B4D.𐹾", .ascii = (const lxb_char_t *) "xn--9ic364dho91z.xn--2o0d", .status = 8} /* 3192 */,
    {.source = (const lxb_char_t *) "xn--9ic364dho91z.xn--2o0d", .ascii = (const lxb_char_t *) "xn--9ic364dho91z.xn--2o0d", .status = 8} /* 3193 */,
    {.source = (const lxb_char_t *) "\u08DFႫ𶿸귤．򠅼𝟢휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", .status = 8} /* 3194 */,
    {.source = (const lxb_char_t *) "\u08DFႫ𶿸귤．򠅼𝟢휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", .status = 8} /* 3195 */,
    {.source = (const lxb_char_t *) "\u08DFႫ𶿸귤.򠅼0휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", .status = 8} /* 3196 */,
    {.source = (const lxb_char_t *) "\u08DFႫ𶿸귤.򠅼0휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", .status = 8} /* 3197 */,
    {.source = (const lxb_char_t *) "\u08DFⴋ𶿸귤.򠅼0휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", .status = 8} /* 3198 */,
    {.source = (const lxb_char_t *) "\u08DFⴋ𶿸귤.򠅼0휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", .status = 8} /* 3199 */,
    {.source = (const lxb_char_t *) "xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", .ascii = (const lxb_char_t *) "xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", .status = 8} /* 3200 */,
    {.source = (const lxb_char_t *) "xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", .ascii = (const lxb_char_t *) "xn--i0b601b6r7l2hs0a.xn--0-8le8997mulr5f", .status = 8} /* 3201 */,
    {.source = (const lxb_char_t *) "\u08DFⴋ𶿸귤．򠅼𝟢휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", .status = 8} /* 3202 */,
    {.source = (const lxb_char_t *) "\u08DFⴋ𶿸귤．򠅼𝟢휪\u0AE3", .ascii = (const lxb_char_t *) "xn--i0b436pkl2g2h42a.xn--0-8le8997mulr5f", .status = 8} /* 3203 */,
    {.source = (const lxb_char_t *) "\u0784．𞡝\u0601", .ascii = (const lxb_char_t *) "xn--lqb.xn--jfb1808v", .status = 4} /* 3204 */,
    {.source = (const lxb_char_t *) "\u0784.𞡝\u0601", .ascii = (const lxb_char_t *) "xn--lqb.xn--jfb1808v", .status = 4} /* 3205 */,
    {.source = (const lxb_char_t *) "xn--lqb.xn--jfb1808v", .ascii = (const lxb_char_t *) "xn--lqb.xn--jfb1808v", .status = 4} /* 3206 */,
    {.source = (const lxb_char_t *) "\u0ACD₃.8\uA8C4\u200D🃤", .ascii = (const lxb_char_t *) "xn--3-yke.xn--8-ugnv982dbkwm", .status = 4} /* 3207 */,
    {.source = (const lxb_char_t *) "\u0ACD3.8\uA8C4\u200D🃤", .ascii = (const lxb_char_t *) "xn--3-yke.xn--8-ugnv982dbkwm", .status = 4} /* 3208 */,
    {.source = (const lxb_char_t *) "xn--3-yke.xn--8-sl4et308f", .ascii = (const lxb_char_t *) "xn--3-yke.xn--8-sl4et308f", .status = 4} /* 3209 */,
    {.source = (const lxb_char_t *) "xn--3-yke.xn--8-ugnv982dbkwm", .ascii = (const lxb_char_t *) "xn--3-yke.xn--8-ugnv982dbkwm", .status = 4} /* 3210 */,
    {.source = (const lxb_char_t *) "℻⩷𝆆。𞤠󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3211 */,
    {.source = (const lxb_char_t *) "FAX⩷𝆆。𞤠󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3212 */,
    {.source = (const lxb_char_t *) "fax⩷𝆆。𞥂󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3213 */,
    {.source = (const lxb_char_t *) "Fax⩷𝆆。𞤠󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3214 */,
    {.source = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3215 */,
    {.source = (const lxb_char_t *) "℻⩷𝆆。𞥂󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3216 */,
    {.source = (const lxb_char_t *) "FAX⩷𝆆。𞥂󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3217 */,
    {.source = (const lxb_char_t *) "fax⩷𝆆。𞤠󠆁\u180C", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3218 */,
    {.source = (const lxb_char_t *) "fax⩷𝆆.𞥂", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3219 */,
    {.source = (const lxb_char_t *) "FAX⩷𝆆.𞤠", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3220 */,
    {.source = (const lxb_char_t *) "Fax⩷𝆆.𞤠", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3221 */,
    {.source = (const lxb_char_t *) "FAX⩷𝆆.𞥂", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3222 */,
    {.source = (const lxb_char_t *) "Fax⩷𝆆.𞥂", .ascii = (const lxb_char_t *) "xn--fax-4c9a1676t.xn--6e6h", .status = 4} /* 3223 */,
    {.source = (const lxb_char_t *) "ꡕ≠\u105E󮿱｡𐵧󠄫\uFFA0", .ascii = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--cl7c96v", .status = 12} /* 3224 */,
    {.source = (const lxb_char_t *) "ꡕ=\u0338\u105E󮿱｡𐵧󠄫\uFFA0", .ascii = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--cl7c96v", .status = 12} /* 3225 */,
    {.source = (const lxb_char_t *) "ꡕ≠\u105E󮿱。𐵧󠄫\u1160", .ascii = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--psd1510k", .status = 12} /* 3226 */,
    {.source = (const lxb_char_t *) "ꡕ=\u0338\u105E󮿱。𐵧󠄫\u1160", .ascii = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--psd1510k", .status = 12} /* 3227 */,
    {.source = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--psd1510k", .ascii = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--psd1510k", .status = 12} /* 3228 */,
    {.source = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--cl7c96v", .ascii = (const lxb_char_t *) "xn--cld333gn31h0158l.xn--cl7c96v", .status = 12} /* 3229 */,
    {.source = (const lxb_char_t *) "鱊。\u200C", .ascii = (const lxb_char_t *) "xn--rt6a.xn--0ug", .status = 4} /* 3230 */,
    {.source = (const lxb_char_t *) "xn--rt6a.", .ascii = (const lxb_char_t *) "xn--rt6a.", .status = 0} /* 3231 */,
    {.source = (const lxb_char_t *) "鱊.", .ascii = (const lxb_char_t *) "xn--rt6a.", .status = 0} /* 3232 */,
    {.source = (const lxb_char_t *) "xn--rt6a.xn--0ug", .ascii = (const lxb_char_t *) "xn--rt6a.xn--0ug", .status = 4} /* 3233 */,
    {.source = (const lxb_char_t *) "8𐹣．𑍨", .ascii = (const lxb_char_t *) "xn--8-d26i.xn--0p1d", .status = 8} /* 3234 */,
    {.source = (const lxb_char_t *) "8𐹣.𑍨", .ascii = (const lxb_char_t *) "xn--8-d26i.xn--0p1d", .status = 8} /* 3235 */,
    {.source = (const lxb_char_t *) "xn--8-d26i.xn--0p1d", .ascii = (const lxb_char_t *) "xn--8-d26i.xn--0p1d", .status = 8} /* 3236 */,
    {.source = (const lxb_char_t *) "⏹𐧀．𐫯", .ascii = (const lxb_char_t *) "xn--qoh9161g.xn--1x9c", .status = 4} /* 3237 */,
    {.source = (const lxb_char_t *) "⏹𐧀.𐫯", .ascii = (const lxb_char_t *) "xn--qoh9161g.xn--1x9c", .status = 4} /* 3238 */,
    {.source = (const lxb_char_t *) "xn--qoh9161g.xn--1x9c", .ascii = (const lxb_char_t *) "xn--qoh9161g.xn--1x9c", .status = 4} /* 3239 */,
    {.source = (const lxb_char_t *) "𞤺\u07CC4．\u200D", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.xn--1ug", .status = 8} /* 3240 */,
    {.source = (const lxb_char_t *) "𞤺\u07CC4.\u200D", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.xn--1ug", .status = 8} /* 3241 */,
    {.source = (const lxb_char_t *) "𞤘\u07CC4.\u200D", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.xn--1ug", .status = 8} /* 3242 */,
    {.source = (const lxb_char_t *) "xn--4-0bd15808a.", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.", .status = 0} /* 3243 */,
    {.source = (const lxb_char_t *) "𞤺\u07CC4.", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.", .status = 0} /* 3244 */,
    {.source = (const lxb_char_t *) "𞤘\u07CC4.", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.", .status = 0} /* 3245 */,
    {.source = (const lxb_char_t *) "xn--4-0bd15808a.xn--1ug", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.xn--1ug", .status = 8} /* 3246 */,
    {.source = (const lxb_char_t *) "𞤘\u07CC4．\u200D", .ascii = (const lxb_char_t *) "xn--4-0bd15808a.xn--1ug", .status = 8} /* 3247 */,
    {.source = (const lxb_char_t *) "⒗\u0981\u20EF-.\u08E2•", .ascii = (const lxb_char_t *) "xn----z0d801p6kd.xn--l0b810j", .status = 12} /* 3248 */,
    {.source = (const lxb_char_t *) "16.\u0981\u20EF-.\u08E2•", .ascii = (const lxb_char_t *) "16.xn----z0d801p.xn--l0b810j", .status = 16} /* 3249 */,
    {.source = (const lxb_char_t *) "16.xn----z0d801p.xn--l0b810j", .ascii = (const lxb_char_t *) "16.xn----z0d801p.xn--l0b810j", .status = 16} /* 3250 */,
    {.source = (const lxb_char_t *) "xn----z0d801p6kd.xn--l0b810j", .ascii = (const lxb_char_t *) "xn----z0d801p6kd.xn--l0b810j", .status = 12} /* 3251 */,
    {.source = (const lxb_char_t *) "-｡䏛", .ascii = (const lxb_char_t *) "-.xn--xco", .status = 4} /* 3252 */,
    {.source = (const lxb_char_t *) "-。䏛", .ascii = (const lxb_char_t *) "-.xn--xco", .status = 4} /* 3253 */,
    {.source = (const lxb_char_t *) "-.xn--xco", .ascii = (const lxb_char_t *) "-.xn--xco", .status = 4} /* 3254 */,
    {.source = (const lxb_char_t *) "\u200C񒃠．\u200D", .ascii = (const lxb_char_t *) "xn--0ugz7551c.xn--1ug", .status = 12} /* 3255 */,
    {.source = (const lxb_char_t *) "\u200C񒃠.\u200D", .ascii = (const lxb_char_t *) "xn--0ugz7551c.xn--1ug", .status = 12} /* 3256 */,
    {.source = (const lxb_char_t *) "xn--dj8y.", .ascii = (const lxb_char_t *) "xn--dj8y.", .status = 4} /* 3257 */,
    {.source = (const lxb_char_t *) "xn--0ugz7551c.xn--1ug", .ascii = (const lxb_char_t *) "xn--0ugz7551c.xn--1ug", .status = 12} /* 3258 */,
    {.source = (const lxb_char_t *) "⒈⓰󥣇｡𐹠\u200D򗷦Ⴕ", .ascii = (const lxb_char_t *) "xn--tsh0nz9380h.xn--tnd969erj4psgl3e", .status = 12} /* 3259 */,
    {.source = (const lxb_char_t *) "1.⓰󥣇。𐹠\u200D򗷦Ⴕ", .ascii = (const lxb_char_t *) "1.xn--svh00804k.xn--tnd969erj4psgl3e", .status = 12} /* 3260 */,
    {.source = (const lxb_char_t *) "1.⓰󥣇。𐹠\u200D򗷦ⴕ", .ascii = (const lxb_char_t *) "1.xn--svh00804k.xn--1ug352csp0psg45e", .status = 12} /* 3261 */,
    {.source = (const lxb_char_t *) "1.xn--svh00804k.xn--dljv223ee5t2d", .ascii = (const lxb_char_t *) "1.xn--svh00804k.xn--dljv223ee5t2d", .status = 8} /* 3262 */,
    {.source = (const lxb_char_t *) "1.xn--svh00804k.xn--1ug352csp0psg45e", .ascii = (const lxb_char_t *) "1.xn--svh00804k.xn--1ug352csp0psg45e", .status = 12} /* 3263 */,
    {.source = (const lxb_char_t *) "1.xn--svh00804k.xn--tnd1990ke579c", .ascii = (const lxb_char_t *) "1.xn--svh00804k.xn--tnd1990ke579c", .status = 8} /* 3264 */,
    {.source = (const lxb_char_t *) "1.xn--svh00804k.xn--tnd969erj4psgl3e", .ascii = (const lxb_char_t *) "1.xn--svh00804k.xn--tnd969erj4psgl3e", .status = 12} /* 3265 */,
    {.source = (const lxb_char_t *) "⒈⓰󥣇｡𐹠\u200D򗷦ⴕ", .ascii = (const lxb_char_t *) "xn--tsh0nz9380h.xn--1ug352csp0psg45e", .status = 12} /* 3266 */,
    {.source = (const lxb_char_t *) "xn--tsh0nz9380h.xn--dljv223ee5t2d", .ascii = (const lxb_char_t *) "xn--tsh0nz9380h.xn--dljv223ee5t2d", .status = 8} /* 3267 */,
    {.source = (const lxb_char_t *) "xn--tsh0nz9380h.xn--1ug352csp0psg45e", .ascii = (const lxb_char_t *) "xn--tsh0nz9380h.xn--1ug352csp0psg45e", .status = 12} /* 3268 */,
    {.source = (const lxb_char_t *) "xn--tsh0nz9380h.xn--tnd1990ke579c", .ascii = (const lxb_char_t *) "xn--tsh0nz9380h.xn--tnd1990ke579c", .status = 8} /* 3269 */,
    {.source = (const lxb_char_t *) "xn--tsh0nz9380h.xn--tnd969erj4psgl3e", .ascii = (const lxb_char_t *) "xn--tsh0nz9380h.xn--tnd969erj4psgl3e", .status = 12} /* 3270 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-ß｡\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn----qfa310pg973b.xn--jfb197i791bi6x4c", .status = 20} /* 3271 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-ß。\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn----qfa310pg973b.xn--jfb197i791bi6x4c", .status = 20} /* 3272 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-SS。\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3273 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-ss。\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3274 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-Ss。\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3275 */,
    {.source = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3276 */,
    {.source = (const lxb_char_t *) "xn----qfa310pg973b.xn--jfb197i791bi6x4c", .ascii = (const lxb_char_t *) "xn----qfa310pg973b.xn--jfb197i791bi6x4c", .status = 20} /* 3277 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-SS｡\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3278 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-ss｡\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3279 */,
    {.source = (const lxb_char_t *) "𞠊ᠮ-Ss｡\u1CD0効\u0601𷣭", .ascii = (const lxb_char_t *) "xn---ss-21t18904a.xn--jfb197i791bi6x4c", .status = 20} /* 3280 */,
    {.source = (const lxb_char_t *) "𑇀.󠨱", .ascii = (const lxb_char_t *) "xn--wd1d.xn--k946e", .status = 8} /* 3281 */,
    {.source = (const lxb_char_t *) "xn--wd1d.xn--k946e", .ascii = (const lxb_char_t *) "xn--wd1d.xn--k946e", .status = 8} /* 3282 */,
    {.source = (const lxb_char_t *) "␒3\uFB88｡𝟘𐨿𐹆", .ascii = (const lxb_char_t *) "xn--3-jsc897t.xn--0-sc5iy3h", .status = 8} /* 3283 */,
    {.source = (const lxb_char_t *) "␒3\u0688。0𐨿𐹆", .ascii = (const lxb_char_t *) "xn--3-jsc897t.xn--0-sc5iy3h", .status = 8} /* 3284 */,
    {.source = (const lxb_char_t *) "xn--3-jsc897t.xn--0-sc5iy3h", .ascii = (const lxb_char_t *) "xn--3-jsc897t.xn--0-sc5iy3h", .status = 8} /* 3285 */,
    {.source = (const lxb_char_t *) "\u076B６\u0A81\u08A6。\u1DE3", .ascii = (const lxb_char_t *) "xn--6-h5c06gj6c.xn--7eg", .status = 8} /* 3286 */,
    {.source = (const lxb_char_t *) "\u076B6\u0A81\u08A6。\u1DE3", .ascii = (const lxb_char_t *) "xn--6-h5c06gj6c.xn--7eg", .status = 8} /* 3287 */,
    {.source = (const lxb_char_t *) "xn--6-h5c06gj6c.xn--7eg", .ascii = (const lxb_char_t *) "xn--6-h5c06gj6c.xn--7eg", .status = 8} /* 3288 */,
    {.source = (const lxb_char_t *) "\u0605-𽤞Ⴂ。򅤶\u200D", .ascii = (const lxb_char_t *) "xn----0kc662fc152h.xn--1ugy3204f", .status = 16} /* 3289 */,
    {.source = (const lxb_char_t *) "\u0605-𽤞ⴂ。򅤶\u200D", .ascii = (const lxb_char_t *) "xn----0kc8501a5399e.xn--1ugy3204f", .status = 16} /* 3290 */,
    {.source = (const lxb_char_t *) "xn----0kc8501a5399e.xn--ss06b", .ascii = (const lxb_char_t *) "xn----0kc8501a5399e.xn--ss06b", .status = 8} /* 3291 */,
    {.source = (const lxb_char_t *) "xn----0kc8501a5399e.xn--1ugy3204f", .ascii = (const lxb_char_t *) "xn----0kc8501a5399e.xn--1ugy3204f", .status = 16} /* 3292 */,
    {.source = (const lxb_char_t *) "xn----0kc662fc152h.xn--ss06b", .ascii = (const lxb_char_t *) "xn----0kc662fc152h.xn--ss06b", .status = 8} /* 3293 */,
    {.source = (const lxb_char_t *) "xn----0kc662fc152h.xn--1ugy3204f", .ascii = (const lxb_char_t *) "xn----0kc662fc152h.xn--1ugy3204f", .status = 16} /* 3294 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５≯ß", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5-qfa988w745i", .status = 0} /* 3295 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５>\u0338ß", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5-qfa988w745i", .status = 0} /* 3296 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5≯ß", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5-qfa988w745i", .status = 0} /* 3297 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5>\u0338ß", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5-qfa988w745i", .status = 0} /* 3298 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5>\u0338SS", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3299 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5≯SS", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3300 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5≯ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3301 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5>\u0338ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3302 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5>\u0338Ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3303 */,
    {.source = (const lxb_char_t *) "舌.ꡈ5≯Ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3304 */,
    {.source = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3305 */,
    {.source = (const lxb_char_t *) "xn--tc1a.xn--5-qfa988w745i", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5-qfa988w745i", .status = 0} /* 3306 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５>\u0338SS", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3307 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５≯SS", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3308 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５≯ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3309 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５>\u0338ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3310 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５>\u0338Ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3311 */,
    {.source = (const lxb_char_t *) "⾆．ꡈ５≯Ss", .ascii = (const lxb_char_t *) "xn--tc1a.xn--5ss-3m2a5009e", .status = 0} /* 3312 */,
    {.source = (const lxb_char_t *) "\u0ACD8\u200D．򾂈\u075C", .ascii = (const lxb_char_t *) "xn--8-yke534n.xn--gpb79046m", .status = 24} /* 3313 */,
    {.source = (const lxb_char_t *) "\u0ACD8\u200D.򾂈\u075C", .ascii = (const lxb_char_t *) "xn--8-yke534n.xn--gpb79046m", .status = 24} /* 3314 */,
    {.source = (const lxb_char_t *) "xn--8-yke.xn--gpb79046m", .ascii = (const lxb_char_t *) "xn--8-yke.xn--gpb79046m", .status = 20} /* 3315 */,
    {.source = (const lxb_char_t *) "xn--8-yke534n.xn--gpb79046m", .ascii = (const lxb_char_t *) "xn--8-yke534n.xn--gpb79046m", .status = 24} /* 3316 */,
    {.source = (const lxb_char_t *) "򸷆\u0A70≮򹓙．񞎧⁷󠯙\u06B6", .ascii = (const lxb_char_t *) "xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", .status = 12} /* 3317 */,
    {.source = (const lxb_char_t *) "򸷆\u0A70<\u0338򹓙．񞎧⁷󠯙\u06B6", .ascii = (const lxb_char_t *) "xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", .status = 12} /* 3318 */,
    {.source = (const lxb_char_t *) "򸷆\u0A70≮򹓙.񞎧7󠯙\u06B6", .ascii = (const lxb_char_t *) "xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", .status = 12} /* 3319 */,
    {.source = (const lxb_char_t *) "򸷆\u0A70<\u0338򹓙.񞎧7󠯙\u06B6", .ascii = (const lxb_char_t *) "xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", .status = 12} /* 3320 */,
    {.source = (const lxb_char_t *) "xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", .ascii = (const lxb_char_t *) "xn--ycc893jqh38rb6fa.xn--7-5uc53836ixt41c", .status = 12} /* 3321 */,
    {.source = (const lxb_char_t *) "𞤪.ς", .ascii = (const lxb_char_t *) "xn--ie6h.xn--3xa", .status = 0} /* 3322 */,
    {.source = (const lxb_char_t *) "𞤈.Σ", .ascii = (const lxb_char_t *) "xn--ie6h.xn--4xa", .status = 0} /* 3323 */,
    {.source = (const lxb_char_t *) "𞤪.σ", .ascii = (const lxb_char_t *) "xn--ie6h.xn--4xa", .status = 0} /* 3324 */,
    {.source = (const lxb_char_t *) "𞤈.σ", .ascii = (const lxb_char_t *) "xn--ie6h.xn--4xa", .status = 0} /* 3325 */,
    {.source = (const lxb_char_t *) "xn--ie6h.xn--4xa", .ascii = (const lxb_char_t *) "xn--ie6h.xn--4xa", .status = 0} /* 3326 */,
    {.source = (const lxb_char_t *) "𞤈.ς", .ascii = (const lxb_char_t *) "xn--ie6h.xn--3xa", .status = 0} /* 3327 */,
    {.source = (const lxb_char_t *) "xn--ie6h.xn--3xa", .ascii = (const lxb_char_t *) "xn--ie6h.xn--3xa", .status = 0} /* 3328 */,
    {.source = (const lxb_char_t *) "𞤪.Σ", .ascii = (const lxb_char_t *) "xn--ie6h.xn--4xa", .status = 0} /* 3329 */,
    {.source = (const lxb_char_t *) "\u200CႺ｡ς", .ascii = (const lxb_char_t *) "xn--ynd759e.xn--3xa", .status = 8} /* 3330 */,
    {.source = (const lxb_char_t *) "\u200CႺ。ς", .ascii = (const lxb_char_t *) "xn--ynd759e.xn--3xa", .status = 8} /* 3331 */,
    {.source = (const lxb_char_t *) "\u200Cⴚ。ς", .ascii = (const lxb_char_t *) "xn--0ug262c.xn--3xa", .status = 4} /* 3332 */,
    {.source = (const lxb_char_t *) "\u200CႺ。Σ", .ascii = (const lxb_char_t *) "xn--ynd759e.xn--4xa", .status = 8} /* 3333 */,
    {.source = (const lxb_char_t *) "\u200Cⴚ。σ", .ascii = (const lxb_char_t *) "xn--0ug262c.xn--4xa", .status = 4} /* 3334 */,
    {.source = (const lxb_char_t *) "xn--ilj.xn--4xa", .ascii = (const lxb_char_t *) "xn--ilj.xn--4xa", .status = 0} /* 3335 */,
    {.source = (const lxb_char_t *) "ⴚ.σ", .ascii = (const lxb_char_t *) "xn--ilj.xn--4xa", .status = 0} /* 3336 */,
    {.source = (const lxb_char_t *) "Ⴚ.Σ", .ascii = (const lxb_char_t *) "xn--ynd.xn--4xa", .status = 4} /* 3337 */,
    {.source = (const lxb_char_t *) "ⴚ.ς", .ascii = (const lxb_char_t *) "xn--ilj.xn--3xa", .status = 0} /* 3338 */,
    {.source = (const lxb_char_t *) "Ⴚ.ς", .ascii = (const lxb_char_t *) "xn--ynd.xn--3xa", .status = 4} /* 3339 */,
    {.source = (const lxb_char_t *) "xn--ynd.xn--4xa", .ascii = (const lxb_char_t *) "xn--ynd.xn--4xa", .status = 4} /* 3340 */,
    {.source = (const lxb_char_t *) "xn--ynd.xn--3xa", .ascii = (const lxb_char_t *) "xn--ynd.xn--3xa", .status = 4} /* 3341 */,
    {.source = (const lxb_char_t *) "xn--ilj.xn--3xa", .ascii = (const lxb_char_t *) "xn--ilj.xn--3xa", .status = 0} /* 3342 */,
    {.source = (const lxb_char_t *) "Ⴚ.σ", .ascii = (const lxb_char_t *) "xn--ynd.xn--4xa", .status = 4} /* 3343 */,
    {.source = (const lxb_char_t *) "xn--0ug262c.xn--4xa", .ascii = (const lxb_char_t *) "xn--0ug262c.xn--4xa", .status = 4} /* 3344 */,
    {.source = (const lxb_char_t *) "xn--ynd759e.xn--4xa", .ascii = (const lxb_char_t *) "xn--ynd759e.xn--4xa", .status = 8} /* 3345 */,
    {.source = (const lxb_char_t *) "xn--0ug262c.xn--3xa", .ascii = (const lxb_char_t *) "xn--0ug262c.xn--3xa", .status = 4} /* 3346 */,
    {.source = (const lxb_char_t *) "xn--ynd759e.xn--3xa", .ascii = (const lxb_char_t *) "xn--ynd759e.xn--3xa", .status = 8} /* 3347 */,
    {.source = (const lxb_char_t *) "\u200Cⴚ｡ς", .ascii = (const lxb_char_t *) "xn--0ug262c.xn--3xa", .status = 4} /* 3348 */,
    {.source = (const lxb_char_t *) "\u200CႺ｡Σ", .ascii = (const lxb_char_t *) "xn--ynd759e.xn--4xa", .status = 8} /* 3349 */,
    {.source = (const lxb_char_t *) "\u200Cⴚ｡σ", .ascii = (const lxb_char_t *) "xn--0ug262c.xn--4xa", .status = 4} /* 3350 */,
    {.source = (const lxb_char_t *) "𞤃．𐹦", .ascii = (const lxb_char_t *) "xn--de6h.xn--eo0d", .status = 4} /* 3351 */,
    {.source = (const lxb_char_t *) "𞤃.𐹦", .ascii = (const lxb_char_t *) "xn--de6h.xn--eo0d", .status = 4} /* 3352 */,
    {.source = (const lxb_char_t *) "𞤥.𐹦", .ascii = (const lxb_char_t *) "xn--de6h.xn--eo0d", .status = 4} /* 3353 */,
    {.source = (const lxb_char_t *) "xn--de6h.xn--eo0d", .ascii = (const lxb_char_t *) "xn--de6h.xn--eo0d", .status = 4} /* 3354 */,
    {.source = (const lxb_char_t *) "𞤥．𐹦", .ascii = (const lxb_char_t *) "xn--de6h.xn--eo0d", .status = 4} /* 3355 */,
    {.source = (const lxb_char_t *) "\u200D⾕。\u200C\u0310\uA953ꡎ", .ascii = (const lxb_char_t *) "xn--1ug0273b.xn--0sa359l6n7g13a", .status = 8} /* 3356 */,
    {.source = (const lxb_char_t *) "\u200D⾕。\u200C\uA953\u0310ꡎ", .ascii = (const lxb_char_t *) "xn--1ug0273b.xn--0sa359l6n7g13a", .status = 8} /* 3357 */,
    {.source = (const lxb_char_t *) "\u200D谷。\u200C\uA953\u0310ꡎ", .ascii = (const lxb_char_t *) "xn--1ug0273b.xn--0sa359l6n7g13a", .status = 8} /* 3358 */,
    {.source = (const lxb_char_t *) "xn--6g3a.xn--0sa8175flwa", .ascii = (const lxb_char_t *) "xn--6g3a.xn--0sa8175flwa", .status = 4} /* 3359 */,
    {.source = (const lxb_char_t *) "xn--1ug0273b.xn--0sa359l6n7g13a", .ascii = (const lxb_char_t *) "xn--1ug0273b.xn--0sa359l6n7g13a", .status = 8} /* 3360 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔．𞤐\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3361 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔．𞤐\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3362 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔.𞤐\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3363 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔.𞤐\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3364 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔.𞤲\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3365 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔.𞤲\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3366 */,
    {.source = (const lxb_char_t *) "xn----guc3592k.xn--qe6h", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--qe6h", .status = 8} /* 3367 */,
    {.source = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3368 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔．𞤲\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3369 */,
    {.source = (const lxb_char_t *) "\u06AA-뉔．𞤲\u200C", .ascii = (const lxb_char_t *) "xn----guc3592k.xn--0ug7611p", .status = 12} /* 3370 */,
    {.source = (const lxb_char_t *) "񔲵５ᦛς.\uA8C4\u077B\u1CD2\u0738", .ascii = (const lxb_char_t *) "xn--5-ymb298ng603j.xn--fob7kk44dl41k", .status = 12} /* 3371 */,
    {.source = (const lxb_char_t *) "񔲵５ᦛς.\uA8C4\u077B\u0738\u1CD2", .ascii = (const lxb_char_t *) "xn--5-ymb298ng603j.xn--fob7kk44dl41k", .status = 12} /* 3372 */,
    {.source = (const lxb_char_t *) "񔲵5ᦛς.\uA8C4\u077B\u0738\u1CD2", .ascii = (const lxb_char_t *) "xn--5-ymb298ng603j.xn--fob7kk44dl41k", .status = 12} /* 3373 */,
    {.source = (const lxb_char_t *) "񔲵5ᦛΣ.\uA8C4\u077B\u0738\u1CD2", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3374 */,
    {.source = (const lxb_char_t *) "񔲵5ᦛσ.\uA8C4\u077B\u0738\u1CD2", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3375 */,
    {.source = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3376 */,
    {.source = (const lxb_char_t *) "xn--5-ymb298ng603j.xn--fob7kk44dl41k", .ascii = (const lxb_char_t *) "xn--5-ymb298ng603j.xn--fob7kk44dl41k", .status = 12} /* 3377 */,
    {.source = (const lxb_char_t *) "񔲵５ᦛΣ.\uA8C4\u077B\u0738\u1CD2", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3378 */,
    {.source = (const lxb_char_t *) "񔲵５ᦛσ.\uA8C4\u077B\u0738\u1CD2", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3379 */,
    {.source = (const lxb_char_t *) "񔲵５ᦛΣ.\uA8C4\u077B\u1CD2\u0738", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3380 */,
    {.source = (const lxb_char_t *) "񔲵５ᦛσ.\uA8C4\u077B\u1CD2\u0738", .ascii = (const lxb_char_t *) "xn--5-0mb988ng603j.xn--fob7kk44dl41k", .status = 12} /* 3381 */,
    {.source = (const lxb_char_t *) "淽。ᠾ", .ascii = (const lxb_char_t *) "xn--34w.xn--x7e", .status = 0} /* 3382 */,
    {.source = (const lxb_char_t *) "xn--34w.xn--x7e", .ascii = (const lxb_char_t *) "xn--34w.xn--x7e", .status = 0} /* 3383 */,
    {.source = (const lxb_char_t *) "淽.ᠾ", .ascii = (const lxb_char_t *) "xn--34w.xn--x7e", .status = 0} /* 3384 */,
    {.source = (const lxb_char_t *) "𐹴𑘷。-", .ascii = (const lxb_char_t *) "xn--so0do6k.-", .status = 8} /* 3385 */,
    {.source = (const lxb_char_t *) "xn--so0do6k.-", .ascii = (const lxb_char_t *) "xn--so0do6k.-", .status = 8} /* 3386 */,
    {.source = (const lxb_char_t *) "򬨩Ⴓ❓｡𑄨", .ascii = (const lxb_char_t *) "xn--rnd896i0j14q.xn--k80d", .status = 8} /* 3387 */,
    {.source = (const lxb_char_t *) "򬨩Ⴓ❓。𑄨", .ascii = (const lxb_char_t *) "xn--rnd896i0j14q.xn--k80d", .status = 8} /* 3388 */,
    {.source = (const lxb_char_t *) "򬨩ⴓ❓。𑄨", .ascii = (const lxb_char_t *) "xn--8di78qvw32y.xn--k80d", .status = 8} /* 3389 */,
    {.source = (const lxb_char_t *) "xn--8di78qvw32y.xn--k80d", .ascii = (const lxb_char_t *) "xn--8di78qvw32y.xn--k80d", .status = 8} /* 3390 */,
    {.source = (const lxb_char_t *) "xn--rnd896i0j14q.xn--k80d", .ascii = (const lxb_char_t *) "xn--rnd896i0j14q.xn--k80d", .status = 8} /* 3391 */,
    {.source = (const lxb_char_t *) "򬨩ⴓ❓｡𑄨", .ascii = (const lxb_char_t *) "xn--8di78qvw32y.xn--k80d", .status = 8} /* 3392 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌Ⴇ｡ßႣ", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--zca681f", .status = 12} /* 3393 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌Ⴇ。ßႣ", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--zca681f", .status = 12} /* 3394 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤮ⴇ。ßⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--zca417t", .status = 8} /* 3395 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌Ⴇ。SSႣ", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-fek", .status = 12} /* 3396 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤮ⴇ。ssⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3397 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌ⴇ。Ssⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3398 */,
    {.source = (const lxb_char_t *) "xn--ykj9323eegwf.xn--ss-151a", .ascii = (const lxb_char_t *) "xn--ykj9323eegwf.xn--ss-151a", .status = 4} /* 3399 */,
    {.source = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3400 */,
    {.source = (const lxb_char_t *) "xn--fnd1201kegrf.xn--ss-fek", .ascii = (const lxb_char_t *) "xn--fnd1201kegrf.xn--ss-fek", .status = 8} /* 3401 */,
    {.source = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-fek", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-fek", .status = 12} /* 3402 */,
    {.source = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--zca417t", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--zca417t", .status = 8} /* 3403 */,
    {.source = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--zca681f", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--zca681f", .status = 12} /* 3404 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤮ⴇ｡ßⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--zca417t", .status = 8} /* 3405 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌Ⴇ｡SSႣ", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-fek", .status = 12} /* 3406 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤮ⴇ｡ssⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3407 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌ⴇ｡Ssⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3408 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌ⴇ。ßⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--zca417t", .status = 8} /* 3409 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌ⴇ。ssⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3410 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌Ⴇ。Ssⴃ", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-151a", .status = 12} /* 3411 */,
    {.source = (const lxb_char_t *) "xn--fnd1201kegrf.xn--ss-151a", .ascii = (const lxb_char_t *) "xn--fnd1201kegrf.xn--ss-151a", .status = 8} /* 3412 */,
    {.source = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-151a", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-151a", .status = 12} /* 3413 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌ⴇ｡ßⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--zca417t", .status = 8} /* 3414 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌ⴇ｡ssⴃ", .ascii = (const lxb_char_t *) "xn--0ug332c3q0pr56g.xn--ss-151a", .status = 8} /* 3415 */,
    {.source = (const lxb_char_t *) "\u200C𐹡𞤌Ⴇ｡Ssⴃ", .ascii = (const lxb_char_t *) "xn--fnd599eyj4pr50g.xn--ss-151a", .status = 12} /* 3416 */,
    {.source = (const lxb_char_t *) "\u17FF｡𞬳", .ascii = (const lxb_char_t *) "xn--45e.xn--et6h", .status = 4} /* 3417 */,
    {.source = (const lxb_char_t *) "\u17FF。𞬳", .ascii = (const lxb_char_t *) "xn--45e.xn--et6h", .status = 4} /* 3418 */,
    {.source = (const lxb_char_t *) "xn--45e.xn--et6h", .ascii = (const lxb_char_t *) "xn--45e.xn--et6h", .status = 4} /* 3419 */,
    {.source = (const lxb_char_t *) "\u0652\u200D｡\u0CCD𑚳", .ascii = (const lxb_char_t *) "xn--uhb882k.xn--8tc4527k", .status = 8} /* 3420 */,
    {.source = (const lxb_char_t *) "\u0652\u200D。\u0CCD𑚳", .ascii = (const lxb_char_t *) "xn--uhb882k.xn--8tc4527k", .status = 8} /* 3421 */,
    {.source = (const lxb_char_t *) "xn--uhb.xn--8tc4527k", .ascii = (const lxb_char_t *) "xn--uhb.xn--8tc4527k", .status = 4} /* 3422 */,
    {.source = (const lxb_char_t *) "xn--uhb882k.xn--8tc4527k", .ascii = (const lxb_char_t *) "xn--uhb882k.xn--8tc4527k", .status = 8} /* 3423 */,
    {.source = (const lxb_char_t *) "-≠ᠻ．\u076D𞥃≮󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3424 */,
    {.source = (const lxb_char_t *) "-=\u0338ᠻ．\u076D𞥃<\u0338󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3425 */,
    {.source = (const lxb_char_t *) "-≠ᠻ.\u076D𞥃≮󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3426 */,
    {.source = (const lxb_char_t *) "-=\u0338ᠻ.\u076D𞥃<\u0338󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3427 */,
    {.source = (const lxb_char_t *) "-=\u0338ᠻ.\u076D𞤡<\u0338󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3428 */,
    {.source = (const lxb_char_t *) "-≠ᠻ.\u076D𞤡≮󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3429 */,
    {.source = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3430 */,
    {.source = (const lxb_char_t *) "-=\u0338ᠻ．\u076D𞤡<\u0338󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3431 */,
    {.source = (const lxb_char_t *) "-≠ᠻ．\u076D𞤡≮󟷺", .ascii = (const lxb_char_t *) "xn----g6j886c.xn--xpb049kk353abj99f", .status = 20} /* 3432 */,
    {.source = (const lxb_char_t *) "󠰆≯\u07B5𐻪．򊥕≮𑁆\u084C", .ascii = (const lxb_char_t *) "xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", .status = 16} /* 3433 */,
    {.source = (const lxb_char_t *) "󠰆>\u0338\u07B5𐻪．򊥕<\u0338𑁆\u084C", .ascii = (const lxb_char_t *) "xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", .status = 16} /* 3434 */,
    {.source = (const lxb_char_t *) "󠰆≯\u07B5𐻪.򊥕≮𑁆\u084C", .ascii = (const lxb_char_t *) "xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", .status = 16} /* 3435 */,
    {.source = (const lxb_char_t *) "󠰆>\u0338\u07B5𐻪.򊥕<\u0338𑁆\u084C", .ascii = (const lxb_char_t *) "xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", .status = 16} /* 3436 */,
    {.source = (const lxb_char_t *) "xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", .ascii = (const lxb_char_t *) "xn--zrb797kdm1oes34i.xn--bwb394k8k2o25n6d", .status = 16} /* 3437 */,
    {.source = (const lxb_char_t *) "≠󦋂.\u0600\u0BCD-\u06B9", .ascii = (const lxb_char_t *) "xn--1ch22084l.xn----qkc07co6n", .status = 8} /* 3438 */,
    {.source = (const lxb_char_t *) "=\u0338󦋂.\u0600\u0BCD-\u06B9", .ascii = (const lxb_char_t *) "xn--1ch22084l.xn----qkc07co6n", .status = 8} /* 3439 */,
    {.source = (const lxb_char_t *) "xn--1ch22084l.xn----qkc07co6n", .ascii = (const lxb_char_t *) "xn--1ch22084l.xn----qkc07co6n", .status = 8} /* 3440 */,
    {.source = (const lxb_char_t *) "\u17DD󠁣≠｡𐹼𐋤", .ascii = (const lxb_char_t *) "xn--54e694cn389z.xn--787ct8r", .status = 12} /* 3441 */,
    {.source = (const lxb_char_t *) "\u17DD󠁣=\u0338｡𐹼𐋤", .ascii = (const lxb_char_t *) "xn--54e694cn389z.xn--787ct8r", .status = 12} /* 3442 */,
    {.source = (const lxb_char_t *) "\u17DD󠁣≠。𐹼𐋤", .ascii = (const lxb_char_t *) "xn--54e694cn389z.xn--787ct8r", .status = 12} /* 3443 */,
    {.source = (const lxb_char_t *) "\u17DD󠁣=\u0338。𐹼𐋤", .ascii = (const lxb_char_t *) "xn--54e694cn389z.xn--787ct8r", .status = 12} /* 3444 */,
    {.source = (const lxb_char_t *) "xn--54e694cn389z.xn--787ct8r", .ascii = (const lxb_char_t *) "xn--54e694cn389z.xn--787ct8r", .status = 12} /* 3445 */,
    {.source = (const lxb_char_t *) "ß𰀻񆬗｡𝩨🕮ß", .ascii = (const lxb_char_t *) "xn--zca20040bgrkh.xn--zca3653v86qa", .status = 8} /* 3446 */,
    {.source = (const lxb_char_t *) "ß𰀻񆬗。𝩨🕮ß", .ascii = (const lxb_char_t *) "xn--zca20040bgrkh.xn--zca3653v86qa", .status = 8} /* 3447 */,
    {.source = (const lxb_char_t *) "SS𰀻񆬗。𝩨🕮SS", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3448 */,
    {.source = (const lxb_char_t *) "ss𰀻񆬗。𝩨🕮ss", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3449 */,
    {.source = (const lxb_char_t *) "Ss𰀻񆬗。𝩨🕮Ss", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3450 */,
    {.source = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3451 */,
    {.source = (const lxb_char_t *) "xn--zca20040bgrkh.xn--zca3653v86qa", .ascii = (const lxb_char_t *) "xn--zca20040bgrkh.xn--zca3653v86qa", .status = 8} /* 3452 */,
    {.source = (const lxb_char_t *) "SS𰀻񆬗｡𝩨🕮SS", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3453 */,
    {.source = (const lxb_char_t *) "ss𰀻񆬗｡𝩨🕮ss", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3454 */,
    {.source = (const lxb_char_t *) "Ss𰀻񆬗｡𝩨🕮Ss", .ascii = (const lxb_char_t *) "xn--ss-jl59biy67d.xn--ss-4d11aw87d", .status = 8} /* 3455 */,
    {.source = (const lxb_char_t *) "\u200D。\u200C", .ascii = (const lxb_char_t *) "xn--1ug.xn--0ug", .status = 8} /* 3456 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--0ug", .ascii = (const lxb_char_t *) "xn--1ug.xn--0ug", .status = 8} /* 3457 */,
    {.source = (const lxb_char_t *) "\u0483𐭞\u200D.\u17B9𞯌򟩚", .ascii = (const lxb_char_t *) "xn--m3a412lrr0o.xn--43e8670vmd79b", .status = 16} /* 3458 */,
    {.source = (const lxb_char_t *) "xn--m3a6965k.xn--43e8670vmd79b", .ascii = (const lxb_char_t *) "xn--m3a6965k.xn--43e8670vmd79b", .status = 12} /* 3459 */,
    {.source = (const lxb_char_t *) "xn--m3a412lrr0o.xn--43e8670vmd79b", .ascii = (const lxb_char_t *) "xn--m3a412lrr0o.xn--43e8670vmd79b", .status = 16} /* 3460 */,
    {.source = (const lxb_char_t *) "\u200C𐠨\u200C临。ꡢ򄷞ⶏ𐹣", .ascii = (const lxb_char_t *) "xn--0uga2656aop9k.xn--uojv340bk71c99u9f", .status = 20} /* 3461 */,
    {.source = (const lxb_char_t *) "xn--miq9646b.xn--uojv340bk71c99u9f", .ascii = (const lxb_char_t *) "xn--miq9646b.xn--uojv340bk71c99u9f", .status = 20} /* 3462 */,
    {.source = (const lxb_char_t *) "xn--0uga2656aop9k.xn--uojv340bk71c99u9f", .ascii = (const lxb_char_t *) "xn--0uga2656aop9k.xn--uojv340bk71c99u9f", .status = 20} /* 3463 */,
    {.source = (const lxb_char_t *) "󠑘．󠄮", .ascii = (const lxb_char_t *) "xn--s136e.", .status = 4} /* 3464 */,
    {.source = (const lxb_char_t *) "󠑘.󠄮", .ascii = (const lxb_char_t *) "xn--s136e.", .status = 4} /* 3465 */,
    {.source = (const lxb_char_t *) "xn--s136e.", .ascii = (const lxb_char_t *) "xn--s136e.", .status = 4} /* 3466 */,
    {.source = (const lxb_char_t *) "𐫄\u0D4D．\uAAF6", .ascii = (const lxb_char_t *) "xn--wxc7880k.xn--2v9a", .status = 8} /* 3467 */,
    {.source = (const lxb_char_t *) "𐫄\u0D4D.\uAAF6", .ascii = (const lxb_char_t *) "xn--wxc7880k.xn--2v9a", .status = 8} /* 3468 */,
    {.source = (const lxb_char_t *) "xn--wxc7880k.xn--2v9a", .ascii = (const lxb_char_t *) "xn--wxc7880k.xn--2v9a", .status = 8} /* 3469 */,
    {.source = (const lxb_char_t *) "\uA9B7󝵙멹。⒛󠨇", .ascii = (const lxb_char_t *) "xn--ym9av13acp85w.xn--dth22121k", .status = 8} /* 3470 */,
    {.source = (const lxb_char_t *) "\uA9B7󝵙멹。⒛󠨇", .ascii = (const lxb_char_t *) "xn--ym9av13acp85w.xn--dth22121k", .status = 8} /* 3471 */,
    {.source = (const lxb_char_t *) "\uA9B7󝵙멹。20.󠨇", .ascii = (const lxb_char_t *) "xn--ym9av13acp85w.20.xn--d846e", .status = 8} /* 3472 */,
    {.source = (const lxb_char_t *) "\uA9B7󝵙멹。20.󠨇", .ascii = (const lxb_char_t *) "xn--ym9av13acp85w.20.xn--d846e", .status = 8} /* 3473 */,
    {.source = (const lxb_char_t *) "xn--ym9av13acp85w.20.xn--d846e", .ascii = (const lxb_char_t *) "xn--ym9av13acp85w.20.xn--d846e", .status = 8} /* 3474 */,
    {.source = (const lxb_char_t *) "xn--ym9av13acp85w.xn--dth22121k", .ascii = (const lxb_char_t *) "xn--ym9av13acp85w.xn--dth22121k", .status = 8} /* 3475 */,
    {.source = (const lxb_char_t *) "Ⴅ󲬹릖󠶚.\u0777𐹳⒊", .ascii = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--7pb000mwm4n", .status = 12} /* 3476 */,
    {.source = (const lxb_char_t *) "Ⴅ󲬹릖󠶚.\u0777𐹳⒊", .ascii = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--7pb000mwm4n", .status = 12} /* 3477 */,
    {.source = (const lxb_char_t *) "Ⴅ󲬹릖󠶚.\u0777𐹳3.", .ascii = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--3-55c6803r.", .status = 12} /* 3478 */,
    {.source = (const lxb_char_t *) "Ⴅ󲬹릖󠶚.\u0777𐹳3.", .ascii = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--3-55c6803r.", .status = 12} /* 3479 */,
    {.source = (const lxb_char_t *) "ⴅ󲬹릖󠶚.\u0777𐹳3.", .ascii = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--3-55c6803r.", .status = 12} /* 3480 */,
    {.source = (const lxb_char_t *) "ⴅ󲬹릖󠶚.\u0777𐹳3.", .ascii = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--3-55c6803r.", .status = 12} /* 3481 */,
    {.source = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--3-55c6803r.", .ascii = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--3-55c6803r.", .status = 12} /* 3482 */,
    {.source = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--3-55c6803r.", .ascii = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--3-55c6803r.", .status = 12} /* 3483 */,
    {.source = (const lxb_char_t *) "ⴅ󲬹릖󠶚.\u0777𐹳⒊", .ascii = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--7pb000mwm4n", .status = 12} /* 3484 */,
    {.source = (const lxb_char_t *) "ⴅ󲬹릖󠶚.\u0777𐹳⒊", .ascii = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--7pb000mwm4n", .status = 12} /* 3485 */,
    {.source = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--7pb000mwm4n", .ascii = (const lxb_char_t *) "xn--wkj8016bne45io02g.xn--7pb000mwm4n", .status = 12} /* 3486 */,
    {.source = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--7pb000mwm4n", .ascii = (const lxb_char_t *) "xn--dnd2167fnet0io02g.xn--7pb000mwm4n", .status = 12} /* 3487 */,
    {.source = (const lxb_char_t *) "\u200C｡︒", .ascii = (const lxb_char_t *) "xn--0ug.xn--y86c", .status = 8} /* 3488 */,
    {.source = (const lxb_char_t *) "\u200C。。", .ascii = (const lxb_char_t *) "xn--0ug..", .status = 10} /* 3489 */,
    {.source = (const lxb_char_t *) "..", .ascii = (const lxb_char_t *) "..", .status = 6} /* 3490 */,
    {.source = (const lxb_char_t *) "xn--0ug..", .ascii = (const lxb_char_t *) "xn--0ug..", .status = 10} /* 3491 */,
    {.source = (const lxb_char_t *) ".xn--y86c", .ascii = (const lxb_char_t *) ".xn--y86c", .status = 10} /* 3492 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--y86c", .ascii = (const lxb_char_t *) "xn--0ug.xn--y86c", .status = 8} /* 3493 */,
    {.source = (const lxb_char_t *) "≯\u076D．₄", .ascii = (const lxb_char_t *) "xn--xpb149k.4", .status = 4} /* 3494 */,
    {.source = (const lxb_char_t *) ">\u0338\u076D．₄", .ascii = (const lxb_char_t *) "xn--xpb149k.4", .status = 4} /* 3495 */,
    {.source = (const lxb_char_t *) "≯\u076D.4", .ascii = (const lxb_char_t *) "xn--xpb149k.4", .status = 4} /* 3496 */,
    {.source = (const lxb_char_t *) ">\u0338\u076D.4", .ascii = (const lxb_char_t *) "xn--xpb149k.4", .status = 4} /* 3497 */,
    {.source = (const lxb_char_t *) "xn--xpb149k.4", .ascii = (const lxb_char_t *) "xn--xpb149k.4", .status = 4} /* 3498 */,
    {.source = (const lxb_char_t *) "ᡲ-𝟹.ß-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn-----fia9303a", .status = 8} /* 3499 */,
    {.source = (const lxb_char_t *) "ᡲ-3.ß-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn-----fia9303a", .status = 8} /* 3500 */,
    {.source = (const lxb_char_t *) "ᡲ-3.SS-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3501 */,
    {.source = (const lxb_char_t *) "ᡲ-3.ss-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3502 */,
    {.source = (const lxb_char_t *) "ᡲ-3.Ss-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3503 */,
    {.source = (const lxb_char_t *) "xn---3-p9o.ss--", .ascii = (const lxb_char_t *) "xn---3-p9o.ss--", .status = 8} /* 3504 */,
    {.source = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3505 */,
    {.source = (const lxb_char_t *) "xn---3-p9o.xn-----fia9303a", .ascii = (const lxb_char_t *) "xn---3-p9o.xn-----fia9303a", .status = 8} /* 3506 */,
    {.source = (const lxb_char_t *) "ᡲ-𝟹.SS-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3507 */,
    {.source = (const lxb_char_t *) "ᡲ-𝟹.ss-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3508 */,
    {.source = (const lxb_char_t *) "ᡲ-𝟹.Ss-\u200C-", .ascii = (const lxb_char_t *) "xn---3-p9o.xn--ss---276a", .status = 8} /* 3509 */,
    {.source = (const lxb_char_t *) "\uFD08𝟦\u0647󎊯｡Ӏ", .ascii = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--d5a", .status = 12} /* 3510 */,
    {.source = (const lxb_char_t *) "\u0636\u064A4\u0647󎊯。Ӏ", .ascii = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--d5a", .status = 12} /* 3511 */,
    {.source = (const lxb_char_t *) "\u0636\u064A4\u0647󎊯。ӏ", .ascii = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--s5a", .status = 12} /* 3512 */,
    {.source = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--s5a", .ascii = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--s5a", .status = 12} /* 3513 */,
    {.source = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--d5a", .ascii = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--d5a", .status = 12} /* 3514 */,
    {.source = (const lxb_char_t *) "\uFD08𝟦\u0647󎊯｡ӏ", .ascii = (const lxb_char_t *) "xn--4-tnc6ck183523b.xn--s5a", .status = 12} /* 3515 */,
    {.source = (const lxb_char_t *) "-.\u0602\u0622𑆾🐹", .ascii = (const lxb_char_t *) "-.xn--kfb8dy983hgl7g", .status = 12} /* 3516 */,
    {.source = (const lxb_char_t *) "-.\u0602\u0627\u0653𑆾🐹", .ascii = (const lxb_char_t *) "-.xn--kfb8dy983hgl7g", .status = 12} /* 3517 */,
    {.source = (const lxb_char_t *) "-.xn--kfb8dy983hgl7g", .ascii = (const lxb_char_t *) "-.xn--kfb8dy983hgl7g", .status = 12} /* 3518 */,
    {.source = (const lxb_char_t *) "󙶜ᢘ。\u1A7F⺢", .ascii = (const lxb_char_t *) "xn--ibf35138o.xn--fpfz94g", .status = 8} /* 3519 */,
    {.source = (const lxb_char_t *) "xn--ibf35138o.xn--fpfz94g", .ascii = (const lxb_char_t *) "xn--ibf35138o.xn--fpfz94g", .status = 8} /* 3520 */,
    {.source = (const lxb_char_t *) "≠ႷᠤႫ｡?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3521 */,
    {.source = (const lxb_char_t *) "=\u0338ႷᠤႫ｡?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3522 */,
    {.source = (const lxb_char_t *) "≠ႷᠤႫ。?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3523 */,
    {.source = (const lxb_char_t *) "=\u0338ႷᠤႫ。?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3524 */,
    {.source = (const lxb_char_t *) "=\u0338ⴗᠤⴋ。?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3525 */,
    {.source = (const lxb_char_t *) "≠ⴗᠤⴋ。?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3526 */,
    {.source = (const lxb_char_t *) "≠Ⴗᠤⴋ。?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3527 */,
    {.source = (const lxb_char_t *) "=\u0338Ⴗᠤⴋ。?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3528 */,
    {.source = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3529 */,
    {.source = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3530 */,
    {.source = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3531 */,
    {.source = (const lxb_char_t *) "=\u0338ⴗᠤⴋ｡?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3532 */,
    {.source = (const lxb_char_t *) "≠ⴗᠤⴋ｡?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3533 */,
    {.source = (const lxb_char_t *) "≠Ⴗᠤⴋ｡?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3534 */,
    {.source = (const lxb_char_t *) "=\u0338Ⴗᠤⴋ｡?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3535 */,
    {.source = (const lxb_char_t *) "xn--vnd619as6ig6k.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3536 */,
    {.source = (const lxb_char_t *) "XN--VND619AS6IG6K.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3537 */,
    {.source = (const lxb_char_t *) "Xn--Vnd619as6ig6k.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--vnd619as6ig6k.xn--?-7fb34t0u7s", .status = 8} /* 3538 */,
    {.source = (const lxb_char_t *) "xn--66e353ce0ilb.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3539 */,
    {.source = (const lxb_char_t *) "XN--66E353CE0ILB.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3540 */,
    {.source = (const lxb_char_t *) "Xn--66e353ce0ilb.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--66e353ce0ilb.xn--?-7fb34t0u7s", .status = 8} /* 3541 */,
    {.source = (const lxb_char_t *) "xn--jndx718cnnl.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3542 */,
    {.source = (const lxb_char_t *) "XN--JNDX718CNNL.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3543 */,
    {.source = (const lxb_char_t *) "Xn--Jndx718cnnl.?\u034C\u0633觴", .ascii = (const lxb_char_t *) "xn--jndx718cnnl.xn--?-7fb34t0u7s", .status = 8} /* 3544 */,
    {.source = (const lxb_char_t *) "\u0667.𐥨", .ascii = (const lxb_char_t *) "xn--gib.xn--vm9c", .status = 8} /* 3545 */,
    {.source = (const lxb_char_t *) "xn--gib.xn--vm9c", .ascii = (const lxb_char_t *) "xn--gib.xn--vm9c", .status = 8} /* 3546 */,
    {.source = (const lxb_char_t *) "\uA9C0𝟯｡\u200D񼑥𐹪\u1BF3", .ascii = (const lxb_char_t *) "xn--3-5z4e.xn--1zf96ony8ygd68c", .status = 16} /* 3547 */,
    {.source = (const lxb_char_t *) "\uA9C03。\u200D񼑥𐹪\u1BF3", .ascii = (const lxb_char_t *) "xn--3-5z4e.xn--1zf96ony8ygd68c", .status = 16} /* 3548 */,
    {.source = (const lxb_char_t *) "xn--3-5z4e.xn--1zfz754hncv8b", .ascii = (const lxb_char_t *) "xn--3-5z4e.xn--1zfz754hncv8b", .status = 12} /* 3549 */,
    {.source = (const lxb_char_t *) "xn--3-5z4e.xn--1zf96ony8ygd68c", .ascii = (const lxb_char_t *) "xn--3-5z4e.xn--1zf96ony8ygd68c", .status = 16} /* 3550 */,
    {.source = (const lxb_char_t *) "򣕄4񠖽.≯\u0664𑀾󠸌", .ascii = (const lxb_char_t *) "xn--4-fg85dl688i.xn--dib174li86ntdy0i", .status = 8} /* 3551 */,
    {.source = (const lxb_char_t *) "򣕄4񠖽.>\u0338\u0664𑀾󠸌", .ascii = (const lxb_char_t *) "xn--4-fg85dl688i.xn--dib174li86ntdy0i", .status = 8} /* 3552 */,
    {.source = (const lxb_char_t *) "xn--4-fg85dl688i.xn--dib174li86ntdy0i", .ascii = (const lxb_char_t *) "xn--4-fg85dl688i.xn--dib174li86ntdy0i", .status = 8} /* 3553 */,
    {.source = (const lxb_char_t *) "򗆧𝟯。⒈\u1A76𝟚򠘌", .ascii = (const lxb_char_t *) "xn--3-rj42h.xn--2-13k746cq465x", .status = 4} /* 3554 */,
    {.source = (const lxb_char_t *) "򗆧3。1.\u1A762򠘌", .ascii = (const lxb_char_t *) "xn--3-rj42h.1.xn--2-13k96240l", .status = 8} /* 3555 */,
    {.source = (const lxb_char_t *) "xn--3-rj42h.1.xn--2-13k96240l", .ascii = (const lxb_char_t *) "xn--3-rj42h.1.xn--2-13k96240l", .status = 8} /* 3556 */,
    {.source = (const lxb_char_t *) "xn--3-rj42h.xn--2-13k746cq465x", .ascii = (const lxb_char_t *) "xn--3-rj42h.xn--2-13k746cq465x", .status = 4} /* 3557 */,
    {.source = (const lxb_char_t *) "\u200D₅⒈。≯𝟴\u200D", .ascii = (const lxb_char_t *) "xn--5-tgnz5r.xn--8-ugn00i", .status = 8} /* 3558 */,
    {.source = (const lxb_char_t *) "\u200D₅⒈。>\u0338𝟴\u200D", .ascii = (const lxb_char_t *) "xn--5-tgnz5r.xn--8-ugn00i", .status = 8} /* 3559 */,
    {.source = (const lxb_char_t *) "\u200D51.。≯8\u200D", .ascii = (const lxb_char_t *) "xn--51-l1t..xn--8-ugn00i", .status = 10} /* 3560 */,
    {.source = (const lxb_char_t *) "\u200D51.。>\u03388\u200D", .ascii = (const lxb_char_t *) "xn--51-l1t..xn--8-ugn00i", .status = 10} /* 3561 */,
    {.source = (const lxb_char_t *) "51..xn--8-ogo", .ascii = (const lxb_char_t *) "51..xn--8-ogo", .status = 6} /* 3562 */,
    {.source = (const lxb_char_t *) "xn--51-l1t..xn--8-ugn00i", .ascii = (const lxb_char_t *) "xn--51-l1t..xn--8-ugn00i", .status = 10} /* 3563 */,
    {.source = (const lxb_char_t *) "xn--5-ecp.xn--8-ogo", .ascii = (const lxb_char_t *) "xn--5-ecp.xn--8-ogo", .status = 4} /* 3564 */,
    {.source = (const lxb_char_t *) "xn--5-tgnz5r.xn--8-ugn00i", .ascii = (const lxb_char_t *) "xn--5-tgnz5r.xn--8-ugn00i", .status = 8} /* 3565 */,
    {.source = (const lxb_char_t *) "ꡰ\u0697\u1086．򪘙\u072F≠\u200C", .ascii = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb448jcubcz547b", .status = 16} /* 3566 */,
    {.source = (const lxb_char_t *) "ꡰ\u0697\u1086．򪘙\u072F=\u0338\u200C", .ascii = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb448jcubcz547b", .status = 16} /* 3567 */,
    {.source = (const lxb_char_t *) "ꡰ\u0697\u1086.򪘙\u072F≠\u200C", .ascii = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb448jcubcz547b", .status = 16} /* 3568 */,
    {.source = (const lxb_char_t *) "ꡰ\u0697\u1086.򪘙\u072F=\u0338\u200C", .ascii = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb448jcubcz547b", .status = 16} /* 3569 */,
    {.source = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb630lbj91q", .ascii = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb630lbj91q", .status = 12} /* 3570 */,
    {.source = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb448jcubcz547b", .ascii = (const lxb_char_t *) "xn--tjb002cn51k.xn--5nb448jcubcz547b", .status = 16} /* 3571 */,
    {.source = (const lxb_char_t *) "𑄱｡򪌿𐹵", .ascii = (const lxb_char_t *) "xn--t80d.xn--to0d14792b", .status = 20} /* 3572 */,
    {.source = (const lxb_char_t *) "𑄱。򪌿𐹵", .ascii = (const lxb_char_t *) "xn--t80d.xn--to0d14792b", .status = 20} /* 3573 */,
    {.source = (const lxb_char_t *) "xn--t80d.xn--to0d14792b", .ascii = (const lxb_char_t *) "xn--t80d.xn--to0d14792b", .status = 20} /* 3574 */,
    {.source = (const lxb_char_t *) "𝟥\u0600。\u073D", .ascii = (const lxb_char_t *) "xn--3-rkc.xn--kob", .status = 12} /* 3575 */,
    {.source = (const lxb_char_t *) "3\u0600。\u073D", .ascii = (const lxb_char_t *) "xn--3-rkc.xn--kob", .status = 12} /* 3576 */,
    {.source = (const lxb_char_t *) "xn--3-rkc.xn--kob", .ascii = (const lxb_char_t *) "xn--3-rkc.xn--kob", .status = 12} /* 3577 */,
    {.source = (const lxb_char_t *) "\u0637𐹣\u0666.\u076D긷", .ascii = (const lxb_char_t *) "xn--2gb8gu829f.xn--xpb0156f", .status = 8} /* 3578 */,
    {.source = (const lxb_char_t *) "\u0637𐹣\u0666.\u076D긷", .ascii = (const lxb_char_t *) "xn--2gb8gu829f.xn--xpb0156f", .status = 8} /* 3579 */,
    {.source = (const lxb_char_t *) "xn--2gb8gu829f.xn--xpb0156f", .ascii = (const lxb_char_t *) "xn--2gb8gu829f.xn--xpb0156f", .status = 8} /* 3580 */,
    {.source = (const lxb_char_t *) "︒Ↄ\u2DE7򾀃．Ⴗ𐣞", .ascii = (const lxb_char_t *) "xn--q5g000c056n0226g.xn--vnd8618j", .status = 16} /* 3581 */,
    {.source = (const lxb_char_t *) "。Ↄ\u2DE7򾀃.Ⴗ𐣞", .ascii = (const lxb_char_t *) ".xn--q5g000cll06u.xn--vnd8618j", .status = 18} /* 3582 */,
    {.source = (const lxb_char_t *) "。ↄ\u2DE7򾀃.ⴗ𐣞", .ascii = (const lxb_char_t *) ".xn--r5gy00cll06u.xn--flj4541e", .status = 18} /* 3583 */,
    {.source = (const lxb_char_t *) ".xn--r5gy00cll06u.xn--flj4541e", .ascii = (const lxb_char_t *) ".xn--r5gy00cll06u.xn--flj4541e", .status = 18} /* 3584 */,
    {.source = (const lxb_char_t *) ".xn--q5g000cll06u.xn--vnd8618j", .ascii = (const lxb_char_t *) ".xn--q5g000cll06u.xn--vnd8618j", .status = 18} /* 3585 */,
    {.source = (const lxb_char_t *) "︒ↄ\u2DE7򾀃．ⴗ𐣞", .ascii = (const lxb_char_t *) "xn--r5gy00c056n0226g.xn--flj4541e", .status = 16} /* 3586 */,
    {.source = (const lxb_char_t *) "xn--r5gy00c056n0226g.xn--flj4541e", .ascii = (const lxb_char_t *) "xn--r5gy00c056n0226g.xn--flj4541e", .status = 16} /* 3587 */,
    {.source = (const lxb_char_t *) "xn--q5g000c056n0226g.xn--vnd8618j", .ascii = (const lxb_char_t *) "xn--q5g000c056n0226g.xn--vnd8618j", .status = 16} /* 3588 */,
    {.source = (const lxb_char_t *) "\u0600.\u05B1", .ascii = (const lxb_char_t *) "xn--ifb.xn--8cb", .status = 12} /* 3589 */,
    {.source = (const lxb_char_t *) "xn--ifb.xn--8cb", .ascii = (const lxb_char_t *) "xn--ifb.xn--8cb", .status = 12} /* 3590 */,
    {.source = (const lxb_char_t *) "ς≯｡𐹽", .ascii = (const lxb_char_t *) "xn--3xa028m.xn--1o0d", .status = 8} /* 3591 */,
    {.source = (const lxb_char_t *) "ς>\u0338｡𐹽", .ascii = (const lxb_char_t *) "xn--3xa028m.xn--1o0d", .status = 8} /* 3592 */,
    {.source = (const lxb_char_t *) "ς≯。𐹽", .ascii = (const lxb_char_t *) "xn--3xa028m.xn--1o0d", .status = 8} /* 3593 */,
    {.source = (const lxb_char_t *) "ς>\u0338。𐹽", .ascii = (const lxb_char_t *) "xn--3xa028m.xn--1o0d", .status = 8} /* 3594 */,
    {.source = (const lxb_char_t *) "Σ>\u0338。𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3595 */,
    {.source = (const lxb_char_t *) "Σ≯。𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3596 */,
    {.source = (const lxb_char_t *) "σ≯。𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3597 */,
    {.source = (const lxb_char_t *) "σ>\u0338。𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3598 */,
    {.source = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3599 */,
    {.source = (const lxb_char_t *) "xn--3xa028m.xn--1o0d", .ascii = (const lxb_char_t *) "xn--3xa028m.xn--1o0d", .status = 8} /* 3600 */,
    {.source = (const lxb_char_t *) "Σ>\u0338｡𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3601 */,
    {.source = (const lxb_char_t *) "Σ≯｡𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3602 */,
    {.source = (const lxb_char_t *) "σ≯｡𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3603 */,
    {.source = (const lxb_char_t *) "σ>\u0338｡𐹽", .ascii = (const lxb_char_t *) "xn--4xa818m.xn--1o0d", .status = 8} /* 3604 */,
    {.source = (const lxb_char_t *) "\u17D2\u200D\u075F。𐹶", .ascii = (const lxb_char_t *) "xn--jpb535fv9f.xn--uo0d", .status = 8} /* 3605 */,
    {.source = (const lxb_char_t *) "xn--jpb535f.xn--uo0d", .ascii = (const lxb_char_t *) "xn--jpb535f.xn--uo0d", .status = 8} /* 3606 */,
    {.source = (const lxb_char_t *) "xn--jpb535fv9f.xn--uo0d", .ascii = (const lxb_char_t *) "xn--jpb535fv9f.xn--uo0d", .status = 8} /* 3607 */,
    {.source = (const lxb_char_t *) "𾷂\u0A42Ⴊ񂂟.≮", .ascii = (const lxb_char_t *) "xn--nbc493aro75ggskb.xn--gdh", .status = 4} /* 3608 */,
    {.source = (const lxb_char_t *) "𾷂\u0A42Ⴊ񂂟.<\u0338", .ascii = (const lxb_char_t *) "xn--nbc493aro75ggskb.xn--gdh", .status = 4} /* 3609 */,
    {.source = (const lxb_char_t *) "𾷂\u0A42ⴊ񂂟.<\u0338", .ascii = (const lxb_char_t *) "xn--nbc229o4y27dgskb.xn--gdh", .status = 4} /* 3610 */,
    {.source = (const lxb_char_t *) "𾷂\u0A42ⴊ񂂟.≮", .ascii = (const lxb_char_t *) "xn--nbc229o4y27dgskb.xn--gdh", .status = 4} /* 3611 */,
    {.source = (const lxb_char_t *) "xn--nbc229o4y27dgskb.xn--gdh", .ascii = (const lxb_char_t *) "xn--nbc229o4y27dgskb.xn--gdh", .status = 4} /* 3612 */,
    {.source = (const lxb_char_t *) "xn--nbc493aro75ggskb.xn--gdh", .ascii = (const lxb_char_t *) "xn--nbc493aro75ggskb.xn--gdh", .status = 4} /* 3613 */,
    {.source = (const lxb_char_t *) "ꡠ．۲", .ascii = (const lxb_char_t *) "xn--5c9a.xn--fmb", .status = 0} /* 3614 */,
    {.source = (const lxb_char_t *) "ꡠ.۲", .ascii = (const lxb_char_t *) "xn--5c9a.xn--fmb", .status = 0} /* 3615 */,
    {.source = (const lxb_char_t *) "xn--5c9a.xn--fmb", .ascii = (const lxb_char_t *) "xn--5c9a.xn--fmb", .status = 0} /* 3616 */,
    {.source = (const lxb_char_t *) "𐹣񄷄｡ꡬ🄄", .ascii = (const lxb_char_t *) "xn--bo0d0203l.xn--id9a4443d", .status = 8} /* 3617 */,
    {.source = (const lxb_char_t *) "𐹣񄷄。ꡬ3,", .ascii = (const lxb_char_t *) "xn--bo0d0203l.xn--3,-yj9h", .status = 12} /* 3618 */,
    {.source = (const lxb_char_t *) "xn--bo0d0203l.xn--3,-yj9h", .ascii = (const lxb_char_t *) "xn--bo0d0203l.xn--3,-yj9h", .status = 12} /* 3619 */,
    {.source = (const lxb_char_t *) "xn--bo0d0203l.xn--id9a4443d", .ascii = (const lxb_char_t *) "xn--bo0d0203l.xn--id9a4443d", .status = 8} /* 3620 */,
    {.source = (const lxb_char_t *) "-\u0C4D𞾀𑲓｡\u200D\u0D4D", .ascii = (const lxb_char_t *) "xn----x6e0220sclug.xn--wxc317g", .status = 16} /* 3621 */,
    {.source = (const lxb_char_t *) "-\u0C4D𞾀𑲓。\u200D\u0D4D", .ascii = (const lxb_char_t *) "xn----x6e0220sclug.xn--wxc317g", .status = 16} /* 3622 */,
    {.source = (const lxb_char_t *) "xn----x6e0220sclug.xn--wxc", .ascii = (const lxb_char_t *) "xn----x6e0220sclug.xn--wxc", .status = 16} /* 3623 */,
    {.source = (const lxb_char_t *) "xn----x6e0220sclug.xn--wxc317g", .ascii = (const lxb_char_t *) "xn----x6e0220sclug.xn--wxc317g", .status = 16} /* 3624 */,
    {.source = (const lxb_char_t *) "\uA67D\u200C霣🄆｡\u200C𑁂\u1B01", .ascii = (const lxb_char_t *) "xn--0ug4208b2vjuk63a.xn--4sf36u6u4w", .status = 12} /* 3625 */,
    {.source = (const lxb_char_t *) "\uA67D\u200C霣🄆｡\u200C𑁂\u1B01", .ascii = (const lxb_char_t *) "xn--0ug4208b2vjuk63a.xn--4sf36u6u4w", .status = 12} /* 3626 */,
    {.source = (const lxb_char_t *) "\uA67D\u200C霣5,。\u200C𑁂\u1B01", .ascii = (const lxb_char_t *) "xn--5,-i1tz135dnbqa.xn--4sf36u6u4w", .status = 12} /* 3627 */,
    {.source = (const lxb_char_t *) "xn--5,-op8g373c.xn--4sf0725i", .ascii = (const lxb_char_t *) "xn--5,-op8g373c.xn--4sf0725i", .status = 8} /* 3628 */,
    {.source = (const lxb_char_t *) "xn--5,-i1tz135dnbqa.xn--4sf36u6u4w", .ascii = (const lxb_char_t *) "xn--5,-i1tz135dnbqa.xn--4sf36u6u4w", .status = 12} /* 3629 */,
    {.source = (const lxb_char_t *) "xn--2q5a751a653w.xn--4sf0725i", .ascii = (const lxb_char_t *) "xn--2q5a751a653w.xn--4sf0725i", .status = 8} /* 3630 */,
    {.source = (const lxb_char_t *) "xn--0ug4208b2vjuk63a.xn--4sf36u6u4w", .ascii = (const lxb_char_t *) "xn--0ug4208b2vjuk63a.xn--4sf36u6u4w", .status = 12} /* 3631 */,
    {.source = (const lxb_char_t *) "兎｡ᠼ󠴜𑚶𑰿", .ascii = (const lxb_char_t *) "xn--b5q.xn--v7e6041kqqd4m251b", .status = 4} /* 3632 */,
    {.source = (const lxb_char_t *) "兎。ᠼ󠴜𑚶𑰿", .ascii = (const lxb_char_t *) "xn--b5q.xn--v7e6041kqqd4m251b", .status = 4} /* 3633 */,
    {.source = (const lxb_char_t *) "xn--b5q.xn--v7e6041kqqd4m251b", .ascii = (const lxb_char_t *) "xn--b5q.xn--v7e6041kqqd4m251b", .status = 4} /* 3634 */,
    {.source = (const lxb_char_t *) "𝟙｡\u200D𝟸\u200D⁷", .ascii = (const lxb_char_t *) "1.xn--27-l1tb", .status = 4} /* 3635 */,
    {.source = (const lxb_char_t *) "1。\u200D2\u200D7", .ascii = (const lxb_char_t *) "1.xn--27-l1tb", .status = 4} /* 3636 */,
    {.source = (const lxb_char_t *) "1.27", .ascii = (const lxb_char_t *) "1.27", .status = 0} /* 3637 */,
    {.source = (const lxb_char_t *) "1.xn--27-l1tb", .ascii = (const lxb_char_t *) "1.xn--27-l1tb", .status = 4} /* 3638 */,
    {.source = (const lxb_char_t *) "ᡨ-｡󠻋𝟷", .ascii = (const lxb_char_t *) "xn----z8j.xn--1-5671m", .status = 8} /* 3639 */,
    {.source = (const lxb_char_t *) "ᡨ-。󠻋1", .ascii = (const lxb_char_t *) "xn----z8j.xn--1-5671m", .status = 8} /* 3640 */,
    {.source = (const lxb_char_t *) "xn----z8j.xn--1-5671m", .ascii = (const lxb_char_t *) "xn----z8j.xn--1-5671m", .status = 8} /* 3641 */,
    {.source = (const lxb_char_t *) "𑰻񵀐𐫚．\u0668⁹", .ascii = (const lxb_char_t *) "xn--gx9cr01aul57i.xn--9-oqc", .status = 12} /* 3642 */,
    {.source = (const lxb_char_t *) "𑰻񵀐𐫚.\u06689", .ascii = (const lxb_char_t *) "xn--gx9cr01aul57i.xn--9-oqc", .status = 12} /* 3643 */,
    {.source = (const lxb_char_t *) "xn--gx9cr01aul57i.xn--9-oqc", .ascii = (const lxb_char_t *) "xn--gx9cr01aul57i.xn--9-oqc", .status = 12} /* 3644 */,
    {.source = (const lxb_char_t *) "Ⴜ򈷭\u0F80⾇。Ⴏ♀\u200C\u200C", .ascii = (const lxb_char_t *) "xn--zed54dz10wo343g.xn--nnd089ea464d", .status = 8} /* 3645 */,
    {.source = (const lxb_char_t *) "Ⴜ򈷭\u0F80舛。Ⴏ♀\u200C\u200C", .ascii = (const lxb_char_t *) "xn--zed54dz10wo343g.xn--nnd089ea464d", .status = 8} /* 3646 */,
    {.source = (const lxb_char_t *) "ⴜ򈷭\u0F80舛。ⴏ♀\u200C\u200C", .ascii = (const lxb_char_t *) "xn--zed372mdj2do3v4h.xn--0uga678bgyh", .status = 8} /* 3647 */,
    {.source = (const lxb_char_t *) "xn--zed372mdj2do3v4h.xn--e5h11w", .ascii = (const lxb_char_t *) "xn--zed372mdj2do3v4h.xn--e5h11w", .status = 4} /* 3648 */,
    {.source = (const lxb_char_t *) "xn--zed372mdj2do3v4h.xn--0uga678bgyh", .ascii = (const lxb_char_t *) "xn--zed372mdj2do3v4h.xn--0uga678bgyh", .status = 8} /* 3649 */,
    {.source = (const lxb_char_t *) "xn--zed54dz10wo343g.xn--nnd651i", .ascii = (const lxb_char_t *) "xn--zed54dz10wo343g.xn--nnd651i", .status = 4} /* 3650 */,
    {.source = (const lxb_char_t *) "xn--zed54dz10wo343g.xn--nnd089ea464d", .ascii = (const lxb_char_t *) "xn--zed54dz10wo343g.xn--nnd089ea464d", .status = 8} /* 3651 */,
    {.source = (const lxb_char_t *) "ⴜ򈷭\u0F80⾇。ⴏ♀\u200C\u200C", .ascii = (const lxb_char_t *) "xn--zed372mdj2do3v4h.xn--0uga678bgyh", .status = 8} /* 3652 */,
    {.source = (const lxb_char_t *) "𑁆𝟰.\u200D", .ascii = (const lxb_char_t *) "xn--4-xu7i.xn--1ug", .status = 8} /* 3653 */,
    {.source = (const lxb_char_t *) "𑁆4.\u200D", .ascii = (const lxb_char_t *) "xn--4-xu7i.xn--1ug", .status = 8} /* 3654 */,
    {.source = (const lxb_char_t *) "xn--4-xu7i.", .ascii = (const lxb_char_t *) "xn--4-xu7i.", .status = 4} /* 3655 */,
    {.source = (const lxb_char_t *) "xn--4-xu7i.xn--1ug", .ascii = (const lxb_char_t *) "xn--4-xu7i.xn--1ug", .status = 8} /* 3656 */,
    {.source = (const lxb_char_t *) "񮴘Ⴞ癀｡𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--0ugb6122js83c", .status = 12} /* 3657 */,
    {.source = (const lxb_char_t *) "񮴘Ⴞ癀｡𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--0ugb6122js83c", .status = 12} /* 3658 */,
    {.source = (const lxb_char_t *) "񮴘Ⴞ癀。𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--0ugb6122js83c", .status = 12} /* 3659 */,
    {.source = (const lxb_char_t *) "񮴘Ⴞ癀。𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--0ugb6122js83c", .status = 12} /* 3660 */,
    {.source = (const lxb_char_t *) "񮴘ⴞ癀。𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--0ugb6122js83c", .status = 12} /* 3661 */,
    {.source = (const lxb_char_t *) "񮴘ⴞ癀。𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--0ugb6122js83c", .status = 12} /* 3662 */,
    {.source = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--et3bn23n", .ascii = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--et3bn23n", .status = 8} /* 3663 */,
    {.source = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--0ugb6122js83c", .ascii = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--0ugb6122js83c", .status = 12} /* 3664 */,
    {.source = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--et3bn23n", .ascii = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--et3bn23n", .status = 8} /* 3665 */,
    {.source = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--0ugb6122js83c", .ascii = (const lxb_char_t *) "xn--2nd6803c7q37d.xn--0ugb6122js83c", .status = 12} /* 3666 */,
    {.source = (const lxb_char_t *) "񮴘ⴞ癀｡𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--0ugb6122js83c", .status = 12} /* 3667 */,
    {.source = (const lxb_char_t *) "񮴘ⴞ癀｡𑘿\u200D\u200C붼", .ascii = (const lxb_char_t *) "xn--mlju35u7qx2f.xn--0ugb6122js83c", .status = 12} /* 3668 */,
    {.source = (const lxb_char_t *) "󚀅-\u0BCD。\u06B9", .ascii = (const lxb_char_t *) "xn----mze84808x.xn--skb", .status = 8} /* 3669 */,
    {.source = (const lxb_char_t *) "xn----mze84808x.xn--skb", .ascii = (const lxb_char_t *) "xn----mze84808x.xn--skb", .status = 8} /* 3670 */,
    {.source = (const lxb_char_t *) "ᡃ𝟧≯ᠣ．氁񨏱ꁫ", .ascii = (const lxb_char_t *) "xn--5-24jyf768b.xn--lqw213ime95g", .status = 4} /* 3671 */,
    {.source = (const lxb_char_t *) "ᡃ𝟧>\u0338ᠣ．氁񨏱ꁫ", .ascii = (const lxb_char_t *) "xn--5-24jyf768b.xn--lqw213ime95g", .status = 4} /* 3672 */,
    {.source = (const lxb_char_t *) "ᡃ5≯ᠣ.氁񨏱ꁫ", .ascii = (const lxb_char_t *) "xn--5-24jyf768b.xn--lqw213ime95g", .status = 4} /* 3673 */,
    {.source = (const lxb_char_t *) "ᡃ5>\u0338ᠣ.氁񨏱ꁫ", .ascii = (const lxb_char_t *) "xn--5-24jyf768b.xn--lqw213ime95g", .status = 4} /* 3674 */,
    {.source = (const lxb_char_t *) "xn--5-24jyf768b.xn--lqw213ime95g", .ascii = (const lxb_char_t *) "xn--5-24jyf768b.xn--lqw213ime95g", .status = 4} /* 3675 */,
    {.source = (const lxb_char_t *) "𐹬𝩇．\u0F76", .ascii = (const lxb_char_t *) "xn--ko0d8295a.xn--zed3h", .status = 8} /* 3676 */,
    {.source = (const lxb_char_t *) "𐹬𝩇．\u0FB2\u0F80", .ascii = (const lxb_char_t *) "xn--ko0d8295a.xn--zed3h", .status = 8} /* 3677 */,
    {.source = (const lxb_char_t *) "𐹬𝩇.\u0FB2\u0F80", .ascii = (const lxb_char_t *) "xn--ko0d8295a.xn--zed3h", .status = 8} /* 3678 */,
    {.source = (const lxb_char_t *) "xn--ko0d8295a.xn--zed3h", .ascii = (const lxb_char_t *) "xn--ko0d8295a.xn--zed3h", .status = 8} /* 3679 */,
    {.source = (const lxb_char_t *) "-𑈶⒏．⒎𰛢󠎭", .ascii = (const lxb_char_t *) "xn----scp6252h.xn--zshy411yzpx2d", .status = 8} /* 3680 */,
    {.source = (const lxb_char_t *) "-𑈶8..7.𰛢󠎭", .ascii = (const lxb_char_t *) "xn---8-bv5o..7.xn--c35nf1622b", .status = 14} /* 3681 */,
    {.source = (const lxb_char_t *) "xn---8-bv5o..7.xn--c35nf1622b", .ascii = (const lxb_char_t *) "xn---8-bv5o..7.xn--c35nf1622b", .status = 14} /* 3682 */,
    {.source = (const lxb_char_t *) "xn----scp6252h.xn--zshy411yzpx2d", .ascii = (const lxb_char_t *) "xn----scp6252h.xn--zshy411yzpx2d", .status = 8} /* 3683 */,
    {.source = (const lxb_char_t *) "\u200CႡ畝\u200D．≮", .ascii = (const lxb_char_t *) "xn--8md700fea3748f.xn--gdh", .status = 12} /* 3684 */,
    {.source = (const lxb_char_t *) "\u200CႡ畝\u200D．<\u0338", .ascii = (const lxb_char_t *) "xn--8md700fea3748f.xn--gdh", .status = 12} /* 3685 */,
    {.source = (const lxb_char_t *) "\u200CႡ畝\u200D.≮", .ascii = (const lxb_char_t *) "xn--8md700fea3748f.xn--gdh", .status = 12} /* 3686 */,
    {.source = (const lxb_char_t *) "\u200CႡ畝\u200D.<\u0338", .ascii = (const lxb_char_t *) "xn--8md700fea3748f.xn--gdh", .status = 12} /* 3687 */,
    {.source = (const lxb_char_t *) "\u200Cⴁ畝\u200D.<\u0338", .ascii = (const lxb_char_t *) "xn--0ugc160hb36e.xn--gdh", .status = 8} /* 3688 */,
    {.source = (const lxb_char_t *) "\u200Cⴁ畝\u200D.≮", .ascii = (const lxb_char_t *) "xn--0ugc160hb36e.xn--gdh", .status = 8} /* 3689 */,
    {.source = (const lxb_char_t *) "xn--skjy82u.xn--gdh", .ascii = (const lxb_char_t *) "xn--skjy82u.xn--gdh", .status = 0} /* 3690 */,
    {.source = (const lxb_char_t *) "ⴁ畝.≮", .ascii = (const lxb_char_t *) "xn--skjy82u.xn--gdh", .status = 0} /* 3691 */,
    {.source = (const lxb_char_t *) "ⴁ畝.<\u0338", .ascii = (const lxb_char_t *) "xn--skjy82u.xn--gdh", .status = 0} /* 3692 */,
    {.source = (const lxb_char_t *) "Ⴁ畝.<\u0338", .ascii = (const lxb_char_t *) "xn--8md0962c.xn--gdh", .status = 4} /* 3693 */,
    {.source = (const lxb_char_t *) "Ⴁ畝.≮", .ascii = (const lxb_char_t *) "xn--8md0962c.xn--gdh", .status = 4} /* 3694 */,
    {.source = (const lxb_char_t *) "xn--8md0962c.xn--gdh", .ascii = (const lxb_char_t *) "xn--8md0962c.xn--gdh", .status = 4} /* 3695 */,
    {.source = (const lxb_char_t *) "xn--0ugc160hb36e.xn--gdh", .ascii = (const lxb_char_t *) "xn--0ugc160hb36e.xn--gdh", .status = 8} /* 3696 */,
    {.source = (const lxb_char_t *) "xn--8md700fea3748f.xn--gdh", .ascii = (const lxb_char_t *) "xn--8md700fea3748f.xn--gdh", .status = 12} /* 3697 */,
    {.source = (const lxb_char_t *) "\u200Cⴁ畝\u200D．<\u0338", .ascii = (const lxb_char_t *) "xn--0ugc160hb36e.xn--gdh", .status = 8} /* 3698 */,
    {.source = (const lxb_char_t *) "\u200Cⴁ畝\u200D．≮", .ascii = (const lxb_char_t *) "xn--0ugc160hb36e.xn--gdh", .status = 8} /* 3699 */,
    {.source = (const lxb_char_t *) "歷｡𐹻≯󳛽\u200D", .ascii = (const lxb_char_t *) "xn--nmw.xn--1ugx6gs128a1134j", .status = 12} /* 3700 */,
    {.source = (const lxb_char_t *) "歷｡𐹻>\u0338󳛽\u200D", .ascii = (const lxb_char_t *) "xn--nmw.xn--1ugx6gs128a1134j", .status = 12} /* 3701 */,
    {.source = (const lxb_char_t *) "歷。𐹻≯󳛽\u200D", .ascii = (const lxb_char_t *) "xn--nmw.xn--1ugx6gs128a1134j", .status = 12} /* 3702 */,
    {.source = (const lxb_char_t *) "歷。𐹻>\u0338󳛽\u200D", .ascii = (const lxb_char_t *) "xn--nmw.xn--1ugx6gs128a1134j", .status = 12} /* 3703 */,
    {.source = (const lxb_char_t *) "xn--nmw.xn--hdh7804gdms2h", .ascii = (const lxb_char_t *) "xn--nmw.xn--hdh7804gdms2h", .status = 8} /* 3704 */,
    {.source = (const lxb_char_t *) "xn--nmw.xn--1ugx6gs128a1134j", .ascii = (const lxb_char_t *) "xn--nmw.xn--1ugx6gs128a1134j", .status = 12} /* 3705 */,
    {.source = (const lxb_char_t *) "\u0ECB\u200D．鎁󠰑", .ascii = (const lxb_char_t *) "xn--t8c059f.xn--iz4a43209d", .status = 12} /* 3706 */,
    {.source = (const lxb_char_t *) "\u0ECB\u200D.鎁󠰑", .ascii = (const lxb_char_t *) "xn--t8c059f.xn--iz4a43209d", .status = 12} /* 3707 */,
    {.source = (const lxb_char_t *) "xn--t8c.xn--iz4a43209d", .ascii = (const lxb_char_t *) "xn--t8c.xn--iz4a43209d", .status = 8} /* 3708 */,
    {.source = (const lxb_char_t *) "xn--t8c059f.xn--iz4a43209d", .ascii = (const lxb_char_t *) "xn--t8c059f.xn--iz4a43209d", .status = 12} /* 3709 */,
    {.source = (const lxb_char_t *) "\u200D\u200C𞤀｡𱘅𐶃", .ascii = (const lxb_char_t *) "xn--0ugb45126a.xn--wh0dj799f", .status = 24} /* 3710 */,
    {.source = (const lxb_char_t *) "\u200D\u200C𞤀。𱘅𐶃", .ascii = (const lxb_char_t *) "xn--0ugb45126a.xn--wh0dj799f", .status = 24} /* 3711 */,
    {.source = (const lxb_char_t *) "\u200D\u200C𞤢。𱘅𐶃", .ascii = (const lxb_char_t *) "xn--0ugb45126a.xn--wh0dj799f", .status = 24} /* 3712 */,
    {.source = (const lxb_char_t *) "xn--9d6h.xn--wh0dj799f", .ascii = (const lxb_char_t *) "xn--9d6h.xn--wh0dj799f", .status = 12} /* 3713 */,
    {.source = (const lxb_char_t *) "xn--0ugb45126a.xn--wh0dj799f", .ascii = (const lxb_char_t *) "xn--0ugb45126a.xn--wh0dj799f", .status = 24} /* 3714 */,
    {.source = (const lxb_char_t *) "\u200D\u200C𞤢｡𱘅𐶃", .ascii = (const lxb_char_t *) "xn--0ugb45126a.xn--wh0dj799f", .status = 24} /* 3715 */,
    {.source = (const lxb_char_t *) "\u0628≠𝟫-.ς⒍𐹦≠", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--3xa097mzpbzz04b", .status = 20} /* 3716 */,
    {.source = (const lxb_char_t *) "\u0628=\u0338𝟫-.ς⒍𐹦=\u0338", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--3xa097mzpbzz04b", .status = 20} /* 3717 */,
    {.source = (const lxb_char_t *) "\u0628≠9-.ς6.𐹦≠", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-xmb.xn--1ch8704g", .status = 12} /* 3718 */,
    {.source = (const lxb_char_t *) "\u0628=\u03389-.ς6.𐹦=\u0338", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-xmb.xn--1ch8704g", .status = 12} /* 3719 */,
    {.source = (const lxb_char_t *) "\u0628=\u03389-.Σ6.𐹦=\u0338", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", .status = 12} /* 3720 */,
    {.source = (const lxb_char_t *) "\u0628≠9-.Σ6.𐹦≠", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", .status = 12} /* 3721 */,
    {.source = (const lxb_char_t *) "\u0628≠9-.σ6.𐹦≠", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", .status = 12} /* 3722 */,
    {.source = (const lxb_char_t *) "\u0628=\u03389-.σ6.𐹦=\u0338", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", .status = 12} /* 3723 */,
    {.source = (const lxb_char_t *) "xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-zmb.xn--1ch8704g", .status = 12} /* 3724 */,
    {.source = (const lxb_char_t *) "xn--9--etd0100a.xn--6-xmb.xn--1ch8704g", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--6-xmb.xn--1ch8704g", .status = 12} /* 3725 */,
    {.source = (const lxb_char_t *) "\u0628=\u0338𝟫-.Σ⒍𐹦=\u0338", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--4xa887mzpbzz04b", .status = 20} /* 3726 */,
    {.source = (const lxb_char_t *) "\u0628≠𝟫-.Σ⒍𐹦≠", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--4xa887mzpbzz04b", .status = 20} /* 3727 */,
    {.source = (const lxb_char_t *) "\u0628≠𝟫-.σ⒍𐹦≠", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--4xa887mzpbzz04b", .status = 20} /* 3728 */,
    {.source = (const lxb_char_t *) "\u0628=\u0338𝟫-.σ⒍𐹦=\u0338", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--4xa887mzpbzz04b", .status = 20} /* 3729 */,
    {.source = (const lxb_char_t *) "xn--9--etd0100a.xn--4xa887mzpbzz04b", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--4xa887mzpbzz04b", .status = 20} /* 3730 */,
    {.source = (const lxb_char_t *) "xn--9--etd0100a.xn--3xa097mzpbzz04b", .ascii = (const lxb_char_t *) "xn--9--etd0100a.xn--3xa097mzpbzz04b", .status = 20} /* 3731 */,
    {.source = (const lxb_char_t *) "򉛴.-ᡢ\u0592𝨠", .ascii = (const lxb_char_t *) "xn--ep37b.xn----hec165lho83b", .status = 8} /* 3732 */,
    {.source = (const lxb_char_t *) "xn--ep37b.xn----hec165lho83b", .ascii = (const lxb_char_t *) "xn--ep37b.xn----hec165lho83b", .status = 8} /* 3733 */,
    {.source = (const lxb_char_t *) "\u06CB⒈ß󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--zca541ato3a.xn----q001f", .status = 20} /* 3734 */,
    {.source = (const lxb_char_t *) "\u06CB1.ß󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--1-cwc.xn--zca.xn----q001f", .status = 12} /* 3735 */,
    {.source = (const lxb_char_t *) "\u06CB1.SS󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--1-cwc.ss.xn----q001f", .status = 12} /* 3736 */,
    {.source = (const lxb_char_t *) "\u06CB1.ss󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--1-cwc.ss.xn----q001f", .status = 12} /* 3737 */,
    {.source = (const lxb_char_t *) "\u06CB1.Ss󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--1-cwc.ss.xn----q001f", .status = 12} /* 3738 */,
    {.source = (const lxb_char_t *) "xn--1-cwc.ss.xn----q001f", .ascii = (const lxb_char_t *) "xn--1-cwc.ss.xn----q001f", .status = 12} /* 3739 */,
    {.source = (const lxb_char_t *) "xn--1-cwc.xn--zca.xn----q001f", .ascii = (const lxb_char_t *) "xn--1-cwc.xn--zca.xn----q001f", .status = 12} /* 3740 */,
    {.source = (const lxb_char_t *) "\u06CB⒈SS󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--ss-d7d6651a.xn----q001f", .status = 20} /* 3741 */,
    {.source = (const lxb_char_t *) "\u06CB⒈ss󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--ss-d7d6651a.xn----q001f", .status = 20} /* 3742 */,
    {.source = (const lxb_char_t *) "\u06CB⒈Ss󠄽。񷋍-", .ascii = (const lxb_char_t *) "xn--ss-d7d6651a.xn----q001f", .status = 20} /* 3743 */,
    {.source = (const lxb_char_t *) "xn--ss-d7d6651a.xn----q001f", .ascii = (const lxb_char_t *) "xn--ss-d7d6651a.xn----q001f", .status = 20} /* 3744 */,
    {.source = (const lxb_char_t *) "xn--zca541ato3a.xn----q001f", .ascii = (const lxb_char_t *) "xn--zca541ato3a.xn----q001f", .status = 20} /* 3745 */,
    {.source = (const lxb_char_t *) "𿀫．\u1BAAςႦ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--3xa417dxriome", .status = 12} /* 3746 */,
    {.source = (const lxb_char_t *) "𿀫.\u1BAAςႦ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--3xa417dxriome", .status = 12} /* 3747 */,
    {.source = (const lxb_char_t *) "𿀫.\u1BAAςⴆ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--3xa353jk8cs1q", .status = 12} /* 3748 */,
    {.source = (const lxb_char_t *) "𿀫.\u1BAAΣႦ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa217dxriome", .status = 12} /* 3749 */,
    {.source = (const lxb_char_t *) "𿀫.\u1BAAσⴆ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa153jk8cs1q", .status = 12} /* 3750 */,
    {.source = (const lxb_char_t *) "𿀫.\u1BAAΣⴆ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa153jk8cs1q", .status = 12} /* 3751 */,
    {.source = (const lxb_char_t *) "xn--nu4s.xn--4xa153j7im", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa153j7im", .status = 8} /* 3752 */,
    {.source = (const lxb_char_t *) "xn--nu4s.xn--4xa153jk8cs1q", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa153jk8cs1q", .status = 12} /* 3753 */,
    {.source = (const lxb_char_t *) "xn--nu4s.xn--4xa217dxri", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa217dxri", .status = 8} /* 3754 */,
    {.source = (const lxb_char_t *) "xn--nu4s.xn--4xa217dxriome", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa217dxriome", .status = 12} /* 3755 */,
    {.source = (const lxb_char_t *) "xn--nu4s.xn--3xa353jk8cs1q", .ascii = (const lxb_char_t *) "xn--nu4s.xn--3xa353jk8cs1q", .status = 12} /* 3756 */,
    {.source = (const lxb_char_t *) "xn--nu4s.xn--3xa417dxriome", .ascii = (const lxb_char_t *) "xn--nu4s.xn--3xa417dxriome", .status = 12} /* 3757 */,
    {.source = (const lxb_char_t *) "𿀫．\u1BAAςⴆ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--3xa353jk8cs1q", .status = 12} /* 3758 */,
    {.source = (const lxb_char_t *) "𿀫．\u1BAAΣႦ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa217dxriome", .status = 12} /* 3759 */,
    {.source = (const lxb_char_t *) "𿀫．\u1BAAσⴆ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa153jk8cs1q", .status = 12} /* 3760 */,
    {.source = (const lxb_char_t *) "𿀫．\u1BAAΣⴆ\u200D", .ascii = (const lxb_char_t *) "xn--nu4s.xn--4xa153jk8cs1q", .status = 12} /* 3761 */,
    {.source = (const lxb_char_t *) "⾆\u08E2.𝈴", .ascii = (const lxb_char_t *) "xn--l0b9413d.xn--kl1h", .status = 16} /* 3762 */,
    {.source = (const lxb_char_t *) "舌\u08E2.𝈴", .ascii = (const lxb_char_t *) "xn--l0b9413d.xn--kl1h", .status = 16} /* 3763 */,
    {.source = (const lxb_char_t *) "xn--l0b9413d.xn--kl1h", .ascii = (const lxb_char_t *) "xn--l0b9413d.xn--kl1h", .status = 16} /* 3764 */,
    {.source = (const lxb_char_t *) "⫞𐹶𖫴。⭠⒈", .ascii = (const lxb_char_t *) "xn--53ix188et88b.xn--tsh52w", .status = 8} /* 3765 */,
    {.source = (const lxb_char_t *) "⫞𐹶𖫴。⭠1.", .ascii = (const lxb_char_t *) "xn--53ix188et88b.xn--1-h6r.", .status = 4} /* 3766 */,
    {.source = (const lxb_char_t *) "xn--53ix188et88b.xn--1-h6r.", .ascii = (const lxb_char_t *) "xn--53ix188et88b.xn--1-h6r.", .status = 4} /* 3767 */,
    {.source = (const lxb_char_t *) "xn--53ix188et88b.xn--tsh52w", .ascii = (const lxb_char_t *) "xn--53ix188et88b.xn--tsh52w", .status = 8} /* 3768 */,
    {.source = (const lxb_char_t *) "⒈\u200C\uAAEC︒．\u0ACD", .ascii = (const lxb_char_t *) "xn--0ug78o720myr1c.xn--mfc", .status = 12} /* 3769 */,
    {.source = (const lxb_char_t *) "1.\u200C\uAAEC。.\u0ACD", .ascii = (const lxb_char_t *) "1.xn--0ug7185c..xn--mfc", .status = 14} /* 3770 */,
    {.source = (const lxb_char_t *) "1.xn--sv9a..xn--mfc", .ascii = (const lxb_char_t *) "1.xn--sv9a..xn--mfc", .status = 10} /* 3771 */,
    {.source = (const lxb_char_t *) "1.xn--0ug7185c..xn--mfc", .ascii = (const lxb_char_t *) "1.xn--0ug7185c..xn--mfc", .status = 14} /* 3772 */,
    {.source = (const lxb_char_t *) "xn--tsh0720cse8b.xn--mfc", .ascii = (const lxb_char_t *) "xn--tsh0720cse8b.xn--mfc", .status = 8} /* 3773 */,
    {.source = (const lxb_char_t *) "xn--0ug78o720myr1c.xn--mfc", .ascii = (const lxb_char_t *) "xn--0ug78o720myr1c.xn--mfc", .status = 12} /* 3774 */,
    {.source = (const lxb_char_t *) "\u0C46。䰀\u0668𞭅󠅼", .ascii = (const lxb_char_t *) "xn--eqc.xn--hib5476aim6t", .status = 20} /* 3775 */,
    {.source = (const lxb_char_t *) "xn--eqc.xn--hib5476aim6t", .ascii = (const lxb_char_t *) "xn--eqc.xn--hib5476aim6t", .status = 20} /* 3776 */,
    {.source = (const lxb_char_t *) "ß\u200D.\u1BF2񄾼", .ascii = (const lxb_char_t *) "xn--zca870n.xn--0zf22107b", .status = 12} /* 3777 */,
    {.source = (const lxb_char_t *) "SS\u200D.\u1BF2񄾼", .ascii = (const lxb_char_t *) "xn--ss-n1t.xn--0zf22107b", .status = 12} /* 3778 */,
    {.source = (const lxb_char_t *) "ss\u200D.\u1BF2񄾼", .ascii = (const lxb_char_t *) "xn--ss-n1t.xn--0zf22107b", .status = 12} /* 3779 */,
    {.source = (const lxb_char_t *) "Ss\u200D.\u1BF2񄾼", .ascii = (const lxb_char_t *) "xn--ss-n1t.xn--0zf22107b", .status = 12} /* 3780 */,
    {.source = (const lxb_char_t *) "ss.xn--0zf22107b", .ascii = (const lxb_char_t *) "ss.xn--0zf22107b", .status = 8} /* 3781 */,
    {.source = (const lxb_char_t *) "xn--ss-n1t.xn--0zf22107b", .ascii = (const lxb_char_t *) "xn--ss-n1t.xn--0zf22107b", .status = 12} /* 3782 */,
    {.source = (const lxb_char_t *) "xn--zca870n.xn--0zf22107b", .ascii = (const lxb_char_t *) "xn--zca870n.xn--0zf22107b", .status = 12} /* 3783 */,
    {.source = (const lxb_char_t *) "𑓂\u200C≮.≮", .ascii = (const lxb_char_t *) "xn--0ugy6glz29a.xn--gdh", .status = 4} /* 3784 */,
    {.source = (const lxb_char_t *) "𑓂\u200C<\u0338.<\u0338", .ascii = (const lxb_char_t *) "xn--0ugy6glz29a.xn--gdh", .status = 4} /* 3785 */,
    {.source = (const lxb_char_t *) "xn--gdhz656g.xn--gdh", .ascii = (const lxb_char_t *) "xn--gdhz656g.xn--gdh", .status = 4} /* 3786 */,
    {.source = (const lxb_char_t *) "xn--0ugy6glz29a.xn--gdh", .ascii = (const lxb_char_t *) "xn--0ugy6glz29a.xn--gdh", .status = 4} /* 3787 */,
    {.source = (const lxb_char_t *) "🕼．\uFFA0", .ascii = (const lxb_char_t *) "xn--my8h.xn--cl7c", .status = 4} /* 3788 */,
    {.source = (const lxb_char_t *) "🕼.\u1160", .ascii = (const lxb_char_t *) "xn--my8h.xn--psd", .status = 4} /* 3789 */,
    {.source = (const lxb_char_t *) "xn--my8h.xn--psd", .ascii = (const lxb_char_t *) "xn--my8h.xn--psd", .status = 4} /* 3790 */,
    {.source = (const lxb_char_t *) "xn--my8h.xn--cl7c", .ascii = (const lxb_char_t *) "xn--my8h.xn--cl7c", .status = 4} /* 3791 */,
    {.source = (const lxb_char_t *) "ᡔ\uFD82。񷘎", .ascii = (const lxb_char_t *) "xn--sgb9bq785p.xn--bc31b", .status = 12} /* 3792 */,
    {.source = (const lxb_char_t *) "ᡔ\u0644\u062D\u0649。񷘎", .ascii = (const lxb_char_t *) "xn--sgb9bq785p.xn--bc31b", .status = 12} /* 3793 */,
    {.source = (const lxb_char_t *) "xn--sgb9bq785p.xn--bc31b", .ascii = (const lxb_char_t *) "xn--sgb9bq785p.xn--bc31b", .status = 12} /* 3794 */,
    {.source = (const lxb_char_t *) "爕򳙑．𝟰気", .ascii = (const lxb_char_t *) "xn--1zxq3199c.xn--4-678b", .status = 4} /* 3795 */,
    {.source = (const lxb_char_t *) "爕򳙑.4気", .ascii = (const lxb_char_t *) "xn--1zxq3199c.xn--4-678b", .status = 4} /* 3796 */,
    {.source = (const lxb_char_t *) "xn--1zxq3199c.xn--4-678b", .ascii = (const lxb_char_t *) "xn--1zxq3199c.xn--4-678b", .status = 4} /* 3797 */,
    {.source = (const lxb_char_t *) "⒋𑍍Ⴝ-．𞬪\u0DCA\u05B5", .ascii = (const lxb_char_t *) "xn----t1g323mnk9t.xn--ddb152b7y23b", .status = 12} /* 3798 */,
    {.source = (const lxb_char_t *) "4.𑍍Ⴝ-.𞬪\u0DCA\u05B5", .ascii = (const lxb_char_t *) "4.xn----t1g9869q.xn--ddb152b7y23b", .status = 20} /* 3799 */,
    {.source = (const lxb_char_t *) "4.𑍍ⴝ-.𞬪\u0DCA\u05B5", .ascii = (const lxb_char_t *) "4.xn----wwsx259f.xn--ddb152b7y23b", .status = 20} /* 3800 */,
    {.source = (const lxb_char_t *) "4.xn----wwsx259f.xn--ddb152b7y23b", .ascii = (const lxb_char_t *) "4.xn----wwsx259f.xn--ddb152b7y23b", .status = 20} /* 3801 */,
    {.source = (const lxb_char_t *) "4.xn----t1g9869q.xn--ddb152b7y23b", .ascii = (const lxb_char_t *) "4.xn----t1g9869q.xn--ddb152b7y23b", .status = 20} /* 3802 */,
    {.source = (const lxb_char_t *) "⒋𑍍ⴝ-．𞬪\u0DCA\u05B5", .ascii = (const lxb_char_t *) "xn----jcp487avl3w.xn--ddb152b7y23b", .status = 12} /* 3803 */,
    {.source = (const lxb_char_t *) "xn----jcp487avl3w.xn--ddb152b7y23b", .ascii = (const lxb_char_t *) "xn----jcp487avl3w.xn--ddb152b7y23b", .status = 12} /* 3804 */,
    {.source = (const lxb_char_t *) "xn----t1g323mnk9t.xn--ddb152b7y23b", .ascii = (const lxb_char_t *) "xn----t1g323mnk9t.xn--ddb152b7y23b", .status = 12} /* 3805 */,
    {.source = (const lxb_char_t *) "󞝃。򑆃񉢗--", .ascii = (const lxb_char_t *) "xn--2y75e.xn-----1l15eer88n", .status = 12} /* 3806 */,
    {.source = (const lxb_char_t *) "xn--2y75e.xn-----1l15eer88n", .ascii = (const lxb_char_t *) "xn--2y75e.xn-----1l15eer88n", .status = 12} /* 3807 */,
    {.source = (const lxb_char_t *) "\u200D\u07DF｡\u200C\uABED", .ascii = (const lxb_char_t *) "xn--6sb394j.xn--0ug1126c", .status = 12} /* 3808 */,
    {.source = (const lxb_char_t *) "\u200D\u07DF。\u200C\uABED", .ascii = (const lxb_char_t *) "xn--6sb394j.xn--0ug1126c", .status = 12} /* 3809 */,
    {.source = (const lxb_char_t *) "xn--6sb.xn--429a", .ascii = (const lxb_char_t *) "xn--6sb.xn--429a", .status = 8} /* 3810 */,
    {.source = (const lxb_char_t *) "xn--6sb394j.xn--0ug1126c", .ascii = (const lxb_char_t *) "xn--6sb394j.xn--0ug1126c", .status = 12} /* 3811 */,
    {.source = (const lxb_char_t *) "𞮽\u07FF\u084E｡ᢍ򝹁𐫘", .ascii = (const lxb_char_t *) "xn--3tb2nz468k.xn--69e8615j5rn5d", .status = 12} /* 3812 */,
    {.source = (const lxb_char_t *) "𞮽\u07FF\u084E。ᢍ򝹁𐫘", .ascii = (const lxb_char_t *) "xn--3tb2nz468k.xn--69e8615j5rn5d", .status = 12} /* 3813 */,
    {.source = (const lxb_char_t *) "xn--3tb2nz468k.xn--69e8615j5rn5d", .ascii = (const lxb_char_t *) "xn--3tb2nz468k.xn--69e8615j5rn5d", .status = 12} /* 3814 */,
    {.source = (const lxb_char_t *) "\u06ED𞺌𑄚\u1714.ꡞ\u08B7", .ascii = (const lxb_char_t *) "xn--hhb94ag41b739u.xn--dzb5582f", .status = 16} /* 3815 */,
    {.source = (const lxb_char_t *) "\u06ED\u0645𑄚\u1714.ꡞ\u08B7", .ascii = (const lxb_char_t *) "xn--hhb94ag41b739u.xn--dzb5582f", .status = 16} /* 3816 */,
    {.source = (const lxb_char_t *) "xn--hhb94ag41b739u.xn--dzb5582f", .ascii = (const lxb_char_t *) "xn--hhb94ag41b739u.xn--dzb5582f", .status = 16} /* 3817 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡ς\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xaa51q", .status = 12} /* 3818 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡ς\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xaa51q", .status = 12} /* 3819 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。ς\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xaa51q", .status = 12} /* 3820 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。ς\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xaa51q", .status = 12} /* 3821 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。Σ\u063CΣ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3822 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。Σ\u063CΣ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3823 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3824 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3825 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。Σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3826 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。Σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3827 */,
    {.source = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3828 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。Σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3829 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。Σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3830 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3831 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC。σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3832 */,
    {.source = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3833 */,
    {.source = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xaa51q", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xaa51q", .status = 12} /* 3834 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡Σ\u063CΣ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3835 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡Σ\u063CΣ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3836 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3837 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3838 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡Σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3839 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡Σ\u063Cσ", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--4xaa21q", .status = 12} /* 3840 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡Σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3841 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡Σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3842 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3843 */,
    {.source = (const lxb_char_t *) "񻂵킃𑘶\u07DC｡σ\u063Cς", .ascii = (const lxb_char_t *) "xn--3sb7483hoyvbbe76g.xn--3xab31q", .status = 12} /* 3844 */,
    {.source = (const lxb_char_t *) "蔰。󠁹\u08DD-𑈵", .ascii = (const lxb_char_t *) "xn--sz1a.xn----mrd9984r3dl0i", .status = 4} /* 3845 */,
    {.source = (const lxb_char_t *) "xn--sz1a.xn----mrd9984r3dl0i", .ascii = (const lxb_char_t *) "xn--sz1a.xn----mrd9984r3dl0i", .status = 4} /* 3846 */,
    {.source = (const lxb_char_t *) "ςჅ。\u075A", .ascii = (const lxb_char_t *) "xn--3xa677d.xn--epb", .status = 4} /* 3847 */,
    {.source = (const lxb_char_t *) "ςⴥ。\u075A", .ascii = (const lxb_char_t *) "xn--3xa403s.xn--epb", .status = 0} /* 3848 */,
    {.source = (const lxb_char_t *) "ΣჅ。\u075A", .ascii = (const lxb_char_t *) "xn--4xa477d.xn--epb", .status = 4} /* 3849 */,
    {.source = (const lxb_char_t *) "σⴥ。\u075A", .ascii = (const lxb_char_t *) "xn--4xa203s.xn--epb", .status = 0} /* 3850 */,
    {.source = (const lxb_char_t *) "Σⴥ。\u075A", .ascii = (const lxb_char_t *) "xn--4xa203s.xn--epb", .status = 0} /* 3851 */,
    {.source = (const lxb_char_t *) "xn--4xa203s.xn--epb", .ascii = (const lxb_char_t *) "xn--4xa203s.xn--epb", .status = 0} /* 3852 */,
    {.source = (const lxb_char_t *) "σⴥ.\u075A", .ascii = (const lxb_char_t *) "xn--4xa203s.xn--epb", .status = 0} /* 3853 */,
    {.source = (const lxb_char_t *) "ΣჅ.\u075A", .ascii = (const lxb_char_t *) "xn--4xa477d.xn--epb", .status = 4} /* 3854 */,
    {.source = (const lxb_char_t *) "Σⴥ.\u075A", .ascii = (const lxb_char_t *) "xn--4xa203s.xn--epb", .status = 0} /* 3855 */,
    {.source = (const lxb_char_t *) "xn--4xa477d.xn--epb", .ascii = (const lxb_char_t *) "xn--4xa477d.xn--epb", .status = 4} /* 3856 */,
    {.source = (const lxb_char_t *) "xn--3xa403s.xn--epb", .ascii = (const lxb_char_t *) "xn--3xa403s.xn--epb", .status = 0} /* 3857 */,
    {.source = (const lxb_char_t *) "ςⴥ.\u075A", .ascii = (const lxb_char_t *) "xn--3xa403s.xn--epb", .status = 0} /* 3858 */,
    {.source = (const lxb_char_t *) "xn--3xa677d.xn--epb", .ascii = (const lxb_char_t *) "xn--3xa677d.xn--epb", .status = 4} /* 3859 */,
    {.source = (const lxb_char_t *) "\u0C4DႩ𞰓．\u1B72", .ascii = (const lxb_char_t *) "xn--lqc64t7t26c.xn--dwf", .status = 12} /* 3860 */,
    {.source = (const lxb_char_t *) "\u0C4DႩ𞰓.\u1B72", .ascii = (const lxb_char_t *) "xn--lqc64t7t26c.xn--dwf", .status = 12} /* 3861 */,
    {.source = (const lxb_char_t *) "\u0C4Dⴉ𞰓.\u1B72", .ascii = (const lxb_char_t *) "xn--lqc478nlr02a.xn--dwf", .status = 12} /* 3862 */,
    {.source = (const lxb_char_t *) "xn--lqc478nlr02a.xn--dwf", .ascii = (const lxb_char_t *) "xn--lqc478nlr02a.xn--dwf", .status = 12} /* 3863 */,
    {.source = (const lxb_char_t *) "xn--lqc64t7t26c.xn--dwf", .ascii = (const lxb_char_t *) "xn--lqc64t7t26c.xn--dwf", .status = 12} /* 3864 */,
    {.source = (const lxb_char_t *) "\u0C4Dⴉ𞰓．\u1B72", .ascii = (const lxb_char_t *) "xn--lqc478nlr02a.xn--dwf", .status = 12} /* 3865 */,
    {.source = (const lxb_char_t *) "⮷≮񎈴󠄟。𐠄", .ascii = (const lxb_char_t *) "xn--gdh877a3513h.xn--pc9c", .status = 8} /* 3866 */,
    {.source = (const lxb_char_t *) "⮷<\u0338񎈴󠄟。𐠄", .ascii = (const lxb_char_t *) "xn--gdh877a3513h.xn--pc9c", .status = 8} /* 3867 */,
    {.source = (const lxb_char_t *) "xn--gdh877a3513h.xn--pc9c", .ascii = (const lxb_char_t *) "xn--gdh877a3513h.xn--pc9c", .status = 8} /* 3868 */,
    {.source = (const lxb_char_t *) "\u06BC｡\u200Dẏ\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3869 */,
    {.source = (const lxb_char_t *) "\u06BC｡\u200Dy\u0307\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3870 */,
    {.source = (const lxb_char_t *) "\u06BC。\u200Dẏ\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3871 */,
    {.source = (const lxb_char_t *) "\u06BC。\u200Dy\u0307\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3872 */,
    {.source = (const lxb_char_t *) "\u06BC。\u200DY\u0307\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3873 */,
    {.source = (const lxb_char_t *) "\u06BC。\u200DẎ\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3874 */,
    {.source = (const lxb_char_t *) "xn--vkb.xn--08e172a", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172a", .status = 0} /* 3875 */,
    {.source = (const lxb_char_t *) "\u06BC.ẏᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172a", .status = 0} /* 3876 */,
    {.source = (const lxb_char_t *) "\u06BC.y\u0307ᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172a", .status = 0} /* 3877 */,
    {.source = (const lxb_char_t *) "\u06BC.Y\u0307ᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172a", .status = 0} /* 3878 */,
    {.source = (const lxb_char_t *) "\u06BC.Ẏᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172a", .status = 0} /* 3879 */,
    {.source = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3880 */,
    {.source = (const lxb_char_t *) "\u06BC｡\u200DY\u0307\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3881 */,
    {.source = (const lxb_char_t *) "\u06BC｡\u200DẎ\u200Cᡤ", .ascii = (const lxb_char_t *) "xn--vkb.xn--08e172ax6aca", .status = 12} /* 3882 */,
    {.source = (const lxb_char_t *) "𐹹𑲛。񑂐\u0DCA", .ascii = (const lxb_char_t *) "xn--xo0dg5v.xn--h1c39876d", .status = 8} /* 3883 */,
    {.source = (const lxb_char_t *) "xn--xo0dg5v.xn--h1c39876d", .ascii = (const lxb_char_t *) "xn--xo0dg5v.xn--h1c39876d", .status = 8} /* 3884 */,
    {.source = (const lxb_char_t *) "-≠𑈵｡嵕\uFEF1۴\uA953", .ascii = (const lxb_char_t *) "xn----ufo4749h.xn--mhb45a235sns3c", .status = 12} /* 3885 */,
    {.source = (const lxb_char_t *) "-=\u0338𑈵｡嵕\uFEF1۴\uA953", .ascii = (const lxb_char_t *) "xn----ufo4749h.xn--mhb45a235sns3c", .status = 12} /* 3886 */,
    {.source = (const lxb_char_t *) "-≠𑈵。嵕\u064A۴\uA953", .ascii = (const lxb_char_t *) "xn----ufo4749h.xn--mhb45a235sns3c", .status = 12} /* 3887 */,
    {.source = (const lxb_char_t *) "-=\u0338𑈵。嵕\u064A۴\uA953", .ascii = (const lxb_char_t *) "xn----ufo4749h.xn--mhb45a235sns3c", .status = 12} /* 3888 */,
    {.source = (const lxb_char_t *) "xn----ufo4749h.xn--mhb45a235sns3c", .ascii = (const lxb_char_t *) "xn----ufo4749h.xn--mhb45a235sns3c", .status = 12} /* 3889 */,
    {.source = (const lxb_char_t *) "\u200C񍸰𐹶\u076E．\u06C1\u200D≯\u200D", .ascii = (const lxb_char_t *) "xn--ypb717jrx2o7v94a.xn--0kb660ka35v", .status = 20} /* 3890 */,
    {.source = (const lxb_char_t *) "\u200C񍸰𐹶\u076E．\u06C1\u200D>\u0338\u200D", .ascii = (const lxb_char_t *) "xn--ypb717jrx2o7v94a.xn--0kb660ka35v", .status = 20} /* 3891 */,
    {.source = (const lxb_char_t *) "\u200C񍸰𐹶\u076E.\u06C1\u200D≯\u200D", .ascii = (const lxb_char_t *) "xn--ypb717jrx2o7v94a.xn--0kb660ka35v", .status = 20} /* 3892 */,
    {.source = (const lxb_char_t *) "\u200C񍸰𐹶\u076E.\u06C1\u200D>\u0338\u200D", .ascii = (const lxb_char_t *) "xn--ypb717jrx2o7v94a.xn--0kb660ka35v", .status = 20} /* 3893 */,
    {.source = (const lxb_char_t *) "xn--ypb5875khz9y.xn--0kb682l", .ascii = (const lxb_char_t *) "xn--ypb5875khz9y.xn--0kb682l", .status = 16} /* 3894 */,
    {.source = (const lxb_char_t *) "xn--ypb717jrx2o7v94a.xn--0kb660ka35v", .ascii = (const lxb_char_t *) "xn--ypb717jrx2o7v94a.xn--0kb660ka35v", .status = 20} /* 3895 */,
    {.source = (const lxb_char_t *) "≮．\u17B5\u0855𐫔", .ascii = (const lxb_char_t *) "xn--gdh.xn--kwb589e217p", .status = 12} /* 3896 */,
    {.source = (const lxb_char_t *) "<\u0338．\u17B5\u0855𐫔", .ascii = (const lxb_char_t *) "xn--gdh.xn--kwb589e217p", .status = 12} /* 3897 */,
    {.source = (const lxb_char_t *) "≮.\u17B5\u0855𐫔", .ascii = (const lxb_char_t *) "xn--gdh.xn--kwb589e217p", .status = 12} /* 3898 */,
    {.source = (const lxb_char_t *) "<\u0338.\u17B5\u0855𐫔", .ascii = (const lxb_char_t *) "xn--gdh.xn--kwb589e217p", .status = 12} /* 3899 */,
    {.source = (const lxb_char_t *) "xn--gdh.xn--kwb589e217p", .ascii = (const lxb_char_t *) "xn--gdh.xn--kwb589e217p", .status = 12} /* 3900 */,
    {.source = (const lxb_char_t *) "𐩗\u200D｡ႩႵ", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--hndy", .status = 12} /* 3901 */,
    {.source = (const lxb_char_t *) "𐩗\u200D。ႩႵ", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--hndy", .status = 12} /* 3902 */,
    {.source = (const lxb_char_t *) "𐩗\u200D。ⴉⴕ", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--0kjya", .status = 8} /* 3903 */,
    {.source = (const lxb_char_t *) "𐩗\u200D。Ⴉⴕ", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--hnd666l", .status = 12} /* 3904 */,
    {.source = (const lxb_char_t *) "xn--pt9c.xn--hnd666l", .ascii = (const lxb_char_t *) "xn--pt9c.xn--hnd666l", .status = 4} /* 3905 */,
    {.source = (const lxb_char_t *) "xn--1ug4933g.xn--hnd666l", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--hnd666l", .status = 12} /* 3906 */,
    {.source = (const lxb_char_t *) "xn--pt9c.xn--0kjya", .ascii = (const lxb_char_t *) "xn--pt9c.xn--0kjya", .status = 0} /* 3907 */,
    {.source = (const lxb_char_t *) "𐩗.ⴉⴕ", .ascii = (const lxb_char_t *) "xn--pt9c.xn--0kjya", .status = 0} /* 3908 */,
    {.source = (const lxb_char_t *) "𐩗.ႩႵ", .ascii = (const lxb_char_t *) "xn--pt9c.xn--hndy", .status = 4} /* 3909 */,
    {.source = (const lxb_char_t *) "𐩗.Ⴉⴕ", .ascii = (const lxb_char_t *) "xn--pt9c.xn--hnd666l", .status = 4} /* 3910 */,
    {.source = (const lxb_char_t *) "xn--pt9c.xn--hndy", .ascii = (const lxb_char_t *) "xn--pt9c.xn--hndy", .status = 4} /* 3911 */,
    {.source = (const lxb_char_t *) "xn--1ug4933g.xn--0kjya", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--0kjya", .status = 8} /* 3912 */,
    {.source = (const lxb_char_t *) "xn--1ug4933g.xn--hndy", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--hndy", .status = 12} /* 3913 */,
    {.source = (const lxb_char_t *) "𐩗\u200D｡ⴉⴕ", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--0kjya", .status = 8} /* 3914 */,
    {.source = (const lxb_char_t *) "𐩗\u200D｡Ⴉⴕ", .ascii = (const lxb_char_t *) "xn--1ug4933g.xn--hnd666l", .status = 12} /* 3915 */,
    {.source = (const lxb_char_t *) "\u200C\u200Cㄤ．\u032E󕨑\u09C2", .ascii = (const lxb_char_t *) "xn--0uga242k.xn--vta284a9o563a", .status = 12} /* 3916 */,
    {.source = (const lxb_char_t *) "\u200C\u200Cㄤ.\u032E󕨑\u09C2", .ascii = (const lxb_char_t *) "xn--0uga242k.xn--vta284a9o563a", .status = 12} /* 3917 */,
    {.source = (const lxb_char_t *) "xn--1fk.xn--vta284a9o563a", .ascii = (const lxb_char_t *) "xn--1fk.xn--vta284a9o563a", .status = 8} /* 3918 */,
    {.source = (const lxb_char_t *) "xn--0uga242k.xn--vta284a9o563a", .ascii = (const lxb_char_t *) "xn--0uga242k.xn--vta284a9o563a", .status = 12} /* 3919 */,
    {.source = (const lxb_char_t *) "𐋻｡-\u200C𐫄Ⴗ", .ascii = (const lxb_char_t *) "xn--v97c.xn----i1g888ih12u", .status = 16} /* 3920 */,
    {.source = (const lxb_char_t *) "𐋻。-\u200C𐫄Ⴗ", .ascii = (const lxb_char_t *) "xn--v97c.xn----i1g888ih12u", .status = 16} /* 3921 */,
    {.source = (const lxb_char_t *) "𐋻。-\u200C𐫄ⴗ", .ascii = (const lxb_char_t *) "xn--v97c.xn----sgnv20du99s", .status = 12} /* 3922 */,
    {.source = (const lxb_char_t *) "xn--v97c.xn----lws0526f", .ascii = (const lxb_char_t *) "xn--v97c.xn----lws0526f", .status = 8} /* 3923 */,
    {.source = (const lxb_char_t *) "xn--v97c.xn----sgnv20du99s", .ascii = (const lxb_char_t *) "xn--v97c.xn----sgnv20du99s", .status = 12} /* 3924 */,
    {.source = (const lxb_char_t *) "xn--v97c.xn----i1g2513q", .ascii = (const lxb_char_t *) "xn--v97c.xn----i1g2513q", .status = 12} /* 3925 */,
    {.source = (const lxb_char_t *) "xn--v97c.xn----i1g888ih12u", .ascii = (const lxb_char_t *) "xn--v97c.xn----i1g888ih12u", .status = 16} /* 3926 */,
    {.source = (const lxb_char_t *) "𐋻｡-\u200C𐫄ⴗ", .ascii = (const lxb_char_t *) "xn--v97c.xn----sgnv20du99s", .status = 12} /* 3927 */,
    {.source = (const lxb_char_t *) "🙑𐷺．≠\u200C", .ascii = (const lxb_char_t *) "xn--bl0dh970b.xn--0ug83g", .status = 12} /* 3928 */,
    {.source = (const lxb_char_t *) "🙑𐷺．=\u0338\u200C", .ascii = (const lxb_char_t *) "xn--bl0dh970b.xn--0ug83g", .status = 12} /* 3929 */,
    {.source = (const lxb_char_t *) "🙑𐷺.≠\u200C", .ascii = (const lxb_char_t *) "xn--bl0dh970b.xn--0ug83g", .status = 12} /* 3930 */,
    {.source = (const lxb_char_t *) "🙑𐷺.=\u0338\u200C", .ascii = (const lxb_char_t *) "xn--bl0dh970b.xn--0ug83g", .status = 12} /* 3931 */,
    {.source = (const lxb_char_t *) "xn--bl0dh970b.xn--1ch", .ascii = (const lxb_char_t *) "xn--bl0dh970b.xn--1ch", .status = 8} /* 3932 */,
    {.source = (const lxb_char_t *) "xn--bl0dh970b.xn--0ug83g", .ascii = (const lxb_char_t *) "xn--bl0dh970b.xn--0ug83g", .status = 12} /* 3933 */,
    {.source = (const lxb_char_t *) "\u064C\u1CD2｡𞮞\u2D7F⧎", .ascii = (const lxb_char_t *) "xn--ohb646i.xn--ewi38jf765c", .status = 16} /* 3934 */,
    {.source = (const lxb_char_t *) "\u064C\u1CD2。𞮞\u2D7F⧎", .ascii = (const lxb_char_t *) "xn--ohb646i.xn--ewi38jf765c", .status = 16} /* 3935 */,
    {.source = (const lxb_char_t *) "xn--ohb646i.xn--ewi38jf765c", .ascii = (const lxb_char_t *) "xn--ohb646i.xn--ewi38jf765c", .status = 16} /* 3936 */,
    {.source = (const lxb_char_t *) "Ⴔ𝨨₃󠁦．𝟳𑂹\u0B82", .ascii = (const lxb_char_t *) "xn--3-b1g83426a35t0g.xn--7-cve6271r", .status = 4} /* 3937 */,
    {.source = (const lxb_char_t *) "Ⴔ𝨨3󠁦.7𑂹\u0B82", .ascii = (const lxb_char_t *) "xn--3-b1g83426a35t0g.xn--7-cve6271r", .status = 4} /* 3938 */,
    {.source = (const lxb_char_t *) "ⴔ𝨨3󠁦.7𑂹\u0B82", .ascii = (const lxb_char_t *) "xn--3-ews6985n35s3g.xn--7-cve6271r", .status = 4} /* 3939 */,
    {.source = (const lxb_char_t *) "xn--3-ews6985n35s3g.xn--7-cve6271r", .ascii = (const lxb_char_t *) "xn--3-ews6985n35s3g.xn--7-cve6271r", .status = 4} /* 3940 */,
    {.source = (const lxb_char_t *) "xn--3-b1g83426a35t0g.xn--7-cve6271r", .ascii = (const lxb_char_t *) "xn--3-b1g83426a35t0g.xn--7-cve6271r", .status = 4} /* 3941 */,
    {.source = (const lxb_char_t *) "ⴔ𝨨₃󠁦．𝟳𑂹\u0B82", .ascii = (const lxb_char_t *) "xn--3-ews6985n35s3g.xn--7-cve6271r", .status = 4} /* 3942 */,
    {.source = (const lxb_char_t *) "䏈\u200C。\u200C⒈񱢕", .ascii = (const lxb_char_t *) "xn--0ug491l.xn--0ug88oot66q", .status = 8} /* 3943 */,
    {.source = (const lxb_char_t *) "䏈\u200C。\u200C1.񱢕", .ascii = (const lxb_char_t *) "xn--0ug491l.xn--1-rgn.xn--ms39a", .status = 8} /* 3944 */,
    {.source = (const lxb_char_t *) "xn--eco.1.xn--ms39a", .ascii = (const lxb_char_t *) "xn--eco.1.xn--ms39a", .status = 4} /* 3945 */,
    {.source = (const lxb_char_t *) "xn--0ug491l.xn--1-rgn.xn--ms39a", .ascii = (const lxb_char_t *) "xn--0ug491l.xn--1-rgn.xn--ms39a", .status = 8} /* 3946 */,
    {.source = (const lxb_char_t *) "xn--eco.xn--tsh21126d", .ascii = (const lxb_char_t *) "xn--eco.xn--tsh21126d", .status = 4} /* 3947 */,
    {.source = (const lxb_char_t *) "xn--0ug491l.xn--0ug88oot66q", .ascii = (const lxb_char_t *) "xn--0ug491l.xn--0ug88oot66q", .status = 8} /* 3948 */,
    {.source = (const lxb_char_t *) "１\uAAF6ß𑲥｡\u1DD8", .ascii = (const lxb_char_t *) "xn--1-qfa2471kdb0d.xn--weg", .status = 4} /* 3949 */,
    {.source = (const lxb_char_t *) "1\uAAF6ß𑲥。\u1DD8", .ascii = (const lxb_char_t *) "xn--1-qfa2471kdb0d.xn--weg", .status = 4} /* 3950 */,
    {.source = (const lxb_char_t *) "1\uAAF6SS𑲥。\u1DD8", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3951 */,
    {.source = (const lxb_char_t *) "1\uAAF6ss𑲥。\u1DD8", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3952 */,
    {.source = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3953 */,
    {.source = (const lxb_char_t *) "xn--1-qfa2471kdb0d.xn--weg", .ascii = (const lxb_char_t *) "xn--1-qfa2471kdb0d.xn--weg", .status = 4} /* 3954 */,
    {.source = (const lxb_char_t *) "１\uAAF6SS𑲥｡\u1DD8", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3955 */,
    {.source = (const lxb_char_t *) "１\uAAF6ss𑲥｡\u1DD8", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3956 */,
    {.source = (const lxb_char_t *) "1\uAAF6Ss𑲥。\u1DD8", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3957 */,
    {.source = (const lxb_char_t *) "１\uAAF6Ss𑲥｡\u1DD8", .ascii = (const lxb_char_t *) "xn--1ss-ir6ln166b.xn--weg", .status = 4} /* 3958 */,
    {.source = (const lxb_char_t *) "\u200D񫶩𞪯\u0CCD｡\u077C⒈", .ascii = (const lxb_char_t *) "xn--8tc969gzn94a4lm8a.xn--dqb689l", .status = 12} /* 3959 */,
    {.source = (const lxb_char_t *) "\u200D񫶩𞪯\u0CCD。\u077C1.", .ascii = (const lxb_char_t *) "xn--8tc969gzn94a4lm8a.xn--1-g6c.", .status = 12} /* 3960 */,
    {.source = (const lxb_char_t *) "xn--8tc9875v5is1a.xn--1-g6c.", .ascii = (const lxb_char_t *) "xn--8tc9875v5is1a.xn--1-g6c.", .status = 12} /* 3961 */,
    {.source = (const lxb_char_t *) "xn--8tc969gzn94a4lm8a.xn--1-g6c.", .ascii = (const lxb_char_t *) "xn--8tc969gzn94a4lm8a.xn--1-g6c.", .status = 12} /* 3962 */,
    {.source = (const lxb_char_t *) "xn--8tc9875v5is1a.xn--dqb689l", .ascii = (const lxb_char_t *) "xn--8tc9875v5is1a.xn--dqb689l", .status = 12} /* 3963 */,
    {.source = (const lxb_char_t *) "xn--8tc969gzn94a4lm8a.xn--dqb689l", .ascii = (const lxb_char_t *) "xn--8tc969gzn94a4lm8a.xn--dqb689l", .status = 12} /* 3964 */,
    {.source = (const lxb_char_t *) "\u1AB6．𞤳򓢖򻉒\u07D7", .ascii = (const lxb_char_t *) "xn--zqf.xn--ysb9657vuiz5bj0ep", .status = 16} /* 3965 */,
    {.source = (const lxb_char_t *) "\u1AB6.𞤳򓢖򻉒\u07D7", .ascii = (const lxb_char_t *) "xn--zqf.xn--ysb9657vuiz5bj0ep", .status = 16} /* 3966 */,
    {.source = (const lxb_char_t *) "\u1AB6.𞤑򓢖򻉒\u07D7", .ascii = (const lxb_char_t *) "xn--zqf.xn--ysb9657vuiz5bj0ep", .status = 16} /* 3967 */,
    {.source = (const lxb_char_t *) "xn--zqf.xn--ysb9657vuiz5bj0ep", .ascii = (const lxb_char_t *) "xn--zqf.xn--ysb9657vuiz5bj0ep", .status = 16} /* 3968 */,
    {.source = (const lxb_char_t *) "\u1AB6．𞤑򓢖򻉒\u07D7", .ascii = (const lxb_char_t *) "xn--zqf.xn--ysb9657vuiz5bj0ep", .status = 16} /* 3969 */,
    {.source = (const lxb_char_t *) "\u0842𞩚⒈．󠬌８򏳏\u0770", .ascii = (const lxb_char_t *) "xn--0vb095ldg52a.xn--8-s5c22427ox454a", .status = 8} /* 3970 */,
    {.source = (const lxb_char_t *) "\u0842𞩚1..󠬌8򏳏\u0770", .ascii = (const lxb_char_t *) "xn--1-rid26318a..xn--8-s5c22427ox454a", .status = 14} /* 3971 */,
    {.source = (const lxb_char_t *) "xn--1-rid26318a..xn--8-s5c22427ox454a", .ascii = (const lxb_char_t *) "xn--1-rid26318a..xn--8-s5c22427ox454a", .status = 14} /* 3972 */,
    {.source = (const lxb_char_t *) "xn--0vb095ldg52a.xn--8-s5c22427ox454a", .ascii = (const lxb_char_t *) "xn--0vb095ldg52a.xn--8-s5c22427ox454a", .status = 8} /* 3973 */,
    {.source = (const lxb_char_t *) "\u0361𐫫\u0369ᡷ。-󠰛鞰", .ascii = (const lxb_char_t *) "xn--cvaq482npv5t.xn----yg7dt1332g", .status = 16} /* 3974 */,
    {.source = (const lxb_char_t *) "xn--cvaq482npv5t.xn----yg7dt1332g", .ascii = (const lxb_char_t *) "xn--cvaq482npv5t.xn----yg7dt1332g", .status = 16} /* 3975 */,
    {.source = (const lxb_char_t *) "-.\u0ACD剘ß𐫃", .ascii = (const lxb_char_t *) "-.xn--zca791c493duf8i", .status = 12} /* 3976 */,
    {.source = (const lxb_char_t *) "-.\u0ACD剘SS𐫃", .ascii = (const lxb_char_t *) "-.xn--ss-bqg4734erywk", .status = 12} /* 3977 */,
    {.source = (const lxb_char_t *) "-.\u0ACD剘ss𐫃", .ascii = (const lxb_char_t *) "-.xn--ss-bqg4734erywk", .status = 12} /* 3978 */,
    {.source = (const lxb_char_t *) "-.\u0ACD剘Ss𐫃", .ascii = (const lxb_char_t *) "-.xn--ss-bqg4734erywk", .status = 12} /* 3979 */,
    {.source = (const lxb_char_t *) "-.xn--ss-bqg4734erywk", .ascii = (const lxb_char_t *) "-.xn--ss-bqg4734erywk", .status = 12} /* 3980 */,
    {.source = (const lxb_char_t *) "-.xn--zca791c493duf8i", .ascii = (const lxb_char_t *) "-.xn--zca791c493duf8i", .status = 12} /* 3981 */,
    {.source = (const lxb_char_t *) "\u08FB𞵸｡-", .ascii = (const lxb_char_t *) "xn--b1b2719v.-", .status = 16} /* 3982 */,
    {.source = (const lxb_char_t *) "\u08FB𞵸。-", .ascii = (const lxb_char_t *) "xn--b1b2719v.-", .status = 16} /* 3983 */,
    {.source = (const lxb_char_t *) "xn--b1b2719v.-", .ascii = (const lxb_char_t *) "xn--b1b2719v.-", .status = 16} /* 3984 */,
    {.source = (const lxb_char_t *) "⒈󠈻𐹲｡≠\u0603𐹽", .ascii = (const lxb_char_t *) "xn--tshw766f1153g.xn--lfb536lb35n", .status = 8} /* 3985 */,
    {.source = (const lxb_char_t *) "⒈󠈻𐹲｡=\u0338\u0603𐹽", .ascii = (const lxb_char_t *) "xn--tshw766f1153g.xn--lfb536lb35n", .status = 8} /* 3986 */,
    {.source = (const lxb_char_t *) "1.󠈻𐹲。≠\u0603𐹽", .ascii = (const lxb_char_t *) "1.xn--qo0dl3077c.xn--lfb536lb35n", .status = 8} /* 3987 */,
    {.source = (const lxb_char_t *) "1.󠈻𐹲。=\u0338\u0603𐹽", .ascii = (const lxb_char_t *) "1.xn--qo0dl3077c.xn--lfb536lb35n", .status = 8} /* 3988 */,
    {.source = (const lxb_char_t *) "1.xn--qo0dl3077c.xn--lfb536lb35n", .ascii = (const lxb_char_t *) "1.xn--qo0dl3077c.xn--lfb536lb35n", .status = 8} /* 3989 */,
    {.source = (const lxb_char_t *) "xn--tshw766f1153g.xn--lfb536lb35n", .ascii = (const lxb_char_t *) "xn--tshw766f1153g.xn--lfb536lb35n", .status = 8} /* 3990 */,
    {.source = (const lxb_char_t *) "𐹢󠈚Ⴎ\u200C.㖾𐹡", .ascii = (const lxb_char_t *) "xn--mnd289ezj4pqxp0i.xn--pelu572d", .status = 20} /* 3991 */,
    {.source = (const lxb_char_t *) "𐹢󠈚ⴎ\u200C.㖾𐹡", .ascii = (const lxb_char_t *) "xn--0ug342clq0pqxv4i.xn--pelu572d", .status = 20} /* 3992 */,
    {.source = (const lxb_char_t *) "xn--5kjx323em053g.xn--pelu572d", .ascii = (const lxb_char_t *) "xn--5kjx323em053g.xn--pelu572d", .status = 16} /* 3993 */,
    {.source = (const lxb_char_t *) "xn--0ug342clq0pqxv4i.xn--pelu572d", .ascii = (const lxb_char_t *) "xn--0ug342clq0pqxv4i.xn--pelu572d", .status = 20} /* 3994 */,
    {.source = (const lxb_char_t *) "xn--mnd9001km0o0g.xn--pelu572d", .ascii = (const lxb_char_t *) "xn--mnd9001km0o0g.xn--pelu572d", .status = 16} /* 3995 */,
    {.source = (const lxb_char_t *) "xn--mnd289ezj4pqxp0i.xn--pelu572d", .ascii = (const lxb_char_t *) "xn--mnd289ezj4pqxp0i.xn--pelu572d", .status = 20} /* 3996 */,
    {.source = (const lxb_char_t *) "򩼗．\u07C7ᡖႳႧ", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb856b9a631d", .status = 12} /* 3997 */,
    {.source = (const lxb_char_t *) "򩼗.\u07C7ᡖႳႧ", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb856b9a631d", .status = 12} /* 3998 */,
    {.source = (const lxb_char_t *) "򩼗.\u07C7ᡖⴓⴇ", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb295fbtpmb", .status = 12} /* 3999 */,
    {.source = (const lxb_char_t *) "xn--te28c.xn--isb295fbtpmb", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb295fbtpmb", .status = 12} /* 4000 */,
    {.source = (const lxb_char_t *) "xn--te28c.xn--isb856b9a631d", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb856b9a631d", .status = 12} /* 4001 */,
    {.source = (const lxb_char_t *) "򩼗．\u07C7ᡖⴓⴇ", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb295fbtpmb", .status = 12} /* 4002 */,
    {.source = (const lxb_char_t *) "򩼗.\u07C7ᡖႳⴇ", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb286btrgo7w", .status = 12} /* 4003 */,
    {.source = (const lxb_char_t *) "xn--te28c.xn--isb286btrgo7w", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb286btrgo7w", .status = 12} /* 4004 */,
    {.source = (const lxb_char_t *) "򩼗．\u07C7ᡖႳⴇ", .ascii = (const lxb_char_t *) "xn--te28c.xn--isb286btrgo7w", .status = 12} /* 4005 */,
    {.source = (const lxb_char_t *) "\u200D􅍉.\u06B3\u0775", .ascii = (const lxb_char_t *) "xn--1ug39444n.xn--mkb20b", .status = 12} /* 4006 */,
    {.source = (const lxb_char_t *) "xn--3j78f.xn--mkb20b", .ascii = (const lxb_char_t *) "xn--3j78f.xn--mkb20b", .status = 4} /* 4007 */,
    {.source = (const lxb_char_t *) "xn--1ug39444n.xn--mkb20b", .ascii = (const lxb_char_t *) "xn--1ug39444n.xn--mkb20b", .status = 12} /* 4008 */,
    {.source = (const lxb_char_t *) "𲤱⒛⾳．ꡦ⒈", .ascii = (const lxb_char_t *) "xn--dth6033bzbvx.xn--tsh9439b", .status = 4} /* 4009 */,
    {.source = (const lxb_char_t *) "𲤱20.音.ꡦ1.", .ascii = (const lxb_char_t *) "xn--20-9802c.xn--0w5a.xn--1-eg4e.", .status = 4} /* 4010 */,
    {.source = (const lxb_char_t *) "xn--20-9802c.xn--0w5a.xn--1-eg4e.", .ascii = (const lxb_char_t *) "xn--20-9802c.xn--0w5a.xn--1-eg4e.", .status = 4} /* 4011 */,
    {.source = (const lxb_char_t *) "xn--dth6033bzbvx.xn--tsh9439b", .ascii = (const lxb_char_t *) "xn--dth6033bzbvx.xn--tsh9439b", .status = 4} /* 4012 */,
    {.source = (const lxb_char_t *) "\u07DC８񳦓-｡򞲙𑁿𐩥\u09CD", .ascii = (const lxb_char_t *) "xn--8--rve13079p.xn--b7b9842k42df776x", .status = 24} /* 4013 */,
    {.source = (const lxb_char_t *) "\u07DC8񳦓-。򞲙𑁿𐩥\u09CD", .ascii = (const lxb_char_t *) "xn--8--rve13079p.xn--b7b9842k42df776x", .status = 24} /* 4014 */,
    {.source = (const lxb_char_t *) "xn--8--rve13079p.xn--b7b9842k42df776x", .ascii = (const lxb_char_t *) "xn--8--rve13079p.xn--b7b9842k42df776x", .status = 24} /* 4015 */,
    {.source = (const lxb_char_t *) "Ⴕ。۰≮ß\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--zca912alh227g", .status = 4} /* 4016 */,
    {.source = (const lxb_char_t *) "Ⴕ。۰<\u0338ß\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--zca912alh227g", .status = 4} /* 4017 */,
    {.source = (const lxb_char_t *) "ⴕ。۰<\u0338ß\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--zca912alh227g", .status = 0} /* 4018 */,
    {.source = (const lxb_char_t *) "ⴕ。۰≮ß\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--zca912alh227g", .status = 0} /* 4019 */,
    {.source = (const lxb_char_t *) "Ⴕ。۰≮SS\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4020 */,
    {.source = (const lxb_char_t *) "Ⴕ。۰<\u0338SS\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4021 */,
    {.source = (const lxb_char_t *) "ⴕ。۰<\u0338ss\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--ss-jbe65aw27i", .status = 0} /* 4022 */,
    {.source = (const lxb_char_t *) "ⴕ。۰≮ss\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--ss-jbe65aw27i", .status = 0} /* 4023 */,
    {.source = (const lxb_char_t *) "Ⴕ。۰≮Ss\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4024 */,
    {.source = (const lxb_char_t *) "Ⴕ。۰<\u0338Ss\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4025 */,
    {.source = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4026 */,
    {.source = (const lxb_char_t *) "xn--dlj.xn--ss-jbe65aw27i", .ascii = (const lxb_char_t *) "xn--dlj.xn--ss-jbe65aw27i", .status = 0} /* 4027 */,
    {.source = (const lxb_char_t *) "ⴕ.۰≮ss\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--ss-jbe65aw27i", .status = 0} /* 4028 */,
    {.source = (const lxb_char_t *) "ⴕ.۰<\u0338ss\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--ss-jbe65aw27i", .status = 0} /* 4029 */,
    {.source = (const lxb_char_t *) "Ⴕ.۰<\u0338SS\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4030 */,
    {.source = (const lxb_char_t *) "Ⴕ.۰≮SS\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4031 */,
    {.source = (const lxb_char_t *) "Ⴕ.۰≮Ss\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4032 */,
    {.source = (const lxb_char_t *) "Ⴕ.۰<\u0338Ss\u0745", .ascii = (const lxb_char_t *) "xn--tnd.xn--ss-jbe65aw27i", .status = 4} /* 4033 */,
    {.source = (const lxb_char_t *) "xn--dlj.xn--zca912alh227g", .ascii = (const lxb_char_t *) "xn--dlj.xn--zca912alh227g", .status = 0} /* 4034 */,
    {.source = (const lxb_char_t *) "ⴕ.۰≮ß\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--zca912alh227g", .status = 0} /* 4035 */,
    {.source = (const lxb_char_t *) "ⴕ.۰<\u0338ß\u0745", .ascii = (const lxb_char_t *) "xn--dlj.xn--zca912alh227g", .status = 0} /* 4036 */,
    {.source = (const lxb_char_t *) "xn--tnd.xn--zca912alh227g", .ascii = (const lxb_char_t *) "xn--tnd.xn--zca912alh227g", .status = 4} /* 4037 */,
    {.source = (const lxb_char_t *) "\u07E9-.𝨗꒱\u1B72", .ascii = (const lxb_char_t *) "xn----odd.xn--dwf8994dc8wj", .status = 16} /* 4038 */,
    {.source = (const lxb_char_t *) "xn----odd.xn--dwf8994dc8wj", .ascii = (const lxb_char_t *) "xn----odd.xn--dwf8994dc8wj", .status = 16} /* 4039 */,
    {.source = (const lxb_char_t *) "𞼸\u200C.≯䕵⫧", .ascii = (const lxb_char_t *) "xn--0ugx453p.xn--hdh754ax6w", .status = 16} /* 4040 */,
    {.source = (const lxb_char_t *) "𞼸\u200C.>\u0338䕵⫧", .ascii = (const lxb_char_t *) "xn--0ugx453p.xn--hdh754ax6w", .status = 16} /* 4041 */,
    {.source = (const lxb_char_t *) "xn--sn7h.xn--hdh754ax6w", .ascii = (const lxb_char_t *) "xn--sn7h.xn--hdh754ax6w", .status = 8} /* 4042 */,
    {.source = (const lxb_char_t *) "xn--0ugx453p.xn--hdh754ax6w", .ascii = (const lxb_char_t *) "xn--0ugx453p.xn--hdh754ax6w", .status = 16} /* 4043 */,
    {.source = (const lxb_char_t *) "𐨅ß\uFC57.\u06AC۳︒", .ascii = (const lxb_char_t *) "xn--zca23yncs877j.xn--fkb6lp314e", .status = 16} /* 4044 */,
    {.source = (const lxb_char_t *) "𐨅ß\u064A\u062E.\u06AC۳。", .ascii = (const lxb_char_t *) "xn--zca23yncs877j.xn--fkb6l.", .status = 8} /* 4045 */,
    {.source = (const lxb_char_t *) "𐨅SS\u064A\u062E.\u06AC۳。", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6l.", .status = 8} /* 4046 */,
    {.source = (const lxb_char_t *) "𐨅ss\u064A\u062E.\u06AC۳。", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6l.", .status = 8} /* 4047 */,
    {.source = (const lxb_char_t *) "𐨅Ss\u064A\u062E.\u06AC۳。", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6l.", .status = 8} /* 4048 */,
    {.source = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6l.", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6l.", .status = 8} /* 4049 */,
    {.source = (const lxb_char_t *) "xn--zca23yncs877j.xn--fkb6l.", .ascii = (const lxb_char_t *) "xn--zca23yncs877j.xn--fkb6l.", .status = 8} /* 4050 */,
    {.source = (const lxb_char_t *) "𐨅SS\uFC57.\u06AC۳︒", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6lp314e", .status = 16} /* 4051 */,
    {.source = (const lxb_char_t *) "𐨅ss\uFC57.\u06AC۳︒", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6lp314e", .status = 16} /* 4052 */,
    {.source = (const lxb_char_t *) "𐨅Ss\uFC57.\u06AC۳︒", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6lp314e", .status = 16} /* 4053 */,
    {.source = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6lp314e", .ascii = (const lxb_char_t *) "xn--ss-ytd5i7765l.xn--fkb6lp314e", .status = 16} /* 4054 */,
    {.source = (const lxb_char_t *) "xn--zca23yncs877j.xn--fkb6lp314e", .ascii = (const lxb_char_t *) "xn--zca23yncs877j.xn--fkb6lp314e", .status = 16} /* 4055 */,
    {.source = (const lxb_char_t *) "-≮🡒\u1CED.񏿾Ⴁ\u0714", .ascii = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb300c1597h", .status = 12} /* 4056 */,
    {.source = (const lxb_char_t *) "-<\u0338🡒\u1CED.񏿾Ⴁ\u0714", .ascii = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb300c1597h", .status = 12} /* 4057 */,
    {.source = (const lxb_char_t *) "-<\u0338🡒\u1CED.񏿾ⴁ\u0714", .ascii = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb135qf106f", .status = 12} /* 4058 */,
    {.source = (const lxb_char_t *) "-≮🡒\u1CED.񏿾ⴁ\u0714", .ascii = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb135qf106f", .status = 12} /* 4059 */,
    {.source = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb135qf106f", .ascii = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb135qf106f", .status = 12} /* 4060 */,
    {.source = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb300c1597h", .ascii = (const lxb_char_t *) "xn----44l04zxt68c.xn--enb300c1597h", .status = 12} /* 4061 */,
    {.source = (const lxb_char_t *) "𞤨｡ꡏ\u200D\u200C", .ascii = (const lxb_char_t *) "xn--ge6h.xn--0ugb9575h", .status = 12} /* 4062 */,
    {.source = (const lxb_char_t *) "𞤨。ꡏ\u200D\u200C", .ascii = (const lxb_char_t *) "xn--ge6h.xn--0ugb9575h", .status = 12} /* 4063 */,
    {.source = (const lxb_char_t *) "𞤆。ꡏ\u200D\u200C", .ascii = (const lxb_char_t *) "xn--ge6h.xn--0ugb9575h", .status = 12} /* 4064 */,
    {.source = (const lxb_char_t *) "xn--ge6h.xn--oc9a", .ascii = (const lxb_char_t *) "xn--ge6h.xn--oc9a", .status = 0} /* 4065 */,
    {.source = (const lxb_char_t *) "𞤨.ꡏ", .ascii = (const lxb_char_t *) "xn--ge6h.xn--oc9a", .status = 0} /* 4066 */,
    {.source = (const lxb_char_t *) "𞤆.ꡏ", .ascii = (const lxb_char_t *) "xn--ge6h.xn--oc9a", .status = 0} /* 4067 */,
    {.source = (const lxb_char_t *) "xn--ge6h.xn--0ugb9575h", .ascii = (const lxb_char_t *) "xn--ge6h.xn--0ugb9575h", .status = 12} /* 4068 */,
    {.source = (const lxb_char_t *) "𞤆｡ꡏ\u200D\u200C", .ascii = (const lxb_char_t *) "xn--ge6h.xn--0ugb9575h", .status = 12} /* 4069 */,
    {.source = (const lxb_char_t *) "󠅹𑂶．ᢌ𑂹\u0669", .ascii = (const lxb_char_t *) "xn--b50d.xn--iib993gyp5p", .status = 16} /* 4070 */,
    {.source = (const lxb_char_t *) "󠅹𑂶.ᢌ𑂹\u0669", .ascii = (const lxb_char_t *) "xn--b50d.xn--iib993gyp5p", .status = 16} /* 4071 */,
    {.source = (const lxb_char_t *) "xn--b50d.xn--iib993gyp5p", .ascii = (const lxb_char_t *) "xn--b50d.xn--iib993gyp5p", .status = 16} /* 4072 */,
    {.source = (const lxb_char_t *) "Ⅎ󠅺񝵒。≯⾑", .ascii = (const lxb_char_t *) "xn--f3g73398c.xn--hdhz171b", .status = 4} /* 4073 */,
    {.source = (const lxb_char_t *) "Ⅎ󠅺񝵒。>\u0338⾑", .ascii = (const lxb_char_t *) "xn--f3g73398c.xn--hdhz171b", .status = 4} /* 4074 */,
    {.source = (const lxb_char_t *) "Ⅎ󠅺񝵒。≯襾", .ascii = (const lxb_char_t *) "xn--f3g73398c.xn--hdhz171b", .status = 4} /* 4075 */,
    {.source = (const lxb_char_t *) "Ⅎ󠅺񝵒。>\u0338襾", .ascii = (const lxb_char_t *) "xn--f3g73398c.xn--hdhz171b", .status = 4} /* 4076 */,
    {.source = (const lxb_char_t *) "ⅎ󠅺񝵒。>\u0338襾", .ascii = (const lxb_char_t *) "xn--73g39298c.xn--hdhz171b", .status = 4} /* 4077 */,
    {.source = (const lxb_char_t *) "ⅎ󠅺񝵒。≯襾", .ascii = (const lxb_char_t *) "xn--73g39298c.xn--hdhz171b", .status = 4} /* 4078 */,
    {.source = (const lxb_char_t *) "xn--73g39298c.xn--hdhz171b", .ascii = (const lxb_char_t *) "xn--73g39298c.xn--hdhz171b", .status = 4} /* 4079 */,
    {.source = (const lxb_char_t *) "xn--f3g73398c.xn--hdhz171b", .ascii = (const lxb_char_t *) "xn--f3g73398c.xn--hdhz171b", .status = 4} /* 4080 */,
    {.source = (const lxb_char_t *) "ⅎ󠅺񝵒。>\u0338⾑", .ascii = (const lxb_char_t *) "xn--73g39298c.xn--hdhz171b", .status = 4} /* 4081 */,
    {.source = (const lxb_char_t *) "ⅎ󠅺񝵒。≯⾑", .ascii = (const lxb_char_t *) "xn--73g39298c.xn--hdhz171b", .status = 4} /* 4082 */,
    {.source = (const lxb_char_t *) "ς\u200D\u0DD4\u0660｡-", .ascii = (const lxb_char_t *) "xn--3xa45ks2jenu.-", .status = 20} /* 4083 */,
    {.source = (const lxb_char_t *) "ς\u200D\u0DD4\u0660。-", .ascii = (const lxb_char_t *) "xn--3xa45ks2jenu.-", .status = 20} /* 4084 */,
    {.source = (const lxb_char_t *) "Σ\u200D\u0DD4\u0660。-", .ascii = (const lxb_char_t *) "xn--4xa25ks2jenu.-", .status = 20} /* 4085 */,
    {.source = (const lxb_char_t *) "σ\u200D\u0DD4\u0660。-", .ascii = (const lxb_char_t *) "xn--4xa25ks2jenu.-", .status = 20} /* 4086 */,
    {.source = (const lxb_char_t *) "xn--4xa25ks2j.-", .ascii = (const lxb_char_t *) "xn--4xa25ks2j.-", .status = 16} /* 4087 */,
    {.source = (const lxb_char_t *) "xn--4xa25ks2jenu.-", .ascii = (const lxb_char_t *) "xn--4xa25ks2jenu.-", .status = 20} /* 4088 */,
    {.source = (const lxb_char_t *) "xn--3xa45ks2jenu.-", .ascii = (const lxb_char_t *) "xn--3xa45ks2jenu.-", .status = 20} /* 4089 */,
    {.source = (const lxb_char_t *) "Σ\u200D\u0DD4\u0660｡-", .ascii = (const lxb_char_t *) "xn--4xa25ks2jenu.-", .status = 20} /* 4090 */,
    {.source = (const lxb_char_t *) "σ\u200D\u0DD4\u0660｡-", .ascii = (const lxb_char_t *) "xn--4xa25ks2jenu.-", .status = 20} /* 4091 */,
    {.source = (const lxb_char_t *) "\u200C.ßႩ-", .ascii = (const lxb_char_t *) "xn--0ug.xn----pfa042j", .status = 12} /* 4092 */,
    {.source = (const lxb_char_t *) "\u200C.ßⴉ-", .ascii = (const lxb_char_t *) "xn--0ug.xn----pfa2305a", .status = 8} /* 4093 */,
    {.source = (const lxb_char_t *) "\u200C.SSႩ-", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss--4rn", .status = 12} /* 4094 */,
    {.source = (const lxb_char_t *) "\u200C.ssⴉ-", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss--bi1b", .status = 8} /* 4095 */,
    {.source = (const lxb_char_t *) "\u200C.Ssⴉ-", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss--bi1b", .status = 8} /* 4096 */,
    {.source = (const lxb_char_t *) ".xn--ss--bi1b", .ascii = (const lxb_char_t *) ".xn--ss--bi1b", .status = 10} /* 4097 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--ss--bi1b", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss--bi1b", .status = 8} /* 4098 */,
    {.source = (const lxb_char_t *) ".xn--ss--4rn", .ascii = (const lxb_char_t *) ".xn--ss--4rn", .status = 14} /* 4099 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--ss--4rn", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss--4rn", .status = 12} /* 4100 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn----pfa2305a", .ascii = (const lxb_char_t *) "xn--0ug.xn----pfa2305a", .status = 8} /* 4101 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn----pfa042j", .ascii = (const lxb_char_t *) "xn--0ug.xn----pfa042j", .status = 12} /* 4102 */,
    {.source = (const lxb_char_t *) "󍭲𐫍㓱。⾑", .ascii = (const lxb_char_t *) "xn--u7kt691dlj09f.xn--9v2a", .status = 8} /* 4103 */,
    {.source = (const lxb_char_t *) "󍭲𐫍㓱。襾", .ascii = (const lxb_char_t *) "xn--u7kt691dlj09f.xn--9v2a", .status = 8} /* 4104 */,
    {.source = (const lxb_char_t *) "xn--u7kt691dlj09f.xn--9v2a", .ascii = (const lxb_char_t *) "xn--u7kt691dlj09f.xn--9v2a", .status = 8} /* 4105 */,
    {.source = (const lxb_char_t *) "\u06A0𐮋𐹰≮。≯󠦗\u200D", .ascii = (const lxb_char_t *) "xn--2jb053lf13nyoc.xn--1ugx6gc8096c", .status = 16} /* 4106 */,
    {.source = (const lxb_char_t *) "\u06A0𐮋𐹰<\u0338。>\u0338󠦗\u200D", .ascii = (const lxb_char_t *) "xn--2jb053lf13nyoc.xn--1ugx6gc8096c", .status = 16} /* 4107 */,
    {.source = (const lxb_char_t *) "xn--2jb053lf13nyoc.xn--hdh08821l", .ascii = (const lxb_char_t *) "xn--2jb053lf13nyoc.xn--hdh08821l", .status = 12} /* 4108 */,
    {.source = (const lxb_char_t *) "xn--2jb053lf13nyoc.xn--1ugx6gc8096c", .ascii = (const lxb_char_t *) "xn--2jb053lf13nyoc.xn--1ugx6gc8096c", .status = 16} /* 4109 */,
    {.source = (const lxb_char_t *) "𝟞｡񃰶\u0777\u08B0⩋", .ascii = (const lxb_char_t *) "6.xn--7pb04do15eq748f", .status = 16} /* 4110 */,
    {.source = (const lxb_char_t *) "6。񃰶\u0777\u08B0⩋", .ascii = (const lxb_char_t *) "6.xn--7pb04do15eq748f", .status = 16} /* 4111 */,
    {.source = (const lxb_char_t *) "6.xn--7pb04do15eq748f", .ascii = (const lxb_char_t *) "6.xn--7pb04do15eq748f", .status = 16} /* 4112 */,
    {.source = (const lxb_char_t *) "-\uFCFD。𑇀𑍴", .ascii = (const lxb_char_t *) "xn----qnc7d.xn--wd1d62a", .status = 12} /* 4113 */,
    {.source = (const lxb_char_t *) "-\uFCFD。𑇀𑍴", .ascii = (const lxb_char_t *) "xn----qnc7d.xn--wd1d62a", .status = 12} /* 4114 */,
    {.source = (const lxb_char_t *) "-\u0634\u0649。𑇀𑍴", .ascii = (const lxb_char_t *) "xn----qnc7d.xn--wd1d62a", .status = 12} /* 4115 */,
    {.source = (const lxb_char_t *) "xn----qnc7d.xn--wd1d62a", .ascii = (const lxb_char_t *) "xn----qnc7d.xn--wd1d62a", .status = 12} /* 4116 */,
    {.source = (const lxb_char_t *) "\u200C󠊶𝟏.\u0D43򪥐𐹬󊓶", .ascii = (const lxb_char_t *) "xn--1-rgnu0071n.xn--mxc0872kcu37dnmem", .status = 16} /* 4117 */,
    {.source = (const lxb_char_t *) "\u200C󠊶1.\u0D43򪥐𐹬󊓶", .ascii = (const lxb_char_t *) "xn--1-rgnu0071n.xn--mxc0872kcu37dnmem", .status = 16} /* 4118 */,
    {.source = (const lxb_char_t *) "xn--1-f521m.xn--mxc0872kcu37dnmem", .ascii = (const lxb_char_t *) "xn--1-f521m.xn--mxc0872kcu37dnmem", .status = 12} /* 4119 */,
    {.source = (const lxb_char_t *) "xn--1-rgnu0071n.xn--mxc0872kcu37dnmem", .ascii = (const lxb_char_t *) "xn--1-rgnu0071n.xn--mxc0872kcu37dnmem", .status = 16} /* 4120 */,
    {.source = (const lxb_char_t *) "齙--𝟰.ß", .ascii = (const lxb_char_t *) "xn----4-p16k.xn--zca", .status = 0} /* 4121 */,
    {.source = (const lxb_char_t *) "齙--4.ß", .ascii = (const lxb_char_t *) "xn----4-p16k.xn--zca", .status = 0} /* 4122 */,
    {.source = (const lxb_char_t *) "齙--4.SS", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4123 */,
    {.source = (const lxb_char_t *) "齙--4.ss", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4124 */,
    {.source = (const lxb_char_t *) "齙--4.Ss", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4125 */,
    {.source = (const lxb_char_t *) "xn----4-p16k.ss", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4126 */,
    {.source = (const lxb_char_t *) "xn----4-p16k.xn--zca", .ascii = (const lxb_char_t *) "xn----4-p16k.xn--zca", .status = 0} /* 4127 */,
    {.source = (const lxb_char_t *) "齙--𝟰.SS", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4128 */,
    {.source = (const lxb_char_t *) "齙--𝟰.ss", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4129 */,
    {.source = (const lxb_char_t *) "齙--𝟰.Ss", .ascii = (const lxb_char_t *) "xn----4-p16k.ss", .status = 0} /* 4130 */,
    {.source = (const lxb_char_t *) "\u1BF2.𐹢𞀖\u200C", .ascii = (const lxb_char_t *) "xn--0zf.xn--0ug9894grqqf", .status = 12} /* 4131 */,
    {.source = (const lxb_char_t *) "xn--0zf.xn--9n0d2296a", .ascii = (const lxb_char_t *) "xn--0zf.xn--9n0d2296a", .status = 8} /* 4132 */,
    {.source = (const lxb_char_t *) "xn--0zf.xn--0ug9894grqqf", .ascii = (const lxb_char_t *) "xn--0zf.xn--0ug9894grqqf", .status = 12} /* 4133 */,
    {.source = (const lxb_char_t *) "󃲙󠋘｡?-\u200D", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .status = 8} /* 4134 */,
    {.source = (const lxb_char_t *) "󃲙󠋘。?-\u200D", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .status = 8} /* 4135 */,
    {.source = (const lxb_char_t *) "xn--ct86d8w51a.?-", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.?-", .status = 8} /* 4136 */,
    {.source = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .status = 8} /* 4137 */,
    {.source = (const lxb_char_t *) "xn--ct86d8w51a.?-\u200D", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .status = 8} /* 4138 */,
    {.source = (const lxb_char_t *) "XN--CT86D8W51A.?-\u200D", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .status = 8} /* 4139 */,
    {.source = (const lxb_char_t *) "Xn--Ct86d8w51a.?-\u200D", .ascii = (const lxb_char_t *) "xn--ct86d8w51a.xn--?--n1t", .status = 8} /* 4140 */,
    {.source = (const lxb_char_t *) "\u1A60．𞵷-𝪩悎", .ascii = (const lxb_char_t *) "xn--jof.xn----gf4bq282iezpa", .status = 20} /* 4141 */,
    {.source = (const lxb_char_t *) "\u1A60.𞵷-𝪩悎", .ascii = (const lxb_char_t *) "xn--jof.xn----gf4bq282iezpa", .status = 20} /* 4142 */,
    {.source = (const lxb_char_t *) "xn--jof.xn----gf4bq282iezpa", .ascii = (const lxb_char_t *) "xn--jof.xn----gf4bq282iezpa", .status = 20} /* 4143 */,
    {.source = (const lxb_char_t *) "𛜯󠊛．𞤳񏥾", .ascii = (const lxb_char_t *) "xn--xx5gy2741c.xn--re6hw266j", .status = 16} /* 4144 */,
    {.source = (const lxb_char_t *) "𛜯󠊛.𞤳񏥾", .ascii = (const lxb_char_t *) "xn--xx5gy2741c.xn--re6hw266j", .status = 16} /* 4145 */,
    {.source = (const lxb_char_t *) "𛜯󠊛.𞤑񏥾", .ascii = (const lxb_char_t *) "xn--xx5gy2741c.xn--re6hw266j", .status = 16} /* 4146 */,
    {.source = (const lxb_char_t *) "xn--xx5gy2741c.xn--re6hw266j", .ascii = (const lxb_char_t *) "xn--xx5gy2741c.xn--re6hw266j", .status = 16} /* 4147 */,
    {.source = (const lxb_char_t *) "𛜯󠊛．𞤑񏥾", .ascii = (const lxb_char_t *) "xn--xx5gy2741c.xn--re6hw266j", .status = 16} /* 4148 */,
    {.source = (const lxb_char_t *) "\u071C𐫒\u062E.𐋲", .ascii = (const lxb_char_t *) "xn--tgb98b8643d.xn--m97c", .status = 4} /* 4149 */,
    {.source = (const lxb_char_t *) "xn--tgb98b8643d.xn--m97c", .ascii = (const lxb_char_t *) "xn--tgb98b8643d.xn--m97c", .status = 4} /* 4150 */,
    {.source = (const lxb_char_t *) "𐼑𞤓\u0637\u08E2.?", .ascii = (const lxb_char_t *) "xn--2gb08k9w69agm0g.?", .status = 8} /* 4151 */,
    {.source = (const lxb_char_t *) "𐼑𞤵\u0637\u08E2.?", .ascii = (const lxb_char_t *) "xn--2gb08k9w69agm0g.?", .status = 8} /* 4152 */,
    {.source = (const lxb_char_t *) "xn--2gb08k9w69agm0g.?", .ascii = (const lxb_char_t *) "xn--2gb08k9w69agm0g.?", .status = 8} /* 4153 */,
    {.source = (const lxb_char_t *) "Ↄ。\u0A4D\u1CD4𞷣", .ascii = (const lxb_char_t *) "xn--q5g.xn--ybc995g0835a", .status = 12} /* 4154 */,
    {.source = (const lxb_char_t *) "Ↄ。\u1CD4\u0A4D𞷣", .ascii = (const lxb_char_t *) "xn--q5g.xn--ybc995g0835a", .status = 12} /* 4155 */,
    {.source = (const lxb_char_t *) "ↄ。\u1CD4\u0A4D𞷣", .ascii = (const lxb_char_t *) "xn--r5g.xn--ybc995g0835a", .status = 12} /* 4156 */,
    {.source = (const lxb_char_t *) "xn--r5g.xn--ybc995g0835a", .ascii = (const lxb_char_t *) "xn--r5g.xn--ybc995g0835a", .status = 12} /* 4157 */,
    {.source = (const lxb_char_t *) "xn--q5g.xn--ybc995g0835a", .ascii = (const lxb_char_t *) "xn--q5g.xn--ybc995g0835a", .status = 12} /* 4158 */,
    {.source = (const lxb_char_t *) "ↄ。\u0A4D\u1CD4𞷣", .ascii = (const lxb_char_t *) "xn--r5g.xn--ybc995g0835a", .status = 12} /* 4159 */,
    {.source = (const lxb_char_t *) "󠪢-。򛂏≮𑜫", .ascii = (const lxb_char_t *) "xn----bh61m.xn--gdhz157g0em1d", .status = 8} /* 4160 */,
    {.source = (const lxb_char_t *) "󠪢-。򛂏<\u0338𑜫", .ascii = (const lxb_char_t *) "xn----bh61m.xn--gdhz157g0em1d", .status = 8} /* 4161 */,
    {.source = (const lxb_char_t *) "xn----bh61m.xn--gdhz157g0em1d", .ascii = (const lxb_char_t *) "xn----bh61m.xn--gdhz157g0em1d", .status = 8} /* 4162 */,
    {.source = (const lxb_char_t *) "\u200C󠉹\u200D。򌿧≮Ⴉ", .ascii = (const lxb_char_t *) "xn--0ugc90904y.xn--hnd112gpz83n", .status = 12} /* 4163 */,
    {.source = (const lxb_char_t *) "\u200C󠉹\u200D。򌿧<\u0338Ⴉ", .ascii = (const lxb_char_t *) "xn--0ugc90904y.xn--hnd112gpz83n", .status = 12} /* 4164 */,
    {.source = (const lxb_char_t *) "\u200C󠉹\u200D。򌿧<\u0338ⴉ", .ascii = (const lxb_char_t *) "xn--0ugc90904y.xn--gdh992byu01p", .status = 12} /* 4165 */,
    {.source = (const lxb_char_t *) "\u200C󠉹\u200D。򌿧≮ⴉ", .ascii = (const lxb_char_t *) "xn--0ugc90904y.xn--gdh992byu01p", .status = 12} /* 4166 */,
    {.source = (const lxb_char_t *) "xn--3n36e.xn--gdh992byu01p", .ascii = (const lxb_char_t *) "xn--3n36e.xn--gdh992byu01p", .status = 4} /* 4167 */,
    {.source = (const lxb_char_t *) "xn--0ugc90904y.xn--gdh992byu01p", .ascii = (const lxb_char_t *) "xn--0ugc90904y.xn--gdh992byu01p", .status = 12} /* 4168 */,
    {.source = (const lxb_char_t *) "xn--3n36e.xn--hnd112gpz83n", .ascii = (const lxb_char_t *) "xn--3n36e.xn--hnd112gpz83n", .status = 4} /* 4169 */,
    {.source = (const lxb_char_t *) "xn--0ugc90904y.xn--hnd112gpz83n", .ascii = (const lxb_char_t *) "xn--0ugc90904y.xn--hnd112gpz83n", .status = 12} /* 4170 */,
    {.source = (const lxb_char_t *) "𐹯-𑄴\u08BC。︒䖐⾆", .ascii = (const lxb_char_t *) "xn----rpd7902rclc.xn--fpo216mn07e", .status = 8} /* 4171 */,
    {.source = (const lxb_char_t *) "𐹯-𑄴\u08BC。。䖐舌", .ascii = (const lxb_char_t *) "xn----rpd7902rclc..xn--fpo216m", .status = 10} /* 4172 */,
    {.source = (const lxb_char_t *) "xn----rpd7902rclc..xn--fpo216m", .ascii = (const lxb_char_t *) "xn----rpd7902rclc..xn--fpo216m", .status = 10} /* 4173 */,
    {.source = (const lxb_char_t *) "xn----rpd7902rclc.xn--fpo216mn07e", .ascii = (const lxb_char_t *) "xn----rpd7902rclc.xn--fpo216mn07e", .status = 8} /* 4174 */,
    {.source = (const lxb_char_t *) "𝪞Ⴐ｡쪡", .ascii = (const lxb_char_t *) "xn--ond3755u.xn--pi6b", .status = 8} /* 4175 */,
    {.source = (const lxb_char_t *) "𝪞Ⴐ｡쪡", .ascii = (const lxb_char_t *) "xn--ond3755u.xn--pi6b", .status = 8} /* 4176 */,
    {.source = (const lxb_char_t *) "𝪞Ⴐ。쪡", .ascii = (const lxb_char_t *) "xn--ond3755u.xn--pi6b", .status = 8} /* 4177 */,
    {.source = (const lxb_char_t *) "𝪞Ⴐ。쪡", .ascii = (const lxb_char_t *) "xn--ond3755u.xn--pi6b", .status = 8} /* 4178 */,
    {.source = (const lxb_char_t *) "𝪞ⴐ。쪡", .ascii = (const lxb_char_t *) "xn--7kj1858k.xn--pi6b", .status = 4} /* 4179 */,
    {.source = (const lxb_char_t *) "𝪞ⴐ。쪡", .ascii = (const lxb_char_t *) "xn--7kj1858k.xn--pi6b", .status = 4} /* 4180 */,
    {.source = (const lxb_char_t *) "xn--7kj1858k.xn--pi6b", .ascii = (const lxb_char_t *) "xn--7kj1858k.xn--pi6b", .status = 4} /* 4181 */,
    {.source = (const lxb_char_t *) "xn--ond3755u.xn--pi6b", .ascii = (const lxb_char_t *) "xn--ond3755u.xn--pi6b", .status = 8} /* 4182 */,
    {.source = (const lxb_char_t *) "𝪞ⴐ｡쪡", .ascii = (const lxb_char_t *) "xn--7kj1858k.xn--pi6b", .status = 4} /* 4183 */,
    {.source = (const lxb_char_t *) "𝪞ⴐ｡쪡", .ascii = (const lxb_char_t *) "xn--7kj1858k.xn--pi6b", .status = 4} /* 4184 */,
    {.source = (const lxb_char_t *) "\u0E3A쩁𐹬.􋉳", .ascii = (const lxb_char_t *) "xn--o4c4837g2zvb.xn--5f70g", .status = 12} /* 4185 */,
    {.source = (const lxb_char_t *) "\u0E3A쩁𐹬.􋉳", .ascii = (const lxb_char_t *) "xn--o4c4837g2zvb.xn--5f70g", .status = 12} /* 4186 */,
    {.source = (const lxb_char_t *) "xn--o4c4837g2zvb.xn--5f70g", .ascii = (const lxb_char_t *) "xn--o4c4837g2zvb.xn--5f70g", .status = 12} /* 4187 */,
    {.source = (const lxb_char_t *) "ᡅ０\u200C｡⎢󤨄", .ascii = (const lxb_char_t *) "xn--0-z6jy93b.xn--8lh28773l", .status = 8} /* 4188 */,
    {.source = (const lxb_char_t *) "ᡅ0\u200C。⎢󤨄", .ascii = (const lxb_char_t *) "xn--0-z6jy93b.xn--8lh28773l", .status = 8} /* 4189 */,
    {.source = (const lxb_char_t *) "xn--0-z6j.xn--8lh28773l", .ascii = (const lxb_char_t *) "xn--0-z6j.xn--8lh28773l", .status = 4} /* 4190 */,
    {.source = (const lxb_char_t *) "xn--0-z6jy93b.xn--8lh28773l", .ascii = (const lxb_char_t *) "xn--0-z6jy93b.xn--8lh28773l", .status = 8} /* 4191 */,
    {.source = (const lxb_char_t *) "𲮚９ꍩ\u17D3．\u200Dß", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--zca770n", .status = 8} /* 4192 */,
    {.source = (const lxb_char_t *) "𲮚9ꍩ\u17D3.\u200Dß", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--zca770n", .status = 8} /* 4193 */,
    {.source = (const lxb_char_t *) "𲮚9ꍩ\u17D3.\u200DSS", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4194 */,
    {.source = (const lxb_char_t *) "𲮚9ꍩ\u17D3.\u200Dss", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4195 */,
    {.source = (const lxb_char_t *) "xn--9-i0j5967eg3qz.ss", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.ss", .status = 4} /* 4196 */,
    {.source = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4197 */,
    {.source = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--zca770n", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--zca770n", .status = 8} /* 4198 */,
    {.source = (const lxb_char_t *) "𲮚９ꍩ\u17D3．\u200DSS", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4199 */,
    {.source = (const lxb_char_t *) "𲮚９ꍩ\u17D3．\u200Dss", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4200 */,
    {.source = (const lxb_char_t *) "𲮚9ꍩ\u17D3.\u200DSs", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4201 */,
    {.source = (const lxb_char_t *) "𲮚９ꍩ\u17D3．\u200DSs", .ascii = (const lxb_char_t *) "xn--9-i0j5967eg3qz.xn--ss-l1t", .status = 8} /* 4202 */,
    {.source = (const lxb_char_t *) "ꗷ𑆀.\u075D𐩒", .ascii = (const lxb_char_t *) "xn--ju8a625r.xn--hpb0073k", .status = 0} /* 4203 */,
    {.source = (const lxb_char_t *) "xn--ju8a625r.xn--hpb0073k", .ascii = (const lxb_char_t *) "xn--ju8a625r.xn--hpb0073k", .status = 0} /* 4204 */,
    {.source = (const lxb_char_t *) "⒐≯-。︒򩑣-񞛠", .ascii = (const lxb_char_t *) "xn----ogot9g.xn----n89hl0522az9u2a", .status = 8} /* 4205 */,
    {.source = (const lxb_char_t *) "⒐>\u0338-。︒򩑣-񞛠", .ascii = (const lxb_char_t *) "xn----ogot9g.xn----n89hl0522az9u2a", .status = 8} /* 4206 */,
    {.source = (const lxb_char_t *) "9.≯-。。򩑣-񞛠", .ascii = (const lxb_char_t *) "9.xn----ogo..xn----xj54d1s69k", .status = 14} /* 4207 */,
    {.source = (const lxb_char_t *) "9.>\u0338-。。򩑣-񞛠", .ascii = (const lxb_char_t *) "9.xn----ogo..xn----xj54d1s69k", .status = 14} /* 4208 */,
    {.source = (const lxb_char_t *) "9.xn----ogo..xn----xj54d1s69k", .ascii = (const lxb_char_t *) "9.xn----ogo..xn----xj54d1s69k", .status = 14} /* 4209 */,
    {.source = (const lxb_char_t *) "xn----ogot9g.xn----n89hl0522az9u2a", .ascii = (const lxb_char_t *) "xn----ogot9g.xn----n89hl0522az9u2a", .status = 8} /* 4210 */,
    {.source = (const lxb_char_t *) "򈪚\u0CE3Ⴡ󠢏．\u061D", .ascii = (const lxb_char_t *) "xn--vuc49qvu85xmju7a.xn--cgb", .status = 8} /* 4211 */,
    {.source = (const lxb_char_t *) "򈪚\u0CE3Ⴡ󠢏.\u061D", .ascii = (const lxb_char_t *) "xn--vuc49qvu85xmju7a.xn--cgb", .status = 8} /* 4212 */,
    {.source = (const lxb_char_t *) "򈪚\u0CE3ⴡ󠢏.\u061D", .ascii = (const lxb_char_t *) "xn--vuc226n8n28lmju7a.xn--cgb", .status = 8} /* 4213 */,
    {.source = (const lxb_char_t *) "xn--vuc226n8n28lmju7a.xn--cgb", .ascii = (const lxb_char_t *) "xn--vuc226n8n28lmju7a.xn--cgb", .status = 8} /* 4214 */,
    {.source = (const lxb_char_t *) "xn--vuc49qvu85xmju7a.xn--cgb", .ascii = (const lxb_char_t *) "xn--vuc49qvu85xmju7a.xn--cgb", .status = 8} /* 4215 */,
    {.source = (const lxb_char_t *) "򈪚\u0CE3ⴡ󠢏．\u061D", .ascii = (const lxb_char_t *) "xn--vuc226n8n28lmju7a.xn--cgb", .status = 8} /* 4216 */,
    {.source = (const lxb_char_t *) "\u1DEB。𐋩\u0638-𐫮", .ascii = (const lxb_char_t *) "xn--gfg.xn----xnc0815qyyg", .status = 8} /* 4217 */,
    {.source = (const lxb_char_t *) "xn--gfg.xn----xnc0815qyyg", .ascii = (const lxb_char_t *) "xn--gfg.xn----xnc0815qyyg", .status = 8} /* 4218 */,
    {.source = (const lxb_char_t *) "싇。⾇𐳋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4219 */,
    {.source = (const lxb_char_t *) "싇。⾇𐳋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4220 */,
    {.source = (const lxb_char_t *) "싇。舛𐳋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4221 */,
    {.source = (const lxb_char_t *) "싇。舛𐳋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4222 */,
    {.source = (const lxb_char_t *) "싇。舛𐳋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4223 */,
    {.source = (const lxb_char_t *) "싇。舛𐳋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4224 */,
    {.source = (const lxb_char_t *) "싇。舛𐲋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4225 */,
    {.source = (const lxb_char_t *) "싇。舛𐲋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4226 */,
    {.source = (const lxb_char_t *) "싇。舛𐲋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4227 */,
    {.source = (const lxb_char_t *) "싇。舛𐲋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4228 */,
    {.source = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4229 */,
    {.source = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4230 */,
    {.source = (const lxb_char_t *) "싇。⾇𐳋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4231 */,
    {.source = (const lxb_char_t *) "싇。⾇𐳋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4232 */,
    {.source = (const lxb_char_t *) "싇。⾇𐲋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4233 */,
    {.source = (const lxb_char_t *) "싇。⾇𐲋Ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--1nd7519ch79d", .status = 8} /* 4234 */,
    {.source = (const lxb_char_t *) "싇。⾇𐲋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4235 */,
    {.source = (const lxb_char_t *) "싇。⾇𐲋ⴝ", .ascii = (const lxb_char_t *) "xn--9u4b.xn--llj123yh74e", .status = 4} /* 4236 */,
    {.source = (const lxb_char_t *) "𐹠ς。\u200C\u06BFჀ", .ascii = (const lxb_char_t *) "xn--3xa1267k.xn--ykb632cvxm", .status = 12} /* 4237 */,
    {.source = (const lxb_char_t *) "𐹠ς。\u200C\u06BFⴠ", .ascii = (const lxb_char_t *) "xn--3xa1267k.xn--ykb760k9hj", .status = 8} /* 4238 */,
    {.source = (const lxb_char_t *) "𐹠Σ。\u200C\u06BFჀ", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb632cvxm", .status = 12} /* 4239 */,
    {.source = (const lxb_char_t *) "𐹠σ。\u200C\u06BFⴠ", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb760k9hj", .status = 8} /* 4240 */,
    {.source = (const lxb_char_t *) "𐹠Σ。\u200C\u06BFⴠ", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb760k9hj", .status = 8} /* 4241 */,
    {.source = (const lxb_char_t *) "xn--4xa9167k.xn--ykb467q", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb467q", .status = 12} /* 4242 */,
    {.source = (const lxb_char_t *) "xn--4xa9167k.xn--ykb760k9hj", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb760k9hj", .status = 8} /* 4243 */,
    {.source = (const lxb_char_t *) "xn--4xa9167k.xn--ykb632c", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb632c", .status = 16} /* 4244 */,
    {.source = (const lxb_char_t *) "xn--4xa9167k.xn--ykb632cvxm", .ascii = (const lxb_char_t *) "xn--4xa9167k.xn--ykb632cvxm", .status = 12} /* 4245 */,
    {.source = (const lxb_char_t *) "xn--3xa1267k.xn--ykb760k9hj", .ascii = (const lxb_char_t *) "xn--3xa1267k.xn--ykb760k9hj", .status = 8} /* 4246 */,
    {.source = (const lxb_char_t *) "xn--3xa1267k.xn--ykb632cvxm", .ascii = (const lxb_char_t *) "xn--3xa1267k.xn--ykb632cvxm", .status = 12} /* 4247 */,
    {.source = (const lxb_char_t *) "򇒐\u200C\u0604.\u069A-ß", .ascii = (const lxb_char_t *) "xn--mfb144kqo32m.xn----qfa315b", .status = 24} /* 4248 */,
    {.source = (const lxb_char_t *) "򇒐\u200C\u0604.\u069A-SS", .ascii = (const lxb_char_t *) "xn--mfb144kqo32m.xn---ss-sdf", .status = 24} /* 4249 */,
    {.source = (const lxb_char_t *) "򇒐\u200C\u0604.\u069A-ss", .ascii = (const lxb_char_t *) "xn--mfb144kqo32m.xn---ss-sdf", .status = 24} /* 4250 */,
    {.source = (const lxb_char_t *) "򇒐\u200C\u0604.\u069A-Ss", .ascii = (const lxb_char_t *) "xn--mfb144kqo32m.xn---ss-sdf", .status = 24} /* 4251 */,
    {.source = (const lxb_char_t *) "xn--mfb98261i.xn---ss-sdf", .ascii = (const lxb_char_t *) "xn--mfb98261i.xn---ss-sdf", .status = 20} /* 4252 */,
    {.source = (const lxb_char_t *) "xn--mfb144kqo32m.xn---ss-sdf", .ascii = (const lxb_char_t *) "xn--mfb144kqo32m.xn---ss-sdf", .status = 24} /* 4253 */,
    {.source = (const lxb_char_t *) "xn--mfb144kqo32m.xn----qfa315b", .ascii = (const lxb_char_t *) "xn--mfb144kqo32m.xn----qfa315b", .status = 24} /* 4254 */,
    {.source = (const lxb_char_t *) "\u200C\u200D\u17B5\u067A.-\uFBB0󅄞𐸚", .ascii = (const lxb_char_t *) "xn--zib539f8igea.xn----twc1133r17r6g", .status = 20} /* 4255 */,
    {.source = (const lxb_char_t *) "\u200C\u200D\u17B5\u067A.-\u06D3󅄞𐸚", .ascii = (const lxb_char_t *) "xn--zib539f8igea.xn----twc1133r17r6g", .status = 20} /* 4256 */,
    {.source = (const lxb_char_t *) "\u200C\u200D\u17B5\u067A.-\u06D2\u0654󅄞𐸚", .ascii = (const lxb_char_t *) "xn--zib539f8igea.xn----twc1133r17r6g", .status = 20} /* 4257 */,
    {.source = (const lxb_char_t *) "xn--zib539f.xn----twc1133r17r6g", .ascii = (const lxb_char_t *) "xn--zib539f.xn----twc1133r17r6g", .status = 16} /* 4258 */,
    {.source = (const lxb_char_t *) "xn--zib539f8igea.xn----twc1133r17r6g", .ascii = (const lxb_char_t *) "xn--zib539f8igea.xn----twc1133r17r6g", .status = 20} /* 4259 */,
    {.source = (const lxb_char_t *) "򡶱｡𐮬≠", .ascii = (const lxb_char_t *) "xn--dd55c.xn--1ch3003g", .status = 8} /* 4260 */,
    {.source = (const lxb_char_t *) "򡶱｡𐮬=\u0338", .ascii = (const lxb_char_t *) "xn--dd55c.xn--1ch3003g", .status = 8} /* 4261 */,
    {.source = (const lxb_char_t *) "򡶱。𐮬≠", .ascii = (const lxb_char_t *) "xn--dd55c.xn--1ch3003g", .status = 8} /* 4262 */,
    {.source = (const lxb_char_t *) "򡶱。𐮬=\u0338", .ascii = (const lxb_char_t *) "xn--dd55c.xn--1ch3003g", .status = 8} /* 4263 */,
    {.source = (const lxb_char_t *) "xn--dd55c.xn--1ch3003g", .ascii = (const lxb_char_t *) "xn--dd55c.xn--1ch3003g", .status = 8} /* 4264 */,
    {.source = (const lxb_char_t *) "\u0FB2𞶅｡𐹮𐹷덝۵", .ascii = (const lxb_char_t *) "xn--fgd0675v.xn--imb5839fidpcbba", .status = 12} /* 4265 */,
    {.source = (const lxb_char_t *) "\u0FB2𞶅｡𐹮𐹷덝۵", .ascii = (const lxb_char_t *) "xn--fgd0675v.xn--imb5839fidpcbba", .status = 12} /* 4266 */,
    {.source = (const lxb_char_t *) "\u0FB2𞶅。𐹮𐹷덝۵", .ascii = (const lxb_char_t *) "xn--fgd0675v.xn--imb5839fidpcbba", .status = 12} /* 4267 */,
    {.source = (const lxb_char_t *) "\u0FB2𞶅。𐹮𐹷덝۵", .ascii = (const lxb_char_t *) "xn--fgd0675v.xn--imb5839fidpcbba", .status = 12} /* 4268 */,
    {.source = (const lxb_char_t *) "xn--fgd0675v.xn--imb5839fidpcbba", .ascii = (const lxb_char_t *) "xn--fgd0675v.xn--imb5839fidpcbba", .status = 12} /* 4269 */,
    {.source = (const lxb_char_t *) "Ⴏ󠅋-．\u200DႩ", .ascii = (const lxb_char_t *) "xn----00g.xn--hnd399e", .status = 12} /* 4270 */,
    {.source = (const lxb_char_t *) "Ⴏ󠅋-.\u200DႩ", .ascii = (const lxb_char_t *) "xn----00g.xn--hnd399e", .status = 12} /* 4271 */,
    {.source = (const lxb_char_t *) "ⴏ󠅋-.\u200Dⴉ", .ascii = (const lxb_char_t *) "xn----3vs.xn--1ug532c", .status = 8} /* 4272 */,
    {.source = (const lxb_char_t *) "xn----3vs.xn--0kj", .ascii = (const lxb_char_t *) "xn----3vs.xn--0kj", .status = 4} /* 4273 */,
    {.source = (const lxb_char_t *) "xn----3vs.xn--1ug532c", .ascii = (const lxb_char_t *) "xn----3vs.xn--1ug532c", .status = 8} /* 4274 */,
    {.source = (const lxb_char_t *) "xn----00g.xn--hnd", .ascii = (const lxb_char_t *) "xn----00g.xn--hnd", .status = 8} /* 4275 */,
    {.source = (const lxb_char_t *) "xn----00g.xn--hnd399e", .ascii = (const lxb_char_t *) "xn----00g.xn--hnd399e", .status = 12} /* 4276 */,
    {.source = (const lxb_char_t *) "ⴏ󠅋-．\u200Dⴉ", .ascii = (const lxb_char_t *) "xn----3vs.xn--1ug532c", .status = 8} /* 4277 */,
    {.source = (const lxb_char_t *) "⇧𐨏󠾈󯶅。\u0600󠈵󠆉", .ascii = (const lxb_char_t *) "xn--l8g5552g64t4g46xf.xn--ifb08144p", .status = 8} /* 4278 */,
    {.source = (const lxb_char_t *) "xn--l8g5552g64t4g46xf.xn--ifb08144p", .ascii = (const lxb_char_t *) "xn--l8g5552g64t4g46xf.xn--ifb08144p", .status = 8} /* 4279 */,
    {.source = (const lxb_char_t *) "≠𐮂.↑🄇⒈", .ascii = (const lxb_char_t *) "xn--1chy492g.xn--45gx9iuy44d", .status = 8} /* 4280 */,
    {.source = (const lxb_char_t *) "=\u0338𐮂.↑🄇⒈", .ascii = (const lxb_char_t *) "xn--1chy492g.xn--45gx9iuy44d", .status = 8} /* 4281 */,
    {.source = (const lxb_char_t *) "≠𐮂.↑6,1.", .ascii = (const lxb_char_t *) "xn--1chy492g.xn--6,1-pw1a.", .status = 8} /* 4282 */,
    {.source = (const lxb_char_t *) "=\u0338𐮂.↑6,1.", .ascii = (const lxb_char_t *) "xn--1chy492g.xn--6,1-pw1a.", .status = 8} /* 4283 */,
    {.source = (const lxb_char_t *) "xn--1chy492g.xn--6,1-pw1a.", .ascii = (const lxb_char_t *) "xn--1chy492g.xn--6,1-pw1a.", .status = 8} /* 4284 */,
    {.source = (const lxb_char_t *) "xn--1chy492g.xn--45gx9iuy44d", .ascii = (const lxb_char_t *) "xn--1chy492g.xn--45gx9iuy44d", .status = 8} /* 4285 */,
    {.source = (const lxb_char_t *) "𝩏󠲉ß.ᢤ򄦌\u200C𐹫", .ascii = (const lxb_char_t *) "xn--zca3153vupz3e.xn--ubf609atw1tynn3d", .status = 24} /* 4286 */,
    {.source = (const lxb_char_t *) "𝩏󠲉SS.ᢤ򄦌\u200C𐹫", .ascii = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d", .status = 24} /* 4287 */,
    {.source = (const lxb_char_t *) "𝩏󠲉ss.ᢤ򄦌\u200C𐹫", .ascii = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d", .status = 24} /* 4288 */,
    {.source = (const lxb_char_t *) "𝩏󠲉Ss.ᢤ򄦌\u200C𐹫", .ascii = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d", .status = 24} /* 4289 */,
    {.source = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf2596jbt61c", .ascii = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf2596jbt61c", .status = 20} /* 4290 */,
    {.source = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d", .ascii = (const lxb_char_t *) "xn--ss-zb11ap1427e.xn--ubf609atw1tynn3d", .status = 24} /* 4291 */,
    {.source = (const lxb_char_t *) "xn--zca3153vupz3e.xn--ubf609atw1tynn3d", .ascii = (const lxb_char_t *) "xn--zca3153vupz3e.xn--ubf609atw1tynn3d", .status = 24} /* 4292 */,
    {.source = (const lxb_char_t *) "ß𐵳񗘁Ⴇ｡\uA67A", .ascii = (const lxb_char_t *) "xn--zca491fci5qkn79a.xn--9x8a", .status = 16} /* 4293 */,
    {.source = (const lxb_char_t *) "ß𐵳񗘁Ⴇ。\uA67A", .ascii = (const lxb_char_t *) "xn--zca491fci5qkn79a.xn--9x8a", .status = 16} /* 4294 */,
    {.source = (const lxb_char_t *) "ß𐵳񗘁ⴇ。\uA67A", .ascii = (const lxb_char_t *) "xn--zca227tpy4lkns1b.xn--9x8a", .status = 16} /* 4295 */,
    {.source = (const lxb_char_t *) "SS𐵳񗘁Ⴇ。\uA67A", .ascii = (const lxb_char_t *) "xn--ss-rek7420r4hs7b.xn--9x8a", .status = 16} /* 4296 */,
    {.source = (const lxb_char_t *) "ss𐵳񗘁ⴇ。\uA67A", .ascii = (const lxb_char_t *) "xn--ss-e61ar955h4hs7b.xn--9x8a", .status = 16} /* 4297 */,
    {.source = (const lxb_char_t *) "Ss𐵳񗘁Ⴇ。\uA67A", .ascii = (const lxb_char_t *) "xn--ss-rek7420r4hs7b.xn--9x8a", .status = 16} /* 4298 */,
    {.source = (const lxb_char_t *) "xn--ss-rek7420r4hs7b.xn--9x8a", .ascii = (const lxb_char_t *) "xn--ss-rek7420r4hs7b.xn--9x8a", .status = 16} /* 4299 */,
    {.source = (const lxb_char_t *) "xn--ss-e61ar955h4hs7b.xn--9x8a", .ascii = (const lxb_char_t *) "xn--ss-e61ar955h4hs7b.xn--9x8a", .status = 16} /* 4300 */,
    {.source = (const lxb_char_t *) "xn--zca227tpy4lkns1b.xn--9x8a", .ascii = (const lxb_char_t *) "xn--zca227tpy4lkns1b.xn--9x8a", .status = 16} /* 4301 */,
    {.source = (const lxb_char_t *) "xn--zca491fci5qkn79a.xn--9x8a", .ascii = (const lxb_char_t *) "xn--zca491fci5qkn79a.xn--9x8a", .status = 16} /* 4302 */,
    {.source = (const lxb_char_t *) "ß𐵳񗘁ⴇ｡\uA67A", .ascii = (const lxb_char_t *) "xn--zca227tpy4lkns1b.xn--9x8a", .status = 16} /* 4303 */,
    {.source = (const lxb_char_t *) "SS𐵳񗘁Ⴇ｡\uA67A", .ascii = (const lxb_char_t *) "xn--ss-rek7420r4hs7b.xn--9x8a", .status = 16} /* 4304 */,
    {.source = (const lxb_char_t *) "ss𐵳񗘁ⴇ｡\uA67A", .ascii = (const lxb_char_t *) "xn--ss-e61ar955h4hs7b.xn--9x8a", .status = 16} /* 4305 */,
    {.source = (const lxb_char_t *) "Ss𐵳񗘁Ⴇ｡\uA67A", .ascii = (const lxb_char_t *) "xn--ss-rek7420r4hs7b.xn--9x8a", .status = 16} /* 4306 */,
    {.source = (const lxb_char_t *) "\u1714。󠆣-𑋪", .ascii = (const lxb_char_t *) "xn--fze.xn----ly8i", .status = 8} /* 4307 */,
    {.source = (const lxb_char_t *) "xn--fze.xn----ly8i", .ascii = (const lxb_char_t *) "xn--fze.xn----ly8i", .status = 8} /* 4308 */,
    {.source = (const lxb_char_t *) "\uABE8-．򨏜\u05BDß", .ascii = (const lxb_char_t *) "xn----pw5e.xn--zca50wfv060a", .status = 12} /* 4309 */,
    {.source = (const lxb_char_t *) "\uABE8-.򨏜\u05BDß", .ascii = (const lxb_char_t *) "xn----pw5e.xn--zca50wfv060a", .status = 12} /* 4310 */,
    {.source = (const lxb_char_t *) "\uABE8-.򨏜\u05BDSS", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4311 */,
    {.source = (const lxb_char_t *) "\uABE8-.򨏜\u05BDss", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4312 */,
    {.source = (const lxb_char_t *) "\uABE8-.򨏜\u05BDSs", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4313 */,
    {.source = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4314 */,
    {.source = (const lxb_char_t *) "xn----pw5e.xn--zca50wfv060a", .ascii = (const lxb_char_t *) "xn----pw5e.xn--zca50wfv060a", .status = 12} /* 4315 */,
    {.source = (const lxb_char_t *) "\uABE8-．򨏜\u05BDSS", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4316 */,
    {.source = (const lxb_char_t *) "\uABE8-．򨏜\u05BDss", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4317 */,
    {.source = (const lxb_char_t *) "\uABE8-．򨏜\u05BDSs", .ascii = (const lxb_char_t *) "xn----pw5e.xn--ss-7jd10716y", .status = 12} /* 4318 */,
    {.source = (const lxb_char_t *) "ᡓ-≮。\u066B󠅱ᡄ", .ascii = (const lxb_char_t *) "xn----s7j866c.xn--kib252g", .status = 8} /* 4319 */,
    {.source = (const lxb_char_t *) "ᡓ-<\u0338。\u066B󠅱ᡄ", .ascii = (const lxb_char_t *) "xn----s7j866c.xn--kib252g", .status = 8} /* 4320 */,
    {.source = (const lxb_char_t *) "xn----s7j866c.xn--kib252g", .ascii = (const lxb_char_t *) "xn----s7j866c.xn--kib252g", .status = 8} /* 4321 */,
    {.source = (const lxb_char_t *) "𝟥♮𑜫\u08ED．\u17D2𑜫8󠆏", .ascii = (const lxb_char_t *) "xn--3-ksd277tlo7s.xn--8-f0jx021l", .status = 4} /* 4322 */,
    {.source = (const lxb_char_t *) "3♮𑜫\u08ED.\u17D2𑜫8󠆏", .ascii = (const lxb_char_t *) "xn--3-ksd277tlo7s.xn--8-f0jx021l", .status = 4} /* 4323 */,
    {.source = (const lxb_char_t *) "xn--3-ksd277tlo7s.xn--8-f0jx021l", .ascii = (const lxb_char_t *) "xn--3-ksd277tlo7s.xn--8-f0jx021l", .status = 4} /* 4324 */,
    {.source = (const lxb_char_t *) "-｡򕌀\u200D❡", .ascii = (const lxb_char_t *) "-.xn--1ug800aq795s", .status = 12} /* 4325 */,
    {.source = (const lxb_char_t *) "-。򕌀\u200D❡", .ascii = (const lxb_char_t *) "-.xn--1ug800aq795s", .status = 12} /* 4326 */,
    {.source = (const lxb_char_t *) "-.xn--nei54421f", .ascii = (const lxb_char_t *) "-.xn--nei54421f", .status = 8} /* 4327 */,
    {.source = (const lxb_char_t *) "-.xn--1ug800aq795s", .ascii = (const lxb_char_t *) "-.xn--1ug800aq795s", .status = 12} /* 4328 */,
    {.source = (const lxb_char_t *) "𝟓☱𝟐򥰵｡𝪮񐡳", .ascii = (const lxb_char_t *) "xn--52-dwx47758j.xn--kd3hk431k", .status = 8} /* 4329 */,
    {.source = (const lxb_char_t *) "5☱2򥰵。𝪮񐡳", .ascii = (const lxb_char_t *) "xn--52-dwx47758j.xn--kd3hk431k", .status = 8} /* 4330 */,
    {.source = (const lxb_char_t *) "xn--52-dwx47758j.xn--kd3hk431k", .ascii = (const lxb_char_t *) "xn--52-dwx47758j.xn--kd3hk431k", .status = 8} /* 4331 */,
    {.source = (const lxb_char_t *) "-.-├򖦣", .ascii = (const lxb_char_t *) "-.xn----ukp70432h", .status = 8} /* 4332 */,
    {.source = (const lxb_char_t *) "-.xn----ukp70432h", .ascii = (const lxb_char_t *) "-.xn----ukp70432h", .status = 8} /* 4333 */,
    {.source = (const lxb_char_t *) "\u05A5\u076D｡\u200D󠀘", .ascii = (const lxb_char_t *) "xn--wcb62g.xn--1ugy8001l", .status = 16} /* 4334 */,
    {.source = (const lxb_char_t *) "\u05A5\u076D。\u200D󠀘", .ascii = (const lxb_char_t *) "xn--wcb62g.xn--1ugy8001l", .status = 16} /* 4335 */,
    {.source = (const lxb_char_t *) "xn--wcb62g.xn--p526e", .ascii = (const lxb_char_t *) "xn--wcb62g.xn--p526e", .status = 12} /* 4336 */,
    {.source = (const lxb_char_t *) "xn--wcb62g.xn--1ugy8001l", .ascii = (const lxb_char_t *) "xn--wcb62g.xn--1ugy8001l", .status = 16} /* 4337 */,
    {.source = (const lxb_char_t *) "쥥󔏉Ⴎ．\u200C⒈⒈𐫒", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--0ug88oa0396u", .status = 12} /* 4338 */,
    {.source = (const lxb_char_t *) "쥥󔏉Ⴎ．\u200C⒈⒈𐫒", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--0ug88oa0396u", .status = 12} /* 4339 */,
    {.source = (const lxb_char_t *) "쥥󔏉Ⴎ.\u200C1.1.𐫒", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c", .status = 12} /* 4340 */,
    {.source = (const lxb_char_t *) "쥥󔏉Ⴎ.\u200C1.1.𐫒", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c", .status = 12} /* 4341 */,
    {.source = (const lxb_char_t *) "쥥󔏉ⴎ.\u200C1.1.𐫒", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c", .status = 12} /* 4342 */,
    {.source = (const lxb_char_t *) "쥥󔏉ⴎ.\u200C1.1.𐫒", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c", .status = 12} /* 4343 */,
    {.source = (const lxb_char_t *) "xn--5kj3511ccyw3h.1.1.xn--7w9c", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.1.1.xn--7w9c", .status = 8} /* 4344 */,
    {.source = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--1-rgn.1.xn--7w9c", .status = 12} /* 4345 */,
    {.source = (const lxb_char_t *) "xn--mnd7865gcy28g.1.1.xn--7w9c", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.1.1.xn--7w9c", .status = 8} /* 4346 */,
    {.source = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--1-rgn.1.xn--7w9c", .status = 12} /* 4347 */,
    {.source = (const lxb_char_t *) "쥥󔏉ⴎ．\u200C⒈⒈𐫒", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--0ug88oa0396u", .status = 12} /* 4348 */,
    {.source = (const lxb_char_t *) "쥥󔏉ⴎ．\u200C⒈⒈𐫒", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--0ug88oa0396u", .status = 12} /* 4349 */,
    {.source = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--tsha6797o", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--tsha6797o", .status = 8} /* 4350 */,
    {.source = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--0ug88oa0396u", .ascii = (const lxb_char_t *) "xn--5kj3511ccyw3h.xn--0ug88oa0396u", .status = 12} /* 4351 */,
    {.source = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--tsha6797o", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--tsha6797o", .status = 8} /* 4352 */,
    {.source = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--0ug88oa0396u", .ascii = (const lxb_char_t *) "xn--mnd7865gcy28g.xn--0ug88oa0396u", .status = 12} /* 4353 */,
    {.source = (const lxb_char_t *) "\u0827𝟶\u06A0-。𑄳", .ascii = (const lxb_char_t *) "xn--0--p3d67m.xn--v80d", .status = 12} /* 4354 */,
    {.source = (const lxb_char_t *) "\u08270\u06A0-。𑄳", .ascii = (const lxb_char_t *) "xn--0--p3d67m.xn--v80d", .status = 12} /* 4355 */,
    {.source = (const lxb_char_t *) "xn--0--p3d67m.xn--v80d", .ascii = (const lxb_char_t *) "xn--0--p3d67m.xn--v80d", .status = 12} /* 4356 */,
    {.source = (const lxb_char_t *) "ς．\uFDC1🞛⒈", .ascii = (const lxb_char_t *) "xn--3xa.xn--dhbip2802atb20c", .status = 4} /* 4357 */,
    {.source = (const lxb_char_t *) "ς.\u0641\u0645\u064A🞛1.", .ascii = (const lxb_char_t *) "xn--3xa.xn--1-gocmu97674d.", .status = 0} /* 4358 */,
    {.source = (const lxb_char_t *) "Σ.\u0641\u0645\u064A🞛1.", .ascii = (const lxb_char_t *) "xn--4xa.xn--1-gocmu97674d.", .status = 0} /* 4359 */,
    {.source = (const lxb_char_t *) "σ.\u0641\u0645\u064A🞛1.", .ascii = (const lxb_char_t *) "xn--4xa.xn--1-gocmu97674d.", .status = 0} /* 4360 */,
    {.source = (const lxb_char_t *) "xn--4xa.xn--1-gocmu97674d.", .ascii = (const lxb_char_t *) "xn--4xa.xn--1-gocmu97674d.", .status = 0} /* 4361 */,
    {.source = (const lxb_char_t *) "xn--3xa.xn--1-gocmu97674d.", .ascii = (const lxb_char_t *) "xn--3xa.xn--1-gocmu97674d.", .status = 0} /* 4362 */,
    {.source = (const lxb_char_t *) "Σ．\uFDC1🞛⒈", .ascii = (const lxb_char_t *) "xn--4xa.xn--dhbip2802atb20c", .status = 4} /* 4363 */,
    {.source = (const lxb_char_t *) "σ．\uFDC1🞛⒈", .ascii = (const lxb_char_t *) "xn--4xa.xn--dhbip2802atb20c", .status = 4} /* 4364 */,
    {.source = (const lxb_char_t *) "xn--4xa.xn--dhbip2802atb20c", .ascii = (const lxb_char_t *) "xn--4xa.xn--dhbip2802atb20c", .status = 4} /* 4365 */,
    {.source = (const lxb_char_t *) "xn--3xa.xn--dhbip2802atb20c", .ascii = (const lxb_char_t *) "xn--3xa.xn--dhbip2802atb20c", .status = 4} /* 4366 */,
    {.source = (const lxb_char_t *) "🗩-｡𐹻󐞆񥉮", .ascii = (const lxb_char_t *) "xn----6t3s.xn--zo0d4811u6ru6a", .status = 12} /* 4367 */,
    {.source = (const lxb_char_t *) "🗩-。𐹻󐞆񥉮", .ascii = (const lxb_char_t *) "xn----6t3s.xn--zo0d4811u6ru6a", .status = 12} /* 4368 */,
    {.source = (const lxb_char_t *) "xn----6t3s.xn--zo0d4811u6ru6a", .ascii = (const lxb_char_t *) "xn----6t3s.xn--zo0d4811u6ru6a", .status = 12} /* 4369 */,
    {.source = (const lxb_char_t *) "𐡜-🔪｡𝟻\u200C𐿀", .ascii = (const lxb_char_t *) "xn----5j4iv089c.xn--5-sgn7149h", .status = 12} /* 4370 */,
    {.source = (const lxb_char_t *) "𐡜-🔪。5\u200C𐿀", .ascii = (const lxb_char_t *) "xn----5j4iv089c.xn--5-sgn7149h", .status = 12} /* 4371 */,
    {.source = (const lxb_char_t *) "xn----5j4iv089c.xn--5-bn7i", .ascii = (const lxb_char_t *) "xn----5j4iv089c.xn--5-bn7i", .status = 8} /* 4372 */,
    {.source = (const lxb_char_t *) "xn----5j4iv089c.xn--5-sgn7149h", .ascii = (const lxb_char_t *) "xn----5j4iv089c.xn--5-sgn7149h", .status = 12} /* 4373 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dß．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--zca770n5s4hev6c.xn--0-vgc50n", .status = 8} /* 4374 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dß．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--zca770n5s4hev6c.xn--0-vgc50n", .status = 8} /* 4375 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dß.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--zca770n5s4hev6c.xn--0-vgc50n", .status = 8} /* 4376 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dß.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--zca770n5s4hev6c.xn--0-vgc50n", .status = 8} /* 4377 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSS.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4378 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSS.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4379 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dss.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4380 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dss.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4381 */,
    {.source = (const lxb_char_t *) "xn--ss-i05i7041a.xn--0-vgc50n", .ascii = (const lxb_char_t *) "xn--ss-i05i7041a.xn--0-vgc50n", .status = 4} /* 4382 */,
    {.source = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4383 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSs.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4384 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSs.\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4385 */,
    {.source = (const lxb_char_t *) "xn--zca770n5s4hev6c.xn--0-vgc50n", .ascii = (const lxb_char_t *) "xn--zca770n5s4hev6c.xn--0-vgc50n", .status = 8} /* 4386 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSS．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4387 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSS．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4388 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dss．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4389 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200Dss．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4390 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSs．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4391 */,
    {.source = (const lxb_char_t *) "𐹣늿\u200DSs．\u07CF0\u05BC", .ascii = (const lxb_char_t *) "xn--ss-l1tu910fo0xd.xn--0-vgc50n", .status = 8} /* 4392 */,
    {.source = (const lxb_char_t *) "9󠇥．󪴴ᢓ", .ascii = (const lxb_char_t *) "9.xn--dbf91222q", .status = 4} /* 4393 */,
    {.source = (const lxb_char_t *) "9󠇥.󪴴ᢓ", .ascii = (const lxb_char_t *) "9.xn--dbf91222q", .status = 4} /* 4394 */,
    {.source = (const lxb_char_t *) "9.xn--dbf91222q", .ascii = (const lxb_char_t *) "9.xn--dbf91222q", .status = 4} /* 4395 */,
    {.source = (const lxb_char_t *) "\u200C\uFFA0.𐫭🠗ß⽟", .ascii = (const lxb_char_t *) "xn--0ug7719f.xn--zca2289c550e0iwi", .status = 20} /* 4396 */,
    {.source = (const lxb_char_t *) "\u200C\u1160.𐫭🠗ß玉", .ascii = (const lxb_char_t *) "xn--psd526e.xn--zca2289c550e0iwi", .status = 20} /* 4397 */,
    {.source = (const lxb_char_t *) "\u200C\u1160.𐫭🠗SS玉", .ascii = (const lxb_char_t *) "xn--psd526e.xn--ss-je6eq954cp25j", .status = 20} /* 4398 */,
    {.source = (const lxb_char_t *) "\u200C\u1160.𐫭🠗ss玉", .ascii = (const lxb_char_t *) "xn--psd526e.xn--ss-je6eq954cp25j", .status = 20} /* 4399 */,
    {.source = (const lxb_char_t *) "\u200C\u1160.𐫭🠗Ss玉", .ascii = (const lxb_char_t *) "xn--psd526e.xn--ss-je6eq954cp25j", .status = 20} /* 4400 */,
    {.source = (const lxb_char_t *) "xn--psd.xn--ss-je6eq954cp25j", .ascii = (const lxb_char_t *) "xn--psd.xn--ss-je6eq954cp25j", .status = 12} /* 4401 */,
    {.source = (const lxb_char_t *) "xn--psd526e.xn--ss-je6eq954cp25j", .ascii = (const lxb_char_t *) "xn--psd526e.xn--ss-je6eq954cp25j", .status = 20} /* 4402 */,
    {.source = (const lxb_char_t *) "xn--psd526e.xn--zca2289c550e0iwi", .ascii = (const lxb_char_t *) "xn--psd526e.xn--zca2289c550e0iwi", .status = 20} /* 4403 */,
    {.source = (const lxb_char_t *) "\u200C\uFFA0.𐫭🠗SS⽟", .ascii = (const lxb_char_t *) "xn--0ug7719f.xn--ss-je6eq954cp25j", .status = 20} /* 4404 */,
    {.source = (const lxb_char_t *) "\u200C\uFFA0.𐫭🠗ss⽟", .ascii = (const lxb_char_t *) "xn--0ug7719f.xn--ss-je6eq954cp25j", .status = 20} /* 4405 */,
    {.source = (const lxb_char_t *) "\u200C\uFFA0.𐫭🠗Ss⽟", .ascii = (const lxb_char_t *) "xn--0ug7719f.xn--ss-je6eq954cp25j", .status = 20} /* 4406 */,
    {.source = (const lxb_char_t *) "xn--cl7c.xn--ss-je6eq954cp25j", .ascii = (const lxb_char_t *) "xn--cl7c.xn--ss-je6eq954cp25j", .status = 12} /* 4407 */,
    {.source = (const lxb_char_t *) "xn--0ug7719f.xn--ss-je6eq954cp25j", .ascii = (const lxb_char_t *) "xn--0ug7719f.xn--ss-je6eq954cp25j", .status = 20} /* 4408 */,
    {.source = (const lxb_char_t *) "xn--0ug7719f.xn--zca2289c550e0iwi", .ascii = (const lxb_char_t *) "xn--0ug7719f.xn--zca2289c550e0iwi", .status = 20} /* 4409 */,
    {.source = (const lxb_char_t *) "︒Ⴖ\u0366．\u200C", .ascii = (const lxb_char_t *) "xn--hva929dl29p.xn--0ug", .status = 8} /* 4410 */,
    {.source = (const lxb_char_t *) "。Ⴖ\u0366.\u200C", .ascii = (const lxb_char_t *) ".xn--hva929d.xn--0ug", .status = 14} /* 4411 */,
    {.source = (const lxb_char_t *) "。ⴖ\u0366.\u200C", .ascii = (const lxb_char_t *) ".xn--hva754s.xn--0ug", .status = 10} /* 4412 */,
    {.source = (const lxb_char_t *) ".xn--hva754s.", .ascii = (const lxb_char_t *) ".xn--hva754s.", .status = 6} /* 4413 */,
    {.source = (const lxb_char_t *) ".xn--hva754s.xn--0ug", .ascii = (const lxb_char_t *) ".xn--hva754s.xn--0ug", .status = 10} /* 4414 */,
    {.source = (const lxb_char_t *) ".xn--hva929d.", .ascii = (const lxb_char_t *) ".xn--hva929d.", .status = 10} /* 4415 */,
    {.source = (const lxb_char_t *) ".xn--hva929d.xn--0ug", .ascii = (const lxb_char_t *) ".xn--hva929d.xn--0ug", .status = 14} /* 4416 */,
    {.source = (const lxb_char_t *) "︒ⴖ\u0366．\u200C", .ascii = (const lxb_char_t *) "xn--hva754sy94k.xn--0ug", .status = 8} /* 4417 */,
    {.source = (const lxb_char_t *) "xn--hva754sy94k.", .ascii = (const lxb_char_t *) "xn--hva754sy94k.", .status = 4} /* 4418 */,
    {.source = (const lxb_char_t *) "xn--hva754sy94k.xn--0ug", .ascii = (const lxb_char_t *) "xn--hva754sy94k.xn--0ug", .status = 8} /* 4419 */,
    {.source = (const lxb_char_t *) "xn--hva929dl29p.", .ascii = (const lxb_char_t *) "xn--hva929dl29p.", .status = 4} /* 4420 */,
    {.source = (const lxb_char_t *) "xn--hva929dl29p.xn--0ug", .ascii = (const lxb_char_t *) "xn--hva929dl29p.xn--0ug", .status = 8} /* 4421 */,
    {.source = (const lxb_char_t *) "xn--hva754s.", .ascii = (const lxb_char_t *) "xn--hva754s.", .status = 0} /* 4422 */,
    {.source = (const lxb_char_t *) "ⴖ\u0366.", .ascii = (const lxb_char_t *) "xn--hva754s.", .status = 0} /* 4423 */,
    {.source = (const lxb_char_t *) "Ⴖ\u0366.", .ascii = (const lxb_char_t *) "xn--hva929d.", .status = 4} /* 4424 */,
    {.source = (const lxb_char_t *) "xn--hva929d.", .ascii = (const lxb_char_t *) "xn--hva929d.", .status = 4} /* 4425 */,
    {.source = (const lxb_char_t *) "\u08BB．\u200CႣ𞀒", .ascii = (const lxb_char_t *) "xn--hzb.xn--bnd300f7225a", .status = 12} /* 4426 */,
    {.source = (const lxb_char_t *) "\u08BB.\u200CႣ𞀒", .ascii = (const lxb_char_t *) "xn--hzb.xn--bnd300f7225a", .status = 12} /* 4427 */,
    {.source = (const lxb_char_t *) "\u08BB.\u200Cⴃ𞀒", .ascii = (const lxb_char_t *) "xn--hzb.xn--0ug822cp045a", .status = 8} /* 4428 */,
    {.source = (const lxb_char_t *) "xn--hzb.xn--ukj4430l", .ascii = (const lxb_char_t *) "xn--hzb.xn--ukj4430l", .status = 0} /* 4429 */,
    {.source = (const lxb_char_t *) "\u08BB.ⴃ𞀒", .ascii = (const lxb_char_t *) "xn--hzb.xn--ukj4430l", .status = 0} /* 4430 */,
    {.source = (const lxb_char_t *) "\u08BB.Ⴃ𞀒", .ascii = (const lxb_char_t *) "xn--hzb.xn--bnd2938u", .status = 4} /* 4431 */,
    {.source = (const lxb_char_t *) "xn--hzb.xn--bnd2938u", .ascii = (const lxb_char_t *) "xn--hzb.xn--bnd2938u", .status = 4} /* 4432 */,
    {.source = (const lxb_char_t *) "xn--hzb.xn--0ug822cp045a", .ascii = (const lxb_char_t *) "xn--hzb.xn--0ug822cp045a", .status = 8} /* 4433 */,
    {.source = (const lxb_char_t *) "xn--hzb.xn--bnd300f7225a", .ascii = (const lxb_char_t *) "xn--hzb.xn--bnd300f7225a", .status = 12} /* 4434 */,
    {.source = (const lxb_char_t *) "\u08BB．\u200Cⴃ𞀒", .ascii = (const lxb_char_t *) "xn--hzb.xn--0ug822cp045a", .status = 8} /* 4435 */,
    {.source = (const lxb_char_t *) "\u200D\u200C。２䫷󠧷", .ascii = (const lxb_char_t *) "xn--0ugb.xn--2-me5ay1273i", .status = 12} /* 4436 */,
    {.source = (const lxb_char_t *) "\u200D\u200C。2䫷󠧷", .ascii = (const lxb_char_t *) "xn--0ugb.xn--2-me5ay1273i", .status = 12} /* 4437 */,
    {.source = (const lxb_char_t *) ".xn--2-me5ay1273i", .ascii = (const lxb_char_t *) ".xn--2-me5ay1273i", .status = 10} /* 4438 */,
    {.source = (const lxb_char_t *) "xn--0ugb.xn--2-me5ay1273i", .ascii = (const lxb_char_t *) "xn--0ugb.xn--2-me5ay1273i", .status = 12} /* 4439 */,
    {.source = (const lxb_char_t *) "-𞀤󜠐。򈬖", .ascii = (const lxb_char_t *) "xn----rq4re4997d.xn--l707b", .status = 8} /* 4440 */,
    {.source = (const lxb_char_t *) "xn----rq4re4997d.xn--l707b", .ascii = (const lxb_char_t *) "xn----rq4re4997d.xn--l707b", .status = 8} /* 4441 */,
    {.source = (const lxb_char_t *) "󳛂︒\u200C㟀．\u0624⒈", .ascii = (const lxb_char_t *) "xn--0ug754gxl4ldlt0k.xn--jgb476m", .status = 8} /* 4442 */,
    {.source = (const lxb_char_t *) "󳛂︒\u200C㟀．\u0648\u0654⒈", .ascii = (const lxb_char_t *) "xn--0ug754gxl4ldlt0k.xn--jgb476m", .status = 8} /* 4443 */,
    {.source = (const lxb_char_t *) "󳛂。\u200C㟀.\u06241.", .ascii = (const lxb_char_t *) "xn--z272f.xn--0ug754g.xn--1-smc.", .status = 12} /* 4444 */,
    {.source = (const lxb_char_t *) "󳛂。\u200C㟀.\u0648\u06541.", .ascii = (const lxb_char_t *) "xn--z272f.xn--0ug754g.xn--1-smc.", .status = 12} /* 4445 */,
    {.source = (const lxb_char_t *) "xn--z272f.xn--etl.xn--1-smc.", .ascii = (const lxb_char_t *) "xn--z272f.xn--etl.xn--1-smc.", .status = 4} /* 4446 */,
    {.source = (const lxb_char_t *) "xn--z272f.xn--0ug754g.xn--1-smc.", .ascii = (const lxb_char_t *) "xn--z272f.xn--0ug754g.xn--1-smc.", .status = 12} /* 4447 */,
    {.source = (const lxb_char_t *) "xn--etlt457ccrq7h.xn--jgb476m", .ascii = (const lxb_char_t *) "xn--etlt457ccrq7h.xn--jgb476m", .status = 4} /* 4448 */,
    {.source = (const lxb_char_t *) "xn--0ug754gxl4ldlt0k.xn--jgb476m", .ascii = (const lxb_char_t *) "xn--0ug754gxl4ldlt0k.xn--jgb476m", .status = 8} /* 4449 */,
    {.source = (const lxb_char_t *) "𑲜\u07CA𝅼。-\u200D", .ascii = (const lxb_char_t *) "xn--lsb5482l7nre.xn----ugn", .status = 16} /* 4450 */,
    {.source = (const lxb_char_t *) "xn--lsb5482l7nre.-", .ascii = (const lxb_char_t *) "xn--lsb5482l7nre.-", .status = 12} /* 4451 */,
    {.source = (const lxb_char_t *) "xn--lsb5482l7nre.xn----ugn", .ascii = (const lxb_char_t *) "xn--lsb5482l7nre.xn----ugn", .status = 16} /* 4452 */,
    {.source = (const lxb_char_t *) "\u200C．Ⴉ≠𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--hnd481gv73o", .status = 20} /* 4453 */,
    {.source = (const lxb_char_t *) "\u200C．Ⴉ=\u0338𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--hnd481gv73o", .status = 20} /* 4454 */,
    {.source = (const lxb_char_t *) "\u200C.Ⴉ≠𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--hnd481gv73o", .status = 20} /* 4455 */,
    {.source = (const lxb_char_t *) "\u200C.Ⴉ=\u0338𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--hnd481gv73o", .status = 20} /* 4456 */,
    {.source = (const lxb_char_t *) "\u200C.ⴉ=\u0338𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--1chx23bzj4p", .status = 16} /* 4457 */,
    {.source = (const lxb_char_t *) "\u200C.ⴉ≠𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--1chx23bzj4p", .status = 16} /* 4458 */,
    {.source = (const lxb_char_t *) ".xn--1chx23bzj4p", .ascii = (const lxb_char_t *) ".xn--1chx23bzj4p", .status = 14} /* 4459 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--1chx23bzj4p", .ascii = (const lxb_char_t *) "xn--0ug.xn--1chx23bzj4p", .status = 16} /* 4460 */,
    {.source = (const lxb_char_t *) ".xn--hnd481gv73o", .ascii = (const lxb_char_t *) ".xn--hnd481gv73o", .status = 18} /* 4461 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--hnd481gv73o", .ascii = (const lxb_char_t *) "xn--0ug.xn--hnd481gv73o", .status = 20} /* 4462 */,
    {.source = (const lxb_char_t *) "\u200C．ⴉ=\u0338𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--1chx23bzj4p", .status = 16} /* 4463 */,
    {.source = (const lxb_char_t *) "\u200C．ⴉ≠𐫶", .ascii = (const lxb_char_t *) "xn--0ug.xn--1chx23bzj4p", .status = 16} /* 4464 */,
    {.source = (const lxb_char_t *) "\u0750。≯ς", .ascii = (const lxb_char_t *) "xn--3ob.xn--3xa918m", .status = 4} /* 4465 */,
    {.source = (const lxb_char_t *) "\u0750。>\u0338ς", .ascii = (const lxb_char_t *) "xn--3ob.xn--3xa918m", .status = 4} /* 4466 */,
    {.source = (const lxb_char_t *) "\u0750。>\u0338Σ", .ascii = (const lxb_char_t *) "xn--3ob.xn--4xa718m", .status = 4} /* 4467 */,
    {.source = (const lxb_char_t *) "\u0750。≯Σ", .ascii = (const lxb_char_t *) "xn--3ob.xn--4xa718m", .status = 4} /* 4468 */,
    {.source = (const lxb_char_t *) "\u0750。≯σ", .ascii = (const lxb_char_t *) "xn--3ob.xn--4xa718m", .status = 4} /* 4469 */,
    {.source = (const lxb_char_t *) "\u0750。>\u0338σ", .ascii = (const lxb_char_t *) "xn--3ob.xn--4xa718m", .status = 4} /* 4470 */,
    {.source = (const lxb_char_t *) "xn--3ob.xn--4xa718m", .ascii = (const lxb_char_t *) "xn--3ob.xn--4xa718m", .status = 4} /* 4471 */,
    {.source = (const lxb_char_t *) "xn--3ob.xn--3xa918m", .ascii = (const lxb_char_t *) "xn--3ob.xn--3xa918m", .status = 4} /* 4472 */,
    {.source = (const lxb_char_t *) "\u07FC𐸆.𓖏︒񊨩Ⴐ", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--ond3562jt18a7py9c", .status = 4} /* 4473 */,
    {.source = (const lxb_char_t *) "\u07FC𐸆.𓖏。񊨩Ⴐ", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--tu8d.xn--ond97931d", .status = 4} /* 4474 */,
    {.source = (const lxb_char_t *) "\u07FC𐸆.𓖏。񊨩ⴐ", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--tu8d.xn--7kj73887a", .status = 4} /* 4475 */,
    {.source = (const lxb_char_t *) "xn--0tb8725k.xn--tu8d.xn--7kj73887a", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--tu8d.xn--7kj73887a", .status = 4} /* 4476 */,
    {.source = (const lxb_char_t *) "xn--0tb8725k.xn--tu8d.xn--ond97931d", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--tu8d.xn--ond97931d", .status = 4} /* 4477 */,
    {.source = (const lxb_char_t *) "\u07FC𐸆.𓖏︒񊨩ⴐ", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--7kj9008dt18a7py9c", .status = 4} /* 4478 */,
    {.source = (const lxb_char_t *) "xn--0tb8725k.xn--7kj9008dt18a7py9c", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--7kj9008dt18a7py9c", .status = 4} /* 4479 */,
    {.source = (const lxb_char_t *) "xn--0tb8725k.xn--ond3562jt18a7py9c", .ascii = (const lxb_char_t *) "xn--0tb8725k.xn--ond3562jt18a7py9c", .status = 4} /* 4480 */,
    {.source = (const lxb_char_t *) "Ⴥ⚭󠖫⋃｡𑌼", .ascii = (const lxb_char_t *) "xn--9nd623g4zc5z060c.xn--ro1d", .status = 8} /* 4481 */,
    {.source = (const lxb_char_t *) "Ⴥ⚭󠖫⋃。𑌼", .ascii = (const lxb_char_t *) "xn--9nd623g4zc5z060c.xn--ro1d", .status = 8} /* 4482 */,
    {.source = (const lxb_char_t *) "ⴥ⚭󠖫⋃。𑌼", .ascii = (const lxb_char_t *) "xn--vfh16m67gx1162b.xn--ro1d", .status = 8} /* 4483 */,
    {.source = (const lxb_char_t *) "xn--vfh16m67gx1162b.xn--ro1d", .ascii = (const lxb_char_t *) "xn--vfh16m67gx1162b.xn--ro1d", .status = 8} /* 4484 */,
    {.source = (const lxb_char_t *) "xn--9nd623g4zc5z060c.xn--ro1d", .ascii = (const lxb_char_t *) "xn--9nd623g4zc5z060c.xn--ro1d", .status = 8} /* 4485 */,
    {.source = (const lxb_char_t *) "ⴥ⚭󠖫⋃｡𑌼", .ascii = (const lxb_char_t *) "xn--vfh16m67gx1162b.xn--ro1d", .status = 8} /* 4486 */,
    {.source = (const lxb_char_t *) "🄈。󠷳\u0844", .ascii = (const lxb_char_t *) "xn--107h.xn--2vb13094p", .status = 8} /* 4487 */,
    {.source = (const lxb_char_t *) "7,。󠷳\u0844", .ascii = (const lxb_char_t *) "7,.xn--2vb13094p", .status = 8} /* 4488 */,
    {.source = (const lxb_char_t *) "7,.xn--2vb13094p", .ascii = (const lxb_char_t *) "7,.xn--2vb13094p", .status = 8} /* 4489 */,
    {.source = (const lxb_char_t *) "xn--107h.xn--2vb13094p", .ascii = (const lxb_char_t *) "xn--107h.xn--2vb13094p", .status = 8} /* 4490 */,
    {.source = (const lxb_char_t *) "≮\u0846。섖쮖ß", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--zca7259goug", .status = 4} /* 4491 */,
    {.source = (const lxb_char_t *) "<\u0338\u0846。섖쮖ß", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--zca7259goug", .status = 4} /* 4492 */,
    {.source = (const lxb_char_t *) "<\u0338\u0846。섖쮖SS", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4493 */,
    {.source = (const lxb_char_t *) "≮\u0846。섖쮖SS", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4494 */,
    {.source = (const lxb_char_t *) "≮\u0846。섖쮖ss", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4495 */,
    {.source = (const lxb_char_t *) "<\u0338\u0846。섖쮖ss", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4496 */,
    {.source = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4497 */,
    {.source = (const lxb_char_t *) "≮\u0846。섖쮖Ss", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4498 */,
    {.source = (const lxb_char_t *) "<\u0338\u0846。섖쮖Ss", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--ss-5z4j006a", .status = 4} /* 4499 */,
    {.source = (const lxb_char_t *) "xn--4vb505k.xn--zca7259goug", .ascii = (const lxb_char_t *) "xn--4vb505k.xn--zca7259goug", .status = 4} /* 4500 */,
    {.source = (const lxb_char_t *) "󠆓⛏-。ꡒ", .ascii = (const lxb_char_t *) "xn----o9p.xn--rc9a", .status = 4} /* 4501 */,
    {.source = (const lxb_char_t *) "xn----o9p.xn--rc9a", .ascii = (const lxb_char_t *) "xn----o9p.xn--rc9a", .status = 4} /* 4502 */,
    {.source = (const lxb_char_t *) "\u07BB𐹳\u0626𑁆。\u08A7\u06B0\u200Cᢒ", .ascii = (const lxb_char_t *) "xn--lgb32f2753cosb.xn--jkb91hlz1azih", .status = 12} /* 4503 */,
    {.source = (const lxb_char_t *) "\u07BB𐹳\u064A𑁆\u0654。\u08A7\u06B0\u200Cᢒ", .ascii = (const lxb_char_t *) "xn--lgb32f2753cosb.xn--jkb91hlz1azih", .status = 12} /* 4504 */,
    {.source = (const lxb_char_t *) "xn--lgb32f2753cosb.xn--jkb91hlz1a", .ascii = (const lxb_char_t *) "xn--lgb32f2753cosb.xn--jkb91hlz1a", .status = 12} /* 4505 */,
    {.source = (const lxb_char_t *) "xn--lgb32f2753cosb.xn--jkb91hlz1azih", .ascii = (const lxb_char_t *) "xn--lgb32f2753cosb.xn--jkb91hlz1azih", .status = 12} /* 4506 */,
    {.source = (const lxb_char_t *) "\u0816.𐨕𚚕", .ascii = (const lxb_char_t *) "xn--rub.xn--tr9c248x", .status = 20} /* 4507 */,
    {.source = (const lxb_char_t *) "xn--rub.xn--tr9c248x", .ascii = (const lxb_char_t *) "xn--rub.xn--tr9c248x", .status = 20} /* 4508 */,
    {.source = (const lxb_char_t *) "--。𽊆\u0767𐽋𞠬", .ascii = (const lxb_char_t *) "--.xn--rpb6226k77pfh58p", .status = 20} /* 4509 */,
    {.source = (const lxb_char_t *) "--.xn--rpb6226k77pfh58p", .ascii = (const lxb_char_t *) "--.xn--rpb6226k77pfh58p", .status = 20} /* 4510 */,
    {.source = (const lxb_char_t *) "򛭦𐋥𹸐.≯\u08B0\u08A6󔛣", .ascii = (const lxb_char_t *) "xn--887c2298i5mv6a.xn--vybt688qm8981a", .status = 8} /* 4511 */,
    {.source = (const lxb_char_t *) "򛭦𐋥𹸐.>\u0338\u08B0\u08A6󔛣", .ascii = (const lxb_char_t *) "xn--887c2298i5mv6a.xn--vybt688qm8981a", .status = 8} /* 4512 */,
    {.source = (const lxb_char_t *) "xn--887c2298i5mv6a.xn--vybt688qm8981a", .ascii = (const lxb_char_t *) "xn--887c2298i5mv6a.xn--vybt688qm8981a", .status = 8} /* 4513 */,
    {.source = (const lxb_char_t *) "䔛󠇒򤸞𐹧．-䤷", .ascii = (const lxb_char_t *) "xn--2loy662coo60e.xn----0n4a", .status = 20} /* 4514 */,
    {.source = (const lxb_char_t *) "䔛󠇒򤸞𐹧.-䤷", .ascii = (const lxb_char_t *) "xn--2loy662coo60e.xn----0n4a", .status = 20} /* 4515 */,
    {.source = (const lxb_char_t *) "xn--2loy662coo60e.xn----0n4a", .ascii = (const lxb_char_t *) "xn--2loy662coo60e.xn----0n4a", .status = 20} /* 4516 */,
    {.source = (const lxb_char_t *) "𐹩．\u200D-", .ascii = (const lxb_char_t *) "xn--ho0d.xn----tgn", .status = 12} /* 4517 */,
    {.source = (const lxb_char_t *) "𐹩.\u200D-", .ascii = (const lxb_char_t *) "xn--ho0d.xn----tgn", .status = 12} /* 4518 */,
    {.source = (const lxb_char_t *) "xn--ho0d.-", .ascii = (const lxb_char_t *) "xn--ho0d.-", .status = 8} /* 4519 */,
    {.source = (const lxb_char_t *) "xn--ho0d.xn----tgn", .ascii = (const lxb_char_t *) "xn--ho0d.xn----tgn", .status = 12} /* 4520 */,
    {.source = (const lxb_char_t *) "񂈦帷｡≯萺\u1DC8-", .ascii = (const lxb_char_t *) "xn--qutw175s.xn----mimu6tf67j", .status = 8} /* 4521 */,
    {.source = (const lxb_char_t *) "񂈦帷｡>\u0338萺\u1DC8-", .ascii = (const lxb_char_t *) "xn--qutw175s.xn----mimu6tf67j", .status = 8} /* 4522 */,
    {.source = (const lxb_char_t *) "񂈦帷。≯萺\u1DC8-", .ascii = (const lxb_char_t *) "xn--qutw175s.xn----mimu6tf67j", .status = 8} /* 4523 */,
    {.source = (const lxb_char_t *) "񂈦帷。>\u0338萺\u1DC8-", .ascii = (const lxb_char_t *) "xn--qutw175s.xn----mimu6tf67j", .status = 8} /* 4524 */,
    {.source = (const lxb_char_t *) "xn--qutw175s.xn----mimu6tf67j", .ascii = (const lxb_char_t *) "xn--qutw175s.xn----mimu6tf67j", .status = 8} /* 4525 */,
    {.source = (const lxb_char_t *) "\u200D攌\uABED。ᢖ-Ⴘ", .ascii = (const lxb_char_t *) "xn--1ug592ykp6b.xn----k1g451d", .status = 8} /* 4526 */,
    {.source = (const lxb_char_t *) "\u200D攌\uABED。ᢖ-ⴘ", .ascii = (const lxb_char_t *) "xn--1ug592ykp6b.xn----mck373i", .status = 4} /* 4527 */,
    {.source = (const lxb_char_t *) "xn--p9ut19m.xn----mck373i", .ascii = (const lxb_char_t *) "xn--p9ut19m.xn----mck373i", .status = 0} /* 4528 */,
    {.source = (const lxb_char_t *) "攌\uABED.ᢖ-ⴘ", .ascii = (const lxb_char_t *) "xn--p9ut19m.xn----mck373i", .status = 0} /* 4529 */,
    {.source = (const lxb_char_t *) "攌\uABED.ᢖ-Ⴘ", .ascii = (const lxb_char_t *) "xn--p9ut19m.xn----k1g451d", .status = 4} /* 4530 */,
    {.source = (const lxb_char_t *) "xn--p9ut19m.xn----k1g451d", .ascii = (const lxb_char_t *) "xn--p9ut19m.xn----k1g451d", .status = 4} /* 4531 */,
    {.source = (const lxb_char_t *) "xn--1ug592ykp6b.xn----mck373i", .ascii = (const lxb_char_t *) "xn--1ug592ykp6b.xn----mck373i", .status = 4} /* 4532 */,
    {.source = (const lxb_char_t *) "xn--1ug592ykp6b.xn----k1g451d", .ascii = (const lxb_char_t *) "xn--1ug592ykp6b.xn----k1g451d", .status = 8} /* 4533 */,
    {.source = (const lxb_char_t *) "\u200Cꖨ．⒗３툒۳", .ascii = (const lxb_char_t *) "xn--0ug2473c.xn--3-nyc678tu07m", .status = 8} /* 4534 */,
    {.source = (const lxb_char_t *) "\u200Cꖨ．⒗３툒۳", .ascii = (const lxb_char_t *) "xn--0ug2473c.xn--3-nyc678tu07m", .status = 8} /* 4535 */,
    {.source = (const lxb_char_t *) "\u200Cꖨ.16.3툒۳", .ascii = (const lxb_char_t *) "xn--0ug2473c.16.xn--3-nyc0117m", .status = 4} /* 4536 */,
    {.source = (const lxb_char_t *) "\u200Cꖨ.16.3툒۳", .ascii = (const lxb_char_t *) "xn--0ug2473c.16.xn--3-nyc0117m", .status = 4} /* 4537 */,
    {.source = (const lxb_char_t *) "xn--9r8a.16.xn--3-nyc0117m", .ascii = (const lxb_char_t *) "xn--9r8a.16.xn--3-nyc0117m", .status = 0} /* 4538 */,
    {.source = (const lxb_char_t *) "ꖨ.16.3툒۳", .ascii = (const lxb_char_t *) "xn--9r8a.16.xn--3-nyc0117m", .status = 0} /* 4539 */,
    {.source = (const lxb_char_t *) "ꖨ.16.3툒۳", .ascii = (const lxb_char_t *) "xn--9r8a.16.xn--3-nyc0117m", .status = 0} /* 4540 */,
    {.source = (const lxb_char_t *) "xn--0ug2473c.16.xn--3-nyc0117m", .ascii = (const lxb_char_t *) "xn--0ug2473c.16.xn--3-nyc0117m", .status = 4} /* 4541 */,
    {.source = (const lxb_char_t *) "xn--9r8a.xn--3-nyc678tu07m", .ascii = (const lxb_char_t *) "xn--9r8a.xn--3-nyc678tu07m", .status = 4} /* 4542 */,
    {.source = (const lxb_char_t *) "xn--0ug2473c.xn--3-nyc678tu07m", .ascii = (const lxb_char_t *) "xn--0ug2473c.xn--3-nyc678tu07m", .status = 8} /* 4543 */,
    {.source = (const lxb_char_t *) "⒈걾6.𐱁\u06D0", .ascii = (const lxb_char_t *) "xn--6-dcps419c.xn--glb1794k", .status = 8} /* 4544 */,
    {.source = (const lxb_char_t *) "⒈걾6.𐱁\u06D0", .ascii = (const lxb_char_t *) "xn--6-dcps419c.xn--glb1794k", .status = 8} /* 4545 */,
    {.source = (const lxb_char_t *) "1.걾6.𐱁\u06D0", .ascii = (const lxb_char_t *) "1.xn--6-945e.xn--glb1794k", .status = 4} /* 4546 */,
    {.source = (const lxb_char_t *) "1.걾6.𐱁\u06D0", .ascii = (const lxb_char_t *) "1.xn--6-945e.xn--glb1794k", .status = 4} /* 4547 */,
    {.source = (const lxb_char_t *) "1.xn--6-945e.xn--glb1794k", .ascii = (const lxb_char_t *) "1.xn--6-945e.xn--glb1794k", .status = 4} /* 4548 */,
    {.source = (const lxb_char_t *) "xn--6-dcps419c.xn--glb1794k", .ascii = (const lxb_char_t *) "xn--6-dcps419c.xn--glb1794k", .status = 8} /* 4549 */,
    {.source = (const lxb_char_t *) "𐲞𝟶≮≮.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4550 */,
    {.source = (const lxb_char_t *) "𐲞𝟶<\u0338<\u0338.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4551 */,
    {.source = (const lxb_char_t *) "𐲞0≮≮.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4552 */,
    {.source = (const lxb_char_t *) "𐲞0<\u0338<\u0338.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4553 */,
    {.source = (const lxb_char_t *) "𐳞0<\u0338<\u0338.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4554 */,
    {.source = (const lxb_char_t *) "𐳞0≮≮.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4555 */,
    {.source = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4556 */,
    {.source = (const lxb_char_t *) "𐳞𝟶<\u0338<\u0338.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4557 */,
    {.source = (const lxb_char_t *) "𐳞𝟶≮≮.󠀧\u0639", .ascii = (const lxb_char_t *) "xn--0-ngoa5711v.xn--4gb31034p", .status = 12} /* 4558 */,
    {.source = (const lxb_char_t *) "\u0AE3.𐹺\u115F", .ascii = (const lxb_char_t *) "xn--8fc.xn--osd3070k", .status = 12} /* 4559 */,
    {.source = (const lxb_char_t *) "xn--8fc.xn--osd3070k", .ascii = (const lxb_char_t *) "xn--8fc.xn--osd3070k", .status = 12} /* 4560 */,
    {.source = (const lxb_char_t *) "𝟏𝨙⸖.\u200D", .ascii = (const lxb_char_t *) "xn--1-5bt6845n.xn--1ug", .status = 4} /* 4561 */,
    {.source = (const lxb_char_t *) "1𝨙⸖.\u200D", .ascii = (const lxb_char_t *) "xn--1-5bt6845n.xn--1ug", .status = 4} /* 4562 */,
    {.source = (const lxb_char_t *) "xn--1-5bt6845n.", .ascii = (const lxb_char_t *) "xn--1-5bt6845n.", .status = 0} /* 4563 */,
    {.source = (const lxb_char_t *) "1𝨙⸖.", .ascii = (const lxb_char_t *) "xn--1-5bt6845n.", .status = 0} /* 4564 */,
    {.source = (const lxb_char_t *) "xn--1-5bt6845n.xn--1ug", .ascii = (const lxb_char_t *) "xn--1-5bt6845n.xn--1ug", .status = 4} /* 4565 */,
    {.source = (const lxb_char_t *) "𞤐≠\u0726\u1A60｡-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4566 */,
    {.source = (const lxb_char_t *) "𞤐=\u0338\u0726\u1A60｡-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4567 */,
    {.source = (const lxb_char_t *) "𞤐≠\u0726\u1A60。-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4568 */,
    {.source = (const lxb_char_t *) "𞤐=\u0338\u0726\u1A60。-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4569 */,
    {.source = (const lxb_char_t *) "𞤲=\u0338\u0726\u1A60。-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4570 */,
    {.source = (const lxb_char_t *) "𞤲≠\u0726\u1A60。-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4571 */,
    {.source = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd", .status = 8} /* 4572 */,
    {.source = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4573 */,
    {.source = (const lxb_char_t *) "𞤲=\u0338\u0726\u1A60｡-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4574 */,
    {.source = (const lxb_char_t *) "𞤲≠\u0726\u1A60｡-\u200C\u07D5", .ascii = (const lxb_char_t *) "xn--wnb859grzfzw60c.xn----kcd017p", .status = 12} /* 4575 */,
    {.source = (const lxb_char_t *) "𐹰\u0368-ꡧ｡\u0675", .ascii = (const lxb_char_t *) "xn----shb2387jgkqd.xn--mgb8m", .status = 4} /* 4576 */,
    {.source = (const lxb_char_t *) "𐹰\u0368-ꡧ。\u0627\u0674", .ascii = (const lxb_char_t *) "xn----shb2387jgkqd.xn--mgb8m", .status = 4} /* 4577 */,
    {.source = (const lxb_char_t *) "xn----shb2387jgkqd.xn--mgb8m", .ascii = (const lxb_char_t *) "xn----shb2387jgkqd.xn--mgb8m", .status = 4} /* 4578 */,
    {.source = (const lxb_char_t *) "F󠅟｡򏗅♚", .ascii = (const lxb_char_t *) "f.xn--45hz6953f", .status = 4} /* 4579 */,
    {.source = (const lxb_char_t *) "F󠅟。򏗅♚", .ascii = (const lxb_char_t *) "f.xn--45hz6953f", .status = 4} /* 4580 */,
    {.source = (const lxb_char_t *) "f󠅟。򏗅♚", .ascii = (const lxb_char_t *) "f.xn--45hz6953f", .status = 4} /* 4581 */,
    {.source = (const lxb_char_t *) "f.xn--45hz6953f", .ascii = (const lxb_char_t *) "f.xn--45hz6953f", .status = 4} /* 4582 */,
    {.source = (const lxb_char_t *) "f󠅟｡򏗅♚", .ascii = (const lxb_char_t *) "f.xn--45hz6953f", .status = 4} /* 4583 */,
    {.source = (const lxb_char_t *) "\u0B4D𑄴\u1DE9。𝟮Ⴘ𞀨񃥇", .ascii = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-k1g43076adrwq", .status = 8} /* 4584 */,
    {.source = (const lxb_char_t *) "\u0B4D𑄴\u1DE9。2Ⴘ𞀨񃥇", .ascii = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-k1g43076adrwq", .status = 8} /* 4585 */,
    {.source = (const lxb_char_t *) "\u0B4D𑄴\u1DE9。2ⴘ𞀨񃥇", .ascii = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-nws2918ndrjr", .status = 8} /* 4586 */,
    {.source = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-nws2918ndrjr", .ascii = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-nws2918ndrjr", .status = 8} /* 4587 */,
    {.source = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-k1g43076adrwq", .ascii = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-k1g43076adrwq", .status = 8} /* 4588 */,
    {.source = (const lxb_char_t *) "\u0B4D𑄴\u1DE9。𝟮ⴘ𞀨񃥇", .ascii = (const lxb_char_t *) "xn--9ic246gs21p.xn--2-nws2918ndrjr", .status = 8} /* 4589 */,
    {.source = (const lxb_char_t *) "򓠭\u200C\u200C⒈。勉𑁅", .ascii = (const lxb_char_t *) "xn--0uga855aez302a.xn--4grs325b", .status = 8} /* 4590 */,
    {.source = (const lxb_char_t *) "򓠭\u200C\u200C1.。勉𑁅", .ascii = (const lxb_char_t *) "xn--1-rgna61159u..xn--4grs325b", .status = 14} /* 4591 */,
    {.source = (const lxb_char_t *) "xn--1-yi00h..xn--4grs325b", .ascii = (const lxb_char_t *) "xn--1-yi00h..xn--4grs325b", .status = 10} /* 4592 */,
    {.source = (const lxb_char_t *) "xn--1-rgna61159u..xn--4grs325b", .ascii = (const lxb_char_t *) "xn--1-rgna61159u..xn--4grs325b", .status = 14} /* 4593 */,
    {.source = (const lxb_char_t *) "xn--tsh11906f.xn--4grs325b", .ascii = (const lxb_char_t *) "xn--tsh11906f.xn--4grs325b", .status = 4} /* 4594 */,
    {.source = (const lxb_char_t *) "xn--0uga855aez302a.xn--4grs325b", .ascii = (const lxb_char_t *) "xn--0uga855aez302a.xn--4grs325b", .status = 8} /* 4595 */,
    {.source = (const lxb_char_t *) "ᡃ.玿񫈜󕞐", .ascii = (const lxb_char_t *) "xn--27e.xn--7cy81125a0yq4a", .status = 4} /* 4596 */,
    {.source = (const lxb_char_t *) "xn--27e.xn--7cy81125a0yq4a", .ascii = (const lxb_char_t *) "xn--27e.xn--7cy81125a0yq4a", .status = 4} /* 4597 */,
    {.source = (const lxb_char_t *) "\u200C\u200C｡⒈≯𝟵", .ascii = (const lxb_char_t *) "xn--0uga.xn--9-ogo37g", .status = 8} /* 4598 */,
    {.source = (const lxb_char_t *) "\u200C\u200C｡⒈>\u0338𝟵", .ascii = (const lxb_char_t *) "xn--0uga.xn--9-ogo37g", .status = 8} /* 4599 */,
    {.source = (const lxb_char_t *) "\u200C\u200C。1.≯9", .ascii = (const lxb_char_t *) "xn--0uga.1.xn--9-ogo", .status = 4} /* 4600 */,
    {.source = (const lxb_char_t *) "\u200C\u200C。1.>\u03389", .ascii = (const lxb_char_t *) "xn--0uga.1.xn--9-ogo", .status = 4} /* 4601 */,
    {.source = (const lxb_char_t *) ".1.xn--9-ogo", .ascii = (const lxb_char_t *) ".1.xn--9-ogo", .status = 6} /* 4602 */,
    {.source = (const lxb_char_t *) "xn--0uga.1.xn--9-ogo", .ascii = (const lxb_char_t *) "xn--0uga.1.xn--9-ogo", .status = 4} /* 4603 */,
    {.source = (const lxb_char_t *) ".xn--9-ogo37g", .ascii = (const lxb_char_t *) ".xn--9-ogo37g", .status = 10} /* 4604 */,
    {.source = (const lxb_char_t *) "xn--0uga.xn--9-ogo37g", .ascii = (const lxb_char_t *) "xn--0uga.xn--9-ogo37g", .status = 8} /* 4605 */,
    {.source = (const lxb_char_t *) "\u115F\u1DE0򐀁.𺻆≯𐮁", .ascii = (const lxb_char_t *) "xn--osd615d5659o.xn--hdh5192gkm6r", .status = 12} /* 4606 */,
    {.source = (const lxb_char_t *) "\u115F\u1DE0򐀁.𺻆>\u0338𐮁", .ascii = (const lxb_char_t *) "xn--osd615d5659o.xn--hdh5192gkm6r", .status = 12} /* 4607 */,
    {.source = (const lxb_char_t *) "xn--osd615d5659o.xn--hdh5192gkm6r", .ascii = (const lxb_char_t *) "xn--osd615d5659o.xn--hdh5192gkm6r", .status = 12} /* 4608 */,
    {.source = (const lxb_char_t *) "󠄫𝩤\u200D\u063E.𝩩-\u081E󑼩", .ascii = (const lxb_char_t *) "xn--9gb723kg862a.xn----qgd52296avol4f", .status = 16} /* 4609 */,
    {.source = (const lxb_char_t *) "xn--9gb5080v.xn----qgd52296avol4f", .ascii = (const lxb_char_t *) "xn--9gb5080v.xn----qgd52296avol4f", .status = 12} /* 4610 */,
    {.source = (const lxb_char_t *) "xn--9gb723kg862a.xn----qgd52296avol4f", .ascii = (const lxb_char_t *) "xn--9gb723kg862a.xn----qgd52296avol4f", .status = 16} /* 4611 */,
    {.source = (const lxb_char_t *) "\u20DA．𑘿-", .ascii = (const lxb_char_t *) "xn--w0g.xn----bd0j", .status = 8} /* 4612 */,
    {.source = (const lxb_char_t *) "\u20DA.𑘿-", .ascii = (const lxb_char_t *) "xn--w0g.xn----bd0j", .status = 8} /* 4613 */,
    {.source = (const lxb_char_t *) "xn--w0g.xn----bd0j", .ascii = (const lxb_char_t *) "xn--w0g.xn----bd0j", .status = 8} /* 4614 */,
    {.source = (const lxb_char_t *) "䮸ß.󠵟󠭎紙\u08A8", .ascii = (const lxb_char_t *) "xn--zca5349a.xn--xyb1370div70kpzba", .status = 8} /* 4615 */,
    {.source = (const lxb_char_t *) "䮸SS.󠵟󠭎紙\u08A8", .ascii = (const lxb_char_t *) "xn--ss-sf1c.xn--xyb1370div70kpzba", .status = 8} /* 4616 */,
    {.source = (const lxb_char_t *) "䮸ss.󠵟󠭎紙\u08A8", .ascii = (const lxb_char_t *) "xn--ss-sf1c.xn--xyb1370div70kpzba", .status = 8} /* 4617 */,
    {.source = (const lxb_char_t *) "䮸Ss.󠵟󠭎紙\u08A8", .ascii = (const lxb_char_t *) "xn--ss-sf1c.xn--xyb1370div70kpzba", .status = 8} /* 4618 */,
    {.source = (const lxb_char_t *) "xn--ss-sf1c.xn--xyb1370div70kpzba", .ascii = (const lxb_char_t *) "xn--ss-sf1c.xn--xyb1370div70kpzba", .status = 8} /* 4619 */,
    {.source = (const lxb_char_t *) "xn--zca5349a.xn--xyb1370div70kpzba", .ascii = (const lxb_char_t *) "xn--zca5349a.xn--xyb1370div70kpzba", .status = 8} /* 4620 */,
    {.source = (const lxb_char_t *) "-Ⴞ.-𝩨⅔𐦕", .ascii = (const lxb_char_t *) "xn----w1g.xn---23-pt0a0433lk3jj", .status = 12} /* 4621 */,
    {.source = (const lxb_char_t *) "-Ⴞ.-𝩨2⁄3𐦕", .ascii = (const lxb_char_t *) "xn----w1g.xn---23-pt0a0433lk3jj", .status = 12} /* 4622 */,
    {.source = (const lxb_char_t *) "-ⴞ.-𝩨2⁄3𐦕", .ascii = (const lxb_char_t *) "xn----zws.xn---23-pt0a0433lk3jj", .status = 8} /* 4623 */,
    {.source = (const lxb_char_t *) "xn----zws.xn---23-pt0a0433lk3jj", .ascii = (const lxb_char_t *) "xn----zws.xn---23-pt0a0433lk3jj", .status = 8} /* 4624 */,
    {.source = (const lxb_char_t *) "xn----w1g.xn---23-pt0a0433lk3jj", .ascii = (const lxb_char_t *) "xn----w1g.xn---23-pt0a0433lk3jj", .status = 12} /* 4625 */,
    {.source = (const lxb_char_t *) "-ⴞ.-𝩨⅔𐦕", .ascii = (const lxb_char_t *) "xn----zws.xn---23-pt0a0433lk3jj", .status = 8} /* 4626 */,
    {.source = (const lxb_char_t *) "󧈯𐹯\u0AC2｡򖢨𐮁񇼖ᡂ", .ascii = (const lxb_char_t *) "xn--bfc7604kv8m3g.xn--17e5565jl7zw4h16a", .status = 12} /* 4627 */,
    {.source = (const lxb_char_t *) "󧈯𐹯\u0AC2。򖢨𐮁񇼖ᡂ", .ascii = (const lxb_char_t *) "xn--bfc7604kv8m3g.xn--17e5565jl7zw4h16a", .status = 12} /* 4628 */,
    {.source = (const lxb_char_t *) "xn--bfc7604kv8m3g.xn--17e5565jl7zw4h16a", .ascii = (const lxb_char_t *) "xn--bfc7604kv8m3g.xn--17e5565jl7zw4h16a", .status = 12} /* 4629 */,
    {.source = (const lxb_char_t *) "\u1082-\u200D\uA8EA．ꡊ\u200D񼸳", .ascii = (const lxb_char_t *) "xn----gyg250jio7k.xn--1ug8774cri56d", .status = 12} /* 4630 */,
    {.source = (const lxb_char_t *) "\u1082-\u200D\uA8EA.ꡊ\u200D񼸳", .ascii = (const lxb_char_t *) "xn----gyg250jio7k.xn--1ug8774cri56d", .status = 12} /* 4631 */,
    {.source = (const lxb_char_t *) "xn----gyg3618i.xn--jc9ao4185a", .ascii = (const lxb_char_t *) "xn----gyg3618i.xn--jc9ao4185a", .status = 8} /* 4632 */,
    {.source = (const lxb_char_t *) "xn----gyg250jio7k.xn--1ug8774cri56d", .ascii = (const lxb_char_t *) "xn----gyg250jio7k.xn--1ug8774cri56d", .status = 12} /* 4633 */,
    {.source = (const lxb_char_t *) "۱。≠\u0668", .ascii = (const lxb_char_t *) "xn--emb.xn--hib334l", .status = 4} /* 4634 */,
    {.source = (const lxb_char_t *) "۱。=\u0338\u0668", .ascii = (const lxb_char_t *) "xn--emb.xn--hib334l", .status = 4} /* 4635 */,
    {.source = (const lxb_char_t *) "xn--emb.xn--hib334l", .ascii = (const lxb_char_t *) "xn--emb.xn--hib334l", .status = 4} /* 4636 */,
    {.source = (const lxb_char_t *) "𑈵廊.𐠍", .ascii = (const lxb_char_t *) "xn--xytw701b.xn--yc9c", .status = 4} /* 4637 */,
    {.source = (const lxb_char_t *) "xn--xytw701b.xn--yc9c", .ascii = (const lxb_char_t *) "xn--xytw701b.xn--yc9c", .status = 4} /* 4638 */,
    {.source = (const lxb_char_t *) "\u200D\u0356-．-Ⴐ\u0661", .ascii = (const lxb_char_t *) "xn----rgb661t.xn----bqc030f", .status = 16} /* 4639 */,
    {.source = (const lxb_char_t *) "\u200D\u0356-.-Ⴐ\u0661", .ascii = (const lxb_char_t *) "xn----rgb661t.xn----bqc030f", .status = 16} /* 4640 */,
    {.source = (const lxb_char_t *) "\u200D\u0356-.-ⴐ\u0661", .ascii = (const lxb_char_t *) "xn----rgb661t.xn----bqc2280a", .status = 12} /* 4641 */,
    {.source = (const lxb_char_t *) "xn----rgb.xn----bqc2280a", .ascii = (const lxb_char_t *) "xn----rgb.xn----bqc2280a", .status = 12} /* 4642 */,
    {.source = (const lxb_char_t *) "xn----rgb661t.xn----bqc2280a", .ascii = (const lxb_char_t *) "xn----rgb661t.xn----bqc2280a", .status = 12} /* 4643 */,
    {.source = (const lxb_char_t *) "xn----rgb.xn----bqc030f", .ascii = (const lxb_char_t *) "xn----rgb.xn----bqc030f", .status = 16} /* 4644 */,
    {.source = (const lxb_char_t *) "xn----rgb661t.xn----bqc030f", .ascii = (const lxb_char_t *) "xn----rgb661t.xn----bqc030f", .status = 16} /* 4645 */,
    {.source = (const lxb_char_t *) "\u200D\u0356-．-ⴐ\u0661", .ascii = (const lxb_char_t *) "xn----rgb661t.xn----bqc2280a", .status = 12} /* 4646 */,
    {.source = (const lxb_char_t *) "\u063A\u0661挏󾯐.-", .ascii = (const lxb_char_t *) "xn--5gb2f4205aqi47p.-", .status = 20} /* 4647 */,
    {.source = (const lxb_char_t *) "xn--5gb2f4205aqi47p.-", .ascii = (const lxb_char_t *) "xn--5gb2f4205aqi47p.-", .status = 20} /* 4648 */,
    {.source = (const lxb_char_t *) "\u06EF｡𐹧𞤽", .ascii = (const lxb_char_t *) "xn--cmb.xn--fo0dy848a", .status = 4} /* 4649 */,
    {.source = (const lxb_char_t *) "\u06EF。𐹧𞤽", .ascii = (const lxb_char_t *) "xn--cmb.xn--fo0dy848a", .status = 4} /* 4650 */,
    {.source = (const lxb_char_t *) "\u06EF。𐹧𞤛", .ascii = (const lxb_char_t *) "xn--cmb.xn--fo0dy848a", .status = 4} /* 4651 */,
    {.source = (const lxb_char_t *) "xn--cmb.xn--fo0dy848a", .ascii = (const lxb_char_t *) "xn--cmb.xn--fo0dy848a", .status = 4} /* 4652 */,
    {.source = (const lxb_char_t *) "\u06EF｡𐹧𞤛", .ascii = (const lxb_char_t *) "xn--cmb.xn--fo0dy848a", .status = 4} /* 4653 */,
    {.source = (const lxb_char_t *) "Ⴞ𶛀𛗻．ᢗ릫", .ascii = (const lxb_char_t *) "xn--2nd8876sgl2j.xn--hbf6853f", .status = 4} /* 4654 */,
    {.source = (const lxb_char_t *) "Ⴞ𶛀𛗻．ᢗ릫", .ascii = (const lxb_char_t *) "xn--2nd8876sgl2j.xn--hbf6853f", .status = 4} /* 4655 */,
    {.source = (const lxb_char_t *) "Ⴞ𶛀𛗻.ᢗ릫", .ascii = (const lxb_char_t *) "xn--2nd8876sgl2j.xn--hbf6853f", .status = 4} /* 4656 */,
    {.source = (const lxb_char_t *) "Ⴞ𶛀𛗻.ᢗ릫", .ascii = (const lxb_char_t *) "xn--2nd8876sgl2j.xn--hbf6853f", .status = 4} /* 4657 */,
    {.source = (const lxb_char_t *) "ⴞ𶛀𛗻.ᢗ릫", .ascii = (const lxb_char_t *) "xn--mlj0486jgl2j.xn--hbf6853f", .status = 4} /* 4658 */,
    {.source = (const lxb_char_t *) "ⴞ𶛀𛗻.ᢗ릫", .ascii = (const lxb_char_t *) "xn--mlj0486jgl2j.xn--hbf6853f", .status = 4} /* 4659 */,
    {.source = (const lxb_char_t *) "xn--mlj0486jgl2j.xn--hbf6853f", .ascii = (const lxb_char_t *) "xn--mlj0486jgl2j.xn--hbf6853f", .status = 4} /* 4660 */,
    {.source = (const lxb_char_t *) "xn--2nd8876sgl2j.xn--hbf6853f", .ascii = (const lxb_char_t *) "xn--2nd8876sgl2j.xn--hbf6853f", .status = 4} /* 4661 */,
    {.source = (const lxb_char_t *) "ⴞ𶛀𛗻．ᢗ릫", .ascii = (const lxb_char_t *) "xn--mlj0486jgl2j.xn--hbf6853f", .status = 4} /* 4662 */,
    {.source = (const lxb_char_t *) "ⴞ𶛀𛗻．ᢗ릫", .ascii = (const lxb_char_t *) "xn--mlj0486jgl2j.xn--hbf6853f", .status = 4} /* 4663 */,
    {.source = (const lxb_char_t *) "󠎃󗭞\u06B7𐹷｡≯\u200C\u1DFE", .ascii = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg59fm0c", .status = 12} /* 4664 */,
    {.source = (const lxb_char_t *) "󠎃󗭞\u06B7𐹷｡>\u0338\u200C\u1DFE", .ascii = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg59fm0c", .status = 12} /* 4665 */,
    {.source = (const lxb_char_t *) "󠎃󗭞\u06B7𐹷。≯\u200C\u1DFE", .ascii = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg59fm0c", .status = 12} /* 4666 */,
    {.source = (const lxb_char_t *) "󠎃󗭞\u06B7𐹷。>\u0338\u200C\u1DFE", .ascii = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg59fm0c", .status = 12} /* 4667 */,
    {.source = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg31q", .ascii = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg31q", .status = 8} /* 4668 */,
    {.source = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg59fm0c", .ascii = (const lxb_char_t *) "xn--qkb4516kbi06fg2id.xn--zfg59fm0c", .status = 12} /* 4669 */,
    {.source = (const lxb_char_t *) "ᛎ󠅍󠐕\u200D｡𐹾𐹪𐻝-", .ascii = (const lxb_char_t *) "xn--fxe848bq3411a.xn----q26i2bvu", .status = 20} /* 4670 */,
    {.source = (const lxb_char_t *) "ᛎ󠅍󠐕\u200D。𐹾𐹪𐻝-", .ascii = (const lxb_char_t *) "xn--fxe848bq3411a.xn----q26i2bvu", .status = 20} /* 4671 */,
    {.source = (const lxb_char_t *) "xn--fxe63563p.xn----q26i2bvu", .ascii = (const lxb_char_t *) "xn--fxe63563p.xn----q26i2bvu", .status = 16} /* 4672 */,
    {.source = (const lxb_char_t *) "xn--fxe848bq3411a.xn----q26i2bvu", .ascii = (const lxb_char_t *) "xn--fxe848bq3411a.xn----q26i2bvu", .status = 20} /* 4673 */,
    {.source = (const lxb_char_t *) "𐹶.𐫂", .ascii = (const lxb_char_t *) "xn--uo0d.xn--rw9c", .status = 4} /* 4674 */,
    {.source = (const lxb_char_t *) "xn--uo0d.xn--rw9c", .ascii = (const lxb_char_t *) "xn--uo0d.xn--rw9c", .status = 4} /* 4675 */,
    {.source = (const lxb_char_t *) "ß\u200D\u103A｡⒈", .ascii = (const lxb_char_t *) "xn--zca679eh2l.xn--tsh", .status = 8} /* 4676 */,
    {.source = (const lxb_char_t *) "ß\u200D\u103A。1.", .ascii = (const lxb_char_t *) "xn--zca679eh2l.1.", .status = 4} /* 4677 */,
    {.source = (const lxb_char_t *) "SS\u200D\u103A。1.", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.1.", .status = 4} /* 4678 */,
    {.source = (const lxb_char_t *) "ss\u200D\u103A。1.", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.1.", .status = 4} /* 4679 */,
    {.source = (const lxb_char_t *) "Ss\u200D\u103A。1.", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.1.", .status = 4} /* 4680 */,
    {.source = (const lxb_char_t *) "xn--ss-f4j.1.", .ascii = (const lxb_char_t *) "xn--ss-f4j.1.", .status = 0} /* 4681 */,
    {.source = (const lxb_char_t *) "ss\u103A.1.", .ascii = (const lxb_char_t *) "xn--ss-f4j.1.", .status = 0} /* 4682 */,
    {.source = (const lxb_char_t *) "SS\u103A.1.", .ascii = (const lxb_char_t *) "xn--ss-f4j.1.", .status = 0} /* 4683 */,
    {.source = (const lxb_char_t *) "Ss\u103A.1.", .ascii = (const lxb_char_t *) "xn--ss-f4j.1.", .status = 0} /* 4684 */,
    {.source = (const lxb_char_t *) "xn--ss-f4j585j.1.", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.1.", .status = 4} /* 4685 */,
    {.source = (const lxb_char_t *) "xn--zca679eh2l.1.", .ascii = (const lxb_char_t *) "xn--zca679eh2l.1.", .status = 4} /* 4686 */,
    {.source = (const lxb_char_t *) "SS\u200D\u103A｡⒈", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.xn--tsh", .status = 8} /* 4687 */,
    {.source = (const lxb_char_t *) "ss\u200D\u103A｡⒈", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.xn--tsh", .status = 8} /* 4688 */,
    {.source = (const lxb_char_t *) "Ss\u200D\u103A｡⒈", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.xn--tsh", .status = 8} /* 4689 */,
    {.source = (const lxb_char_t *) "xn--ss-f4j.xn--tsh", .ascii = (const lxb_char_t *) "xn--ss-f4j.xn--tsh", .status = 4} /* 4690 */,
    {.source = (const lxb_char_t *) "xn--ss-f4j585j.xn--tsh", .ascii = (const lxb_char_t *) "xn--ss-f4j585j.xn--tsh", .status = 8} /* 4691 */,
    {.source = (const lxb_char_t *) "xn--zca679eh2l.xn--tsh", .ascii = (const lxb_char_t *) "xn--zca679eh2l.xn--tsh", .status = 8} /* 4692 */,
    {.source = (const lxb_char_t *) "\u0B4D\u200C𙶵𞻘。\u200D", .ascii = (const lxb_char_t *) "xn--9ic637hz82z32jc.xn--1ug", .status = 16} /* 4693 */,
    {.source = (const lxb_char_t *) "xn--9ic6417rn4xb.", .ascii = (const lxb_char_t *) "xn--9ic6417rn4xb.", .status = 12} /* 4694 */,
    {.source = (const lxb_char_t *) "xn--9ic637hz82z32jc.xn--1ug", .ascii = (const lxb_char_t *) "xn--9ic637hz82z32jc.xn--1ug", .status = 16} /* 4695 */,
    {.source = (const lxb_char_t *) "𐮅｡\u06BC🁕", .ascii = (const lxb_char_t *) "xn--c29c.xn--vkb8871w", .status = 4} /* 4696 */,
    {.source = (const lxb_char_t *) "𐮅。\u06BC🁕", .ascii = (const lxb_char_t *) "xn--c29c.xn--vkb8871w", .status = 4} /* 4697 */,
    {.source = (const lxb_char_t *) "xn--c29c.xn--vkb8871w", .ascii = (const lxb_char_t *) "xn--c29c.xn--vkb8871w", .status = 4} /* 4698 */,
    {.source = (const lxb_char_t *) "\u0620\u17D2。𐫔󠀧\u200C𑈵", .ascii = (const lxb_char_t *) "xn--fgb471g.xn--0ug9853g7verp838a", .status = 16} /* 4699 */,
    {.source = (const lxb_char_t *) "xn--fgb471g.xn--9w9c29jw3931a", .ascii = (const lxb_char_t *) "xn--fgb471g.xn--9w9c29jw3931a", .status = 12} /* 4700 */,
    {.source = (const lxb_char_t *) "xn--fgb471g.xn--0ug9853g7verp838a", .ascii = (const lxb_char_t *) "xn--fgb471g.xn--0ug9853g7verp838a", .status = 16} /* 4701 */,
    {.source = (const lxb_char_t *) "񋉕.𞣕𞤊", .ascii = (const lxb_char_t *) "xn--tf5w.xn--2b6hof", .status = 12} /* 4702 */,
    {.source = (const lxb_char_t *) "񋉕.𞣕𞤬", .ascii = (const lxb_char_t *) "xn--tf5w.xn--2b6hof", .status = 12} /* 4703 */,
    {.source = (const lxb_char_t *) "xn--tf5w.xn--2b6hof", .ascii = (const lxb_char_t *) "xn--tf5w.xn--2b6hof", .status = 12} /* 4704 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿．ß\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--zca216edt0r", .status = 0} /* 4705 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿.ß\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--zca216edt0r", .status = 0} /* 4706 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿.SS\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4707 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿.ss\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4708 */,
    {.source = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4709 */,
    {.source = (const lxb_char_t *) "xn--clb2593k.xn--zca216edt0r", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--zca216edt0r", .status = 0} /* 4710 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿．SS\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4711 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿．ss\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4712 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿.Ss\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4713 */,
    {.source = (const lxb_char_t *) "\u06CC𐨿．Ss\u0F84𑍬", .ascii = (const lxb_char_t *) "xn--clb2593k.xn--ss-toj6092t", .status = 0} /* 4714 */,
    {.source = (const lxb_char_t *) "𝟠≮\u200C｡󠅱\u17B4", .ascii = (const lxb_char_t *) "xn--8-sgn10i.xn--z3e", .status = 12} /* 4715 */,
    {.source = (const lxb_char_t *) "𝟠<\u0338\u200C｡󠅱\u17B4", .ascii = (const lxb_char_t *) "xn--8-sgn10i.xn--z3e", .status = 12} /* 4716 */,
    {.source = (const lxb_char_t *) "8≮\u200C。󠅱\u17B4", .ascii = (const lxb_char_t *) "xn--8-sgn10i.xn--z3e", .status = 12} /* 4717 */,
    {.source = (const lxb_char_t *) "8<\u0338\u200C。󠅱\u17B4", .ascii = (const lxb_char_t *) "xn--8-sgn10i.xn--z3e", .status = 12} /* 4718 */,
    {.source = (const lxb_char_t *) "xn--8-ngo.xn--z3e", .ascii = (const lxb_char_t *) "xn--8-ngo.xn--z3e", .status = 8} /* 4719 */,
    {.source = (const lxb_char_t *) "xn--8-sgn10i.xn--z3e", .ascii = (const lxb_char_t *) "xn--8-sgn10i.xn--z3e", .status = 12} /* 4720 */,
    {.source = (const lxb_char_t *) "ᢕ≯︒񄂯．Ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--7md", .status = 4} /* 4721 */,
    {.source = (const lxb_char_t *) "ᢕ>\u0338︒񄂯．Ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--7md", .status = 4} /* 4722 */,
    {.source = (const lxb_char_t *) "ᢕ≯。񄂯.Ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--7md", .status = 4} /* 4723 */,
    {.source = (const lxb_char_t *) "ᢕ>\u0338。񄂯.Ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--7md", .status = 4} /* 4724 */,
    {.source = (const lxb_char_t *) "ᢕ>\u0338。񄂯.ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--rkj", .status = 4} /* 4725 */,
    {.source = (const lxb_char_t *) "ᢕ≯。񄂯.ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--rkj", .status = 4} /* 4726 */,
    {.source = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--rkj", .ascii = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--rkj", .status = 4} /* 4727 */,
    {.source = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--7md", .ascii = (const lxb_char_t *) "xn--fbf851c.xn--ko1u.xn--7md", .status = 4} /* 4728 */,
    {.source = (const lxb_char_t *) "ᢕ>\u0338︒񄂯．ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--rkj", .status = 4} /* 4729 */,
    {.source = (const lxb_char_t *) "ᢕ≯︒񄂯．ⴀ", .ascii = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--rkj", .status = 4} /* 4730 */,
    {.source = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--rkj", .ascii = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--rkj", .status = 4} /* 4731 */,
    {.source = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--7md", .ascii = (const lxb_char_t *) "xn--fbf851cq98poxw1a.xn--7md", .status = 4} /* 4732 */,
    {.source = (const lxb_char_t *) "\u0F9F．-\u082A", .ascii = (const lxb_char_t *) "xn--vfd.xn----fhd", .status = 8} /* 4733 */,
    {.source = (const lxb_char_t *) "\u0F9F.-\u082A", .ascii = (const lxb_char_t *) "xn--vfd.xn----fhd", .status = 8} /* 4734 */,
    {.source = (const lxb_char_t *) "xn--vfd.xn----fhd", .ascii = (const lxb_char_t *) "xn--vfd.xn----fhd", .status = 8} /* 4735 */,
    {.source = (const lxb_char_t *) "ᵬ󠆠．핒⒒⒈􈄦", .ascii = (const lxb_char_t *) "xn--tbg.xn--tsht7586kyts9l", .status = 4} /* 4736 */,
    {.source = (const lxb_char_t *) "ᵬ󠆠．핒⒒⒈􈄦", .ascii = (const lxb_char_t *) "xn--tbg.xn--tsht7586kyts9l", .status = 4} /* 4737 */,
    {.source = (const lxb_char_t *) "ᵬ󠆠.핒11.1.􈄦", .ascii = (const lxb_char_t *) "xn--tbg.xn--11-5o7k.1.xn--k469f", .status = 4} /* 4738 */,
    {.source = (const lxb_char_t *) "ᵬ󠆠.핒11.1.􈄦", .ascii = (const lxb_char_t *) "xn--tbg.xn--11-5o7k.1.xn--k469f", .status = 4} /* 4739 */,
    {.source = (const lxb_char_t *) "xn--tbg.xn--11-5o7k.1.xn--k469f", .ascii = (const lxb_char_t *) "xn--tbg.xn--11-5o7k.1.xn--k469f", .status = 4} /* 4740 */,
    {.source = (const lxb_char_t *) "xn--tbg.xn--tsht7586kyts9l", .ascii = (const lxb_char_t *) "xn--tbg.xn--tsht7586kyts9l", .status = 4} /* 4741 */,
    {.source = (const lxb_char_t *) "ς𑓂𐋢．\u0668", .ascii = (const lxb_char_t *) "xn--3xa8371khhl.xn--hib", .status = 4} /* 4742 */,
    {.source = (const lxb_char_t *) "ς𑓂𐋢.\u0668", .ascii = (const lxb_char_t *) "xn--3xa8371khhl.xn--hib", .status = 4} /* 4743 */,
    {.source = (const lxb_char_t *) "Σ𑓂𐋢.\u0668", .ascii = (const lxb_char_t *) "xn--4xa6371khhl.xn--hib", .status = 4} /* 4744 */,
    {.source = (const lxb_char_t *) "σ𑓂𐋢.\u0668", .ascii = (const lxb_char_t *) "xn--4xa6371khhl.xn--hib", .status = 4} /* 4745 */,
    {.source = (const lxb_char_t *) "xn--4xa6371khhl.xn--hib", .ascii = (const lxb_char_t *) "xn--4xa6371khhl.xn--hib", .status = 4} /* 4746 */,
    {.source = (const lxb_char_t *) "xn--3xa8371khhl.xn--hib", .ascii = (const lxb_char_t *) "xn--3xa8371khhl.xn--hib", .status = 4} /* 4747 */,
    {.source = (const lxb_char_t *) "Σ𑓂𐋢．\u0668", .ascii = (const lxb_char_t *) "xn--4xa6371khhl.xn--hib", .status = 4} /* 4748 */,
    {.source = (const lxb_char_t *) "σ𑓂𐋢．\u0668", .ascii = (const lxb_char_t *) "xn--4xa6371khhl.xn--hib", .status = 4} /* 4749 */,
    {.source = (const lxb_char_t *) "\uA953\u200C𐋻\u200D.\u2DF8𞿄𐹲", .ascii = (const lxb_char_t *) "xn--0ugc8356he76c.xn--urju692efj0f", .status = 20} /* 4750 */,
    {.source = (const lxb_char_t *) "xn--3j9a531o.xn--urju692efj0f", .ascii = (const lxb_char_t *) "xn--3j9a531o.xn--urju692efj0f", .status = 12} /* 4751 */,
    {.source = (const lxb_char_t *) "xn--0ugc8356he76c.xn--urju692efj0f", .ascii = (const lxb_char_t *) "xn--0ugc8356he76c.xn--urju692efj0f", .status = 20} /* 4752 */,
    {.source = (const lxb_char_t *) "⊼。񪧖\u0695", .ascii = (const lxb_char_t *) "xn--ofh.xn--rjb13118f", .status = 16} /* 4753 */,
    {.source = (const lxb_char_t *) "xn--ofh.xn--rjb13118f", .ascii = (const lxb_char_t *) "xn--ofh.xn--rjb13118f", .status = 16} /* 4754 */,
    {.source = (const lxb_char_t *) "𐯬񖋔。󜳥", .ascii = (const lxb_char_t *) "xn--949co370q.xn--7g25e", .status = 12} /* 4755 */,
    {.source = (const lxb_char_t *) "xn--949co370q.xn--7g25e", .ascii = (const lxb_char_t *) "xn--949co370q.xn--7g25e", .status = 12} /* 4756 */,
    {.source = (const lxb_char_t *) "\u0601𑍧\u07DD。ς򬍘🀞\u17B5", .ascii = (const lxb_char_t *) "xn--jfb66gt010c.xn--3xa823h9p95ars26d", .status = 12} /* 4757 */,
    {.source = (const lxb_char_t *) "\u0601𑍧\u07DD。Σ򬍘🀞\u17B5", .ascii = (const lxb_char_t *) "xn--jfb66gt010c.xn--4xa623h9p95ars26d", .status = 12} /* 4758 */,
    {.source = (const lxb_char_t *) "\u0601𑍧\u07DD。σ򬍘🀞\u17B5", .ascii = (const lxb_char_t *) "xn--jfb66gt010c.xn--4xa623h9p95ars26d", .status = 12} /* 4759 */,
    {.source = (const lxb_char_t *) "xn--jfb66gt010c.xn--4xa623h9p95ars26d", .ascii = (const lxb_char_t *) "xn--jfb66gt010c.xn--4xa623h9p95ars26d", .status = 12} /* 4760 */,
    {.source = (const lxb_char_t *) "xn--jfb66gt010c.xn--3xa823h9p95ars26d", .ascii = (const lxb_char_t *) "xn--jfb66gt010c.xn--3xa823h9p95ars26d", .status = 12} /* 4761 */,
    {.source = (const lxb_char_t *) "-𐳲\u0646󠺐。\uABED𝟥", .ascii = (const lxb_char_t *) "xn----roc5482rek10i.xn--3-zw5e", .status = 16} /* 4762 */,
    {.source = (const lxb_char_t *) "-𐳲\u0646󠺐。\uABED3", .ascii = (const lxb_char_t *) "xn----roc5482rek10i.xn--3-zw5e", .status = 16} /* 4763 */,
    {.source = (const lxb_char_t *) "-𐲲\u0646󠺐。\uABED3", .ascii = (const lxb_char_t *) "xn----roc5482rek10i.xn--3-zw5e", .status = 16} /* 4764 */,
    {.source = (const lxb_char_t *) "xn----roc5482rek10i.xn--3-zw5e", .ascii = (const lxb_char_t *) "xn----roc5482rek10i.xn--3-zw5e", .status = 16} /* 4765 */,
    {.source = (const lxb_char_t *) "-𐲲\u0646󠺐。\uABED𝟥", .ascii = (const lxb_char_t *) "xn----roc5482rek10i.xn--3-zw5e", .status = 16} /* 4766 */,
    {.source = (const lxb_char_t *) "\u200C󠴦｡񲨕≮𐦜", .ascii = (const lxb_char_t *) "xn--0ug22251l.xn--gdhz712gzlr6b", .status = 20} /* 4767 */,
    {.source = (const lxb_char_t *) "\u200C󠴦｡񲨕<\u0338𐦜", .ascii = (const lxb_char_t *) "xn--0ug22251l.xn--gdhz712gzlr6b", .status = 20} /* 4768 */,
    {.source = (const lxb_char_t *) "\u200C󠴦。񲨕≮𐦜", .ascii = (const lxb_char_t *) "xn--0ug22251l.xn--gdhz712gzlr6b", .status = 20} /* 4769 */,
    {.source = (const lxb_char_t *) "\u200C󠴦。񲨕<\u0338𐦜", .ascii = (const lxb_char_t *) "xn--0ug22251l.xn--gdhz712gzlr6b", .status = 20} /* 4770 */,
    {.source = (const lxb_char_t *) "xn--6v56e.xn--gdhz712gzlr6b", .ascii = (const lxb_char_t *) "xn--6v56e.xn--gdhz712gzlr6b", .status = 16} /* 4771 */,
    {.source = (const lxb_char_t *) "xn--0ug22251l.xn--gdhz712gzlr6b", .ascii = (const lxb_char_t *) "xn--0ug22251l.xn--gdhz712gzlr6b", .status = 20} /* 4772 */,
    {.source = (const lxb_char_t *) "⒈✌򟬟．𝟡񠱣", .ascii = (const lxb_char_t *) "xn--tsh24g49550b.xn--9-o706d", .status = 4} /* 4773 */,
    {.source = (const lxb_char_t *) "1.✌򟬟.9񠱣", .ascii = (const lxb_char_t *) "1.xn--7bi44996f.xn--9-o706d", .status = 4} /* 4774 */,
    {.source = (const lxb_char_t *) "1.xn--7bi44996f.xn--9-o706d", .ascii = (const lxb_char_t *) "1.xn--7bi44996f.xn--9-o706d", .status = 4} /* 4775 */,
    {.source = (const lxb_char_t *) "xn--tsh24g49550b.xn--9-o706d", .ascii = (const lxb_char_t *) "xn--tsh24g49550b.xn--9-o706d", .status = 4} /* 4776 */,
    {.source = (const lxb_char_t *) "𑆾𞤬𐮆.\u0666\u1DD4", .ascii = (const lxb_char_t *) "xn--d29c79hf98r.xn--fib011j", .status = 8} /* 4777 */,
    {.source = (const lxb_char_t *) "𑆾𞤊𐮆.\u0666\u1DD4", .ascii = (const lxb_char_t *) "xn--d29c79hf98r.xn--fib011j", .status = 8} /* 4778 */,
    {.source = (const lxb_char_t *) "xn--d29c79hf98r.xn--fib011j", .ascii = (const lxb_char_t *) "xn--d29c79hf98r.xn--fib011j", .status = 8} /* 4779 */,
    {.source = (const lxb_char_t *) "ς．\uA9C0\uA8C4", .ascii = (const lxb_char_t *) "xn--3xa.xn--0f9ars", .status = 4} /* 4780 */,
    {.source = (const lxb_char_t *) "ς.\uA9C0\uA8C4", .ascii = (const lxb_char_t *) "xn--3xa.xn--0f9ars", .status = 4} /* 4781 */,
    {.source = (const lxb_char_t *) "Σ.\uA9C0\uA8C4", .ascii = (const lxb_char_t *) "xn--4xa.xn--0f9ars", .status = 4} /* 4782 */,
    {.source = (const lxb_char_t *) "σ.\uA9C0\uA8C4", .ascii = (const lxb_char_t *) "xn--4xa.xn--0f9ars", .status = 4} /* 4783 */,
    {.source = (const lxb_char_t *) "xn--4xa.xn--0f9ars", .ascii = (const lxb_char_t *) "xn--4xa.xn--0f9ars", .status = 4} /* 4784 */,
    {.source = (const lxb_char_t *) "xn--3xa.xn--0f9ars", .ascii = (const lxb_char_t *) "xn--3xa.xn--0f9ars", .status = 4} /* 4785 */,
    {.source = (const lxb_char_t *) "Σ．\uA9C0\uA8C4", .ascii = (const lxb_char_t *) "xn--4xa.xn--0f9ars", .status = 4} /* 4786 */,
    {.source = (const lxb_char_t *) "σ．\uA9C0\uA8C4", .ascii = (const lxb_char_t *) "xn--4xa.xn--0f9ars", .status = 4} /* 4787 */,
    {.source = (const lxb_char_t *) "𑰶\u200C≯𐳐．\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4788 */,
    {.source = (const lxb_char_t *) "𑰶\u200C>\u0338𐳐．\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4789 */,
    {.source = (const lxb_char_t *) "𑰶\u200C≯𐳐.\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4790 */,
    {.source = (const lxb_char_t *) "𑰶\u200C>\u0338𐳐.\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4791 */,
    {.source = (const lxb_char_t *) "𑰶\u200C>\u0338𐲐.\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4792 */,
    {.source = (const lxb_char_t *) "𑰶\u200C≯𐲐.\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4793 */,
    {.source = (const lxb_char_t *) "xn--hdhz343g3wj.xn--qwb", .ascii = (const lxb_char_t *) "xn--hdhz343g3wj.xn--qwb", .status = 8} /* 4794 */,
    {.source = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4795 */,
    {.source = (const lxb_char_t *) "𑰶\u200C>\u0338𐲐．\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4796 */,
    {.source = (const lxb_char_t *) "𑰶\u200C≯𐲐．\u085B", .ascii = (const lxb_char_t *) "xn--0ug06g7697ap4ma.xn--qwb", .status = 12} /* 4797 */,
    {.source = (const lxb_char_t *) "羚｡≯", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4798 */,
    {.source = (const lxb_char_t *) "羚｡>\u0338", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4799 */,
    {.source = (const lxb_char_t *) "羚。≯", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4800 */,
    {.source = (const lxb_char_t *) "羚。>\u0338", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4801 */,
    {.source = (const lxb_char_t *) "xn--xt0a.xn--hdh", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4802 */,
    {.source = (const lxb_char_t *) "羚.≯", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4803 */,
    {.source = (const lxb_char_t *) "羚.>\u0338", .ascii = (const lxb_char_t *) "xn--xt0a.xn--hdh", .status = 0} /* 4804 */,
    {.source = (const lxb_char_t *) "𑓂\u1759．\u08A8", .ascii = (const lxb_char_t *) "xn--e1e9580k.xn--xyb", .status = 12} /* 4805 */,
    {.source = (const lxb_char_t *) "𑓂\u1759.\u08A8", .ascii = (const lxb_char_t *) "xn--e1e9580k.xn--xyb", .status = 12} /* 4806 */,
    {.source = (const lxb_char_t *) "xn--e1e9580k.xn--xyb", .ascii = (const lxb_char_t *) "xn--e1e9580k.xn--xyb", .status = 12} /* 4807 */,
    {.source = (const lxb_char_t *) "󨣿󠇀\u200D｡\u0663ҠჀ𝟑", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36kixu", .status = 16} /* 4808 */,
    {.source = (const lxb_char_t *) "󨣿󠇀\u200D。\u0663ҠჀ3", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36kixu", .status = 16} /* 4809 */,
    {.source = (const lxb_char_t *) "󨣿󠇀\u200D。\u0663ҡⴠ3", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36ko13f", .status = 16} /* 4810 */,
    {.source = (const lxb_char_t *) "xn--1r19e.xn--3-ozb36ko13f", .ascii = (const lxb_char_t *) "xn--1r19e.xn--3-ozb36ko13f", .status = 8} /* 4811 */,
    {.source = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36ko13f", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36ko13f", .status = 16} /* 4812 */,
    {.source = (const lxb_char_t *) "xn--1r19e.xn--3-ozb36kixu", .ascii = (const lxb_char_t *) "xn--1r19e.xn--3-ozb36kixu", .status = 8} /* 4813 */,
    {.source = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36kixu", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36kixu", .status = 16} /* 4814 */,
    {.source = (const lxb_char_t *) "󨣿󠇀\u200D｡\u0663ҡⴠ𝟑", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36ko13f", .status = 16} /* 4815 */,
    {.source = (const lxb_char_t *) "󨣿󠇀\u200D。\u0663Ҡⴠ3", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36ko13f", .status = 16} /* 4816 */,
    {.source = (const lxb_char_t *) "󨣿󠇀\u200D｡\u0663Ҡⴠ𝟑", .ascii = (const lxb_char_t *) "xn--1ug89936l.xn--3-ozb36ko13f", .status = 16} /* 4817 */,
    {.source = (const lxb_char_t *) "ᡷ。𐹢\u08E0", .ascii = (const lxb_char_t *) "xn--k9e.xn--j0b5005k", .status = 4} /* 4818 */,
    {.source = (const lxb_char_t *) "xn--k9e.xn--j0b5005k", .ascii = (const lxb_char_t *) "xn--k9e.xn--j0b5005k", .status = 4} /* 4819 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3｡\u0666񗜼\u17D2ß", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--zca34zk4qx711k", .status = 8} /* 4820 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3。\u0666񗜼\u17D2ß", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--zca34zk4qx711k", .status = 8} /* 4821 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3。\u0666񗜼\u17D2SS", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4822 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3。\u0666񗜼\u17D2ss", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4823 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3。\u0666񗜼\u17D2Ss", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4824 */,
    {.source = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4825 */,
    {.source = (const lxb_char_t *) "xn--1zf58212h.xn--zca34zk4qx711k", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--zca34zk4qx711k", .status = 8} /* 4826 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3｡\u0666񗜼\u17D2SS", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4827 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3｡\u0666񗜼\u17D2ss", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4828 */,
    {.source = (const lxb_char_t *) "򕮇\u1BF3｡\u0666񗜼\u17D2Ss", .ascii = (const lxb_char_t *) "xn--1zf58212h.xn--ss-pyd459o3258m", .status = 8} /* 4829 */,
    {.source = (const lxb_char_t *) "\u0664򤽎𑲛.󠔢︒≠", .ascii = (const lxb_char_t *) "xn--dib0653l2i02d.xn--1ch7467f14u4g", .status = 8} /* 4830 */,
    {.source = (const lxb_char_t *) "\u0664򤽎𑲛.󠔢︒=\u0338", .ascii = (const lxb_char_t *) "xn--dib0653l2i02d.xn--1ch7467f14u4g", .status = 8} /* 4831 */,
    {.source = (const lxb_char_t *) "\u0664򤽎𑲛.󠔢。≠", .ascii = (const lxb_char_t *) "xn--dib0653l2i02d.xn--k736e.xn--1ch", .status = 8} /* 4832 */,
    {.source = (const lxb_char_t *) "\u0664򤽎𑲛.󠔢。=\u0338", .ascii = (const lxb_char_t *) "xn--dib0653l2i02d.xn--k736e.xn--1ch", .status = 8} /* 4833 */,
    {.source = (const lxb_char_t *) "xn--dib0653l2i02d.xn--k736e.xn--1ch", .ascii = (const lxb_char_t *) "xn--dib0653l2i02d.xn--k736e.xn--1ch", .status = 8} /* 4834 */,
    {.source = (const lxb_char_t *) "xn--dib0653l2i02d.xn--1ch7467f14u4g", .ascii = (const lxb_char_t *) "xn--dib0653l2i02d.xn--1ch7467f14u4g", .status = 8} /* 4835 */,
    {.source = (const lxb_char_t *) "➆񷧕ỗ⒈．򑬒񡘮\u085B𝟫", .ascii = (const lxb_char_t *) "xn--6lg26tvvc6v99z.xn--9-6jd87310jtcqs", .status = 4} /* 4836 */,
    {.source = (const lxb_char_t *) "➆񷧕o\u0302\u0303⒈．򑬒񡘮\u085B𝟫", .ascii = (const lxb_char_t *) "xn--6lg26tvvc6v99z.xn--9-6jd87310jtcqs", .status = 4} /* 4837 */,
    {.source = (const lxb_char_t *) "➆񷧕ỗ1..򑬒񡘮\u085B9", .ascii = (const lxb_char_t *) "xn--1-3xm292b6044r..xn--9-6jd87310jtcqs", .status = 10} /* 4838 */,
    {.source = (const lxb_char_t *) "➆񷧕o\u0302\u03031..򑬒񡘮\u085B9", .ascii = (const lxb_char_t *) "xn--1-3xm292b6044r..xn--9-6jd87310jtcqs", .status = 10} /* 4839 */,
    {.source = (const lxb_char_t *) "➆񷧕O\u0302\u03031..򑬒񡘮\u085B9", .ascii = (const lxb_char_t *) "xn--1-3xm292b6044r..xn--9-6jd87310jtcqs", .status = 10} /* 4840 */,
    {.source = (const lxb_char_t *) "➆񷧕Ỗ1..򑬒񡘮\u085B9", .ascii = (const lxb_char_t *) "xn--1-3xm292b6044r..xn--9-6jd87310jtcqs", .status = 10} /* 4841 */,
    {.source = (const lxb_char_t *) "xn--1-3xm292b6044r..xn--9-6jd87310jtcqs", .ascii = (const lxb_char_t *) "xn--1-3xm292b6044r..xn--9-6jd87310jtcqs", .status = 10} /* 4842 */,
    {.source = (const lxb_char_t *) "➆񷧕O\u0302\u0303⒈．򑬒񡘮\u085B𝟫", .ascii = (const lxb_char_t *) "xn--6lg26tvvc6v99z.xn--9-6jd87310jtcqs", .status = 4} /* 4843 */,
    {.source = (const lxb_char_t *) "➆񷧕Ỗ⒈．򑬒񡘮\u085B𝟫", .ascii = (const lxb_char_t *) "xn--6lg26tvvc6v99z.xn--9-6jd87310jtcqs", .status = 4} /* 4844 */,
    {.source = (const lxb_char_t *) "xn--6lg26tvvc6v99z.xn--9-6jd87310jtcqs", .ascii = (const lxb_char_t *) "xn--6lg26tvvc6v99z.xn--9-6jd87310jtcqs", .status = 4} /* 4845 */,
    {.source = (const lxb_char_t *) "\u200D｡𞤘", .ascii = (const lxb_char_t *) "xn--1ug.xn--ye6h", .status = 8} /* 4846 */,
    {.source = (const lxb_char_t *) "\u200D。𞤘", .ascii = (const lxb_char_t *) "xn--1ug.xn--ye6h", .status = 8} /* 4847 */,
    {.source = (const lxb_char_t *) "\u200D。𞤺", .ascii = (const lxb_char_t *) "xn--1ug.xn--ye6h", .status = 8} /* 4848 */,
    {.source = (const lxb_char_t *) ".xn--ye6h", .ascii = (const lxb_char_t *) ".xn--ye6h", .status = 6} /* 4849 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--ye6h", .ascii = (const lxb_char_t *) "xn--1ug.xn--ye6h", .status = 8} /* 4850 */,
    {.source = (const lxb_char_t *) "\u200D｡𞤺", .ascii = (const lxb_char_t *) "xn--1ug.xn--ye6h", .status = 8} /* 4851 */,
    {.source = (const lxb_char_t *) "xn--ye6h", .ascii = (const lxb_char_t *) "xn--ye6h", .status = 0} /* 4852 */,
    {.source = (const lxb_char_t *) "𞤺", .ascii = (const lxb_char_t *) "xn--ye6h", .status = 0} /* 4853 */,
    {.source = (const lxb_char_t *) "𞤘", .ascii = (const lxb_char_t *) "xn--ye6h", .status = 0} /* 4854 */,
    {.source = (const lxb_char_t *) "\u0829\u0724.ᢣ", .ascii = (const lxb_char_t *) "xn--unb53c.xn--tbf", .status = 8} /* 4855 */,
    {.source = (const lxb_char_t *) "xn--unb53c.xn--tbf", .ascii = (const lxb_char_t *) "xn--unb53c.xn--tbf", .status = 8} /* 4856 */,
    {.source = (const lxb_char_t *) "\u073C\u200C-。𓐾ß", .ascii = (const lxb_char_t *) "xn----s2c071q.xn--zca7848m", .status = 16} /* 4857 */,
    {.source = (const lxb_char_t *) "\u073C\u200C-。𓐾SS", .ascii = (const lxb_char_t *) "xn----s2c071q.xn--ss-066q", .status = 16} /* 4858 */,
    {.source = (const lxb_char_t *) "\u073C\u200C-。𓐾ss", .ascii = (const lxb_char_t *) "xn----s2c071q.xn--ss-066q", .status = 16} /* 4859 */,
    {.source = (const lxb_char_t *) "\u073C\u200C-。𓐾Ss", .ascii = (const lxb_char_t *) "xn----s2c071q.xn--ss-066q", .status = 16} /* 4860 */,
    {.source = (const lxb_char_t *) "xn----s2c.xn--ss-066q", .ascii = (const lxb_char_t *) "xn----s2c.xn--ss-066q", .status = 12} /* 4861 */,
    {.source = (const lxb_char_t *) "xn----s2c071q.xn--ss-066q", .ascii = (const lxb_char_t *) "xn----s2c071q.xn--ss-066q", .status = 16} /* 4862 */,
    {.source = (const lxb_char_t *) "xn----s2c071q.xn--zca7848m", .ascii = (const lxb_char_t *) "xn----s2c071q.xn--zca7848m", .status = 16} /* 4863 */,
    {.source = (const lxb_char_t *) "\u200Cς🃡⒗.\u0CC6仧\u0756", .ascii = (const lxb_char_t *) "xn--3xa795lz9czy52d.xn--9ob79ycx2e", .status = 24} /* 4864 */,
    {.source = (const lxb_char_t *) "\u200Cς🃡16..\u0CC6仧\u0756", .ascii = (const lxb_char_t *) "xn--16-rbc1800avy99b..xn--9ob79ycx2e", .status = 26} /* 4865 */,
    {.source = (const lxb_char_t *) "\u200CΣ🃡16..\u0CC6仧\u0756", .ascii = (const lxb_char_t *) "xn--16-ubc7700avy99b..xn--9ob79ycx2e", .status = 26} /* 4866 */,
    {.source = (const lxb_char_t *) "\u200Cσ🃡16..\u0CC6仧\u0756", .ascii = (const lxb_char_t *) "xn--16-ubc7700avy99b..xn--9ob79ycx2e", .status = 26} /* 4867 */,
    {.source = (const lxb_char_t *) "xn--16-ubc66061c..xn--9ob79ycx2e", .ascii = (const lxb_char_t *) "xn--16-ubc66061c..xn--9ob79ycx2e", .status = 18} /* 4868 */,
    {.source = (const lxb_char_t *) "xn--16-ubc7700avy99b..xn--9ob79ycx2e", .ascii = (const lxb_char_t *) "xn--16-ubc7700avy99b..xn--9ob79ycx2e", .status = 26} /* 4869 */,
    {.source = (const lxb_char_t *) "xn--16-rbc1800avy99b..xn--9ob79ycx2e", .ascii = (const lxb_char_t *) "xn--16-rbc1800avy99b..xn--9ob79ycx2e", .status = 26} /* 4870 */,
    {.source = (const lxb_char_t *) "\u200CΣ🃡⒗.\u0CC6仧\u0756", .ascii = (const lxb_char_t *) "xn--4xa595lz9czy52d.xn--9ob79ycx2e", .status = 24} /* 4871 */,
    {.source = (const lxb_char_t *) "\u200Cσ🃡⒗.\u0CC6仧\u0756", .ascii = (const lxb_char_t *) "xn--4xa595lz9czy52d.xn--9ob79ycx2e", .status = 24} /* 4872 */,
    {.source = (const lxb_char_t *) "xn--4xa229nbu92a.xn--9ob79ycx2e", .ascii = (const lxb_char_t *) "xn--4xa229nbu92a.xn--9ob79ycx2e", .status = 16} /* 4873 */,
    {.source = (const lxb_char_t *) "xn--4xa595lz9czy52d.xn--9ob79ycx2e", .ascii = (const lxb_char_t *) "xn--4xa595lz9czy52d.xn--9ob79ycx2e", .status = 24} /* 4874 */,
    {.source = (const lxb_char_t *) "xn--3xa795lz9czy52d.xn--9ob79ycx2e", .ascii = (const lxb_char_t *) "xn--3xa795lz9czy52d.xn--9ob79ycx2e", .status = 24} /* 4875 */,
    {.source = (const lxb_char_t *) "-.𞸚", .ascii = (const lxb_char_t *) "-.xn--3gb", .status = 8} /* 4876 */,
    {.source = (const lxb_char_t *) "-.\u0638", .ascii = (const lxb_char_t *) "-.xn--3gb", .status = 8} /* 4877 */,
    {.source = (const lxb_char_t *) "-.xn--3gb", .ascii = (const lxb_char_t *) "-.xn--3gb", .status = 8} /* 4878 */,
    {.source = (const lxb_char_t *) "򏛓\u0683.\u0F7E\u0634", .ascii = (const lxb_char_t *) "xn--8ib92728i.xn--zgb968b", .status = 20} /* 4879 */,
    {.source = (const lxb_char_t *) "xn--8ib92728i.xn--zgb968b", .ascii = (const lxb_char_t *) "xn--8ib92728i.xn--zgb968b", .status = 20} /* 4880 */,
    {.source = (const lxb_char_t *) "\u0FE6\u0843񽶬.𐮏", .ascii = (const lxb_char_t *) "xn--1vb320b5m04p.xn--m29c", .status = 8} /* 4881 */,
    {.source = (const lxb_char_t *) "xn--1vb320b5m04p.xn--m29c", .ascii = (const lxb_char_t *) "xn--1vb320b5m04p.xn--m29c", .status = 8} /* 4882 */,
    {.source = (const lxb_char_t *) "2񎨠\u07CBß。ᠽ", .ascii = (const lxb_char_t *) "xn--2-qfa924cez02l.xn--w7e", .status = 8} /* 4883 */,
    {.source = (const lxb_char_t *) "2񎨠\u07CBSS。ᠽ", .ascii = (const lxb_char_t *) "xn--2ss-odg83511n.xn--w7e", .status = 8} /* 4884 */,
    {.source = (const lxb_char_t *) "2񎨠\u07CBss。ᠽ", .ascii = (const lxb_char_t *) "xn--2ss-odg83511n.xn--w7e", .status = 8} /* 4885 */,
    {.source = (const lxb_char_t *) "xn--2ss-odg83511n.xn--w7e", .ascii = (const lxb_char_t *) "xn--2ss-odg83511n.xn--w7e", .status = 8} /* 4886 */,
    {.source = (const lxb_char_t *) "xn--2-qfa924cez02l.xn--w7e", .ascii = (const lxb_char_t *) "xn--2-qfa924cez02l.xn--w7e", .status = 8} /* 4887 */,
    {.source = (const lxb_char_t *) "2񎨠\u07CBSs。ᠽ", .ascii = (const lxb_char_t *) "xn--2ss-odg83511n.xn--w7e", .status = 8} /* 4888 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮．\u06CEß-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn----pfa076bys4a", .status = 20} /* 4889 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338．\u06CEß-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn----pfa076bys4a", .status = 20} /* 4890 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮.\u06CEß-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn----pfa076bys4a", .status = 20} /* 4891 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338.\u06CEß-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn----pfa076bys4a", .status = 20} /* 4892 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338.\u06CESS-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4893 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮.\u06CESS-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4894 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮.\u06CEss-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4895 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338.\u06CEss-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4896 */,
    {.source = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf", .status = 20} /* 4897 */,
    {.source = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4898 */,
    {.source = (const lxb_char_t *) "xn--lsb457kkut.xn----pfa076bys4a", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn----pfa076bys4a", .status = 20} /* 4899 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338．\u06CESS-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4900 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮．\u06CESS-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4901 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮．\u06CEss-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4902 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338．\u06CEss-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4903 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338.\u06CESs-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4904 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮.\u06CESs-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4905 */,
    {.source = (const lxb_char_t *) "㸳\u07CA<\u0338．\u06CESs-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4906 */,
    {.source = (const lxb_char_t *) "㸳\u07CA≮．\u06CESs-\u200D", .ascii = (const lxb_char_t *) "xn--lsb457kkut.xn--ss--qjf2343a", .status = 20} /* 4907 */,
    {.source = (const lxb_char_t *) "-򷝬\u135E𑜧.\u1DEB-︒", .ascii = (const lxb_char_t *) "xn----b5h1837n2ok9f.xn----mkmw278h", .status = 12} /* 4908 */,
    {.source = (const lxb_char_t *) "-򷝬\u135E𑜧.\u1DEB-。", .ascii = (const lxb_char_t *) "xn----b5h1837n2ok9f.xn----mkm.", .status = 12} /* 4909 */,
    {.source = (const lxb_char_t *) "xn----b5h1837n2ok9f.xn----mkm.", .ascii = (const lxb_char_t *) "xn----b5h1837n2ok9f.xn----mkm.", .status = 12} /* 4910 */,
    {.source = (const lxb_char_t *) "xn----b5h1837n2ok9f.xn----mkmw278h", .ascii = (const lxb_char_t *) "xn----b5h1837n2ok9f.xn----mkmw278h", .status = 12} /* 4911 */,
    {.source = (const lxb_char_t *) "︒.򚠡\u1A59", .ascii = (const lxb_char_t *) "xn--y86c.xn--cof61594i", .status = 4} /* 4912 */,
    {.source = (const lxb_char_t *) "。.򚠡\u1A59", .ascii = (const lxb_char_t *) "..xn--cof61594i", .status = 10} /* 4913 */,
    {.source = (const lxb_char_t *) "..xn--cof61594i", .ascii = (const lxb_char_t *) "..xn--cof61594i", .status = 10} /* 4914 */,
    {.source = (const lxb_char_t *) "xn--y86c.xn--cof61594i", .ascii = (const lxb_char_t *) "xn--y86c.xn--cof61594i", .status = 4} /* 4915 */,
    {.source = (const lxb_char_t *) "\u0323\u2DE1。\u200C⓾\u200C\u06B9", .ascii = (const lxb_char_t *) "xn--kta899s.xn--skb970ka771c", .status = 12} /* 4916 */,
    {.source = (const lxb_char_t *) "xn--kta899s.xn--skb116m", .ascii = (const lxb_char_t *) "xn--kta899s.xn--skb116m", .status = 8} /* 4917 */,
    {.source = (const lxb_char_t *) "xn--kta899s.xn--skb970ka771c", .ascii = (const lxb_char_t *) "xn--kta899s.xn--skb970ka771c", .status = 12} /* 4918 */,
    {.source = (const lxb_char_t *) "𞠶ᠴ\u06DD｡\u1074𞤵󠅦", .ascii = (const lxb_char_t *) "xn--tlb199fwl35a.xn--yld4613v", .status = 16} /* 4919 */,
    {.source = (const lxb_char_t *) "𞠶ᠴ\u06DD。\u1074𞤵󠅦", .ascii = (const lxb_char_t *) "xn--tlb199fwl35a.xn--yld4613v", .status = 16} /* 4920 */,
    {.source = (const lxb_char_t *) "𞠶ᠴ\u06DD。\u1074𞤓󠅦", .ascii = (const lxb_char_t *) "xn--tlb199fwl35a.xn--yld4613v", .status = 16} /* 4921 */,
    {.source = (const lxb_char_t *) "xn--tlb199fwl35a.xn--yld4613v", .ascii = (const lxb_char_t *) "xn--tlb199fwl35a.xn--yld4613v", .status = 16} /* 4922 */,
    {.source = (const lxb_char_t *) "𞠶ᠴ\u06DD｡\u1074𞤓󠅦", .ascii = (const lxb_char_t *) "xn--tlb199fwl35a.xn--yld4613v", .status = 16} /* 4923 */,
    {.source = (const lxb_char_t *) "𑰺.-򑟏", .ascii = (const lxb_char_t *) "xn--jk3d.xn----iz68g", .status = 12} /* 4924 */,
    {.source = (const lxb_char_t *) "xn--jk3d.xn----iz68g", .ascii = (const lxb_char_t *) "xn--jk3d.xn----iz68g", .status = 12} /* 4925 */,
    {.source = (const lxb_char_t *) "󠻩．赏", .ascii = (const lxb_char_t *) "xn--2856e.xn--6o3a", .status = 4} /* 4926 */,
    {.source = (const lxb_char_t *) "󠻩.赏", .ascii = (const lxb_char_t *) "xn--2856e.xn--6o3a", .status = 4} /* 4927 */,
    {.source = (const lxb_char_t *) "xn--2856e.xn--6o3a", .ascii = (const lxb_char_t *) "xn--2856e.xn--6o3a", .status = 4} /* 4928 */,
    {.source = (const lxb_char_t *) "\u06B0ᠡ｡Ⴁ", .ascii = (const lxb_char_t *) "xn--jkb440g.xn--8md", .status = 12} /* 4929 */,
    {.source = (const lxb_char_t *) "\u06B0ᠡ。Ⴁ", .ascii = (const lxb_char_t *) "xn--jkb440g.xn--8md", .status = 12} /* 4930 */,
    {.source = (const lxb_char_t *) "\u06B0ᠡ。ⴁ", .ascii = (const lxb_char_t *) "xn--jkb440g.xn--skj", .status = 8} /* 4931 */,
    {.source = (const lxb_char_t *) "xn--jkb440g.xn--skj", .ascii = (const lxb_char_t *) "xn--jkb440g.xn--skj", .status = 8} /* 4932 */,
    {.source = (const lxb_char_t *) "xn--jkb440g.xn--8md", .ascii = (const lxb_char_t *) "xn--jkb440g.xn--8md", .status = 12} /* 4933 */,
    {.source = (const lxb_char_t *) "\u06B0ᠡ｡ⴁ", .ascii = (const lxb_char_t *) "xn--jkb440g.xn--skj", .status = 8} /* 4934 */,
    {.source = (const lxb_char_t *) "\u20DEႪ\u06BBς｡-", .ascii = (const lxb_char_t *) "xn--3xa53m7zmb0q.-", .status = 16} /* 4935 */,
    {.source = (const lxb_char_t *) "\u20DEႪ\u06BBς。-", .ascii = (const lxb_char_t *) "xn--3xa53m7zmb0q.-", .status = 16} /* 4936 */,
    {.source = (const lxb_char_t *) "\u20DEⴊ\u06BBς。-", .ascii = (const lxb_char_t *) "xn--3xa53mr38aeel.-", .status = 12} /* 4937 */,
    {.source = (const lxb_char_t *) "\u20DEႪ\u06BBΣ。-", .ascii = (const lxb_char_t *) "xn--4xa33m7zmb0q.-", .status = 16} /* 4938 */,
    {.source = (const lxb_char_t *) "\u20DEⴊ\u06BBσ。-", .ascii = (const lxb_char_t *) "xn--4xa33mr38aeel.-", .status = 12} /* 4939 */,
    {.source = (const lxb_char_t *) "\u20DEႪ\u06BBσ。-", .ascii = (const lxb_char_t *) "xn--4xa33m7zmb0q.-", .status = 16} /* 4940 */,
    {.source = (const lxb_char_t *) "xn--4xa33m7zmb0q.-", .ascii = (const lxb_char_t *) "xn--4xa33m7zmb0q.-", .status = 16} /* 4941 */,
    {.source = (const lxb_char_t *) "xn--4xa33mr38aeel.-", .ascii = (const lxb_char_t *) "xn--4xa33mr38aeel.-", .status = 12} /* 4942 */,
    {.source = (const lxb_char_t *) "xn--3xa53mr38aeel.-", .ascii = (const lxb_char_t *) "xn--3xa53mr38aeel.-", .status = 12} /* 4943 */,
    {.source = (const lxb_char_t *) "xn--3xa53m7zmb0q.-", .ascii = (const lxb_char_t *) "xn--3xa53m7zmb0q.-", .status = 16} /* 4944 */,
    {.source = (const lxb_char_t *) "\u20DEⴊ\u06BBς｡-", .ascii = (const lxb_char_t *) "xn--3xa53mr38aeel.-", .status = 12} /* 4945 */,
    {.source = (const lxb_char_t *) "\u20DEႪ\u06BBΣ｡-", .ascii = (const lxb_char_t *) "xn--4xa33m7zmb0q.-", .status = 16} /* 4946 */,
    {.source = (const lxb_char_t *) "\u20DEⴊ\u06BBσ｡-", .ascii = (const lxb_char_t *) "xn--4xa33mr38aeel.-", .status = 12} /* 4947 */,
    {.source = (const lxb_char_t *) "\u20DEႪ\u06BBσ｡-", .ascii = (const lxb_char_t *) "xn--4xa33m7zmb0q.-", .status = 16} /* 4948 */,
    {.source = (const lxb_char_t *) "Ⴍ．񍇦\u200C", .ascii = (const lxb_char_t *) "xn--lnd.xn--0ug56448b", .status = 8} /* 4949 */,
    {.source = (const lxb_char_t *) "Ⴍ.񍇦\u200C", .ascii = (const lxb_char_t *) "xn--lnd.xn--0ug56448b", .status = 8} /* 4950 */,
    {.source = (const lxb_char_t *) "ⴍ.񍇦\u200C", .ascii = (const lxb_char_t *) "xn--4kj.xn--0ug56448b", .status = 8} /* 4951 */,
    {.source = (const lxb_char_t *) "xn--4kj.xn--p01x", .ascii = (const lxb_char_t *) "xn--4kj.xn--p01x", .status = 4} /* 4952 */,
    {.source = (const lxb_char_t *) "xn--4kj.xn--0ug56448b", .ascii = (const lxb_char_t *) "xn--4kj.xn--0ug56448b", .status = 8} /* 4953 */,
    {.source = (const lxb_char_t *) "xn--lnd.xn--p01x", .ascii = (const lxb_char_t *) "xn--lnd.xn--p01x", .status = 4} /* 4954 */,
    {.source = (const lxb_char_t *) "xn--lnd.xn--0ug56448b", .ascii = (const lxb_char_t *) "xn--lnd.xn--0ug56448b", .status = 8} /* 4955 */,
    {.source = (const lxb_char_t *) "ⴍ．񍇦\u200C", .ascii = (const lxb_char_t *) "xn--4kj.xn--0ug56448b", .status = 8} /* 4956 */,
    {.source = (const lxb_char_t *) "򉟂󠵣.𐫫\u1A60󴺖\u1B44", .ascii = (const lxb_char_t *) "xn--9u37blu98h.xn--jof13bt568cork1j", .status = 16} /* 4957 */,
    {.source = (const lxb_char_t *) "xn--9u37blu98h.xn--jof13bt568cork1j", .ascii = (const lxb_char_t *) "xn--9u37blu98h.xn--jof13bt568cork1j", .status = 16} /* 4958 */,
    {.source = (const lxb_char_t *) "≯❊ᠯ｡𐹱⺨", .ascii = (const lxb_char_t *) "xn--i7e163ct2d.xn--vwj7372e", .status = 4} /* 4959 */,
    {.source = (const lxb_char_t *) ">\u0338❊ᠯ｡𐹱⺨", .ascii = (const lxb_char_t *) "xn--i7e163ct2d.xn--vwj7372e", .status = 4} /* 4960 */,
    {.source = (const lxb_char_t *) "≯❊ᠯ。𐹱⺨", .ascii = (const lxb_char_t *) "xn--i7e163ct2d.xn--vwj7372e", .status = 4} /* 4961 */,
    {.source = (const lxb_char_t *) ">\u0338❊ᠯ。𐹱⺨", .ascii = (const lxb_char_t *) "xn--i7e163ct2d.xn--vwj7372e", .status = 4} /* 4962 */,
    {.source = (const lxb_char_t *) "xn--i7e163ct2d.xn--vwj7372e", .ascii = (const lxb_char_t *) "xn--i7e163ct2d.xn--vwj7372e", .status = 4} /* 4963 */,
    {.source = (const lxb_char_t *) "􁕜𐹧𞭁𐹩。Ⴈ𐫮Ⴏ", .ascii = (const lxb_char_t *) "xn--fo0de1270ope54j.xn--gndo2033q", .status = 12} /* 4964 */,
    {.source = (const lxb_char_t *) "􁕜𐹧𞭁𐹩。ⴈ𐫮ⴏ", .ascii = (const lxb_char_t *) "xn--fo0de1270ope54j.xn--zkjo0151o", .status = 12} /* 4965 */,
    {.source = (const lxb_char_t *) "xn--fo0de1270ope54j.xn--zkjo0151o", .ascii = (const lxb_char_t *) "xn--fo0de1270ope54j.xn--zkjo0151o", .status = 12} /* 4966 */,
    {.source = (const lxb_char_t *) "xn--fo0de1270ope54j.xn--gndo2033q", .ascii = (const lxb_char_t *) "xn--fo0de1270ope54j.xn--gndo2033q", .status = 12} /* 4967 */,
    {.source = (const lxb_char_t *) "𞠂。\uA926", .ascii = (const lxb_char_t *) "xn--145h.xn--ti9a", .status = 8} /* 4968 */,
    {.source = (const lxb_char_t *) "xn--145h.xn--ti9a", .ascii = (const lxb_char_t *) "xn--145h.xn--ti9a", .status = 8} /* 4969 */,
    {.source = (const lxb_char_t *) "𝟔𐹫．\u0733\u1037９ꡇ", .ascii = (const lxb_char_t *) "xn--6-t26i.xn--9-91c730e8u8n", .status = 8} /* 4970 */,
    {.source = (const lxb_char_t *) "𝟔𐹫．\u1037\u0733９ꡇ", .ascii = (const lxb_char_t *) "xn--6-t26i.xn--9-91c730e8u8n", .status = 8} /* 4971 */,
    {.source = (const lxb_char_t *) "6𐹫.\u1037\u07339ꡇ", .ascii = (const lxb_char_t *) "xn--6-t26i.xn--9-91c730e8u8n", .status = 8} /* 4972 */,
    {.source = (const lxb_char_t *) "xn--6-t26i.xn--9-91c730e8u8n", .ascii = (const lxb_char_t *) "xn--6-t26i.xn--9-91c730e8u8n", .status = 8} /* 4973 */,
    {.source = (const lxb_char_t *) "\u0724\u0603𞲶．\u06D8", .ascii = (const lxb_char_t *) "xn--lfb19ct414i.xn--olb", .status = 12} /* 4974 */,
    {.source = (const lxb_char_t *) "\u0724\u0603𞲶.\u06D8", .ascii = (const lxb_char_t *) "xn--lfb19ct414i.xn--olb", .status = 12} /* 4975 */,
    {.source = (const lxb_char_t *) "xn--lfb19ct414i.xn--olb", .ascii = (const lxb_char_t *) "xn--lfb19ct414i.xn--olb", .status = 12} /* 4976 */,
    {.source = (const lxb_char_t *) "✆񱔩ꡋ．\u0632\u200D𞣴", .ascii = (const lxb_char_t *) "xn--1biv525bcix0d.xn--xgb253k0m73a", .status = 12} /* 4977 */,
    {.source = (const lxb_char_t *) "✆񱔩ꡋ.\u0632\u200D𞣴", .ascii = (const lxb_char_t *) "xn--1biv525bcix0d.xn--xgb253k0m73a", .status = 12} /* 4978 */,
    {.source = (const lxb_char_t *) "xn--1biv525bcix0d.xn--xgb6828v", .ascii = (const lxb_char_t *) "xn--1biv525bcix0d.xn--xgb6828v", .status = 8} /* 4979 */,
    {.source = (const lxb_char_t *) "xn--1biv525bcix0d.xn--xgb253k0m73a", .ascii = (const lxb_char_t *) "xn--1biv525bcix0d.xn--xgb253k0m73a", .status = 12} /* 4980 */,
    {.source = (const lxb_char_t *) "\u0845񃾰𞸍-．≠򃁟𑋪", .ascii = (const lxb_char_t *) "xn----qoc64my971s.xn--1ch7585g76o3c", .status = 20} /* 4981 */,
    {.source = (const lxb_char_t *) "\u0845񃾰𞸍-．=\u0338򃁟𑋪", .ascii = (const lxb_char_t *) "xn----qoc64my971s.xn--1ch7585g76o3c", .status = 20} /* 4982 */,
    {.source = (const lxb_char_t *) "\u0845񃾰\u0646-.≠򃁟𑋪", .ascii = (const lxb_char_t *) "xn----qoc64my971s.xn--1ch7585g76o3c", .status = 20} /* 4983 */,
    {.source = (const lxb_char_t *) "\u0845񃾰\u0646-.=\u0338򃁟𑋪", .ascii = (const lxb_char_t *) "xn----qoc64my971s.xn--1ch7585g76o3c", .status = 20} /* 4984 */,
    {.source = (const lxb_char_t *) "xn----qoc64my971s.xn--1ch7585g76o3c", .ascii = (const lxb_char_t *) "xn----qoc64my971s.xn--1ch7585g76o3c", .status = 20} /* 4985 */,
    {.source = (const lxb_char_t *) "𝟛．笠", .ascii = (const lxb_char_t *) "3.xn--6vz", .status = 0} /* 4986 */,
    {.source = (const lxb_char_t *) "𝟛．笠", .ascii = (const lxb_char_t *) "3.xn--6vz", .status = 0} /* 4987 */,
    {.source = (const lxb_char_t *) "3.笠", .ascii = (const lxb_char_t *) "3.xn--6vz", .status = 0} /* 4988 */,
    {.source = (const lxb_char_t *) "3.xn--6vz", .ascii = (const lxb_char_t *) "3.xn--6vz", .status = 0} /* 4989 */,
    {.source = (const lxb_char_t *) "-\u200D.Ⴞ𐋷", .ascii = (const lxb_char_t *) "xn----ugn.xn--2nd2315j", .status = 12} /* 4990 */,
    {.source = (const lxb_char_t *) "-\u200D.ⴞ𐋷", .ascii = (const lxb_char_t *) "xn----ugn.xn--mlj8559d", .status = 8} /* 4991 */,
    {.source = (const lxb_char_t *) "-.xn--mlj8559d", .ascii = (const lxb_char_t *) "-.xn--mlj8559d", .status = 4} /* 4992 */,
    {.source = (const lxb_char_t *) "xn----ugn.xn--mlj8559d", .ascii = (const lxb_char_t *) "xn----ugn.xn--mlj8559d", .status = 8} /* 4993 */,
    {.source = (const lxb_char_t *) "-.xn--2nd2315j", .ascii = (const lxb_char_t *) "-.xn--2nd2315j", .status = 8} /* 4994 */,
    {.source = (const lxb_char_t *) "xn----ugn.xn--2nd2315j", .ascii = (const lxb_char_t *) "xn----ugn.xn--2nd2315j", .status = 12} /* 4995 */,
    {.source = (const lxb_char_t *) "\u200Dςß\u0731．\u0BCD", .ascii = (const lxb_char_t *) "xn--zca19ln1di19a.xn--xmc", .status = 8} /* 4996 */,
    {.source = (const lxb_char_t *) "\u200Dςß\u0731.\u0BCD", .ascii = (const lxb_char_t *) "xn--zca19ln1di19a.xn--xmc", .status = 8} /* 4997 */,
    {.source = (const lxb_char_t *) "\u200DΣSS\u0731.\u0BCD", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 4998 */,
    {.source = (const lxb_char_t *) "\u200Dσss\u0731.\u0BCD", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 4999 */,
    {.source = (const lxb_char_t *) "\u200DΣss\u0731.\u0BCD", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 5000 */,
    {.source = (const lxb_char_t *) "xn--ss-ubc826a.xn--xmc", .ascii = (const lxb_char_t *) "xn--ss-ubc826a.xn--xmc", .status = 4} /* 5001 */,
    {.source = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 5002 */,
    {.source = (const lxb_char_t *) "\u200DΣß\u0731.\u0BCD", .ascii = (const lxb_char_t *) "xn--zca39lk1di19a.xn--xmc", .status = 8} /* 5003 */,
    {.source = (const lxb_char_t *) "\u200Dσß\u0731.\u0BCD", .ascii = (const lxb_char_t *) "xn--zca39lk1di19a.xn--xmc", .status = 8} /* 5004 */,
    {.source = (const lxb_char_t *) "xn--zca39lk1di19a.xn--xmc", .ascii = (const lxb_char_t *) "xn--zca39lk1di19a.xn--xmc", .status = 8} /* 5005 */,
    {.source = (const lxb_char_t *) "xn--zca19ln1di19a.xn--xmc", .ascii = (const lxb_char_t *) "xn--zca19ln1di19a.xn--xmc", .status = 8} /* 5006 */,
    {.source = (const lxb_char_t *) "\u200DΣSS\u0731．\u0BCD", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 5007 */,
    {.source = (const lxb_char_t *) "\u200Dσss\u0731．\u0BCD", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 5008 */,
    {.source = (const lxb_char_t *) "\u200DΣss\u0731．\u0BCD", .ascii = (const lxb_char_t *) "xn--ss-ubc826ab34b.xn--xmc", .status = 8} /* 5009 */,
    {.source = (const lxb_char_t *) "\u200DΣß\u0731．\u0BCD", .ascii = (const lxb_char_t *) "xn--zca39lk1di19a.xn--xmc", .status = 8} /* 5010 */,
    {.source = (const lxb_char_t *) "\u200Dσß\u0731．\u0BCD", .ascii = (const lxb_char_t *) "xn--zca39lk1di19a.xn--xmc", .status = 8} /* 5011 */,
    {.source = (const lxb_char_t *) "≠．\u200D", .ascii = (const lxb_char_t *) "xn--1ch.xn--1ug", .status = 4} /* 5012 */,
    {.source = (const lxb_char_t *) "=\u0338．\u200D", .ascii = (const lxb_char_t *) "xn--1ch.xn--1ug", .status = 4} /* 5013 */,
    {.source = (const lxb_char_t *) "≠.\u200D", .ascii = (const lxb_char_t *) "xn--1ch.xn--1ug", .status = 4} /* 5014 */,
    {.source = (const lxb_char_t *) "=\u0338.\u200D", .ascii = (const lxb_char_t *) "xn--1ch.xn--1ug", .status = 4} /* 5015 */,
    {.source = (const lxb_char_t *) "xn--1ch.", .ascii = (const lxb_char_t *) "xn--1ch.", .status = 0} /* 5016 */,
    {.source = (const lxb_char_t *) "≠.", .ascii = (const lxb_char_t *) "xn--1ch.", .status = 0} /* 5017 */,
    {.source = (const lxb_char_t *) "=\u0338.", .ascii = (const lxb_char_t *) "xn--1ch.", .status = 0} /* 5018 */,
    {.source = (const lxb_char_t *) "xn--1ch.xn--1ug", .ascii = (const lxb_char_t *) "xn--1ch.xn--1ug", .status = 4} /* 5019 */,
    {.source = (const lxb_char_t *) "\uFC01｡\u0C81ᠼ▗򒁋", .ascii = (const lxb_char_t *) "xn--lgbo.xn--2rc021dcxkrx55t", .status = 12} /* 5020 */,
    {.source = (const lxb_char_t *) "\u0626\u062D。\u0C81ᠼ▗򒁋", .ascii = (const lxb_char_t *) "xn--lgbo.xn--2rc021dcxkrx55t", .status = 12} /* 5021 */,
    {.source = (const lxb_char_t *) "\u064A\u0654\u062D。\u0C81ᠼ▗򒁋", .ascii = (const lxb_char_t *) "xn--lgbo.xn--2rc021dcxkrx55t", .status = 12} /* 5022 */,
    {.source = (const lxb_char_t *) "xn--lgbo.xn--2rc021dcxkrx55t", .ascii = (const lxb_char_t *) "xn--lgbo.xn--2rc021dcxkrx55t", .status = 12} /* 5023 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDς．ς𐨿", .ascii = (const lxb_char_t *) "xn--3xa702av8297a.xn--3xa8055k", .status = 4} /* 5024 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDς.ς𐨿", .ascii = (const lxb_char_t *) "xn--3xa702av8297a.xn--3xa8055k", .status = 4} /* 5025 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDΣ.Σ𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5026 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDσ.ς𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--3xa8055k", .status = 4} /* 5027 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDσ.σ𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5028 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDΣ.σ𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5029 */,
    {.source = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5030 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDΣ.ς𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--3xa8055k", .status = 4} /* 5031 */,
    {.source = (const lxb_char_t *) "xn--4xa502av8297a.xn--3xa8055k", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--3xa8055k", .status = 4} /* 5032 */,
    {.source = (const lxb_char_t *) "xn--3xa702av8297a.xn--3xa8055k", .ascii = (const lxb_char_t *) "xn--3xa702av8297a.xn--3xa8055k", .status = 4} /* 5033 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDΣ．Σ𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5034 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDσ．ς𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--3xa8055k", .status = 4} /* 5035 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDσ．σ𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5036 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDΣ．σ𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--4xa6055k", .status = 4} /* 5037 */,
    {.source = (const lxb_char_t *) "󧋵\u09CDΣ．ς𐨿", .ascii = (const lxb_char_t *) "xn--4xa502av8297a.xn--3xa8055k", .status = 4} /* 5038 */,
    {.source = (const lxb_char_t *) "𐫓\u07D8牅\u08F8｡𞦤\u1A17򱍰Ⴙ", .ascii = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--xnd909bv540bm5k9d", .status = 12} /* 5039 */,
    {.source = (const lxb_char_t *) "𐫓\u07D8牅\u08F8。𞦤\u1A17򱍰Ⴙ", .ascii = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--xnd909bv540bm5k9d", .status = 12} /* 5040 */,
    {.source = (const lxb_char_t *) "𐫓\u07D8牅\u08F8。𞦤\u1A17򱍰ⴙ", .ascii = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--gmf469fr883am5r1e", .status = 12} /* 5041 */,
    {.source = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--gmf469fr883am5r1e", .ascii = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--gmf469fr883am5r1e", .status = 12} /* 5042 */,
    {.source = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--xnd909bv540bm5k9d", .ascii = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--xnd909bv540bm5k9d", .status = 12} /* 5043 */,
    {.source = (const lxb_char_t *) "𐫓\u07D8牅\u08F8｡𞦤\u1A17򱍰ⴙ", .ascii = (const lxb_char_t *) "xn--zsb09cu46vjs6f.xn--gmf469fr883am5r1e", .status = 12} /* 5044 */,
    {.source = (const lxb_char_t *) "񣤒｡륧", .ascii = (const lxb_char_t *) "xn--s264a.xn--pw2b", .status = 4} /* 5045 */,
    {.source = (const lxb_char_t *) "񣤒｡륧", .ascii = (const lxb_char_t *) "xn--s264a.xn--pw2b", .status = 4} /* 5046 */,
    {.source = (const lxb_char_t *) "񣤒。륧", .ascii = (const lxb_char_t *) "xn--s264a.xn--pw2b", .status = 4} /* 5047 */,
    {.source = (const lxb_char_t *) "񣤒。륧", .ascii = (const lxb_char_t *) "xn--s264a.xn--pw2b", .status = 4} /* 5048 */,
    {.source = (const lxb_char_t *) "xn--s264a.xn--pw2b", .ascii = (const lxb_char_t *) "xn--s264a.xn--pw2b", .status = 4} /* 5049 */,
    {.source = (const lxb_char_t *) "𐹷\u200D。󉵢", .ascii = (const lxb_char_t *) "xn--1ugx205g.xn--8088d", .status = 12} /* 5050 */,
    {.source = (const lxb_char_t *) "xn--vo0d.xn--8088d", .ascii = (const lxb_char_t *) "xn--vo0d.xn--8088d", .status = 8} /* 5051 */,
    {.source = (const lxb_char_t *) "xn--1ugx205g.xn--8088d", .ascii = (const lxb_char_t *) "xn--1ugx205g.xn--8088d", .status = 12} /* 5052 */,
    {.source = (const lxb_char_t *) "Ⴘ\u06C2𑲭｡-", .ascii = (const lxb_char_t *) "xn--1kb312c139t.-", .status = 20} /* 5053 */,
    {.source = (const lxb_char_t *) "Ⴘ\u06C1\u0654𑲭｡-", .ascii = (const lxb_char_t *) "xn--1kb312c139t.-", .status = 20} /* 5054 */,
    {.source = (const lxb_char_t *) "Ⴘ\u06C2𑲭。-", .ascii = (const lxb_char_t *) "xn--1kb312c139t.-", .status = 20} /* 5055 */,
    {.source = (const lxb_char_t *) "Ⴘ\u06C1\u0654𑲭。-", .ascii = (const lxb_char_t *) "xn--1kb312c139t.-", .status = 20} /* 5056 */,
    {.source = (const lxb_char_t *) "ⴘ\u06C1\u0654𑲭。-", .ascii = (const lxb_char_t *) "xn--1kb147qfk3n.-", .status = 16} /* 5057 */,
    {.source = (const lxb_char_t *) "ⴘ\u06C2𑲭。-", .ascii = (const lxb_char_t *) "xn--1kb147qfk3n.-", .status = 16} /* 5058 */,
    {.source = (const lxb_char_t *) "xn--1kb147qfk3n.-", .ascii = (const lxb_char_t *) "xn--1kb147qfk3n.-", .status = 16} /* 5059 */,
    {.source = (const lxb_char_t *) "xn--1kb312c139t.-", .ascii = (const lxb_char_t *) "xn--1kb312c139t.-", .status = 20} /* 5060 */,
    {.source = (const lxb_char_t *) "ⴘ\u06C1\u0654𑲭｡-", .ascii = (const lxb_char_t *) "xn--1kb147qfk3n.-", .status = 16} /* 5061 */,
    {.source = (const lxb_char_t *) "ⴘ\u06C2𑲭｡-", .ascii = (const lxb_char_t *) "xn--1kb147qfk3n.-", .status = 16} /* 5062 */,
    {.source = (const lxb_char_t *) "\uA806\u067B₆ᡐ。🛇\uFCDD", .ascii = (const lxb_char_t *) "xn--6-rrc018krt9k.xn--hhbj61429a", .status = 8} /* 5063 */,
    {.source = (const lxb_char_t *) "\uA806\u067B6ᡐ。🛇\u064A\u0645", .ascii = (const lxb_char_t *) "xn--6-rrc018krt9k.xn--hhbj61429a", .status = 8} /* 5064 */,
    {.source = (const lxb_char_t *) "xn--6-rrc018krt9k.xn--hhbj61429a", .ascii = (const lxb_char_t *) "xn--6-rrc018krt9k.xn--hhbj61429a", .status = 8} /* 5065 */,
    {.source = (const lxb_char_t *) "򸍂.㇄ᡟ𐫂\u0622", .ascii = (const lxb_char_t *) "xn--p292d.xn--hgb154ghrsvm2r", .status = 8} /* 5066 */,
    {.source = (const lxb_char_t *) "򸍂.㇄ᡟ𐫂\u0627\u0653", .ascii = (const lxb_char_t *) "xn--p292d.xn--hgb154ghrsvm2r", .status = 8} /* 5067 */,
    {.source = (const lxb_char_t *) "xn--p292d.xn--hgb154ghrsvm2r", .ascii = (const lxb_char_t *) "xn--p292d.xn--hgb154ghrsvm2r", .status = 8} /* 5068 */,
    {.source = (const lxb_char_t *) "\u07DF򵚌。-\u07E9", .ascii = (const lxb_char_t *) "xn--6sb88139l.xn----pdd", .status = 20} /* 5069 */,
    {.source = (const lxb_char_t *) "xn--6sb88139l.xn----pdd", .ascii = (const lxb_char_t *) "xn--6sb88139l.xn----pdd", .status = 20} /* 5070 */,
    {.source = (const lxb_char_t *) "ς\u0643⾑．\u200Cᢟ\u200C⒈", .ascii = (const lxb_char_t *) "xn--3xa69jux8r.xn--pbf519aba607b", .status = 16} /* 5071 */,
    {.source = (const lxb_char_t *) "ς\u0643襾.\u200Cᢟ\u200C1.", .ascii = (const lxb_char_t *) "xn--3xa69jux8r.xn--1-4ck691bba.", .status = 12} /* 5072 */,
    {.source = (const lxb_char_t *) "Σ\u0643襾.\u200Cᢟ\u200C1.", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--1-4ck691bba.", .status = 12} /* 5073 */,
    {.source = (const lxb_char_t *) "σ\u0643襾.\u200Cᢟ\u200C1.", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--1-4ck691bba.", .status = 12} /* 5074 */,
    {.source = (const lxb_char_t *) "xn--4xa49jux8r.xn--1-4ck.", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--1-4ck.", .status = 4} /* 5075 */,
    {.source = (const lxb_char_t *) "xn--4xa49jux8r.xn--1-4ck691bba.", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--1-4ck691bba.", .status = 12} /* 5076 */,
    {.source = (const lxb_char_t *) "xn--3xa69jux8r.xn--1-4ck691bba.", .ascii = (const lxb_char_t *) "xn--3xa69jux8r.xn--1-4ck691bba.", .status = 12} /* 5077 */,
    {.source = (const lxb_char_t *) "Σ\u0643⾑．\u200Cᢟ\u200C⒈", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--pbf519aba607b", .status = 16} /* 5078 */,
    {.source = (const lxb_char_t *) "σ\u0643⾑．\u200Cᢟ\u200C⒈", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--pbf519aba607b", .status = 16} /* 5079 */,
    {.source = (const lxb_char_t *) "xn--4xa49jux8r.xn--pbf212d", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--pbf212d", .status = 8} /* 5080 */,
    {.source = (const lxb_char_t *) "xn--4xa49jux8r.xn--pbf519aba607b", .ascii = (const lxb_char_t *) "xn--4xa49jux8r.xn--pbf519aba607b", .status = 16} /* 5081 */,
    {.source = (const lxb_char_t *) "xn--3xa69jux8r.xn--pbf519aba607b", .ascii = (const lxb_char_t *) "xn--3xa69jux8r.xn--pbf519aba607b", .status = 16} /* 5082 */,
    {.source = (const lxb_char_t *) "ᡆ𑓝．𞵆", .ascii = (const lxb_char_t *) "xn--57e0440k.xn--k86h", .status = 4} /* 5083 */,
    {.source = (const lxb_char_t *) "ᡆ𑓝.𞵆", .ascii = (const lxb_char_t *) "xn--57e0440k.xn--k86h", .status = 4} /* 5084 */,
    {.source = (const lxb_char_t *) "xn--57e0440k.xn--k86h", .ascii = (const lxb_char_t *) "xn--57e0440k.xn--k86h", .status = 4} /* 5085 */,
    {.source = (const lxb_char_t *) "\u0A4D𦍓\u1DEE｡\u200C\u08BD񝹲", .ascii = (const lxb_char_t *) "xn--ybc461hph93b.xn--jzb740j1y45h", .status = 16} /* 5086 */,
    {.source = (const lxb_char_t *) "\u0A4D𦍓\u1DEE。\u200C\u08BD񝹲", .ascii = (const lxb_char_t *) "xn--ybc461hph93b.xn--jzb740j1y45h", .status = 16} /* 5087 */,
    {.source = (const lxb_char_t *) "xn--ybc461hph93b.xn--jzb29857e", .ascii = (const lxb_char_t *) "xn--ybc461hph93b.xn--jzb29857e", .status = 20} /* 5088 */,
    {.source = (const lxb_char_t *) "xn--ybc461hph93b.xn--jzb740j1y45h", .ascii = (const lxb_char_t *) "xn--ybc461hph93b.xn--jzb740j1y45h", .status = 16} /* 5089 */,
    {.source = (const lxb_char_t *) "\u062E\u0748񅪪-．\u200C먿", .ascii = (const lxb_char_t *) "xn----dnc06f42153a.xn--0ug1581d", .status = 24} /* 5090 */,
    {.source = (const lxb_char_t *) "\u062E\u0748񅪪-．\u200C먿", .ascii = (const lxb_char_t *) "xn----dnc06f42153a.xn--0ug1581d", .status = 24} /* 5091 */,
    {.source = (const lxb_char_t *) "\u062E\u0748񅪪-.\u200C먿", .ascii = (const lxb_char_t *) "xn----dnc06f42153a.xn--0ug1581d", .status = 24} /* 5092 */,
    {.source = (const lxb_char_t *) "\u062E\u0748񅪪-.\u200C먿", .ascii = (const lxb_char_t *) "xn----dnc06f42153a.xn--0ug1581d", .status = 24} /* 5093 */,
    {.source = (const lxb_char_t *) "xn----dnc06f42153a.xn--v22b", .ascii = (const lxb_char_t *) "xn----dnc06f42153a.xn--v22b", .status = 16} /* 5094 */,
    {.source = (const lxb_char_t *) "xn----dnc06f42153a.xn--0ug1581d", .ascii = (const lxb_char_t *) "xn----dnc06f42153a.xn--0ug1581d", .status = 24} /* 5095 */,
    {.source = (const lxb_char_t *) "􋿦｡ᠽ", .ascii = (const lxb_char_t *) "xn--j890g.xn--w7e", .status = 4} /* 5096 */,
    {.source = (const lxb_char_t *) "􋿦。ᠽ", .ascii = (const lxb_char_t *) "xn--j890g.xn--w7e", .status = 4} /* 5097 */,
    {.source = (const lxb_char_t *) "xn--j890g.xn--w7e", .ascii = (const lxb_char_t *) "xn--j890g.xn--w7e", .status = 4} /* 5098 */,
    {.source = (const lxb_char_t *) "嬃𝍌．\u200D\u0B44", .ascii = (const lxb_char_t *) "xn--b6s0078f.xn--0ic557h", .status = 4} /* 5099 */,
    {.source = (const lxb_char_t *) "嬃𝍌.\u200D\u0B44", .ascii = (const lxb_char_t *) "xn--b6s0078f.xn--0ic557h", .status = 4} /* 5100 */,
    {.source = (const lxb_char_t *) "xn--b6s0078f.xn--0ic", .ascii = (const lxb_char_t *) "xn--b6s0078f.xn--0ic", .status = 4} /* 5101 */,
    {.source = (const lxb_char_t *) "xn--b6s0078f.xn--0ic557h", .ascii = (const lxb_char_t *) "xn--b6s0078f.xn--0ic557h", .status = 4} /* 5102 */,
    {.source = (const lxb_char_t *) "\u0602𝌪≯．𚋲򵁨", .ascii = (const lxb_char_t *) "xn--kfb866llx01a.xn--wp1gm3570b", .status = 8} /* 5103 */,
    {.source = (const lxb_char_t *) "\u0602𝌪>\u0338．𚋲򵁨", .ascii = (const lxb_char_t *) "xn--kfb866llx01a.xn--wp1gm3570b", .status = 8} /* 5104 */,
    {.source = (const lxb_char_t *) "\u0602𝌪≯.𚋲򵁨", .ascii = (const lxb_char_t *) "xn--kfb866llx01a.xn--wp1gm3570b", .status = 8} /* 5105 */,
    {.source = (const lxb_char_t *) "\u0602𝌪>\u0338.𚋲򵁨", .ascii = (const lxb_char_t *) "xn--kfb866llx01a.xn--wp1gm3570b", .status = 8} /* 5106 */,
    {.source = (const lxb_char_t *) "xn--kfb866llx01a.xn--wp1gm3570b", .ascii = (const lxb_char_t *) "xn--kfb866llx01a.xn--wp1gm3570b", .status = 8} /* 5107 */,
    {.source = (const lxb_char_t *) "򫾥\u08B7\u17CC\uA9C0.𞼠", .ascii = (const lxb_char_t *) "xn--dzb638ewm4i1iy1h.xn--3m7h", .status = 8} /* 5108 */,
    {.source = (const lxb_char_t *) "xn--dzb638ewm4i1iy1h.xn--3m7h", .ascii = (const lxb_char_t *) "xn--dzb638ewm4i1iy1h.xn--3m7h", .status = 8} /* 5109 */,
    {.source = (const lxb_char_t *) "\u200C.񟛤", .ascii = (const lxb_char_t *) "xn--0ug.xn--q823a", .status = 8} /* 5110 */,
    {.source = (const lxb_char_t *) ".xn--q823a", .ascii = (const lxb_char_t *) ".xn--q823a", .status = 10} /* 5111 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--q823a", .ascii = (const lxb_char_t *) "xn--0ug.xn--q823a", .status = 8} /* 5112 */,
    {.source = (const lxb_char_t *) "򺛕Ⴃ䠅．𐸑", .ascii = (const lxb_char_t *) "xn--bnd074zr557n.xn--yl0d", .status = 4} /* 5113 */,
    {.source = (const lxb_char_t *) "򺛕Ⴃ䠅.𐸑", .ascii = (const lxb_char_t *) "xn--bnd074zr557n.xn--yl0d", .status = 4} /* 5114 */,
    {.source = (const lxb_char_t *) "򺛕ⴃ䠅.𐸑", .ascii = (const lxb_char_t *) "xn--ukju77frl47r.xn--yl0d", .status = 4} /* 5115 */,
    {.source = (const lxb_char_t *) "xn--ukju77frl47r.xn--yl0d", .ascii = (const lxb_char_t *) "xn--ukju77frl47r.xn--yl0d", .status = 4} /* 5116 */,
    {.source = (const lxb_char_t *) "xn--bnd074zr557n.xn--yl0d", .ascii = (const lxb_char_t *) "xn--bnd074zr557n.xn--yl0d", .status = 4} /* 5117 */,
    {.source = (const lxb_char_t *) "򺛕ⴃ䠅．𐸑", .ascii = (const lxb_char_t *) "xn--ukju77frl47r.xn--yl0d", .status = 4} /* 5118 */,
    {.source = (const lxb_char_t *) "\u1BF1𐹳𐹵𞤚｡𝟨Ⴅ", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-h0g", .status = 12} /* 5119 */,
    {.source = (const lxb_char_t *) "\u1BF1𐹳𐹵𞤚。6Ⴅ", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-h0g", .status = 12} /* 5120 */,
    {.source = (const lxb_char_t *) "\u1BF1𐹳𐹵𞤼。6ⴅ", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-kvs", .status = 8} /* 5121 */,
    {.source = (const lxb_char_t *) "\u1BF1𐹳𐹵𞤚。6ⴅ", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-kvs", .status = 8} /* 5122 */,
    {.source = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-kvs", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-kvs", .status = 8} /* 5123 */,
    {.source = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-h0g", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-h0g", .status = 12} /* 5124 */,
    {.source = (const lxb_char_t *) "\u1BF1𐹳𐹵𞤼｡𝟨ⴅ", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-kvs", .status = 8} /* 5125 */,
    {.source = (const lxb_char_t *) "\u1BF1𐹳𐹵𞤚｡𝟨ⴅ", .ascii = (const lxb_char_t *) "xn--zzfy954hga2415t.xn--6-kvs", .status = 8} /* 5126 */,
    {.source = (const lxb_char_t *) "-｡︒", .ascii = (const lxb_char_t *) "-.xn--y86c", .status = 8} /* 5127 */,
    {.source = (const lxb_char_t *) "-。。", .ascii = (const lxb_char_t *) "-..", .status = 10} /* 5128 */,
    {.source = (const lxb_char_t *) "-..", .ascii = (const lxb_char_t *) "-..", .status = 10} /* 5129 */,
    {.source = (const lxb_char_t *) "-.xn--y86c", .ascii = (const lxb_char_t *) "-.xn--y86c", .status = 8} /* 5130 */,
    {.source = (const lxb_char_t *) "\u07DBჀ｡-⁵--", .ascii = (const lxb_char_t *) "xn--2sb866b.-5--", .status = 24} /* 5131 */,
    {.source = (const lxb_char_t *) "\u07DBჀ。-5--", .ascii = (const lxb_char_t *) "xn--2sb866b.-5--", .status = 24} /* 5132 */,
    {.source = (const lxb_char_t *) "\u07DBⴠ。-5--", .ascii = (const lxb_char_t *) "xn--2sb691q.-5--", .status = 20} /* 5133 */,
    {.source = (const lxb_char_t *) "xn--2sb691q.-5--", .ascii = (const lxb_char_t *) "xn--2sb691q.-5--", .status = 20} /* 5134 */,
    {.source = (const lxb_char_t *) "xn--2sb866b.-5--", .ascii = (const lxb_char_t *) "xn--2sb866b.-5--", .status = 24} /* 5135 */,
    {.source = (const lxb_char_t *) "\u07DBⴠ｡-⁵--", .ascii = (const lxb_char_t *) "xn--2sb691q.-5--", .status = 20} /* 5136 */,
    {.source = (const lxb_char_t *) "≯?󠑕｡𐹷𐹻≯𐷒", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5137 */,
    {.source = (const lxb_char_t *) ">\u0338?󠑕｡𐹷𐹻>\u0338𐷒", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5138 */,
    {.source = (const lxb_char_t *) "≯?󠑕。𐹷𐹻≯𐷒", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5139 */,
    {.source = (const lxb_char_t *) ">\u0338?󠑕。𐹷𐹻>\u0338𐷒", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5140 */,
    {.source = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5141 */,
    {.source = (const lxb_char_t *) "≯?󠑕.xn--hdh8283gdoaqa", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5142 */,
    {.source = (const lxb_char_t *) ">\u0338?󠑕.xn--hdh8283gdoaqa", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5143 */,
    {.source = (const lxb_char_t *) ">\u0338?󠑕.XN--HDH8283GDOAQA", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5144 */,
    {.source = (const lxb_char_t *) "≯?󠑕.XN--HDH8283GDOAQA", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5145 */,
    {.source = (const lxb_char_t *) "≯?󠑕.Xn--Hdh8283gdoaqa", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5146 */,
    {.source = (const lxb_char_t *) ">\u0338?󠑕.Xn--Hdh8283gdoaqa", .ascii = (const lxb_char_t *) "xn--?-ogo25661n.xn--hdh8283gdoaqa", .status = 8} /* 5147 */,
    {.source = (const lxb_char_t *) "㍔\u08E6\u077C\u200D。\u0346򁳊𝅶\u0604", .ascii = (const lxb_char_t *) "xn--dqb73ec22c9kp8cb1j.xn--kua81ls548d3608b", .status = 24} /* 5148 */,
    {.source = (const lxb_char_t *) "ルーブル\u08E6\u077C\u200D。\u0346򁳊𝅶\u0604", .ascii = (const lxb_char_t *) "xn--dqb73ec22c9kp8cb1j.xn--kua81ls548d3608b", .status = 24} /* 5149 */,
    {.source = (const lxb_char_t *) "ルーフ\u3099ル\u08E6\u077C\u200D。\u0346򁳊𝅶\u0604", .ascii = (const lxb_char_t *) "xn--dqb73ec22c9kp8cb1j.xn--kua81ls548d3608b", .status = 24} /* 5150 */,
    {.source = (const lxb_char_t *) "xn--dqb73el09fncab4h.xn--kua81ls548d3608b", .ascii = (const lxb_char_t *) "xn--dqb73el09fncab4h.xn--kua81ls548d3608b", .status = 20} /* 5151 */,
    {.source = (const lxb_char_t *) "xn--dqb73ec22c9kp8cb1j.xn--kua81ls548d3608b", .ascii = (const lxb_char_t *) "xn--dqb73ec22c9kp8cb1j.xn--kua81ls548d3608b", .status = 24} /* 5152 */,
    {.source = (const lxb_char_t *) "\u200D.F", .ascii = (const lxb_char_t *) "xn--1ug.f", .status = 4} /* 5153 */,
    {.source = (const lxb_char_t *) "\u200D.f", .ascii = (const lxb_char_t *) "xn--1ug.f", .status = 4} /* 5154 */,
    {.source = (const lxb_char_t *) ".f", .ascii = (const lxb_char_t *) ".f", .status = 6} /* 5155 */,
    {.source = (const lxb_char_t *) "xn--1ug.f", .ascii = (const lxb_char_t *) "xn--1ug.f", .status = 4} /* 5156 */,
    {.source = (const lxb_char_t *) "f", .ascii = (const lxb_char_t *) "f", .status = 0} /* 5157 */,
    {.source = (const lxb_char_t *) "\u200D㨲｡ß", .ascii = (const lxb_char_t *) "xn--1ug914h.xn--zca", .status = 4} /* 5158 */,
    {.source = (const lxb_char_t *) "\u200D㨲。ß", .ascii = (const lxb_char_t *) "xn--1ug914h.xn--zca", .status = 4} /* 5159 */,
    {.source = (const lxb_char_t *) "\u200D㨲。SS", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5160 */,
    {.source = (const lxb_char_t *) "\u200D㨲。ss", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5161 */,
    {.source = (const lxb_char_t *) "\u200D㨲。Ss", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5162 */,
    {.source = (const lxb_char_t *) "xn--9bm.ss", .ascii = (const lxb_char_t *) "xn--9bm.ss", .status = 0} /* 5163 */,
    {.source = (const lxb_char_t *) "㨲.ss", .ascii = (const lxb_char_t *) "xn--9bm.ss", .status = 0} /* 5164 */,
    {.source = (const lxb_char_t *) "㨲.SS", .ascii = (const lxb_char_t *) "xn--9bm.ss", .status = 0} /* 5165 */,
    {.source = (const lxb_char_t *) "㨲.Ss", .ascii = (const lxb_char_t *) "xn--9bm.ss", .status = 0} /* 5166 */,
    {.source = (const lxb_char_t *) "xn--1ug914h.ss", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5167 */,
    {.source = (const lxb_char_t *) "xn--1ug914h.xn--zca", .ascii = (const lxb_char_t *) "xn--1ug914h.xn--zca", .status = 4} /* 5168 */,
    {.source = (const lxb_char_t *) "\u200D㨲｡SS", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5169 */,
    {.source = (const lxb_char_t *) "\u200D㨲｡ss", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5170 */,
    {.source = (const lxb_char_t *) "\u200D㨲｡Ss", .ascii = (const lxb_char_t *) "xn--1ug914h.ss", .status = 4} /* 5171 */,
    {.source = (const lxb_char_t *) "\u0605\u067E｡\u08A8", .ascii = (const lxb_char_t *) "xn--nfb6v.xn--xyb", .status = 8} /* 5172 */,
    {.source = (const lxb_char_t *) "\u0605\u067E。\u08A8", .ascii = (const lxb_char_t *) "xn--nfb6v.xn--xyb", .status = 8} /* 5173 */,
    {.source = (const lxb_char_t *) "xn--nfb6v.xn--xyb", .ascii = (const lxb_char_t *) "xn--nfb6v.xn--xyb", .status = 8} /* 5174 */,
    {.source = (const lxb_char_t *) "⾑\u0753𞤁。𐹵\u0682", .ascii = (const lxb_char_t *) "xn--6ob9577deqwl.xn--7ib5526k", .status = 12} /* 5175 */,
    {.source = (const lxb_char_t *) "襾\u0753𞤁。𐹵\u0682", .ascii = (const lxb_char_t *) "xn--6ob9577deqwl.xn--7ib5526k", .status = 12} /* 5176 */,
    {.source = (const lxb_char_t *) "襾\u0753𞤣。𐹵\u0682", .ascii = (const lxb_char_t *) "xn--6ob9577deqwl.xn--7ib5526k", .status = 12} /* 5177 */,
    {.source = (const lxb_char_t *) "xn--6ob9577deqwl.xn--7ib5526k", .ascii = (const lxb_char_t *) "xn--6ob9577deqwl.xn--7ib5526k", .status = 12} /* 5178 */,
    {.source = (const lxb_char_t *) "⾑\u0753𞤣。𐹵\u0682", .ascii = (const lxb_char_t *) "xn--6ob9577deqwl.xn--7ib5526k", .status = 12} /* 5179 */,
    {.source = (const lxb_char_t *) "񦴻ς-\u20EB｡\u0754-ꡛ", .ascii = (const lxb_char_t *) "xn----xmb015tuo34l.xn----53c4874j", .status = 16} /* 5180 */,
    {.source = (const lxb_char_t *) "񦴻ς-\u20EB。\u0754-ꡛ", .ascii = (const lxb_char_t *) "xn----xmb015tuo34l.xn----53c4874j", .status = 16} /* 5181 */,
    {.source = (const lxb_char_t *) "񦴻Σ-\u20EB。\u0754-ꡛ", .ascii = (const lxb_char_t *) "xn----zmb705tuo34l.xn----53c4874j", .status = 16} /* 5182 */,
    {.source = (const lxb_char_t *) "񦴻σ-\u20EB。\u0754-ꡛ", .ascii = (const lxb_char_t *) "xn----zmb705tuo34l.xn----53c4874j", .status = 16} /* 5183 */,
    {.source = (const lxb_char_t *) "xn----zmb705tuo34l.xn----53c4874j", .ascii = (const lxb_char_t *) "xn----zmb705tuo34l.xn----53c4874j", .status = 16} /* 5184 */,
    {.source = (const lxb_char_t *) "xn----xmb015tuo34l.xn----53c4874j", .ascii = (const lxb_char_t *) "xn----xmb015tuo34l.xn----53c4874j", .status = 16} /* 5185 */,
    {.source = (const lxb_char_t *) "񦴻Σ-\u20EB｡\u0754-ꡛ", .ascii = (const lxb_char_t *) "xn----zmb705tuo34l.xn----53c4874j", .status = 16} /* 5186 */,
    {.source = (const lxb_char_t *) "񦴻σ-\u20EB｡\u0754-ꡛ", .ascii = (const lxb_char_t *) "xn----zmb705tuo34l.xn----53c4874j", .status = 16} /* 5187 */,
    {.source = (const lxb_char_t *) "\u200D．􀸨", .ascii = (const lxb_char_t *) "xn--1ug.xn--h327f", .status = 8} /* 5188 */,
    {.source = (const lxb_char_t *) "\u200D.􀸨", .ascii = (const lxb_char_t *) "xn--1ug.xn--h327f", .status = 8} /* 5189 */,
    {.source = (const lxb_char_t *) ".xn--h327f", .ascii = (const lxb_char_t *) ".xn--h327f", .status = 10} /* 5190 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--h327f", .ascii = (const lxb_char_t *) "xn--1ug.xn--h327f", .status = 8} /* 5191 */,
    {.source = (const lxb_char_t *) "񣭻񌥁｡≠𝟲", .ascii = (const lxb_char_t *) "xn--h79w4z99a.xn--6-tfo", .status = 4} /* 5192 */,
    {.source = (const lxb_char_t *) "񣭻񌥁｡=\u0338𝟲", .ascii = (const lxb_char_t *) "xn--h79w4z99a.xn--6-tfo", .status = 4} /* 5193 */,
    {.source = (const lxb_char_t *) "񣭻񌥁。≠6", .ascii = (const lxb_char_t *) "xn--h79w4z99a.xn--6-tfo", .status = 4} /* 5194 */,
    {.source = (const lxb_char_t *) "񣭻񌥁。=\u03386", .ascii = (const lxb_char_t *) "xn--h79w4z99a.xn--6-tfo", .status = 4} /* 5195 */,
    {.source = (const lxb_char_t *) "xn--h79w4z99a.xn--6-tfo", .ascii = (const lxb_char_t *) "xn--h79w4z99a.xn--6-tfo", .status = 4} /* 5196 */,
    {.source = (const lxb_char_t *) "󠅊ᡭ\u200D.𐥡", .ascii = (const lxb_char_t *) "xn--98e810b.xn--om9c", .status = 12} /* 5197 */,
    {.source = (const lxb_char_t *) "xn--98e.xn--om9c", .ascii = (const lxb_char_t *) "xn--98e.xn--om9c", .status = 4} /* 5198 */,
    {.source = (const lxb_char_t *) "xn--98e810b.xn--om9c", .ascii = (const lxb_char_t *) "xn--98e810b.xn--om9c", .status = 12} /* 5199 */,
    {.source = (const lxb_char_t *) "\u0C40\u0855𐥛𑄴．󭰵", .ascii = (const lxb_char_t *) "xn--kwb91r5112avtg.xn--o580f", .status = 12} /* 5200 */,
    {.source = (const lxb_char_t *) "\u0C40\u0855𐥛𑄴.󭰵", .ascii = (const lxb_char_t *) "xn--kwb91r5112avtg.xn--o580f", .status = 12} /* 5201 */,
    {.source = (const lxb_char_t *) "xn--kwb91r5112avtg.xn--o580f", .ascii = (const lxb_char_t *) "xn--kwb91r5112avtg.xn--o580f", .status = 12} /* 5202 */,
    {.source = (const lxb_char_t *) "𞤮。𑇊\u200C≯\u1CE6", .ascii = (const lxb_char_t *) "xn--me6h.xn--z6f16kn9b2642b", .status = 12} /* 5203 */,
    {.source = (const lxb_char_t *) "𞤮。𑇊\u200C>\u0338\u1CE6", .ascii = (const lxb_char_t *) "xn--me6h.xn--z6f16kn9b2642b", .status = 12} /* 5204 */,
    {.source = (const lxb_char_t *) "𞤌。𑇊\u200C>\u0338\u1CE6", .ascii = (const lxb_char_t *) "xn--me6h.xn--z6f16kn9b2642b", .status = 12} /* 5205 */,
    {.source = (const lxb_char_t *) "𞤌。𑇊\u200C≯\u1CE6", .ascii = (const lxb_char_t *) "xn--me6h.xn--z6f16kn9b2642b", .status = 12} /* 5206 */,
    {.source = (const lxb_char_t *) "xn--me6h.xn--z6fz8ueq2v", .ascii = (const lxb_char_t *) "xn--me6h.xn--z6fz8ueq2v", .status = 8} /* 5207 */,
    {.source = (const lxb_char_t *) "xn--me6h.xn--z6f16kn9b2642b", .ascii = (const lxb_char_t *) "xn--me6h.xn--z6f16kn9b2642b", .status = 12} /* 5208 */,
    {.source = (const lxb_char_t *) "󠄀𝟕.𞤌񛗓Ⴉ", .ascii = (const lxb_char_t *) "7.xn--hnd3403vv1vv", .status = 16} /* 5209 */,
    {.source = (const lxb_char_t *) "󠄀7.𞤌񛗓Ⴉ", .ascii = (const lxb_char_t *) "7.xn--hnd3403vv1vv", .status = 16} /* 5210 */,
    {.source = (const lxb_char_t *) "󠄀7.𞤮񛗓ⴉ", .ascii = (const lxb_char_t *) "7.xn--0kjz523lv1vv", .status = 16} /* 5211 */,
    {.source = (const lxb_char_t *) "7.xn--0kjz523lv1vv", .ascii = (const lxb_char_t *) "7.xn--0kjz523lv1vv", .status = 16} /* 5212 */,
    {.source = (const lxb_char_t *) "7.xn--hnd3403vv1vv", .ascii = (const lxb_char_t *) "7.xn--hnd3403vv1vv", .status = 16} /* 5213 */,
    {.source = (const lxb_char_t *) "󠄀𝟕.𞤮񛗓ⴉ", .ascii = (const lxb_char_t *) "7.xn--0kjz523lv1vv", .status = 16} /* 5214 */,
    {.source = (const lxb_char_t *) "󠄀7.𞤌񛗓ⴉ", .ascii = (const lxb_char_t *) "7.xn--0kjz523lv1vv", .status = 16} /* 5215 */,
    {.source = (const lxb_char_t *) "󠄀𝟕.𞤌񛗓ⴉ", .ascii = (const lxb_char_t *) "7.xn--0kjz523lv1vv", .status = 16} /* 5216 */,
    {.source = (const lxb_char_t *) "閃9𝩍。Ↄ\u0669\u08B1\u0B4D", .ascii = (const lxb_char_t *) "xn--9-3j6dk517f.xn--iib28ij3c0t9a", .status = 12} /* 5217 */,
    {.source = (const lxb_char_t *) "閃9𝩍。ↄ\u0669\u08B1\u0B4D", .ascii = (const lxb_char_t *) "xn--9-3j6dk517f.xn--iib28ij3c4t9a", .status = 8} /* 5218 */,
    {.source = (const lxb_char_t *) "xn--9-3j6dk517f.xn--iib28ij3c4t9a", .ascii = (const lxb_char_t *) "xn--9-3j6dk517f.xn--iib28ij3c4t9a", .status = 8} /* 5219 */,
    {.source = (const lxb_char_t *) "xn--9-3j6dk517f.xn--iib28ij3c0t9a", .ascii = (const lxb_char_t *) "xn--9-3j6dk517f.xn--iib28ij3c0t9a", .status = 12} /* 5220 */,
    {.source = (const lxb_char_t *) "\uAAF6ᢏ\u0E3A２.𐋢\u0745\u0F9F︒", .ascii = (const lxb_char_t *) "xn--2-2zf840fk16m.xn--sob093bj62sz9d", .status = 8} /* 5221 */,
    {.source = (const lxb_char_t *) "\uAAF6ᢏ\u0E3A2.𐋢\u0745\u0F9F。", .ascii = (const lxb_char_t *) "xn--2-2zf840fk16m.xn--sob093b2m7s.", .status = 4} /* 5222 */,
    {.source = (const lxb_char_t *) "xn--2-2zf840fk16m.xn--sob093b2m7s.", .ascii = (const lxb_char_t *) "xn--2-2zf840fk16m.xn--sob093b2m7s.", .status = 4} /* 5223 */,
    {.source = (const lxb_char_t *) "xn--2-2zf840fk16m.xn--sob093bj62sz9d", .ascii = (const lxb_char_t *) "xn--2-2zf840fk16m.xn--sob093bj62sz9d", .status = 8} /* 5224 */,
    {.source = (const lxb_char_t *) "󅴧｡≠-󠙄⾛", .ascii = (const lxb_char_t *) "xn--gm57d.xn----tfo4949b3664m", .status = 4} /* 5225 */,
    {.source = (const lxb_char_t *) "󅴧｡=\u0338-󠙄⾛", .ascii = (const lxb_char_t *) "xn--gm57d.xn----tfo4949b3664m", .status = 4} /* 5226 */,
    {.source = (const lxb_char_t *) "󅴧。≠-󠙄走", .ascii = (const lxb_char_t *) "xn--gm57d.xn----tfo4949b3664m", .status = 4} /* 5227 */,
    {.source = (const lxb_char_t *) "󅴧。=\u0338-󠙄走", .ascii = (const lxb_char_t *) "xn--gm57d.xn----tfo4949b3664m", .status = 4} /* 5228 */,
    {.source = (const lxb_char_t *) "xn--gm57d.xn----tfo4949b3664m", .ascii = (const lxb_char_t *) "xn--gm57d.xn----tfo4949b3664m", .status = 4} /* 5229 */,
    {.source = (const lxb_char_t *) "\u076E\u0604Ⴊ。-≠\u1160", .ascii = (const lxb_char_t *) "xn--mfb73ex6r.xn----5bh589i", .status = 20} /* 5230 */,
    {.source = (const lxb_char_t *) "\u076E\u0604Ⴊ。-=\u0338\u1160", .ascii = (const lxb_char_t *) "xn--mfb73ex6r.xn----5bh589i", .status = 20} /* 5231 */,
    {.source = (const lxb_char_t *) "\u076E\u0604ⴊ。-=\u0338\u1160", .ascii = (const lxb_char_t *) "xn--mfb73ek93f.xn----5bh589i", .status = 20} /* 5232 */,
    {.source = (const lxb_char_t *) "\u076E\u0604ⴊ。-≠\u1160", .ascii = (const lxb_char_t *) "xn--mfb73ek93f.xn----5bh589i", .status = 20} /* 5233 */,
    {.source = (const lxb_char_t *) "xn--mfb73ek93f.xn----5bh589i", .ascii = (const lxb_char_t *) "xn--mfb73ek93f.xn----5bh589i", .status = 20} /* 5234 */,
    {.source = (const lxb_char_t *) "xn--mfb73ex6r.xn----5bh589i", .ascii = (const lxb_char_t *) "xn--mfb73ex6r.xn----5bh589i", .status = 20} /* 5235 */,
    {.source = (const lxb_char_t *) "\uFB4F𐹧𝟒≯｡\u200C", .ascii = (const lxb_char_t *) "xn--4-zhc0by36txt0w.xn--0ug", .status = 16} /* 5236 */,
    {.source = (const lxb_char_t *) "\uFB4F𐹧𝟒>\u0338｡\u200C", .ascii = (const lxb_char_t *) "xn--4-zhc0by36txt0w.xn--0ug", .status = 16} /* 5237 */,
    {.source = (const lxb_char_t *) "\u05D0\u05DC𐹧4≯。\u200C", .ascii = (const lxb_char_t *) "xn--4-zhc0by36txt0w.xn--0ug", .status = 16} /* 5238 */,
    {.source = (const lxb_char_t *) "\u05D0\u05DC𐹧4>\u0338。\u200C", .ascii = (const lxb_char_t *) "xn--4-zhc0by36txt0w.xn--0ug", .status = 16} /* 5239 */,
    {.source = (const lxb_char_t *) "xn--4-zhc0by36txt0w.", .ascii = (const lxb_char_t *) "xn--4-zhc0by36txt0w.", .status = 8} /* 5240 */,
    {.source = (const lxb_char_t *) "xn--4-zhc0by36txt0w.xn--0ug", .ascii = (const lxb_char_t *) "xn--4-zhc0by36txt0w.xn--0ug", .status = 16} /* 5241 */,
    {.source = (const lxb_char_t *) "𝟎。甯", .ascii = (const lxb_char_t *) "0.xn--qny", .status = 0} /* 5242 */,
    {.source = (const lxb_char_t *) "0。甯", .ascii = (const lxb_char_t *) "0.xn--qny", .status = 0} /* 5243 */,
    {.source = (const lxb_char_t *) "0.xn--qny", .ascii = (const lxb_char_t *) "0.xn--qny", .status = 0} /* 5244 */,
    {.source = (const lxb_char_t *) "0.甯", .ascii = (const lxb_char_t *) "0.xn--qny", .status = 0} /* 5245 */,
    {.source = (const lxb_char_t *) "-⾆．\uAAF6", .ascii = (const lxb_char_t *) "xn----ef8c.xn--2v9a", .status = 8} /* 5246 */,
    {.source = (const lxb_char_t *) "-舌.\uAAF6", .ascii = (const lxb_char_t *) "xn----ef8c.xn--2v9a", .status = 8} /* 5247 */,
    {.source = (const lxb_char_t *) "xn----ef8c.xn--2v9a", .ascii = (const lxb_char_t *) "xn----ef8c.xn--2v9a", .status = 8} /* 5248 */,
    {.source = (const lxb_char_t *) "-｡ᢘ", .ascii = (const lxb_char_t *) "-.xn--ibf", .status = 4} /* 5249 */,
    {.source = (const lxb_char_t *) "-。ᢘ", .ascii = (const lxb_char_t *) "-.xn--ibf", .status = 4} /* 5250 */,
    {.source = (const lxb_char_t *) "-.xn--ibf", .ascii = (const lxb_char_t *) "-.xn--ibf", .status = 4} /* 5251 */,
    {.source = (const lxb_char_t *) "🂴Ⴋ.≮", .ascii = (const lxb_char_t *) "xn--jnd1986v.xn--gdh", .status = 4} /* 5252 */,
    {.source = (const lxb_char_t *) "🂴Ⴋ.<\u0338", .ascii = (const lxb_char_t *) "xn--jnd1986v.xn--gdh", .status = 4} /* 5253 */,
    {.source = (const lxb_char_t *) "🂴ⴋ.<\u0338", .ascii = (const lxb_char_t *) "xn--2kj7565l.xn--gdh", .status = 0} /* 5254 */,
    {.source = (const lxb_char_t *) "🂴ⴋ.≮", .ascii = (const lxb_char_t *) "xn--2kj7565l.xn--gdh", .status = 0} /* 5255 */,
    {.source = (const lxb_char_t *) "xn--2kj7565l.xn--gdh", .ascii = (const lxb_char_t *) "xn--2kj7565l.xn--gdh", .status = 0} /* 5256 */,
    {.source = (const lxb_char_t *) "xn--jnd1986v.xn--gdh", .ascii = (const lxb_char_t *) "xn--jnd1986v.xn--gdh", .status = 4} /* 5257 */,
    {.source = (const lxb_char_t *) "璼𝨭｡\u200C󠇟", .ascii = (const lxb_char_t *) "xn--gky8837e.xn--0ug", .status = 4} /* 5258 */,
    {.source = (const lxb_char_t *) "璼𝨭。\u200C󠇟", .ascii = (const lxb_char_t *) "xn--gky8837e.xn--0ug", .status = 4} /* 5259 */,
    {.source = (const lxb_char_t *) "xn--gky8837e.", .ascii = (const lxb_char_t *) "xn--gky8837e.", .status = 0} /* 5260 */,
    {.source = (const lxb_char_t *) "璼𝨭.", .ascii = (const lxb_char_t *) "xn--gky8837e.", .status = 0} /* 5261 */,
    {.source = (const lxb_char_t *) "xn--gky8837e.xn--0ug", .ascii = (const lxb_char_t *) "xn--gky8837e.xn--0ug", .status = 4} /* 5262 */,
    {.source = (const lxb_char_t *) "\u06698񂍽｡-5🞥", .ascii = (const lxb_char_t *) "xn--8-qqc97891f.xn---5-rp92a", .status = 12} /* 5263 */,
    {.source = (const lxb_char_t *) "\u06698񂍽。-5🞥", .ascii = (const lxb_char_t *) "xn--8-qqc97891f.xn---5-rp92a", .status = 12} /* 5264 */,
    {.source = (const lxb_char_t *) "xn--8-qqc97891f.xn---5-rp92a", .ascii = (const lxb_char_t *) "xn--8-qqc97891f.xn---5-rp92a", .status = 12} /* 5265 */,
    {.source = (const lxb_char_t *) "\u200C.\u200C", .ascii = (const lxb_char_t *) "xn--0ug.xn--0ug", .status = 4} /* 5266 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--0ug", .ascii = (const lxb_char_t *) "xn--0ug.xn--0ug", .status = 4} /* 5267 */,
    {.source = (const lxb_char_t *) "\u200D튛.\u0716", .ascii = (const lxb_char_t *) "xn--1ug4441e.xn--gnb", .status = 8} /* 5268 */,
    {.source = (const lxb_char_t *) "\u200D튛.\u0716", .ascii = (const lxb_char_t *) "xn--1ug4441e.xn--gnb", .status = 8} /* 5269 */,
    {.source = (const lxb_char_t *) "xn--157b.xn--gnb", .ascii = (const lxb_char_t *) "xn--157b.xn--gnb", .status = 0} /* 5270 */,
    {.source = (const lxb_char_t *) "튛.\u0716", .ascii = (const lxb_char_t *) "xn--157b.xn--gnb", .status = 0} /* 5271 */,
    {.source = (const lxb_char_t *) "튛.\u0716", .ascii = (const lxb_char_t *) "xn--157b.xn--gnb", .status = 0} /* 5272 */,
    {.source = (const lxb_char_t *) "xn--1ug4441e.xn--gnb", .ascii = (const lxb_char_t *) "xn--1ug4441e.xn--gnb", .status = 8} /* 5273 */,
    {.source = (const lxb_char_t *) "ᡋ𐹰𞽳.\u0779ⴞ", .ascii = (const lxb_char_t *) "xn--b8e0417jocvf.xn--9pb883q", .status = 20} /* 5274 */,
    {.source = (const lxb_char_t *) "ᡋ𐹰𞽳.\u0779Ⴞ", .ascii = (const lxb_char_t *) "xn--b8e0417jocvf.xn--9pb068b", .status = 20} /* 5275 */,
    {.source = (const lxb_char_t *) "xn--b8e0417jocvf.xn--9pb068b", .ascii = (const lxb_char_t *) "xn--b8e0417jocvf.xn--9pb068b", .status = 20} /* 5276 */,
    {.source = (const lxb_char_t *) "xn--b8e0417jocvf.xn--9pb883q", .ascii = (const lxb_char_t *) "xn--b8e0417jocvf.xn--9pb883q", .status = 20} /* 5277 */,
    {.source = (const lxb_char_t *) "𐷃\u0662𝅻𝟧．𐹮𐹬Ⴇ", .ascii = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--fnd3401kfa", .status = 12} /* 5278 */,
    {.source = (const lxb_char_t *) "𐷃\u0662𝅻5.𐹮𐹬Ⴇ", .ascii = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--fnd3401kfa", .status = 12} /* 5279 */,
    {.source = (const lxb_char_t *) "𐷃\u0662𝅻5.𐹮𐹬ⴇ", .ascii = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--ykjz523efa", .status = 12} /* 5280 */,
    {.source = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--ykjz523efa", .ascii = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--ykjz523efa", .status = 12} /* 5281 */,
    {.source = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--fnd3401kfa", .ascii = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--fnd3401kfa", .status = 12} /* 5282 */,
    {.source = (const lxb_char_t *) "𐷃\u0662𝅻𝟧．𐹮𐹬ⴇ", .ascii = (const lxb_char_t *) "xn--5-cqc8833rhv7f.xn--ykjz523efa", .status = 12} /* 5283 */,
    {.source = (const lxb_char_t *) "Ⴗ．\u05C2𑄴\uA9B7񘃨", .ascii = (const lxb_char_t *) "xn--vnd.xn--qdb0605f14ycrms3c", .status = 8} /* 5284 */,
    {.source = (const lxb_char_t *) "Ⴗ．𑄴\u05C2\uA9B7񘃨", .ascii = (const lxb_char_t *) "xn--vnd.xn--qdb0605f14ycrms3c", .status = 8} /* 5285 */,
    {.source = (const lxb_char_t *) "Ⴗ.𑄴\u05C2\uA9B7񘃨", .ascii = (const lxb_char_t *) "xn--vnd.xn--qdb0605f14ycrms3c", .status = 8} /* 5286 */,
    {.source = (const lxb_char_t *) "ⴗ.𑄴\u05C2\uA9B7񘃨", .ascii = (const lxb_char_t *) "xn--flj.xn--qdb0605f14ycrms3c", .status = 8} /* 5287 */,
    {.source = (const lxb_char_t *) "xn--flj.xn--qdb0605f14ycrms3c", .ascii = (const lxb_char_t *) "xn--flj.xn--qdb0605f14ycrms3c", .status = 8} /* 5288 */,
    {.source = (const lxb_char_t *) "xn--vnd.xn--qdb0605f14ycrms3c", .ascii = (const lxb_char_t *) "xn--vnd.xn--qdb0605f14ycrms3c", .status = 8} /* 5289 */,
    {.source = (const lxb_char_t *) "ⴗ．𑄴\u05C2\uA9B7񘃨", .ascii = (const lxb_char_t *) "xn--flj.xn--qdb0605f14ycrms3c", .status = 8} /* 5290 */,
    {.source = (const lxb_char_t *) "ⴗ．\u05C2𑄴\uA9B7񘃨", .ascii = (const lxb_char_t *) "xn--flj.xn--qdb0605f14ycrms3c", .status = 8} /* 5291 */,
    {.source = (const lxb_char_t *) "𝟾𾤘．򇕛\u066C", .ascii = (const lxb_char_t *) "xn--8-kh23b.xn--lib78461i", .status = 16} /* 5292 */,
    {.source = (const lxb_char_t *) "8𾤘.򇕛\u066C", .ascii = (const lxb_char_t *) "xn--8-kh23b.xn--lib78461i", .status = 16} /* 5293 */,
    {.source = (const lxb_char_t *) "xn--8-kh23b.xn--lib78461i", .ascii = (const lxb_char_t *) "xn--8-kh23b.xn--lib78461i", .status = 16} /* 5294 */,
    {.source = (const lxb_char_t *) "⒈酫︒。\u08D6", .ascii = (const lxb_char_t *) "xn--tsh4490bfe8c.xn--8zb", .status = 8} /* 5295 */,
    {.source = (const lxb_char_t *) "1.酫。。\u08D6", .ascii = (const lxb_char_t *) "1.xn--8j4a..xn--8zb", .status = 10} /* 5296 */,
    {.source = (const lxb_char_t *) "1.xn--8j4a..xn--8zb", .ascii = (const lxb_char_t *) "1.xn--8j4a..xn--8zb", .status = 10} /* 5297 */,
    {.source = (const lxb_char_t *) "xn--tsh4490bfe8c.xn--8zb", .ascii = (const lxb_char_t *) "xn--tsh4490bfe8c.xn--8zb", .status = 8} /* 5298 */,
    {.source = (const lxb_char_t *) "\u2DE3\u200C≮\u1A6B.\u200C\u0E3A", .ascii = (const lxb_char_t *) "xn--uof63xk4bf3s.xn--o4c732g", .status = 8} /* 5299 */,
    {.source = (const lxb_char_t *) "\u2DE3\u200C<\u0338\u1A6B.\u200C\u0E3A", .ascii = (const lxb_char_t *) "xn--uof63xk4bf3s.xn--o4c732g", .status = 8} /* 5300 */,
    {.source = (const lxb_char_t *) "xn--uof548an0j.xn--o4c", .ascii = (const lxb_char_t *) "xn--uof548an0j.xn--o4c", .status = 4} /* 5301 */,
    {.source = (const lxb_char_t *) "xn--uof63xk4bf3s.xn--o4c732g", .ascii = (const lxb_char_t *) "xn--uof63xk4bf3s.xn--o4c732g", .status = 8} /* 5302 */,
    {.source = (const lxb_char_t *) "𞪂。ႷႽ¹\u200D", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1gs597m", .status = 12} /* 5303 */,
    {.source = (const lxb_char_t *) "𞪂。ႷႽ1\u200D", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1gs597m", .status = 12} /* 5304 */,
    {.source = (const lxb_char_t *) "𞪂。ⴗⴝ1\u200D", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-ugn710dya", .status = 12} /* 5305 */,
    {.source = (const lxb_char_t *) "𞪂。Ⴗⴝ1\u200D", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1g398iewm", .status = 12} /* 5306 */,
    {.source = (const lxb_char_t *) "xn--co6h.xn--1-h1g429s", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1g429s", .status = 4} /* 5307 */,
    {.source = (const lxb_char_t *) "xn--co6h.xn--1-h1g398iewm", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1g398iewm", .status = 12} /* 5308 */,
    {.source = (const lxb_char_t *) "xn--co6h.xn--1-kwssa", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-kwssa", .status = 4} /* 5309 */,
    {.source = (const lxb_char_t *) "xn--co6h.xn--1-ugn710dya", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-ugn710dya", .status = 12} /* 5310 */,
    {.source = (const lxb_char_t *) "xn--co6h.xn--1-h1gs", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1gs", .status = 4} /* 5311 */,
    {.source = (const lxb_char_t *) "xn--co6h.xn--1-h1gs597m", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1gs597m", .status = 12} /* 5312 */,
    {.source = (const lxb_char_t *) "𞪂。ⴗⴝ¹\u200D", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-ugn710dya", .status = 12} /* 5313 */,
    {.source = (const lxb_char_t *) "𞪂。Ⴗⴝ¹\u200D", .ascii = (const lxb_char_t *) "xn--co6h.xn--1-h1g398iewm", .status = 12} /* 5314 */,
    {.source = (const lxb_char_t *) "𑄴𑄳2.𞳿󠀳-", .ascii = (const lxb_char_t *) "xn--2-h87ic.xn----s39r33498d", .status = 20} /* 5315 */,
    {.source = (const lxb_char_t *) "xn--2-h87ic.xn----s39r33498d", .ascii = (const lxb_char_t *) "xn--2-h87ic.xn----s39r33498d", .status = 20} /* 5316 */,
    {.source = (const lxb_char_t *) "󠕲󟶶\u0665｡񀁁𑄳𞤃\u0710", .ascii = (const lxb_char_t *) "xn--eib57614py3ea.xn--9mb5737kqnpfzkwr", .status = 16} /* 5317 */,
    {.source = (const lxb_char_t *) "󠕲󟶶\u0665。񀁁𑄳𞤃\u0710", .ascii = (const lxb_char_t *) "xn--eib57614py3ea.xn--9mb5737kqnpfzkwr", .status = 16} /* 5318 */,
    {.source = (const lxb_char_t *) "󠕲󟶶\u0665。񀁁𑄳𞤥\u0710", .ascii = (const lxb_char_t *) "xn--eib57614py3ea.xn--9mb5737kqnpfzkwr", .status = 16} /* 5319 */,
    {.source = (const lxb_char_t *) "xn--eib57614py3ea.xn--9mb5737kqnpfzkwr", .ascii = (const lxb_char_t *) "xn--eib57614py3ea.xn--9mb5737kqnpfzkwr", .status = 16} /* 5320 */,
    {.source = (const lxb_char_t *) "󠕲󟶶\u0665｡񀁁𑄳𞤥\u0710", .ascii = (const lxb_char_t *) "xn--eib57614py3ea.xn--9mb5737kqnpfzkwr", .status = 16} /* 5321 */,
    {.source = (const lxb_char_t *) "\u0720򲠽𐹢\u17BB｡ςᢈ🝭\u200C", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--3xa057h6ofgl44c", .status = 16} /* 5322 */,
    {.source = (const lxb_char_t *) "\u0720򲠽𐹢\u17BB。ςᢈ🝭\u200C", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--3xa057h6ofgl44c", .status = 16} /* 5323 */,
    {.source = (const lxb_char_t *) "\u0720򲠽𐹢\u17BB。Σᢈ🝭\u200C", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847h6ofgl44c", .status = 16} /* 5324 */,
    {.source = (const lxb_char_t *) "\u0720򲠽𐹢\u17BB。σᢈ🝭\u200C", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847h6ofgl44c", .status = 16} /* 5325 */,
    {.source = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847hli46a", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847hli46a", .status = 12} /* 5326 */,
    {.source = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847h6ofgl44c", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847h6ofgl44c", .status = 16} /* 5327 */,
    {.source = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--3xa057h6ofgl44c", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--3xa057h6ofgl44c", .status = 16} /* 5328 */,
    {.source = (const lxb_char_t *) "\u0720򲠽𐹢\u17BB｡Σᢈ🝭\u200C", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847h6ofgl44c", .status = 16} /* 5329 */,
    {.source = (const lxb_char_t *) "\u0720򲠽𐹢\u17BB｡σᢈ🝭\u200C", .ascii = (const lxb_char_t *) "xn--qnb616fis0qzt36f.xn--4xa847h6ofgl44c", .status = 16} /* 5330 */,
    {.source = (const lxb_char_t *) "\u200D--≮。𐹧", .ascii = (const lxb_char_t *) "xn-----l1tz1k.xn--fo0d", .status = 8} /* 5331 */,
    {.source = (const lxb_char_t *) "\u200D--<\u0338。𐹧", .ascii = (const lxb_char_t *) "xn-----l1tz1k.xn--fo0d", .status = 8} /* 5332 */,
    {.source = (const lxb_char_t *) "xn-----ujv.xn--fo0d", .ascii = (const lxb_char_t *) "xn-----ujv.xn--fo0d", .status = 8} /* 5333 */,
    {.source = (const lxb_char_t *) "xn-----l1tz1k.xn--fo0d", .ascii = (const lxb_char_t *) "xn-----l1tz1k.xn--fo0d", .status = 8} /* 5334 */,
    {.source = (const lxb_char_t *) "\uA806。𻚏\u0FB0⒕", .ascii = (const lxb_char_t *) "xn--l98a.xn--dgd218hhp28d", .status = 8} /* 5335 */,
    {.source = (const lxb_char_t *) "\uA806。𻚏\u0FB014.", .ascii = (const lxb_char_t *) "xn--l98a.xn--14-jsj57880f.", .status = 8} /* 5336 */,
    {.source = (const lxb_char_t *) "xn--l98a.xn--14-jsj57880f.", .ascii = (const lxb_char_t *) "xn--l98a.xn--14-jsj57880f.", .status = 8} /* 5337 */,
    {.source = (const lxb_char_t *) "xn--l98a.xn--dgd218hhp28d", .ascii = (const lxb_char_t *) "xn--l98a.xn--dgd218hhp28d", .status = 8} /* 5338 */,
    {.source = (const lxb_char_t *) "򮉂\u06BC．𑆺\u0669", .ascii = (const lxb_char_t *) "xn--vkb92243l.xn--iib9797k", .status = 20} /* 5339 */,
    {.source = (const lxb_char_t *) "򮉂\u06BC.𑆺\u0669", .ascii = (const lxb_char_t *) "xn--vkb92243l.xn--iib9797k", .status = 20} /* 5340 */,
    {.source = (const lxb_char_t *) "xn--vkb92243l.xn--iib9797k", .ascii = (const lxb_char_t *) "xn--vkb92243l.xn--iib9797k", .status = 20} /* 5341 */,
    {.source = (const lxb_char_t *) "󠁎\u06D0-。𞤴", .ascii = (const lxb_char_t *) "xn----mwc72685y.xn--se6h", .status = 12} /* 5342 */,
    {.source = (const lxb_char_t *) "󠁎\u06D0-。𞤒", .ascii = (const lxb_char_t *) "xn----mwc72685y.xn--se6h", .status = 12} /* 5343 */,
    {.source = (const lxb_char_t *) "xn----mwc72685y.xn--se6h", .ascii = (const lxb_char_t *) "xn----mwc72685y.xn--se6h", .status = 12} /* 5344 */,
    {.source = (const lxb_char_t *) "𝟠4󠇗𝈻．\u200D𐋵⛧\u200D", .ascii = (const lxb_char_t *) "xn--84-s850a.xn--1uga573cfq1w", .status = 4} /* 5345 */,
    {.source = (const lxb_char_t *) "84󠇗𝈻.\u200D𐋵⛧\u200D", .ascii = (const lxb_char_t *) "xn--84-s850a.xn--1uga573cfq1w", .status = 4} /* 5346 */,
    {.source = (const lxb_char_t *) "xn--84-s850a.xn--59h6326e", .ascii = (const lxb_char_t *) "xn--84-s850a.xn--59h6326e", .status = 0} /* 5347 */,
    {.source = (const lxb_char_t *) "84𝈻.𐋵⛧", .ascii = (const lxb_char_t *) "xn--84-s850a.xn--59h6326e", .status = 0} /* 5348 */,
    {.source = (const lxb_char_t *) "xn--84-s850a.xn--1uga573cfq1w", .ascii = (const lxb_char_t *) "xn--84-s850a.xn--1uga573cfq1w", .status = 4} /* 5349 */,
    {.source = (const lxb_char_t *) "-\u0601｡ᡪ", .ascii = (const lxb_char_t *) "xn----tkc.xn--68e", .status = 12} /* 5350 */,
    {.source = (const lxb_char_t *) "-\u0601。ᡪ", .ascii = (const lxb_char_t *) "xn----tkc.xn--68e", .status = 12} /* 5351 */,
    {.source = (const lxb_char_t *) "xn----tkc.xn--68e", .ascii = (const lxb_char_t *) "xn----tkc.xn--68e", .status = 12} /* 5352 */,
    {.source = (const lxb_char_t *) "≮𝟕．謖ß≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--zca892oly5e", .status = 0} /* 5353 */,
    {.source = (const lxb_char_t *) "<\u0338𝟕．謖ß>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--zca892oly5e", .status = 0} /* 5354 */,
    {.source = (const lxb_char_t *) "≮7.謖ß≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--zca892oly5e", .status = 0} /* 5355 */,
    {.source = (const lxb_char_t *) "<\u03387.謖ß>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--zca892oly5e", .status = 0} /* 5356 */,
    {.source = (const lxb_char_t *) "<\u03387.謖SS>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5357 */,
    {.source = (const lxb_char_t *) "≮7.謖SS≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5358 */,
    {.source = (const lxb_char_t *) "≮7.謖ss≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5359 */,
    {.source = (const lxb_char_t *) "<\u03387.謖ss>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5360 */,
    {.source = (const lxb_char_t *) "<\u03387.謖Ss>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5361 */,
    {.source = (const lxb_char_t *) "≮7.謖Ss≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5362 */,
    {.source = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5363 */,
    {.source = (const lxb_char_t *) "xn--7-mgo.xn--zca892oly5e", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--zca892oly5e", .status = 0} /* 5364 */,
    {.source = (const lxb_char_t *) "<\u0338𝟕．謖SS>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5365 */,
    {.source = (const lxb_char_t *) "≮𝟕．謖SS≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5366 */,
    {.source = (const lxb_char_t *) "≮𝟕．謖ss≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5367 */,
    {.source = (const lxb_char_t *) "<\u0338𝟕．謖ss>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5368 */,
    {.source = (const lxb_char_t *) "<\u0338𝟕．謖Ss>\u0338", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5369 */,
    {.source = (const lxb_char_t *) "≮𝟕．謖Ss≯", .ascii = (const lxb_char_t *) "xn--7-mgo.xn--ss-xjvv174c", .status = 0} /* 5370 */,
    {.source = (const lxb_char_t *) "朶Ⴉ𞪡.𝨽\u0825📻-", .ascii = (const lxb_char_t *) "xn--hnd7245bd56p.xn----3gd37096apmwa", .status = 24} /* 5371 */,
    {.source = (const lxb_char_t *) "朶ⴉ𞪡.𝨽\u0825📻-", .ascii = (const lxb_char_t *) "xn--0kjz47pd57t.xn----3gd37096apmwa", .status = 24} /* 5372 */,
    {.source = (const lxb_char_t *) "xn--0kjz47pd57t.xn----3gd37096apmwa", .ascii = (const lxb_char_t *) "xn--0kjz47pd57t.xn----3gd37096apmwa", .status = 24} /* 5373 */,
    {.source = (const lxb_char_t *) "xn--hnd7245bd56p.xn----3gd37096apmwa", .ascii = (const lxb_char_t *) "xn--hnd7245bd56p.xn----3gd37096apmwa", .status = 24} /* 5374 */,
    {.source = (const lxb_char_t *) "𐤎。󑿰\u200C≮\u200D", .ascii = (const lxb_char_t *) "xn--bk9c.xn--0ugc04p2u638c", .status = 16} /* 5375 */,
    {.source = (const lxb_char_t *) "𐤎。󑿰\u200C<\u0338\u200D", .ascii = (const lxb_char_t *) "xn--bk9c.xn--0ugc04p2u638c", .status = 16} /* 5376 */,
    {.source = (const lxb_char_t *) "xn--bk9c.xn--gdhx6802k", .ascii = (const lxb_char_t *) "xn--bk9c.xn--gdhx6802k", .status = 8} /* 5377 */,
    {.source = (const lxb_char_t *) "xn--bk9c.xn--0ugc04p2u638c", .ascii = (const lxb_char_t *) "xn--bk9c.xn--0ugc04p2u638c", .status = 16} /* 5378 */,
    {.source = (const lxb_char_t *) "񭜎⒈｡\u200C𝟤", .ascii = (const lxb_char_t *) "xn--tsh94183d.xn--2-rgn", .status = 8} /* 5379 */,
    {.source = (const lxb_char_t *) "񭜎1.。\u200C2", .ascii = (const lxb_char_t *) "xn--1-ex54e..xn--2-rgn", .status = 14} /* 5380 */,
    {.source = (const lxb_char_t *) "xn--1-ex54e..2", .ascii = (const lxb_char_t *) "xn--1-ex54e..2", .status = 10} /* 5381 */,
    {.source = (const lxb_char_t *) "xn--1-ex54e..xn--2-rgn", .ascii = (const lxb_char_t *) "xn--1-ex54e..xn--2-rgn", .status = 14} /* 5382 */,
    {.source = (const lxb_char_t *) "xn--tsh94183d.2", .ascii = (const lxb_char_t *) "xn--tsh94183d.2", .status = 4} /* 5383 */,
    {.source = (const lxb_char_t *) "xn--tsh94183d.xn--2-rgn", .ascii = (const lxb_char_t *) "xn--tsh94183d.xn--2-rgn", .status = 8} /* 5384 */,
    {.source = (const lxb_char_t *) "󠟊𐹤\u200D．𐹳󙄵𐹶", .ascii = (const lxb_char_t *) "xn--1ugy994g7k93g.xn--ro0dga22807v", .status = 12} /* 5385 */,
    {.source = (const lxb_char_t *) "󠟊𐹤\u200D.𐹳󙄵𐹶", .ascii = (const lxb_char_t *) "xn--1ugy994g7k93g.xn--ro0dga22807v", .status = 12} /* 5386 */,
    {.source = (const lxb_char_t *) "xn--co0d98977c.xn--ro0dga22807v", .ascii = (const lxb_char_t *) "xn--co0d98977c.xn--ro0dga22807v", .status = 8} /* 5387 */,
    {.source = (const lxb_char_t *) "xn--1ugy994g7k93g.xn--ro0dga22807v", .ascii = (const lxb_char_t *) "xn--1ugy994g7k93g.xn--ro0dga22807v", .status = 12} /* 5388 */,
    {.source = (const lxb_char_t *) "𞤴𐹻𑓂𐭝．\u094D\uFE07􉛯", .ascii = (const lxb_char_t *) "xn--609c96c09grp2w.xn--n3b28708s", .status = 12} /* 5389 */,
    {.source = (const lxb_char_t *) "𞤴𐹻𑓂𐭝.\u094D\uFE07􉛯", .ascii = (const lxb_char_t *) "xn--609c96c09grp2w.xn--n3b28708s", .status = 12} /* 5390 */,
    {.source = (const lxb_char_t *) "𞤒𐹻𑓂𐭝.\u094D\uFE07􉛯", .ascii = (const lxb_char_t *) "xn--609c96c09grp2w.xn--n3b28708s", .status = 12} /* 5391 */,
    {.source = (const lxb_char_t *) "xn--609c96c09grp2w.xn--n3b28708s", .ascii = (const lxb_char_t *) "xn--609c96c09grp2w.xn--n3b28708s", .status = 12} /* 5392 */,
    {.source = (const lxb_char_t *) "𞤒𐹻𑓂𐭝．\u094D\uFE07􉛯", .ascii = (const lxb_char_t *) "xn--609c96c09grp2w.xn--n3b28708s", .status = 12} /* 5393 */,
    {.source = (const lxb_char_t *) "\u0668｡𐹠𐹽񗮶", .ascii = (const lxb_char_t *) "xn--hib.xn--7n0d2bu9196b", .status = 8} /* 5394 */,
    {.source = (const lxb_char_t *) "\u0668。𐹠𐹽񗮶", .ascii = (const lxb_char_t *) "xn--hib.xn--7n0d2bu9196b", .status = 8} /* 5395 */,
    {.source = (const lxb_char_t *) "xn--hib.xn--7n0d2bu9196b", .ascii = (const lxb_char_t *) "xn--hib.xn--7n0d2bu9196b", .status = 8} /* 5396 */,
    {.source = (const lxb_char_t *) "\u1160񍀜.8򶾵\u069C", .ascii = (const lxb_char_t *) "xn--psd85033d.xn--8-otc61545t", .status = 8} /* 5397 */,
    {.source = (const lxb_char_t *) "xn--psd85033d.xn--8-otc61545t", .ascii = (const lxb_char_t *) "xn--psd85033d.xn--8-otc61545t", .status = 8} /* 5398 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪｡ß𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--zca0732l", .status = 8} /* 5399 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪。ß𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--zca0732l", .status = 8} /* 5400 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪。SS𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5401 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪。ss𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5402 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪。Ss𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5403 */,
    {.source = (const lxb_char_t *) ".xn--ss-bh7o", .ascii = (const lxb_char_t *) ".xn--ss-bh7o", .status = 6} /* 5404 */,
    {.source = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5405 */,
    {.source = (const lxb_char_t *) "xn--0ugb.xn--zca0732l", .ascii = (const lxb_char_t *) "xn--0ugb.xn--zca0732l", .status = 8} /* 5406 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪｡SS𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5407 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪｡ss𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5408 */,
    {.source = (const lxb_char_t *) "\u200D\u200C󠆪｡Ss𑓃", .ascii = (const lxb_char_t *) "xn--0ugb.xn--ss-bh7o", .status = 8} /* 5409 */,
    {.source = (const lxb_char_t *) "xn--ss-bh7o", .ascii = (const lxb_char_t *) "xn--ss-bh7o", .status = 0} /* 5410 */,
    {.source = (const lxb_char_t *) "ss𑓃", .ascii = (const lxb_char_t *) "xn--ss-bh7o", .status = 0} /* 5411 */,
    {.source = (const lxb_char_t *) "SS𑓃", .ascii = (const lxb_char_t *) "xn--ss-bh7o", .status = 0} /* 5412 */,
    {.source = (const lxb_char_t *) "Ss𑓃", .ascii = (const lxb_char_t *) "xn--ss-bh7o", .status = 0} /* 5413 */,
    {.source = (const lxb_char_t *) "︒\u200Cヶ䒩.ꡪ", .ascii = (const lxb_char_t *) "xn--0ug287dj0or48o.xn--gd9a", .status = 8} /* 5414 */,
    {.source = (const lxb_char_t *) "。\u200Cヶ䒩.ꡪ", .ascii = (const lxb_char_t *) ".xn--0ug287dj0o.xn--gd9a", .status = 10} /* 5415 */,
    {.source = (const lxb_char_t *) ".xn--qekw60d.xn--gd9a", .ascii = (const lxb_char_t *) ".xn--qekw60d.xn--gd9a", .status = 6} /* 5416 */,
    {.source = (const lxb_char_t *) ".xn--0ug287dj0o.xn--gd9a", .ascii = (const lxb_char_t *) ".xn--0ug287dj0o.xn--gd9a", .status = 10} /* 5417 */,
    {.source = (const lxb_char_t *) "xn--qekw60dns9k.xn--gd9a", .ascii = (const lxb_char_t *) "xn--qekw60dns9k.xn--gd9a", .status = 4} /* 5418 */,
    {.source = (const lxb_char_t *) "xn--0ug287dj0or48o.xn--gd9a", .ascii = (const lxb_char_t *) "xn--0ug287dj0or48o.xn--gd9a", .status = 8} /* 5419 */,
    {.source = (const lxb_char_t *) "xn--qekw60d.xn--gd9a", .ascii = (const lxb_char_t *) "xn--qekw60d.xn--gd9a", .status = 0} /* 5420 */,
    {.source = (const lxb_char_t *) "ヶ䒩.ꡪ", .ascii = (const lxb_char_t *) "xn--qekw60d.xn--gd9a", .status = 0} /* 5421 */,
    {.source = (const lxb_char_t *) "\u200C⒈𤮍.󢓋\u1A60", .ascii = (const lxb_char_t *) "xn--0ug88o7471d.xn--jof45148n", .status = 8} /* 5422 */,
    {.source = (const lxb_char_t *) "\u200C1.𤮍.󢓋\u1A60", .ascii = (const lxb_char_t *) "xn--1-rgn.xn--4x6j.xn--jof45148n", .status = 8} /* 5423 */,
    {.source = (const lxb_char_t *) "1.xn--4x6j.xn--jof45148n", .ascii = (const lxb_char_t *) "1.xn--4x6j.xn--jof45148n", .status = 4} /* 5424 */,
    {.source = (const lxb_char_t *) "xn--1-rgn.xn--4x6j.xn--jof45148n", .ascii = (const lxb_char_t *) "xn--1-rgn.xn--4x6j.xn--jof45148n", .status = 8} /* 5425 */,
    {.source = (const lxb_char_t *) "xn--tshw462r.xn--jof45148n", .ascii = (const lxb_char_t *) "xn--tshw462r.xn--jof45148n", .status = 4} /* 5426 */,
    {.source = (const lxb_char_t *) "xn--0ug88o7471d.xn--jof45148n", .ascii = (const lxb_char_t *) "xn--0ug88o7471d.xn--jof45148n", .status = 8} /* 5427 */,
    {.source = (const lxb_char_t *) "⒈\u200C𐫓󠀺。\u1A60񤰵\u200D", .ascii = (const lxb_char_t *) "xn--0ug78ol75wzcx4i.xn--jof95xex98m", .status = 20} /* 5428 */,
    {.source = (const lxb_char_t *) "1.\u200C𐫓󠀺。\u1A60񤰵\u200D", .ascii = (const lxb_char_t *) "1.xn--0ug8853gk263g.xn--jof95xex98m", .status = 20} /* 5429 */,
    {.source = (const lxb_char_t *) "1.xn--8w9c40377c.xn--jofz5294e", .ascii = (const lxb_char_t *) "1.xn--8w9c40377c.xn--jofz5294e", .status = 16} /* 5430 */,
    {.source = (const lxb_char_t *) "1.xn--0ug8853gk263g.xn--jof95xex98m", .ascii = (const lxb_char_t *) "1.xn--0ug8853gk263g.xn--jof95xex98m", .status = 20} /* 5431 */,
    {.source = (const lxb_char_t *) "xn--tsh4435fk263g.xn--jofz5294e", .ascii = (const lxb_char_t *) "xn--tsh4435fk263g.xn--jofz5294e", .status = 12} /* 5432 */,
    {.source = (const lxb_char_t *) "xn--0ug78ol75wzcx4i.xn--jof95xex98m", .ascii = (const lxb_char_t *) "xn--0ug78ol75wzcx4i.xn--jof95xex98m", .status = 20} /* 5433 */,
    {.source = (const lxb_char_t *) "𝅵｡𝟫𞀈䬺⒈", .ascii = (const lxb_char_t *) "xn--3f1h.xn--9-ecp936non25a", .status = 4} /* 5434 */,
    {.source = (const lxb_char_t *) "𝅵。9𞀈䬺1.", .ascii = (const lxb_char_t *) "xn--3f1h.xn--91-030c1650n.", .status = 4} /* 5435 */,
    {.source = (const lxb_char_t *) "xn--3f1h.xn--91-030c1650n.", .ascii = (const lxb_char_t *) "xn--3f1h.xn--91-030c1650n.", .status = 4} /* 5436 */,
    {.source = (const lxb_char_t *) "xn--3f1h.xn--9-ecp936non25a", .ascii = (const lxb_char_t *) "xn--3f1h.xn--9-ecp936non25a", .status = 4} /* 5437 */,
    {.source = (const lxb_char_t *) "򡼺≯。盚\u0635", .ascii = (const lxb_char_t *) "xn--hdh30181h.xn--0gb7878c", .status = 12} /* 5438 */,
    {.source = (const lxb_char_t *) "򡼺>\u0338。盚\u0635", .ascii = (const lxb_char_t *) "xn--hdh30181h.xn--0gb7878c", .status = 12} /* 5439 */,
    {.source = (const lxb_char_t *) "xn--hdh30181h.xn--0gb7878c", .ascii = (const lxb_char_t *) "xn--hdh30181h.xn--0gb7878c", .status = 12} /* 5440 */,
    {.source = (const lxb_char_t *) "-񿰭\u05B4。-󠁊𐢸≯", .ascii = (const lxb_char_t *) "xn----fgc06667m.xn----pgoy615he5y4i", .status = 12} /* 5441 */,
    {.source = (const lxb_char_t *) "-񿰭\u05B4。-󠁊𐢸>\u0338", .ascii = (const lxb_char_t *) "xn----fgc06667m.xn----pgoy615he5y4i", .status = 12} /* 5442 */,
    {.source = (const lxb_char_t *) "xn----fgc06667m.xn----pgoy615he5y4i", .ascii = (const lxb_char_t *) "xn----fgc06667m.xn----pgoy615he5y4i", .status = 12} /* 5443 */,
    {.source = (const lxb_char_t *) "󿭓\u1B44\u200C\u0A4D．𐭛񳋔", .ascii = (const lxb_char_t *) "xn--ybc997f6rd2n772c.xn--409c6100y", .status = 16} /* 5444 */,
    {.source = (const lxb_char_t *) "󿭓\u1B44\u200C\u0A4D.𐭛񳋔", .ascii = (const lxb_char_t *) "xn--ybc997f6rd2n772c.xn--409c6100y", .status = 16} /* 5445 */,
    {.source = (const lxb_char_t *) "xn--ybc997fb5881a.xn--409c6100y", .ascii = (const lxb_char_t *) "xn--ybc997fb5881a.xn--409c6100y", .status = 12} /* 5446 */,
    {.source = (const lxb_char_t *) "xn--ybc997f6rd2n772c.xn--409c6100y", .ascii = (const lxb_char_t *) "xn--ybc997f6rd2n772c.xn--409c6100y", .status = 16} /* 5447 */,
    {.source = (const lxb_char_t *) "⾇.\u067D𞤴\u06BB\u200D", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jv19e6413b", .status = 8} /* 5448 */,
    {.source = (const lxb_char_t *) "舛.\u067D𞤴\u06BB\u200D", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jv19e6413b", .status = 8} /* 5449 */,
    {.source = (const lxb_char_t *) "舛.\u067D𞤒\u06BB\u200D", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jv19e6413b", .status = 8} /* 5450 */,
    {.source = (const lxb_char_t *) "xn--8c1a.xn--2ib8jn539l", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jn539l", .status = 0} /* 5451 */,
    {.source = (const lxb_char_t *) "舛.\u067D𞤴\u06BB", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jn539l", .status = 0} /* 5452 */,
    {.source = (const lxb_char_t *) "舛.\u067D𞤒\u06BB", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jn539l", .status = 0} /* 5453 */,
    {.source = (const lxb_char_t *) "xn--8c1a.xn--2ib8jv19e6413b", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jv19e6413b", .status = 8} /* 5454 */,
    {.source = (const lxb_char_t *) "⾇.\u067D𞤒\u06BB\u200D", .ascii = (const lxb_char_t *) "xn--8c1a.xn--2ib8jv19e6413b", .status = 8} /* 5455 */,
    {.source = (const lxb_char_t *) "4򭆥。\u0767≯", .ascii = (const lxb_char_t *) "xn--4-xn17i.xn--rpb459k", .status = 12} /* 5456 */,
    {.source = (const lxb_char_t *) "4򭆥。\u0767>\u0338", .ascii = (const lxb_char_t *) "xn--4-xn17i.xn--rpb459k", .status = 12} /* 5457 */,
    {.source = (const lxb_char_t *) "xn--4-xn17i.xn--rpb459k", .ascii = (const lxb_char_t *) "xn--4-xn17i.xn--rpb459k", .status = 12} /* 5458 */,
    {.source = (const lxb_char_t *) "𲔏𞫨񺿂硲．\u06AD", .ascii = (const lxb_char_t *) "xn--lcz1610fn78gk609a.xn--gkb", .status = 8} /* 5459 */,
    {.source = (const lxb_char_t *) "𲔏𞫨񺿂硲.\u06AD", .ascii = (const lxb_char_t *) "xn--lcz1610fn78gk609a.xn--gkb", .status = 8} /* 5460 */,
    {.source = (const lxb_char_t *) "xn--lcz1610fn78gk609a.xn--gkb", .ascii = (const lxb_char_t *) "xn--lcz1610fn78gk609a.xn--gkb", .status = 8} /* 5461 */,
    {.source = (const lxb_char_t *) "\u200C.\uFE08\u0666Ⴆ℮", .ascii = (const lxb_char_t *) "xn--0ug.xn--fib263c0yn", .status = 12} /* 5462 */,
    {.source = (const lxb_char_t *) "\u200C.\uFE08\u0666ⴆ℮", .ascii = (const lxb_char_t *) "xn--0ug.xn--fib628k4li", .status = 8} /* 5463 */,
    {.source = (const lxb_char_t *) ".xn--fib628k4li", .ascii = (const lxb_char_t *) ".xn--fib628k4li", .status = 10} /* 5464 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--fib628k4li", .ascii = (const lxb_char_t *) "xn--0ug.xn--fib628k4li", .status = 8} /* 5465 */,
    {.source = (const lxb_char_t *) ".xn--fib263c0yn", .ascii = (const lxb_char_t *) ".xn--fib263c0yn", .status = 14} /* 5466 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--fib263c0yn", .ascii = (const lxb_char_t *) "xn--0ug.xn--fib263c0yn", .status = 12} /* 5467 */,
    {.source = (const lxb_char_t *) "\u06A3．\u0D4D\u200DϞ", .ascii = (const lxb_char_t *) "xn--5jb.xn--xya149bpvp", .status = 8} /* 5468 */,
    {.source = (const lxb_char_t *) "\u06A3.\u0D4D\u200DϞ", .ascii = (const lxb_char_t *) "xn--5jb.xn--xya149bpvp", .status = 8} /* 5469 */,
    {.source = (const lxb_char_t *) "\u06A3.\u0D4D\u200Dϟ", .ascii = (const lxb_char_t *) "xn--5jb.xn--xya149bpvp", .status = 8} /* 5470 */,
    {.source = (const lxb_char_t *) "xn--5jb.xn--xya149b", .ascii = (const lxb_char_t *) "xn--5jb.xn--xya149b", .status = 8} /* 5471 */,
    {.source = (const lxb_char_t *) "xn--5jb.xn--xya149bpvp", .ascii = (const lxb_char_t *) "xn--5jb.xn--xya149bpvp", .status = 8} /* 5472 */,
    {.source = (const lxb_char_t *) "\u06A3．\u0D4D\u200Dϟ", .ascii = (const lxb_char_t *) "xn--5jb.xn--xya149bpvp", .status = 8} /* 5473 */,
    {.source = (const lxb_char_t *) "\u200C𞸇𑘿。\u0623𐮂-腍", .ascii = (const lxb_char_t *) "xn--sgb953kmi8o.xn----qmc5075grs9e", .status = 16} /* 5474 */,
    {.source = (const lxb_char_t *) "\u200C𞸇𑘿。\u0627\u0654𐮂-腍", .ascii = (const lxb_char_t *) "xn--sgb953kmi8o.xn----qmc5075grs9e", .status = 16} /* 5475 */,
    {.source = (const lxb_char_t *) "\u200C\u062D𑘿。\u0623𐮂-腍", .ascii = (const lxb_char_t *) "xn--sgb953kmi8o.xn----qmc5075grs9e", .status = 16} /* 5476 */,
    {.source = (const lxb_char_t *) "\u200C\u062D𑘿。\u0627\u0654𐮂-腍", .ascii = (const lxb_char_t *) "xn--sgb953kmi8o.xn----qmc5075grs9e", .status = 16} /* 5477 */,
    {.source = (const lxb_char_t *) "xn--sgb4140l.xn----qmc5075grs9e", .ascii = (const lxb_char_t *) "xn--sgb4140l.xn----qmc5075grs9e", .status = 8} /* 5478 */,
    {.source = (const lxb_char_t *) "xn--sgb953kmi8o.xn----qmc5075grs9e", .ascii = (const lxb_char_t *) "xn--sgb953kmi8o.xn----qmc5075grs9e", .status = 16} /* 5479 */,
    {.source = (const lxb_char_t *) "-򭷙\u066B纛｡𝟛񭤇🄅", .ascii = (const lxb_char_t *) "xn----vqc8143g0tt4i.xn--3-os1sn476y", .status = 12} /* 5480 */,
    {.source = (const lxb_char_t *) "-򭷙\u066B纛。3񭤇4,", .ascii = (const lxb_char_t *) "xn----vqc8143g0tt4i.xn--34,-8787l", .status = 12} /* 5481 */,
    {.source = (const lxb_char_t *) "xn----vqc8143g0tt4i.xn--34,-8787l", .ascii = (const lxb_char_t *) "xn----vqc8143g0tt4i.xn--34,-8787l", .status = 12} /* 5482 */,
    {.source = (const lxb_char_t *) "xn----vqc8143g0tt4i.xn--3-os1sn476y", .ascii = (const lxb_char_t *) "xn----vqc8143g0tt4i.xn--3-os1sn476y", .status = 12} /* 5483 */,
    {.source = (const lxb_char_t *) "🔔．Ⴂ\u07CC\u0BCD𐋮", .ascii = (const lxb_char_t *) "xn--nv8h.xn--nsb46r83e8112a", .status = 12} /* 5484 */,
    {.source = (const lxb_char_t *) "🔔.Ⴂ\u07CC\u0BCD𐋮", .ascii = (const lxb_char_t *) "xn--nv8h.xn--nsb46r83e8112a", .status = 12} /* 5485 */,
    {.source = (const lxb_char_t *) "🔔.ⴂ\u07CC\u0BCD𐋮", .ascii = (const lxb_char_t *) "xn--nv8h.xn--nsb46rvz1b222p", .status = 8} /* 5486 */,
    {.source = (const lxb_char_t *) "xn--nv8h.xn--nsb46rvz1b222p", .ascii = (const lxb_char_t *) "xn--nv8h.xn--nsb46rvz1b222p", .status = 8} /* 5487 */,
    {.source = (const lxb_char_t *) "xn--nv8h.xn--nsb46r83e8112a", .ascii = (const lxb_char_t *) "xn--nv8h.xn--nsb46r83e8112a", .status = 12} /* 5488 */,
    {.source = (const lxb_char_t *) "🔔．ⴂ\u07CC\u0BCD𐋮", .ascii = (const lxb_char_t *) "xn--nv8h.xn--nsb46rvz1b222p", .status = 8} /* 5489 */,
    {.source = (const lxb_char_t *) "軥\u06B3.-𖬵", .ascii = (const lxb_char_t *) "xn--mkb5480e.xn----6u5m", .status = 16} /* 5490 */,
    {.source = (const lxb_char_t *) "xn--mkb5480e.xn----6u5m", .ascii = (const lxb_char_t *) "xn--mkb5480e.xn----6u5m", .status = 16} /* 5491 */,
    {.source = (const lxb_char_t *) "𐹤\u07CA\u06B6.𐨂-", .ascii = (const lxb_char_t *) "xn--pkb56cn614d.xn----974i", .status = 12} /* 5492 */,
    {.source = (const lxb_char_t *) "xn--pkb56cn614d.xn----974i", .ascii = (const lxb_char_t *) "xn--pkb56cn614d.xn----974i", .status = 12} /* 5493 */,
    {.source = (const lxb_char_t *) "-󠅱0｡\u17CF\u1DFD톇십", .ascii = (const lxb_char_t *) "-0.xn--r4e872ah77nghm", .status = 8} /* 5494 */,
    {.source = (const lxb_char_t *) "-󠅱0｡\u17CF\u1DFD톇십", .ascii = (const lxb_char_t *) "-0.xn--r4e872ah77nghm", .status = 8} /* 5495 */,
    {.source = (const lxb_char_t *) "-󠅱0。\u17CF\u1DFD톇십", .ascii = (const lxb_char_t *) "-0.xn--r4e872ah77nghm", .status = 8} /* 5496 */,
    {.source = (const lxb_char_t *) "-󠅱0。\u17CF\u1DFD톇십", .ascii = (const lxb_char_t *) "-0.xn--r4e872ah77nghm", .status = 8} /* 5497 */,
    {.source = (const lxb_char_t *) "-0.xn--r4e872ah77nghm", .ascii = (const lxb_char_t *) "-0.xn--r4e872ah77nghm", .status = 8} /* 5498 */,
    {.source = (const lxb_char_t *) "ꡰ︒--｡\u17CC靈𐹢񘳮", .ascii = (const lxb_char_t *) "xn-----bk9hu24z.xn--o4e6836dpxudz0v1c", .status = 24} /* 5499 */,
    {.source = (const lxb_char_t *) "ꡰ。--。\u17CC靈𐹢񘳮", .ascii = (const lxb_char_t *) "xn--md9a.--.xn--o4e6836dpxudz0v1c", .status = 16} /* 5500 */,
    {.source = (const lxb_char_t *) "xn--md9a.--.xn--o4e6836dpxudz0v1c", .ascii = (const lxb_char_t *) "xn--md9a.--.xn--o4e6836dpxudz0v1c", .status = 16} /* 5501 */,
    {.source = (const lxb_char_t *) "xn-----bk9hu24z.xn--o4e6836dpxudz0v1c", .ascii = (const lxb_char_t *) "xn-----bk9hu24z.xn--o4e6836dpxudz0v1c", .status = 24} /* 5502 */,
    {.source = (const lxb_char_t *) "\u115FႿႵრ｡\u0B4D", .ascii = (const lxb_char_t *) "xn--tndt4hvw.xn--9ic", .status = 8} /* 5503 */,
    {.source = (const lxb_char_t *) "\u115FႿႵრ。\u0B4D", .ascii = (const lxb_char_t *) "xn--tndt4hvw.xn--9ic", .status = 8} /* 5504 */,
    {.source = (const lxb_char_t *) "\u115Fⴟⴕრ。\u0B4D", .ascii = (const lxb_char_t *) "xn--1od7wz74eeb.xn--9ic", .status = 8} /* 5505 */,
    {.source = (const lxb_char_t *) "\u115FႿႵᲠ。\u0B4D", .ascii = (const lxb_char_t *) "xn--tndt4hvw.xn--9ic", .status = 8} /* 5506 */,
    {.source = (const lxb_char_t *) "xn--tndt4hvw.xn--9ic", .ascii = (const lxb_char_t *) "xn--tndt4hvw.xn--9ic", .status = 8} /* 5507 */,
    {.source = (const lxb_char_t *) "xn--1od7wz74eeb.xn--9ic", .ascii = (const lxb_char_t *) "xn--1od7wz74eeb.xn--9ic", .status = 8} /* 5508 */,
    {.source = (const lxb_char_t *) "\u115Fⴟⴕრ｡\u0B4D", .ascii = (const lxb_char_t *) "xn--1od7wz74eeb.xn--9ic", .status = 8} /* 5509 */,
    {.source = (const lxb_char_t *) "\u115FႿႵᲠ｡\u0B4D", .ascii = (const lxb_char_t *) "xn--tndt4hvw.xn--9ic", .status = 8} /* 5510 */,
    {.source = (const lxb_char_t *) "\u115FႿⴕრ。\u0B4D", .ascii = (const lxb_char_t *) "xn--3nd0etsm92g.xn--9ic", .status = 8} /* 5511 */,
    {.source = (const lxb_char_t *) "xn--3nd0etsm92g.xn--9ic", .ascii = (const lxb_char_t *) "xn--3nd0etsm92g.xn--9ic", .status = 8} /* 5512 */,
    {.source = (const lxb_char_t *) "\u115FႿⴕრ｡\u0B4D", .ascii = (const lxb_char_t *) "xn--3nd0etsm92g.xn--9ic", .status = 8} /* 5513 */,
    {.source = (const lxb_char_t *) "🄃𐹠.\u0664󠅇", .ascii = (const lxb_char_t *) "xn--7n0d1189a.xn--dib", .status = 8} /* 5514 */,
    {.source = (const lxb_char_t *) "2,𐹠.\u0664󠅇", .ascii = (const lxb_char_t *) "xn--2,-5g3o.xn--dib", .status = 8} /* 5515 */,
    {.source = (const lxb_char_t *) "xn--2,-5g3o.xn--dib", .ascii = (const lxb_char_t *) "xn--2,-5g3o.xn--dib", .status = 8} /* 5516 */,
    {.source = (const lxb_char_t *) "xn--7n0d1189a.xn--dib", .ascii = (const lxb_char_t *) "xn--7n0d1189a.xn--dib", .status = 8} /* 5517 */,
    {.source = (const lxb_char_t *) "򻲼\u200C\uFC5B．\u07D2\u0848\u1BF3", .ascii = (const lxb_char_t *) "xn--vgb2kq00fl213y.xn--tsb0vz43c", .status = 24} /* 5518 */,
    {.source = (const lxb_char_t *) "򻲼\u200C\u0630\u0670.\u07D2\u0848\u1BF3", .ascii = (const lxb_char_t *) "xn--vgb2kq00fl213y.xn--tsb0vz43c", .status = 24} /* 5519 */,
    {.source = (const lxb_char_t *) "xn--vgb2kp1223g.xn--tsb0vz43c", .ascii = (const lxb_char_t *) "xn--vgb2kp1223g.xn--tsb0vz43c", .status = 20} /* 5520 */,
    {.source = (const lxb_char_t *) "xn--vgb2kq00fl213y.xn--tsb0vz43c", .ascii = (const lxb_char_t *) "xn--vgb2kq00fl213y.xn--tsb0vz43c", .status = 24} /* 5521 */,
    {.source = (const lxb_char_t *) "\u200D\u200D𞵪\u200C。ᡘ𑲭\u17B5", .ascii = (const lxb_char_t *) "xn--0ugba05538b.xn--03e93aq365d", .status = 16} /* 5522 */,
    {.source = (const lxb_char_t *) "xn--l96h.xn--03e93aq365d", .ascii = (const lxb_char_t *) "xn--l96h.xn--03e93aq365d", .status = 4} /* 5523 */,
    {.source = (const lxb_char_t *) "xn--0ugba05538b.xn--03e93aq365d", .ascii = (const lxb_char_t *) "xn--0ugba05538b.xn--03e93aq365d", .status = 16} /* 5524 */,
    {.source = (const lxb_char_t *) "𞷻。⚄񗑇𑁿", .ascii = (const lxb_char_t *) "xn--qe7h.xn--c7h2966f7so4a", .status = 8} /* 5525 */,
    {.source = (const lxb_char_t *) "xn--qe7h.xn--c7h2966f7so4a", .ascii = (const lxb_char_t *) "xn--qe7h.xn--c7h2966f7so4a", .status = 8} /* 5526 */,
    {.source = (const lxb_char_t *) "\uA8C4≠．𞠨\u0667", .ascii = (const lxb_char_t *) "xn--1chy504c.xn--gib1777v", .status = 8} /* 5527 */,
    {.source = (const lxb_char_t *) "\uA8C4=\u0338．𞠨\u0667", .ascii = (const lxb_char_t *) "xn--1chy504c.xn--gib1777v", .status = 8} /* 5528 */,
    {.source = (const lxb_char_t *) "\uA8C4≠.𞠨\u0667", .ascii = (const lxb_char_t *) "xn--1chy504c.xn--gib1777v", .status = 8} /* 5529 */,
    {.source = (const lxb_char_t *) "\uA8C4=\u0338.𞠨\u0667", .ascii = (const lxb_char_t *) "xn--1chy504c.xn--gib1777v", .status = 8} /* 5530 */,
    {.source = (const lxb_char_t *) "xn--1chy504c.xn--gib1777v", .ascii = (const lxb_char_t *) "xn--1chy504c.xn--gib1777v", .status = 8} /* 5531 */,
    {.source = (const lxb_char_t *) "𝟛𝆪\uA8C4｡\uA8EA-", .ascii = (const lxb_char_t *) "xn--3-sl4eu679e.xn----xn4e", .status = 8} /* 5532 */,
    {.source = (const lxb_char_t *) "𝟛\uA8C4𝆪｡\uA8EA-", .ascii = (const lxb_char_t *) "xn--3-sl4eu679e.xn----xn4e", .status = 8} /* 5533 */,
    {.source = (const lxb_char_t *) "3\uA8C4𝆪。\uA8EA-", .ascii = (const lxb_char_t *) "xn--3-sl4eu679e.xn----xn4e", .status = 8} /* 5534 */,
    {.source = (const lxb_char_t *) "xn--3-sl4eu679e.xn----xn4e", .ascii = (const lxb_char_t *) "xn--3-sl4eu679e.xn----xn4e", .status = 8} /* 5535 */,
    {.source = (const lxb_char_t *) "\u075F\u1BA2\u103AႧ.4", .ascii = (const lxb_char_t *) "xn--jpb846bmjw88a.4", .status = 16} /* 5536 */,
    {.source = (const lxb_char_t *) "\u075F\u1BA2\u103Aⴇ.4", .ascii = (const lxb_char_t *) "xn--jpb846bjzj7pr.4", .status = 12} /* 5537 */,
    {.source = (const lxb_char_t *) "xn--jpb846bjzj7pr.4", .ascii = (const lxb_char_t *) "xn--jpb846bjzj7pr.4", .status = 12} /* 5538 */,
    {.source = (const lxb_char_t *) "xn--jpb846bmjw88a.4", .ascii = (const lxb_char_t *) "xn--jpb846bmjw88a.4", .status = 16} /* 5539 */,
    {.source = (const lxb_char_t *) "ᄹ｡\u0ECA򠯤󠄞", .ascii = (const lxb_char_t *) "xn--lrd.xn--s8c05302k", .status = 8} /* 5540 */,
    {.source = (const lxb_char_t *) "ᄹ。\u0ECA򠯤󠄞", .ascii = (const lxb_char_t *) "xn--lrd.xn--s8c05302k", .status = 8} /* 5541 */,
    {.source = (const lxb_char_t *) "xn--lrd.xn--s8c05302k", .ascii = (const lxb_char_t *) "xn--lrd.xn--s8c05302k", .status = 8} /* 5542 */,
    {.source = (const lxb_char_t *) "Ⴆ򻢩．󠆡\uFE09𞤍", .ascii = (const lxb_char_t *) "xn--end82983m.xn--ne6h", .status = 4} /* 5543 */,
    {.source = (const lxb_char_t *) "Ⴆ򻢩.󠆡\uFE09𞤍", .ascii = (const lxb_char_t *) "xn--end82983m.xn--ne6h", .status = 4} /* 5544 */,
    {.source = (const lxb_char_t *) "ⴆ򻢩.󠆡\uFE09𞤯", .ascii = (const lxb_char_t *) "xn--xkjw3965g.xn--ne6h", .status = 4} /* 5545 */,
    {.source = (const lxb_char_t *) "xn--xkjw3965g.xn--ne6h", .ascii = (const lxb_char_t *) "xn--xkjw3965g.xn--ne6h", .status = 4} /* 5546 */,
    {.source = (const lxb_char_t *) "xn--end82983m.xn--ne6h", .ascii = (const lxb_char_t *) "xn--end82983m.xn--ne6h", .status = 4} /* 5547 */,
    {.source = (const lxb_char_t *) "ⴆ򻢩．󠆡\uFE09𞤯", .ascii = (const lxb_char_t *) "xn--xkjw3965g.xn--ne6h", .status = 4} /* 5548 */,
    {.source = (const lxb_char_t *) "ⴆ򻢩.󠆡\uFE09𞤍", .ascii = (const lxb_char_t *) "xn--xkjw3965g.xn--ne6h", .status = 4} /* 5549 */,
    {.source = (const lxb_char_t *) "ⴆ򻢩．󠆡\uFE09𞤍", .ascii = (const lxb_char_t *) "xn--xkjw3965g.xn--ne6h", .status = 4} /* 5550 */,
    {.source = (const lxb_char_t *) "ß\u080B︒\u067B．帼F∬\u200C", .ascii = (const lxb_char_t *) "xn--zca68zj8ac956c.xn--f-sgn48ga6997e", .status = 16} /* 5551 */,
    {.source = (const lxb_char_t *) "ß\u080B。\u067B.帼F∫∫\u200C", .ascii = (const lxb_char_t *) "xn--zca687a.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5552 */,
    {.source = (const lxb_char_t *) "ß\u080B。\u067B.帼f∫∫\u200C", .ascii = (const lxb_char_t *) "xn--zca687a.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5553 */,
    {.source = (const lxb_char_t *) "SS\u080B。\u067B.帼F∫∫\u200C", .ascii = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5554 */,
    {.source = (const lxb_char_t *) "ss\u080B。\u067B.帼f∫∫\u200C", .ascii = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5555 */,
    {.source = (const lxb_char_t *) "Ss\u080B。\u067B.帼F∫∫\u200C", .ascii = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5556 */,
    {.source = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-tcoa9162d", .ascii = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-tcoa9162d", .status = 8} /* 5557 */,
    {.source = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-sgn48ga6997e", .ascii = (const lxb_char_t *) "xn--ss-uze.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5558 */,
    {.source = (const lxb_char_t *) "xn--zca687a.xn--0ib.xn--f-sgn48ga6997e", .ascii = (const lxb_char_t *) "xn--zca687a.xn--0ib.xn--f-sgn48ga6997e", .status = 12} /* 5559 */,
    {.source = (const lxb_char_t *) "ß\u080B︒\u067B．帼f∬\u200C", .ascii = (const lxb_char_t *) "xn--zca68zj8ac956c.xn--f-sgn48ga6997e", .status = 16} /* 5560 */,
    {.source = (const lxb_char_t *) "SS\u080B︒\u067B．帼F∬\u200C", .ascii = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-sgn48ga6997e", .status = 16} /* 5561 */,
    {.source = (const lxb_char_t *) "ss\u080B︒\u067B．帼f∬\u200C", .ascii = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-sgn48ga6997e", .status = 16} /* 5562 */,
    {.source = (const lxb_char_t *) "Ss\u080B︒\u067B．帼F∬\u200C", .ascii = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-sgn48ga6997e", .status = 16} /* 5563 */,
    {.source = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-tcoa9162d", .ascii = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-tcoa9162d", .status = 12} /* 5564 */,
    {.source = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-sgn48ga6997e", .ascii = (const lxb_char_t *) "xn--ss-k0d31nu121d.xn--f-sgn48ga6997e", .status = 16} /* 5565 */,
    {.source = (const lxb_char_t *) "xn--zca68zj8ac956c.xn--f-sgn48ga6997e", .ascii = (const lxb_char_t *) "xn--zca68zj8ac956c.xn--f-sgn48ga6997e", .status = 16} /* 5566 */,
    {.source = (const lxb_char_t *) "󘪗｡𐹴𞨌\u200D", .ascii = (const lxb_char_t *) "xn--8l83e.xn--1ug4105gsxwf", .status = 12} /* 5567 */,
    {.source = (const lxb_char_t *) "󘪗。𐹴𞨌\u200D", .ascii = (const lxb_char_t *) "xn--8l83e.xn--1ug4105gsxwf", .status = 12} /* 5568 */,
    {.source = (const lxb_char_t *) "xn--8l83e.xn--so0dw168a", .ascii = (const lxb_char_t *) "xn--8l83e.xn--so0dw168a", .status = 8} /* 5569 */,
    {.source = (const lxb_char_t *) "xn--8l83e.xn--1ug4105gsxwf", .ascii = (const lxb_char_t *) "xn--8l83e.xn--1ug4105gsxwf", .status = 12} /* 5570 */,
    {.source = (const lxb_char_t *) "񗛨.򅟢𝟨\uA8C4", .ascii = (const lxb_char_t *) "xn--mi60a.xn--6-sl4es8023c", .status = 4} /* 5571 */,
    {.source = (const lxb_char_t *) "񗛨.򅟢6\uA8C4", .ascii = (const lxb_char_t *) "xn--mi60a.xn--6-sl4es8023c", .status = 4} /* 5572 */,
    {.source = (const lxb_char_t *) "xn--mi60a.xn--6-sl4es8023c", .ascii = (const lxb_char_t *) "xn--mi60a.xn--6-sl4es8023c", .status = 4} /* 5573 */,
    {.source = (const lxb_char_t *) "\u1AB2\uFD8E。-۹ႱႨ", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc155e9a", .status = 16} /* 5574 */,
    {.source = (const lxb_char_t *) "\u1AB2\u0645\u062E\u062C。-۹ႱႨ", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc155e9a", .status = 16} /* 5575 */,
    {.source = (const lxb_char_t *) "\u1AB2\u0645\u062E\u062C。-۹ⴑⴈ", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc3430a9a", .status = 12} /* 5576 */,
    {.source = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc3430a9a", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc3430a9a", .status = 12} /* 5577 */,
    {.source = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc155e9a", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc155e9a", .status = 16} /* 5578 */,
    {.source = (const lxb_char_t *) "\u1AB2\uFD8E。-۹ⴑⴈ", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc3430a9a", .status = 12} /* 5579 */,
    {.source = (const lxb_char_t *) "\u1AB2\u0645\u062E\u062C。-۹Ⴑⴈ", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc875efr3a", .status = 16} /* 5580 */,
    {.source = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc875efr3a", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc875efr3a", .status = 16} /* 5581 */,
    {.source = (const lxb_char_t *) "\u1AB2\uFD8E。-۹Ⴑⴈ", .ascii = (const lxb_char_t *) "xn--rgbd2e831i.xn----zyc875efr3a", .status = 16} /* 5582 */,
    {.source = (const lxb_char_t *) "𞤤．-\u08A3︒", .ascii = (const lxb_char_t *) "xn--ce6h.xn----cod7069p", .status = 12} /* 5583 */,
    {.source = (const lxb_char_t *) "𞤤.-\u08A3。", .ascii = (const lxb_char_t *) "xn--ce6h.xn----cod.", .status = 8} /* 5584 */,
    {.source = (const lxb_char_t *) "𞤂.-\u08A3。", .ascii = (const lxb_char_t *) "xn--ce6h.xn----cod.", .status = 8} /* 5585 */,
    {.source = (const lxb_char_t *) "xn--ce6h.xn----cod.", .ascii = (const lxb_char_t *) "xn--ce6h.xn----cod.", .status = 8} /* 5586 */,
    {.source = (const lxb_char_t *) "𞤂．-\u08A3︒", .ascii = (const lxb_char_t *) "xn--ce6h.xn----cod7069p", .status = 12} /* 5587 */,
    {.source = (const lxb_char_t *) "xn--ce6h.xn----cod7069p", .ascii = (const lxb_char_t *) "xn--ce6h.xn----cod7069p", .status = 12} /* 5588 */,
    {.source = (const lxb_char_t *) "\u200C𐺨.\u0859--", .ascii = (const lxb_char_t *) "xn--0ug7905g.xn-----h6e", .status = 16} /* 5589 */,
    {.source = (const lxb_char_t *) "xn--9p0d.xn-----h6e", .ascii = (const lxb_char_t *) "xn--9p0d.xn-----h6e", .status = 12} /* 5590 */,
    {.source = (const lxb_char_t *) "xn--0ug7905g.xn-----h6e", .ascii = (const lxb_char_t *) "xn--0ug7905g.xn-----h6e", .status = 16} /* 5591 */,
    {.source = (const lxb_char_t *) "𐋸󮘋Ⴢ.Ⴁ", .ascii = (const lxb_char_t *) "xn--6nd5215jr2u0h.xn--8md", .status = 4} /* 5592 */,
    {.source = (const lxb_char_t *) "𐋸󮘋ⴢ.ⴁ", .ascii = (const lxb_char_t *) "xn--qlj1559dr224h.xn--skj", .status = 4} /* 5593 */,
    {.source = (const lxb_char_t *) "𐋸󮘋Ⴢ.ⴁ", .ascii = (const lxb_char_t *) "xn--6nd5215jr2u0h.xn--skj", .status = 4} /* 5594 */,
    {.source = (const lxb_char_t *) "xn--6nd5215jr2u0h.xn--skj", .ascii = (const lxb_char_t *) "xn--6nd5215jr2u0h.xn--skj", .status = 4} /* 5595 */,
    {.source = (const lxb_char_t *) "xn--qlj1559dr224h.xn--skj", .ascii = (const lxb_char_t *) "xn--qlj1559dr224h.xn--skj", .status = 4} /* 5596 */,
    {.source = (const lxb_char_t *) "xn--6nd5215jr2u0h.xn--8md", .ascii = (const lxb_char_t *) "xn--6nd5215jr2u0h.xn--8md", .status = 4} /* 5597 */,
    {.source = (const lxb_char_t *) "񗑿\uA806₄򩞆｡𲩧󠒹ς", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--3xa51142bk3f0d", .status = 4} /* 5598 */,
    {.source = (const lxb_char_t *) "񗑿\uA8064򩞆。𲩧󠒹ς", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--3xa51142bk3f0d", .status = 4} /* 5599 */,
    {.source = (const lxb_char_t *) "񗑿\uA8064򩞆。𲩧󠒹Σ", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--4xa31142bk3f0d", .status = 4} /* 5600 */,
    {.source = (const lxb_char_t *) "񗑿\uA8064򩞆。𲩧󠒹σ", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--4xa31142bk3f0d", .status = 4} /* 5601 */,
    {.source = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--4xa31142bk3f0d", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--4xa31142bk3f0d", .status = 4} /* 5602 */,
    {.source = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--3xa51142bk3f0d", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--3xa51142bk3f0d", .status = 4} /* 5603 */,
    {.source = (const lxb_char_t *) "񗑿\uA806₄򩞆｡𲩧󠒹Σ", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--4xa31142bk3f0d", .status = 4} /* 5604 */,
    {.source = (const lxb_char_t *) "񗑿\uA806₄򩞆｡𲩧󠒹σ", .ascii = (const lxb_char_t *) "xn--4-w93ej7463a9io5a.xn--4xa31142bk3f0d", .status = 4} /* 5605 */,
    {.source = (const lxb_char_t *) "󠆀\u0723。\u1DF4\u0775", .ascii = (const lxb_char_t *) "xn--tnb.xn--5pb136i", .status = 8} /* 5606 */,
    {.source = (const lxb_char_t *) "xn--tnb.xn--5pb136i", .ascii = (const lxb_char_t *) "xn--tnb.xn--5pb136i", .status = 8} /* 5607 */,
    {.source = (const lxb_char_t *) "𐹱\u0842𝪨｡𬼖Ⴑ\u200D", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--pnd879eqy33c", .status = 16} /* 5608 */,
    {.source = (const lxb_char_t *) "𐹱\u0842𝪨。𬼖Ⴑ\u200D", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--pnd879eqy33c", .status = 16} /* 5609 */,
    {.source = (const lxb_char_t *) "𐹱\u0842𝪨。𬼖ⴑ\u200D", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--1ug742c5714c", .status = 12} /* 5610 */,
    {.source = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--8kjz186s", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--8kjz186s", .status = 4} /* 5611 */,
    {.source = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--1ug742c5714c", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--1ug742c5714c", .status = 12} /* 5612 */,
    {.source = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--pnd93707a", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--pnd93707a", .status = 8} /* 5613 */,
    {.source = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--pnd879eqy33c", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--pnd879eqy33c", .status = 16} /* 5614 */,
    {.source = (const lxb_char_t *) "𐹱\u0842𝪨｡𬼖ⴑ\u200D", .ascii = (const lxb_char_t *) "xn--0vb1535kdb6e.xn--1ug742c5714c", .status = 12} /* 5615 */,
    {.source = (const lxb_char_t *) "\u1714𐭪󠙘\u200D｡-𐹴", .ascii = (const lxb_char_t *) "xn--fze807bso0spy14i.xn----c36i", .status = 20} /* 5616 */,
    {.source = (const lxb_char_t *) "\u1714𐭪󠙘\u200D。-𐹴", .ascii = (const lxb_char_t *) "xn--fze807bso0spy14i.xn----c36i", .status = 20} /* 5617 */,
    {.source = (const lxb_char_t *) "xn--fze4126jujt0g.xn----c36i", .ascii = (const lxb_char_t *) "xn--fze4126jujt0g.xn----c36i", .status = 16} /* 5618 */,
    {.source = (const lxb_char_t *) "xn--fze807bso0spy14i.xn----c36i", .ascii = (const lxb_char_t *) "xn--fze807bso0spy14i.xn----c36i", .status = 20} /* 5619 */,
    {.source = (const lxb_char_t *) "𾢬｡\u0729︒쯙𝟧", .ascii = (const lxb_char_t *) "xn--t92s.xn--5-p1c0712mm8rb", .status = 8} /* 5620 */,
    {.source = (const lxb_char_t *) "𾢬｡\u0729︒쯙𝟧", .ascii = (const lxb_char_t *) "xn--t92s.xn--5-p1c0712mm8rb", .status = 8} /* 5621 */,
    {.source = (const lxb_char_t *) "𾢬。\u0729。쯙5", .ascii = (const lxb_char_t *) "xn--t92s.xn--znb.xn--5-y88f", .status = 4} /* 5622 */,
    {.source = (const lxb_char_t *) "𾢬。\u0729。쯙5", .ascii = (const lxb_char_t *) "xn--t92s.xn--znb.xn--5-y88f", .status = 4} /* 5623 */,
    {.source = (const lxb_char_t *) "xn--t92s.xn--znb.xn--5-y88f", .ascii = (const lxb_char_t *) "xn--t92s.xn--znb.xn--5-y88f", .status = 4} /* 5624 */,
    {.source = (const lxb_char_t *) "xn--t92s.xn--5-p1c0712mm8rb", .ascii = (const lxb_char_t *) "xn--t92s.xn--5-p1c0712mm8rb", .status = 8} /* 5625 */,
    {.source = (const lxb_char_t *) "𞤟-。\u0762≮뻐", .ascii = (const lxb_char_t *) "xn----1j8r.xn--mpb269krv4i", .status = 12} /* 5626 */,
    {.source = (const lxb_char_t *) "𞤟-。\u0762<\u0338뻐", .ascii = (const lxb_char_t *) "xn----1j8r.xn--mpb269krv4i", .status = 12} /* 5627 */,
    {.source = (const lxb_char_t *) "𞥁-。\u0762<\u0338뻐", .ascii = (const lxb_char_t *) "xn----1j8r.xn--mpb269krv4i", .status = 12} /* 5628 */,
    {.source = (const lxb_char_t *) "𞥁-。\u0762≮뻐", .ascii = (const lxb_char_t *) "xn----1j8r.xn--mpb269krv4i", .status = 12} /* 5629 */,
    {.source = (const lxb_char_t *) "xn----1j8r.xn--mpb269krv4i", .ascii = (const lxb_char_t *) "xn----1j8r.xn--mpb269krv4i", .status = 12} /* 5630 */,
    {.source = (const lxb_char_t *) "𞥩-򊫠．\u08B4≠", .ascii = (const lxb_char_t *) "xn----cm8rp3609a.xn--9yb852k", .status = 12} /* 5631 */,
    {.source = (const lxb_char_t *) "𞥩-򊫠．\u08B4=\u0338", .ascii = (const lxb_char_t *) "xn----cm8rp3609a.xn--9yb852k", .status = 12} /* 5632 */,
    {.source = (const lxb_char_t *) "𞥩-򊫠.\u08B4≠", .ascii = (const lxb_char_t *) "xn----cm8rp3609a.xn--9yb852k", .status = 12} /* 5633 */,
    {.source = (const lxb_char_t *) "𞥩-򊫠.\u08B4=\u0338", .ascii = (const lxb_char_t *) "xn----cm8rp3609a.xn--9yb852k", .status = 12} /* 5634 */,
    {.source = (const lxb_char_t *) "xn----cm8rp3609a.xn--9yb852k", .ascii = (const lxb_char_t *) "xn----cm8rp3609a.xn--9yb852k", .status = 12} /* 5635 */,
    {.source = (const lxb_char_t *) "-񅂏ςႼ．\u0661", .ascii = (const lxb_char_t *) "xn----ymb080hun11i.xn--9hb", .status = 12} /* 5636 */,
    {.source = (const lxb_char_t *) "-񅂏ςႼ.\u0661", .ascii = (const lxb_char_t *) "xn----ymb080hun11i.xn--9hb", .status = 12} /* 5637 */,
    {.source = (const lxb_char_t *) "-񅂏ςⴜ.\u0661", .ascii = (const lxb_char_t *) "xn----ymb2782aov12f.xn--9hb", .status = 12} /* 5638 */,
    {.source = (const lxb_char_t *) "-񅂏ΣႼ.\u0661", .ascii = (const lxb_char_t *) "xn----0mb770hun11i.xn--9hb", .status = 12} /* 5639 */,
    {.source = (const lxb_char_t *) "-񅂏σⴜ.\u0661", .ascii = (const lxb_char_t *) "xn----0mb9682aov12f.xn--9hb", .status = 12} /* 5640 */,
    {.source = (const lxb_char_t *) "-񅂏Σⴜ.\u0661", .ascii = (const lxb_char_t *) "xn----0mb9682aov12f.xn--9hb", .status = 12} /* 5641 */,
    {.source = (const lxb_char_t *) "xn----0mb9682aov12f.xn--9hb", .ascii = (const lxb_char_t *) "xn----0mb9682aov12f.xn--9hb", .status = 12} /* 5642 */,
    {.source = (const lxb_char_t *) "xn----0mb770hun11i.xn--9hb", .ascii = (const lxb_char_t *) "xn----0mb770hun11i.xn--9hb", .status = 12} /* 5643 */,
    {.source = (const lxb_char_t *) "xn----ymb2782aov12f.xn--9hb", .ascii = (const lxb_char_t *) "xn----ymb2782aov12f.xn--9hb", .status = 12} /* 5644 */,
    {.source = (const lxb_char_t *) "xn----ymb080hun11i.xn--9hb", .ascii = (const lxb_char_t *) "xn----ymb080hun11i.xn--9hb", .status = 12} /* 5645 */,
    {.source = (const lxb_char_t *) "-񅂏ςⴜ．\u0661", .ascii = (const lxb_char_t *) "xn----ymb2782aov12f.xn--9hb", .status = 12} /* 5646 */,
    {.source = (const lxb_char_t *) "-񅂏ΣႼ．\u0661", .ascii = (const lxb_char_t *) "xn----0mb770hun11i.xn--9hb", .status = 12} /* 5647 */,
    {.source = (const lxb_char_t *) "-񅂏σⴜ．\u0661", .ascii = (const lxb_char_t *) "xn----0mb9682aov12f.xn--9hb", .status = 12} /* 5648 */,
    {.source = (const lxb_char_t *) "-񅂏Σⴜ．\u0661", .ascii = (const lxb_char_t *) "xn----0mb9682aov12f.xn--9hb", .status = 12} /* 5649 */,
    {.source = (const lxb_char_t *) "\u17CA.\u200D𝟮𑀿", .ascii = (const lxb_char_t *) "xn--m4e.xn--2-tgnv469h", .status = 8} /* 5650 */,
    {.source = (const lxb_char_t *) "\u17CA.\u200D2𑀿", .ascii = (const lxb_char_t *) "xn--m4e.xn--2-tgnv469h", .status = 8} /* 5651 */,
    {.source = (const lxb_char_t *) "xn--m4e.xn--2-ku7i", .ascii = (const lxb_char_t *) "xn--m4e.xn--2-ku7i", .status = 4} /* 5652 */,
    {.source = (const lxb_char_t *) "xn--m4e.xn--2-tgnv469h", .ascii = (const lxb_char_t *) "xn--m4e.xn--2-tgnv469h", .status = 8} /* 5653 */,
    {.source = (const lxb_char_t *) "≯𝟖｡\u1A60𐫓򟇑", .ascii = (const lxb_char_t *) "xn--8-ogo.xn--jof5303iv1z5d", .status = 12} /* 5654 */,
    {.source = (const lxb_char_t *) ">\u0338𝟖｡\u1A60𐫓򟇑", .ascii = (const lxb_char_t *) "xn--8-ogo.xn--jof5303iv1z5d", .status = 12} /* 5655 */,
    {.source = (const lxb_char_t *) "≯8。\u1A60𐫓򟇑", .ascii = (const lxb_char_t *) "xn--8-ogo.xn--jof5303iv1z5d", .status = 12} /* 5656 */,
    {.source = (const lxb_char_t *) ">\u03388。\u1A60𐫓򟇑", .ascii = (const lxb_char_t *) "xn--8-ogo.xn--jof5303iv1z5d", .status = 12} /* 5657 */,
    {.source = (const lxb_char_t *) "xn--8-ogo.xn--jof5303iv1z5d", .ascii = (const lxb_char_t *) "xn--8-ogo.xn--jof5303iv1z5d", .status = 12} /* 5658 */,
    {.source = (const lxb_char_t *) "𑲫Ↄ\u0664｡\u200C", .ascii = (const lxb_char_t *) "xn--dib999kcy1p.xn--0ug", .status = 16} /* 5659 */,
    {.source = (const lxb_char_t *) "𑲫Ↄ\u0664。\u200C", .ascii = (const lxb_char_t *) "xn--dib999kcy1p.xn--0ug", .status = 16} /* 5660 */,
    {.source = (const lxb_char_t *) "𑲫ↄ\u0664。\u200C", .ascii = (const lxb_char_t *) "xn--dib100l8x1p.xn--0ug", .status = 12} /* 5661 */,
    {.source = (const lxb_char_t *) "xn--dib100l8x1p.", .ascii = (const lxb_char_t *) "xn--dib100l8x1p.", .status = 8} /* 5662 */,
    {.source = (const lxb_char_t *) "xn--dib100l8x1p.xn--0ug", .ascii = (const lxb_char_t *) "xn--dib100l8x1p.xn--0ug", .status = 12} /* 5663 */,
    {.source = (const lxb_char_t *) "xn--dib999kcy1p.", .ascii = (const lxb_char_t *) "xn--dib999kcy1p.", .status = 12} /* 5664 */,
    {.source = (const lxb_char_t *) "xn--dib999kcy1p.xn--0ug", .ascii = (const lxb_char_t *) "xn--dib999kcy1p.xn--0ug", .status = 16} /* 5665 */,
    {.source = (const lxb_char_t *) "𑲫ↄ\u0664｡\u200C", .ascii = (const lxb_char_t *) "xn--dib100l8x1p.xn--0ug", .status = 12} /* 5666 */,
    {.source = (const lxb_char_t *) "\u0C00𝟵\u200D\uFC9D.\u200D\u0750⒈", .ascii = (const lxb_char_t *) "xn--9-1mcp570dl51a.xn--3ob977jmfd", .status = 16} /* 5667 */,
    {.source = (const lxb_char_t *) "\u0C009\u200D\u0628\u062D.\u200D\u07501.", .ascii = (const lxb_char_t *) "xn--9-1mcp570dl51a.xn--1-x3c211q.", .status = 12} /* 5668 */,
    {.source = (const lxb_char_t *) "xn--9-1mcp570d.xn--1-x3c.", .ascii = (const lxb_char_t *) "xn--9-1mcp570d.xn--1-x3c.", .status = 8} /* 5669 */,
    {.source = (const lxb_char_t *) "xn--9-1mcp570dl51a.xn--1-x3c211q.", .ascii = (const lxb_char_t *) "xn--9-1mcp570dl51a.xn--1-x3c211q.", .status = 12} /* 5670 */,
    {.source = (const lxb_char_t *) "xn--9-1mcp570d.xn--3ob470m", .ascii = (const lxb_char_t *) "xn--9-1mcp570d.xn--3ob470m", .status = 12} /* 5671 */,
    {.source = (const lxb_char_t *) "xn--9-1mcp570dl51a.xn--3ob977jmfd", .ascii = (const lxb_char_t *) "xn--9-1mcp570dl51a.xn--3ob977jmfd", .status = 16} /* 5672 */,
    {.source = (const lxb_char_t *) "\uAAF6。嬶ß葽", .ascii = (const lxb_char_t *) "xn--2v9a.xn--zca7637b14za", .status = 4} /* 5673 */,
    {.source = (const lxb_char_t *) "\uAAF6。嬶SS葽", .ascii = (const lxb_char_t *) "xn--2v9a.xn--ss-q40dp97m", .status = 4} /* 5674 */,
    {.source = (const lxb_char_t *) "\uAAF6。嬶ss葽", .ascii = (const lxb_char_t *) "xn--2v9a.xn--ss-q40dp97m", .status = 4} /* 5675 */,
    {.source = (const lxb_char_t *) "\uAAF6。嬶Ss葽", .ascii = (const lxb_char_t *) "xn--2v9a.xn--ss-q40dp97m", .status = 4} /* 5676 */,
    {.source = (const lxb_char_t *) "xn--2v9a.xn--ss-q40dp97m", .ascii = (const lxb_char_t *) "xn--2v9a.xn--ss-q40dp97m", .status = 4} /* 5677 */,
    {.source = (const lxb_char_t *) "xn--2v9a.xn--zca7637b14za", .ascii = (const lxb_char_t *) "xn--2v9a.xn--zca7637b14za", .status = 4} /* 5678 */,
    {.source = (const lxb_char_t *) "𑚶⒈。񞻡𐹺", .ascii = (const lxb_char_t *) "xn--tshz969f.xn--yo0d5914s", .status = 16} /* 5679 */,
    {.source = (const lxb_char_t *) "𑚶1.。񞻡𐹺", .ascii = (const lxb_char_t *) "xn--1-3j0j..xn--yo0d5914s", .status = 22} /* 5680 */,
    {.source = (const lxb_char_t *) "xn--1-3j0j..xn--yo0d5914s", .ascii = (const lxb_char_t *) "xn--1-3j0j..xn--yo0d5914s", .status = 22} /* 5681 */,
    {.source = (const lxb_char_t *) "xn--tshz969f.xn--yo0d5914s", .ascii = (const lxb_char_t *) "xn--tshz969f.xn--yo0d5914s", .status = 16} /* 5682 */,
    {.source = (const lxb_char_t *) "𑜤︒≮．񚕽\u05D8𞾩", .ascii = (const lxb_char_t *) "xn--gdh5267fdzpa.xn--deb0091w5q9u", .status = 20} /* 5683 */,
    {.source = (const lxb_char_t *) "𑜤︒<\u0338．񚕽\u05D8𞾩", .ascii = (const lxb_char_t *) "xn--gdh5267fdzpa.xn--deb0091w5q9u", .status = 20} /* 5684 */,
    {.source = (const lxb_char_t *) "𑜤。≮.񚕽\u05D8𞾩", .ascii = (const lxb_char_t *) "xn--ci2d.xn--gdh.xn--deb0091w5q9u", .status = 20} /* 5685 */,
    {.source = (const lxb_char_t *) "𑜤。<\u0338.񚕽\u05D8𞾩", .ascii = (const lxb_char_t *) "xn--ci2d.xn--gdh.xn--deb0091w5q9u", .status = 20} /* 5686 */,
    {.source = (const lxb_char_t *) "xn--ci2d.xn--gdh.xn--deb0091w5q9u", .ascii = (const lxb_char_t *) "xn--ci2d.xn--gdh.xn--deb0091w5q9u", .status = 20} /* 5687 */,
    {.source = (const lxb_char_t *) "xn--gdh5267fdzpa.xn--deb0091w5q9u", .ascii = (const lxb_char_t *) "xn--gdh5267fdzpa.xn--deb0091w5q9u", .status = 20} /* 5688 */,
    {.source = (const lxb_char_t *) "󠆋\u0603񏦤.⇁ς򏋈򺇥", .ascii = (const lxb_char_t *) "xn--lfb04106d.xn--3xa174mxv16m8moq", .status = 8} /* 5689 */,
    {.source = (const lxb_char_t *) "󠆋\u0603񏦤.⇁Σ򏋈򺇥", .ascii = (const lxb_char_t *) "xn--lfb04106d.xn--4xa964mxv16m8moq", .status = 8} /* 5690 */,
    {.source = (const lxb_char_t *) "󠆋\u0603񏦤.⇁σ򏋈򺇥", .ascii = (const lxb_char_t *) "xn--lfb04106d.xn--4xa964mxv16m8moq", .status = 8} /* 5691 */,
    {.source = (const lxb_char_t *) "xn--lfb04106d.xn--4xa964mxv16m8moq", .ascii = (const lxb_char_t *) "xn--lfb04106d.xn--4xa964mxv16m8moq", .status = 8} /* 5692 */,
    {.source = (const lxb_char_t *) "xn--lfb04106d.xn--3xa174mxv16m8moq", .ascii = (const lxb_char_t *) "xn--lfb04106d.xn--3xa174mxv16m8moq", .status = 8} /* 5693 */,
    {.source = (const lxb_char_t *) "ς𑐽𵢈𑜫｡𞬩\u200C𐫄", .ascii = (const lxb_char_t *) "xn--3xa4260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5694 */,
    {.source = (const lxb_char_t *) "ς𑐽𵢈𑜫。𞬩\u200C𐫄", .ascii = (const lxb_char_t *) "xn--3xa4260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5695 */,
    {.source = (const lxb_char_t *) "Σ𑐽𵢈𑜫。𞬩\u200C𐫄", .ascii = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5696 */,
    {.source = (const lxb_char_t *) "σ𑐽𵢈𑜫。𞬩\u200C𐫄", .ascii = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5697 */,
    {.source = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--tw9ct349a", .ascii = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--tw9ct349a", .status = 4} /* 5698 */,
    {.source = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--0ug4653g2xzf", .ascii = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5699 */,
    {.source = (const lxb_char_t *) "xn--3xa4260lk3b8z15g.xn--0ug4653g2xzf", .ascii = (const lxb_char_t *) "xn--3xa4260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5700 */,
    {.source = (const lxb_char_t *) "Σ𑐽𵢈𑜫｡𞬩\u200C𐫄", .ascii = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5701 */,
    {.source = (const lxb_char_t *) "σ𑐽𵢈𑜫｡𞬩\u200C𐫄", .ascii = (const lxb_char_t *) "xn--4xa2260lk3b8z15g.xn--0ug4653g2xzf", .status = 8} /* 5702 */,
    {.source = (const lxb_char_t *) "-򵏽｡-\uFC4C\u075B", .ascii = (const lxb_char_t *) "xn----o452j.xn----cnc8e38c", .status = 12} /* 5703 */,
    {.source = (const lxb_char_t *) "-򵏽。-\u0646\u062D\u075B", .ascii = (const lxb_char_t *) "xn----o452j.xn----cnc8e38c", .status = 12} /* 5704 */,
    {.source = (const lxb_char_t *) "xn----o452j.xn----cnc8e38c", .ascii = (const lxb_char_t *) "xn----o452j.xn----cnc8e38c", .status = 12} /* 5705 */,
    {.source = (const lxb_char_t *) "⺢򇺅𝟤｡\u200D🚷", .ascii = (const lxb_char_t *) "xn--2-4jtr4282f.xn--1ugz946p", .status = 8} /* 5706 */,
    {.source = (const lxb_char_t *) "⺢򇺅2。\u200D🚷", .ascii = (const lxb_char_t *) "xn--2-4jtr4282f.xn--1ugz946p", .status = 8} /* 5707 */,
    {.source = (const lxb_char_t *) "xn--2-4jtr4282f.xn--m78h", .ascii = (const lxb_char_t *) "xn--2-4jtr4282f.xn--m78h", .status = 4} /* 5708 */,
    {.source = (const lxb_char_t *) "xn--2-4jtr4282f.xn--1ugz946p", .ascii = (const lxb_char_t *) "xn--2-4jtr4282f.xn--1ugz946p", .status = 8} /* 5709 */,
    {.source = (const lxb_char_t *) "\u0CF8\u200D\u2DFE𐹲｡򤐶", .ascii = (const lxb_char_t *) "xn--hvc488g69j402t.xn--3e36c", .status = 16} /* 5710 */,
    {.source = (const lxb_char_t *) "\u0CF8\u200D\u2DFE𐹲。򤐶", .ascii = (const lxb_char_t *) "xn--hvc488g69j402t.xn--3e36c", .status = 16} /* 5711 */,
    {.source = (const lxb_char_t *) "xn--hvc220of37m.xn--3e36c", .ascii = (const lxb_char_t *) "xn--hvc220of37m.xn--3e36c", .status = 12} /* 5712 */,
    {.source = (const lxb_char_t *) "xn--hvc488g69j402t.xn--3e36c", .ascii = (const lxb_char_t *) "xn--hvc488g69j402t.xn--3e36c", .status = 16} /* 5713 */,
    {.source = (const lxb_char_t *) "𐹢．Ⴍ₉⁸", .ascii = (const lxb_char_t *) "xn--9n0d.xn--98-7ek", .status = 8} /* 5714 */,
    {.source = (const lxb_char_t *) "𐹢.Ⴍ98", .ascii = (const lxb_char_t *) "xn--9n0d.xn--98-7ek", .status = 8} /* 5715 */,
    {.source = (const lxb_char_t *) "𐹢.ⴍ98", .ascii = (const lxb_char_t *) "xn--9n0d.xn--98-u61a", .status = 4} /* 5716 */,
    {.source = (const lxb_char_t *) "xn--9n0d.xn--98-u61a", .ascii = (const lxb_char_t *) "xn--9n0d.xn--98-u61a", .status = 4} /* 5717 */,
    {.source = (const lxb_char_t *) "xn--9n0d.xn--98-7ek", .ascii = (const lxb_char_t *) "xn--9n0d.xn--98-7ek", .status = 8} /* 5718 */,
    {.source = (const lxb_char_t *) "𐹢．ⴍ₉⁸", .ascii = (const lxb_char_t *) "xn--9n0d.xn--98-u61a", .status = 4} /* 5719 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡ß\u08E2⒚≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--zca612bx9vo5b", .status = 20} /* 5720 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡ß\u08E2⒚>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--zca612bx9vo5b", .status = 20} /* 5721 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。ß\u08E219.≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--19-fia813f.xn--hdh", .status = 16} /* 5722 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。ß\u08E219.>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--19-fia813f.xn--hdh", .status = 16} /* 5723 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。SS\u08E219.>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5724 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。SS\u08E219.≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5725 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。ss\u08E219.≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5726 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。ss\u08E219.>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5727 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。Ss\u08E219.>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5728 */,
    {.source = (const lxb_char_t *) "\u200C\u034F。Ss\u08E219.≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5729 */,
    {.source = (const lxb_char_t *) ".xn--ss19-w0i.xn--hdh", .ascii = (const lxb_char_t *) ".xn--ss19-w0i.xn--hdh", .status = 18} /* 5730 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss19-w0i.xn--hdh", .status = 16} /* 5731 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--19-fia813f.xn--hdh", .ascii = (const lxb_char_t *) "xn--0ug.xn--19-fia813f.xn--hdh", .status = 16} /* 5732 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡SS\u08E2⒚>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5733 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡SS\u08E2⒚≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5734 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡ss\u08E2⒚≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5735 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡ss\u08E2⒚>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5736 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡Ss\u08E2⒚>\u0338", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5737 */,
    {.source = (const lxb_char_t *) "\u200C\u034F｡Ss\u08E2⒚≯", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5738 */,
    {.source = (const lxb_char_t *) ".xn--ss-9if872xjjc", .ascii = (const lxb_char_t *) ".xn--ss-9if872xjjc", .status = 18} /* 5739 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .ascii = (const lxb_char_t *) "xn--0ug.xn--ss-9if872xjjc", .status = 20} /* 5740 */,
    {.source = (const lxb_char_t *) "xn--0ug.xn--zca612bx9vo5b", .ascii = (const lxb_char_t *) "xn--0ug.xn--zca612bx9vo5b", .status = 20} /* 5741 */,
    {.source = (const lxb_char_t *) "\u200C𞥍ᡌ．𣃔", .ascii = (const lxb_char_t *) "xn--c8e180bqz13b.xn--od1j", .status = 12} /* 5742 */,
    {.source = (const lxb_char_t *) "\u200C𞥍ᡌ.𣃔", .ascii = (const lxb_char_t *) "xn--c8e180bqz13b.xn--od1j", .status = 12} /* 5743 */,
    {.source = (const lxb_char_t *) "xn--c8e5919u.xn--od1j", .ascii = (const lxb_char_t *) "xn--c8e5919u.xn--od1j", .status = 12} /* 5744 */,
    {.source = (const lxb_char_t *) "xn--c8e180bqz13b.xn--od1j", .ascii = (const lxb_char_t *) "xn--c8e180bqz13b.xn--od1j", .status = 12} /* 5745 */,
    {.source = (const lxb_char_t *) "\u07D0򜬝-񡢬。\u0FA0Ⴛ𞷏𝆬", .ascii = (const lxb_char_t *) "xn----8bd11730jefvw.xn--wfd08cd265hgsxa", .status = 20} /* 5746 */,
    {.source = (const lxb_char_t *) "\u07D0򜬝-񡢬。\u0FA0ⴛ𞷏𝆬", .ascii = (const lxb_char_t *) "xn----8bd11730jefvw.xn--wfd802mpm20agsxa", .status = 20} /* 5747 */,
    {.source = (const lxb_char_t *) "xn----8bd11730jefvw.xn--wfd802mpm20agsxa", .ascii = (const lxb_char_t *) "xn----8bd11730jefvw.xn--wfd802mpm20agsxa", .status = 20} /* 5748 */,
    {.source = (const lxb_char_t *) "xn----8bd11730jefvw.xn--wfd08cd265hgsxa", .ascii = (const lxb_char_t *) "xn----8bd11730jefvw.xn--wfd08cd265hgsxa", .status = 20} /* 5749 */,
    {.source = (const lxb_char_t *) "𝨥。⫟𑈾", .ascii = (const lxb_char_t *) "xn--n82h.xn--63iw010f", .status = 4} /* 5750 */,
    {.source = (const lxb_char_t *) "xn--n82h.xn--63iw010f", .ascii = (const lxb_char_t *) "xn--n82h.xn--63iw010f", .status = 4} /* 5751 */,
    {.source = (const lxb_char_t *) "⾛\u0753.Ⴕ𞠬\u0604\u200D", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb785czmm0y85b", .status = 16} /* 5752 */,
    {.source = (const lxb_char_t *) "走\u0753.Ⴕ𞠬\u0604\u200D", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb785czmm0y85b", .status = 16} /* 5753 */,
    {.source = (const lxb_char_t *) "走\u0753.ⴕ𞠬\u0604\u200D", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb444k5gjt754b", .status = 16} /* 5754 */,
    {.source = (const lxb_char_t *) "xn--6ob9779d.xn--mfb511rxu80a", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb511rxu80a", .status = 12} /* 5755 */,
    {.source = (const lxb_char_t *) "xn--6ob9779d.xn--mfb444k5gjt754b", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb444k5gjt754b", .status = 16} /* 5756 */,
    {.source = (const lxb_char_t *) "xn--6ob9779d.xn--mfb785ck569a", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb785ck569a", .status = 12} /* 5757 */,
    {.source = (const lxb_char_t *) "xn--6ob9779d.xn--mfb785czmm0y85b", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb785czmm0y85b", .status = 16} /* 5758 */,
    {.source = (const lxb_char_t *) "⾛\u0753.ⴕ𞠬\u0604\u200D", .ascii = (const lxb_char_t *) "xn--6ob9779d.xn--mfb444k5gjt754b", .status = 16} /* 5759 */,
    {.source = (const lxb_char_t *) "-ᢗ\u200C🄄.𑜢", .ascii = (const lxb_char_t *) "xn----pck312bx563c.xn--9h2d", .status = 16} /* 5760 */,
    {.source = (const lxb_char_t *) "-ᢗ\u200C3,.𑜢", .ascii = (const lxb_char_t *) "xn---3,-3eu051c.xn--9h2d", .status = 16} /* 5761 */,
    {.source = (const lxb_char_t *) "xn---3,-3eu.xn--9h2d", .ascii = (const lxb_char_t *) "xn---3,-3eu.xn--9h2d", .status = 12} /* 5762 */,
    {.source = (const lxb_char_t *) "xn---3,-3eu051c.xn--9h2d", .ascii = (const lxb_char_t *) "xn---3,-3eu051c.xn--9h2d", .status = 16} /* 5763 */,
    {.source = (const lxb_char_t *) "xn----pck1820x.xn--9h2d", .ascii = (const lxb_char_t *) "xn----pck1820x.xn--9h2d", .status = 12} /* 5764 */,
    {.source = (const lxb_char_t *) "xn----pck312bx563c.xn--9h2d", .ascii = (const lxb_char_t *) "xn----pck312bx563c.xn--9h2d", .status = 16} /* 5765 */,
    {.source = (const lxb_char_t *) "≠𐸁𹏁\u200C.Ⴚ򳄠", .ascii = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ynd49496l", .status = 12} /* 5766 */,
    {.source = (const lxb_char_t *) "=\u0338𐸁𹏁\u200C.Ⴚ򳄠", .ascii = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ynd49496l", .status = 12} /* 5767 */,
    {.source = (const lxb_char_t *) "=\u0338𐸁𹏁\u200C.ⴚ򳄠", .ascii = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ilj23531g", .status = 12} /* 5768 */,
    {.source = (const lxb_char_t *) "≠𐸁𹏁\u200C.ⴚ򳄠", .ascii = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ilj23531g", .status = 12} /* 5769 */,
    {.source = (const lxb_char_t *) "xn--1ch2293gv3nr.xn--ilj23531g", .ascii = (const lxb_char_t *) "xn--1ch2293gv3nr.xn--ilj23531g", .status = 8} /* 5770 */,
    {.source = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ilj23531g", .ascii = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ilj23531g", .status = 12} /* 5771 */,
    {.source = (const lxb_char_t *) "xn--1ch2293gv3nr.xn--ynd49496l", .ascii = (const lxb_char_t *) "xn--1ch2293gv3nr.xn--ynd49496l", .status = 8} /* 5772 */,
    {.source = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ynd49496l", .ascii = (const lxb_char_t *) "xn--0ug83gn618a21ov.xn--ynd49496l", .status = 12} /* 5773 */,
    {.source = (const lxb_char_t *) "\u0669｡󠇀𑇊", .ascii = (const lxb_char_t *) "xn--iib.xn--6d1d", .status = 8} /* 5774 */,
    {.source = (const lxb_char_t *) "\u0669。󠇀𑇊", .ascii = (const lxb_char_t *) "xn--iib.xn--6d1d", .status = 8} /* 5775 */,
    {.source = (const lxb_char_t *) "xn--iib.xn--6d1d", .ascii = (const lxb_char_t *) "xn--iib.xn--6d1d", .status = 8} /* 5776 */,
    {.source = (const lxb_char_t *) "\u1086𞶀≯⒍。-", .ascii = (const lxb_char_t *) "xn--hmd482gqqb8730g.-", .status = 16} /* 5777 */,
    {.source = (const lxb_char_t *) "\u1086𞶀>\u0338⒍。-", .ascii = (const lxb_char_t *) "xn--hmd482gqqb8730g.-", .status = 16} /* 5778 */,
    {.source = (const lxb_char_t *) "\u1086𞶀≯6.。-", .ascii = (const lxb_char_t *) "xn--6-oyg968k7h74b..-", .status = 22} /* 5779 */,
    {.source = (const lxb_char_t *) "\u1086𞶀>\u03386.。-", .ascii = (const lxb_char_t *) "xn--6-oyg968k7h74b..-", .status = 22} /* 5780 */,
    {.source = (const lxb_char_t *) "xn--6-oyg968k7h74b..-", .ascii = (const lxb_char_t *) "xn--6-oyg968k7h74b..-", .status = 22} /* 5781 */,
    {.source = (const lxb_char_t *) "xn--hmd482gqqb8730g.-", .ascii = (const lxb_char_t *) "xn--hmd482gqqb8730g.-", .status = 16} /* 5782 */,
    {.source = (const lxb_char_t *) "\u17B4.쮇-", .ascii = (const lxb_char_t *) "xn--z3e.xn----938f", .status = 12} /* 5783 */,
    {.source = (const lxb_char_t *) "\u17B4.쮇-", .ascii = (const lxb_char_t *) "xn--z3e.xn----938f", .status = 12} /* 5784 */,
    {.source = (const lxb_char_t *) "xn--z3e.xn----938f", .ascii = (const lxb_char_t *) "xn--z3e.xn----938f", .status = 12} /* 5785 */,
    {.source = (const lxb_char_t *) "\u200C𑓂。⒈-􀪛", .ascii = (const lxb_char_t *) "xn--0ugy057g.xn----dcp29674o", .status = 8} /* 5786 */,
    {.source = (const lxb_char_t *) "\u200C𑓂。1.-􀪛", .ascii = (const lxb_char_t *) "xn--0ugy057g.1.xn----rg03o", .status = 12} /* 5787 */,
    {.source = (const lxb_char_t *) "xn--wz1d.1.xn----rg03o", .ascii = (const lxb_char_t *) "xn--wz1d.1.xn----rg03o", .status = 12} /* 5788 */,
    {.source = (const lxb_char_t *) "xn--0ugy057g.1.xn----rg03o", .ascii = (const lxb_char_t *) "xn--0ugy057g.1.xn----rg03o", .status = 12} /* 5789 */,
    {.source = (const lxb_char_t *) "xn--wz1d.xn----dcp29674o", .ascii = (const lxb_char_t *) "xn--wz1d.xn----dcp29674o", .status = 8} /* 5790 */,
    {.source = (const lxb_char_t *) "xn--0ugy057g.xn----dcp29674o", .ascii = (const lxb_char_t *) "xn--0ugy057g.xn----dcp29674o", .status = 8} /* 5791 */,
    {.source = (const lxb_char_t *) "⒈\uFEAE\u200C。\u20E9🖞\u200C𖬴", .ascii = (const lxb_char_t *) "xn--wgb253kmfd.xn--0ugz6a8040fty5d", .status = 16} /* 5792 */,
    {.source = (const lxb_char_t *) "1.\u0631\u200C。\u20E9🖞\u200C𖬴", .ascii = (const lxb_char_t *) "1.xn--wgb253k.xn--0ugz6a8040fty5d", .status = 16} /* 5793 */,
    {.source = (const lxb_char_t *) "1.xn--wgb.xn--c1g6021kg18c", .ascii = (const lxb_char_t *) "1.xn--wgb.xn--c1g6021kg18c", .status = 8} /* 5794 */,
    {.source = (const lxb_char_t *) "1.xn--wgb253k.xn--0ugz6a8040fty5d", .ascii = (const lxb_char_t *) "1.xn--wgb253k.xn--0ugz6a8040fty5d", .status = 16} /* 5795 */,
    {.source = (const lxb_char_t *) "xn--wgb746m.xn--c1g6021kg18c", .ascii = (const lxb_char_t *) "xn--wgb746m.xn--c1g6021kg18c", .status = 12} /* 5796 */,
    {.source = (const lxb_char_t *) "xn--wgb253kmfd.xn--0ugz6a8040fty5d", .ascii = (const lxb_char_t *) "xn--wgb253kmfd.xn--0ugz6a8040fty5d", .status = 16} /* 5797 */,
    {.source = (const lxb_char_t *) "󌭇｡𝟐\u1BA8\u07D4", .ascii = (const lxb_char_t *) "xn--xm89d.xn--2-icd143m", .status = 8} /* 5798 */,
    {.source = (const lxb_char_t *) "󌭇。2\u1BA8\u07D4", .ascii = (const lxb_char_t *) "xn--xm89d.xn--2-icd143m", .status = 8} /* 5799 */,
    {.source = (const lxb_char_t *) "xn--xm89d.xn--2-icd143m", .ascii = (const lxb_char_t *) "xn--xm89d.xn--2-icd143m", .status = 8} /* 5800 */,
    {.source = (const lxb_char_t *) "\uFD8F򫳺.ς\u200D𐹷", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--3xa006lrp7n", .status = 24} /* 5801 */,
    {.source = (const lxb_char_t *) "\u0645\u062E\u0645򫳺.ς\u200D𐹷", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--3xa006lrp7n", .status = 24} /* 5802 */,
    {.source = (const lxb_char_t *) "\u0645\u062E\u0645򫳺.Σ\u200D𐹷", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa895lrp7n", .status = 24} /* 5803 */,
    {.source = (const lxb_char_t *) "\u0645\u062E\u0645򫳺.σ\u200D𐹷", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa895lrp7n", .status = 24} /* 5804 */,
    {.source = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa6667k", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa6667k", .status = 20} /* 5805 */,
    {.source = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa895lrp7n", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa895lrp7n", .status = 24} /* 5806 */,
    {.source = (const lxb_char_t *) "xn--tgb9bb64691z.xn--3xa006lrp7n", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--3xa006lrp7n", .status = 24} /* 5807 */,
    {.source = (const lxb_char_t *) "\uFD8F򫳺.Σ\u200D𐹷", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa895lrp7n", .status = 24} /* 5808 */,
    {.source = (const lxb_char_t *) "\uFD8F򫳺.σ\u200D𐹷", .ascii = (const lxb_char_t *) "xn--tgb9bb64691z.xn--4xa895lrp7n", .status = 24} /* 5809 */,
    {.source = (const lxb_char_t *) "⒎\u06C1\u0605｡\uAAF6۵𐇽", .ascii = (const lxb_char_t *) "xn--nfb98ai25e.xn--imb3805fxt8b", .status = 12} /* 5810 */,
    {.source = (const lxb_char_t *) "7.\u06C1\u0605。\uAAF6۵𐇽", .ascii = (const lxb_char_t *) "7.xn--nfb98a.xn--imb3805fxt8b", .status = 12} /* 5811 */,
    {.source = (const lxb_char_t *) "7.xn--nfb98a.xn--imb3805fxt8b", .ascii = (const lxb_char_t *) "7.xn--nfb98a.xn--imb3805fxt8b", .status = 12} /* 5812 */,
    {.source = (const lxb_char_t *) "xn--nfb98ai25e.xn--imb3805fxt8b", .ascii = (const lxb_char_t *) "xn--nfb98ai25e.xn--imb3805fxt8b", .status = 12} /* 5813 */,
    {.source = (const lxb_char_t *) "-ᡥ᠆󍲭。\u0605\u1A5D𐹡", .ascii = (const lxb_char_t *) "xn----f3j6s87156i.xn--nfb035hoo2p", .status = 12} /* 5814 */,
    {.source = (const lxb_char_t *) "xn----f3j6s87156i.xn--nfb035hoo2p", .ascii = (const lxb_char_t *) "xn----f3j6s87156i.xn--nfb035hoo2p", .status = 12} /* 5815 */,
    {.source = (const lxb_char_t *) "\u200D.\u06BD\u0663\u0596", .ascii = (const lxb_char_t *) "xn--1ug.xn--hcb32bni", .status = 8} /* 5816 */,
    {.source = (const lxb_char_t *) ".xn--hcb32bni", .ascii = (const lxb_char_t *) ".xn--hcb32bni", .status = 6} /* 5817 */,
    {.source = (const lxb_char_t *) "xn--1ug.xn--hcb32bni", .ascii = (const lxb_char_t *) "xn--1ug.xn--hcb32bni", .status = 8} /* 5818 */,
    {.source = (const lxb_char_t *) "xn--hcb32bni", .ascii = (const lxb_char_t *) "xn--hcb32bni", .status = 0} /* 5819 */,
    {.source = (const lxb_char_t *) "\u06BD\u0663\u0596", .ascii = (const lxb_char_t *) "xn--hcb32bni", .status = 0} /* 5820 */,
    {.source = (const lxb_char_t *) "㒧۱.Ⴚ\u0678\u200D", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f817ao2p", .status = 16} /* 5821 */,
    {.source = (const lxb_char_t *) "㒧۱.Ⴚ\u064A\u0674\u200D", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f817ao2p", .status = 16} /* 5822 */,
    {.source = (const lxb_char_t *) "㒧۱.ⴚ\u064A\u0674\u200D", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f960g03l", .status = 12} /* 5823 */,
    {.source = (const lxb_char_t *) "xn--emb715u.xn--mhb8fy26k", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8fy26k", .status = 8} /* 5824 */,
    {.source = (const lxb_char_t *) "xn--emb715u.xn--mhb8f960g03l", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f960g03l", .status = 12} /* 5825 */,
    {.source = (const lxb_char_t *) "xn--emb715u.xn--mhb8f817a", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f817a", .status = 12} /* 5826 */,
    {.source = (const lxb_char_t *) "xn--emb715u.xn--mhb8f817ao2p", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f817ao2p", .status = 16} /* 5827 */,
    {.source = (const lxb_char_t *) "㒧۱.ⴚ\u0678\u200D", .ascii = (const lxb_char_t *) "xn--emb715u.xn--mhb8f960g03l", .status = 12} /* 5828 */,
    {.source = (const lxb_char_t *) "\u0F94ꡋ-．-𖬴", .ascii = (const lxb_char_t *) "xn----ukg9938i.xn----4u5m", .status = 8} /* 5829 */,
    {.source = (const lxb_char_t *) "\u0F94ꡋ-.-𖬴", .ascii = (const lxb_char_t *) "xn----ukg9938i.xn----4u5m", .status = 8} /* 5830 */,
    {.source = (const lxb_char_t *) "xn----ukg9938i.xn----4u5m", .ascii = (const lxb_char_t *) "xn----ukg9938i.xn----4u5m", .status = 8} /* 5831 */,
    {.source = (const lxb_char_t *) "񿒳-⋢\u200C．标-", .ascii = (const lxb_char_t *) "xn----sgn90kn5663a.xn----qj7b", .status = 12} /* 5832 */,
    {.source = (const lxb_char_t *) "񿒳-⊑\u0338\u200C．标-", .ascii = (const lxb_char_t *) "xn----sgn90kn5663a.xn----qj7b", .status = 12} /* 5833 */,
    {.source = (const lxb_char_t *) "񿒳-⋢\u200C.标-", .ascii = (const lxb_char_t *) "xn----sgn90kn5663a.xn----qj7b", .status = 12} /* 5834 */,
    {.source = (const lxb_char_t *) "񿒳-⊑\u0338\u200C.标-", .ascii = (const lxb_char_t *) "xn----sgn90kn5663a.xn----qj7b", .status = 12} /* 5835 */,
    {.source = (const lxb_char_t *) "xn----9mo67451g.xn----qj7b", .ascii = (const lxb_char_t *) "xn----9mo67451g.xn----qj7b", .status = 8} /* 5836 */,
    {.source = (const lxb_char_t *) "xn----sgn90kn5663a.xn----qj7b", .ascii = (const lxb_char_t *) "xn----sgn90kn5663a.xn----qj7b", .status = 12} /* 5837 */,
    {.source = (const lxb_char_t *) "\u0671．ς\u07DC", .ascii = (const lxb_char_t *) "xn--qib.xn--3xa41s", .status = 8} /* 5838 */,
    {.source = (const lxb_char_t *) "\u0671.ς\u07DC", .ascii = (const lxb_char_t *) "xn--qib.xn--3xa41s", .status = 8} /* 5839 */,
    {.source = (const lxb_char_t *) "\u0671.Σ\u07DC", .ascii = (const lxb_char_t *) "xn--qib.xn--4xa21s", .status = 8} /* 5840 */,
    {.source = (const lxb_char_t *) "\u0671.σ\u07DC", .ascii = (const lxb_char_t *) "xn--qib.xn--4xa21s", .status = 8} /* 5841 */,
    {.source = (const lxb_char_t *) "xn--qib.xn--4xa21s", .ascii = (const lxb_char_t *) "xn--qib.xn--4xa21s", .status = 8} /* 5842 */,
    {.source = (const lxb_char_t *) "xn--qib.xn--3xa41s", .ascii = (const lxb_char_t *) "xn--qib.xn--3xa41s", .status = 8} /* 5843 */,
    {.source = (const lxb_char_t *) "\u0671．Σ\u07DC", .ascii = (const lxb_char_t *) "xn--qib.xn--4xa21s", .status = 8} /* 5844 */,
    {.source = (const lxb_char_t *) "\u0671．σ\u07DC", .ascii = (const lxb_char_t *) "xn--qib.xn--4xa21s", .status = 8} /* 5845 */,
    {.source = (const lxb_char_t *) "񼈶\u0605．\u08C1\u200D𑑂𱼱", .ascii = (const lxb_char_t *) "xn--nfb17942h.xn--nzb240jv06otevq", .status = 24} /* 5846 */,
    {.source = (const lxb_char_t *) "񼈶\u0605.\u08C1\u200D𑑂𱼱", .ascii = (const lxb_char_t *) "xn--nfb17942h.xn--nzb240jv06otevq", .status = 24} /* 5847 */,
    {.source = (const lxb_char_t *) "xn--nfb17942h.xn--nzb6708kx3pn", .ascii = (const lxb_char_t *) "xn--nfb17942h.xn--nzb6708kx3pn", .status = 20} /* 5848 */,
    {.source = (const lxb_char_t *) "xn--nfb17942h.xn--nzb240jv06otevq", .ascii = (const lxb_char_t *) "xn--nfb17942h.xn--nzb240jv06otevq", .status = 24} /* 5849 */,
    {.source = (const lxb_char_t *) "𐹾𐋩𞵜｡\u1BF2", .ascii = (const lxb_char_t *) "xn--d97cn8rn44p.xn--0zf", .status = 12} /* 5850 */,
    {.source = (const lxb_char_t *) "𐹾𐋩𞵜。\u1BF2", .ascii = (const lxb_char_t *) "xn--d97cn8rn44p.xn--0zf", .status = 12} /* 5851 */,
    {.source = (const lxb_char_t *) "xn--d97cn8rn44p.xn--0zf", .ascii = (const lxb_char_t *) "xn--d97cn8rn44p.xn--0zf", .status = 12} /* 5852 */,
    {.source = (const lxb_char_t *) "6\u1160\u1C33󠸧.򟜊锰\u072Cς", .ascii = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--3xa16ohw6pk078g", .status = 12} /* 5853 */,
    {.source = (const lxb_char_t *) "6\u1160\u1C33󠸧.򟜊锰\u072CΣ", .ascii = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--4xa95ohw6pk078g", .status = 12} /* 5854 */,
    {.source = (const lxb_char_t *) "6\u1160\u1C33󠸧.򟜊锰\u072Cσ", .ascii = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--4xa95ohw6pk078g", .status = 12} /* 5855 */,
    {.source = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--4xa95ohw6pk078g", .ascii = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--4xa95ohw6pk078g", .status = 12} /* 5856 */,
    {.source = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--3xa16ohw6pk078g", .ascii = (const lxb_char_t *) "xn--6-5bh476ewr517a.xn--3xa16ohw6pk078g", .status = 12} /* 5857 */,
    {.source = (const lxb_char_t *) "\u06B3\uFE04񅎦𝟽｡𐹽", .ascii = (const lxb_char_t *) "xn--7-yuc34665f.xn--1o0d", .status = 12} /* 5858 */,
    {.source = (const lxb_char_t *) "\u06B3\uFE04񅎦7。𐹽", .ascii = (const lxb_char_t *) "xn--7-yuc34665f.xn--1o0d", .status = 12} /* 5859 */,
    {.source = (const lxb_char_t *) "xn--7-yuc34665f.xn--1o0d", .ascii = (const lxb_char_t *) "xn--7-yuc34665f.xn--1o0d", .status = 12} /* 5860 */,
    {.source = (const lxb_char_t *) "𞮧．\u200C⫞", .ascii = (const lxb_char_t *) "xn--pw6h.xn--0ug283b", .status = 12} /* 5861 */,
    {.source = (const lxb_char_t *) "𞮧.\u200C⫞", .ascii = (const lxb_char_t *) "xn--pw6h.xn--0ug283b", .status = 12} /* 5862 */,
    {.source = (const lxb_char_t *) "xn--pw6h.xn--53i", .ascii = (const lxb_char_t *) "xn--pw6h.xn--53i", .status = 8} /* 5863 */,
    {.source = (const lxb_char_t *) "xn--pw6h.xn--0ug283b", .ascii = (const lxb_char_t *) "xn--pw6h.xn--0ug283b", .status = 12} /* 5864 */,
    {.source = (const lxb_char_t *) "-񕉴.\u06E0ᢚ-", .ascii = (const lxb_char_t *) "xn----qi38c.xn----jxc827k", .status = 12} /* 5865 */,
    {.source = (const lxb_char_t *) "xn----qi38c.xn----jxc827k", .ascii = (const lxb_char_t *) "xn----qi38c.xn----jxc827k", .status = 12} /* 5866 */,
    {.source = (const lxb_char_t *) "⌁\u200D𑄴．\u200C𝟩\u066C", .ascii = (const lxb_char_t *) "xn--1ug38i2093a.xn--7-xqc297q", .status = 12} /* 5867 */,
    {.source = (const lxb_char_t *) "⌁\u200D𑄴.\u200C7\u066C", .ascii = (const lxb_char_t *) "xn--1ug38i2093a.xn--7-xqc297q", .status = 12} /* 5868 */,
    {.source = (const lxb_char_t *) "xn--nhh5394g.xn--7-xqc", .ascii = (const lxb_char_t *) "xn--nhh5394g.xn--7-xqc", .status = 4} /* 5869 */,
    {.source = (const lxb_char_t *) "xn--1ug38i2093a.xn--7-xqc297q", .ascii = (const lxb_char_t *) "xn--1ug38i2093a.xn--7-xqc297q", .status = 12} /* 5870 */,
    {.source = (const lxb_char_t *) "︒\uFD05\u0E37\uFEFC。岓\u1BF2󠾃ᡂ", .ascii = (const lxb_char_t *) "xn--mgb1a7bt462hf267a.xn--17e10qe61f9r71s", .status = 8} /* 5871 */,
    {.source = (const lxb_char_t *) "。\u0635\u0649\u0E37\u0644\u0627。岓\u1BF2󠾃ᡂ", .ascii = (const lxb_char_t *) ".xn--mgb1a7bt462h.xn--17e10qe61f9r71s", .status = 10} /* 5872 */,
    {.source = (const lxb_char_t *) ".xn--mgb1a7bt462h.xn--17e10qe61f9r71s", .ascii = (const lxb_char_t *) ".xn--mgb1a7bt462h.xn--17e10qe61f9r71s", .status = 10} /* 5873 */,
    {.source = (const lxb_char_t *) "xn--mgb1a7bt462hf267a.xn--17e10qe61f9r71s", .ascii = (const lxb_char_t *) "xn--mgb1a7bt462hf267a.xn--17e10qe61f9r71s", .status = 8} /* 5874 */,
    {.source = (const lxb_char_t *) "𐹨。8𑁆", .ascii = (const lxb_char_t *) "xn--go0d.xn--8-yu7i", .status = 4} /* 5875 */,
    {.source = (const lxb_char_t *) "xn--go0d.xn--8-yu7i", .ascii = (const lxb_char_t *) "xn--go0d.xn--8-yu7i", .status = 4} /* 5876 */,
    {.source = (const lxb_char_t *) "𞀕\u0D43．ꡚ\u08FA𐹰\u0D44", .ascii = (const lxb_char_t *) "xn--mxc5210v.xn--90b01t8u2p1ltd", .status = 16} /* 5877 */,
    {.source = (const lxb_char_t *) "𞀕\u0D43.ꡚ\u08FA𐹰\u0D44", .ascii = (const lxb_char_t *) "xn--mxc5210v.xn--90b01t8u2p1ltd", .status = 16} /* 5878 */,
    {.source = (const lxb_char_t *) "xn--mxc5210v.xn--90b01t8u2p1ltd", .ascii = (const lxb_char_t *) "xn--mxc5210v.xn--90b01t8u2p1ltd", .status = 16} /* 5879 */,
    {.source = (const lxb_char_t *) "󆩏𐦹\u0303｡󠍅", .ascii = (const lxb_char_t *) "xn--nsa1265kp9z9e.xn--xt36e", .status = 16} /* 5880 */,
    {.source = (const lxb_char_t *) "󆩏𐦹\u0303。󠍅", .ascii = (const lxb_char_t *) "xn--nsa1265kp9z9e.xn--xt36e", .status = 16} /* 5881 */,
    {.source = (const lxb_char_t *) "xn--nsa1265kp9z9e.xn--xt36e", .ascii = (const lxb_char_t *) "xn--nsa1265kp9z9e.xn--xt36e", .status = 16} /* 5882 */,
    {.source = (const lxb_char_t *) "ᢌ．-\u085A", .ascii = (const lxb_char_t *) "xn--59e.xn----5jd", .status = 4} /* 5883 */,
    {.source = (const lxb_char_t *) "ᢌ.-\u085A", .ascii = (const lxb_char_t *) "xn--59e.xn----5jd", .status = 4} /* 5884 */,
    {.source = (const lxb_char_t *) "xn--59e.xn----5jd", .ascii = (const lxb_char_t *) "xn--59e.xn----5jd", .status = 4} /* 5885 */,
    {.source = (const lxb_char_t *) "𥛛𑘶｡𐹬𐲸\u0BCD", .ascii = (const lxb_char_t *) "xn--jb2dj685c.xn--xmc5562kmcb", .status = 8} /* 5886 */,
    {.source = (const lxb_char_t *) "𥛛𑘶。𐹬𐲸\u0BCD", .ascii = (const lxb_char_t *) "xn--jb2dj685c.xn--xmc5562kmcb", .status = 8} /* 5887 */,
    {.source = (const lxb_char_t *) "xn--jb2dj685c.xn--xmc5562kmcb", .ascii = (const lxb_char_t *) "xn--jb2dj685c.xn--xmc5562kmcb", .status = 8} /* 5888 */,
    {.source = (const lxb_char_t *) "Ⴐ\u077F．\u200C", .ascii = (const lxb_char_t *) "xn--gqb918b.xn--0ug", .status = 20} /* 5889 */,
    {.source = (const lxb_char_t *) "Ⴐ\u077F.\u200C", .ascii = (const lxb_char_t *) "xn--gqb918b.xn--0ug", .status = 20} /* 5890 */,
    {.source = (const lxb_char_t *) "ⴐ\u077F.\u200C", .ascii = (const lxb_char_t *) "xn--gqb743q.xn--0ug", .status = 16} /* 5891 */,
    {.source = (const lxb_char_t *) "xn--gqb743q.", .ascii = (const lxb_char_t *) "xn--gqb743q.", .status = 8} /* 5892 */,
    {.source = (const lxb_char_t *) "xn--gqb743q.xn--0ug", .ascii = (const lxb_char_t *) "xn--gqb743q.xn--0ug", .status = 16} /* 5893 */,
    {.source = (const lxb_char_t *) "xn--gqb918b.", .ascii = (const lxb_char_t *) "xn--gqb918b.", .status = 12} /* 5894 */,
    {.source = (const lxb_char_t *) "xn--gqb918b.xn--0ug", .ascii = (const lxb_char_t *) "xn--gqb918b.xn--0ug", .status = 20} /* 5895 */,
    {.source = (const lxb_char_t *) "ⴐ\u077F．\u200C", .ascii = (const lxb_char_t *) "xn--gqb743q.xn--0ug", .status = 16} /* 5896 */,
    {.source = (const lxb_char_t *) "🄅𑲞-⒈。\u200Dᠩ\u06A5", .ascii = (const lxb_char_t *) "xn----ecp8796hjtvg.xn--7jb180gexf", .status = 12} /* 5897 */,
    {.source = (const lxb_char_t *) "4,𑲞-1.。\u200Dᠩ\u06A5", .ascii = (const lxb_char_t *) "xn--4,-1-w401a..xn--7jb180gexf", .status = 18} /* 5898 */,
    {.source = (const lxb_char_t *) "xn--4,-1-w401a..xn--7jb180g", .ascii = (const lxb_char_t *) "xn--4,-1-w401a..xn--7jb180g", .status = 22} /* 5899 */,
    {.source = (const lxb_char_t *) "xn--4,-1-w401a..xn--7jb180gexf", .ascii = (const lxb_char_t *) "xn--4,-1-w401a..xn--7jb180gexf", .status = 18} /* 5900 */,
    {.source = (const lxb_char_t *) "xn----ecp8796hjtvg.xn--7jb180g", .ascii = (const lxb_char_t *) "xn----ecp8796hjtvg.xn--7jb180g", .status = 16} /* 5901 */,
    {.source = (const lxb_char_t *) "xn----ecp8796hjtvg.xn--7jb180gexf", .ascii = (const lxb_char_t *) "xn----ecp8796hjtvg.xn--7jb180gexf", .status = 12} /* 5902 */,
    {.source = (const lxb_char_t *) "񗀤。𞤪򮿋", .ascii = (const lxb_char_t *) "xn--4240a.xn--ie6h83808a", .status = 12} /* 5903 */,
    {.source = (const lxb_char_t *) "񗀤。𞤈򮿋", .ascii = (const lxb_char_t *) "xn--4240a.xn--ie6h83808a", .status = 12} /* 5904 */,
    {.source = (const lxb_char_t *) "xn--4240a.xn--ie6h83808a", .ascii = (const lxb_char_t *) "xn--4240a.xn--ie6h83808a", .status = 12} /* 5905 */,
    {.source = (const lxb_char_t *) "\u05C1۲｡𐮊\u066C𝨊鄨", .ascii = (const lxb_char_t *) "xn--pdb42d.xn--lib6412enztdwv6h", .status = 16} /* 5906 */,
    {.source = (const lxb_char_t *) "\u05C1۲。𐮊\u066C𝨊鄨", .ascii = (const lxb_char_t *) "xn--pdb42d.xn--lib6412enztdwv6h", .status = 16} /* 5907 */,
    {.source = (const lxb_char_t *) "xn--pdb42d.xn--lib6412enztdwv6h", .ascii = (const lxb_char_t *) "xn--pdb42d.xn--lib6412enztdwv6h", .status = 16} /* 5908 */,
    {.source = (const lxb_char_t *) "𞭳-ꡁ。\u1A69\u0BCD-", .ascii = (const lxb_char_t *) "xn----be4e4276f.xn----lze333i", .status = 24} /* 5909 */,
    {.source = (const lxb_char_t *) "xn----be4e4276f.xn----lze333i", .ascii = (const lxb_char_t *) "xn----be4e4276f.xn----lze333i", .status = 24} /* 5910 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢．ß", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.xn--zca", .status = 8} /* 5911 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢.ß", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.xn--zca", .status = 8} /* 5912 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢.SS", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5913 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢.ss", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5914 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢.Ss", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5915 */,
    {.source = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5916 */,
    {.source = (const lxb_char_t *) "xn----9tg11172akr8b.xn--zca", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.xn--zca", .status = 8} /* 5917 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢．SS", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5918 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢．ss", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5919 */,
    {.source = (const lxb_char_t *) "\u1039-𚮭🞢．Ss", .ascii = (const lxb_char_t *) "xn----9tg11172akr8b.ss", .status = 8} /* 5920 */,
    {.source = (const lxb_char_t *) "\uFCF2-\u200C｡Ⴟ\u200C␣", .ascii = (const lxb_char_t *) "xn----eoc6bm0504a.xn--3nd849e05c", .status = 16} /* 5921 */,
    {.source = (const lxb_char_t *) "\u0640\u064E\u0651-\u200C。Ⴟ\u200C␣", .ascii = (const lxb_char_t *) "xn----eoc6bm0504a.xn--3nd849e05c", .status = 16} /* 5922 */,
    {.source = (const lxb_char_t *) "\u0640\u064E\u0651-\u200C。ⴟ\u200C␣", .ascii = (const lxb_char_t *) "xn----eoc6bm0504a.xn--0ug13nd0j", .status = 12} /* 5923 */,
    {.source = (const lxb_char_t *) "xn----eoc6bm.xn--xph904a", .ascii = (const lxb_char_t *) "xn----eoc6bm.xn--xph904a", .status = 12} /* 5924 */,
    {.source = (const lxb_char_t *) "xn----eoc6bm0504a.xn--0ug13nd0j", .ascii = (const lxb_char_t *) "xn----eoc6bm0504a.xn--0ug13nd0j", .status = 12} /* 5925 */,
    {.source = (const lxb_char_t *) "xn----eoc6bm.xn--3nd240h", .ascii = (const lxb_char_t *) "xn----eoc6bm.xn--3nd240h", .status = 16} /* 5926 */,
    {.source = (const lxb_char_t *) "xn----eoc6bm0504a.xn--3nd849e05c", .ascii = (const lxb_char_t *) "xn----eoc6bm0504a.xn--3nd849e05c", .status = 16} /* 5927 */,
    {.source = (const lxb_char_t *) "\uFCF2-\u200C｡ⴟ\u200C␣", .ascii = (const lxb_char_t *) "xn----eoc6bm0504a.xn--0ug13nd0j", .status = 12} /* 5928 */,
    {.source = (const lxb_char_t *) "\u0D4D-\u200D\u200C｡񥞧₅≠", .ascii = (const lxb_char_t *) "xn----jmf215lda.xn--5-ufo50192e", .status = 16} /* 5929 */,
    {.source = (const lxb_char_t *) "\u0D4D-\u200D\u200C｡񥞧₅=\u0338", .ascii = (const lxb_char_t *) "xn----jmf215lda.xn--5-ufo50192e", .status = 16} /* 5930 */,
    {.source = (const lxb_char_t *) "\u0D4D-\u200D\u200C。񥞧5≠", .ascii = (const lxb_char_t *) "xn----jmf215lda.xn--5-ufo50192e", .status = 16} /* 5931 */,
    {.source = (const lxb_char_t *) "\u0D4D-\u200D\u200C。񥞧5=\u0338", .ascii = (const lxb_char_t *) "xn----jmf215lda.xn--5-ufo50192e", .status = 16} /* 5932 */,
    {.source = (const lxb_char_t *) "xn----jmf.xn--5-ufo50192e", .ascii = (const lxb_char_t *) "xn----jmf.xn--5-ufo50192e", .status = 12} /* 5933 */,
    {.source = (const lxb_char_t *) "xn----jmf215lda.xn--5-ufo50192e", .ascii = (const lxb_char_t *) "xn----jmf215lda.xn--5-ufo50192e", .status = 16} /* 5934 */,
    {.source = (const lxb_char_t *) "锣。\u0A4D󠘻󠚆", .ascii = (const lxb_char_t *) "xn--gc5a.xn--ybc83044ppga", .status = 8} /* 5935 */,
    {.source = (const lxb_char_t *) "xn--gc5a.xn--ybc83044ppga", .ascii = (const lxb_char_t *) "xn--gc5a.xn--ybc83044ppga", .status = 8} /* 5936 */,
    {.source = (const lxb_char_t *) "\u063D𑈾．\u0649\u200D\uA92B", .ascii = (const lxb_char_t *) "xn--8gb2338k.xn--lhb603k060h", .status = 8} /* 5937 */,
    {.source = (const lxb_char_t *) "\u063D𑈾.\u0649\u200D\uA92B", .ascii = (const lxb_char_t *) "xn--8gb2338k.xn--lhb603k060h", .status = 8} /* 5938 */,
    {.source = (const lxb_char_t *) "xn--8gb2338k.xn--lhb0154f", .ascii = (const lxb_char_t *) "xn--8gb2338k.xn--lhb0154f", .status = 0} /* 5939 */,
    {.source = (const lxb_char_t *) "\u063D𑈾.\u0649\uA92B", .ascii = (const lxb_char_t *) "xn--8gb2338k.xn--lhb0154f", .status = 0} /* 5940 */,
    {.source = (const lxb_char_t *) "xn--8gb2338k.xn--lhb603k060h", .ascii = (const lxb_char_t *) "xn--8gb2338k.xn--lhb603k060h", .status = 8} /* 5941 */,
    {.source = (const lxb_char_t *) "\u0666⁴Ⴅ．\u08BD\u200C", .ascii = (const lxb_char_t *) "xn--4-kqc489e.xn--jzb840j", .status = 16} /* 5942 */,
    {.source = (const lxb_char_t *) "\u06664Ⴅ.\u08BD\u200C", .ascii = (const lxb_char_t *) "xn--4-kqc489e.xn--jzb840j", .status = 16} /* 5943 */,
    {.source = (const lxb_char_t *) "\u06664ⴅ.\u08BD\u200C", .ascii = (const lxb_char_t *) "xn--4-kqc6770a.xn--jzb840j", .status = 12} /* 5944 */,
    {.source = (const lxb_char_t *) "xn--4-kqc6770a.xn--jzb", .ascii = (const lxb_char_t *) "xn--4-kqc6770a.xn--jzb", .status = 4} /* 5945 */,
    {.source = (const lxb_char_t *) "xn--4-kqc6770a.xn--jzb840j", .ascii = (const lxb_char_t *) "xn--4-kqc6770a.xn--jzb840j", .status = 12} /* 5946 */,
    {.source = (const lxb_char_t *) "xn--4-kqc489e.xn--jzb", .ascii = (const lxb_char_t *) "xn--4-kqc489e.xn--jzb", .status = 8} /* 5947 */,
    {.source = (const lxb_char_t *) "xn--4-kqc489e.xn--jzb840j", .ascii = (const lxb_char_t *) "xn--4-kqc489e.xn--jzb840j", .status = 16} /* 5948 */,
    {.source = (const lxb_char_t *) "\u0666⁴ⴅ．\u08BD\u200C", .ascii = (const lxb_char_t *) "xn--4-kqc6770a.xn--jzb840j", .status = 12} /* 5949 */,
    {.source = (const lxb_char_t *) "ჁႱ6\u0318。ß\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb555h2b.xn--zca894k", .status = 4} /* 5950 */,
    {.source = (const lxb_char_t *) "ⴡⴑ6\u0318。ß\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--zca894k", .status = 0} /* 5951 */,
    {.source = (const lxb_char_t *) "ჁႱ6\u0318。SS\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb555h2b.xn--ss-2vq", .status = 4} /* 5952 */,
    {.source = (const lxb_char_t *) "ⴡⴑ6\u0318。ss\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--ss-2vq", .status = 0} /* 5953 */,
    {.source = (const lxb_char_t *) "Ⴡⴑ6\u0318。Ss\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb306hms1a.xn--ss-2vq", .status = 4} /* 5954 */,
    {.source = (const lxb_char_t *) "xn--6-8cb306hms1a.xn--ss-2vq", .ascii = (const lxb_char_t *) "xn--6-8cb306hms1a.xn--ss-2vq", .status = 4} /* 5955 */,
    {.source = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--ss-2vq", .ascii = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--ss-2vq", .status = 0} /* 5956 */,
    {.source = (const lxb_char_t *) "ⴡⴑ6\u0318.ss\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--ss-2vq", .status = 0} /* 5957 */,
    {.source = (const lxb_char_t *) "ჁႱ6\u0318.SS\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb555h2b.xn--ss-2vq", .status = 4} /* 5958 */,
    {.source = (const lxb_char_t *) "Ⴡⴑ6\u0318.Ss\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb306hms1a.xn--ss-2vq", .status = 4} /* 5959 */,
    {.source = (const lxb_char_t *) "xn--6-8cb555h2b.xn--ss-2vq", .ascii = (const lxb_char_t *) "xn--6-8cb555h2b.xn--ss-2vq", .status = 4} /* 5960 */,
    {.source = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--zca894k", .ascii = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--zca894k", .status = 0} /* 5961 */,
    {.source = (const lxb_char_t *) "ⴡⴑ6\u0318.ß\u1B03", .ascii = (const lxb_char_t *) "xn--6-8cb7433a2ba.xn--zca894k", .status = 0} /* 5962 */,
    {.source = (const lxb_char_t *) "xn--6-8cb555h2b.xn--zca894k", .ascii = (const lxb_char_t *) "xn--6-8cb555h2b.xn--zca894k", .status = 4} /* 5963 */,
    {.source = (const lxb_char_t *) "򋡐｡≯𑋪", .ascii = (const lxb_char_t *) "xn--eo08b.xn--hdh3385g", .status = 4} /* 5964 */,
    {.source = (const lxb_char_t *) "򋡐｡>\u0338𑋪", .ascii = (const lxb_char_t *) "xn--eo08b.xn--hdh3385g", .status = 4} /* 5965 */,
    {.source = (const lxb_char_t *) "򋡐。≯𑋪", .ascii = (const lxb_char_t *) "xn--eo08b.xn--hdh3385g", .status = 4} /* 5966 */,
    {.source = (const lxb_char_t *) "򋡐。>\u0338𑋪", .ascii = (const lxb_char_t *) "xn--eo08b.xn--hdh3385g", .status = 4} /* 5967 */,
    {.source = (const lxb_char_t *) "xn--eo08b.xn--hdh3385g", .ascii = (const lxb_char_t *) "xn--eo08b.xn--hdh3385g", .status = 4} /* 5968 */,
    {.source = (const lxb_char_t *) "\u065A۲。\u200C-\u1BF3\u08E2", .ascii = (const lxb_char_t *) "xn--2hb81a.xn----xrd657l30d", .status = 16} /* 5969 */,
    {.source = (const lxb_char_t *) "xn--2hb81a.xn----xrd657l", .ascii = (const lxb_char_t *) "xn--2hb81a.xn----xrd657l", .status = 16} /* 5970 */,
    {.source = (const lxb_char_t *) "xn--2hb81a.xn----xrd657l30d", .ascii = (const lxb_char_t *) "xn--2hb81a.xn----xrd657l30d", .status = 16} /* 5971 */,
    {.source = (const lxb_char_t *) "󠄏𖬴󠲽｡\uFFA0", .ascii = (const lxb_char_t *) "xn--619ep9154c.xn--cl7c", .status = 8} /* 5972 */,
    {.source = (const lxb_char_t *) "󠄏𖬴󠲽。\u1160", .ascii = (const lxb_char_t *) "xn--619ep9154c.xn--psd", .status = 8} /* 5973 */,
    {.source = (const lxb_char_t *) "xn--619ep9154c.xn--psd", .ascii = (const lxb_char_t *) "xn--619ep9154c.xn--psd", .status = 8} /* 5974 */,
    {.source = (const lxb_char_t *) "xn--619ep9154c.xn--cl7c", .ascii = (const lxb_char_t *) "xn--619ep9154c.xn--cl7c", .status = 8} /* 5975 */,
    {.source = (const lxb_char_t *) "ß⒈\u0760\uD7AE．􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "xn--zca444a0s1ao12n.xn--nfb09923ifkyyb", .status = 8} /* 5976 */,
    {.source = (const lxb_char_t *) "ß1.\u0760\uD7AE.􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "xn--1-pfa.xn--kpb6677h.xn--nfb09923ifkyyb", .status = 16} /* 5977 */,
    {.source = (const lxb_char_t *) "SS1.\u0760\uD7AE.􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "ss1.xn--kpb6677h.xn--nfb09923ifkyyb", .status = 16} /* 5978 */,
    {.source = (const lxb_char_t *) "ss1.\u0760\uD7AE.􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "ss1.xn--kpb6677h.xn--nfb09923ifkyyb", .status = 16} /* 5979 */,
    {.source = (const lxb_char_t *) "Ss1.\u0760\uD7AE.􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "ss1.xn--kpb6677h.xn--nfb09923ifkyyb", .status = 16} /* 5980 */,
    {.source = (const lxb_char_t *) "ss1.xn--kpb6677h.xn--nfb09923ifkyyb", .ascii = (const lxb_char_t *) "ss1.xn--kpb6677h.xn--nfb09923ifkyyb", .status = 16} /* 5981 */,
    {.source = (const lxb_char_t *) "xn--1-pfa.xn--kpb6677h.xn--nfb09923ifkyyb", .ascii = (const lxb_char_t *) "xn--1-pfa.xn--kpb6677h.xn--nfb09923ifkyyb", .status = 16} /* 5982 */,
    {.source = (const lxb_char_t *) "SS⒈\u0760\uD7AE．􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "xn--ss-6ke9690a0g1q.xn--nfb09923ifkyyb", .status = 8} /* 5983 */,
    {.source = (const lxb_char_t *) "ss⒈\u0760\uD7AE．􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "xn--ss-6ke9690a0g1q.xn--nfb09923ifkyyb", .status = 8} /* 5984 */,
    {.source = (const lxb_char_t *) "Ss⒈\u0760\uD7AE．􉖲󠅄\u0605򉔯", .ascii = (const lxb_char_t *) "xn--ss-6ke9690a0g1q.xn--nfb09923ifkyyb", .status = 8} /* 5985 */,
    {.source = (const lxb_char_t *) "xn--ss-6ke9690a0g1q.xn--nfb09923ifkyyb", .ascii = (const lxb_char_t *) "xn--ss-6ke9690a0g1q.xn--nfb09923ifkyyb", .status = 8} /* 5986 */,
    {.source = (const lxb_char_t *) "xn--zca444a0s1ao12n.xn--nfb09923ifkyyb", .ascii = (const lxb_char_t *) "xn--zca444a0s1ao12n.xn--nfb09923ifkyyb", .status = 8} /* 5987 */,
    {.source = (const lxb_char_t *) "󠭔.𐋱₂", .ascii = (const lxb_char_t *) "xn--vi56e.xn--2-w91i", .status = 4} /* 5988 */,
    {.source = (const lxb_char_t *) "󠭔.𐋱2", .ascii = (const lxb_char_t *) "xn--vi56e.xn--2-w91i", .status = 4} /* 5989 */,
    {.source = (const lxb_char_t *) "xn--vi56e.xn--2-w91i", .ascii = (const lxb_char_t *) "xn--vi56e.xn--2-w91i", .status = 4} /* 5990 */,
    {.source = (const lxb_char_t *) "\u0716\u0947。-ß\u06A5\u200C", .ascii = (const lxb_char_t *) "xn--gnb63i.xn----qfa845bhx4a", .status = 12} /* 5991 */,
    {.source = (const lxb_char_t *) "\u0716\u0947。-SS\u06A5\u200C", .ascii = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef9263a", .status = 12} /* 5992 */,
    {.source = (const lxb_char_t *) "\u0716\u0947。-ss\u06A5\u200C", .ascii = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef9263a", .status = 12} /* 5993 */,
    {.source = (const lxb_char_t *) "\u0716\u0947。-Ss\u06A5\u200C", .ascii = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef9263a", .status = 12} /* 5994 */,
    {.source = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef", .ascii = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef", .status = 8} /* 5995 */,
    {.source = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef9263a", .ascii = (const lxb_char_t *) "xn--gnb63i.xn---ss-4ef9263a", .status = 12} /* 5996 */,
    {.source = (const lxb_char_t *) "xn--gnb63i.xn----qfa845bhx4a", .ascii = (const lxb_char_t *) "xn--gnb63i.xn----qfa845bhx4a", .status = 12} /* 5997 */,
    {.source = (const lxb_char_t *) "\u1BA9\u200D\u062A񡚈．\u1CD5䷉Ⴡ", .ascii = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--5nd792dgv3b", .status = 16} /* 5998 */,
    {.source = (const lxb_char_t *) "\u1BA9\u200D\u062A񡚈.\u1CD5䷉Ⴡ", .ascii = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--5nd792dgv3b", .status = 16} /* 5999 */,
    {.source = (const lxb_char_t *) "\u1BA9\u200D\u062A񡚈.\u1CD5䷉ⴡ", .ascii = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--i6f270etuy", .status = 16} /* 6000 */,
    {.source = (const lxb_char_t *) "xn--pgb911izv33i.xn--i6f270etuy", .ascii = (const lxb_char_t *) "xn--pgb911izv33i.xn--i6f270etuy", .status = 12} /* 6001 */,
    {.source = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--i6f270etuy", .ascii = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--i6f270etuy", .status = 16} /* 6002 */,
    {.source = (const lxb_char_t *) "xn--pgb911izv33i.xn--5nd792dgv3b", .ascii = (const lxb_char_t *) "xn--pgb911izv33i.xn--5nd792dgv3b", .status = 12} /* 6003 */,
    {.source = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--5nd792dgv3b", .ascii = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--5nd792dgv3b", .status = 16} /* 6004 */,
    {.source = (const lxb_char_t *) "\u1BA9\u200D\u062A񡚈．\u1CD5䷉ⴡ", .ascii = (const lxb_char_t *) "xn--pgb911imgdrw34r.xn--i6f270etuy", .status = 16} /* 6005 */,
    {.source = (const lxb_char_t *) "\u2DBF.ß\u200D", .ascii = (const lxb_char_t *) "xn--7pj.xn--zca870n", .status = 8} /* 6006 */,
    {.source = (const lxb_char_t *) "\u2DBF.SS\u200D", .ascii = (const lxb_char_t *) "xn--7pj.xn--ss-n1t", .status = 8} /* 6007 */,
    {.source = (const lxb_char_t *) "\u2DBF.ss\u200D", .ascii = (const lxb_char_t *) "xn--7pj.xn--ss-n1t", .status = 8} /* 6008 */,
    {.source = (const lxb_char_t *) "\u2DBF.Ss\u200D", .ascii = (const lxb_char_t *) "xn--7pj.xn--ss-n1t", .status = 8} /* 6009 */,
    {.source = (const lxb_char_t *) "xn--7pj.ss", .ascii = (const lxb_char_t *) "xn--7pj.ss", .status = 4} /* 6010 */,
    {.source = (const lxb_char_t *) "xn--7pj.xn--ss-n1t", .ascii = (const lxb_char_t *) "xn--7pj.xn--ss-n1t", .status = 8} /* 6011 */,
    {.source = (const lxb_char_t *) "xn--7pj.xn--zca870n", .ascii = (const lxb_char_t *) "xn--7pj.xn--zca870n", .status = 8} /* 6012 */,
    {.source = (const lxb_char_t *) "\u1BF3︒.\u062A≯ꡂ", .ascii = (const lxb_char_t *) "xn--1zf8957g.xn--pgb885lry5g", .status = 20} /* 6013 */,
    {.source = (const lxb_char_t *) "\u1BF3︒.\u062A>\u0338ꡂ", .ascii = (const lxb_char_t *) "xn--1zf8957g.xn--pgb885lry5g", .status = 20} /* 6014 */,
    {.source = (const lxb_char_t *) "\u1BF3。.\u062A≯ꡂ", .ascii = (const lxb_char_t *) "xn--1zf..xn--pgb885lry5g", .status = 18} /* 6015 */,
    {.source = (const lxb_char_t *) "\u1BF3。.\u062A>\u0338ꡂ", .ascii = (const lxb_char_t *) "xn--1zf..xn--pgb885lry5g", .status = 18} /* 6016 */,
    {.source = (const lxb_char_t *) "xn--1zf..xn--pgb885lry5g", .ascii = (const lxb_char_t *) "xn--1zf..xn--pgb885lry5g", .status = 18} /* 6017 */,
    {.source = (const lxb_char_t *) "xn--1zf8957g.xn--pgb885lry5g", .ascii = (const lxb_char_t *) "xn--1zf8957g.xn--pgb885lry5g", .status = 20} /* 6018 */,
    {.source = (const lxb_char_t *) "≮≠񏻃｡-𫠆\u06B7𐹪", .ascii = (const lxb_char_t *) "xn--1ch1a29470f.xn----7uc5363rc1rn", .status = 12} /* 6019 */,
    {.source = (const lxb_char_t *) "<\u0338=\u0338񏻃｡-𫠆\u06B7𐹪", .ascii = (const lxb_char_t *) "xn--1ch1a29470f.xn----7uc5363rc1rn", .status = 12} /* 6020 */,
    {.source = (const lxb_char_t *) "≮≠񏻃。-𫠆\u06B7𐹪", .ascii = (const lxb_char_t *) "xn--1ch1a29470f.xn----7uc5363rc1rn", .status = 12} /* 6021 */,
    {.source = (const lxb_char_t *) "<\u0338=\u0338񏻃。-𫠆\u06B7𐹪", .ascii = (const lxb_char_t *) "xn--1ch1a29470f.xn----7uc5363rc1rn", .status = 12} /* 6022 */,
    {.source = (const lxb_char_t *) "xn--1ch1a29470f.xn----7uc5363rc1rn", .ascii = (const lxb_char_t *) "xn--1ch1a29470f.xn----7uc5363rc1rn", .status = 12} /* 6023 */,
    {.source = (const lxb_char_t *) "𐹡\u0777。ꡂ", .ascii = (const lxb_char_t *) "xn--7pb5275k.xn--bc9a", .status = 4} /* 6024 */,
    {.source = (const lxb_char_t *) "xn--7pb5275k.xn--bc9a", .ascii = (const lxb_char_t *) "xn--7pb5275k.xn--bc9a", .status = 4} /* 6025 */,
    {.source = (const lxb_char_t *) "Ⴉ𝆅񔻅\u0619.ß𐧦𐹳\u0775", .ascii = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--zca684a699vf2d", .status = 12} /* 6026 */,
    {.source = (const lxb_char_t *) "ⴉ𝆅񔻅\u0619.ß𐧦𐹳\u0775", .ascii = (const lxb_char_t *) "xn--7fb940rwt3z7xvz.xn--zca684a699vf2d", .status = 12} /* 6027 */,
    {.source = (const lxb_char_t *) "Ⴉ𝆅񔻅\u0619.SS𐧦𐹳\u0775", .ascii = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--ss-zme7575xp0e", .status = 12} /* 6028 */,
    {.source = (const lxb_char_t *) "ⴉ𝆅񔻅\u0619.ss𐧦𐹳\u0775", .ascii = (const lxb_char_t *) "xn--7fb940rwt3z7xvz.xn--ss-zme7575xp0e", .status = 12} /* 6029 */,
    {.source = (const lxb_char_t *) "Ⴉ𝆅񔻅\u0619.Ss𐧦𐹳\u0775", .ascii = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--ss-zme7575xp0e", .status = 12} /* 6030 */,
    {.source = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--ss-zme7575xp0e", .ascii = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--ss-zme7575xp0e", .status = 12} /* 6031 */,
    {.source = (const lxb_char_t *) "xn--7fb940rwt3z7xvz.xn--ss-zme7575xp0e", .ascii = (const lxb_char_t *) "xn--7fb940rwt3z7xvz.xn--ss-zme7575xp0e", .status = 12} /* 6032 */,
    {.source = (const lxb_char_t *) "xn--7fb940rwt3z7xvz.xn--zca684a699vf2d", .ascii = (const lxb_char_t *) "xn--7fb940rwt3z7xvz.xn--zca684a699vf2d", .status = 12} /* 6033 */,
    {.source = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--zca684a699vf2d", .ascii = (const lxb_char_t *) "xn--7fb125cjv87a7xvz.xn--zca684a699vf2d", .status = 12} /* 6034 */,
    {.source = (const lxb_char_t *) "\u200D\u0643𐧾↙.񊽡", .ascii = (const lxb_char_t *) "xn--fhb713k87ag053c.xn--7s4w", .status = 12} /* 6035 */,
    {.source = (const lxb_char_t *) "xn--fhb011lnp8n.xn--7s4w", .ascii = (const lxb_char_t *) "xn--fhb011lnp8n.xn--7s4w", .status = 8} /* 6036 */,
    {.source = (const lxb_char_t *) "xn--fhb713k87ag053c.xn--7s4w", .ascii = (const lxb_char_t *) "xn--fhb713k87ag053c.xn--7s4w", .status = 12} /* 6037 */,
    {.source = (const lxb_char_t *) "梉。\u200C", .ascii = (const lxb_char_t *) "xn--7zv.xn--0ug", .status = 4} /* 6038 */,
    {.source = (const lxb_char_t *) "xn--7zv.", .ascii = (const lxb_char_t *) "xn--7zv.", .status = 0} /* 6039 */,
    {.source = (const lxb_char_t *) "梉.", .ascii = (const lxb_char_t *) "xn--7zv.", .status = 0} /* 6040 */,
    {.source = (const lxb_char_t *) "xn--7zv.xn--0ug", .ascii = (const lxb_char_t *) "xn--7zv.xn--0ug", .status = 4} /* 6041 */,
    {.source = (const lxb_char_t *) "ꡣ-≠.\u200D𞤗𐅢Ↄ", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug79cm620c71sh", .status = 16} /* 6042 */,
    {.source = (const lxb_char_t *) "ꡣ-=\u0338.\u200D𞤗𐅢Ↄ", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug79cm620c71sh", .status = 16} /* 6043 */,
    {.source = (const lxb_char_t *) "ꡣ-=\u0338.\u200D𞤹𐅢ↄ", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug99cj620c71sh", .status = 12} /* 6044 */,
    {.source = (const lxb_char_t *) "ꡣ-≠.\u200D𞤹𐅢ↄ", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug99cj620c71sh", .status = 12} /* 6045 */,
    {.source = (const lxb_char_t *) "ꡣ-≠.\u200D𞤗𐅢ↄ", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug99cj620c71sh", .status = 12} /* 6046 */,
    {.source = (const lxb_char_t *) "ꡣ-=\u0338.\u200D𞤗𐅢ↄ", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug99cj620c71sh", .status = 12} /* 6047 */,
    {.source = (const lxb_char_t *) "xn----ufo9661d.xn--r5gy929fhm4f", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--r5gy929fhm4f", .status = 12} /* 6048 */,
    {.source = (const lxb_char_t *) "xn----ufo9661d.xn--1ug99cj620c71sh", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug99cj620c71sh", .status = 12} /* 6049 */,
    {.source = (const lxb_char_t *) "xn----ufo9661d.xn--q5g0929fhm4f", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--q5g0929fhm4f", .status = 16} /* 6050 */,
    {.source = (const lxb_char_t *) "xn----ufo9661d.xn--1ug79cm620c71sh", .ascii = (const lxb_char_t *) "xn----ufo9661d.xn--1ug79cm620c71sh", .status = 16} /* 6051 */,
    {.source = (const lxb_char_t *) "ς⒐𝆫⸵｡𐱢🄊𝟳", .ascii = (const lxb_char_t *) "xn--3xa019nwtghi25b.xn--7-075iy877c", .status = 8} /* 6052 */,
    {.source = (const lxb_char_t *) "ς9.𝆫⸵。𐱢9,7", .ascii = (const lxb_char_t *) "xn--9-xmb.xn--ltj1535k.xn--9,7-r67t", .status = 12} /* 6053 */,
    {.source = (const lxb_char_t *) "Σ9.𝆫⸵。𐱢9,7", .ascii = (const lxb_char_t *) "xn--9-zmb.xn--ltj1535k.xn--9,7-r67t", .status = 12} /* 6054 */,
    {.source = (const lxb_char_t *) "σ9.𝆫⸵。𐱢9,7", .ascii = (const lxb_char_t *) "xn--9-zmb.xn--ltj1535k.xn--9,7-r67t", .status = 12} /* 6055 */,
    {.source = (const lxb_char_t *) "xn--9-zmb.xn--ltj1535k.xn--9,7-r67t", .ascii = (const lxb_char_t *) "xn--9-zmb.xn--ltj1535k.xn--9,7-r67t", .status = 12} /* 6056 */,
    {.source = (const lxb_char_t *) "xn--9-xmb.xn--ltj1535k.xn--9,7-r67t", .ascii = (const lxb_char_t *) "xn--9-xmb.xn--ltj1535k.xn--9,7-r67t", .status = 12} /* 6057 */,
    {.source = (const lxb_char_t *) "Σ⒐𝆫⸵｡𐱢🄊𝟳", .ascii = (const lxb_char_t *) "xn--4xa809nwtghi25b.xn--7-075iy877c", .status = 8} /* 6058 */,
    {.source = (const lxb_char_t *) "σ⒐𝆫⸵｡𐱢🄊𝟳", .ascii = (const lxb_char_t *) "xn--4xa809nwtghi25b.xn--7-075iy877c", .status = 8} /* 6059 */,
    {.source = (const lxb_char_t *) "xn--4xa809nwtghi25b.xn--7-075iy877c", .ascii = (const lxb_char_t *) "xn--4xa809nwtghi25b.xn--7-075iy877c", .status = 8} /* 6060 */,
    {.source = (const lxb_char_t *) "xn--3xa019nwtghi25b.xn--7-075iy877c", .ascii = (const lxb_char_t *) "xn--3xa019nwtghi25b.xn--7-075iy877c", .status = 8} /* 6061 */,
    {.source = (const lxb_char_t *) "\u0853．\u200Cß", .ascii = (const lxb_char_t *) "xn--iwb.xn--zca570n", .status = 8} /* 6062 */,
    {.source = (const lxb_char_t *) "\u0853.\u200Cß", .ascii = (const lxb_char_t *) "xn--iwb.xn--zca570n", .status = 8} /* 6063 */,
    {.source = (const lxb_char_t *) "\u0853.\u200CSS", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6064 */,
    {.source = (const lxb_char_t *) "\u0853.\u200Css", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6065 */,
    {.source = (const lxb_char_t *) "xn--iwb.ss", .ascii = (const lxb_char_t *) "xn--iwb.ss", .status = 0} /* 6066 */,
    {.source = (const lxb_char_t *) "\u0853.ss", .ascii = (const lxb_char_t *) "xn--iwb.ss", .status = 0} /* 6067 */,
    {.source = (const lxb_char_t *) "\u0853.SS", .ascii = (const lxb_char_t *) "xn--iwb.ss", .status = 0} /* 6068 */,
    {.source = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6069 */,
    {.source = (const lxb_char_t *) "xn--iwb.xn--zca570n", .ascii = (const lxb_char_t *) "xn--iwb.xn--zca570n", .status = 8} /* 6070 */,
    {.source = (const lxb_char_t *) "\u0853．\u200CSS", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6071 */,
    {.source = (const lxb_char_t *) "\u0853．\u200Css", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6072 */,
    {.source = (const lxb_char_t *) "\u0853.\u200CSs", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6073 */,
    {.source = (const lxb_char_t *) "\u0853．\u200CSs", .ascii = (const lxb_char_t *) "xn--iwb.xn--ss-i1t", .status = 8} /* 6074 */,
    {.source = (const lxb_char_t *) "񯶣-.\u200D\u074E\uA94D󠻨", .ascii = (const lxb_char_t *) "xn----s116e.xn--1ob387jy90hq459k", .status = 20} /* 6075 */,
    {.source = (const lxb_char_t *) "xn----s116e.xn--1ob6504fmf40i", .ascii = (const lxb_char_t *) "xn----s116e.xn--1ob6504fmf40i", .status = 16} /* 6076 */,
    {.source = (const lxb_char_t *) "xn----s116e.xn--1ob387jy90hq459k", .ascii = (const lxb_char_t *) "xn----s116e.xn--1ob387jy90hq459k", .status = 20} /* 6077 */,
    {.source = (const lxb_char_t *) "䃚蟥-。-񽒘⒈", .ascii = (const lxb_char_t *) "xn----n50a258u.xn----ecp33805f", .status = 8} /* 6078 */,
    {.source = (const lxb_char_t *) "䃚蟥-。-񽒘1.", .ascii = (const lxb_char_t *) "xn----n50a258u.xn---1-up07j.", .status = 8} /* 6079 */,
    {.source = (const lxb_char_t *) "xn----n50a258u.xn---1-up07j.", .ascii = (const lxb_char_t *) "xn----n50a258u.xn---1-up07j.", .status = 8} /* 6080 */,
    {.source = (const lxb_char_t *) "xn----n50a258u.xn----ecp33805f", .ascii = (const lxb_char_t *) "xn----n50a258u.xn----ecp33805f", .status = 8} /* 6081 */,
    {.source = (const lxb_char_t *) "𐹸䚵-ꡡ。⺇", .ascii = (const lxb_char_t *) "xn----bm3an932a1l5d.xn--xvj", .status = 4} /* 6082 */,
    {.source = (const lxb_char_t *) "xn----bm3an932a1l5d.xn--xvj", .ascii = (const lxb_char_t *) "xn----bm3an932a1l5d.xn--xvj", .status = 4} /* 6083 */,
    {.source = (const lxb_char_t *) "𑄳。\u1ADC𐹻", .ascii = (const lxb_char_t *) "xn--v80d.xn--2rf1154i", .status = 20} /* 6084 */,
    {.source = (const lxb_char_t *) "xn--v80d.xn--2rf1154i", .ascii = (const lxb_char_t *) "xn--v80d.xn--2rf1154i", .status = 20} /* 6085 */,
    {.source = (const lxb_char_t *) "≮𐹻.⒎𑂵\u06BA\u0602", .ascii = (const lxb_char_t *) "xn--gdhx904g.xn--kfb18a325efm3s", .status = 8} /* 6086 */,
    {.source = (const lxb_char_t *) "<\u0338𐹻.⒎𑂵\u06BA\u0602", .ascii = (const lxb_char_t *) "xn--gdhx904g.xn--kfb18a325efm3s", .status = 8} /* 6087 */,
    {.source = (const lxb_char_t *) "≮𐹻.7.𑂵\u06BA\u0602", .ascii = (const lxb_char_t *) "xn--gdhx904g.7.xn--kfb18an307d", .status = 12} /* 6088 */,
    {.source = (const lxb_char_t *) "<\u0338𐹻.7.𑂵\u06BA\u0602", .ascii = (const lxb_char_t *) "xn--gdhx904g.7.xn--kfb18an307d", .status = 12} /* 6089 */,
    {.source = (const lxb_char_t *) "xn--gdhx904g.7.xn--kfb18an307d", .ascii = (const lxb_char_t *) "xn--gdhx904g.7.xn--kfb18an307d", .status = 12} /* 6090 */,
    {.source = (const lxb_char_t *) "xn--gdhx904g.xn--kfb18a325efm3s", .ascii = (const lxb_char_t *) "xn--gdhx904g.xn--kfb18a325efm3s", .status = 8} /* 6091 */,
    {.source = (const lxb_char_t *) "ᢔ≠􋉂.\u200D𐋢", .ascii = (const lxb_char_t *) "xn--ebf031cf7196a.xn--1ug9540g", .status = 8} /* 6092 */,
    {.source = (const lxb_char_t *) "ᢔ=\u0338􋉂.\u200D𐋢", .ascii = (const lxb_char_t *) "xn--ebf031cf7196a.xn--1ug9540g", .status = 8} /* 6093 */,
    {.source = (const lxb_char_t *) "xn--ebf031cf7196a.xn--587c", .ascii = (const lxb_char_t *) "xn--ebf031cf7196a.xn--587c", .status = 4} /* 6094 */,
    {.source = (const lxb_char_t *) "xn--ebf031cf7196a.xn--1ug9540g", .ascii = (const lxb_char_t *) "xn--ebf031cf7196a.xn--1ug9540g", .status = 8} /* 6095 */,
    {.source = (const lxb_char_t *) "𐩁≮񣊛≯．\u066C𞵕⳿", .ascii = (const lxb_char_t *) "xn--gdhc0519o0y27b.xn--lib468q0d21a", .status = 16} /* 6096 */,
    {.source = (const lxb_char_t *) "𐩁<\u0338񣊛>\u0338．\u066C𞵕⳿", .ascii = (const lxb_char_t *) "xn--gdhc0519o0y27b.xn--lib468q0d21a", .status = 16} /* 6097 */,
    {.source = (const lxb_char_t *) "𐩁≮񣊛≯.\u066C𞵕⳿", .ascii = (const lxb_char_t *) "xn--gdhc0519o0y27b.xn--lib468q0d21a", .status = 16} /* 6098 */,
    {.source = (const lxb_char_t *) "𐩁<\u0338񣊛>\u0338.\u066C𞵕⳿", .ascii = (const lxb_char_t *) "xn--gdhc0519o0y27b.xn--lib468q0d21a", .status = 16} /* 6099 */,
    {.source = (const lxb_char_t *) "xn--gdhc0519o0y27b.xn--lib468q0d21a", .ascii = (const lxb_char_t *) "xn--gdhc0519o0y27b.xn--lib468q0d21a", .status = 16} /* 6100 */,
    {.source = (const lxb_char_t *) "-｡⺐", .ascii = (const lxb_char_t *) "-.xn--6vj", .status = 4} /* 6101 */,
    {.source = (const lxb_char_t *) "-。⺐", .ascii = (const lxb_char_t *) "-.xn--6vj", .status = 4} /* 6102 */,
    {.source = (const lxb_char_t *) "-.xn--6vj", .ascii = (const lxb_char_t *) "-.xn--6vj", .status = 4} /* 6103 */,
    {.source = (const lxb_char_t *) "󠰩𑲬．\u065C", .ascii = (const lxb_char_t *) "xn--sn3d59267c.xn--4hb", .status = 8} /* 6104 */,
    {.source = (const lxb_char_t *) "󠰩𑲬.\u065C", .ascii = (const lxb_char_t *) "xn--sn3d59267c.xn--4hb", .status = 8} /* 6105 */,
    {.source = (const lxb_char_t *) "xn--sn3d59267c.xn--4hb", .ascii = (const lxb_char_t *) "xn--sn3d59267c.xn--4hb", .status = 8} /* 6106 */,
    {.source = (const lxb_char_t *) "𐍺.񚇃\u200C", .ascii = (const lxb_char_t *) "xn--ie8c.xn--0ug03366c", .status = 12} /* 6107 */,
    {.source = (const lxb_char_t *) "xn--ie8c.xn--2g51a", .ascii = (const lxb_char_t *) "xn--ie8c.xn--2g51a", .status = 8} /* 6108 */,
    {.source = (const lxb_char_t *) "xn--ie8c.xn--0ug03366c", .ascii = (const lxb_char_t *) "xn--ie8c.xn--0ug03366c", .status = 12} /* 6109 */,
    {.source = (const lxb_char_t *) "\u063D\u06E3.𐨎", .ascii = (const lxb_char_t *) "xn--8gb64a.xn--mr9c", .status = 8} /* 6110 */,
    {.source = (const lxb_char_t *) "xn--8gb64a.xn--mr9c", .ascii = (const lxb_char_t *) "xn--8gb64a.xn--mr9c", .status = 8} /* 6111 */,
    {.source = (const lxb_char_t *) "漦Ⴙς.񡻀𐴄", .ascii = (const lxb_char_t *) "xn--3xa157d717e.xn--9d0d3162t", .status = 12} /* 6112 */,
    {.source = (const lxb_char_t *) "漦ⴙς.񡻀𐴄", .ascii = (const lxb_char_t *) "xn--3xa972sl47b.xn--9d0d3162t", .status = 12} /* 6113 */,
    {.source = (const lxb_char_t *) "漦ႹΣ.񡻀𐴄", .ascii = (const lxb_char_t *) "xn--4xa947d717e.xn--9d0d3162t", .status = 12} /* 6114 */,
    {.source = (const lxb_char_t *) "漦ⴙσ.񡻀𐴄", .ascii = (const lxb_char_t *) "xn--4xa772sl47b.xn--9d0d3162t", .status = 12} /* 6115 */,
    {.source = (const lxb_char_t *) "漦Ⴙσ.񡻀𐴄", .ascii = (const lxb_char_t *) "xn--4xa947d717e.xn--9d0d3162t", .status = 12} /* 6116 */,
    {.source = (const lxb_char_t *) "xn--4xa947d717e.xn--9d0d3162t", .ascii = (const lxb_char_t *) "xn--4xa947d717e.xn--9d0d3162t", .status = 12} /* 6117 */,
    {.source = (const lxb_char_t *) "xn--4xa772sl47b.xn--9d0d3162t", .ascii = (const lxb_char_t *) "xn--4xa772sl47b.xn--9d0d3162t", .status = 12} /* 6118 */,
    {.source = (const lxb_char_t *) "xn--3xa972sl47b.xn--9d0d3162t", .ascii = (const lxb_char_t *) "xn--3xa972sl47b.xn--9d0d3162t", .status = 12} /* 6119 */,
    {.source = (const lxb_char_t *) "xn--3xa157d717e.xn--9d0d3162t", .ascii = (const lxb_char_t *) "xn--3xa157d717e.xn--9d0d3162t", .status = 12} /* 6120 */,
    {.source = (const lxb_char_t *) "𐹫踧\u0CCD򫚇.󜀃⒈𝨤", .ascii = (const lxb_char_t *) "xn--8tc1437dro0d6q06h.xn--tsh2611ncu71e", .status = 8} /* 6121 */,
    {.source = (const lxb_char_t *) "𐹫踧\u0CCD򫚇.󜀃1.𝨤", .ascii = (const lxb_char_t *) "xn--8tc1437dro0d6q06h.xn--1-p948l.xn--m82h", .status = 12} /* 6122 */,
    {.source = (const lxb_char_t *) "xn--8tc1437dro0d6q06h.xn--1-p948l.xn--m82h", .ascii = (const lxb_char_t *) "xn--8tc1437dro0d6q06h.xn--1-p948l.xn--m82h", .status = 12} /* 6123 */,
    {.source = (const lxb_char_t *) "xn--8tc1437dro0d6q06h.xn--tsh2611ncu71e", .ascii = (const lxb_char_t *) "xn--8tc1437dro0d6q06h.xn--tsh2611ncu71e", .status = 8} /* 6124 */,
    {.source = (const lxb_char_t *) "\u200D≮．󠟪𹫏-", .ascii = (const lxb_char_t *) "xn--1ug95g.xn----cr99a1w710b", .status = 12} /* 6125 */,
    {.source = (const lxb_char_t *) "\u200D<\u0338．󠟪𹫏-", .ascii = (const lxb_char_t *) "xn--1ug95g.xn----cr99a1w710b", .status = 12} /* 6126 */,
    {.source = (const lxb_char_t *) "\u200D≮.󠟪𹫏-", .ascii = (const lxb_char_t *) "xn--1ug95g.xn----cr99a1w710b", .status = 12} /* 6127 */,
    {.source = (const lxb_char_t *) "\u200D<\u0338.󠟪𹫏-", .ascii = (const lxb_char_t *) "xn--1ug95g.xn----cr99a1w710b", .status = 12} /* 6128 */,
    {.source = (const lxb_char_t *) "xn--gdh.xn----cr99a1w710b", .ascii = (const lxb_char_t *) "xn--gdh.xn----cr99a1w710b", .status = 8} /* 6129 */,
    {.source = (const lxb_char_t *) "xn--1ug95g.xn----cr99a1w710b", .ascii = (const lxb_char_t *) "xn--1ug95g.xn----cr99a1w710b", .status = 12} /* 6130 */,
    {.source = (const lxb_char_t *) "\u200D\u200D襔。Ⴜ5ꡮ񵝏", .ascii = (const lxb_char_t *) "xn--1uga7691f.xn--5-r1g7167ipfw8d", .status = 8} /* 6131 */,
    {.source = (const lxb_char_t *) "\u200D\u200D襔。ⴜ5ꡮ񵝏", .ascii = (const lxb_char_t *) "xn--1uga7691f.xn--5-uws5848bpf44e", .status = 8} /* 6132 */,
    {.source = (const lxb_char_t *) "xn--2u2a.xn--5-uws5848bpf44e", .ascii = (const lxb_char_t *) "xn--2u2a.xn--5-uws5848bpf44e", .status = 4} /* 6133 */,
    {.source = (const lxb_char_t *) "xn--1uga7691f.xn--5-uws5848bpf44e", .ascii = (const lxb_char_t *) "xn--1uga7691f.xn--5-uws5848bpf44e", .status = 8} /* 6134 */,
    {.source = (const lxb_char_t *) "xn--2u2a.xn--5-r1g7167ipfw8d", .ascii = (const lxb_char_t *) "xn--2u2a.xn--5-r1g7167ipfw8d", .status = 4} /* 6135 */,
    {.source = (const lxb_char_t *) "xn--1uga7691f.xn--5-r1g7167ipfw8d", .ascii = (const lxb_char_t *) "xn--1uga7691f.xn--5-r1g7167ipfw8d", .status = 8} /* 6136 */,
    {.source = (const lxb_char_t *) "𐫜𑌼\u200D．婀", .ascii = (const lxb_char_t *) "xn--1ugx063g1if.xn--q0s", .status = 8} /* 6137 */,
    {.source = (const lxb_char_t *) "𐫜𑌼\u200D.婀", .ascii = (const lxb_char_t *) "xn--1ugx063g1if.xn--q0s", .status = 8} /* 6138 */,
    {.source = (const lxb_char_t *) "xn--ix9c26l.xn--q0s", .ascii = (const lxb_char_t *) "xn--ix9c26l.xn--q0s", .status = 0} /* 6139 */,
    {.source = (const lxb_char_t *) "𐫜𑌼.婀", .ascii = (const lxb_char_t *) "xn--ix9c26l.xn--q0s", .status = 0} /* 6140 */,
    {.source = (const lxb_char_t *) "xn--1ugx063g1if.xn--q0s", .ascii = (const lxb_char_t *) "xn--1ugx063g1if.xn--q0s", .status = 8} /* 6141 */,
    {.source = (const lxb_char_t *) "󠅽︒︒𐹯｡⬳\u1A78", .ascii = (const lxb_char_t *) "xn--y86ca186j.xn--7of309e", .status = 8} /* 6142 */,
    {.source = (const lxb_char_t *) "󠅽。。𐹯。⬳\u1A78", .ascii = (const lxb_char_t *) "..xn--no0d.xn--7of309e", .status = 10} /* 6143 */,
    {.source = (const lxb_char_t *) "..xn--no0d.xn--7of309e", .ascii = (const lxb_char_t *) "..xn--no0d.xn--7of309e", .status = 10} /* 6144 */,
    {.source = (const lxb_char_t *) "xn--y86ca186j.xn--7of309e", .ascii = (const lxb_char_t *) "xn--y86ca186j.xn--7of309e", .status = 8} /* 6145 */,
    {.source = (const lxb_char_t *) "𝟖ß．󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .status = 8} /* 6146 */,
    {.source = (const lxb_char_t *) "8ß.󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .status = 8} /* 6147 */,
    {.source = (const lxb_char_t *) "8ß.󠄐-?ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-261a", .status = 8} /* 6148 */,
    {.source = (const lxb_char_t *) "8SS.󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6149 */,
    {.source = (const lxb_char_t *) "8ss.󠄐-?ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-261a", .status = 8} /* 6150 */,
    {.source = (const lxb_char_t *) "8ss.󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6151 */,
    {.source = (const lxb_char_t *) "8ss.xn---?-gfk", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6152 */,
    {.source = (const lxb_char_t *) "8ss.xn---?-261a", .ascii = (const lxb_char_t *) "8ss.xn---?-261a", .status = 8} /* 6153 */,
    {.source = (const lxb_char_t *) "xn--8-qfa.xn---?-261a", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-261a", .status = 8} /* 6154 */,
    {.source = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .status = 8} /* 6155 */,
    {.source = (const lxb_char_t *) "𝟖ß．󠄐-?ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-261a", .status = 8} /* 6156 */,
    {.source = (const lxb_char_t *) "𝟖SS．󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6157 */,
    {.source = (const lxb_char_t *) "𝟖ss．󠄐-?ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-261a", .status = 8} /* 6158 */,
    {.source = (const lxb_char_t *) "𝟖ss．󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6159 */,
    {.source = (const lxb_char_t *) "8ss.-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6160 */,
    {.source = (const lxb_char_t *) "8ss.-?ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-261a", .status = 8} /* 6161 */,
    {.source = (const lxb_char_t *) "8SS.-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6162 */,
    {.source = (const lxb_char_t *) "xn--8-qfa.-?ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-261a", .status = 8} /* 6163 */,
    {.source = (const lxb_char_t *) "XN--8-QFA.-?Ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .status = 8} /* 6164 */,
    {.source = (const lxb_char_t *) "Xn--8-Qfa.-?Ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .status = 8} /* 6165 */,
    {.source = (const lxb_char_t *) "xn--8-qfa.-?Ⴏ", .ascii = (const lxb_char_t *) "xn--8-qfa.xn---?-gfk", .status = 8} /* 6166 */,
    {.source = (const lxb_char_t *) "𝟖Ss．󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6167 */,
    {.source = (const lxb_char_t *) "8Ss.󠄐-?Ⴏ", .ascii = (const lxb_char_t *) "8ss.xn---?-gfk", .status = 8} /* 6168 */,
    {.source = (const lxb_char_t *) "-\u200D󠋟.\u200C𐹣Ⴅ", .ascii = (const lxb_char_t *) "xn----ugnv7071n.xn--dnd999e4j4p", .status = 20} /* 6169 */,
    {.source = (const lxb_char_t *) "-\u200D󠋟.\u200C𐹣ⴅ", .ascii = (const lxb_char_t *) "xn----ugnv7071n.xn--0ugz32cgr0p", .status = 20} /* 6170 */,
    {.source = (const lxb_char_t *) "xn----s721m.xn--wkj1423e", .ascii = (const lxb_char_t *) "xn----s721m.xn--wkj1423e", .status = 12} /* 6171 */,
    {.source = (const lxb_char_t *) "xn----ugnv7071n.xn--0ugz32cgr0p", .ascii = (const lxb_char_t *) "xn----ugnv7071n.xn--0ugz32cgr0p", .status = 20} /* 6172 */,
    {.source = (const lxb_char_t *) "xn----s721m.xn--dnd9201k", .ascii = (const lxb_char_t *) "xn----s721m.xn--dnd9201k", .status = 12} /* 6173 */,
    {.source = (const lxb_char_t *) "xn----ugnv7071n.xn--dnd999e4j4p", .ascii = (const lxb_char_t *) "xn----ugnv7071n.xn--dnd999e4j4p", .status = 20} /* 6174 */,
    {.source = (const lxb_char_t *) "\uA9B9\u200D큷𻶡｡₂", .ascii = (const lxb_char_t *) "xn--1ug1435cfkyaoi04d.2", .status = 12} /* 6175 */,
    {.source = (const lxb_char_t *) "\uA9B9\u200D큷𻶡｡₂", .ascii = (const lxb_char_t *) "xn--1ug1435cfkyaoi04d.2", .status = 12} /* 6176 */,
    {.source = (const lxb_char_t *) "\uA9B9\u200D큷𻶡。2", .ascii = (const lxb_char_t *) "xn--1ug1435cfkyaoi04d.2", .status = 12} /* 6177 */,
    {.source = (const lxb_char_t *) "\uA9B9\u200D큷𻶡。2", .ascii = (const lxb_char_t *) "xn--1ug1435cfkyaoi04d.2", .status = 12} /* 6178 */,
    {.source = (const lxb_char_t *) "xn--0m9as84e2e21c.2", .ascii = (const lxb_char_t *) "xn--0m9as84e2e21c.2", .status = 8} /* 6179 */,
    {.source = (const lxb_char_t *) "xn--1ug1435cfkyaoi04d.2", .ascii = (const lxb_char_t *) "xn--1ug1435cfkyaoi04d.2", .status = 12} /* 6180 */,
    {.source = (const lxb_char_t *) "?.🄄𞯘", .ascii = (const lxb_char_t *) "?.xn--3x6hx6f", .status = 8} /* 6181 */,
    {.source = (const lxb_char_t *) "?.3,𞯘", .ascii = (const lxb_char_t *) "?.xn--3,-tb22a", .status = 8} /* 6182 */,
    {.source = (const lxb_char_t *) "?.xn--3,-tb22a", .ascii = (const lxb_char_t *) "?.xn--3,-tb22a", .status = 8} /* 6183 */,
    {.source = (const lxb_char_t *) "?.xn--3x6hx6f", .ascii = (const lxb_char_t *) "?.xn--3x6hx6f", .status = 8} /* 6184 */,
    {.source = (const lxb_char_t *) "𝨖𐩙。\u06DD󀡶\uA8C5⒈", .ascii = (const lxb_char_t *) "xn--rt9cl956a.xn--tlb403mxv4g06s9i", .status = 12} /* 6185 */,
    {.source = (const lxb_char_t *) "𝨖𐩙。\u06DD󀡶\uA8C51.", .ascii = (const lxb_char_t *) "xn--rt9cl956a.xn--1-dxc8545j0693i.", .status = 12} /* 6186 */,
    {.source = (const lxb_char_t *) "xn--rt9cl956a.xn--1-dxc8545j0693i.", .ascii = (const lxb_char_t *) "xn--rt9cl956a.xn--1-dxc8545j0693i.", .status = 12} /* 6187 */,
    {.source = (const lxb_char_t *) "xn--rt9cl956a.xn--tlb403mxv4g06s9i", .ascii = (const lxb_char_t *) "xn--rt9cl956a.xn--tlb403mxv4g06s9i", .status = 12} /* 6188 */,
    {.source = (const lxb_char_t *) "򒈣\u05E1\u06B8。Ⴈ\u200D", .ascii = (const lxb_char_t *) "xn--meb44b57607c.xn--gnd699e", .status = 16} /* 6189 */,
    {.source = (const lxb_char_t *) "򒈣\u05E1\u06B8。ⴈ\u200D", .ascii = (const lxb_char_t *) "xn--meb44b57607c.xn--1ug232c", .status = 16} /* 6190 */,
    {.source = (const lxb_char_t *) "xn--meb44b57607c.xn--zkj", .ascii = (const lxb_char_t *) "xn--meb44b57607c.xn--zkj", .status = 12} /* 6191 */,
    {.source = (const lxb_char_t *) "xn--meb44b57607c.xn--1ug232c", .ascii = (const lxb_char_t *) "xn--meb44b57607c.xn--1ug232c", .status = 16} /* 6192 */,
    {.source = (const lxb_char_t *) "xn--meb44b57607c.xn--gnd", .ascii = (const lxb_char_t *) "xn--meb44b57607c.xn--gnd", .status = 12} /* 6193 */,
    {.source = (const lxb_char_t *) "xn--meb44b57607c.xn--gnd699e", .ascii = (const lxb_char_t *) "xn--meb44b57607c.xn--gnd699e", .status = 16} /* 6194 */,
    {.source = (const lxb_char_t *) "󀚶𝨱\u07E6⒈．𑗝髯\u200C", .ascii = (const lxb_char_t *) "xn--etb477lq931a1f58e.xn--0ugx259bocxd", .status = 20} /* 6195 */,
    {.source = (const lxb_char_t *) "󀚶𝨱\u07E61..𑗝髯\u200C", .ascii = (const lxb_char_t *) "xn--1-idd62296a1fr6e..xn--0ugx259bocxd", .status = 26} /* 6196 */,
    {.source = (const lxb_char_t *) "xn--1-idd62296a1fr6e..xn--uj6at43v", .ascii = (const lxb_char_t *) "xn--1-idd62296a1fr6e..xn--uj6at43v", .status = 22} /* 6197 */,
    {.source = (const lxb_char_t *) "xn--1-idd62296a1fr6e..xn--0ugx259bocxd", .ascii = (const lxb_char_t *) "xn--1-idd62296a1fr6e..xn--0ugx259bocxd", .status = 26} /* 6198 */,
    {.source = (const lxb_char_t *) "xn--etb477lq931a1f58e.xn--uj6at43v", .ascii = (const lxb_char_t *) "xn--etb477lq931a1f58e.xn--uj6at43v", .status = 16} /* 6199 */,
    {.source = (const lxb_char_t *) "xn--etb477lq931a1f58e.xn--0ugx259bocxd", .ascii = (const lxb_char_t *) "xn--etb477lq931a1f58e.xn--0ugx259bocxd", .status = 20} /* 6200 */,
    {.source = (const lxb_char_t *) "𐫀．\u0689𑌀", .ascii = (const lxb_char_t *) "xn--pw9c.xn--fjb8658k", .status = 0} /* 6201 */,
    {.source = (const lxb_char_t *) "𐫀.\u0689𑌀", .ascii = (const lxb_char_t *) "xn--pw9c.xn--fjb8658k", .status = 0} /* 6202 */,
    {.source = (const lxb_char_t *) "xn--pw9c.xn--fjb8658k", .ascii = (const lxb_char_t *) "xn--pw9c.xn--fjb8658k", .status = 0} /* 6203 */,
    {.source = (const lxb_char_t *) "𑋪．𐳝", .ascii = (const lxb_char_t *) "xn--fm1d.xn--5c0d", .status = 8} /* 6204 */,
    {.source = (const lxb_char_t *) "𑋪.𐳝", .ascii = (const lxb_char_t *) "xn--fm1d.xn--5c0d", .status = 8} /* 6205 */,
    {.source = (const lxb_char_t *) "𑋪.𐲝", .ascii = (const lxb_char_t *) "xn--fm1d.xn--5c0d", .status = 8} /* 6206 */,
    {.source = (const lxb_char_t *) "xn--fm1d.xn--5c0d", .ascii = (const lxb_char_t *) "xn--fm1d.xn--5c0d", .status = 8} /* 6207 */,
    {.source = (const lxb_char_t *) "𑋪．𐲝", .ascii = (const lxb_char_t *) "xn--fm1d.xn--5c0d", .status = 8} /* 6208 */,
    {.source = (const lxb_char_t *) "≠膣。\u0F83", .ascii = (const lxb_char_t *) "xn--1chy468a.xn--2ed", .status = 4} /* 6209 */,
    {.source = (const lxb_char_t *) "=\u0338膣。\u0F83", .ascii = (const lxb_char_t *) "xn--1chy468a.xn--2ed", .status = 4} /* 6210 */,
    {.source = (const lxb_char_t *) "xn--1chy468a.xn--2ed", .ascii = (const lxb_char_t *) "xn--1chy468a.xn--2ed", .status = 4} /* 6211 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D｡ß", .ascii = (const lxb_char_t *) "xn----j6c95618k.xn--zca", .status = 12} /* 6212 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D。ß", .ascii = (const lxb_char_t *) "xn----j6c95618k.xn--zca", .status = 12} /* 6213 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D。SS", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6214 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D。ss", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6215 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D。Ss", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6216 */,
    {.source = (const lxb_char_t *) "xn----j6c95618k.ss", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6217 */,
    {.source = (const lxb_char_t *) "xn----j6c95618k.xn--zca", .ascii = (const lxb_char_t *) "xn----j6c95618k.xn--zca", .status = 12} /* 6218 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D｡SS", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6219 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D｡ss", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6220 */,
    {.source = (const lxb_char_t *) "񰀎-\u077D｡Ss", .ascii = (const lxb_char_t *) "xn----j6c95618k.ss", .status = 12} /* 6221 */,
    {.source = (const lxb_char_t *) "ς𐹠ᡚ𑄳．⾭𐹽𽐖𐫜", .ascii = (const lxb_char_t *) "xn--3xa856hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6222 */,
    {.source = (const lxb_char_t *) "ς𐹠ᡚ𑄳.靑𐹽𽐖𐫜", .ascii = (const lxb_char_t *) "xn--3xa856hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6223 */,
    {.source = (const lxb_char_t *) "Σ𐹠ᡚ𑄳.靑𐹽𽐖𐫜", .ascii = (const lxb_char_t *) "xn--4xa656hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6224 */,
    {.source = (const lxb_char_t *) "σ𐹠ᡚ𑄳.靑𐹽𽐖𐫜", .ascii = (const lxb_char_t *) "xn--4xa656hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6225 */,
    {.source = (const lxb_char_t *) "xn--4xa656hp23pxmc.xn--es5a888tvjc2u15h", .ascii = (const lxb_char_t *) "xn--4xa656hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6226 */,
    {.source = (const lxb_char_t *) "xn--3xa856hp23pxmc.xn--es5a888tvjc2u15h", .ascii = (const lxb_char_t *) "xn--3xa856hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6227 */,
    {.source = (const lxb_char_t *) "Σ𐹠ᡚ𑄳．⾭𐹽𽐖𐫜", .ascii = (const lxb_char_t *) "xn--4xa656hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6228 */,
    {.source = (const lxb_char_t *) "σ𐹠ᡚ𑄳．⾭𐹽𽐖𐫜", .ascii = (const lxb_char_t *) "xn--4xa656hp23pxmc.xn--es5a888tvjc2u15h", .status = 12} /* 6229 */,
    {.source = (const lxb_char_t *) "𐋷。\u200D", .ascii = (const lxb_char_t *) "xn--r97c.xn--1ug", .status = 4} /* 6230 */,
    {.source = (const lxb_char_t *) "xn--r97c.", .ascii = (const lxb_char_t *) "xn--r97c.", .status = 0} /* 6231 */,
    {.source = (const lxb_char_t *) "𐋷.", .ascii = (const lxb_char_t *) "xn--r97c.", .status = 0} /* 6232 */,
    {.source = (const lxb_char_t *) "xn--r97c.xn--1ug", .ascii = (const lxb_char_t *) "xn--r97c.xn--1ug", .status = 4} /* 6233 */,
    {.source = (const lxb_char_t *) "𑰳𑈯。⥪", .ascii = (const lxb_char_t *) "xn--2g1d14o.xn--jti", .status = 4} /* 6234 */,
    {.source = (const lxb_char_t *) "xn--2g1d14o.xn--jti", .ascii = (const lxb_char_t *) "xn--2g1d14o.xn--jti", .status = 4} /* 6235 */,
    {.source = (const lxb_char_t *) "𑆀䁴񤧣．Ⴕ𝟜\u200C\u0348", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb324h32o", .status = 12} /* 6236 */,
    {.source = (const lxb_char_t *) "𑆀䁴񤧣.Ⴕ4\u200C\u0348", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb324h32o", .status = 12} /* 6237 */,
    {.source = (const lxb_char_t *) "𑆀䁴񤧣.ⴕ4\u200C\u0348", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb502tlsl", .status = 12} /* 6238 */,
    {.source = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb5123a", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb5123a", .status = 8} /* 6239 */,
    {.source = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb502tlsl", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb502tlsl", .status = 12} /* 6240 */,
    {.source = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb324h", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb324h", .status = 8} /* 6241 */,
    {.source = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb324h32o", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb324h32o", .status = 12} /* 6242 */,
    {.source = (const lxb_char_t *) "𑆀䁴񤧣．ⴕ𝟜\u200C\u0348", .ascii = (const lxb_char_t *) "xn--1mnx647cg3x1b.xn--4-zfb502tlsl", .status = 12} /* 6243 */,
    {.source = (const lxb_char_t *) "憡?\u200CႴ.𐋮\u200D≠", .ascii = (const lxb_char_t *) "xn--?-c1g798iy27d.xn--1ug73gl146a", .status = 12} /* 6244 */,
    {.source = (const lxb_char_t *) "憡?\u200CႴ.𐋮\u200D=\u0338", .ascii = (const lxb_char_t *) "xn--?-c1g798iy27d.xn--1ug73gl146a", .status = 12} /* 6245 */,
    {.source = (const lxb_char_t *) "憡?\u200Cⴔ.𐋮\u200D=\u0338", .ascii = (const lxb_char_t *) "xn--?-sgn310doh5c.xn--1ug73gl146a", .status = 12} /* 6246 */,
    {.source = (const lxb_char_t *) "憡?\u200Cⴔ.𐋮\u200D≠", .ascii = (const lxb_char_t *) "xn--?-sgn310doh5c.xn--1ug73gl146a", .status = 12} /* 6247 */,
    {.source = (const lxb_char_t *) "xn--?-fwsr13r.xn--1chz659f", .ascii = (const lxb_char_t *) "xn--?-fwsr13r.xn--1chz659f", .status = 4} /* 6248 */,
    {.source = (const lxb_char_t *) "xn--?-sgn310doh5c.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-sgn310doh5c.xn--1ug73gl146a", .status = 12} /* 6249 */,
    {.source = (const lxb_char_t *) "xn--?-c1g3623d.xn--1chz659f", .ascii = (const lxb_char_t *) "xn--?-c1g3623d.xn--1chz659f", .status = 4} /* 6250 */,
    {.source = (const lxb_char_t *) "xn--?-c1g798iy27d.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-c1g798iy27d.xn--1ug73gl146a", .status = 12} /* 6251 */,
    {.source = (const lxb_char_t *) "憡?ⴔ.xn--1chz659f", .ascii = (const lxb_char_t *) "xn--?-fwsr13r.xn--1chz659f", .status = 4} /* 6252 */,
    {.source = (const lxb_char_t *) "憡?Ⴔ.XN--1CHZ659F", .ascii = (const lxb_char_t *) "xn--?-c1g3623d.xn--1chz659f", .status = 4} /* 6253 */,
    {.source = (const lxb_char_t *) "憡?Ⴔ.xn--1chz659f", .ascii = (const lxb_char_t *) "xn--?-c1g3623d.xn--1chz659f", .status = 4} /* 6254 */,
    {.source = (const lxb_char_t *) "憡?\u200Cⴔ.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-sgn310doh5c.xn--1ug73gl146a", .status = 12} /* 6255 */,
    {.source = (const lxb_char_t *) "憡?\u200CႴ.XN--1UG73GL146A", .ascii = (const lxb_char_t *) "xn--?-c1g798iy27d.xn--1ug73gl146a", .status = 12} /* 6256 */,
    {.source = (const lxb_char_t *) "憡?\u200CႴ.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-c1g798iy27d.xn--1ug73gl146a", .status = 12} /* 6257 */,
    {.source = (const lxb_char_t *) "xn--?-c1g3623d.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-c1g3623d.xn--1ug73gl146a", .status = 8} /* 6258 */,
    {.source = (const lxb_char_t *) "xn--?-fwsr13r.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-fwsr13r.xn--1ug73gl146a", .status = 8} /* 6259 */,
    {.source = (const lxb_char_t *) "憡?Ⴔ.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-c1g3623d.xn--1ug73gl146a", .status = 8} /* 6260 */,
    {.source = (const lxb_char_t *) "憡?ⴔ.xn--1ug73gl146a", .ascii = (const lxb_char_t *) "xn--?-fwsr13r.xn--1ug73gl146a", .status = 8} /* 6261 */,
    {.source = (const lxb_char_t *) "憡?Ⴔ.XN--1UG73GL146A", .ascii = (const lxb_char_t *) "xn--?-c1g3623d.xn--1ug73gl146a", .status = 8} /* 6262 */,
    {.source = NULL, .ascii = NULL, .status = 0}
};


#ifdef __cplusplus
} /* extern "C" */
#endif

#endif /* LEXBOR_UNICODE_IDNA_TEST_RES_H */

