import ctypes
import ctypes.util
import os
import sys

# Search in LD_LIBRARY_PATH (unix), DYLD_LIBRARY_PATH (osx) or 
# other standard places. Also appends prefix and suffix according to system
# https://docs.python.org/3/library/ctypes.html#finding-shared-libraries
lib_file = ctypes.util.find_library('lenstool')

_lib = ctypes.CDLL(lib_file)
_lib.init_grille.argtypes = [ctypes.c_char_p, ctypes.c_int]
_lib.init_grille.restype = ctypes.c_int

_lib.init_cosmoratio.argtypes = None
_lib.init_cosmoratio.restype = None

_lib.checkpar.argtypes = None
_lib.checkpar.restype = None

_lib.grid.argtypes = None
_lib.grid.restype = None

_lib.readConstraints.argtypes = []
_lib.readConstraints.restype = None

_lib.getNParameters.argtypes = []
_lib.getNParameters.restype = ctypes.c_int

square_double_t = ctypes.POINTER(ctypes.POINTER(ctypes.c_double))
_lib.free_square_double.argtypes = [square_double_t, ctypes.c_int]
_lib.free_square_double.restype = None

_lib.readBayesModels.argtypes = [ctypes.POINTER(ctypes.c_int), ctypes.POINTER(ctypes.c_long)]
_lib.readBayesModels.restype = square_double_t

_lib.setBayesModel.argtypes = [ctypes.c_long, ctypes.c_long, square_double_t]
_lib.setBayesModel.restypes = None

_lib.o_chires.argtypes = [ctypes.c_char_p]
_lib.o_chires.restype = None

_lib.o_chi_lhood0.argtypes = [ctypes.POINTER(ctypes.c_double), ctypes.POINTER(ctypes.c_double), ctypes.POINTER(ctypes.c_double)]
_lib.o_chi_lhood0.restype = ctypes.c_int

_lib.rescaleCube_1Atom.argtypes = [ctypes.POINTER(ctypes.c_double), ctypes.c_int]
_lib.rescaleCube_1Atom.restype = ctypes.c_int

_lib.bayesHeader.argtypes = None
_lib.bayesHeader.restype = ctypes.c_int

_lib.write_bayes_line.argtype = [ctypes.c_void_p, ctypes.c_double, ctypes.c_double, ctypes.c_long, ctypes.c_void_p]
_lib.write_bayes_line.restype = None

_lib.open_mcmc_files.argtype = [ctypes.c_double, ctypes.c_char_p]
_lib.open_mcmc_files.restype = ctypes.c_void_p

_lib.close_mcmc_files.argtype = [ctypes.c_void_p, ctypes.c_void_p]
_lib.close_mcmc_files.restype = None

_lib.userCommon_init.argstype = [ctypes.c_int]
_lib.userCommon_init.restype = ctypes.c_void_p

_lib.userCommon_free.argstype = [ctypes.c_void_p]
_lib.userCommon_free.restype = None

from .lenstool import Lenstool
