/**
 * Copyright (c) OpenLens Authors. All rights reserved.
 * Licensed under MIT License. See LICENSE in root directory for more information.
 */
import { getInjectable } from "@ogre-tools/injectable";
import { reaction } from "mobx";
import { onLoadOfApplicationInjectionToken } from "../../../../main/start-main-application/runnable-tokens/on-load-of-application-injection-token";
import operatingSystemThemeInjectable from "../../../../main/theme/operating-system-theme.injectable";
import emitSystemThemeTypeUpdateInjectable from "./emit-update.injectable";

const setupSystemThemeTypeUpdaterEmitterInjectable = getInjectable({
  id: "setup-system-theme-type-updater-emitter",
  instantiate: (di) => {
    const operatingSystemTheme = di.inject(operatingSystemThemeInjectable);
    const emitSystemThemeTypeUpdate = di.inject(emitSystemThemeTypeUpdateInjectable);

    return {
      id: "setup-system-theme-type-updater-emitter",
      run: () => {
        reaction(
          () => operatingSystemTheme.get(),
          emitSystemThemeTypeUpdate,
          {
            fireImmediately: true,
          },
        );
      },
    };
  },
  injectionToken: onLoadOfApplicationInjectionToken,
});

export default setupSystemThemeTypeUpdaterEmitterInjectable;
