/**
 * Copyright (c) OpenLens Authors. All rights reserved.
 * Licensed under MIT License. See LICENSE in root directory for more information.
 */
import { getInjectable } from "@ogre-tools/injectable";
import { shouldShowResourceInjectionToken } from "../../../../../cluster-store/allowed-resources-injection-token";
import { frontEndRouteInjectionToken } from "../../../../front-end-route-injection-token";

const clusterRoleBindingsRouteInjectable = getInjectable({
  id: "cluster-role-bindings-route",

  instantiate: (di) => ({
    path: "/cluster-role-bindings",
    clusterFrame: true,
    isEnabled: di.inject(shouldShowResourceInjectionToken, {
      apiName: "clusterrolebindings",
      group: "rbac.authorization.k8s.io",
    }),
  }),

  injectionToken: frontEndRouteInjectionToken,
});

export default clusterRoleBindingsRouteInjectable;
