/**
 * Copyright (c) OpenLens Authors. All rights reserved.
 * Licensed under MIT License. See LICENSE in root directory for more information.
 */
import { getInjectable } from "@ogre-tools/injectable";
import applicationMenuItemInjectionToken from "../../application-menu-item-injection-token";
import { supportUrl } from "../../../../../../common/vars";
import openLinkInBrowserInjectable from "../../../../../../common/utils/open-link-in-browser.injectable";
import loggerInjectable from "../../../../../../common/logger.injectable";

const openSupportItemInjectable = getInjectable({
  id: "open-support-menu-item",

  instantiate: (di) => {
    const openLinkInBrowser = di.inject(openLinkInBrowserInjectable);
    const logger = di.inject(loggerInjectable);

    return {
      kind: "clickable-menu-item" as const,
      parentId: "help",
      id: "open-support",
      orderNumber: 30,
      label: "Support",

      // TODO: Convert to async/await
      onClick: () => {
        openLinkInBrowser(supportUrl).catch((error) => {
          logger.error("[MENU]: failed to open browser", { error });
        });
      },
    };
  },

  injectionToken: applicationMenuItemInjectionToken,
});

export default openSupportItemInjectable;
