
/*
 * Copyright (c) 2019
 * Copyright (C) 2023 raf <raf@raf.org>, Tavian Barnes <tavianator@tavianator.com>
 *
 * Permission to use, copy, modify, and distribute this software for any
 * purpose with or without fee is hereby granted, provided that the above
 * copyright notice and this permission notice appear in all copies.
 *
 * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
 * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
 * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
 * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
 * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 */

/* MP support header */
#include "MacportsLegacySupport.h"
#if __MP_LEGACY_SUPPORT_FDOPENDIR__

#include "common-priv.h"

#include <dirent.h>

/*
 * Implementation behavior largely follows these man page descriptions:
 *
 * https://www.freebsd.org/cgi/man.cgi?query=fdopendir&sektion=3
 * https://linux.die.net/man/3/fdopendir
 */

DIR *fdopendir(int dirfd) {

    /* Check dirfd here (for macos-10.4, see _ATCALL() and best_fchdir()) */

    if (dirfd < 0) {
        errno = EBADF;
        return 0;
    }

    /* Open given directory fd safely for iteration via readdir */

    DIR *dir = _ATCALL(dirfd, ".", NULL, opendir("."));
    if (!dir)
        return 0;

    /* Replace underlying fd with equivalent given fd (closed by closedir) */

    #if __ENVIRONMENT_MAC_OS_X_VERSION_MIN_REQUIRED__ == 1040
    (void)close(dir->dd_fd);
    dir->dd_fd = dirfd;
    #else
    (void)close(dir->__dd_fd);
    dir->__dd_fd = dirfd;
    #endif

    /* Rewind to the start of the directory (in case it's not there already) */

    rewinddir(dir);

    /* Close given fd on exec (just in case not already done) */

    (void)fcntl(dirfd, F_SETFD, FD_CLOEXEC);

    return dir;
}

#endif /* __MP_LEGACY_SUPPORT_FDOPENDIR__ */
