#ifndef LDASTOOLSAL__MEM_CHECKER_HH
#define LDASTOOLSAL__MEM_CHECKER_HH

#include <list>
#include <string>

namespace LDASTools
{
  namespace AL
  {
    //-------------------------------------------------------------------
    /// \brief Memory garbage collector
    ///
    /// This class keeps track of user defined cleanup routines to be
    /// called.
    ///
    /// \todo Put in code snippet
    //-------------------------------------------------------------------
    class MemChecker
    {
    public:
      //-----------------------------------------------------------------
      /// \brief Trigger garbage collection upon deletion.
      //-----------------------------------------------------------------
      class Trigger
      {
      public:
	//---------------------------------------------------------------
	/// \brief Default Constructor
	///
	/// \param[in] Final
	///     True if this trigger is to be considered the final
	///     cleanup trigger.
	//---------------------------------------------------------------
	Trigger( bool Final = false );

	//---------------------------------------------------------------
	/// \brief Destructor
	//---------------------------------------------------------------
	~Trigger( );

	//---------------------------------------------------------------
	/// \brief Force early garbage collection
	//---------------------------------------------------------------
	void DoGarbageCollection( ) const;

	//---------------------------------------------------------------
	/// \brief Determine if a trigger is registered for cleanup
	//---------------------------------------------------------------
	static bool IsRegistered( );

      private:
	static bool registered;

	bool final;
      };
      //-----------------------------------------------------------------
      /// \brief  Type specifier for exit functions.
      //-----------------------------------------------------------------
      typedef void (*CleanupFunction)();

      //-----------------------------------------------------------------
      /// \brief  Add a cleanup function to call.
      ///
      /// \param[in] Function
      ///     The function to be called
      ///
      /// \param[in] Name
      ///     A descriptive name of the action being taken
      ///
      /// \param[in] Ring
      ///     The level at which to call.
      ///     The ring structure is inverted in that rings of higher value
      ///     are called prior to rings of lesser values.
      //-------------------------------------------------------------------
      static void Append( CleanupFunction Function,
			  const std::string& Name,
			  int Ring,
			  bool Always = false );

      //-----------------------------------------------------------------
      /// \brief Query the exiting state of the system.
      //-----------------------------------------------------------------
      static bool IsExiting( );

      //-----------------------------------------------------------------
      /// \brief Debugger routine
      //-----------------------------------------------------------------
      static void Info( );

    private:
      friend class Trigger;
      //-----------------------------------------------------------------
      /// \brief Release all resources entrusted
      //-----------------------------------------------------------------
      static void cleanup( );

      //-----------------------------------------------------------------
      /// \brief Set the exit status for other to query.
      ///
      /// \param[in] Value
      ///     New value for exiting status.
      //-----------------------------------------------------------------
      static void is_exiting( bool Value );
    };

    inline bool MemChecker::Trigger::
    IsRegistered( )
    {
      return registered;
    }
  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__MEM_CHECKER_HH */
