/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef GENERIC_API__STAT_VFS_HH
#define GENERIC_API__STAT_VFS_HH

namespace GenericAPI
{
  //---------------------------------------------------------------------
  /// \brief Returns information about a mounted file system.
  ///
  /// \param[in] Filename
  ///     The pathname of any file within the mounted filesystem.
  /// \param[in,out] StatVFSBuffer
  ///     The reference to a statvfs structure.
  ///     If statvfs returns successfully, then information
  ///     about the mounted filesystem containing Filename
  ///     will be available in this structure.
  ///
  /// \return
  ///     Upon successful completion, the value zero is returned.
  ///     Upon failure, the value -1 is returned and errno
  ///     is set.
  //---------------------------------------------------------------------
  int StatVFS( const std::string& Filename,
	       struct statvfs& StatVFSBuffer );
}

#endif /* GENERIC_API__STAT_VFS_HH */
