#ifndef GENERIC_API__LSTAT_BASE_HH
#define GENERIC_API__LSTAT_BASE_HH

#include <sys/types.h>
#include <sys/stat.h>

namespace LDASTools
{
  namespace AL
  {
    class Directory;
  }
}

namespace GenericAPI
{
  class StatBase
  {
  public:
    enum debug_info {
      STAT_DEBUG_GENERAL
    };

    typedef struct stat stat_buf_type;
    typedef LDASTools::AL::Directory directory_type;

    virtual ~StatBase( );

    virtual std::string
    Debug( debug_info DebugInfo = STAT_DEBUG_GENERAL ) const = 0;

    virtual void Init( ) = 0;

    virtual int
    LStat( const std::string& FileName, stat_buf_type& Buf ) const = 0;

    virtual int
    LStat( const directory_type& Dir,
	   const std::string& RelFileName,
	   stat_buf_type& Buf ) const = 0;

    virtual int
    Stat( const std::string& FileName, stat_buf_type& Buf ) const = 0;

    virtual int
    Stat( const directory_type& Dir,
	  const std::string& RelFileName,
	  stat_buf_type& Buf ) const = 0;

    virtual StatBase* vnew( ) const = 0;
  };
}

#endif /* GENERIC_API__LSTAT_BASE_HH */

