#include "genericAPI/MonitorMemory.hh"

#include <sys/time.h>
#include <sys/resource.h>

namespace GenericAPI
{
  namespace Status
  {
    //-------------------------------------------------------------------
    //
    //-------------------------------------------------------------------
    MonitorMemory::
    MonitorMemory( flag_type Checks )
      : flag( Checks )
    {
    }

    void MonitorMemory::
    operator()( frequency_type Frequency )
    {
      struct rusage	usage;

      ::getrusage( RUSAGE_SELF, &usage );

      if ( flag | MEMORY_PHYSICAL )
      {
	//---------------------------------------------------------------
	// Track the amount of physical RAM being used by process
	//---------------------------------------------------------------
        AddDataPoint( Frequency, usage.ru_maxrss );
      }
    }
  }
}
