#include "ldastoolsal/ThreadPool.hh"

#include "genericAPI/Daemon.hh"

using LDASTools::AL::ThreadPool;

namespace GenericAPI
{
  Daemon::
  Daemon( )
    : thread( (thread_type*)NULL )
  {
  }

  Daemon::
  ~Daemon( )
  {
    Stop( );
  }
  void Daemon::
  Start( )
  {
    if ( thread == (thread_type*)NULL )
    {
      thread = ThreadPool::Acquire( );
      thread->AddTask( Task( ) );
    }
  }

  void Daemon::
  Stop( )
  {
    if ( thread )
    {
      thread_type*	t( thread );
      thread = (thread_type*)NULL;

      t->Halt( ); 
      ThreadPool::Relinquish( t );
   }
  }
}
