/* -*- mode: c++; c-basic-offset: 3 -*- */
#include <ldas_tools_config.h>

#include <algorithm>   
#include <sstream>   
#include <memory>   
   
// GenericAPI Header Files   
#include "genericAPI/swigexception.hh"
#include "ldastoolsal/gpstime.hh"

#include "framecpp/FrAdcData.hh"
#include "framecpp/FrProcData.hh"

// Local Header Files
#include "rdsreduce.hh"
#include "filereader.hh"   
#include "rdsutil.hh"   

using namespace std;
using namespace FrameCPP::Version;   
using LDASTools::AL::GPSTime;   

   
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ReduceRawFrame::
ReduceRawFrame( const char* frame_files, 
		const char* channels,
		const RDSFrame::Options& UserOptions )
   : RDSFrame( frame_files, channels, UserOptions )
{
}
   
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ReduceRawFrame::
ReduceRawFrame( const frame_file_container_type& frame_files, 
		const channel_container_type& channels,
		const RDSFrame::Options& UserOptions )
   : RDSFrame( frame_files, channels, UserOptions )
{
}
   
   
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
ReduceRawFrame::
~ReduceRawFrame()
{
}
   
//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ReduceRawFrame::
processChannel( fr_adc_data_type Adc )
{
   if ( Adc.get( ) && mResultFrame.get( ) && mResultFrame->GetRawData( ) )
   {
      QUEUE_LOG_MESSAGE( "Adding Channel: " << Adc->GetName( )
			 << " to frame: " << mResultFrame->GetName( )
			 << " containing: " << mResultFrame->GetRawData( )->RefFirstAdc( ).size( )
			 << " channel(s)",
			 MT_DEBUG, 30,
			 "ReduceRawFrame::processChannel",
			 "CreateRDS" );
      // Append adc to current frame
      mResultFrame->GetRawData( )->RefFirstAdc( ).append( Adc );
   }
}

//-----------------------------------------------------------------------------
//-----------------------------------------------------------------------------
void ReduceRawFrame::
processChannel( fr_proc_data_type Proc )
{
   if ( Proc.get( ) && mResultFrame.get( ) )
   {
      QUEUE_LOG_MESSAGE( "Adding Channel(FrProc): '" << Proc->GetName( ) << "'"
			 << " to frame: " << mResultFrame->GetName( )
			 << " containing: " << mResultFrame->RefProcData( ).size( )
			 << " channel(s)"
			 << " [contains: " << Proc->GetName( ) << " - "
			 << ( mResultFrame->RefProcData( ).find(  Proc->GetName( ) )
			      != mResultFrame->RefProcData( ).end( ) )<< "]"
			 ,
			 MT_DEBUG, 30,
			 "ReduceRawFrame::processChannel",
			 "CreateRDS" );
      // Append deep copy of existing channel
      mResultFrame->RefProcData( ).append( Proc );
   }
}

ReduceRawFrame::stop_request_type ReduceRawFrame::
stopRequest( ) const
{
   return STOP_USER;
}

