///=======================================================================
// WARNING: Do not use as an example of how to program against the API.
//          This file is strictly for low level testing.
//=======================================================================

#include <unistd.h>

// General Header Files   
#include "ldastoolsal/unittest.h"

//-----------------------------------------------------------------------
// To gain access to all of the functions that need to be tested,
// include the entire source.
//-----------------------------------------------------------------------
#define private public
#include "../src/Cache/SDGTx.cc"
#undef private

#include "genericAPI/LDASplatform.hh"
#include "genericAPI/Logging.hh"
#include "genericAPI/LogText.hh"

//-----------------------------------------------------------------------
//-----------------------------------------------------------------------
LDASTools::Testing::UnitTest	Test;

#include "tSDGTxSupport.icc"
#include "tSDGTxDirectoryInfo.icc"
#include "tSDGTxScanData.icc"
#include "tSDGTxDirectory.icc"
#include "tSDGTxFind.icc"

int
main( int ArgC, char** ArgV )
{
  //---------------------------------------------------------------------
  // Get ready for testing
  //---------------------------------------------------------------------
  Test.Init( ArgC, ArgV );

  GenericAPI::LoggingInfo::LogDirectory( "-" );
  GenericAPI::SetLogFormatter( new GenericAPI::Log::Text( "" ) );
  GenericAPI::LDASplatform::AppName( "test_createRDS_cpp" );
  if ( Test.Verbosity( ) > 0 )
  {
    GenericAPI::setLogDebugLevel( Test.Verbosity( ) );
  }
  
  //---------------------------------------------------------------------
  // Execute a series of tests
  //---------------------------------------------------------------------
  test_directory_info( );
  test_scan_data( );
  // test_directory( );
  test_find( );

  //---------------------------------------------------------------------
  // Cleanup and exit
  //---------------------------------------------------------------------
  Test.Exit();
   
  //---------------------------------------------------------------------
  // Should never get this far
  //---------------------------------------------------------------------
  return 1;
}
