/* -*- mode: c++; c-basic-offset: 2; -*- */

#ifndef LDASTOOLSAL__TASK_HH
#define LDASTOOLSAL__TASK_HH

#include "ldastoolsal/Memory.hh"
#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/Thread.hh"

namespace LDASTools
{
  namespace AL
  {
    //--------------------------------------------------------------------
    /// \brief A unit of work to be done usually within a thread.
    ///
    /// This is an abstract class that should be used as the base
    /// for a class that is to perform some task usually within
    /// a thread.
    //--------------------------------------------------------------------
    class Task {
    public:
      typedef Thread::cancel_type cancel_method;

      //-----------------------------------------------------------------
      /// \brief Data class for passing signal information
      //-----------------------------------------------------------------
      typedef Thread::signal_type signal_type;

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] CancelSignal
      ///     Signal to use for termination of the task
      //-----------------------------------------------------------------
      Task( cancel_method CancelMethod = Thread::CANCEL_ABANDON,
	    signal_type CancelSignal = SignalHandler::SIGNAL_UNKNOWN );

      //-----------------------------------------------------------------
      /// \brief Destructor
      //-----------------------------------------------------------------
      virtual ~Task( );

      //-----------------------------------------------------------------
      /// \brief Retrieve baton to gain exclusive access
      //-----------------------------------------------------------------
      MutexLock::baton_type Baton( ) const;

      //-----------------------------------------------------------------
      /// \brief Retrieve method to use for terminating the task.
      ///
      /// \return
      ///     The method to be used to terminate the task.
      //-----------------------------------------------------------------
      cancel_method CancelMethod( ) const;

      //-----------------------------------------------------------------
      /// \brief Retrieve signal to use for terminating the task.
      ///
      /// \return
      ///     The signal to be used to terminate the task.
      //-----------------------------------------------------------------
      signal_type CancelSignal( ) const;

      //-----------------------------------------------------------------
      /// \brief Retrieve state information concearning deletion.
      ///
      /// \return
      ///    True if the task should be deleted once terminated.
      //-----------------------------------------------------------------
      bool DeleteOnCompletion( ) const;

      //-----------------------------------------------------------------
      /// \brief Action to be done when task completes
      //-----------------------------------------------------------------
      virtual void OnCompletion( int TaskThreadState );

      //-----------------------------------------------------------------
      /// \brief Action to perform
      //-----------------------------------------------------------------
      virtual void operator()( ) = 0;

    protected:
      void delete_on_completion( bool Value );

    private:
      struct _p_type;

      std::unique_ptr< _p_type >	_p;
    };
  } // namespace - AL
} // namespace LDASTools

#endif /* LDASTOOLSAL__TASK_HH */
