#include <assert.h>

#include "ldastoolsal/ErrorLog.hh"
#include "ldastoolsal/gpstime.hh"

namespace LDASTools
{
  namespace AL
  {
    ErrorLog StdErrLog( std::cerr, false );
    ErrorLog JournalLog( std::cerr, true );

    bool ErrorLog::m_abort_on_assert_failure = false;

    ErrorLog::
    ErrorLog( std::ostream& Stream, bool OpenState )
      : m_stream( &Stream ),
	m_is_open( OpenState ),
	m_mask( 0 )
    {
      MaskBitSet( ASSERT_FAILURE );
      MaskBitSet( FATAL );
      MaskBitSet( WARNING );
    }

    ErrorLog::
    ~ErrorLog( )
    {
    }

    void ErrorLog::
    operator()( state State,
		const char* Filename, const int Line,
		const std::string& Message,
		bool EOL )
    {
      if ( IsOpen( ) &&
	   ( m_mask & ( 1<<State ) ) )
      {
	//-------------------------------------------------------------------
	// Ensure only one process writing to the stream at a time
	//-------------------------------------------------------------------
	MutexLock	lock( m_lock,
			      __FILE__, __LINE__ );

	(*m_stream) << GPSTime::now( )
		    << " " <<  Filename
		    << " " << Line
		    << " -- " << Message
	  ;
	if ( EOL )
	{
	  (*m_stream) << std::endl;
	}
	(*m_stream) << std::flush;
	if ( ( State == ASSERT_FAILURE )
	     && ( m_abort_on_assert_failure ) )
	{
	  assert( false );
	}
      }
    }
  } // namespace - AL
} // namespace - LDASTools
