#ifdef HAVE_CONFIG_H
#include <ldas_tools_config.h>
#endif /* HAVE_CONFIG_H */

//----------------------------------------------------------------------
#include <cstdlib>

#include <time.h>

#include "StatStream.cc"

using std::exit;

// Utility program for doing an lstat call

//=======================================================================
// This thread will watch to see if we become inherited by process 1
//=======================================================================
void*
parent_watch( void* /* Data */ )
{
  while( 1 )
  {
    if ( getppid( ) == 1 )
    {
      exit( 1 );
    }
    sleep( 5 );
  }
  return (NULL);
}

int
main( int /* ArgV */, char** /* ArgV */ )
{
  GenericAPI::StatStream	stream;
  pthread_t			pw_thread;

  pthread_create( &pw_thread, NULL, parent_watch, NULL );
  try
  {
    while( 1 )
    {
      //-----------------------------------------------------------------
      // Continuously process events on stdin and send results on stdout
      //-----------------------------------------------------------------
      stream.Process( 0, 1 );
    }
  }
  catch( ... )
  {
  }
  pthread_join( pw_thread, NULL );
  return( 0 );
}
