#ifndef FrameCPP_VERSION_8_FrTOC_HH
#define FrameCPP_VERSION_8_FrTOC_HH

#if ! defined(SWIGIMPORTED)
#include <map>
#include <vector>
#endif /* ! defined(SWIGIMPORTED) */

#if ! defined(SWIGIMPORTED)
#include "framecpp/Common/FrameSpec.hh"
#include "framecpp/Common/FrTOC.hh"

#include "framecpp/Version7/FrTOC.hh"
#endif /* ! defined(SWIGIMPORTED) */

#if ! defined(SWIGIMPORTED)
#include "framecpp/Version8/FrameSpec.hh"
#endif /* ! defined(SWIGIMPORTED) */
#include "framecpp/Version8/FrTOCData.hh"
#if ! defined(SWIGIMPORTED)
#include "framecpp/Version8/FrTOCStatData.hh"
#include "framecpp/Version8/FrTOCAdcData.hh"
#endif /* ! defined(SWIGIMPORTED) */
#include "framecpp/Version8/FrTOCProcData.hh"
#include "framecpp/Version8/FrTOCSimData.hh"
#if ! defined(SWIGIMPORTED)
#include "framecpp/Version8/FrTOCSerData.hh"
#include "framecpp/Version8/FrTOCSummary.hh"
#include "framecpp/Version8/FrTOCEvent.hh"
#include "framecpp/Version8/FrTOCSimEvent.hh"
#endif /* ! defined(SWIGIMPORTED) */

namespace FrameCPP
{
  namespace Version_8
  {

    //===================================================================
    /// \brief Table of Contents Data Structure Definition
    //===================================================================
    class FrTOC
#if ! defined(SWIG)
      : public ObjectWithChecksum< Common::FrTOC >,
        public FrTOCData,
	public FrTOCStatData,
	public FrTOCAdcData,
	public FrTOCProcData,
	public FrTOCSimData,
	public FrTOCSerData,
	public FrTOCSummary,
	public FrTOCEvent,
	public FrTOCSimEvent
#endif /* ! defined(SWIG) */
    {
    public:
      typedef INT_8U				position_type;
      typedef std::vector< position_type >	position_list_type;

#if ! defined(SWIG)
      class StatTypeKey {
      public:
	std::string	s_name;
	std::string	s_detector;

	StatTypeKey( const std::string& Name,
		     const std::string& Detector );
	bool operator<( const StatTypeKey& RHS ) const;
	bool operator==( const StatTypeKey& RHS ) const;
	bool operator!=( const StatTypeKey& RHS ) const;
      };
#endif /* ! defined(SWIG) */

#if ! defined(SWIG)
      struct StatType_type
      {
	std::vector< INT_4U >	tStart;
	std::vector< INT_4U >	tEnd;
	std::vector< INT_4U >	version;
	position_list_type	positionStat;
      };
#endif /* ! defined(SWIG) */


#if ! defined(SWIG)
      class StatTypeKeyHash
      {
      public:
	size_t operator()( const StatTypeKey& Key ) const
	{
	  LDASTools::AL::hash< const char* > h;

	  std::string key( Key.s_name );
	  key += Key.s_detector;
	  return h( key.c_str( ) );
	}
      };
#endif /* ! defined(SWIG) */


      typedef LDASTools::AL::unordered_map< StatTypeKey,
					    StatType_type,
					    StatTypeKeyHash >
      MapStatType_type;

      static const INT_4U	NO_DATA_AVAILABLE;

      //-----------------------------------------------------------------
      /// \brief Default constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrTOC( );

      //-----------------------------------------------------------------
      /// \brief Constructor
      ///
      /// \param[in] Source
      ///     
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      explicit FrTOC( const FrameCPP::Common::FrTOC* Source );

      //-----------------------------------------------------------------
      /// \brief Iterate over elements of the Table of Contents
      ///
      /// \param[in] Info
      ///     Type of objects upon which to iterate.
      /// \param[in,out] Action
      ///     Action to be performed.
      /// 
      //-----------------------------------------------------------------
      virtual void ForEach( query_info_type Info, FunctionBase& Action ) const;

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      static const char* StructName( );

      //-----------------------------------------------------------------
      /// \brief The description of structure
      ///
      /// \return
      ///     A Description object which describes this structure as
      ///     specified by the frame specification.
      //-----------------------------------------------------------------
      static const Common::Description* StructDescription( );

      //-----------------------------------------------------------------
      /// \brief Place information about an object into the TOC
      ///
      /// \param[in] Object
      ///     Object from which to extract information for the TOC.
      /// \param[in] Position
      ///     Stream position where object begins.
      //-----------------------------------------------------------------
      virtual void IndexObject( object_type Object,
				std::streampos Position );

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      virtual FrTOC* Create( ) const;

      //-----------------------------------------------------------------
      /// \brief Retieve FrStatData data
      ///
      /// \param[in] NamePattern
      ///     Regular expression describing the FrStatData name of
      ///     interest.
      /// \param[in] StartTime
      ///     The lower bound GPS time of the FrStatData start time.
      /// \param[in] EndTime
      ///     The upper bound GPS time of the FrStatData end time.
      /// \param[in] Version
      ///     The FrStatData version of interest.
      /// \param[out] Result
      ///     All FrStatData information that matched the query.
      //-----------------------------------------------------------------
      virtual void FrStatDataQuery( const std::string& NamePattern,
				    const LDASTools::AL::GPSTime& StartTime,
				    const LDASTools::AL::GPSTime& EndTime,
				    const INT_4U Version,
				    Common::FrStatData::Query& Result ) const;

      //-----------------------------------------------------------------
      /// \brief The name structure name of this object.
      ///
      /// \return
      ///     The name of the structure as specified by the frame
      ///     specification.
      //-----------------------------------------------------------------
      virtual const char* ObjectStructName( ) const;

      //-----------------------------------------------------------------
      /// \brief equality operator
      ///
      /// \param[in] RHS
      ///     The FrAdcData object to be compared.
      ///
      /// \return
      ///     The value true is returned if this object is equivelent
      ///     to the RHS instance; false otherwise.
      //-----------------------------------------------------------------
      virtual bool operator==( const Common::FrameSpec::Object& RHS ) const;

      const MapStatType_type&		GetStatType( ) const;

    protected:
      //-----------------------------------------------------------------
      /// \brief Demotes object to previous version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the frame specification to demote too.
      /// \param[in] Obj
      ///     The version of the object to demote.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object of the previous generation.
      //-----------------------------------------------------------------
      virtual demote_ret_type
      demote( INT_2U Target,
	      demote_arg_type Obj,
	      Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Promotes object to another version of the frame spec
      ///
      /// \param[in] Target
      ///     The version of the promoted frame specification.
      /// \param[in] Obj
      ///     The object to be promoted.
      /// \param[in] Stream
      ///     The input stream from which the original object was read.
      ///
      /// \return
      ///     An object promoted to the next generation.
      //-----------------------------------------------------------------
      virtual promote_ret_type
      promote( INT_2U Target,
	       promote_arg_type Obj,
	       Common::IStream* Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Number of bytes needed to write this structure
      ///
      /// \param[in] Stream
      ///     The stream from which to the object is being read or
      ///     written.
      ///
      /// \return
      ///     The number of bytes need to read or write this object.
      //-----------------------------------------------------------------
      virtual Common::FrameSpec::size_type
      pBytes( const Common::StreamBase& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Virtual constructor
      ///
      /// \param[in] Stream
      ///     The input stream from where the object is being read.
      //-----------------------------------------------------------------
      virtual FrTOC* pCreate( Common::IStream& Stream ) const;

      //-----------------------------------------------------------------
      /// \brief Write the structure to the stream
      ///
      /// \param[in] Stream
      ///     The output stream where the object is to be written.
      //-----------------------------------------------------------------
      virtual void pWrite( Common::OStream& Stream ) const;
 
    protected:
      virtual INT_4U nFrame( ) const;

      virtual const cmn_dt_container_type& dt( ) const;
      virtual const cmn_GTimeS_container_type& GTimeS( ) const;
      virtual const cmn_GTimeN_container_type& GTimeN( ) const;

      virtual cmn_position_type positionDetector( const std::string& Name ) const;

      virtual cmn_position_type positionH( INT_4U FrameIndex ) const;

      virtual const cmn_name_container_type& nameADC( ) const;

      virtual cmn_position_type positionADC( INT_4U FrameIndex,
					     const std::string& Channel ) const;
      virtual cmn_position_type positionADC( INT_4U FrameIndex,
					     INT_4U Channel ) const;

      virtual cmn_position_type positionEvent( INT_4U FrameIndex,
					       const std::string& Event ) const;

      virtual const cmn_name_container_type& nameProc( ) const;

      virtual cmn_position_type positionProc( INT_4U FrameIndex,
					      const std::string& Channel ) const;
      virtual cmn_position_type positionProc( INT_4U FrameIndex,
					      INT_4U Channel ) const;

      virtual const cmn_name_container_type& nameSer( ) const;

      virtual cmn_position_type positionSer( INT_4U FrameIndex,
					     const std::string& Channel ) const;

      virtual const cmn_name_container_type& nameSim( ) const;

      virtual cmn_position_type positionSim( INT_4U FrameIndex,
					     const std::string& Channel ) const;

      virtual cmn_position_type positionSimEvent( INT_4U FrameIndex,
						  const std::string& SimEvent ) const;

      //-----------------------------------------------------------------
      /// \brief Cache where the positions of the Adc channels
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      //-----------------------------------------------------------------
      virtual void cacheAdcDataPositions( istream_type& Stream );

      //-----------------------------------------------------------------
      /// \brief Advance to the specified Adc channel
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      /// \param[in] Channel
      ///     The requested channel
      //-----------------------------------------------------------------
      virtual void seekAdcDataPositions( istream_type& Stream,
					 Common::FrTOC::channel_id_type Channel );

      //-----------------------------------------------------------------
      /// \brief Advance to the specified Adc channel
      ///
      /// \param[in,out] Stream
      ///     The Stream being read
      /// \param[in] Channel
      ///     The requested channel
      //-----------------------------------------------------------------
      virtual void seekAdcDataPositions( istream_type& Stream,
					 const std::string& Channel );

      virtual INT_4U nSH( ) const;
      virtual INT_2U SHid( INT_4U Offset ) const;
      virtual const std::string& SHname( INT_4U Offset ) const;

    private:
      //-----------------------------------------------------------------
      /// \brief Object with checksum data.
      //-----------------------------------------------------------------
      typedef ObjectWithChecksum< Common::FrTOC > toc_base_type;

      using Common::FrameSpec::Object::Create;

      MapStatType_type		m_StatType;

      //-----------------------------------------------------------------
      /// \brief Stream Constructor
      ///
      /// \param[in] Stream
      ///     The stream from which the object is being read.
      ///
      /// \return
      ///    A new instance of this object.
      //-----------------------------------------------------------------
      FrTOC( Common::IStream& Stream );

      template< typename ChannelType >
      cmn_position_type position_adc( INT_4U FrameIndex, ChannelType Channel ) const;

      template< typename ChannelType >
      cmn_position_type position_proc( INT_4U FrameIndex, ChannelType Channel ) const;

      const FrTOC& operator=( const FrTOC& Source );
      const FrTOC& operator=( const Previous::FrTOC& Source );

   };

    inline FrTOC::StatTypeKey::
    StatTypeKey( const std::string& Name,
		 const std::string& Detector )
      : s_name( Name ),
	s_detector( Detector )
    {
    }

    inline bool FrTOC::StatTypeKey::
    operator<( const StatTypeKey& RHS ) const
    {
      if ( s_name.compare( RHS.s_name ) == 0 )
      {
	return s_detector < RHS.s_detector;
      }
      return s_name < RHS.s_name;
    }

    inline bool FrTOC::StatTypeKey::
    operator==( const StatTypeKey& RHS ) const
    {
      return ( ( s_name == RHS.s_name )
	       && ( s_detector == RHS.s_detector ) );
    }

    inline bool FrTOC::StatTypeKey::
    operator!=( const StatTypeKey& RHS ) const
    {
      return ( ! ( *this == RHS ) );
    }

    inline const char* FrTOC::
    StructName( )
    {
      static const CHAR* class_name( "FrTOC" );
      return class_name;
    }

    inline const FrTOC::MapStatType_type& FrTOC::
    GetStatType( ) const
    {
      return m_StatType;
    }

  } // namespace - Version_8
} // namespace - FrameCPP

#endif /* FrameCPP_VERSION_8_FrTOC_HH */
