/* -*- mode: c++; c-basic-offset: 4; -*- */
/* $Id: toss.cc,v 1.9 2008/01/12 01:22:25 emaros Exp $ */

#include <ldas_tools_config.h>

#include <sstream>
#include <stdexcept>

#include "toss.hh"
#include "unimplemented_error.hh"

namespace {
  static const char GeneralTossCC_rcsID[] =
  "@(#) $Id: toss.cc,v 1.9 2008/01/12 01:22:25 emaros Exp $:";
}

namespace LDASTools
{
    namespace Error
    {

	//-------------------------------------------------------------------
	/// This function simplifies the addition of key debugging information
	/// when throwing an exception.
	/// The availability of the information to the developer greatly
	/// increases the developer's ability to trouble shoot problems.
	//-------------------------------------------------------------------
	template <class T>
	void toss( const std::string& ClassName,
		   const std::string& Filename, 
		   int                LineNumber, 
		   const std::string& Description )
	{
	    std::ostringstream oss;
	    oss << ClassName << "(" << Filename << ":" << LineNumber << "): "
		<< Description;
	    std::string what = oss.str();
	    throw T(what);
	}
    
	/// \cond IGNORE

#define INSTANTIATE(EXCEPT_TYPE)					\
	template void toss<EXCEPT_TYPE> ( const std::string& cl,	\
					  const std::string& fl,	\
					  int ln,			\
					  const std::string& de )

	INSTANTIATE(std::logic_error);
	INSTANTIATE(std::domain_error);
	INSTANTIATE(std::invalid_argument);
	INSTANTIATE(std::length_error);
	INSTANTIATE(std::out_of_range);
	INSTANTIATE(std::runtime_error);
	INSTANTIATE(std::range_error);
	INSTANTIATE(std::overflow_error);
	INSTANTIATE(std::underflow_error);
	INSTANTIATE(unimplemented_error);

#undef INSTANTIATE

	/// \endcond

    } // namespace - Error
} // namespace - LDASTools
