#ifndef LDASTOOLSAL__BACKGROUND_TASK_COUNTER_HH
#define LDASTOOLSAL__BACKGROUND_TASK_COUNTER_HH

#include "ldastoolsal/types.hh"
#include "ldastoolsal/mutexlock.hh"
#include "ldastoolsal/ConditionalVariable.hh"

namespace LDASTools
{
  namespace AL
  {
    class BackgroundTaskCounter
    {
    public:
      BackgroundTaskCounter( );

      INT_4U Active( );

      void CriticalSection( bool Value );

      void Decrement( );

      void DecrementOnly( );

      void Increment( );

      void Wait( );

    private:
      LDASTools::AL::ConditionalVariable	m_sync;
      MutexLock::baton_type			m_baton;
      INT_4U				m_count;
    };

    inline BackgroundTaskCounter::
    BackgroundTaskCounter( )
      : m_count( 0 )
    {
    }

    inline INT_4U BackgroundTaskCounter::
    Active( )
    {
      MutexLock  l( m_baton,
		    __FILE__, __LINE__ );

      return m_count;
    }

    inline void BackgroundTaskCounter::
    CriticalSection( bool Value )
    {
      if ( Value )
      {
	m_sync.Mutex( ).Lock( __FILE__, __LINE__ );
      }
      else
      {
	m_sync.Mutex( ).Unlock( __FILE__, __LINE__ );
      }
    }

    inline void BackgroundTaskCounter::
    Decrement( )
    {
      CriticalSection( true );
      DecrementOnly( );
      m_sync.Broadcast( );
      CriticalSection( false );
    }

    inline void BackgroundTaskCounter::
    DecrementOnly( )
    {
      MutexLock  l( m_baton,
		    __FILE__, __LINE__ );
    
      if ( m_count )
      {
	--m_count;
      }
    }

    inline void BackgroundTaskCounter::
    Increment( )
    {
      MutexLock  l( m_baton,
		    __FILE__, __LINE__ );
	 
      ++m_count;
    }

    inline void BackgroundTaskCounter::
    Wait( )
    {
      m_sync.Wait( );
    }

  } // namespace - AL
} // namespace - LDASTools

#endif /* LDASTOOLSAL__BACKGROUND_TASK_COUNTER_HH */
