#include "genericAPI/Status.hh"

SINGLETON_INSTANCE_DEFINITION( LDASTools::AL::SingletonHolder< GenericAPI::Status::Recorder > )

namespace GenericAPI
{
  namespace Status
  {
    //-------------------------------------------------------------------
    // Recorder
    //-------------------------------------------------------------------
    Recorder::
    Recorder( )
      : freq_min( 0 )
    {
    }

    void Recorder::
    Add( LDASTools::AL::SharedPtr< MonitorInterface > M )
    {
      Instance( ).add( M );
    }
    

    void Recorder::
    add( monitor_type M )
    {
      std::list< frequency_type >	frequencies = M->Frequencies( );

      for ( std::list< frequency_type >::const_iterator
	      cur_freq = frequencies.begin( ),
	      last_freq = frequencies.end( );
	    cur_freq != last_freq;
	    ++cur_freq )
      {
	frequency_actions[ *cur_freq ].insert( M );
      }
    }

  }
}
