#ifndef GENERIC_API__LDAS_PLATFORM_HH
#define GENERIC_API__LDAS_PLATFORM_HH

#include "ldastoolsal/Singleton.hh"

namespace GenericAPI
{
  class LDASplatform
    : public LDASTools::AL::Singleton< LDASplatform >
  {
  public:
    LDASplatform( );

    static std::string AppName( );
    static void AppName( const std::string& Value );
    static std::string HTTP_URL( );
    static std::string LDASSystem( );
    static std::string RunCode( );

  private:
    std::string	app_name_;
    std::string http_url_;
    std::string ldas_system_;
    std::string run_code_;

    std::string app_name( );
    void app_name( const std::string& Value );
    std::string http_url( );
    std::string ldas_system( );
    std::string run_code( );

  };

  inline std::string LDASplatform::
  app_name( )
  {
    return app_name_;
  }

  inline void LDASplatform::
  app_name( const std::string& Value )
  {
    app_name_ = Value;
  }

  inline std::string LDASplatform::
  http_url( )
  {
    return http_url_;
  }

  inline std::string LDASplatform::
  ldas_system( )
  {
    return ldas_system_;
  }

  inline std::string LDASplatform::
  run_code( )
  {
    return run_code_;
  }
}

#endif /* GENERIC_API__LDAS_PLATFORM_HH */
