#include "genericAPI/LDASplatform.hh"

SINGLETON_INSTANCE_DEFINITION( LDASTools::AL::SingletonHolder< GenericAPI::LDASplatform > )

namespace GenericAPI
{
  LDASplatform::
  LDASplatform( )
    : http_url_( "" ),
      ldas_system_( "StandAlone" ),
      run_code_( "StandAlone" )
  {
  }

  std::string LDASplatform::
  AppName( )
  {
    return Instance( ).app_name( );
  }

  void LDASplatform::
  AppName( const std::string& Value )
  {
    Instance( ).app_name( Value );
  }

  std::string LDASplatform::
  HTTP_URL( )
  {
    return Instance( ).http_url( );
  }

  std::string LDASplatform::
  LDASSystem( )
  {
    return Instance( ).ldas_system( );
  }

  std::string LDASplatform::
  RunCode( )
  {
    return Instance( ).run_code( );
  }
}
