#include <ldas_tools_config.h>

#include <memory>

#include "framecpp/Common/IOStream.hh"

#include "framecpp/Version3/FrameSpec.hh"

#include "framecpp/Version3/FrSE.hh"

using FrameCPP::Common::FrameSpec;

using FrameCPP::Common::Description;

static const Description* s_description = (Description*)NULL;

namespace FrameCPP
{
  namespace Version_3
  {

    FrSE::
    FrSE( )
      : FrameSpec::Object( s_object_id, s_description )
    {
      m_data.name = "";
      m_data.classId = "";
      m_data.comment = "";
    }

    FrSE::
    FrSE( const std::string& Name,
	  const std::string& ClassId,
	  const std::string& Comment )
      : FrameSpec::Object( s_object_id, s_description )
    {
      m_data.name = Name;
      m_data.classId = ClassId;
      m_data.comment = Comment;
    }

    FrSE::
    FrSE( istream_type& Stream )
      : FrameSpec::Object( s_object_id, s_description )
    {
      Stream >> m_data.name
	     >> m_data.classId
	     >> m_data.comment
	;
    }

    FrSE::
    ~FrSE( )
    {
    }

    const char* FrSE::
    ObjectStructName( ) const
    {
      return StructName( );
    }

    std::string FrSE::
    GetName( ) const
    {
      return m_data.name;
    }


    INT_8U FrSE::
    Bytes( const Common::StreamBase& Stream ) const
    {
      return
	m_data.name.Bytes( ) +
	m_data.classId.Bytes( ) +
	m_data.comment.Bytes( );
    }

    FrSE* FrSE::
    Create( istream_type& Stream ) const
    {
      return new FrSE( Stream );
    }

    FrSE* FrSE::
    Clone( ) const
    {
      return new FrSE( *this );
    }

    void FrSE::
    Write( ostream_type& Stream ) const
    {
      Stream << m_data.name
	     << m_data.classId
	     << m_data.comment;
    }

    bool FrSE::
    operator==( const FrSE& RHS ) const
    {
      return ( ( m_data.name == RHS.m_data.name )
	       && ( m_data.classId == RHS.m_data.classId )
	       && ( m_data.comment == RHS.m_data.comment ) );
    }

    bool FrSE::
    operator==( const Common::FrameSpec::Object& Obj ) const
    {
      return ( *this == Obj );
    }

    FrSE::demote_ret_type FrSE::
    demote( INT_2U Target,
	    demote_arg_type Obj,
	    istream_type* Stream ) const
    {
      throw
	Unimplemented( "Object* FrSE::Demote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }

    FrSE::promote_ret_type FrSE::
    promote( INT_2U Target,
	     promote_arg_type Obj,
	     istream_type* Stream ) const
    {
      throw
	Unimplemented( "Object* FrSE::Promote( Object* Obj ) const",
		       DATA_FORMAT_VERSION, __FILE__, __LINE__ );
    }
  } // namespace - Version_3
} // namespace - FrameCPP
