#ifndef FRAME_CPP_INTERFACE__OFrameStream_HH
#define FRAME_CPP_INTERFACE__OFrameStream_HH

#if ! defined(SWIGIMPORTED)
#include "framecpp/FrameCPP.hh"

#include "framecpp/Common/IOStream.hh"
#include "framecpp/Common/FrameBuffer.hh"
#include "framecpp/Common/FrameStream.hh"
#include "framecpp/FrameH.hh"
#include "framecpp/FrTOC.hh"
#endif /* ! defined(SWIGIMPORTED) */

namespace FrameCPP
{
  typedef Common::OFrameStream OFrameStream;

  class OFrameFStream
  {
  public:
    typedef OFrameStream stream_type;
    typedef LDASTools::AL::SharedPtr< FrameH >	frameh_type;

    OFrameFStream( const char* Filename );
    const FrTOC& GetTOC( ) const;
    stream_type* Stream( );
    void WriteFrame( frameh_type Frame,
		     INT_2U CompressionScheme,
		     INT_2U CompressionLevel );

  private:
    typedef LDASTools::AL::filebuf			filebuf_type;
    typedef Common::FrameBuffer< filebuf_type >		frame_buffer_type;
    typedef std::unique_ptr< frame_buffer_type >	frame_buffer_ptr_type;
    typedef std::unique_ptr< OFrameStream >		stream_ptr_type;
    typedef LDASTools::AL::AutoArray< CHAR >		buffer_ptr_type;

    static const int			BUFFER_SIZE = 1024 * 1024;
    static const bool			MEMORY_MAPPED_IO = false;

    buffer_ptr_type		m_buffer;
    frame_buffer_ptr_type	m_frame_buffer;
    stream_ptr_type		m_frame_stream;
  };

  inline OFrameFStream::
  OFrameFStream( const char* Filename )
  {
    m_buffer.reset( new CHAR[ BUFFER_SIZE ] );

    m_frame_buffer.reset( new frame_buffer_type( std::ios::out ) );
    m_frame_buffer->pubsetbuf( m_buffer.get( ), BUFFER_SIZE );
    m_frame_buffer->UseMemoryMappedIO( MEMORY_MAPPED_IO );
    m_frame_buffer->open( Filename,
			  std::ios::out | std::ios::binary );

    m_frame_stream.reset( new OFrameStream( m_frame_buffer.release( ) ) );
  }

  inline OFrameFStream::stream_type* OFrameFStream::
  Stream( )
  {
    return m_frame_stream.get( );
  }

  inline void OFrameFStream::
  WriteFrame( frameh_type Frame,
	      INT_2U CompressionScheme,
	      INT_2U CompressionLevel )
  {
    m_frame_stream->WriteFrame( Frame, CompressionScheme, CompressionLevel );
  }
}

#endif /* FRAME_CPP_INTERFACE__OFrameStream_HH */
