/* -*- mode: c++ -*- */
%module frameCPP

%{
#include "framecpp/GPSTime.hh"

%}

class GPSTime
{
public:
  GPSTime( );

  GPSTime( const INT_4U Seconds, const INT_4U Nanoseconds );

  void Now( );

  INT_4U GetSeconds( ) const;

  INT_4U GetNanoseconds( ) const;

  LDAS_PROPERTY_READ_ONLY("seconds",GetSeconds)
  LDAS_PROPERTY_READ_ONLY("nanoseconds",GetNanoseconds)

};

//-----------------------------------------------------------------------
// const GPSTime&
//-----------------------------------------------------------------------
#if defined(SWIGPYTHON)
%typemap(out) const GPSTime& {
  $result = Py_BuildValue( "ii",
			   $1->GetSeconds( ),
			   $1->GetNanoseconds( ) );
}
#else
#error No "out" typemap for 'const GPSTime&'
#endif
