#include <sstream>

#include "ldas/ldasconfig.hh"

#include "framecpp/FrameCPP.hh"

#if FRAME_SPEC_CURRENT == 3
#include "framecpp/Version3/FrameSpec.hh"
#elif FRAME_SPEC_CURRENT == 4
#include "framecpp/Version4/FrameSpec.hh"
#elif FRAME_SPEC_CURRENT == 6
#include "framecpp/Version6/FrameSpec.hh"
#elif FRAME_SPEC_CURRENT == 7
#include "framecpp/Version7/FrameSpec.hh"
#elif FRAME_SPEC_CURRENT == 8
#include "framecpp/Version8/FrameSpec.hh"
#else
#error "Unsupported frame spec: FRAME_SPEC_CURRENT"
#endif

namespace FrameCPP
{
  namespace Version_3
  {
    extern bool init_frame_spec( );
  }
  namespace Version_4
  {
    extern bool init_frame_spec( );
  }
  namespace Version_6
  {
    extern bool init_frame_spec( );
  }
  namespace Version_7
  {
    extern bool init_frame_spec( );
  }
  namespace Version_8
  {
    extern bool init_frame_spec( );
  }
}

//-----------------------------------------------------------------------------
// The time information that is returned by this function is based on when the
// top level configure.in ( ldas/configure.in) file was committed to CVS.
// The time value is in UTC time as that is what CVS uses internally.
//
//!return: std::string - The string representation of the cvs date
std::string FrameCPP::
GetCVSDate( )
{
  return LDAS_CVS_DATE;
}

//-----------------------------------------------------------------------------
//!return: std::string - The string representation of when the library was
//+ built
std::string FrameCPP::
GetBuildDate( )
{
  return LDAS_BUILD_DATE;
}

//!return: INT_2U - current minor version for the frame library
INT_2U FrameCPP::
GetFrameLibraryMinorVersion( )
{
  return FrameCPP::Version::LIBRARY_MINOR_VERSION;
}

void FrameCPP::
Initialize( )
{
  Version_3::init_frame_spec( );
  Version_4::init_frame_spec( );
  Version_6::init_frame_spec( );
  Version_7::init_frame_spec( );
  Version_8::init_frame_spec( );
}
