#include <ldas_tools_config.h>

#include <sstream>
#include <stdexcept>

#include "framecpp/Common/Description.hh"
#include "framecpp/Common/FrameStream.hh"
#include "framecpp/Common/FrSH.hh"

typedef LDASTools::AL::SharedPtr< FrameCPP::Common::FrSH > fr_sh_type;

namespace FrameCPP
{
  namespace Common
  {
    Description::
    ~Description( )
    {
    }

    const std::string& Description::
    GetName( ) const
    {
      static const std::string unknown( "UNKNOWN" );

      fr_sh_type
	frsh = LDASTools::AL::DynamicPointerCast< fr_sh_type::element_type >( m_desc.front( ) );
      if ( frsh )
      {
	return frsh->name( );
      }
      
      return unknown;
    }

    void Description::
    Write( OFrameStream& Stream ) const
    {
      for ( description_container::const_iterator
	      cur = m_desc.begin( ),
	      last = m_desc.end( );
	    cur != last;
	    ++cur )
      {
	if (*cur)
	{
	  Stream.Write( (*cur) );
	}
      }
    }

    void Description::
    operator( )( object_type Obj )
    {
      if ( ( m_desc.size( ) == 0 )
	   && ( Obj->GetClass( ) != FrameSpec::Info::FSI_FR_SH ) )
      {
	std::ostringstream	msg;

	msg << "Expected object of class FrSH instead of: "
	    << Obj->GetClass( )
	  ;
	throw( std::logic_error( msg.str( ) ) );
      } else if ( ( m_desc.size( ) > 0 )
		  && ( Obj->GetClass( ) != FrameSpec::Info::FSI_FR_SE ) )
      {
	std::ostringstream	msg;

	msg << "Expected object of class FrSE instead of: "
	    << Obj->GetClass( )
	  ;
	throw( std::logic_error( msg.str( ) ) );
      }

      m_desc.push_back( Obj );
    }

    void Description::
    operator( )( const object_type::element_type& Obj )
    {
      object_type	o( Obj.Clone( ) );

      this->operator( )( o );
    }
  } // namespace - Common
} // namespace - FrameCPP
