#include <ldas_tools_config.h>

#include "valarray_utils.hh"

namespace Filters
{
  template < class Type >
  std::valarray< Type >
  real(const std::valarray< Type >& Data )
  {
    return Data;
  }

  template < class Type >
  std::valarray< Type >
  real(const std::valarray< std::complex< Type > >& Data )
  {
    std::valarray< Type >	ret(Data.size());
    
    for (size_t i = 0; i < Data.size(); i++)
    {
      ret[i] = Data[i].real();
    }
    return ret;
  }

  template < class Type >
  std::valarray< Type >
  imag(const std::valarray< Type >& Data )
  {
    std::valarray< Type > ret(Type(0), Data.size());

    return ret;
  }

  template < class Type >
  std::valarray< Type >
  imag(const std::valarray< std::complex< Type > >& Data )
  {
    std::valarray< Type >	ret(Data.size());
    
    for (size_t i = 0; i < Data.size(); i++)
    {
      ret[i] = Data[i].imag();
    }
    return ret;
  }

  template<class T>
  std::valarray<T> abs(const std::valarray<std::complex<T> >& in)
  {
    std::valarray<T> ret(in.size());
    
    for (size_t k = 0; k < in.size(); ++k)
    {
        ret[k] = std::abs(in[k]);
    }

    return ret;
  }

  template<class T>
  std::valarray<T> arg(const std::valarray<std::complex<T> >& in)
  {
    std::valarray<T> ret(in.size());
    
    for (size_t k = 0; k < in.size(); ++k)
    {
        ret[k] = std::arg(in[k]);
    }

    return ret;
  }

  template < class Type >
  std::valarray< Type >
  conj(const std::valarray< Type >& Data )
  {
    return Data;
  }

  template < class Type >
  std::valarray< std::complex< Type > >
  conj(const std::valarray< std::complex< Type > >& Data )
  {
    //-------------------------------------------------------------------
    // Increase portability by introduction of temporary variable.
    //-------------------------------------------------------------------
    typename std::complex< Type > (*func)( const typename std::complex< Type >& )
      = std::conj;
    return Data.apply(func);
  }


  template std::valarray<float> real(const std::valarray<float>& Data);
  template std::valarray<double> real(const std::valarray<double>& Data);

  template std::valarray<float>
  real(const std::valarray< std::complex<float> >& Data);

  template std::valarray<double>
  real(const std::valarray< std::complex<double> >& Data);

  template std::valarray<float> imag(const std::valarray<float>& Data);
  template std::valarray<double> imag(const std::valarray<double>& Data);

  template std::valarray<float>
  imag(const std::valarray< std::complex<float> >& Data);

  template std::valarray<double>
  imag(const std::valarray< std::complex<double> >& Data);

  template std::valarray<float>
  abs(const std::valarray< std::complex<float> >& Data);

  template std::valarray<double>
  abs(const std::valarray< std::complex<double> >& Data);

  template std::valarray<float>
  arg(const std::valarray< std::complex<float> >& Data);

  template std::valarray<double>
  arg(const std::valarray< std::complex<double> >& Data);

  template std::valarray<float> conj(const std::valarray<float>& Data);
  template std::valarray<double> conj(const std::valarray<double>& Data);

  template std::valarray<std::complex<float> >
  conj(const std::valarray< std::complex<float> >& Data);

  template std::valarray<std::complex<double> >
  conj(const std::valarray< std::complex<double> >& Data);

} // namespace Filters
